﻿
#include "custom/controllers/classes/CascadeTCA.es"
#include "custom/controllers/classes/CascadeSTK.es"
#include "custom/controllers/classes/CascadeUtilityFunctions.es"
#include "importTCA.es"
#include "importSTK.es"
#include "exportMass.es"
#include "MS_CALCDRUCKVERLUST.b"
#include "MS_CALCSTOFFDATEN.b"
#include "Base.update.b"


function readRights()
{
    var strSQLStatement = "select * from RIGHTS order by abs(SORT) ";
    var numRet  = dbselect("SYS", strSQLStatement, "RIGHTS");
    var strRight = "", strStatus = "", strCode = "";
    while (dbiseof("RIGHTS") == 0)
    {
        strRight  = dbgetstring("RIGHTS", "RIGHT");
        strStatus = dbgetstring("RIGHTS", "STATUS");
        strCode   = strCode + dbgetstring("RIGHTS", "CODE")+"-";
        setstring(strRight, "RIGHTS", strStatus);
        dbskip("RIGHTS");
    }
    strCode				= trimright(strCode, "-");
	var strCodeSplit	= strCode.split("-");
    setstring("VERSION_CODE","", strCode);
	
	
    if ((getstring("VERSION","RIGHTS") == "SALESVERSION") &&
        (getstring("SAP_ENABLED", "RIGHTS") == "1"))
    {
        // 02/2009: nicht mehr gebraucht setstring("INTERNE_VERSION","", "- SAP INTERNE VERSION -");
        setstring("SAP_VERSION","", getstring("SAPINFO","CATALOG.SAP"));
    }

    setstring("PREVENT_OUTPUT_EXPERT","RIGHTS", "true");
	if (getstring("EXPERT_MODE", "RIGHTS") == "1")
		setstring("PREVENT_OUTPUT_EXPERT","RIGHTS", "false");

    setstring("SALESVERSION","RIGHTS", "false");
    setstring("CLIENTVERSION","RIGHTS", "false");
    if (getstring("VERSION","RIGHTS") == "SALESVERSION")
        setstring("SALESVERSION","RIGHTS", "true");
    if (getstring("VERSION","RIGHTS") == "CLIENTVERSION")
        setstring("CLIENTVERSION","RIGHTS", "true");

    setstring("PREVENT_SAP_EINZEL_UEBERGABE","RIGHTS", "true");
    if ((getstring("EXPERT_MODE", "RIGHTS") == "1") &&
        (getstring("SAP_ENABLED", "RIGHTS") == "1"))
        setstring("PREVENT_SAP_EINZEL_UEBERGABE","RIGHTS", "false");

    setstring("SAP_GESAMT_UEBERGABE_ENABLED","RIGHTS", "false");
    setstring("PREVENT_SAP_GESAMT_UEBERGABE","RIGHTS", "true");
    if ((getstring("SAP_ENABLED", "RIGHTS") == "1") &&
        (getstring("VERSION","RIGHTS") == "SALESVERSION"))
    {
        setstring("PREVENT_SAP_GESAMT_UEBERGABE","RIGHTS", "false");
        setstring("SAP_GESAMT_UEBERGABE_ENABLED","RIGHTS", "true");
    }

    setstring("PRICES_VISIBLE","RIGHTS", "false");
    if (getstring("PRICES_ENABLED", "RIGHTS") == "1")
    {
        setstring("PCODE", "CATALOG.SETTINGS", "630927");
        setstring("PRICES_VISIBLE","RIGHTS", "true");
    }

    setstring("PREVENT_VIEW_REBATES","RIGHTS", "true");
    if (getstring("REBATES_VISIBLE", "RIGHTS") == "1")
        setstring("PREVENT_VIEW_REBATES","RIGHTS", "false");

    setstring("DISABLE_EDIT_REBATES","RIGHTS", "true");
    if (getstring("REBATES_EDITABLE", "RIGHTS") == "1")
        setstring("DISABLE_EDIT_REBATES","RIGHTS", "false");

    setstring("CALCULATION_ENABLED","RIGHTS", "true");
    setstring("CALCULATION_DISABLED","RIGHTS", "false");
    if (getstring("CALCULATION", "RIGHTS") != "1")
    {
        setstring("CALCULATION_ENABLED","RIGHTS", "false");
        setstring("CALCULATION_DISABLED","RIGHTS", "true");
    }

    setstring("PREVENT_OUTPUT_DRUCKVERLUST","RIGHTS", "true");
    /*
	if ( (getstring("PRICES_ENABLED", "RIGHTS") == "1") &&
		 (getstring("REBATES_EDITABLE", "RIGHTS") == "1") &&
		 (getstring("REBATES_VISIBLE", "RIGHTS") == "1"))
		setstring("PREVENT_OUTPUT_DRUCKVERLUST","RIGHTS", "false");
	*/
	if (getstring("VERSION","RIGHTS") == "SALESVERSION" &&
		(((getstring("REBATES_EDITABLE", "RIGHTS") == "1") && (getstring("REBATES_VISIBLE", "RIGHTS") == "1")) ||
		((getstring("REBATES_EDITABLE", "RIGHTS") == "0") && (getstring("REBATES_VISIBLE", "RIGHTS") == "0"))))
		setstring("PREVENT_OUTPUT_DRUCKVERLUST","RIGHTS", "false");
	
	setstring("PREVENT_ONLINEUPDATE","RIGHTS", "true");
	setstring("PREVENT_LOCALUPDATE","RIGHTS", "false");
	setstring("ONLINEUPDATE_MUST","RIGHTS", "false");
	if ( getstring("ONLINEUPDATE", "RIGHTS") == "1"){
		setstring("PREVENT_ONLINEUPDATE","RIGHTS", "false");
		setstring("PREVENT_LOCALUPDATE","RIGHTS", "true");
	}
	else if ( getstring("ONLINEUPDATE", "RIGHTS") == "Z"){
		setstring("PREVENT_ONLINEUPDATE","RIGHTS", "false");
		setstring("PREVENT_LOCALUPDATE","RIGHTS", "true");
		setstring("ONLINEUPDATE_MUST","RIGHTS", "true");
	}

    setstring("WEBVERSION","RIGHTS", "false");
	setstring("WEBVERSION_COMMENT", "", "");
	if (getstring("CATALOG.INTERNETSERVERINCDMODE","") == "false")  // Internet-Version
	{
        setstring("WEBVERSION","RIGHTS", "true");
		setstring("WEBVERSION_COMMENT", "", "//");
	}
	// setstring("IDC_ANZAHL_PLIST_ROWS_COMBO","MISCSTUFF", "20");
	setstring("IDC_ANZAHL_PLIST_ROWS_COMBO", "MISCSTUFF", "25");
	
	/*
	// das geht NICHT!!! -> wir wissen noch nicht wo wir sind!!!
	var strLocation		= (RTWExists ? "Werdau" : "Ufa");	// wg. Testzwecken wird WDA bevorzugt
	var strSQLStatement	= "select * from DATAPATH where LOCATION like '" + strLocation + "' order by abs(SEQ_ID) ";
	var numRet			= dbselect("CASCADE", strSQLStatement, "PATH");
	var InfoPath		= dbgetstring("PATH", "INFO_PATH") + "\\";
	*/
	var IsNotTestsystem		= (getint("IS_TESTSYSTEM", "CATALOG.TESTSYSTEM") ? "" : "not");
	var strSQLStatement		= "select * from DATAPATH where LOCATION " + IsNotTestsystem + " like 'TESTSYSTEM' order by abs(SEQ_ID) ";
	var numRet				= dbselect("CASCADE", strSQLStatement, "PATH");
	var INFO_DATA			= "";
	var INFO_DATA_OPTIONS	= [];
	var INFO_DATA_LOCATION	= [];
	
	while (dbiseof("PATH") == 0)
	{
		INFO_DATA	= dbgetstring("PATH", "INFO_PATH");
		
		// hier stehen zum Teil absolute aber auch Netzwerkpfade drin
		if (left(INFO_DATA, 1) == "\\")
		INFO_DATA	= "\\" + INFO_DATA;
		
		if ( INFO_DATA.indexOf( "$TMP$" ) > -1 )
			INFO_DATA = INFO_DATA.replace( "$TMP$", getstddirectory( "TEMP" ) );
		else if ( INFO_DATA.indexOf( "$TEMP$" ) > -1 )
			INFO_DATA = INFO_DATA.replace( "$TEMP$", getstddirectory( "TEMP" ) );
		
		if (INFO_DATA != ""){
			INFO_DATA_OPTIONS.push(INFO_DATA);
			INFO_DATA_LOCATION.push(dbgetstring("PATH", "LOCATION"));
		}
		dbskip("PATH");
	}
	
	setstring ("RTWUser", "", false);
	setstring ("RUSUser", "", false);
	setstring ("UserLocation", "", "");
	setstring ("PREVENT_OUTPUT_HLIST_SCHILD", "RIGHTS", true);
	
	// var IsHangerLocation	= "false";
	// WIN 11 - neue Sicherheitsrichtlinie bzgl. Zugriffen auf Server -> Fehlermeldungen daher keine Abfrage mehr möglich
	var IsHangerLocation	= (strCodeSplit[0] == "VS" ? "true" : "false");
	
	// manche Funktionen sind nur für WDA, Z bzw. Ufa relevant
	// wir prüfen ob wir in WDA, Z bzw. Ufa sind
	for (var i=0; i<INFO_DATA_OPTIONS.length; i++){
		// WIN 11 - siehe oben
		//if(FileName.fileExists(INFO_DATA_OPTIONS[i])){
			//IsHangerLocation	= readfile(INFO_DATA_OPTIONS[i]).split("-");
			//IsHangerLocation	= tolower(trimright(trimleft(IsHangerLocation[IsHangerLocation.length - 1], " "), " "));
			if (IsHangerLocation == "true" &&
				(INFO_DATA_LOCATION[i] == "Werdau" || INFO_DATA_LOCATION[i] == "Zwickau" || INFO_DATA_LOCATION[i] == "TESTSYSTEM")){
				setstring ("RTWUser", "", true);
				setstring ("PREVENT_OUTPUT_HLIST_SCHILD", "RIGHTS", false);
				setstring ("UserLocation", "", INFO_DATA_LOCATION[i]);
			}
			if (IsHangerLocation == "true" && (INFO_DATA_LOCATION[i] == "Ufa" || INFO_DATA_LOCATION[i] == "Ufa_WSZ")){
				setstring ("RUSUser", "", true);
				setstring ("PREVENT_OUTPUT_HLIST_SCHILD", "RIGHTS", false);
				if (getstring ("UserLocation", "") == "")
					setstring ("UserLocation", "", INFO_DATA_LOCATION[i]);
			}
		//}
	}
	/*
	var RTWExists	= readfile("\\\\global.witzenmann.com\\11002\\DATA\\transfer\\flexperte\\WDA_Data\\IsWDA.txt").split("-");
	RTWExists		= tolower(trimright(trimleft(RTWExists[RTWExists.length - 1], " "), " "));
	if (RTWExists == "" || RTWExists == "false"){
		RTWExists	= readfile("\\\\global.witzenmann.com\\11001\\DATA\\transfer\\flexperte\\WSZ_Data\\IsWSZ.txt").split("-");
		RTWExists	= tolower(trimright(trimleft(RTWExists[RTWExists.length - 1], " "), " "));
	}
	setstring ("RTWUser", "", (RTWExists == "true" ? true : false));
	if (RTWExists && getstring("CLIENTVERSION","RIGHTS") == "false")
		setstring ("PREVENT_OUTPUT_HLIST_SCHILD", "RIGHTS", false);
	else
		setstring ("PREVENT_OUTPUT_HLIST_SCHILD", "RIGHTS", true);
	
	// manche Funktionen sind nur für RUS relevant
	// wir prüfen ob wir in RUS sind
	// Originalpfad bei WI-RU
	var RUSExists	= readfile("\\\\WITZENMANN\\H&S_Rh\\Flex_region\\IsRUS.txt").split("-");
	RUSExists		= tolower(trimright(trimleft(RUSExists[RUSExists.length - 1], " "), " "));
	// Testpfad bei RTW
	if (RUSExists == "" || RUSExists == "false"){
		RUSExists	= readfile("\\\\global.witzenmann.com\\11001\\DATA\\transfer\\flexperte\\RUS_Data\\IsRUS.txt").split("-");
		RUSExists	= tolower(trimright(trimleft(RUSExists[RUSExists.length - 1], " "), " "));
	}
	setstring ("RUSUser", "", (RUSExists == "true" ? true : false));
	if (RUSExists == "true" && getstring("CLIENTVERSION","RIGHTS") == "false")
		setstring ("PREVENT_OUTPUT_HLIST_SCHILD", "RIGHTS", false);
	
	//else
	//	setstring ("PREVENT_OUTPUT_HLIST_SCHILD", "RIGHTS", true);
	*/
	
	// einige Felder sperren wenn Auswahl über Pull-Down-Menü erfolgte
	setstring ("DISABLE_VERTRIEBSFELD",	"RIGHTS", "false");
	setstring ("DISABLE_STRASSE_ORT",	"RIGHTS", "true");	// die sind in der DB nicht alle gefüllt
	setstring ("PREVENT_FIRMA_SELECT",	"RIGHTS", "true");
	
	// Funktion "Projektliste zusammenfassen" nur für WI und WS
	setstring("PREVENT_ZSF_POS","RIGHTS", "true");
	if (getstring("VERSION","RIGHTS") == "SALESVERSION" && getstring("REBATES_EDITABLE", "RIGHTS") == "1")
		setstring("PREVENT_ZSF_POS","RIGHTS", "false");
}

function setFromIni(storeVar, storePath, iniFilename, iniSection, iniVar, defaultVal)
{
	var strRet = readinistring(iniFilename, iniSection, iniVar);
	if (strRet == "")
		strRet = defaultVal;
	setstring(storeVar, storePath, strRet);
}

function setDefaultCascadeSettings()
{
    var strSettingspath = "PROJECT.SETTINGS.CASCADE";
	
	/*
	if (toupper(getstring("SALESVERSION", "RIGHTS")) == "TRUE")
		setstring("IDC_SSG_LISEGA_CHECK", strSettingspath, "false");
	else
		setstring("IDC_SSG_LISEGA_CHECK", strSettingspath, "true");
	//setstring("SSG_LI_PART", strSettingspath, "false");
	*/
	setstring("IDC_SSG_LISEGA_CHECK", strSettingspath, "false");
	
	setstring("OBFL_SCHEL1", strSettingspath, "OB_FEUER");
    setstring("OBFL_SCHEL2", strSettingspath, "OB_GALV");
    //setstring("OBFL_SCHEL3", strSettingspath, "OB_ROH");
	setstring("OBFL_SCHEL3", strSettingspath, "OB_GRUND");
    setstring("OBFL_SCHEL4", strSettingspath, "OB_ROH");
    setstring("OBFL_HAENGER", strSettingspath, "OB_FEUER");
    setstring("OBFL_STREBEN", strSettingspath, "OB_GRUND");
    setstring("OBFL_VERBTEILE", strSettingspath, "OB_GALV");
    setstring("OBFL_ZKX", strSettingspath, "OB_FEUER");
    setstring("OBFL_LASCHEN", strSettingspath, "OB_GRUND");
    setstring("OBFL_TRAVERSEN", strSettingspath, "OB_FEUER");
    setstring("GEWINDE_ANSCHLUSS", strSettingspath, "IDC_POS_GEWDIN_RADIOBUTTON");
    setstring("FH_BLOCKIERUNG", strSettingspath, "IDC_FH_BLOCKJA_RADIOBUTTON");
    setstring("KH_BLOCKIERUNG", strSettingspath, "IDC_KH_BLOCKJA_RADIOBUTTON");
    setstring("TERROSON_KH", strSettingspath, "false");
    setstring("TERROSON_FH", strSettingspath, "false");
    setstring("KENNZEICHNUNG_HAENG", strSettingspath, "true");
    setstring("KENNZEICHNUNG_GSTREBEN", strSettingspath, "true");
    setstring("KENNZEICHNUNG_ANDERE", strSettingspath, "false");
    setstring("KENNZEICHNUNG_POSITIONIERUNG", strSettingspath, "false");
    setstring("LASTWEG_PROT_FH", strSettingspath, "false");
    setstring("LASTWEG_PROT_KH", strSettingspath, "false");
    setstring("PRUEFBESCH_PROD_21", strSettingspath, "false");
    //setstring("PRUEFBESCH_PROD_22", strSettingspath, "false");
    setstring("PRUEFBESCH_PROD_22", strSettingspath, "true");
    setstring("PRUEFBESCH_FEDERN", strSettingspath, "false");
    setstring("PRUEFBESCH_WARMFEST", strSettingspath, "false");
    setstring("PRUEFBESCH_AUSTENIT", strSettingspath, "false");
    setstring("VERPACKUNG", strSettingspath, "IDC_RADIO_VERPACKUNG_PALETTEN");
    setstring("SOLLAST_IST", strSettingspath, "IDC_RADIO_SOLLAST_KALT");
    setstring("FH_PROZ_LASTAENDERUNG", strSettingspath, "25");
    setstring("FH_MINDESTWEGRESERVE_ABS", strSettingspath, "5");
    setstring("FH_MINDESTWEGRESERVE_PROZ", strSettingspath, "20");
    setstring("KH_LASTJUSTIERBARKEIT", strSettingspath,	"15");
    setstring("KH_MINDESTWEGRESERVE_ABS", strSettingspath, "10");
    setstring("KH_MINDESTWEGRESERVE_PROZ", strSettingspath, "10");
    setstring("GSTREBE_MINDESTVERSTELLRESERVE", strSettingspath, "");
    setstring("GRENZ_TEMP", strSettingspath, "IDC_RADIO_GRENZ_TEMP_VGB");
    setstring("GEWST_DEF_LEN", strSettingspath, "IDC_RADIO_GEWST_DEF_LEN_2000");
    setstring("GEWSTANGPASSMIN", strSettingspath, "");
    setstring("GEWSTANGPASSRUND", strSettingspath, "");
    setstring("SCHRAEGZUG", strSettingspath, "4");
    setstring("VORSPANNUNG", strSettingspath, "IDC_RADIO_VORSPANNUNG_OHNE");

    setstring("FH_BIS_11_RAB", strSettingspath,	 "0");
    setstring("FH_AB_12_RAB", strSettingspath,	 "0");
    setstring("KH_BIS_12_RAB", strSettingspath,	 "0");
    setstring("KH_AB_13_RAB", strSettingspath,	 "0");
    setstring("SCHELLE_RAB", strSettingspath,	 "0");
    setstring("LAGER_RAB", strSettingspath,	 "0");			// -mw- 10.7.2012 neu
    setstring("VERB_RAB", strSettingspath, "0");
    setstring("ZKX_RAB", strSettingspath,  "0");
    setstring("TRAV_RAB", strSettingspath, "0");
    setstring("SSG_RAB", strSettingspath,  "0");
    setstring("MBS_RAB", strSettingspath,  "0");

    setstring("LASTWEG_RAB", strSettingspath,  "0");
    setstring("PRUEFBESCH_RAB", strSettingspath,  "0");
    setstring("VORMONTAGE_RAB", strSettingspath,  "0");
    setstring("POSITIONIERUNG_RAB", strSettingspath,  "0");

    setstring("EXPORT_DXF_FORMAT_CHECK", "PROJECT.SETTINGS", "false");
    setstring("EXPORT_PDF_FORMAT_CHECK", "PROJECT.SETTINGS", "true");
}

function setCascadeRebatesFromDB()
{
    var strSettingspath = "PROJECT.SETTINGS.CASCADE";
    var strSQLStatement = "select * from REBATES  ";
    var numRet  = dbselect("SYS", strSQLStatement, "REBATES");
    var strProductArea = "", strRebate = "";
    while (dbiseof("REBATES") == 0)
    {
        strProductArea = dbgetstring("REBATES", "REBATE_TYPE");
        strRebate      = dbgetstring("REBATES", "VALUE");
        setstring(strProductArea, strSettingspath, strRebate);
        dbskip("REBATES");
    }
}

function setCascadeSettingsFromIni()
{
    var inifilename = getinipath();

    var strSettingspath = "PROJECT.SETTINGS.CASCADE";

    // setFromIni(storeVar, storePath, iniFilename, iniSection, iniVar, defaultVal)

    /*
	if (toupper(getstring("SALESVERSION", "RIGHTS")) == "TRUE")
		setFromIni("IDC_SSG_LISEGA_CHECK", strSettingspath,	 inifilename, "CA_SETTINGS", "IDC_SSG_LISEGA_CHECK", "false");
	else
		setFromIni("IDC_SSG_LISEGA_CHECK", strSettingspath,	 inifilename, "CA_SETTINGS", "IDC_SSG_LISEGA_CHECK", "true");
	//setFromIni("SSG_LI_PART", strSettingspath,	 inifilename, "CA_SETTINGS", "SSG_LI_PART", "false");
	*/
	
	setFromIni("OBFL_SCHEL1", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_SCHEL1", "OB_FEUER");
    setFromIni("OBFL_SCHEL2", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_SCHEL2", "OB_GALV");
    //setFromIni("OBFL_SCHEL3", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_SCHEL3", "OB_ROH");
	setFromIni("OBFL_SCHEL3", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_SCHEL3", "OB_GRUND");
    setFromIni("OBFL_SCHEL4", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_SCHEL4", "OB_ROH");
    setFromIni("OBFL_HAENGER", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_HAENGER", "OB_FEUER");
    setFromIni("OBFL_STREBEN", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_STREBEN", "OB_GRUND");
    setFromIni("OBFL_VERBTEILE", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_VERBTEILE", "OB_GALV");
    setFromIni("OBFL_ZKX", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_ZKX", "OB_FEUER");
    setFromIni("OBFL_LASCHEN", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_LASCHEN", "OB_GRUND");
    setFromIni("OBFL_TRAVERSEN", strSettingspath,	 inifilename, "CA_SETTINGS", "OBFL_TRAVERSEN", "OB_FEUER");
    setFromIni("GEWINDE_ANSCHLUSS", strSettingspath,	 inifilename, "CA_SETTINGS", "GEWINDE_ANSCHLUSS", "IDC_POS_GEWDIN_RADIOBUTTON");
    setFromIni("FH_BLOCKIERUNG", strSettingspath,	 inifilename, "CA_SETTINGS", "FH_BLOCKIERUNG", "IDC_FH_BLOCKJA_RADIOBUTTON");
    setFromIni("KH_BLOCKIERUNG", strSettingspath,	 inifilename, "CA_SETTINGS", "KH_BLOCKIERUNG", "IDC_KH_BLOCKJA_RADIOBUTTON");
    setFromIni("TERROSON_KH", strSettingspath,	 inifilename, "CA_SETTINGS", "TERROSON_KH", "false");
    setFromIni("TERROSON_FH", strSettingspath,	 inifilename, "CA_SETTINGS", "TERROSON_FH", "false");
    setFromIni("KENNZEICHNUNG_HAENG", strSettingspath,	 inifilename, "CA_SETTINGS", "KENNZEICHNUNG_HAENG", "true");
    setFromIni("KENNZEICHNUNG_GSTREBEN", strSettingspath,	 inifilename, "CA_SETTINGS", "KENNZEICHNUNG_GSTREBEN", "true");
    setFromIni("KENNZEICHNUNG_ANDERE", strSettingspath,	 inifilename, "CA_SETTINGS", "KENNZEICHNUNG_ANDERE", "false");
    setFromIni("KENNZEICHNUNG_POSITIONIERUNG", strSettingspath,	 inifilename, "CA_SETTINGS", "KENNZEICHNUNG_POSITIONIERUNG", "false");
    setFromIni("LASTWEG_PROT_FH", strSettingspath,	 inifilename, "CA_SETTINGS", "LASTWEG_PROT_FH", "false");
    setFromIni("LASTWEG_PROT_KH", strSettingspath,	 inifilename, "CA_SETTINGS", "LASTWEG_PROT_KH", "false");
    setFromIni("PRUEFBESCH_PROD_21", strSettingspath,	 inifilename, "CA_SETTINGS", "PRUEFBESCH_PROD_21", "false");
    setFromIni("PRUEFBESCH_PROD_22", strSettingspath,	 inifilename, "CA_SETTINGS", "PRUEFBESCH_PROD_22", "false");
    setFromIni("PRUEFBESCH_FEDERN", strSettingspath,	 inifilename, "CA_SETTINGS", "PRUEFBESCH_FEDERN", "false");
    setFromIni("PRUEFBESCH_WARMFEST", strSettingspath,	 inifilename, "CA_SETTINGS", "PRUEFBESCH_WARMFEST", "false");
    setFromIni("PRUEFBESCH_AUSTENIT", strSettingspath,	 inifilename, "CA_SETTINGS", "PRUEFBESCH_AUSTENIT", "false");
    setFromIni("VERPACKUNG", strSettingspath,	 inifilename, "CA_SETTINGS", "VERPACKUNG", "IDC_RADIO_VERPACKUNG_PALETTEN");
    setFromIni("SOLLAST_IST", strSettingspath,	 inifilename, "CA_SETTINGS", "SOLLAST_IST", "IDC_RADIO_SOLLAST_KALT");
    setFromIni("FH_PROZ_LASTAENDERUNG", strSettingspath,	 inifilename, "CA_SETTINGS", "FH_PROZ_LASTAENDERUNG", "25");
    setFromIni("FH_MINDESTWEGRESERVE_ABS", strSettingspath,	 inifilename, "CA_SETTINGS", "FH_MINDESTWEGRESERVE_ABS", "5");
    setFromIni("FH_MINDESTWEGRESERVE_PROZ", strSettingspath,	 inifilename, "CA_SETTINGS", "FH_MINDESTWEGRESERVE_PROZ", "20");
    setFromIni("KH_LASTJUSTIERBARKEIT", strSettingspath,	 inifilename, "CA_SETTINGS", "KH_LASTJUSTIERBARKEIT", "15");
    setFromIni("KH_MINDESTWEGRESERVE_ABS", strSettingspath,	 inifilename, "CA_SETTINGS", "KH_MINDESTWEGRESERVE_ABS", "10");
    setFromIni("KH_MINDESTWEGRESERVE_PROZ", strSettingspath,	 inifilename, "CA_SETTINGS", "KH_MINDESTWEGRESERVE_PROZ", "10");
    setFromIni("GSTREBE_MINDESTVERSTELLRESERVE", strSettingspath,	 inifilename, "CA_SETTINGS", "GSTREBE_MINDESTVERSTELLRESERVE", "");
    setFromIni("GRENZ_TEMP", strSettingspath,	 inifilename, "CA_SETTINGS", "GRENZ_TEMP", "IDC_RADIO_GRENZ_TEMP_VGB");
    setFromIni("GEWST_DEF_LEN", strSettingspath,	 inifilename, "CA_SETTINGS", "GEWST_DEF_LEN", "IDC_RADIO_GEWST_DEF_LEN_2000");
    setFromIni("GEWSTANGPASSMIN", strSettingspath,	 inifilename, "CA_SETTINGS", "GEWSTANGPASSMIN", "");
    setFromIni("GEWSTANGPASSRUND", strSettingspath,	 inifilename, "CA_SETTINGS", "GEWSTANGPASSRUND", "");
    setFromIni("SCHRAEGZUG", strSettingspath,	 inifilename, "CA_SETTINGS", "SCHRAEGZUG", "4");
    setFromIni("VORSPANNUNG", strSettingspath,	 inifilename, "CA_SETTINGS", "VORSPANNUNG", "IDC_RADIO_VORSPANNUNG_OHNE");

    // -schm- 04/2008: manche Voreinstellungen festsetzen:
    setstring("KENNZEICHNUNG_HAENG", strSettingspath, "true");
    setstring("KENNZEICHNUNG_GSTREBEN", strSettingspath, "true");
    setstring("GEWINDE_ANSCHLUSS", strSettingspath,	 "IDC_POS_GEWDIN_RADIOBUTTON");

    if ((tolower(getstring("EXPORT_DXF_FORMAT_CHECK", "PROJECT.SETTINGS") != "true")) &&
        (tolower(getstring("EXPORT_PDF_FORMAT_CHECK", "PROJECT.SETTINGS") != "true")))
        setstring("EXPORT_PDF_FORMAT_CHECK", "PROJECT.SETTINGS", "true");

    // Rabatte entweder aus INI, wenn Anwender editieren darf oder aus DB,
    // wenn er nicht editieren darf.
    if (getstring("REBATES_EDITABLE", "RIGHTS") == "0" && getbool("SALESVERSION", "RIGHTS")
			&& getbool("PRICES_VISIBLE", "RIGHTS"))	//Version mit festen Rabatten
    {
        setCascadeRebatesFromDB();
    }
    // 20180201 -Schu-
	// Rabatte nicht aus INI ziehen -> kann zu ungewollter Rabattierung führen
	/*
	else
    {
        setFromIni("FH_BIS_11_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "FH_BIS_11_RAB", "0");
        setFromIni("FH_AB_12_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "FH_AB_12_RAB", "0");
        setFromIni("KH_BIS_12_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "KH_BIS_12_RAB", "0");
        setFromIni("KH_AB_13_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "KH_AB_13_RAB", "0");
        setFromIni("SCHELLE_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "SCHELLE_RAB", "0");
        setFromIni("LAGER_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "LAGER_RAB", "0");
        setFromIni("VERB_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "VERB_RAB", "0");
        setFromIni("ZKX_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "ZKX_RAB", "0");
        setFromIni("TRAV_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "TRAV_RAB", "0");
        setFromIni("SSG_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "SSG_RAB", "0");
        setFromIni("MBS_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "MBS_RAB", "0");

        setFromIni("LASTWEG_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "LASTWEG_RAB", "0");
        setFromIni("PRUEFBESCH_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "PRUEFBESCH_RAB", "0");
        setFromIni("VORMONTAGE_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "VORMONTAGE_RAB", "0");
        setFromIni("POSITIONIERUNG_RAB", strSettingspath,	 inifilename, "CA_SETTINGS", "POSITIONIERUNG_RAB", "0");
    }
	*/
	// immer für Projekt setzen -> default "0"
	else{
		setstring("FH_BIS_11_RAB",	strSettingspath,	"0");
		setstring("FH_AB_12_RAB",	strSettingspath,	"0");
		setstring("KH_BIS_12_RAB",	strSettingspath,	"0");
		setstring("KH_AB_13_RAB",	strSettingspath,	"0");
		setstring("SCHELLE_RAB",	strSettingspath,	"0");
		setstring("LAGER_RAB",		strSettingspath,	"0");
		setstring("VERB_RAB",		strSettingspath,	"0");
		setstring("ZKX_RAB",		strSettingspath,	"0");
		setstring("TRAV_RAB",		strSettingspath,	"0");
		setstring("SSG_RAB",		strSettingspath,	"0");
		setstring("MBS_RAB",		strSettingspath,	"0");
		
		setstring("LASTWEG_RAB",		strSettingspath,	"0");
		setstring("PRUEFBESCH_RAB",		strSettingspath,	"0");
		setstring("VORMONTAGE_RAB",		strSettingspath,	"0");
		setstring("POSITIONIERUNG_RAB",	strSettingspath,	"0");
	}
	
	// Währung und Umrechnungsfaktor:
	setstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR", "1");
	setstring("DISABLE_CUR_FACTOR", "PROJECT.SETTINGS.WUR", "true");
	setstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR", "EUR");
	
	// Sonstiges:
	setstring("IMPORT_STK_VERZEICHNIS", "", readinistring(inifilename, "CA_SETTINGS", "IMPORT_STK_VERZEICHNIS"));
	setstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS", readinistring(inifilename, "CA_SETTINGS", "EXPORT_CAD_VERZEICHNIS"));
	setstring("EXPORT_STK_VERZEICHNIS", "", readinistring(inifilename, "CA_SETTINGS", "EXPORT_STK_VERZEICHNIS"));
	setstring("IMPORT_TCA_VERZEICHNIS", "", readinistring(inifilename, "CA_SETTINGS", "IMPORT_TCA_VERZEICHNIS"));

	bRHMenu = true;
//    if (getstring("RH_MENU_ON_OFF_CHECK","") == "")
//		setstring("RH_MENU_ON_OFF_CHECK","", "true")
	setFromIni("RH_MENU_ON_OFF_CHECK", "",	 inifilename, "CA_SETTINGS", "RH_MENU_ON_OFF_CHECK", "true");
    if (getstring("RH_MENU_ON_OFF_CHECK","") != "true")
		bRHMenu = false;

    setstring("PREVENT_OUTPUT_RH_SETTINGS","RIGHTS", "true");
    setstring("PREVENT_OUTPUT_RH_ANALYSE","RIGHTS", "true");
	if (bRHMenu)
	{
		setstring("PREVENT_OUTPUT_RH_SETTINGS","RIGHTS", "false");
		if (getstring("EXPERT_MODE", "RIGHTS") == "1")
			setstring("PREVENT_OUTPUT_RH_ANALYSE","RIGHTS", "false");
	}

    setstring("PREVENT_OUTPUT_RH_IMEXPORT","RIGHTS", "true");
	if (getstring("CATALOG.INTERNETSERVERINCDMODE","") == "true")  // CD-Version
		setstring("PREVENT_OUTPUT_RH_IMEXPORT","RIGHTS", "false");

	setstring("IDC_AS_MARKIERUNG_CHECK","","true");
	setstring("IDC_AS_ZEICHNUNGSNR_CHECK","","false");

	setFromIni("UNTERSTUETZUNG_PDF_CHECK", "",	 inifilename, "CA_SETTINGS", "UNTERSTUETZUNG_PDF_CHECK", "true");
}

function setSinglePropertyToIni(strProperty, strValue)
{
    var iniFilename = getinipath();
    writeinistring(iniFilename, "CA_SETTINGS", strProperty, strValue);
}

function setCascadeSettingsToIni()
{
    var iniFilename = getinipath();
    // alert(iniFilename);
    /*
    var progdir    = getstddirectory("PROGRAM");
    var inifile    = getstring("CATALOG.INIFILE.NAME","ROOT");
    var iniFilename = progdir + inifile;
	*/
    var strSettingspath = "PROJECT.SETTINGS.CASCADE";

    // writeinistring(iniFilename, iniSection, iniVar, Value);
    // writeinistring(iniFilename, "CA_SETTINGS", "OBFL_SCHEL1", "HALLO");

    // writeinistring(iniFilename, "CA_SETTINGS", "IDC_SSG_LISEGA_CHECK", getstring("IDC_SSG_LISEGA_CHECK", strSettingspath));
	
	writeinistring(iniFilename, "CA_SETTINGS", "OBFL_SCHEL1", getstring("OBFL_SCHEL1", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "OBFL_SCHEL2",getstring("OBFL_SCHEL2", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "OBFL_SCHEL3", getstring("OBFL_SCHEL3", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "OBFL_SCHEL4", getstring("OBFL_SCHEL4", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "OBFL_HAENGER", getstring("OBFL_HAENGER", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "OBFL_STREBEN", getstring("OBFL_STREBEN", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "OBFL_VERBTEILE", getstring("OBFL_VERBTEILE", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "OBFL_ZKX", getstring("OBFL_ZKX", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "OBFL_LASCHEN", getstring("OBFL_LASCHEN", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "OBFL_TRAVERSEN", getstring("OBFL_TRAVERSEN", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "GEWINDE_ANSCHLUSS", getstring("GEWINDE_ANSCHLUSS", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "FH_BLOCKIERUNG", getstring("FH_BLOCKIERUNG", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KH_BLOCKIERUNG", getstring("KH_BLOCKIERUNG", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "TERROSON_KH", getstring("TERROSON_KH", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "TERROSON_FH", getstring("TERROSON_FH", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KENNZEICHNUNG_HAENG", getstring("KENNZEICHNUNG_HAENG", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KENNZEICHNUNG_GSTREBEN", getstring("KENNZEICHNUNG_GSTREBEN", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KENNZEICHNUNG_ANDERE", getstring("KENNZEICHNUNG_ANDERE", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KENNZEICHNUNG_POSITIONIERUNG", getstring("KENNZEICHNUNG_POSITIONIERUNG", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "LASTWEG_PROT_FH", getstring("LASTWEG_PROT_FH", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "LASTWEG_PROT_KH", getstring("LASTWEG_PROT_KH", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "PRUEFBESCH_PROD_21", getstring("PRUEFBESCH_PROD_21", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "PRUEFBESCH_PROD_22", getstring("PRUEFBESCH_PROD_22", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "PRUEFBESCH_FEDERN", getstring("PRUEFBESCH_FEDERN", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "PRUEFBESCH_WARMFEST", getstring("PRUEFBESCH_WARMFEST", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "PRUEFBESCH_AUSTENIT", getstring("PRUEFBESCH_AUSTENIT", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "VERPACKUNG", getstring("VERPACKUNG", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "SOLLAST_IST", getstring("SOLLAST_IST", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "FH_PROZ_LASTAENDERUNG", getstring("FH_PROZ_LASTAENDERUNG", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "FH_MINDESTWEGRESERVE_ABS", getstring("FH_MINDESTWEGRESERVE_ABS", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "FH_MINDESTWEGRESERVE_PROZ", getstring("FH_MINDESTWEGRESERVE_PROZ", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KH_LASTJUSTIERBARKEIT", getstring("KH_LASTJUSTIERBARKEIT", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KH_MINDESTWEGRESERVE_ABS", getstring("KH_MINDESTWEGRESERVE_ABS", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KH_MINDESTWEGRESERVE_PROZ", getstring("KH_MINDESTWEGRESERVE_PROZ", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "GSTREBE_MINDESTVERSTELLRESERVE", getstring("GSTREBE_MINDESTVERSTELLRESERVE", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "GRENZ_TEMP", getstring("GRENZ_TEMP", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "GEWST_DEF_LEN", getstring("GEWST_DEF_LEN", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "GEWSTANGPASSMIN", getstring("GEWSTANGPASSMIN", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "GEWSTANGPASSRUND", getstring("GEWSTANGPASSRUND", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "SCHRAEGZUG", getstring("SCHRAEGZUG", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "VORSPANNUNG", getstring("VORSPANNUNG", strSettingspath));
	/*	Nicht mit in INI schreiben - die werden sonst bei "Start" / "Neues Projekt" IMMER wieder geladen
    writeinistring(iniFilename, "CA_SETTINGS", "FH_BIS_11_RAB", getstring("FH_BIS_11_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "FH_AB_12_RAB", getstring("FH_AB_12_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KH_BIS_12_RAB", getstring("KH_BIS_12_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "KH_AB_13_RAB", getstring("KH_AB_13_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "SCHELLE_RAB", getstring("SCHELLE_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "LAGER_RAB", getstring("LAGER_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "VERB_RAB", getstring("VERB_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "ZKX_RAB", getstring("ZKX_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "TRAV_RAB", getstring("TRAV_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "SSG_RAB", getstring("SSG_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "MBS_RAB", getstring("MBS_RAB", strSettingspath));
	
    writeinistring(iniFilename, "CA_SETTINGS", "LASTWEG_RAB", getstring("LASTWEG_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "PRUEFBESCH_RAB", getstring("PRUEFBESCH_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "VORMONTAGE_RAB", getstring("VORMONTAGE_RAB", strSettingspath));
    writeinistring(iniFilename, "CA_SETTINGS", "POSITIONIERUNG_RAB", getstring("POSITIONIERUNG_RAB", strSettingspath));
	*/
}

function setTablePriceHeaders()
{
	var strCurrencyKuerzel = getstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR");
	if (strCurrencyKuerzel == "")
	{
		strCurrencyKuerzel = "EUR";
		setstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR", strCurrencyKuerzel);
		setstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR", "1");
	}
	
	if (strCurrencyKuerzel == "EUR")
		setstring("AG_CURRENCY_UNIT", "PROJECT.SETTINGS.AG_TEXTE", "€");
	else
		setstring("AG_CURRENCY_UNIT", "PROJECT.SETTINGS.AG_TEXTE", strCurrencyKuerzel);
	
	/*
	if (trimright(trimleft(getstring("IDC_WI_PROJENDPREIS_VORGABE_EDIT", "IDD_PROJECTLISTE"), " "), " ") == ""){
		//setstring("AG_HINWEIS_VORGABE", "PROJECT.SETTINGS.AG_TEXTE", "");
		//setstring("AG_PREIS", "PROJECT.SETTINGS.AG_TEXTE", getstring("IDC_WI_PROJENDPREIS_EDIT", "IDD_PROJECTLISTE"));
		setstring("QUOT_LINE3VALUE", "PROJECT.SETTINGS", getstring("IDC_WI_PROJENDPREIS_EDIT", "IDD_PROJECTLISTE"));
	}
	else{
		//setstring("AG_HINWEIS_VORGABE", "PROJECT.SETTINGS.AG_TEXTE", "(" + getstring("QUOT_LINE3LABEL", "PROJECT.SETTINGS") + ")");
		//setstring("AG_PREIS", "PROJECT.SETTINGS.AG_TEXTE", getstring("IDC_WI_PROJENDPREIS_VORGABE_EDIT", "IDD_PROJECTLISTE"));
		setstring("QUOT_LINE3VALUE", "PROJECT.SETTINGS", getstring("IDC_WI_PROJENDPREIS_VORGABE_EDIT", "IDD_PROJECTLISTE"));
	}
	*/
	
	strCurrencyKuerzel = "[" + strCurrencyKuerzel + "]";
	
	setstring("TCH_UNITPRICE", 				"TMP.HEADER", translate("TCH_UNITPRICE") + strCurrencyKuerzel);
	setstring("TCH_FORCEDUNITPRICE", 		"TMP.HEADER", translate("TCH_FORCEDUNITPRICE") + strCurrencyKuerzel);
	setstring("TCH_EXT_ACCEPT_CALC_PRICE", 	"TMP.HEADER", translate("TCH_EXT_ACCEPT_CALC_PRICE") + strCurrencyKuerzel);
	setstring("TCH_EXT_ACCEPT_SET_PRICE", 	"TMP.HEADER", translate("TCH_EXT_ACCEPT_SET_PRICE") + strCurrencyKuerzel);
	setstring("TCH_INT_ACCEPT_CALC_PRICE", 	"TMP.HEADER", translate("TCH_INT_ACCEPT_CALC_PRICE") + strCurrencyKuerzel);
	setstring("TCH_INT_ACCEPT_SET_PRICE", 	"TMP.HEADER", translate("TCH_INT_ACCEPT_SET_PRICE") + strCurrencyKuerzel);
	setstring("TCH_POSPRICE", 				"TMP.HEADER", translate("TCH_POSPRICE") + strCurrencyKuerzel);
	setstring("TCH_PREIS", 					"TMP.HEADER", translate("TCH_PREIS") + strCurrencyKuerzel);

}


function invalidiereZeichnungen()
{
    // Irgendwas wurde geändert --> Zeichnungs-Cache zurücksetzen
    var Source, strPos, i;
    var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
    var nLastPos = getsize(Projectlist, "") - 1;
    for (i = 0; i <= nLastPos; ++i)
    {
        Source = Projectlist + "[" + i + "]";
        var strProductArea  = getstring("PRODUCT_AREA", Source);
        setstring("CACHE_DRAWING_FILE_PDF_SAP", Source, "");
        setstring("CACHE_DRAWING_FILE_PDF", Source, "");
        setstring("CACHE_DRAWING_FILE_DXF", Source, "");
    }
}

function doSortMarkierung()
{
    var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
    if (getsize(Projectlist, "") > 0)
    {
        var arr = Object.fromStorage('PROJECT.POSITIONS.PROJECTLIST_ITEMS');
        var test = " ";
        function cmp_fn_text(a,b)
        {
            var x = a['ORDERCODE_PROJECTLIST'];
            var i = find(x, "<");
            if (i > 0)
                x = left(x, i-1);
            var y = b['ORDERCODE_PROJECTLIST'];
            i = find(y, "<");
            if (i > 0)
                y = left(y, i-1);
            if (!x || !y)
                return 0;
            return x.compareNoCase(y);
        }
        // if (tolower(getstring('PLIST_SORTIERUNG_TEXT_CHECK', '')) == 'true')
		arr.sort(cmp_fn_text);
        arr.toStorage('PROJECT.POSITIONS.PROJECTLIST_ITEMS', false);
    }
	// Positionsnummern neu vergeben!
    var nLastPos = getsize(Projectlist, "") - 1;
    for (var i = 0; i <= nLastPos; ++i)
    {
        Source = Projectlist + "[" + i + "]";
        var strPos  = '' + ((i + 1) * 10);
		setstring("POS", Source, strPos);
    }

}

function doAktualisierung()
{
    var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
    if (getsize(Projectlist, "") > 0)
    {
        // sortarray("PROJECT.POSITIONS.PROJECTLIST_ITEMS", "POS");
        // src += "function cmp_fn(a,b) {return a['"+par.Str()+"'].compareNoCase(b['"+par.Str()+"']); }\n";
        var arr = Object.fromStorage('PROJECT.POSITIONS.PROJECTLIST_ITEMS');
        var test = " ";
        function cmp_fn(a,b)
        {
            var ret = (parseFloat(a['POS'])-parseFloat(b['POS']))*100;
            if (ret == 0)   // beide gleich, eventuell hängt ein Buchstabe dran ...
            {
                if ((find(a['POS'], 'a') >= 0) || (find(a['POS'], 'A') >= 0))
                    ret = 1;
                if ((find(b['POS'], 'a') >= 0) || (find(b['POS'], 'A') >= 0))
                    ret = -1;
            }
            return ret;
        }
		arr.sort(cmp_fn);
        arr.toStorage('PROJECT.POSITIONS.PROJECTLIST_ITEMS', false);
    }

	// Test auf doppelte Posnummern:
    var nLastPos = getsize(Projectlist, "") - 1;
	var strPrevPos = "XXX";
	var bDoppelt = false;
    for (i = 0; i <= nLastPos; ++i)
    {
        Source = Projectlist + "[" + i + "]";
        var strPos  = getstring("POS", Source);
		if (strPos == strPrevPos)
			bDoppelt = true;
		strPrevPos = strPos;
    }
	if (bDoppelt)
		setstring("ERRORMESSAGE", "TEMP", translate("IDP_DOPPELTE_POSNR"));	// 

	// falls Import noch offen
	delete("PROJECT", "TEMP");
	if(getstring("PROJECTIMPORT_COMMENT_START", "") != "")
	{
		setstring("PROJECTIMPORT_COMMENT_START", "", "<!--");
		setstring("PROJECTIMPORT_COMMENT_END", "", "-->");
		setstring("PROJECTIMPORT_COMMENT_PREVENT", "", "true");
	}
	// Eingabedaten Import löschen
	if(getstring("IMPORT_FILE_NAME", "TEMP") != "")
	{
		setstring("IMPORT_FILE_NAME", "TEMP", "");
		setstring("TYPNUMMER", "TEMP", "");
	}
}

function startCascadeLastkette()
{
        setstring("OPEN_MODE_CASCADE", "", "NEW");
        // Alles wegputzen, Anwender soll frisch starten (u.a. auch Stückzahl wieder auf 1)
        // Anforderung 04/2008: Manche Werte sollen aus alter Auslegung übernommen werden:

        // Sonst serialisiert er sich im postDispatch wieder raus, nachdem wir hier gelöscht haben ....
        // caMainController = null;  --> funktioniert nicht, weil navigate in einem eigenen Kontext läuft !!!
        setstring("KILL_CAMAINCONTROLLER", "", "true");

        delete("SAVE_CASCADE_INPUTS", "TMP");
        copy("DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", "TMP.SAVE_CASCADE_INPUTS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
        copy("DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE", "TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE");

		if (getstring("DLGDATA.CA.FORMS.LAGER2DATAEXISTS", "") == "X") {
			setstring("TMP.SAVE_CASCADE_INPUTS.USELAGERROHRDATA", "", "true");
			copy("DLGDATA.CA.FORMS.LAGER2DATA.SollwerteRohrUmTeil", "TMP.SAVE_CASCADE_INPUTS.LAGER2DATA.SollwerteRohrUmTeil");
		}
		if (typeof(Object.fromStorage( "DLGDATA.CA.FINDATA" )) != 'object')
			delete("", "DLGDATA");
        copy("TMP.SAVE_CASCADE_INPUTS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
        copy("TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR");
        copy("TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR");
        copy("TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN");
        return "index2";
}

/////////////////////////////////////////////////////////////////////////
//FUNKTION KANN ENTFALLEN WENN NEUIMPLEMENTIERUNG FERTIG IST !!!!!!!!!!!
function startCascadeLager()
{
        // Sonst serialisiert er sich im postDispatch wieder raus, nachdem wir hier gelöscht haben ....
        // caMainController = null;
        setstring("KILL_CAMAINCONTROLLER", "", "true");

        setstring( "OPEN_MODE_CASCADE", "", "LAGER" );
        delete( "SAVE_CASCADE_INPUTS", "TMP" );
        copy("DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE", "TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE");
		delete( "", "DLGDATA" );
        copy("TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR");
        copy("TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR");
        copy("TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN");
        return "index2";
}
//END
/////////////////////////////////////////////////////////////////////////

function startCascadeLager2011()
{
        // Sonst serialisiert er sich im postDispatch wieder raus, nachdem wir hier gelöscht haben ....
        // caMainController = null;
        setstring("KILL_CAMAINCONTROLLER", "", "true");

        setstring( "OPEN_MODE_CASCADE", "", "LAGER2011" );
        delete( "SAVE_CASCADE_INPUTS", "TMP" );
        copy("DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", "TMP.SAVE_CASCADE_INPUTS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL");
		copy("DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE", "TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE");
        
		if (getstring("DLGDATA.CA.FORMS.LAGER2DATAEXISTS", "") == "X") {
			setstring("TMP.SAVE_CASCADE_INPUTS.USELAGERROHRDATA", "", "true");
			copy("DLGDATA.CA.FORMS.LAGER2DATA.SollwerteRohrUmTeil", "TMP.SAVE_CASCADE_INPUTS.LAGER2DATA.SollwerteRohrUmTeil");
		}
		if (typeof(Object.fromStorage( "DLGDATA.CA.FINDATA" )) != 'object')
			delete( "", "DLGDATA" );
		else
			delete( "SYSTEMCHARAKTERISTIK" , "DLGDATA.CA.FORMS" );
        copy("TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR");
        copy("TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR");
        copy("TMP.SAVE_CASCADE_INPUTS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN");
        return "index2";
}

function bereiteRHToolsDablaVor()
{
	// BENÖTIGTE VARIABLEN INITIALISIEREN
	var i = 0;
	var iVALUE_FOUND 			= -1;
	var strDN					= "";
	var strRAD					= "";
	var strNENNWEITE_RAD 		= "";

	// AUSLESEN DER DATEN AUS DEM SCREEN 'Berechnungs-Tool'
	var strAUSWAHLWEG 				= getstring("AUSWAHLWEG", "DLGDATA.RH.AUSLEGUNG");
	var strNENNWEITE_ID				= getstring("NENNWEITE", "DLGDATA.RH.AUSLEGUNG");
	var strAUSSENDURCHMESSER   		= getstring("AUSSENDURCHCOMBO", "DLGDATA.RH.AUSLEGUNG");
	var strSONDERAUSSENDURCHCHECK   = getstring("SONDER_AUSSENDURCH_CHECK", "DLGDATA.RH.AUSLEGUNG");
	var strSONDERAUSSENDURCHMESSER  = getstring("SONDER_AUSSENDURCH", "DLGDATA.RH.AUSLEGUNG");
	var strTEMPERATUR_BEREICH  		= getstring("TEMPERATUR_BEREICH", "DLGDATA.RH.AUSLEGUNG");
	var strDICHTE_DAEMMUNG 			= getstring("DICHTE_DAEMM", "DLGDATA.RH.AUSLEGUNG");
	var strDICHTE_MANTEL 			= getstring("DICHTE_MANTEL", "DLGDATA.RH.AUSLEGUNG");
	var strDICHTE_MEDIUM 			= getstring("DICHTE_MEDIUM", "DLGDATA.RH.AUSLEGUNG");

	var techvalROHRWANDDICKE   		= getstring("ROHRWANDDICKE", "DLGDATA.RH.AUSLEGUNG");
	var techvalMANTELDICKE			= getstring("MANTELDICKE", "DLGDATA.RH.AUSLEGUNG");

	var strLAST_FALL				= getstring("LASTFALL", "DLGDATA.RH.AUSLEGUNG");
	var strHOEHE_GELAENDE			= getstring("HOEHE_GELAENDE", "DLGDATA.RH.AUSLEGUNG");
	var strDICHTE_UMGEBUNGSMEDIUM	= getstring("DICHTE_UMGEBUNGSMEDIUM", "DLGDATA.RH.AUSLEGUNG");

	var techvalSTUETZWEITE_BERECHN 	= getstring("STUETZWEITE_BERECHN", "DLGDATA.RH.AUSLEGUNG");
	var techvalSTUETZWEITE_GEWAEHLT	= getstring("STUETZWEITE_GEWAEHLT", "DLGDATA.RH.AUSLEGUNG");
	var techvalAUFLAGELAST			= getstring("AUFLAGELAST", "DLGDATA.RH.AUSLEGUNG");
	var techvalWINDLAST				= getstring("WINDLAST", "DLGDATA.RH.AUSLEGUNG");
	var techvalAUFTRIEBSKRAFT		= getstring("AUFTRIEBSKRAFT", "DLGDATA.RH.AUSLEGUNG");

	var techValDAEMM_DICKE 			= getstring("ISOLIERDICKE", "DLGDATA.RH.AUSLEGUNG");

	// SETZEN DER DATEN
	setstring("DICHTE_DAEMMUNG", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", strDICHTE_DAEMMUNG);
	setstring("DICHTE_MANTEL", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", strDICHTE_MANTEL);
	setstring("DICHTE_MEDIUM", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", strDICHTE_MEDIUM);

	setstring("ROHRWANDDICKE", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", techvalROHRWANDDICKE);
	setstring("MANTELDICKE", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", techvalMANTELDICKE);
	setstring("DICHTE_UMGEBUNGSMEDIUM", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", strDICHTE_UMGEBUNGSMEDIUM);

	setstring("STUETZWEITE_BERECHN", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", techvalSTUETZWEITE_BERECHN);
	setstring("STUETZWEITE_GEWAEHLT", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", techvalSTUETZWEITE_GEWAEHLT);
	setstring("AUFLAGELAST", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", techvalAUFLAGELAST);
	setstring("WINDLAST", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", techvalWINDLAST);
	setstring("AUFTRIEBSKRAFT", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", techvalAUFTRIEBSKRAFT);

	// SETZEN DER TECH_DATEN
	setstring("dDaemmdicke", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", techValDAEMM_DICKE);

	// SETZEN DER DATEN, DIE ÜBERSETZT WERDEN MÜSSEN
	setstring("strHoeheGelaende", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", translate(strHOEHE_GELAENDE));
	setstring("strLastFall", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", translate(strLAST_FALL));
	setstring("strTemperaturBereich", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", translate(strTEMPERATUR_BEREICH));

	// strNENNWEITE_ID enthält den Teilstring 'ID_'
	// dieser muß weggeschnitten werden. strNENNWEITE enthält dann die Nennweite
	var strNENNWEITE = replace(strNENNWEITE_ID, "ID_", "");

	// Aussendurch FINDEN
	if (strSONDERAUSSENDURCHCHECK == "true")
	{
		strAUSSENDURCHMESSER = strSONDERAUSSENDURCHMESSER;
		strNENNWEITE = "-";
	}
	else
	{
		var strSQLStatement = "select * from ROHRD WHERE NENNWEITE="+strNENNWEITE;
		var numRet = dbselect("CASCADE", strSQLStatement, "ROHRD");
		if (numRet > 0)
			 strAUSSENDURCHMESSER = replace(dbgetstring("ROHRD", "D"), ",", ".");
	}
	
	// SETZEN DER DATEN
	setstring("DN", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", strNENNWEITE);
	setstring("D", "DLGDATA.RH.AUSLEGUNG.SELPRODUCT", strAUSSENDURCHMESSER);
    
    setstring("AUSWAHLWEG", "DLGDATA.RH.AUSLEGUNG", "TOOLS");
    specialexec("RHMacheDatenblatt");
}

function CheckRabates()
{
	var Path		= "PROJECT.SETTINGS.CASCADE";
	var NO_RABATES	= "true";
	getdouble("FH_BIS_11_RAB",	Path) != 0		? NO_RABATES = "false" : "";
	getdouble("FH_AB_12_RAB",	Path) != 0		? NO_RABATES = "false" : "";
	getdouble("KH_BIS_12_RAB",	Path) != 0		? NO_RABATES = "false" : "";
	getdouble("KH_AB_13_RAB",	Path) != 0		? NO_RABATES = "false" : "";
	getdouble("SCHELLE_RAB",	Path) != 0		? NO_RABATES = "false" : "";
	getdouble("LAGER_RAB",		Path) != 0		? NO_RABATES = "false" : "";
	getdouble("VERB_RAB",		Path) != 0		? NO_RABATES = "false" : "";
	getdouble("ZKX_RAB",		Path) != 0		? NO_RABATES = "false" : "";
	getdouble("TRAV_RAB",		Path) != 0		? NO_RABATES = "false" : "";
	getdouble("SSG_RAB",		Path) != 0		? NO_RABATES = "false" : "";
	getdouble("MBS_RAB",		Path) != 0		? NO_RABATES = "false" : "";
	/*
	getdouble("LASTWEG_RAB", Path) != 0			? NO_RABATES = "false" : "";
	getdouble("PRUEFBESCH_RAB", Path) != 0		? NO_RABATES = "false" : "";
	getdouble("VORMONTAGE_RAB", Path) != 0		? NO_RABATES = "false" : "";
	getdouble("POSITIONIERUNG_RAB", Path) != 0 	? NO_RABATES = "false" : "";
	*/
	if (getbool("REBATES_EDITABLE", "RIGHTS"))
		setstring("RABATES_NOT_EXIST", "RIGHTS", NO_RABATES);
	else
		setstring("RABATES_NOT_EXIST", "RIGHTS", "true");
}

function DeleteRabates()
{
	var Path		= "PROJECT.SETTINGS.CASCADE";
	
	setstring("FH_BIS_11_RAB",	Path, "0");
	setstring("FH_AB_12_RAB",	Path, "0");
	setstring("KH_BIS_12_RAB",	Path, "0");
	setstring("KH_AB_13_RAB",	Path, "0");
	setstring("SCHELLE_RAB",	Path, "0");
	setstring("LAGER_RAB",		Path, "0");
	setstring("VERB_RAB",		Path, "0");
	setstring("ZKX_RAB",		Path, "0");
	setstring("TRAV_RAB",		Path, "0");
	setstring("SSG_RAB",		Path, "0");
	setstring("MBS_RAB",		Path, "0");
	
	setstring("RABATES_NOT_EXIST", "RIGHTS", "true");
}

function main()
{
	//EasyScript Version ausgeben
	//writefile("version.txt" , easyscriptversion(true) , "");

	// Die aktuelle Maske (sofern vorhanden)
    // -mw-: sowas nie im Produktivbetrieb machen!!!:
	// var store 		= Object.fromStorage("ROOT");

	var current_dlg	= getstring("AKTUELLE_MASKE","");
	var session_id 	= getstring("sessionid","");
	var state_id 	= getstring("stateid", "");
	
	var startScreen = getstring('EK_PRODUCT_GROUP', '');
	setstring('EK_PRODUCT_GROUP', '', '');
	
	// var event		= getdlgvar("EKSUBMITEVENT");	# Event aus der aktuellen Maske
    // -mw- 12/2007: Besser aus dem Store benutzen, da in der Projektliste Event umgesetzt wird !
	var event		= getstring("EKSUBMITEVENT", "");	//# Event aus der aktuellen Maske
	
	var start_dlg       = "IDD_START";
	var new_dlg         = current_dlg;
	var clear_dlg		= false;
	
/* -mw- 15.6.08 Test für parseFloat (Fehler in EXE):
    hier kam 10 raus !!!
    var strTest = "100";
    var dTest = parseFloat(strTest);
*/
    // Reparaturen von Übergabedaten:
    var strAngebNr   = getstring("WI_ANGEBOTSNR",  "PROJECT.SETTINGS");
    strAngebNr   = trimleft(strAngebNr, " ");
    strAngebNr   = trimright(strAngebNr, " ");
    setstring("WI_ANGEBOTSNR",  "PROJECT.SETTINGS", strAngebNr);
	
	// ================================================================================================
	// additional actions for auto update
	// ================================================================================================
	setstring( 'ONLINE', 'DLGDATA', getstring( 'CATALOG.AUTOSTARTINTERNETSERVER', 'ROOT' ) );
	setstring( 'UPDATEURL', 'DLGDATA', getstring( 'CATALOG.CATVERSION.UPDATEURL', 'ROOT' ) );
    setstring( 'CATVERSION', 'DLGDATA', getstring( 'CATALOG.INTERNAL.CATVERSION', 'ROOT' ) );
	
	// ================================================================================================
	// special script actions for first application start
	// ================================================================================================
    if (getstring("INIFILE_GELESEN", "") != "TRUE")
    {
        // Rechte einlesen ....
        readRights();
		
        setstring("INIFILE_GELESEN", "", "TRUE");
        setCascadeSettingsFromIni();
		
		// ================================================================================================
		// bei Aufruf aus des WS-Projektliste soll entsprechendes Projekt geladen werden
		// ================================================================================================
		// wir kommen hier nur 1x vorbei -> Programmstart
		if (getstring("PARAM", "CATALOG.CMDLINE[0000]") == "@WSPL@" &&
			toupper(getstring("RTWUser", "")) == "TRUE"){	// auf WDA beschränkt
			setstring("PROJECT.PROJECTPATH", "", getstring("PARAM", "CATALOG.CMDLINE[0001]"));
			specialexec("LoadProject");
			//setstring("PARAM", "CATALOG.CMDLINE[0000]", "");	// das kommt immer wieder
			//setstring("PARAM", "CATALOG.CMDLINE[0001]", "");
		}
		
		// handle automatic update
		if ( Base.handleUpdateOnStart() ) {
			// nur User ohne zentrale Softwareverteilung
			// WI-User müssen Updaten um einen gemeinsamen Versionsstand zu haben
			// allen anderen kann man das freistellen
			
			var strLanguage = getstring("EKCURRENTLANGUAGE", "");
			setlanguage(strLanguage);
			event = "IDD_UPDATE";
			
			if (getstring("ONLINEUPDATE_MUST","RIGHTS")=="true") { // Update erzwingen:
				var catalogName = getstring("CATALOG.NAME","ROOT");
				var url = getstring("UPDATE_FILE", "AUTOUPDATE");

				var param="";
				param+=" --url="+url;							// Link zum Installer 
				//param+=" --no-cache";							// Keinen Datei auch dem Cache
				//param+=" --exec";								// Den Installer automatisch starten
				param+=" --close-pid="+getcurrentprocessid();	// Diesen Process noch vor dem Start des Installers 
				//param+=" --close-name="+"IndraSize.exe";		// beenden (WM_CLOSE).
				param+=" --kill-timeout=60000"					// Nach max. 60s den Prozess töten (TerminateProcess)
				param+=" --window-title="+'"'+catalogName+'"';	// EasyKat Name (spez.)

				param+=" --extract-to=./";
				param+=" --shell-exec=Flexperte.exe"
				
				//setint("ALLOW_SHUTDOWN", "ROOT", 1);
				shellexecuteex("netupd.exe", param, "", 1);			
			}
		}
		
		// Check "Hintergrundrabatte"
		CheckRabates();
		
		setstring("PROJECTIMPORT_COMMENT_START", "", "<!--");
		setstring("PROJECTIMPORT_COMMENT_END", "", "-->");
		setstring("PROJECTIMPORT_COMMENT_PREVENT", "", "true");
		setstring("STKIMPORT_COMMENT_START", "", "<!--");
		setstring("STKIMPORT_COMMENT_END", "", "-->");
		setstring("STKIMPORT_COMMENT_PREVENT", "", "true");
		setstring("SCHILD_COMMENT_PREVENT", "", "true");

        // Schnelle CAD-Generierung immer angekreuzt
		// -Schu- 121008 nicht mehr nötig, da nur noch "Hohe Qualität"
		//setstring("IDC_WI_QUICK_CAD_CHECK", "", "true");
		setstring("IDC_WI_QUICK_CAD_CHECK", "", "false");

        // Sprache Kommunikation = aktuelle GUI-Sprache
        setstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS", getlanguage());
		
		// Tabellenhaeder mit korrektem Währungssymbol versehen
		setTablePriceHeaders();

        // In Vertriebsversion: Check ob Pfade erreichbar sind:
        if (getstring("VERSION","RIGHTS") == "SALESVERSION")
        {
            var strSapDataPath   = getstring( "CATALOG.SAP.DATAPATH", "" );
            var strSapProjPath   = getstring( "CATALOG.SAP.PROJEKTORDNER", "" );
            var strSapTransPath  = getstring( "CATALOG.SAP.TRANSFERORDNER", "" );
            var str3DCadDataPath = getstring( "CATALOG.3DCAD.DATAPATH", "" );
			if ( str3DCadDataPath.indexOf( "$TMP$" ) > -1 )
				str3DCadDataPath = str3DCadDataPath.replace( "$TMP$", getstddirectory( "TEMP" ) );
			else if ( str3DCadDataPath.indexOf( "$TEMP$" ) > -1 )
				str3DCadDataPath = str3DCadDataPath.replace( "$TEMP$", getstddirectory( "TEMP" ) );

            bSapUTF = 0;
            var strSapStringCoding = getstring( "CATALOG.SAP.CODING", "" );
            if (left(strSapStringCoding, 3) == "UTF")
                bSapUTF = 1;

            var strError = "";

			/* 22.1.2009: Auf Wunsch WI komplett entfernt !!!
            if (getstring("SAP_ENABLED", "RIGHTS") == "1")
            {
                if (!FileName.dirExists(strSapDataPath))
                {
                    // alert("SAP Datenpfad nicht erreichbar. Bitte Hr. Schmidsberger oder Sysadmin kontaktieren!");
                    // exitapp();
                    strError = replace(translate("MSG_ERR_SAP_PATH"), "#s#", strSapDataPath) + ".\n";
                }
                if (!FileName.dirExists(strSapProjPath))
                {
                    // alert("SAP Projektordner nicht erreichbar. Bitte Hr. Schmidsberger oder Sysadmin kontaktieren!");
                    // exitapp();
                    strError += replace(translate("MSG_ERR_SAP_FOLDER"), "#s#", strSapProjPath) + ".\n";
                }
            }
            if (!FileName.dirExists(str3DCadDataPath))
            {
                // alert("CAD Datenpfad nicht erreichbar. Bitte Hr. Schmidsberger oder Sysadmin kontaktieren!");
                // exitapp();
                strError += replace(translate("MSG_ERR_CAD_PATH"), "#s#", str3DCadDataPath) + ".\n";
                
            }

            if (strError != "")
            {
                strError += translate("MSG_SAP_NOT_AVAILABLE");
                alert(strError);
            }
			***********/

            // Prüfung des strSapTransPath hier noch nicht, würde Netlogin erfordern!

        }
    }

	if(getstring("PROJEKT_NEU_COMBO", "PROJECT.SETTINGS") == "")
		setstring("PROJEKT_NEU_COMBO", "PROJECT.SETTINGS", "IDD_FREI");
	
	//	if ((current_dlg == "index" ) || (current_dlg == "index2" )) {
	//  index2 hat anscheinend keine ID mehr, wir müssen das Event global abfangen ...
	
    // ... wird in run_catalog.b gesetzt:
    var strTCAfile = getstring ("CASCADE_START_TCA", "TMP");
    var strFINfile = getstring ("CASCADE_START_FIN", "TMP");

    // Dialog aus C++ setzen geht nicht mehr...
    // (getstring("visaction", "") != "") geht auch nicht, weil c++ anscheinend nachher läuft ...
    // if ((event == "") && (current_dlg == "") && (getstring("CASCADE_START_VIS_ACTION", "TMP") != ""))
    //   new_dlg = "IDD_PROJECTLISTE";
	
	/*
	if( current_dlg == "" && event == "" && start_dlg == "IDD_START" && getstring("CRMQUOTEID", "ROOT.START_PARAM") != "" && getstring("CRMACTION", "ROOT.START_PARAM") != "" && getstring("CRMUSER", "ROOT.START_PARAM") != "")
	{
		new_dlg="IDD_PROJECTLISTE";
		current_dlg="IDD_START";
	}
	else */
	
	//if ((event == "IDC_CASCADE_TCAIMPORT") || (strTCAfile != ""))
	if (startScreen == "ms")
		new_dlg = "IDD_MS_AUSWAHL";
	else if (startScreen == "mb")
		new_dlg = "IDD_MB_AUSWAHL";
	else if (startScreen == "rh")
		new_dlg = "IDD_RH_AUSWAHL";
	else if (startScreen == "kp")
		new_dlg = "IDD_KP_AUSWAHL";
    else if ((event == "IDC_CASCADE_TCAIMPORT") || (strTCAfile != ""))
	{
        if (importTCAfile(strTCAfile))
        {
            setstring("OPEN_MODE_CASCADE", "", "NEW");
            new_dlg = "index2";
        }
        // else
        //    new_dlg=start_dlg;
        setstring ("CASCADE_START_TCA", "TMP", "");  // damit wir hier nicht in eine Endlosschleife geraten!
	}
	else if ((event == "IDC_CASCADE_PDSIMPORT") || 
             (event == "START_NEW_FIN_IMPORT") || 
             (strFINfile != ""))
	{
        if (event == "START_NEW_FIN_IMPORT")
        {
            strFINfile = getstring("REQFILE", "ROOT");
        }
		var eksPathImport = "TEMP.STK_SINGLE_IMPORT_AREA";
        delete("", "DLGDATA");
		delete(eksPathImport, "");
		var bRet = importSTKfileToArray(strFINfile, eksPathImport);
		if (bRet)
			bRet = setSTKdataToDlgAbsPath(eksPathImport, "FIN");

		if (bRet == 1)
        {
            setstring("OPEN_MODE_CASCADE", "", "NEW");
            new_dlg = "index2";
            // new_dlg = startCascadeLastkette();  auskommentiert, weil da sonst die Dialogdaten wieder weggelöscht werden
        }
        else if (bRet == 2)
        {
            setstring( "OPEN_MODE_CASCADE", "", "LAGER" );
            new_dlg = "index2";
            // new_dlg = startCascadeLager();
        }    
        setstring ("CASCADE_START_FIN", "TMP", "");  // damit wir hier nicht in eine Endlosschleife geraten!
	}
    else if (event == "IDC_CASCADE_MASS")
	{
        exportMass();
	}
	else if(event=="IDC_HOME")
	{
		new_dlg=start_dlg;
	}
	else if(event == "IDD_UPDATE")
	{
		new_dlg="IDD_UPDATE";		
	}
	// das soll es so nicht geben
	/*
	else if((event == "IDC_LOCAL_UPDATE_WI")
			|| (event == "IDC_UPDATE_BUT" && getstring ("WI_NETWORK", "AUTOUPDATE") == "true")
			)
	{
		if (FileName.addNetConnection(getstring( "CATALOG.SAP.TRANSFERORDNER", "" ), getstring( "GATE_USER", "AUTOUPDATE" ), getstring( "GATE_PASS", "AUTOUPDATE" )) == ""
			&&
			FileName.fileExists("C:\\DATA\\TEMP\\FL_UPD\\FLEXPERTE\\" + getstring( "UPDATE_FILE_NAME", "AUTOUPDATE" ) + ""))	// TEST
			//FileName.fileExists(getstring( "CATALOG.SAP.TRANSFERORDNER", "" ) + "\\FL_UPD\\" + getstring( "UPDATE_FILE_NAME", "AUTOUPDATE" ) + ""))	// Ernstfall
		{
			var catalogName	= getstring( 'CATALOG.NAME', 'ROOT' );
			var UpdateFile	= replace( "C:\\DATA\\TEMP\\FL_UPD\\FLEXPERTE\\" + getstring( "UPDATE_FILE_NAME", "AUTOUPDATE" ) + "", '\\', '/' );	// TEST
			//var UpdateFile	= replace( getstring( "CATALOG.SAP.TRANSFERORDNER", "" ) + "\\FL_UPD\\" + getstring( "UPDATE_FILE_NAME", "AUTOUPDATE" ) + "", '\\', '/' );	// Ernstfall
			var param = '';
			param += " --url=file:///" + UpdateFile;			// Link zum Installer 
			param += " --close-pid=" + getcurrentprocessid();	// Diesen Process noch vor dem Start des Installers 
			param += " --kill-timeout=60000"					// Nach max. 60s den Prozess töten (TerminateProcess)
			param += " --window-title=" + '"' + catalogName + '"';	// EasyKat Name (spez.)
			param += " --extract-to=./";
			//param += " --shell-exec=SytronixSize.exe";
			param += " --shell-exec=Flexperte.exe";
			
			shellexecuteex( getstddirectory( "PROGRAM" ) + "netupd.exe", param, "", 1 );
		}
		else
			new_dlg=start_dlg;
	}
	*/
	else if(event=="IDC_CASCADE_ABORT")
	{
		new_dlg="IDD_PROJECTLISTE";
        // Sonderfall Aufruf aus PDS / PDMS - System: Wir müssen eine Datei schreiben als Hinweis an PDS, dass die Auswahl abgebrochen wurde
        var outFile = getstring("OUTFILE", "ROOT");
        if (outFile != "")
        {
            writefile( outFile, "FLEXPERTE ERROR: User aborted selection.\r\n", "wc" );   // Damit die Datei neu erzeugt wird
        }
	}
	else if(event=="IDC_BASKET")
	{
		// setstring("CASCADE_EVENT","","TO_PROJECTLIST");
		new_dlg="IDD_PROJECTLISTE";
	}
	else if(event=="CLOSE_PROGRAM")
    {
		setstring("PROJ_MODIFIED_FLAG", "PROJECT.SETTINGS", "");
        exitapp();
		terminateprocess(getcurrentprocessid()); // -HACK- Entfernen wenn "window.close()" wieder richtig funktioniert
    }
	else if(event=="IDC_CASCADE_SETTINGS_P")
    {
        new_dlg="IDD_CASCADE_SETTINGS";
        setstring("CASCADE_SETTINGS_RETURN_DLG", "TMP", "IDD_PROJECTLISTE");
        copy("PROJECT.SETTINGS.CASCADE", "TMP.CASETTINGSSAVE");
    }
    else if(event=="IDC_CASCADE_SETTINGS_R")
    {
        new_dlg="IDD_CASCADE_SETTINGS";
        setstring("CASCADE_SETTINGS_RETURN_DLG", "TMP", "IDD_RH_AUSWAHL");
        copy("PROJECT.SETTINGS.CASCADE", "TMP.CASETTINGSSAVE");
    }
    else if ( event == "IDC_START_CASCADE" )
    {
		new_dlg = startCascadeLastkette();
    }
	
	//////////////////////////////////////////////////////////////////
	// KANN ENTFALLEN WENN NEUIMPLEMENTIERUNG FERTIG IST
	else if ( event == "IDC_START_CASCADE_LAGER")
	{
		new_dlg = startCascadeLager();
	}
	//ENDE
	//////////////////////////////////////////////////////////////////
	
	else if(event == "IDC_START_CASCADE_LAGER_2011")
		new_dlg = startCascadeLager2011();
	
	else if(event == "IDC_LAGER_BUT")					new_dlg="IDD_RH_AUSWAHL";
    else if(event == "IDC_SCHLAUCH_BUT")				new_dlg="IDD_MS_AUSWAHL";
    else if(event == "IDC_KOMPENSATOREN_BUT")			new_dlg="IDD_KP_AUSWAHL";
    else if(event == "IDC_BAELGE_BUT")					new_dlg="IDD_MB_BETRIEBSDATEN";	// new_dlg="IDD_MB_AUSWAHL";
    //else if(current_dlg=="IDD_START")
	else if((current_dlg=="IDD_START") && (event != "IDC_LOCAL_UPDATE"))	// für den Fall des Local Updates darf er hier nicht reinlaufen
	{
		if(event=="IDC_SHOPPING_BUT")					new_dlg="IDD_WARENKORB";
		if(event=="IDC_PROJEKTLISTE_BUT")				new_dlg="IDD_PROJECTLISTE";
		#if(event=="IDC_METALLSCHLAEUCHE_EINSTIEG_BUT")	new_dlg="IDD_MSWS_AUSWAHL";
		if(event=="IDC_KOMPENSATOREN_EINSTIEG_BUT")		new_dlg="IDD_KP_AUSWAHL";
		if(event=="IDC_METALLBAELGE_EINSTIEG_BUT")		new_dlg="IDD_MB_AUSWAHL";
		if(event=="IDC_LAGER_EINSTIEG_BUT")				new_dlg="IDD_RH_AUSWAHL";
		if(event=="IDC_METALLSCHLAEUCHE_EINSTIEG_BUT")	new_dlg="IDD_MS_AUSWAHL";
		if(event=="IDC_UPDATE_EINSTIEG_BUT")			new_dlg="IDD_UPDATE";
		if(event=="IDC_UPDATE_BUT")						new_dlg="IDD_UPDATE";

        if(event=="IDC_SPRACHE_COMBO")
        {
            // Wenn Sprache umgeschaltet, dann auch Sprache Kommunikation umschalten
            var strSprache = getstring("EKCURRENTLANGUAGE", "");
            setstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS", strSprache);

			// Tabellenhaeder in die richtige Sprache bringen
			setlanguage(getstring("EKCURRENTLANGUAGE", ""));	// Weil sonst die neue Sprache erst beim Erzeugen des neuen Screens gesetzt wird, d.h. zu spät für hier
			setTablePriceHeaders();
        }

		// @@@@@
		//specialexec( "EK_SetMeasurementSystem" );
	}
	else if (current_dlg=="IDD_CASCADE_SETTINGS")
	{
        if (event=="IDC_SPEICHERN_BUT")
        {
            setCascadeSettingsToIni();
        }
        if (event=="IDC_STANDARDS_BUT")
        {
            setDefaultCascadeSettings();
        }

        if (event=="IDC_ANWENDEN_BUT")
        {
            invalidiereZeichnungen();
            new_dlg = getstring("CASCADE_SETTINGS_RETURN_DLG", "TMP");
			CheckRabates();
			event = "RECALC_AG_TEXTBLOCK";
        }

        if (event=="IDC_ABBRECHEN_BUT")
        {
            copy("TMP.CASETTINGSSAVE", "PROJECT.SETTINGS.CASCADE");
            new_dlg = getstring("CASCADE_SETTINGS_RETURN_DLG", "TMP");
        }
    }
	else if (current_dlg=="IDD_MB_AUSWAHL")
	{
		if(event=="IDC_BETRIEBSBEDINGUNGEN_BUT")		new_dlg="IDD_MB_BETRIEBSDATEN";
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_START";
	}
	else if ((current_dlg=="IDD_UPDATE" ) || ((current_dlg=="IDD_START") && (event == "IDC_LOCAL_UPDATE")))
	{
		if(event=="IDC_MAIN_BUT")						new_dlg="IDD_START";

		if ( event === 'IDC_LOCAL_UPDATE' )
		{
			var str7zFile = filedialog( 1, '7z', '', 'Update-Files|*.7z;*.7Z||', '' );
			if ( str7zFile != "" )
			{
				var catalogName = getstring( 'CATALOG.NAME', 'ROOT' );
				str7zFile = replace( str7zFile, '\\', '/' );

				var param = '';
				param += " --url=file:///" + str7zFile;				// Link zum Installer 
				//param += " --no-cache";							// Keinen Datei auch dem Cache
				//param += " --exec";								// Den Installer automatisch starten
				param += " --close-pid=" + getcurrentprocessid();	// Diesen Process noch vor dem Start des Installers 
				//param += " --close-name=' + "SytronixSize.exe";	// beenden (WM_CLOSE).
				param += " --kill-timeout=60000"					// Nach max. 60s den Prozess töten (TerminateProcess)
				param += " --window-title=" + '"' + catalogName + '"';	// EasyKat Name (spez.)
				param += " --extract-to=./";
				//param += " --shell-exec=SytronixSize.exe";
				param += " --shell-exec=Flexperte.exe";
				
				var INFO	= shellexecuteex( getstddirectory( "PROGRAM" ) + "netupd.exe", param, "", 1 );
				
				if (FileName.fileExists(getstddirectory( "PROGRAM" ) + "Info.pdf"))
					shellexecuteex( getstddirectory( "PROGRAM" ) + "Info.pdf", "", "", 1 );
			}
		}
		
	}
	else if (current_dlg=="IDD_MB_BETRIEBSDATEN")
	{
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_MB_AUSWAHL";
		if(event=="IDC_WEITER_BUT")						new_dlg="IDD_MB_ERGAENZEN";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";
	}
	else if (current_dlg=="IDD_MB_ERGAENZEN")
	{
		if(event=="IDD_MB_BETRIEBSDATEN")				new_dlg="IDD_MB_BETRIEBSDATEN";
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_MB_BETRIEBSDATEN";
		if(event=="IDC_ABBRECHEN_BUT")					new_dlg="IDD_START";
		if(event=="IDC_UEBERNEHMEN_BUT")				new_dlg="IDD_PROJECTLISTE";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";
	}
	else if (current_dlg=="IDD_RH_AUSWAHL")
	{
		if(event=="IDC_TYP_BUT")						new_dlg="IDD_RH_AUSWAHL_ART";
		if(event=="IDC_BETRIEBSBEDINGUNGEN_BUT")		new_dlg="IDD_RH_AUSWAHL_BETRIEB_PARAMETER";
		if(event=="IDC_KLEMMSYSTEM_BUT")				new_dlg="IDD_RH_AUSWAHL_KLEMMSYS";
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_START";
		if(event=="IDC_PROJEKTLISTE_BUT")				new_dlg="IDD_PROJECTLISTE";

	// Button Tools
		if(event=="IDC_TOOLS_BUT")
		{
			var strSQLStatement;
			var strNennweite, strRAD, strNennweitenCombo, strAussendurchmesserCombo;
			//strSQLStatement = "SELECT DN, RAD FROM NENNWEITEN";
			strSQLStatement = "SELECT DN, D FROM NENNWEITEN";
			//var numRet = dbselect("LAGER", strSQLStatement, "NENNWEITE");
			var numRet = dbselect("LAGER2", strSQLStatement, "NENNWEITE");
			if(numRet > 0)
			{
				// gehe in Dialog
				new_dlg="IDD_RH_TOOLS";

				while (dbiseof("NENNWEITE") == 0)
				{
					strNennweite = dbgetdouble("NENNWEITE", "DN");
					//strRAD = dbgetdouble("NENNWEITE", "RAD");
					strRAD = dbgetdouble("NENNWEITE", "D");
					strNennweitenCombo = strNennweitenCombo + "ID_" + strNennweite + "=DN " + strNennweite + "|"
					strAussendurchmesserCombo = strAussendurchmesserCombo + "ID_" + strNennweite + "=" + strRAD + " mm" + "|"
					dbskip("NENNWEITE");
				}
				strNennweitenCombo = left(strNennweitenCombo, strlen(strNennweitenCombo)-1);
				strAussendurchmesserCombo = left(strAussendurchmesserCombo, strlen(strAussendurchmesserCombo)-1);
				setstring("NENNWEITE_ITEMS", "DLGDATA.RH.AUSLEGUNG", strNennweitenCombo);
				setstring("AUSSENDURCH_ITEMS", "DLGDATA.RH.AUSLEGUNG", strAussendurchmesserCombo);
				setstring("DATENBLATT_FILENAME", "DLGDATA.RH.AUSLEGUNG", "");
			}
			else
				setstring("ERRORMESSAGE", "TEMP", replace(translate("MSG_NODATA_TABLE"), "#s#", "NENNWEITEN"));
		}
	}
	else if (current_dlg=="IDD_RH_TOOLS")
	{
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_RH_AUSWAHL";
        
        if(event=="IDC_DATENBLATT_BUT")
            bereiteRHToolsDablaVor();
	}
	else if (current_dlg=="IDD_KP_AUSWAHL")
	{
		if(event=="IDC_TYP_BUT")						new_dlg="IDD_KP_AUSWAHLTYP";
		if(event=="IDC_BETRIEBSBEDINGUNGEN_BUT")		new_dlg="IDD_KP_BETRIEBSDATEN";
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_START";
	}
	else if (current_dlg=="IDD_KP_AUSWAHLTYP")
	{
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_KP_AUSWAHL";
		if(event=="IDC_WEITER_BUT")						new_dlg="IDD_KP_ERGAENZEN";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";
	}
	else if (current_dlg=="IDD_KP_BETRIEBSDATEN")
	{
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_KP_AUSWAHL";
		if(event=="IDC_WEITER_BUT")						new_dlg="IDD_KP_ERGAENZEN";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";
	}
	else if (current_dlg=="IDD_KP_ERGAENZEN")
	{
		if(event=="IDD_KP_BETRIEBSDATEN")				new_dlg="IDD_KP_BETRIEBSDATEN";
		if(event=="IDD_KP_AUSWAHLTYP")					new_dlg="IDD_KP_AUSWAHLTYP";
		if(event=="IDC_ABBRECHEN_BUT")					new_dlg="IDD_START";
		if(event=="IDC_UEBERNEHMEN_BUT")				new_dlg="IDD_PROJECTLISTE";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";
		if(event=="IDC_ZURUECK_BUT")
		 {
			 if (getstring("AUSWAHLWEG","DLGDATA.KP.AUSLEGUNG") == "AUSWAHL_BETRIEBSDATEN" )
			 	new_dlg="IDD_KP_BETRIEBSDATEN";
			 else
				new_dlg="IDD_KP_AUSWAHLTYP";
		 }
	}
	else if (current_dlg=="IDD_MS_AUSWAHL")
	{
		setstring("MS_FLAG_DRUVERLU_ONLY", "DLGDATA", "false");
		if(event=="IDC_TYP_BUT")						new_dlg="IDD_MS_TYPEN_SCHLAEUCHE";
		if(event=="IDC_BETRIEBSBEDINGUNGEN_BUT")		new_dlg="IDD_MS_BETRIEBSDATEN";
		if(event=="IDC_EINSATZFALL_BUT")				new_dlg="IDD_MS_EINSATZFALL";
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_START";
	// Wickelschläuche:
		var WSAllowed = "true"
		if (WSAllowed == "true")
		{
			if(event=="IDC_BUTTON_SCHUTZSCHLAUCH")			new_dlg="IDD_WS_TYPEN_SCHLAEUCHE";
			if(event=="IDC_BUTTON_ABGASSCHLAUCH")			new_dlg="IDD_WS_TYPEN_SCHLAEUCHE";
			if(event=="IDC_BUTTON_FOERDERSCHLAUCH")			new_dlg="IDD_WS_TYPEN_SCHLAEUCHE";

			if(event=="IDC_BUTTON_SCHUTZSCHLAUCH")			setstring("SCHLAUCHART", "DLGDATA.WS", "SS");
			if(event=="IDC_BUTTON_ABGASSCHLAUCH")			setstring("SCHLAUCHART", "DLGDATA.WS", "SGA");
			if(event=="IDC_BUTTON_FOERDERSCHLAUCH")			setstring("SCHLAUCHART", "DLGDATA.WS", "FS");

			if (new_dlg == "IDD_WS_TYPEN_SCHLAEUCHE")
			{
				delete("RESULT_TABLE",						"DLGDATA.WS.TYPEN_SCHLAEUCHE");
				delete("RESULTLISTE_WS_SCHLAUCH_SELECTED",	"DLGDATA.WS.TYPEN_SCHLAEUCHE");
			}
		}
		//if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_MSWS_AUSWAHL";
	}
	else if (current_dlg=="IDD_MS_TYPEN_SCHLAEUCHE")
	{
		setstring("MS_FLAG_DRUVERLU_ONLY", "DLGDATA", "false");
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_MS_AUSWAHL";
		if(event=="IDC_UEBERNEHMEN_BUT")				new_dlg="IDD_MS_TYPEN_ANSCHLUESSE";
		if(event=="IDC_ANSCHLUESSE_BUT")				new_dlg="IDD_MS_TYPEN_ANSCHLUESSE";
		if(event=="IDC_DRUVERLU_BUT")	{
														new_dlg="IDD_MS_ERGAENZEN";
			scriptexec("MS_PREP_ERGAENZEN");
            scriptexec("MS_INIT_ZUBEHOER");														
			setstring("MS_FLAG_DRUVERLU_ONLY", "DLGDATA", "true");
			setstring("TYP_AT", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS", "");
			setstring("TYP_AT", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS", "");
			setstring("DRUVERL_NENNLAENGE", "DLGDATA.MS.AUSLEGUNG", "1000");
		}
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";
		
	}
	else if (current_dlg=="IDD_MS_BETRIEBSDATEN")
	{
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_MS_AUSWAHL";
		if(event=="IDC_UEBERNEHMEN_BUT")				new_dlg="IDD_MS_TYPEN_ANSCHLUESSE";
		if(event=="IDC_ANSCHLUESSE_BUT")				new_dlg="IDD_MS_TYPEN_ANSCHLUESSE";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";
	}
	else if (current_dlg=="IDD_MS_EINSATZFALL")
	{
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_MS_AUSWAHL";
		if(event=="IDC_UEBERNEHMEN_BUT")				new_dlg="IDD_MS_TYPEN_ANSCHLUESSE";
		if(event=="IDC_ANSCHLUESSE_BUT")				new_dlg="IDD_MS_TYPEN_ANSCHLUESSE";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";
	}
	else if (current_dlg=="IDD_MS_TYPEN_ANSCHLUESSE")
	{
		if(event=="IDD_MS_EINSATZFALL")					new_dlg="IDD_MS_EINSATZFALL";
		if(event=="IDD_MS_BETRIEBSDATEN")				new_dlg="IDD_MS_BETRIEBSDATEN";
		if(event=="IDD_MS_TYPEN_SCHLAEUCHE")			new_dlg="IDD_MS_TYPEN_SCHLAEUCHE";
		if(event=="IDC_ZURUECK_BUT")
		{
			//new_dlg="GOBACK"
			var strAuswahlweg = getstring("AUSWAHLWEG","DLGDATA.MS.AUSLEGUNG");
			if (strAuswahlweg == "AUSWAHL_EINSATZFALL")		new_dlg = "IDD_MS_EINSATZFALL";
			if (strAuswahlweg == "AUSWAHL_BETRIEBSDATEN")	new_dlg = "IDD_MS_BETRIEBSDATEN";
			if (strAuswahlweg == "AUSWAHL_NENNDATEN") 		new_dlg = "IDD_MS_TYPEN_SCHLAEUCHE";
		}
		if(event=="IDC_WEITER_BUT")
		{
			new_dlg="IDD_MS_ERGAENZEN";

			var dNennLaenge	= gettechval("NENNLAENGE",	"DLGDATA.MS.AUSLEGUNG", "MM","LAENGE");
			setstring("DRUVERL_NENNLAENGE", "DLGDATA.MS.AUSLEGUNG", "" + dNennLaenge);

			scriptexec("MS_PREP_ERGAENZEN");
            scriptexec("MS_INIT_ZUBEHOER");
		}
		if(event=="IDC_UEBERNEHMEN_BUT")				new_dlg="IDD_PROJECTLISTE";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";
	}
	else if (current_dlg=="IDD_MS_ERGAENZEN")
	{
		if(event=="IDC_ZURUECK_BUT")					{
			if (getstring("MS_FLAG_DRUVERLU_ONLY", "DLGDATA") == "true")
														new_dlg="IDD_MS_TYPEN_SCHLAEUCHE";
			else
														new_dlg="IDD_MS_TYPEN_ANSCHLUESSE";
		}
		if(event=="IDC_ABBRECHEN_BUT")					new_dlg="IDD_START";
		if(event=="IDC_UEBERNEHMEN_BUT")				new_dlg="IDD_PROJECTLISTE";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_PROJECTLISTE";

        scriptexec("MS_DRUCKVERLUST_INIT_DLG");
        scriptexec("MS_INIT_ZUBEHOER");

		if(event=="IDC_CALCSTOFFDATEN_BUT")
			ms_calcstoffdaten(true);	// scriptexec("MS_CALCSTOFFDATEN");
		if(event=="IDC_NENNWEITE_COMBO")
			scriptexec("MS_DRUVERL_INIT_NENNWEITE");
		if(event=="IDC_CALCDRUCKVERLUST_BUT")
			ms_calcdruckverlust(); 	// scriptexec("MS_CALCDRUCKVERLUST");
		if(event=="IDC_AUSDRUCK_DRUCKVERLUST")
			specialexec("MS_PrintDruckverlust");
		else
			setstring("DRUCKVERLUST_FILENAME","DLGDATA.MS.AUSLEGUNG", "");
	}
	else if (current_dlg=="IDD_FREIE_POSITION")
	{
		if (event != "IDC_ZMARKIERUNG_EDIT")
			new_dlg="IDD_PROJECTLISTE";
		else
			setstring("ZMARKIERUNG", "DLGDATA.FP", getstring("IDC_ZMARKIERUNG_EDIT", "IDD_FREIE_POSITION"));
		if(event=="IDC_UEBERNEHMEN_BUT")
			scriptexec("FREIE_POSITION_ADD");
	}
	else if (current_dlg=="IDD_PROJECTLISTE")
	{
		setSinglePropertyToIni("UNTERSTUETZUNG_PDF_CHECK", getstring("UNTERSTUETZUNG_PDF_CHECK",""));
		
		if (event=="*.RH_MENU_ON_OFF_CHECK")
		{
			bRHMenu = true;
			if (getstring("RH_MENU_ON_OFF_CHECK","") != "true")
				bRHMenu = false;

			setstring("PREVENT_OUTPUT_RH_SETTINGS","RIGHTS", "true");
			// setstring("PREVENT_OUTPUT_RH_IMEXPORT","RIGHTS", "true");
			setstring("PREVENT_OUTPUT_RH_ANALYSE","RIGHTS", "true");
			if (bRHMenu)
			{
				setstring("PREVENT_OUTPUT_RH_SETTINGS","RIGHTS", "false");
				// if (getstring("CATALOG.INTERNETSERVERINCDMODE","") == "true")  // CD-Version
				//  	setstring("PREVENT_OUTPUT_RH_IMEXPORT","RIGHTS", "false");
				if (getstring("EXPERT_MODE", "RIGHTS") == "1")
					setstring("PREVENT_OUTPUT_RH_ANALYSE","RIGHTS", "false");
			}
			setSinglePropertyToIni("RH_MENU_ON_OFF_CHECK", getstring("RH_MENU_ON_OFF_CHECK",""));
		}
		if(event=="IDC_AUSWAHL_NEU_BUT")
		{
			new_dlg="IDD_START";
            var strTyp = getstring("PROJEKT_NEU_COMBO", "PROJECT.SETTINGS");
			if(strTyp == "") strTyp = "IDD_RH";
			switch(strTyp)
			{
				case "IDD_MS":
					new_dlg = "IDD_MS_AUSWAHL";
					prefs.ZUBEHOER_EVENT = "PROJECTLIST_CHANGE";
					break;
				case "IDD_KP":
					new_dlg = "IDD_KP_AUSWAHL";
					break;
				case "IDD_MB":
					new_dlg = "IDD_MB_AUSWAHL";
					break;
				case "IDD_RH":
					new_dlg = startCascadeLastkette();
					break;
				case "IDD_RHL":
					//new_dlg = startCascadeLager();
					new_dlg = startCascadeLager2011();
					break;
				case "IDD_FREI":
					new_dlg = "IDD_FREIE_POSITION";
					delete("FP", "DLGDATA");
                    setstring("CUSTOMER_CODE", "DLGDATA", "");
                    setstring("QTY", "DLGDATA", "1");
                    setstring("POS", "DLGDATA", "");
					break;
			}
		}
        if(event=="IDC_NEUESPROJEKT_BUT")
        {
            // Cascade-Standard-Settings herstellen!
            setCascadeSettingsFromIni();
			// Tabellenhaeder mit korrektem Währungssymbol versehen
			setTablePriceHeaders();
        }
		// Das hier wird und muss nach dem Laden in C++ aufgerufen werden!
		if(event=="IDC_LADEN_BUT")
		{
			// Tabellenhaeder mit korrektem Währungssymbol versehen
			setTablePriceHeaders();
			CheckRabates();
		}
		// -mw- 2012-10-30 neu: Laden von Projekten komplett im Skript, damit wir
		// das Laden älterer Projektdateien unterbinden können:
		
		if(event=="IDC_LADEN_BUT_NEU")
		{
			if (getstring("CATALOG.INTERNETSERVERINCDMODE","") == "true")  // Alles nur für CD-Version
			{
				// Projekt erst einmal in einen Temp-Bereich schreiben, um die Version zu prüfen ...
				delete("PROJECT", "TEMP");
				//f
				var Datei = filedialog(1, "wit", "", "Flexperte-Projekt (*.wit)|*.wit|All Files(*.*)|*.*|", "");
				//var Datei = filedialog(1, "wit", "", "Flexperte-Projekt (*.wit)|*.wit|All Files(*.*)|*.*|", "C:");
				
				if (Datei != "")
				{
					// lese Datei nach ProjectlistImport
					loadxml("TEMP.IMPORT", Datei, "true");
					
					if (check_Version(getstring("TEMP.IMPORT.PROJECTFILEVERSION.MAJOR",""),getstring("TEMP.IMPORT.PROJECTFILEVERSION.MINOR","")))
					{
						setstring("TEMP.ERRORMESSAGE", "", translate("ERROR_PROJEKTDATEI_LADEN_ALTE_VERSION"));		
					}
					else
					
					{
						// lese Datei in den normalen Pfad
						loadxml("PROJECT", Datei, "true");
						
						if (getbool("CLIENTVERSION", "RIGHTS")){	// tw. feste Rabatte in VC -> falsch!!!
							DeleteRabates();
						}
						
						setstring("PROJECT.PROJECTPATH", "", Datei);
						setstring("PROJECT.SETTINGS.PROJ_MODIFIED_FLAG", "", "");
						// Aus C++ ... leider keine Funktin im Skript dafür ....
						//ProjectRebuildTexts(sto);
						
						// Tabellenhaeder mit korrektem Währungssymbol versehen
						setTablePriceHeaders();
						CheckRabates();
					}				
				}
			}
		}
        if(event=="IDC_WI_ANGEBOTSNR_EDIT")
        {
            // Muss auch passieren bei vielen anderen Feldern ... besser erstmal
            // lokal "dirty" machen?
            invalidiereZeichnungen();
        }
		if(event=="IDC_SORT_MARKIERUNG_BUT")
		{
			doSortMarkierung();
		}
		
		if(event=="IDD_MS_TYPEN_ANSCHLUESSE")			new_dlg="IDD_MS_TYPEN_ANSCHLUESSE";
		if(event=="IDD_MS_ERGAENZEN")
		{
		    new_dlg="IDD_MS_ERGAENZEN";
            prefs.ZUBEHOER_EVENT = "PROJECTLIST_CHANGE";
		}
		if(event=="IDD_KP_ERGAENZEN")					new_dlg="IDD_KP_ERGAENZEN";
		if(event=="IDD_MB_ERGAENZEN")					new_dlg="IDD_MB_ERGAENZEN";
		if(event=="IDD_RH_ERGAENZEN")					new_dlg="IDD_RH_ERGAENZEN";
		if(event=="IDD_RH_AUSWAHL_KLEMMSYS")			new_dlg="IDD_RH_AUSWAHL_KLEMMSYS";
		if(event=="IDD_WS_TYPEN_ANSCHLUESSE")			new_dlg="IDD_WS_TYPEN_ANSCHLUESSE";
		if(event=="IDD_FREIE_POSITION")			        new_dlg="IDD_FREIE_POSITION";
		if(event=="IDD_TYPNUMMER")
		{
			setstring("ERRORMESSAGE", "TEMP", translate("ERR_CHANGEPOSITION"));
        }
		if(event=="IDD_CASCADE")
		{
		    new_dlg="index2";
            setstring("OPEN_MODE_CASCADE", "", "MODIFY");
		}
		if(event=="IDC_ZURUECK_BUT")					new_dlg="GOBACK";
		if(event=="IDC_MAIN_BUT")						new_dlg="IDD_START";
        if(event=="IDC_PREISE_AKTUALISIEREN_BUT")
        {
			doAktualisierung();
        }
        if((event=="IDC_SELECT_ALL_BUT") || (event=="IDC_SELECT_NONE_BUT"))
        {
            var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
            var nLastPos	    = getsize(Projectlist, "") - 1;
            var Source, i;
            var strSelect = "true";
            if (event=="IDC_SELECT_NONE_BUT")
                strSelect = "false";
            for (i = 0; i <= nLastPos; ++i)
            {
                Source = Projectlist + "[" + i + "]";
                setstring("SAP_CHECK", Source, strSelect);
            }
        }
	
	// Export von Positionen in einzelne WIT-Files
	//-----------------------------------
		if(event=="IDC_SPLIT_WIT")
		{
			delete("PROJECT", "TEMP");
			var Source, Target, strPos, i;
			var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
			var ProjectlistExport = "TEMP.PROJECT.POSITIONS.PROJECTLIST_ITEMS";
			var nLastPos = getsize(Projectlist, "") - 1;
			var nAnz = 0;
			
			var strPresetOrdner = getstring("EXPORT_STK_VERZEICHNIS", "");
			var Ordner = dirdialog(translate("MSG_DLG_STK_EXPORT"), strPresetOrdner);   
			if (Ordner != "")
			{
				if (right(Ordner, 1) != "\\")
					Ordner += "\\";
				
				setstring("EXPORT_STK_VERZEICHNIS", "", Ordner);
				
				for (i = 0; i <= nLastPos; ++i)
				{
					Source = Projectlist + "[" + i + "]";
					if(getstring("SAP_CHECK", Source) != "true")
						continue;
					Target = ProjectlistExport + "[0]";
					nAnz++;
					copy(Source, Target);
					strPos ="10";
					setstring("POS", Target, strPos);
					copy("PROJECT.SETTINGS", "TEMP.PROJECT.SETTINGS");
					copy("CATALOG.PROJECTFILEVERSION", "TEMP.PROJECT.PROJECTFILEVERSION");		// aktuelle Fileversion steht in Catalog
					var Mark	= trimright(trimleft(getstring("MARKIERUNG", Target), " "), " ");
					var Datei	= (Mark != "" ? Mark : "OriPos_" + getstring("POS", Source)) + ".wit";
					savexml("TEMP.PROJECT", Ordner + Datei, "true");
					delete("PROJECT", "TEMP");
				}
			}
		}
	
	// Export von Positionen
	//-----------------------------------
		if(event=="IDC_STARTEXPORT_BUT")
		{
			delete("PROJECT", "TEMP");

			var Source, Target, strPos, i;
			var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
			var ProjectlistExport = "TEMP.PROJECT.POSITIONS.PROJECTLIST_ITEMS";
			var nLastPos = getsize(Projectlist, "") - 1;
			var nAnz = 0;
			for (i = 0; i <= nLastPos; ++i)
			{
				Source = Projectlist + "[" + i + "]";
				if(getstring("SAP_CHECK", Source) != "true")
					continue;
				Target = ProjectlistExport + "[" + nAnz + "]";
				nAnz++;
				copy(Source, Target);
				strPos =""+(nAnz*10);		// + trimNumbersLeft(getstring("POS", Source));
				setstring("POS", Target, strPos);
				setstring("SAP_CHECK", Target, "false");
			}
			// nichts markiert
			if (nAnz == 0)
			{
				setstring("ERRORMESSAGE", "TEMP", translate("ERR_NOPOSITION"));
				return current_dlg;
			}

			//var Datei = filedialog(0, "wit", "projekt.wit", "Flexperte-Projekt (*.wit)|*.wit|All Files(*.*)|*.*|", "C:");
			var Datei = filedialog(0, "wit", "projekt.wit", "Flexperte-Projekt (*.wit)|*.wit|All Files(*.*)|*.*|", "");
			
			if (Datei == "")
				return current_dlg;

			copy("PROJECT.SETTINGS", "TEMP.PROJECT.SETTINGS");
			copy("CATALOG.PROJECTFILEVERSION", "TEMP.PROJECT.PROJECTFILEVERSION");		// aktuelle Fileversion steht in Catalog

			// schreibe ProjectlistExport
			savexml("TEMP.PROJECT", Datei, "true");

			delete("PROJECT", "TEMP");

			if(nAnz == 1)
			{
				setstring("ERRORMESSAGE", "TEMP", translate("MSG_EXPORT_1POS"));
			}
			else
			{
				setstring("ERRORMESSAGE", "TEMP", replace(translate("MSG_EXPORT_NPOS"), "#x#", nAnz));
			}
		}

	// Import von Positionen
	//-----------------------------------
	// Importdatei bzw. Importpfad festlegen
		if(event=="IDC_IMPORT_FILE_BUT" || event=="IDC_IMPORT_FOLDER_BUT")
		{
			delete("PROJECT", "TEMP");
		
			var bOk	= true;
			
			if(event=="IDC_IMPORT_FILE_BUT"){
				//var Datei = filedialog(1, "wit", "", "Flexperte-Projekt (*.wit)|*.wit|All Files(*.*)|*.*|", "C:");
				var Datei = filedialog(1, "wit", "", "Flexperte-Projekt (*.wit)|*.wit|All Files(*.*)|*.*|", "");
				if (Datei == "")
					return current_dlg;

				
				setstring("IMPORT_FILE_NAME", "TEMP", Datei);
				
				// lese Datei nach ProjectlistImport
				loadxml("TEMP.IMPORT", Datei, "true");
			
				// Prüfen ob die Importdatei zu FLEXPERTE-Version kompatibel ist
				
				if (check_Version(getstring("TEMP.IMPORT.PROJECTFILEVERSION.MAJOR",""),getstring("TEMP.IMPORT.PROJECTFILEVERSION.MINOR","")))
				{
					setstring("TEMP.ERRORMESSAGE", "", translate("ERROR_PROJEKTDATEI_LADEN_ALTE_VERSION"));
					bOk	= false;
				}
			}
			else{
				var WIT_DIR	= dirdialog("Ordner wählen", "");
				if (WIT_DIR == "")
					return current_dlg;
				if (right(WIT_DIR, 1) != "\\")
					WIT_DIR = WIT_DIR + "\\";
				
				delete("TEMP.FILES", "");
				getdirectory(WIT_DIR + "*.wit", "TEMP.FILES");
				var nLastPos	= getsize("TEMP.FILES", "") - 1;
				var ImportItems	= [];
				for (i=0;i<=nLastPos;i++){
					if (!getint("IS_DIRECTORY", "TEMP.FILES["+i+"]")){
						var Datei	= WIT_DIR + getstring("FILENAME", "TEMP.FILES["+i+"]");
						loadxml("TEMP.IMPORT", Datei, "true");
						if (check_Version(getstring("TEMP.IMPORT.PROJECTFILEVERSION.MAJOR",""),getstring("TEMP.IMPORT.PROJECTFILEVERSION.MINOR","")))
						{
							setstring("TEMP.ERRORMESSAGE", "", translate("ERROR_PROJEKTDATEI_LADEN_ALTE_VERSION"));
							bOk	= false;
							i	= nLastPos + 1;	// Abbruch
						}
						else{
							for (j = 0; j <= getsize("TEMP.IMPORT.POSITIONS.PROJECTLIST_ITEMS", "") - 1; j++){
								ImportItems.push(Object.fromStorage("TEMP.IMPORT.POSITIONS.PROJECTLIST_ITEMS[" + j + "]"));
							}
						}
					}
				}
				if (bOk){
					ImportItems.toStorage('TEMP.IMPORT.POSITIONS.PROJECTLIST_ITEMS', false);
					setstring("IMPORT_FILE_NAME", "TEMP", WIT_DIR);
				}
			}
			
			if (bOk){
				var Source, Target, i;
				var Projectlist = "TEMP.IMPORT.POSITIONS.PROJECTLIST_ITEMS";
				var ProjectlistImport = "TEMP.PROJECT.POSITIONS.PROJECTIMPORTLIST_ITEMS";
				var nLastPos = getsize(Projectlist, "") - 1;
				for (i = 0; i <= nLastPos; ++i)
				{
					Source = Projectlist + "[" + i + "]";
					Target = ProjectlistImport + "[" + i + "]";
					copy(Source, Target);
					setstring("IMPORT_CHECK", Target, "true");
				}
				delete("IMPORT", "TEMP");
			}
			else
				delete("IMPORT", "TEMP");
		}
	// Import starten
		if(event=="IDC_IMPORT_BUT")
		{
			logtraceln("");
			logtraceln("Import beginnt!");
			var Source, Target, i, nAnz;
			var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
			var nPosEinfuegen = getsize(Projectlist, "");
			var nPos = 10;
			if(nPosEinfuegen > 0)
			{
				Target = Projectlist + "[" + (nPosEinfuegen-1) + "]";
				nPos = (atoi(getstring("POS", Target)) / 10 + 1) * 10;
			}
			var ProjectlistImport = "TEMP.PROJECT.POSITIONS.PROJECTIMPORTLIST_ITEMS";
			var nLastPos = getsize(ProjectlistImport, "") - 1;
			nAnz = 0;
			for (i = 0; i <= nLastPos; ++i)
			{
				Source = ProjectlistImport + "[" + i + "]";
				if(getstring("IMPORT_CHECK", Source) != "true")
					continue;
				Target = Projectlist + "[" + nPosEinfuegen + "]";
				nPosEinfuegen++;
				copy(Source, Target);
                setstring("POS", Target, ""+(nPos + nAnz*10));
                setstring("CACHE_DRAWING_FILE_PDF_SAP", Target, "");
                setstring("CACHE_DRAWING_FILE_PDF", Target, "");
                setstring("CACHE_DRAWING_FILE_DXF", Target, "");

                if (getstring("ORDERCODE_PROJECTLIST", Target) == "")
					setstring("ORDERCODE_PROJECTLIST", Target, getstring("ORDERCODE", Target));
				nAnz++;
			}
			
			logtraceln("Preise neu berechnen!");
			
			// Damit die importierten Positionen auf die aktuelle Währung umgerechnet werden ...
			specialexec("ProjectRecalcPrices");
			
			logtraceln("Preise berechnen beendet!");
			
			var Merged	= getbool("MERGED_FLAG", "TEMP");
			var strTmp;
			if (!Merged){
				if(nAnz == 1)
				{
					strTmp = replace(translate("MSG_IMPORT_1POS"), "#x#", nPos);
				}
				else if(nAnz > 1)
				{
					strTmp = replace(translate("MSG_IMPORT_NPOS"), "#x#", nPos);
					strTmp = replace(strTmp, "#y#", (nPos + (nAnz-1)*10));
				}
				else
				{
					strTmp = translate("MSG_IMPORT_NOPOS");
				}
			}
			else
				strTmp	= "Zusammenfassen beendet";
			
			logtraceln("Import beendet!");
			
			setstring("ERRORMESSAGE", "TEMP", strTmp);
			setstring("MERGED_FLAG", "TEMP", "false");
		}

	// Typnummernsuche
	//-----------------------------------
	// Importdatei festlegen
		if(event=="IDC_TYPNUMMER_FILE_BUT")
		{
			delete("", "TEMP.TYPNUMMERDATEN");
			delete("", "TEMP.TYPNUMMERLINES");
			delete("TYPNUMMER", "TEMP");
			delete("TYPNUMMER_RESULT", "TEMP");
		// zuletzt importiert
		//	delete("PROJECT.POSITIONS", "IMPORT");
			setstring("IMPORT_FILE_NAME", "TEMP", "");
			setstring("TYPNUMMER", "TEMP", "");

			var Datei = filedialog(1, "txt", "", "Text-Files (*.txt)|*.txt|All Files(*.*)|*.*|", "C:");

			if (Datei == "")
				return current_dlg;
		// Dateiname in Dialogvariable
			setstring("IMPORT_FILE_NAME", "TEMP", Datei);
		// lese Datei
			var i, j, strTmp, strZeile;
			var strTypNummer, strTypNummern = "";
			var aDaten = [];
			var nTypnrDaten = 0, TypnrDaten, strDelim;
			var nRows = stringtoarray(readfile(Datei), "TEMP.TYPNUMMERLINES", "\r\n");
		// Delimiter ; oder Tab erlaubt - NICHT gemischt
			strDelim = "";
			for(i = 0; strDelim == "" && i < nRows; i++)
			{
				// Kommentar: 1.Spalte = ; oder #
				if(left(strZeile, 1) == ";" || left(strZeile, 1) == "#")
					continue;
				strZeile = getstring("VALUE", arraypath("TEMP.TYPNUMMERLINES", i));
				if(find(strZeile, ";") > -1)
					strDelim = ";";
				else if(find(strZeile, "\t") > -1)
					strDelim = "\t";
			}
		// Datenzeilen lesen
			for(i = 0; i < nRows; i++)
			{
				strZeile = getstring("VALUE", arraypath("TEMP.TYPNUMMERLINES", i));
			// Kommentar: 1.Spalte = ; oder #
				if(left(strZeile, 1) == ";" || left(strZeile, 1) == "#")
					continue;
			// splitten mit ; oder Tab nach TEMP.TYPNUMMERDATEN[nTypnrDaten]
				TypnrDaten = arraypath("TEMP.TYPNUMMERDATEN", nTypnrDaten);
				var n = stringtoarray(strZeile, TypnrDaten, strDelim);
			// trimmen
				for(j = 0; j < n; j++)
				{
					strTmp = getstring("VALUE", arraypath(TypnrDaten, j));
					strTmp = trimleft(trimright(strTmp, " "), " ");
					setstring("VALUE", arraypath(TypnrDaten, j), strTmp);
				}
				nTypnrDaten++;
			// Anzeige Suchfeld
				strTmp = getstring("VALUE", arraypath(TypnrDaten, 0));
				if(strTmp != "")
					strTypNummern += strTmp + "\r\n";
			}
		// zu suchende Nummern in Dialogvariable
			setstring("TYPNUMMER", "TEMP", strTypNummern);
		}
		
	// Übernehmen der markierten Positionen aus der Typenschlüsselanalyse in die Projektliste
		if(event=="IDC_TYPNUMMER_EXPORT_BUT")
		{
			var Selection, Source, Target, i, nAnz;
			var Selectionlist = "TEMP.TYPNUMMER_ITEMS";								// Hier steht die angezeigte Liste im Reiter Typenschlüsselanalyse mit den Checkboxen, was übernommen werden soll
			var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";				// unsere Projektliste
			// var ProjectlistImport = "IMPORT.PROJECT.POSITIONS.PROJECTLIST_ITEMS";	// Hier wurden im IndexController die analysierten Positionen hinkopiert ...  Stand 7.5.2015 stehen die aber nur noch in der Selectionlist

			var nPosEinfuegen = getsize(Projectlist, "");
			var nPos = 10;
			if(nPosEinfuegen > 0)
			{
				Target = Projectlist + "[" + (nPosEinfuegen-1) + "]";
				nPos = (atoi(getstring("POS", Target)) / 10 + 1) * 10;
			}
			else
			{
                // Projektliste ist leer ... sicherheitshalber nochmal löschen
                // damit nicht z.B. "0" drin steht.
				delete("POSITIONS", "PROJECT");
			}
			// 7.5.2015 var nLastPos = getsize(ProjectlistImport, "") - 1;
			var nLastPos = getsize(Selectionlist, "") - 1;
			nAnz = 0;
			for (i = 0; i <= nLastPos; ++i)
			{
				Selection = Selectionlist + "[" + i + "]";
				if(getstring("IMPORT_CHECK", Selection) != "true")
					continue;
				// Source = ProjectlistImport + "[" + i + "]";
				Source = Selectionlist + "[" + i + "]";
				Target = Projectlist + "[" + nPosEinfuegen + "]";
				copy(Source, Target);
                setstring("POS", Target, ""+(nPos + nAnz*10));
				nPosEinfuegen++;
				nAnz++;
			}

			// nochmal aktualiseren
			doAktualisierung();

			var strTmp;
			if(nAnz == 1) {
				strTmp = replace(translate("MSG_IMPORT_1POS"), "#x#", nPos);
			}
			else if(nAnz > 1) {
				strTmp = replace(translate("MSG_IMPORT_NPOS"), "#x#", nPos);
				strTmp = replace(strTmp, "#y#", (nPos + (nAnz-1)*10));
			}
			else {
				strTmp = translate("MSG_IMPORT_NOPOS");
			}
			setstring("ERRORMESSAGE", "TEMP", strTmp);
		}
	// Ergebnis löschen
		if(event=="IDC_CLEAR_TYPNUMMER_BUT")
		{
			delete("PROJECT.POSITIONS", "IMPORT");
			delete("TYPNUMMER_ITEMS", "TEMP");
			delete("TYPNUMMERDATEN", "TEMP");
			delete("TYPNUMMER_WORK", "TEMP");
			setstring("IMPORT_FILE_NAME", "TEMP", "");
		}
	// Markierungen
	//-----------------------------------
	// TYPNUMMERNSUCHE
        if ((event=="IDC_SELECT_TYPNUMMER_ALL_BUT") || (event=="IDC_SELECT_TYPNUMMER_NONE_BUT"))
        {
            var Typnummer = "TEMP.TYPNUMMER_ITEMS";
            var nLastPos = getsize(Typnummer, "") - 1;
            var Source, i;
            var strSelect = "true";
            if (event=="IDC_SELECT_TYPNUMMER_NONE_BUT")
                strSelect = "false";
            for (i = 0; i <= nLastPos; ++i)
            {
                Source = Typnummer + "[" + i + "]";
                setstring("IMPORT_CHECK", Source, strSelect);
            }
        }
	// IMPORT
        if ((event=="IDC_SELECT_IMPORT_ALL_BUT") || (event=="IDC_SELECT_IMPORT_NONE_BUT"))
        {
            var ProjectlistImport = "TEMP.PROJECT.POSITIONS.PROJECTIMPORTLIST_ITEMS";
            var nLastPos = getsize(ProjectlistImport, "") - 1;
            var Source, i;
            var strSelect = "true";
            if (event=="IDC_SELECT_IMPORT_NONE_BUT")
                strSelect = "false";
            for (i = 0; i <= nLastPos; ++i)
            {
                Source = ProjectlistImport + "[" + i + "]";
                setstring("IMPORT_CHECK", Source, strSelect);
            }
        }
	// Reiter Import
	//-----------------------------------
	// ein-/ausschalten
		if(event=="IDC_STARTIMPORT_BUT")
		{
			delete("PROJECT", "TEMP");
			setstring("PROJECTIMPORT_COMMENT_START", "", "");
			setstring("PROJECTIMPORT_COMMENT_END", "", "");
            setstring("PROJECTIMPORT_COMMENT_PREVENT", "", "false");
			setstring("SELECTED_PROJEKTTABCTRL", "PROJECT.SETTINGS", "IDC_PROJECTIMPORTLIST_TAB");

            setstring("STKIMPORT_COMMENT_START", "", "<!--");
            setstring("STKIMPORT_COMMENT_END", "", "-->");
            setstring("STKIMPORT_COMMENT_PREVENT", "", "true");
			
			setstring("SCHILD_COMMENT_PREVENT", "", "true");
		}
		if(event=="IDC_ENDEIMPORT_BUT")
		{
			delete("PROJECT", "TEMP");
			setstring("IMPORT_FILE_NAME", "TEMP", "");
			setstring("PROJECTIMPORT_COMMENT_START", "", "<!--");
			setstring("PROJECTIMPORT_COMMENT_END", "", "-->");
            setstring("PROJECTIMPORT_COMMENT_PREVENT", "", "true");
			setstring("SELECTED_PROJEKTTABCTRL", "PROJECT.SETTINGS", "IDC_PROJECTLIST_TAB");
		}
	// REVISION
        if (event=="IDC_REVISION_ANLEGEN")
        {
            var x = getstring("PROJECT.REVISIONS.REVISION_SELECTED", "");
            var RevisionTable = "PROJECT.REVISIONS.REVISION_TABELLE_ITEMS";
            var nLastPos = getsize(RevisionTable, "") - 1;
            var strRevisionText = getstring("TEXT_REVISION", "TMP");
            var strUser = getstring("WI_BENUTZER", "PROJECT.SETTINGS");
            getdate('CURRENT_TIME','TEMP');
            var strMonth = getstring('MONTH','TEMP.CURRENT_TIME');
            if (strMonth.length < 2)
                strMonth = "0" + strMonth;
            var strDay = getstring('DAY','TEMP.CURRENT_TIME');
            if (strDay.length < 2)
                strDay = "0" + strDay;
            var strDate = getstring('YEAR','TEMP.CURRENT_TIME') + "-" + strMonth + "-" + strDay;

            if (strRevisionText != "")
            {
                var Source, Target, i;
                var strNewNr = nLastPos + 2;    // 1 weil wir ne neue haben, +1 weil sichtbare Revnummern bei 1 anfangen sollen
                // Alles um 1 hochschieben ... wir wollen die Tabelle so, dass aktuellste Einträge am kleinsten Index stehen
                for (i = nLastPos; i >= 0; --i)
                {
                    Source = RevisionTable + "[" + i + "]";
                    Target = RevisionTable + "[" + (i+1) + "]";
                    copy(Source, Target);
                }
                // Jetzt neuen Eintrag anlegen
                Target = RevisionTable + "[" + 0 + "]";
                setstring("NR",  Target, strNewNr);
                setstring("USER",Target, strUser);
                setstring("DATE",Target, strDate);
                setstring("TEXT",Target, strRevisionText);
                // wird nicht angezeigt: Typ des Revisionseintrags (Manuell oder durch System)
                setstring("TYPE",Target, "MANUAL");
                // Kenner, dass im laufenden Projekt eine neue Revision angelegt wurde
                // Muss vor dem Speichern bzw. nach dem Laden wieder zurückgesetzt werden
                setstring("NEW_REVISION","PROJECT.SETTINGS", "TRUE");

                setstring("PROJECT.REVISIONS.REVISION_SELECTED", "", "0");

                invalidiereZeichnungen();
            }
        }
	// CAD Export
        if (event=="IDC_EXPORT_CAD_VERZEICHNIS_WAEHLEN_BUTTON")
        {
            //  Open/Save, Extension, Filename, Filter, Directory
			var Ordner = dirdialog(translate("MSG_DLG_CAD_EXPORT"), getstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS"));
			if (Ordner != "")
            {
                if (right(Ordner, 1) != "\\")
                    Ordner += "\\";

				setstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS", Ordner);
				setSinglePropertyToIni("EXPORT_CAD_VERZEICHNIS", Ordner);
            }
        }
	// Import von STK-Dateien ... aus Ordner waehlen ...
	//---------------------------------------------------
		if(event=="IDC_CASCADE_STK_IMPORT" || event=="IDC_CASCADE_STK_IMPORT_CII" || event=="IDC_CASCADE_STK_IMPORT_EXCEL")
		{
			delete("STK_IMPORT_AREA", "TEMP");
			
            var strPresetOrdner = getstring("IMPORT_STK_VERZEICHNIS", "");
			var Ordner = strPresetOrdner;
			//if (event != "IDC_CASCADE_STK_IMPORT_CII" || (event == "IDC_CASCADE_STK_IMPORT_CII" && Ordner == ""))
			if (event == "IDC_CASCADE_STK_IMPORT" || Ordner == "")
				Ordner = dirdialog(translate("MSG_DLG_STK_IMPORT"), strPresetOrdner);
			if (Ordner == "")
				return current_dlg;
			
			setSinglePropertyToIni("IMPORT_STK_VERZEICHNIS", Ordner);
            setstring("IMPORT_STK_VERZEICHNIS", "", Ordner);
            setstring("PROJECTIMPORT_COMMENT_START", "", "<!--");
            setstring("PROJECTIMPORT_COMMENT_END", "", "-->");
            setstring("PROJECTIMPORT_COMMENT_PREVENT", "", "true");
            setstring("STKIMPORT_COMMENT_START", "", "");
            setstring("STKIMPORT_COMMENT_END", "", "");
            setstring("STKIMPORT_COMMENT_PREVENT", "", "false");
			
            importSTKfromFolder(Ordner);
            setstring("TEMP.ERRORMESSAGE", "", translate("MSG_IMPORT_DONE"));
   			setstring("SELECTED_PROJEKTTABCTRL", "PROJECT.SETTINGS", "IDC_STKIMPORTLIST_TAB");
		}
		if(event=="IDC_IMPORT_STK_POS_BUT")
		{
            var strPos = getstring("STKIMPORTLIST_TABELLE_SELECTED", "TEMP.STK_IMPORT_AREA");
            if (strPos != "")
            {
				// -mw- 20.9.2010 damit keine Reste von vorher stehen bleiben ...
				delete("", "DLGDATA");	
				setstring("KILL_CAMAINCONTROLLER", "", "true");
				
				setSTKdataToDlg(strPos);
				var rh_typ = left(toupper(getstring("rh_typ", "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS[" + strPos + "].FINOBJECT.assembly")), 2);
				if (rh_typ == "")
					new_dlg = "IDD_RH_AUSWAHL";
				else if  (rh_typ == "ST" || rh_typ == "AX" || rh_typ == "FL" || rh_typ == "FP" || rh_typ == "GL" || rh_typ == "LL" ||
							rh_typ == "QS" || rh_typ == "2W" || rh_typ == "3W" || rh_typ == "4W" || rh_typ == "90"){
				//setstring("OPEN_MODE_CASCADE", "", "LAGER");
					setstring("OPEN_MODE_CASCADE", "", "LAGER2011");
					new_dlg = "index2";
				}
				else{
					setstring("OPEN_MODE_CASCADE", "", "NEW");
					new_dlg = "index2";
				}
            }
        }
		
		if (event == "IDC_SCHILD_KONVERT"){
			delete("SCHILD_IMPORT_AREA", "TEMP");
			var strPresetOrdner	= "K:\\Common\\arbeitsvorbereitung\\PRUEFPLATZ\\SCHILD";
			var Ordner = dirdialog(translate("Bitte Ordner mit Schilddateien wählen!"), strPresetOrdner);
			if (Ordner == "")
				return current_dlg;
			
			if (right(Ordner, 1) != "\\")
				Ordner = Ordner + "\\";
			
			delete("TEMP.FILES", "");
			getdirectory(Ordner + "*.*", "TEMP.FILES");
			
			var nLastPos	= getsize("TEMP.FILES", "") - 1;
			var AnzSchilder	= 0;
			for (var i = 0; i <= nLastPos; i++){
				var typeFile	= FileName.getExt(Ordner + getstring("FILENAME", "TEMP.FILES["+i+"]"));
				if ((nLastPos != -1) && (typeFile*1 != "NaN") && (typeFile*1 != 0) && (getstring("IS_DIRECTORY", "TEMP.FILES["+i+"]") != "1")){
					var FileLines	= readfile(Ordner + getstring("FILENAME", "TEMP.FILES["+i+"]")).split("\r\n"); // nur 2 rel. Zeilen
					var TempLine	= [];
					for (var j = 0; j < FileLines.length - 1; j++){		// "\r\n" steht auch am Ende des Files -> erzeugt leeres Feld
						TempLine.push(FileLines[j].split(";"));
					}
					// Auslesen der Prägeparameter für den Schildtyp
					var strSchildTyp	= (TempLine[1][0] == "FH050" ? "FH50" : TempLine[1][0]);
					var strSQLStatement = "select * from PraegParam where Schildtyp = '"+strSchildTyp+"' order by Zeilen ";
					var AnzZeilen		= dbselect("CASCADE", strSQLStatement, "PraegParam");
					var PraegeParam		= {};
					for (var z = 1; z <= AnzZeilen; z++){
						strSQLStatement = "select * from PraegParam where Schildtyp = '"+strSchildTyp+"' and abs(Zeilen) = "+z+" ";
						dbselect("CASCADE", strSQLStatement, "PraegParam");
						PraegeParam.push(dbgetstring("PraegParam", "X") + " "
										+ dbgetstring("PraegParam", "Y") + " "
										+ dbgetstring("PraegParam", "Z") + " "
										+ dbgetstring("PraegParam", "W") + " "
										+ dbgetstring("PraegParam", "H") + " "
										+ dbgetstring("PraegParam", "WINKEL") + " "
										+ dbgetstring("PraegParam", "RADIUS") + " "
										+ dbgetstring("PraegParam", "RAUM") + " "
										+ dbgetstring("PraegParam", "KRAFT") + " "
										+ dbgetstring("PraegParam", "QUALITAET") + " "
										+ dbgetstring("PraegParam", "FELD") + " \r\n"
										);
					}
					var strHaengerTyp		= trimright(trimleft(TempLine[1][1], " "), "").replace(" ", "\\ ");
					var strMarkierung		= trimright(trimleft(TempLine[1][3], " "), "").replace(" ", "\\ ");
					var SerNrParts			= TempLine[1][2].split("/");
					var strAuftragsnummer	= SerNrParts[1];
					var strPosNr			= SerNrParts[2]*1;
					if (SerNrParts.length > 3)
						var strIndex		= ( SerNrParts[3] == "" ? 1 : SerNrParts[3] );
					else
						var strIndex		= 1;
					//Ordner	= Ordner.replace("SCHILD", "SCHILD_WOSTOR");
					var bExists = FileName.dirExists(Ordner.replace("SCHILD", "SCHILD_WOSTOR"));
					if (!bExists)
						var bOk = FileName.createDir(Ordner.replace("SCHILD", "SCHILD_WOSTOR"));
					// Unterscheidung FH/FS und KH/KS
					if (left(strSchildTyp, 2) == "FH"){
					//  noch die variablen X-Positionen setzen
						PraegeParam[1]	= PraegeParam[1].replace("X_FKALT", fround(TempLine[1][7], 0)*10 + 75 + 15);	// "+15" -> halbe Texthöhe
						PraegeParam[2]	= PraegeParam[2].replace("X_PFEIL", fround(TempLine[1][7], 0)*10 + 75 + 15);
						writefile(	Ordner.replace("SCHILD", "SCHILD_WOSTOR") + "S_" + strSchildTyp + "_" + strPosNr + "_" + strIndex + "_" + strAuftragsnummer + ".sic",
									"NEWFILE 5 7 1 FH\r\n"
									+ "INSERTTEXTLINE " + PraegeParam[0].replace("Fmin", TempLine[1][8])
									+ "INSERTTEXTLINE " + PraegeParam[1].replace("Fkalt", TempLine[1][4])
									+ "INSERTTEXTLINE " + PraegeParam[2].replace("Pfeil", "<-")
									+ "INSERTTEXTLINE " + PraegeParam[3].replace("Fmax", TempLine[1][9])
									/*	// weglassen
									+ "INSERTTEXTLINE " + PraegeParam[4].replace("FRate_Text", "Springrate")
									+ "INSERTTEXTLINE " + PraegeParam[5].replace("FRate_Wert", FRate)
									+ (strSchildTyp != "FH50" ? "" : "INSERTTEXTLINE " + PraegeParam[6].replace("FRate_Einh", "N/mm"))
									*/
									+ "INSERTTEXTLINE " + PraegeParam[7].replace("Typ", strHaengerTyp)
									+ "INSERTTEXTLINE " + PraegeParam[8].replace("SerNr", TempLine[1][2])
									+ (strMarkierung == "" ? "" : "INSERTTEXTLINE " + PraegeParam[9].replace("Mark", strMarkierung)),
									"wc");
						AnzSchilder++;
					}
					else{
						writefile(	Ordner.replace("SCHILD", "SCHILD_WOSTOR") + "S_" + strSchildTyp + "_" + strPosNr + "_" + strIndex + "_" + strAuftragsnummer + ".sic",
									"NEWFILE 5 7 1 KH\r\n"
									+ "INSERTTEXTLINE " + PraegeParam[0].replace("Typ", TempLine[1][1])
									+ "INSERTTEXTLINE " + PraegeParam[1].replace("SerNr", TempLine[1][2])
									+ (strMarkierung == "" ? "" : "INSERTTEXTLINE " + PraegeParam[2].replace("Mark", strMarkierung))
									+ "INSERTTEXTLINE " + PraegeParam[3].replace("EinstLast", TempLine[1][4])
									+ (strWegAuf == 0 ? "" : "INSERTTEXTLINE " + PraegeParam[4].replace("WegAuf", TempLine[1][5]))
									+ (strWegAb == 0 ? "" : "INSERTTEXTLINE " + PraegeParam[5].replace("WegAb", TempLine[1][6]))
									+ "INSERTTEXTLINE " + PraegeParam[6].replace("BlockPos", TempLine[1][7]),
									"wc");
						AnzSchilder++;
					}
				}
			}
			if (!AnzSchilder)
				setstring("TEMP.ERRORMESSAGE", "", "Keine Daten im Ordner\n" +Ordner+ "\nzum Umwandeln vorhanden!");
			else
				setstring("TEMP.ERRORMESSAGE", "", "Es wurden " + AnzSchilder + " Schilddateien von\n" +Ordner+ "\nnach\n" +Ordner.replace("SCHILD", "SCHILD_WOSTOR")+ "\nkopiert und umgewandelt.");
		}
		if (event == "IDC_SCHILD_LIST"){
		// Nutzung des STK-Imports zur Erstellung der Liste für die Schilddateien
			delete("SIC_IMPORT_AREA", "TEMP");
			var strSAPAuftragsnummer	= trimleft(trimright(getstring("IDC_WI_SAPNR_EDIT", "IDD_PROJECTLISTE"), " "), " ");
			var bExists = FileName.dirExists("K:\\Common\\arbeitsvorbereitung\\PRUEFPLATZ\\SCHILD_WOSTOR\\S" + strSAPAuftragsnummer);
			if (!bExists){
				var strPresetOrdner = getstring("IMPORT_TCA_VERZEICHNIS", "");
				var Ordner = dirdialog(translate("Bitte Ordner mit Schilddateien wählen!"), strPresetOrdner);
				if (Ordner == "")
					return current_dlg;
				setSinglePropertyToIni("IMPORT_TCA_VERZEICHNIS", Ordner);
			}
			else
				var Ordner	= "K:\\Common\\arbeitsvorbereitung\\PRUEFPLATZ\\SCHILD_WOSTOR\\S" + strSAPAuftragsnummer;
			setstring("SCHILD_COMMENT_PREVENT", "", "false");
			importSTKfromFolder(Ordner);
            setstring("TEMP.ERRORMESSAGE", "", translate("MSG_IMPORT_DONE"));
   			setstring("SELECTED_PROJEKTTABCTRL", "PROJECT.SETTINGS", "IDC_SCHILDLIST_TAB");
		}
		if (event == "IDC_PRAEG_SCHILD_BUT"){
			//var TransferProgPath	= "D:\\id\\Teams\\tg\\WOSTOR~1\\OpenCOM\\Debug";
			//var TransferProgName	= "OpenCOM.exe";
			if (getstring("SCHILDLIST_TABELLE_SELECTED", "TEMP.SIC_IMPORT_AREA") == "")
				setstring("TEMP.ERRORMESSAGE", "", "Bitte die zu übertragende Zeile markieren\r\nund neu senden!");
			else{
				var LineSelected		= getint("SCHILDLIST_TABELLE_SELECTED", "TEMP.SIC_IMPORT_AREA");
				var Pfad				= getstring("IMPORT_TCA_VERZEICHNIS", "") + getstring("filename", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"]");
				// den Pfad in die Datei Path.txt Schreiben (Schreibrechte werden Vorausgesetzt)
				//writefile(TransferProgPath + "\\Path.txt", Pfad, "wc");
				//shellexecuteex(TransferProgName, "", TransferProgPath, 0);
				var AnzBearb	= getint("AnzBearb", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"]") + 1;
				var Schildtyp	= getstring("schildtyp", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"]");
				var Status		= translate("IDC_BEARBEITET") + " " + getstring("DATE", "") + " " + getstring("TIME", "") + " (" + AnzBearb + "x)" ;
				setstring("status", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"]", Status);
				setstring("AnzBearb", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"]", AnzBearb);
				setstring("SEND_CHECK", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"]", "false");
				var AnzGesamt	= getint("AnzGesamt", "TEMP.SIC_IMPORT_AREA");
				setstring("SCHILDLIST_TABELLE_SELECTED", "TEMP.SIC_IMPORT_AREA", "");
				//for (var i = LineSelected + 1; i < AnzGesamt; i++){
				for (var i = 0; i < AnzGesamt; i++){
					if (getstring("SEND_CHECK", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+i+"]") == "true"){
						setstring("SCHILDLIST_TABELLE_SELECTED", "TEMP.SIC_IMPORT_AREA", i);
						break;
					}
				}
				switch (Schildtyp){
					case "FH50"		: setstring("IDC_ANZ_FH050", "IDD_PROJECTLISTE", (getint("IDC_ANZ_FH050", "IDD_PROJECTLISTE")-1 < 0 ? 0 : getint("IDC_ANZ_FH050", "IDD_PROJECTLISTE")-1));
									  break;
					case "FH100"	: setstring("IDC_ANZ_FH100", "IDD_PROJECTLISTE", (getint("IDC_ANZ_FH100", "IDD_PROJECTLISTE")-1 < 0 ? 0 : getint("IDC_ANZ_FH100", "IDD_PROJECTLISTE")-1));
									  break;
					case "FH200"	: setstring("IDC_ANZ_FH200", "IDD_PROJECTLISTE", (getint("IDC_ANZ_FH200", "IDD_PROJECTLISTE")-1 < 0 ? 0 : getint("IDC_ANZ_FH200", "IDD_PROJECTLISTE")-1));
									  break;
					case "KH"		: setstring("IDC_ANZ_KH", "IDD_PROJECTLISTE", (getint("IDC_ANZ_KH", "IDD_PROJECTLISTE")-1 < 0 ? 0 : getint("IDC_ANZ_KH", "IDD_PROJECTLISTE")-1));
									  break;
					default			: setstring("IDC_ANZ_SONST", "IDD_PROJECTLISTE", (getint("IDC_ANZ_SONST", "IDD_PROJECTLISTE")-1 < 0 ? 0 : getint("IDC_ANZ_SONST", "IDD_PROJECTLISTE")-1));
									  break;
				}
				if (getstring("SCHILDLIST_TABELLE_SELECTED", "TEMP.SIC_IMPORT_AREA") == "")
					setstring("TEMP.ERRORMESSAGE", "", "Alle Daten wurden mindestens 1x übertragen!");
				writefile(Pfad, "\r\nSTATUS " + Status, "a");
				var AnzLines	= getint("AnzLines", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"]");
				var Submit		= "";
				for (i = 0; i < AnzLines; i++){
					if (getstring("k", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"].Line["+i+"]") != "STATUS"){
						Submit	+= getstring("k", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"].Line["+i+"]")
								+ " "
								+ getstring("v", "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+LineSelected+"].Line["+i+"]")
								+ "\r\n";
					}
				}
				//writefile("\\\\.\\COM4", Submit, "wc");	// USB/COM-Adapter
				writefile("\\\\.\\COM1", Submit, "wc");		// COM-Port Lager
			}
		}
		/*** 03/2009: Auf Wunsch von WI automatisch nach dem erzeugen
		// Alle PDF in Ordner packen
		//---------------------------------------------------
		if(event=="IDC_EXPORT_CAD_PACKALL_BUTTON")
		{
            var strUserExportPath  = getstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS");
            if (strUserExportPath.length > 0)
            {
                // Diversa:
                // Wildcard mit Pfadangabe vorne geht nicht
                // Wildcard ohne Pfadangabe geht, wenn man den Ausführungsordner auf den Zielordner legt,
                //    aber dann sind die Dateien unzusammenhängend sortiert
                // Alle aufzählen geht in der DOS-Box (getestet: 70 Stück), Problem: kann man den Pfad
                // weglassen, wenn man die Dosbox im Zielordner ausführt und die bat-Datei dort ablegt??
                // Alle aufzählen über Params geht nicht bei ca > 50 Dateien

                // @@@@ strUserExportPath ist UTF8 aus Maske .... Funktioniert das auch auf russisch/asiatisch? evtl. besser Funktion die gekürzten internen Namen liefert ...
                strUserExportPath = utf8toansi(strUserExportPath);

                if (strUserExportPath.charAt( strUserExportPath.length - 1 ) != "\\" )
                    strUserExportPath += "\\";
                var strPattern  = "\"" + strUserExportPath + "*.pdf\"";
                var strPrgPath  = getstddirectory( "PROGRAM" ) + "catalog\\plugin\\";    // inkl. trailing Backslash
                var strExecutable = strPrgPath + "pdftk.exe";
                var Datei = filedialog(0, "pdf", "", "*.pdf", "");
                Datei = utf8toansi(Datei);  // @@@ Achtung kyrillisch etc ... @@@ Tool erzeugt Umlaute als DOS-Codes !!! Problem!!
                if (Datei != "")
                {
                    delete("TEMP.FILES", "");
                    getdirectory(strUserExportPath + "*.*", "TEMP.FILES");
                    sortarray("TEMP.FILES", "FILENAME");

                    var nLastPos = getsize("TEMP.FILES", "") - 1;
                    var i, strPdfInputListe= "";
                    for (i = 0; i <= nLastPos; ++i)
                    {
                        var eksPathFile = "TEMP.FILES[" + i + "]";
                        var nameFile = getstring("FILENAME", eksPathFile);
                        if ((toupper(right(nameFile, 4)) == ".PDF") &&
                            (getstring("IS_DIRECTORY", eksPathFile) != "1"))
                        {
                            // Um zu verhindern, dass Umlaute in den Dateinamen vorkommen -> führt bei PDFTK zum Absturz
                            var nameFileShort = FileName.getShortPath(strUserExportPath + nameFile);
                            strPdfInputListe += " \"" + nameFileShort + "\"";
                        }
                    }

                    // var strParams = " *.pdf cat output \"" + Datei + "\" ";  // dont_ask
                    var strParams = strPdfInputListe + " cat output \"" + Datei + "\" dont_ask ";

                    var strFileLine = strExecutable + " " + strParams;
                    var strBatfile  = gettempfile(strUserExportPath, "bat");
                    writefile( strBatfile, strFileLine, "wc" );

                    // Datei erzeugen
                    // shellexecuteexblocking( strExecutable, strParams, strUserExportPath, 1, 256000 );    // show = 1
                    shellexecuteexblocking( strBatfile, "", strUserExportPath, 1, 256000 );    // show = 1

                    // PDF anzeigen
                    // @@@ Check ob es angelegt wurde!!!
                    shellexecuteex( Datei, "", "", 1 );    // show = 1
                }
            }
            else
                alert(translate("ERR_NO_PATH"));
        }
		****/
		/****
		// Alle PDF in Projektliste, die angekreuzt sind packen
		//---------------------------------------------------
        if(event=="IDC_EXPORT_CAD_PACKPLIST_BUTTON")
        {
            // !!! 13.1.09 Der Knopf für dieses Event wurde auf Wunsch WI aus Projektliste entfernt
            var Source, strPos, i, strPdfInputListe= "";
            var bCachePdfExists;
            var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
            var nLastPos = getsize(Projectlist, "") - 1;
            for (i = 0; i <= nLastPos; ++i)
            {
                Source = Projectlist + "[" + i + "]";
                var strProductArea  = getstring("PRODUCT_AREA", Source);
                if (strProductArea == "RH") || (strProductArea != "CA"))
                {
                    var strCachePdf     = getstring("CACHE_DRAWING_FILE_PDF", Source);
                    // @@@ könnte theoretisch aus 2 unterschiedlichen Ordnern kommen
                    bCachePdfExists = false;
                    if ((strCachePdf != "") && FileName.fileExists(strCachePdf))
                    {
                        // Um zu verhindern, dass Umlaute in den Dateinamen vorkommen -> führt bei PDFTK zum Absturz
                        var strCachePdfShort = FileName.getShortPath(strCachePdf);
                        strPdfInputListe += " \"" + strCachePdfShort + "\"";
                    }
                }
            }
            var strUserExportPath  = getPathFromFilename(strCachePdf);
            var strPrgPath  = getstddirectory( "PROGRAM" ) + "catalog\\plugin\\";    // inkl. trailing Backslash
            var strExecutable = strPrgPath + "pdftk.exe";
            var Datei = filedialog(0, "pdf", "", "*.pdf", "");
            if (Datei != "")
            {
                // Um zu verhindern, dass Umlaute in den Dateinamen vorkommen -> führt bei PDFTK zum Absturz
		 		var DateiTmp = FileName.getTempFile("pdf");
                var strParams = strPdfInputListe + " cat output \"" + DateiTmp + "\" dont_ask ";
                var strFileLine = strExecutable + " " + strParams;
                var strBatfile  = gettempfile(strUserExportPath, "bat");
                writefile( strBatfile, strFileLine, "wc" );
                // Datei erzeugen
                // shellexecuteexblocking( strExecutable, strParams, strUserExportPath, 1, 256000 );    // show = 1
                shellexecuteexblocking( strBatfile, "", strUserExportPath, 1, 256000 );    // show = 1
                // @@@ Batchfile wegputzen ...
                // PDF anzeigen
                FileName.moveFile(DateiTmp, Datei, true); // overwrite

                if(FileName.fileExists(Datei))
                {
                    // Weil das sonst schief geht, wenn Umlaute drin sind:
                    var strDateiPdfShort = FileName.getShortPath(Datei);
                    shellexecuteex( strDateiPdfShort, "", "", 1 );    // show = 1
                }
            }
            else
                alert(translate("ERR_NO_PATH"));
        }
		***/
		if (event=="CURRENCY_UNIT_CHANGE")
		{
			
			//Aus dem MS CRM gibt es eine andere Logik
			var strCRMQuoteID = getstring("CRMQUOTEID", "");
			var strCRMAction = getstring("CRMACTION", "");
			var strCRMUser = getstring("CRMUSER", "");
			
			if (strCRMQuoteID != "" && strCRMAction != "" && strCRMUser != "")
			{
				var strCurrency = getstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR");
				var strCurrency_CRM = getstring("CURRENCY_UNIT_CRM", "PROJECT.SETTINGS.WUR");
				
				if(strCurrency == "EUR")
				{
					setstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR", "1");
					setstring("DISABLE_CUR_FACTOR", "PROJECT.SETTINGS.WUR", "true");
				}
				else
				{
					setstring("DISABLE_CUR_FACTOR", "PROJECT.SETTINGS.WUR", "false");
				}
				
				if(strCurrency_CRM != "EUR" && strCurrency == "EUR")
				{
					setstring("CURRENCY_UNIT_CRM_VISIBILITY_CRM", "PROJECT.SETTINGS.WUR", "visible");
				}
				else
				{
					setstring("CURRENCY_UNIT_CRM_VISIBILITY_CRM", "PROJECT.SETTINGS.WUR", "hidden");
				}
			}
			else
			{
			
				// Währung und Umrechnungsfaktor:
				if (getstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR") == "EUR")
				{
					setstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR", "1");
					setstring("DISABLE_CUR_FACTOR", "PROJECT.SETTINGS.WUR", "true");
				}
				else
					setstring("DISABLE_CUR_FACTOR", "PROJECT.SETTINGS.WUR", "false");
			}
			// Projektliste durchlaufen: Alle frei eingegebenen Preise müssen anhand des
			// versteckt hinterlegten Euro-Preises neu berechnet werden.
			/* Im C++, da das vor dem Recalc-Prices laufen muss, das ohnehin bei jedem Event aufgerufen wird!
			var dCurrencyFactor = getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR") - 0;
			if (dCurrencyFactor < 0.01)
				dCurrencyFactor = 1.0;
				
            var Source, i;
            var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
            var nLastPos = getsize(Projectlist, "") - 1;
            for (i = 0; i <= nLastPos; ++i)
            {
                Source = Projectlist + "[" + i + "]";
				
				sto.SetValue(Target|"FORCEDUNITPRICE_EURO",			dForcedUnitPrice / dWaehrungsfaktor);
				sto.SetValue(Target|"INT_ACCEPT_SET_PRICE_EURO",	dIntAccSetprice / dWaehrungsfaktor);
				sto.SetValue(Target|"EXT_ACCEPT_SET_PRICE_EURO",	dExtAccSetprice / dWaehrungsfaktor);
				
				
                var strProductArea  = getstring("PRODUCT_AREA", Source);
                if (strProductArea == "RH") || (strProductArea != "CA"))
                {
                    // var strCachePdf     = getstring("CACHE_DRAWING_FILE_PDF", Source);
                }
				
            }
			*/
			// Tabellenhaeder mit korrektem Währungssymbol versehen
			setTablePriceHeaders();
			// Projektliste-Preise aktualisieren ...
			// specialexec("ProjectRecalcPrices");
		}
		if (event == "IDC_FIN_DEFAULTS_BUT")
			new_dlg	= "IDD_FIN_DEFAULTS";
	}
	else if (current_dlg=="IDD_WS_TYPEN_SCHLAEUCHE")
	{
		if(event=="IDC_BUTTON_ANSCHLUESSE")				new_dlg="IDD_WS_TYPEN_ANSCHLUESSE";
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_MS_AUSWAHL";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_START";

		if(event=="IDC_SUCHEN_BUT")				scriptexec("WS_SUCHE_SCHLAUCH_TYPEN");
		if(event=="IDC_BUTTON_ANSCHLUESSE")		scriptexec("WS_STORE_SCHLAUCH_TYPEN");
	}
	else if (current_dlg=="IDD_WS_TYPEN_ANSCHLUESSE")
	{
		if(event=="IDC_ZURUECK_BUT")					new_dlg="IDD_WS_TYPEN_SCHLAEUCHE";
		if(event=="IDC_UEBERNEHMEN_BUT")				new_dlg="IDD_PROJECTLISTE";
		if(event=="IDC_HOME_BUT")						new_dlg="IDD_START";

		// aus DLGEVENTS importiert
		if(event=="IDC_BUTTON_SUCHEN_LINKS")	
			scriptexec("WS_SUCHE_ANSCHLUSS_TYPEN");
		if(event=="IDC_BUTTON_SUCHEN_RECHTS")	
			scriptexec("WS_SUCHE_ANSCHLUSS_TYPEN");
		if(event=="IDC_UEBERNEHME_LINKS_BUT")	
			scriptexec("WS_KOPIERE_ANSCHLUSS_TYPEN");
		if(event=="IDC_UEBERNEHME_RECHTS_BUT")	
			scriptexec("WS_KOPIERE_ANSCHLUSS_TYPEN");
		if(event=="IDC_DATENBLATT_BUT")			
			scriptexec("WS_GENERATE_RTF");
		if(event=="IDC_WEITER_BUT")				
			scriptexec("WS_STORE_ANSCHLUSS_TYPEN");
		if(event=="IDC_UEBERNEHMEN_BUT")
		{
			scriptexec("WS_UEBERNEHME_IN_PROJEKTLISTE");
			specialexec("UebernehmeAuswahlInProjektliste");
		}
	}
	else if (current_dlg == "IDD_FIN_DEFAULTS"){
		if (event == "IDC_ANWENDEN_BUT"){
			// Werte sind gesetzt
			copy("IDD_FIN_DEFAULTS", "PROJECT.SETTINGS.FINDEFAULTS");	// neue setzen
			delete ("IDD_FIN_DEFAULTS", "");	// brauchen wir nicht mehr
			new_dlg	= "IDD_PROJECTLISTE";
		}
		else if (event == "IDC_ABBRECHEN_BUT")
			new_dlg	= "IDD_PROJECTLISTE";
	}
	else
	{
		new_dlg=start_dlg;
	}

	if ((new_dlg == "IDD_KP_AUSWAHL") || (new_dlg == "IDD_MB_AUSWAHL") ||
		(new_dlg == "IDD_RH_AUSWAHL") || (new_dlg == "IDD_MS_AUSWAHL"))
	{
		pref.QTY = "1";
	}

	if (new_dlg == "IDD_PROJECTLISTE")
    {
        // ------------------------------------------------------------------------------------------
        // Status-Icons neu setzen:
        var Source, strPos, i;
        var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var nLastPos = getsize(Projectlist, "") - 1;
        for (i = 0; i <= nLastPos; ++i)
        {
            Source = Projectlist + "[" + i + "]";
            var strProductArea  = getstring("PRODUCT_AREA", Source);
            var strCachePdfSap  = getstring("CACHE_DRAWING_FILE_PDF_SAP", Source);
            var strCachePdf     = getstring("CACHE_DRAWING_FILE_PDF", Source);
            var strCacheDxf     = getstring("CACHE_DRAWING_FILE_DXF", Source);
            var strSaptransmit  = getstring("SAP_ORDER_TRANSMITTED", Source)
            var strStatusPreis  = getstring("STATUS_PREIS", Source);
            var strStatusMat    = getstring("STATUS_MATNR", Source);
            var fUnitprice      = getstring("FORCEDUNITPRICE", Source); // Vom VB festgesetzter Stueckpreis, als STRING, kann in Projektliste geändert werden
            fUnitprice      = replace (fUnitprice, ",", ".");

            var bCachePdfExists = false;
            if ((strCachePdf != "") && FileName.fileExists(strCachePdf))
                bCachePdfExists = true;

            var bCachePdfSapExists = false;
            if ((strCachePdfSap != "") && FileName.fileExists(strCachePdfSap))
                bCachePdfSapExists = true;


            if ((strProductArea != "RH") && (strProductArea != "CA") && (strProductArea != "FP"))
            {
                setstring("IMAGE_STATUS", Source, "/EasyKatImages/white.png");
                setstring("IMAGE_VIEW", Source, "/EasyKatImages/WITgifs/blank.png");
            }
            else
            {
                // @@@ Problem: was wenn SAP-Transmitted und dann wieder dirty ... rot/schwarz ???
                if (strProductArea == "FP")
                {
                    var unitPrice = getstring("UNITPRICE", Source);
                    var matNr = getstring("IDENT", Source);
                    matNr = trimleft(matNr, " ");
                    if (strSaptransmit == "true")
                    {
                        if (((inputStringToDouble(unitPrice) <= 0) && (inputStringToDouble(fUnitprice) <= 0)) ||
                            (matNr == ""))
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/red_up.png");
                        else
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/green_up.png");
                    }
                    else
                    {
                        if (((inputStringToDouble(unitPrice) <= 0) && (inputStringToDouble(fUnitprice) <= 0)) ||
                            (matNr == ""))
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/red.png");
                        else
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/green.png");
                    }

                    setstring("IMAGE_VIEW", Source, "/EasyKatImages/WITgifs/blank.png");
                }
                else
                {
                    if (strSaptransmit == "true")
                    {
                        if (((strStatusPreis != "OK") && (inputStringToDouble(fUnitprice) <= 0)) ||
                            (strStatusMat != "OK"))
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/red_up.png");
                        else if (!bCachePdfSapExists)
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/blue_up.png");
                        else
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/green_up.png");
                    }
                    else
                    {
                        if (((strStatusPreis != "OK") && (inputStringToDouble(fUnitprice) <= 0)) ||
                            (strStatusMat != "OK"))
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/red.png");
                        else if (!bCachePdfSapExists)
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/blue.png");
                        else
                            setstring("IMAGE_STATUS", Source, "/EasyKatImages/green.png");
                    }

                    if (bCachePdfExists)
                        setstring("IMAGE_VIEW", Source, "/EasyKatImages/icons/report_picture.png");
                    else
                        setstring("IMAGE_VIEW", Source, "/EasyKatImages/WITgifs/blank.png");
                }
            }
        }

        // ------------------------------------------------------------------------------------------
        // Blätter-Controls:
        var Projectlist			= "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var nAnzPos				= getsize(Projectlist, "");
        var nPageSize			= parseInt(getstring("IDC_ANZAHL_PLIST_ROWS_COMBO", "MISCSTUFF"));
        var i, nLastPage 		= 1;
        var strComboItems 		= "";
		var strComboAnzItems	= "25=25|";
        if (nAnzPos > 0)
        {
            for (i=1; ((i-1) * nPageSize) < nAnzPos; ++i)
            {
                if (i * nPageSize >= nAnzPos)    // d.h. wir sind auf der letzten Seite
                {
                    strComboItems += i + "=" + /* i + "Pos " + */ (((i-1) * nPageSize) + 1) + "-" + nAnzPos + "|";
                    nLastPage = i;
                }
                else
                    strComboItems += i + "=" + /* i + "Pos " + */ (((i-1) * nPageSize) + 1) + "-" + (i * nPageSize) + "|";
            }
        }
		// Kombo für anzuzeigende Positionen
		for (i = 2; i < (parseInt(ceil(nAnzPos/25))+1); i++){
			strComboAnzItems	+= i*25 + "=" + i*25 + "|";
		}
        strComboItems = trimright(strComboItems, "|");
		strComboAnzItems = trimright(strComboAnzItems, "|");
        setstring("IDC_BLAETTER_PLIST_ROWS_COMBO_ITEMS", "MISCSTUFF", strComboItems);
		setstring("IDC_ANZAHL_PLIST_ROWS_COMBO_ITEMS", "MISCSTUFF", strComboAnzItems);

        var nStartRow = 0, nStartPage = 0;
        if (getstring("IDC_BLAETTER_PLIST_ROWS_COMBO", "MISCSTUFF") != "")
            nStartPage = parseInt(getstring("IDC_BLAETTER_PLIST_ROWS_COMBO", "MISCSTUFF"));

        if (event=="BLAETTERN_BACK")
		{
            nStartPage = nStartPage - 1;
            setstring("IDC_BLAETTER_PLIST_ROWS_COMBO", "MISCSTUFF", nStartPage)
        }
        if (event=="BLAETTERN_NEXT")
		{
            nStartPage = nStartPage + 1;
            setstring("IDC_BLAETTER_PLIST_ROWS_COMBO", "MISCSTUFF", nStartPage)
        }
        // Generelle Checks (z.B. wenn Anwender Pagesize ändert, kann er hinter die letzte rutschen ...
        // Unter Seite 1 nie gehen ...
        if (nStartPage < 1)
            nStartPage = 1;
        // Hinter die letzte Seite nie gehen ...
        if ((nStartPage - 1) * nPageSize >= nAnzPos)
            nStartPage = nLastPage;

        // intern wird ab 0 aufwärts gezählt, d.h. nStartRow 20 ist die 21ste Position
        // -1 weil wir in der Combo für die Seiten von 1 an aufwärts zählen
        nStartRow = (nStartPage - 1) * nPageSize;
        setstring("PAGETOPROW", "MISCSTUFF", nStartRow);

        /* wird immer ausgewertet ...
        if(event=="BLAETTER_PLIST_CHANGED")
		{
        }
        */
    }

	// aus DLGEVENTS importiert - immer ausführen
    if (new_dlg == "IDD_WS_TYPEN_ANSCHLUESSE")			scriptexec("WS_INIT_ANSCHLUSS_TYPEN");
    if (new_dlg == "IDD_WS_TYPEN_SCHLAEUCHE")			scriptexec("WS_INIT_SCHLAUCH_TYPEN");

    if (new_dlg != current_dlg)
    {
        // Beim Wechsel auf neue Maske, für diese ein INIT-Event aufrufen
        setstring("EKSUBMITEVENT","","INIT");
        setstring("EVENT","","INIT");
        setstring("AKTUELLE_MASKE","", new_dlg);
   		specialexec("DoAction");
		setTablePriceHeaders();
    }
	
	if (left(event,10) == "IDC_POS_LG")
		setstring("IDC_RADIO_LG_ALT_NEU",	"PROJECT.SETTINGS.CASCADE",	event);
	
	if (event == "IDC_DREHEN_KS_BUT")
	{
		var Koord_Image		= getstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE");
		var Koord_Image_Num	= right(Koord_Image, 1)*1;
		if (Koord_Image_Num < 5)
		{
			Koord_Image_Num	+= 1;
			if (Koord_Image_Num > 4)
				Koord_Image_Num = 1;
		}
		else
		{
			Koord_Image_Num	+= 1;
			if (Koord_Image_Num > 8)
				Koord_Image_Num = 5;
		}
		Koord_Image			= left(Koord_Image, Koord_Image.length-1) + Koord_Image_Num;
		
		setstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE", Koord_Image);
	}
	
	if (left(event, 20) == "IDC_VERTIKALDIR_ACHS")
	{
		var Koord_Image	= "RH_KOORD_V" + right(event, 1) + right(getstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE"), 5);
		setstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE", Koord_Image);
		
		// jetzt noch die Achsen die nicht Vertikal sind definieren (Vorspannung)
		var VertiDir		= toupper(left(right(Koord_Image,6),1));
		if (VertiDir == "Z")
			{
				setstring("IDC_VORSPANNUNG_DIR1", "PROJECT.SETTINGS.CASCADE", "X");
				setstring("IDC_VORSPANNUNG_DIR2", "PROJECT.SETTINGS.CASCADE", "Y");
			}
		else if (VertiDir == "Y")
			{
				setstring("IDC_VORSPANNUNG_DIR1", "PROJECT.SETTINGS.CASCADE", "X");
				setstring("IDC_VORSPANNUNG_DIR2", "PROJECT.SETTINGS.CASCADE", "Z");
			}
		else if (VertiDir == "X")
			{
				setstring("IDC_VORSPANNUNG_DIR1", "PROJECT.SETTINGS.CASCADE", "Y");
				setstring("IDC_VORSPANNUNG_DIR2", "PROJECT.SETTINGS.CASCADE", "Z");
			}
		else
			{
				setstring("IDC_VORSPANNUNG_DIR1", "PROJECT.SETTINGS.CASCADE", "");
				setstring("IDC_VORSPANNUNG_DIR2", "PROJECT.SETTINGS.CASCADE", "");
			}
	}
	
	if (left(event, 19) == "IDC_VERTIKALDIR_DEF")
	{
		var Koord_Image		= getstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE");
		var Koord_Image_Num	= right(Koord_Image, 1)*1;
		if ((right(event, 2) == "AB") && ((Koord_Image_Num + 4) < 9))
		{
			Koord_Image_Num += 4;
		}
		else if ((right(event, 3) == "AUF") && ((Koord_Image_Num - 4) > 0))
		{
			Koord_Image_Num -= 4;
		}
		Koord_Image			= left(Koord_Image, Koord_Image.length-1) + Koord_Image_Num;
		setstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE", Koord_Image);
	}
	
	if (event == "IDC_WI_MARK_SIGN_EDIT"){
		var strTrennzeichenMark = trimleft(trimright(getstring("WI_MARK_SIGN","PROJECT.SETTINGS"), " "), " ");
		if (strTrennzeichenMark == ";" || strTrennzeichenMark == "|"){
			setstring("WI_MARK_SIGN","PROJECT.SETTINGS", ",");
			setstring("ERRORMESSAGE", "TEMP", "Achtung! Semikolon bzw. '|' nicht zulässig! Komma gewählt.");
		}
	}
	
	//------------------------------------------------------------------------------------------------
	//PROJECT.SETTINGS.VERTRIEBSADRESSEN_COMBO_ITEMS
	var Selected			= getstring("VERTRIEBSADRESSEN_COMBO",	"PROJECT.SETTINGS");
	var Vertriebsadressen	= getstring("VERTRIEBSADRESSEN_COMBO_ITEMS", "PROJECT.SETTINGS");
	var SearchSlected		= false;
	if (Vertriebsadressen == "" || Vertriebsadressen == "undefined" || rfind(Vertriebsadressen, "=|") > (-1)){
		SearchSlected		= true;
		var strSQLStatement	= "select * from VERTRIEBSADRESSEN order by abs(SEQ_ID)";
		Vertriebsadressen	= "";
		var numRet			= dbselect("CASCADE", strSQLStatement, "ADRESSEN");
		
		while (dbiseof("ADRESSEN") == 0)
		{
			Vertriebsadressen	+= dbgetstring("ADRESSEN", "INTERN") + "=" + translate(dbgetstring("ADRESSEN", "TEXT")) + "|";
			
			dbskip("ADRESSEN");
		}
		
		Selected = left(Vertriebsadressen, Vertriebsadressen.indexOf( "=" ));
		/*
		if (getstring("RTWUser", "") == "true")
			Selected = "WSW";
		*/
		setstring("VERTRIEBSADRESSEN_COMBO_ITEMS",	"PROJECT.SETTINGS", trimright(Vertriebsadressen, "|"));
	}
	
	if ((event == "IDC_WI_DRUCK_VERTRETUNG" || event == "" || event == "IDC_LADEN_BUT_NEU" || event == "IDC_NEUESPROJEKT_BUT" || event == "RECALC_AG_TEXTBLOCK")
		&& getstring("CLIENTVERSION", "RIGHTS") == "false"){
		//var DruckVertretung	= getbool("DRUCK_VERTRETUNG_CHECKBOX", "");
		if (getbool("DRUCK_VERTRETUNG_CHECKBOX", "")){
			var CurrentLanguage		= getlanguage();
			var CommunicationLang	= getstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS");
			setlanguage(CommunicationLang);
			setstring("VERTRETUNG_LABEL",	"PROJECT.SETTINGS.AG_TEXTE",	translate("PRINT_VERTRETUNG") + ":");
			setstring("VERTRETUNG_NAME1",	"PROJECT.SETTINGS.AG_TEXTE",	getstring("Name", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative"));
			if (getstring("Name2", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative") != "")
				setstring("VERTRETUNG_NAME2",	"PROJECT.SETTINGS.AG_TEXTE",	" - " + getstring("Name2", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative"));
			setstring("VERTRETUNG_STRASSE",	"PROJECT.SETTINGS.AG_TEXTE",	getstring("Street", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative"));
			if (getstring("PostalCode", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative") != "")
				setstring("VERTRETUNG_PLZ",		"PROJECT.SETTINGS.AG_TEXTE",	getstring("PostalCode", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative") + " ");
			setstring("VERTRETUNG_ORT",		"PROJECT.SETTINGS.AG_TEXTE",	getstring("City", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative"));
			setstring("VERTRETUNG_TEL",		"PROJECT.SETTINGS.AG_TEXTE",	translate("IDC_TELEFON_AN_LABEL") + ": " + getstring("Telephone", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative"));
			setstring("VERTRETUNG_FAX",		"PROJECT.SETTINGS.AG_TEXTE",	translate("IDC_FAX_AN_LABEL") + ": " + getstring("Fax", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative"));
			setstring("VERTRETUNG_MAIL",	"PROJECT.SETTINGS.AG_TEXTE",	translate("IDC_MAIL_AN_LABEL") + ": " + getstring("EMail", "DATA.CRM_XML_IMPORT.QuoteRetrieve.SalesRepresentative"));
			setlanguage(CurrentLanguage);
		}
		else{
			setstring("VERTRETUNG_LABEL",	"PROJECT.SETTINGS.AG_TEXTE",	"");
			setstring("VERTRETUNG_NAME1",	"PROJECT.SETTINGS.AG_TEXTE",	"");
			setstring("VERTRETUNG_NAME2",	"PROJECT.SETTINGS.AG_TEXTE",	"");
			setstring("VERTRETUNG_STRASSE",	"PROJECT.SETTINGS.AG_TEXTE",	"");
			setstring("VERTRETUNG_PLZ",		"PROJECT.SETTINGS.AG_TEXTE",	"");
			setstring("VERTRETUNG_ORT",		"PROJECT.SETTINGS.AG_TEXTE",	"");
			setstring("VERTRETUNG_TEL",		"PROJECT.SETTINGS.AG_TEXTE",	"");
			setstring("VERTRETUNG_FAX",		"PROJECT.SETTINGS.AG_TEXTE",	"");
			setstring("VERTRETUNG_MAIL",	"PROJECT.SETTINGS.AG_TEXTE",	"");
		}
	}
	
	if ((event == "" || event == "IDC_LADEN_BUT_NEU" || event == "IDC_NEUESPROJEKT_BUT") && getstring("CLIENTVERSION", "RIGHTS") == "false")
	{
		/*
		if (toupper(getstring("DISABLE_CRM", "PROJECT.SETTINGS")) == "TRUE"){
			// ToDo auswerten von Feldern die von CRM befüllt werden (Firmenmane, User, ...) um die Zugehörigkeit zu bestimmen
			Selected		= "EMPTY";
		}
		else if (typeof( Object.fromStorage("PROJECT.SETTINGS.VIS") ) == "object" || event == "IDC_LADEN_BUT_NEU"){
		*/
		//if (typeof(Object.fromStorage("PROJECT.SETTINGS.VIS")) == "object" || toupper(getstring("DISABLE_CRM", "PROJECT.SETTINGS")) == "TRUE"){
		//if (toupper(getstring("VISBUTTON_COMMENT_START", "DLGDATA")) == "FALSE" || toupper(getstring("DISABLE_CRM", "PROJECT.SETTINGS")) == "TRUE"){
		if (toupper(getstring("VISBUTTON_COMMENT_START", "DLGDATA")) == "FALSE" ||
			toupper(getstring("DISABLE_CRM", "PROJECT.SETTINGS")) == "TRUE" ||
			SearchSlected){	// VIS/CRM oder Normal ohne Vorbelegung
			// auswerten von Feldern die von VIS befüllt werden (Firmenmane, User, ...) um die Zugehörigkeit zu bestimmen
			// in VIS gibst leider nichts eindeutiges -> wir versuchen es mit der Telefonnummer
			// das klappt gut -> auch der CRM-Fall wird so abgedeckt - Problem Handynummern
			Selected		= "EMPTY";	// hier EMPTY da z.B. auch WI Mitarbeiter bei WS Angebote machen
			var MacheWeiter	= true;
			// CRM - Zuordnung mittels SalesOffice
			if (typeof( Object.fromStorage("DATA.CRM_XML_IMPORT") ) == "object"){
				var SalesOffice		= getstring("SalesOffice", "DATA.CRM_XML_IMPORT.QuoteRetrieve");
				var SalesOfficeNo	= "";
				for (var TXTPos = 0; TXTPos < SalesOffice.length; TXTPos++)
				{
					if ((SalesOffice[TXTPos]*1 >= 0) && (SalesOffice[TXTPos]*1 <= 9))
						SalesOfficeNo	+= SalesOffice[TXTPos];
				}
				if (SalesOfficeNo*1 >= 1000 && SalesOfficeNo*1 <= 9999){
					var strSQLStatement		= "select * from VERTRIEBSADRESSEN where abs(OFFICE_NO_P1)=" + left(SalesOfficeNo, 2)*1 + " order by abs(SEQ_ID)";
					var numRet				= dbselect("CASCADE", strSQLStatement, "ADRESSEN");
					while (dbiseof("ADRESSEN") == 0 && MacheWeiter){
						var SO_No_P2	= dbgetstring("ADRESSEN", "OFFICE_NO_P2");
						SO_No_P2		= SO_No_P2.split("/");
						var SO_No_Check	= "";
						var No			= 0;
						while (No < SO_No_P2.length && MacheWeiter){
							SO_No_Check	= left(SalesOfficeNo, 2) + "" + SO_No_P2[No];
							if (SO_No_Check*1 == SalesOfficeNo*1){	// wir haben einen Treffer
								MacheWeiter	= false;
							}
							No	+= 1;
						}
						if (MacheWeiter)
							dbskip("ADRESSEN");
					}
				}
			}
			if (MacheWeiter){	// oben kein Treffer oder nicht CRM
				if (typeof( Object.fromStorage("PROJECT.SETTINGS.VIS") ) == "object")
				//if (toupper(getstring("VISBUTTON_COMMENT_START", "DLGDATA")) == "FALSE")	// das geht hier nicht so,auch aus CRM "FALSE" aber Object nicht da!!!
					var TelNr		= getstring("v_Tel",	"PROJECT.SETTINGS.VIS.row[0]");
				else
					var TelNr		= getstring("TELEFON_AN", "PROJECT.SETTINGS");
				var TelNrVergl	= "";
				for (var TXTPos = 0; TXTPos < TelNr.length; TXTPos++)
				{
					if ((TelNr[TXTPos]*1 >= 0) && (TelNr[TXTPos]*1 <= 9))
						TelNrVergl	+= TelNr[TXTPos];
				}
				
				var strSQLStatement		= "select * from VERTRIEBSADRESSEN order by abs(SEQ_ID)";
				var numRet				= dbselect("CASCADE", strSQLStatement, "ADRESSEN");
				var TelNrDB		= "";
				while (dbiseof("ADRESSEN") == 0 && MacheWeiter)
				{
					TelNrDB	= dbgetstring("ADRESSEN", "TEL_NR_VIS_SEARCH");
					TelNrDB	= TelNrDB.split("/");
					for (TNr = 0; TNr < TelNrDB.length; TNr++){
						if (TelNrDB[TNr] != "" && rfind(TelNrVergl, TelNrDB[TNr]) >= 0){
							MacheWeiter	= false;
						}
					}
					if (MacheWeiter)
						dbskip("ADRESSEN");
				}
			}
			if (!MacheWeiter){
				Selected	= dbgetstring("ADRESSEN", "INTERN");
				setstring("FIRMENANSCHRIFT_ZEILE1",	"PROJECT.SETTINGS.AG_TEXTE", dbgetstring("ADRESSEN", "FIRMA"));
				
				if (dbgetstring("ADRESSEN", "POSTFACH") == ""){
					var Zeile2	= dbgetstring("ADRESSEN", "STRASSE") + " - " + dbgetstring("ADRESSEN", "PLZ") + " " + dbgetstring("ADRESSEN", "ORT");
				}
				else{
					var Zeile2	= "POB " + dbgetstring("ADRESSEN", "POSTFACH") + " - " + dbgetstring("ADRESSEN", "POSTFACH_PLZ") + " " + dbgetstring("ADRESSEN", "POSTFACH_ORT");
				}
				setstring("FIRMENANSCHRIFT_ZEILE2",	"PROJECT.SETTINGS.AG_TEXTE",	Zeile2);
				// das sollte aus CRM kommen - ist aber leider oft nicht gepflegt
				if (getstring("PROJECT.SETTINGS", "FIRMENNAME_AN") == "")
					setstring("FIRMENNAME_AN", "PROJECT.SETTINGS", dbgetstring("ADRESSEN", "FIRMA"));
			}
		}
		
		setstring("VERTRIEBSADRESSEN_COMBO_ITEMS",	"PROJECT.SETTINGS", trimright(Vertriebsadressen, "|"));
		setstring("VERTRIEBSADRESSEN_COMBO",		"PROJECT.SETTINGS", Selected);
	}
	
	if (event == "IDC_VERTRIEBSADRESSEN_COMBO" ||
		(event == "" && getstring("CLIENTVERSION", "RIGHTS") == "false"
		&& toupper(getstring("DISABLE_CRM", "PROJECT.SETTINGS")) == "FALSE"		// nicht CRM
		&& typeof( Object.fromStorage("PROJECT.SETTINGS.VIS") ) != "object")){		// nicht VIS
		//&& toupper(getstring("VISBUTTON_COMMENT_START", "DLGDATA")) == "TRUE" ) ){		// nicht VIS
		
		var LocationNew			= getstring("IDC_VERTRIEBSADRESSEN_COMBO",	"IDD_PROJECTLISTE");
		if (LocationNew == "")
			LocationNew			= getstring("VERTRIEBSADRESSEN_COMBO",		"PROJECT.SETTINGS")
		var strSQLStatement		= "select * from VERTRIEBSADRESSEN where INTERN='" + LocationNew + "' order by abs(SEQ_ID)";
		var numRet				= dbselect("CASCADE", strSQLStatement, "ADRESSEN");
		
		while (dbiseof("ADRESSEN") == 0)
		{
			setstring("FIRMENNAME_AN",	"PROJECT.SETTINGS", dbgetstring("ADRESSEN", "FIRMA"));
			setstring("STRASSE_AN",		"PROJECT.SETTINGS", dbgetstring("ADRESSEN", "STRASSE"));
			setstring("ORT_AN",			"PROJECT.SETTINGS", dbgetstring("ADRESSEN", "PLZ") + " " + dbgetstring("ADRESSEN", "ORT"));
			if (toupper(getstring("DISABLE_CRM", "PROJECT.SETTINGS")) == "FALSE") {
				setstring("TELEFON_AN",		"PROJECT.SETTINGS", dbgetstring("ADRESSEN", "TELEFON"));
				setstring("FAX_AN",			"PROJECT.SETTINGS", dbgetstring("ADRESSEN", "FAX"));
			}
			setstring("LAND_AN",		"PROJECT.SETTINGS", dbgetstring("ADRESSEN", "LAND"));
			
			// für den Ausdruck des Angebots
			setstring("FIRMENANSCHRIFT_ZEILE1",	"PROJECT.SETTINGS.AG_TEXTE",	dbgetstring("ADRESSEN", "FIRMA"));
			
			if (dbgetstring("ADRESSEN", "POSTFACH") == ""){
				var Zeile2	= dbgetstring("ADRESSEN", "STRASSE") + " - " + dbgetstring("ADRESSEN", "PLZ") + " " + dbgetstring("ADRESSEN", "ORT");
			}
			else{
				var Zeile2	= "POB " + dbgetstring("ADRESSEN", "POSTFACH") + " - " + dbgetstring("ADRESSEN", "POSTFACH_PLZ") + " " + dbgetstring("ADRESSEN", "POSTFACH_ORT");
			}
			setstring("FIRMENANSCHRIFT_ZEILE2",	"PROJECT.SETTINGS.AG_TEXTE",	Zeile2);
			
			setstring("VERTRIEBSADRESSEN_COMBO",	"PROJECT.SETTINGS", LocationNew);
			
			setstring("IDC_FIRMENNAME_AN",	"IDD_PROJECTLISTE", dbgetstring("ADRESSEN", "FIRMA"));
			setstring("IDC_STRASSE_AN",		"IDD_PROJECTLISTE", dbgetstring("ADRESSEN", "STRASSE"));
			setstring("IDC_ORT_AN",			"IDD_PROJECTLISTE", dbgetstring("ADRESSEN", "PLZ") + " " + dbgetstring("ADRESSEN", "ORT"));
			setstring("IDC_TELEFON_AN",		"IDD_PROJECTLISTE", dbgetstring("ADRESSEN", "TELEFON"));
			setstring("IDC_FAX_AN",			"IDD_PROJECTLISTE", dbgetstring("ADRESSEN", "FAX"));
			setstring("IDC_LAND_AN",		"IDD_PROJECTLISTE", dbgetstring("ADRESSEN", "LAND"));
			
			dbskip("ADRESSEN");
		}
		
		if (trimright(trimleft(getstring("STRASSE_AN", "PROJECT.SETTINGS"), " "), " ") == ""
			|| trimright(trimleft(getstring("ORT_AN", "PROJECT.SETTINGS"), " "), " ") == "")
			setstring ("DISABLE_STRASSE_ORT",	"RIGHTS", "false");
		else
			setstring ("DISABLE_STRASSE_ORT",	"RIGHTS", "true");
	}
	
	if ((event == "" && getstring("CLIENTVERSION", "RIGHTS") == "false") ||	// wir starten (Ist der EVENT kommend aus VIS/CRM auch leer?)
		(event == "IDC_LADEN_BUT_NEU") ||	// wir laden ein Projekt
		(event == "IDC_VERTRIEBSADRESSEN_COMBO")){	// wir haben die Kombo geändert
		// die Werte anhand der Location setzen
		var LocationNew	= getstring("VERTRIEBSADRESSEN_COMBO",	"PROJECT.SETTINGS");
		var strSQLStatement		= "select * from VERTRIEBSADRESSEN where INTERN='" + LocationNew + "' order by abs(SEQ_ID)";
		var numRet				= dbselect("CASCADE", strSQLStatement, "ADRESSEN");
		while (dbiseof("ADRESSEN") == 0)
		{
			setstring("PRINT_CODE",		"PROJECT.SETTINGS.AG_TEXTE", dbgetstring("ADRESSEN", "PRINT_CODE"));	// da gibts nur einen
			setstring("TEXT_LOGO_T1",	"PROJECT.SETTINGS.AG_TEXTE", dbgetstring("ADRESSEN", "TEXT_LOGO_T1"));		// Teil 1 "Arial Narrow 10"
			setstring("TEXT_LOGO_T2",	"PROJECT.SETTINGS.AG_TEXTE", dbgetstring("ADRESSEN", "TEXT_LOGO_T2"));		// Teil 2 "Arial Narrow 9,5"
			setstring("TEXT_LOGO_T3",	"PROJECT.SETTINGS.AG_TEXTE", dbgetstring("ADRESSEN", "TEXT_LOGO_T3"));		// Teil 3 "Arial Narrow 9,5"
			
			// in der Fußzeile haben wir derzeit 5 Spalten mit je 12 Zeilen
			var AnzSpalte	= 5;
			var AnzZeile	= 12;
			var AktPos		= "";
			for (var spalte=1; spalte<=AnzSpalte; spalte++){
				for (var zeile=1; zeile<=AnzZeile; zeile++){
					AktPos	= "S" + spalte + "_Z" + (zeile < 10 ? "0" : "") + zeile;
					setstring(AktPos,	"PROJECT.SETTINGS.AG_TEXTE", dbgetstring("ADRESSEN", AktPos));
				}
			}
			dbskip("ADRESSEN");
		}
		// Reparatur alter aus VIS exportierter Projekte
		if (!getstring("CURRENCY_UNIT_CRM_VISIBILITY_CRM", "PROJECT.SETTINGS.WUR"))
			setstring("CURRENCY_UNIT_CRM_VISIBILITY_CRM", "PROJECT.SETTINGS.WUR", "hidden");
		if (!getstring("CURRENCY_UNIT_ITEMS", "PROJECT.SETTINGS.WUR"))
			setstring("CURRENCY_UNIT_ITEMS", "PROJECT.SETTINGS.WUR", "EUR=EUR|CZK=CZK|USD=USD|GBP=GBP|RUB=RUB|JPY=JPY|CNY=CNY|CHF=CHF");
	}
	
	if ((event == "RECALC_AG_TEXTBLOCK") ||
		(event == "") ||
		(event == "IDC_LADEN_BUT_NEU" && getstring("ADD_PRICE_LINE1_LABEL", "PROJECT.SETTINGS.AG_TEXTE") == "") ||
		(event == "IDC_PREISE_AKTUALISIEREN_BUT") ||
		(event == "IDC_VERTRIEBSADRESSEN_COMBO")){		// wg. der IATF-Texte
		var CurrentLanguage		= getlanguage();
		//var CommunicationLang	= getstring("IDC_WI_SPRACHEKOMM_COMBO", "IDD_PROJECTLISTE");
		var CommunicationLang	= getstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS");
		var Line				= 1;
		setlanguage(CommunicationLang);
		var Projektrabatt	= getstring("PROJRABATT",	"PROJECT.SETTINGS");
		if (Projektrabatt != "" && Projektrabatt*1 != 0){
			setstring("ADD_PRICE_LINE"+Line+"_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", translate("IDC_WI_PROJRABATT_LABEL"));
			setstring("ADD_PRICE_LINE"+Line+"_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", sprintf("%.2f", Projektrabatt));
			setstring("ADD_PRICE_LINE"+Line+"_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", "%");
			Line	+= 1;
		}
		else{
			setstring("ADD_PRICE_LINE1_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE1_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE1_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
		}
		//var Verpackungspreis	= getstring("IDC_WI_VERPACKUNGPREIS_EDIT",	"IDD_PROJECTLISTE");
		var Verpackungspreis	= getstring("WI_VERPACKUNGPREIS",	"PROJECT.SETTINGS");
		if (Verpackungspreis != "" && Verpackungspreis*1 != 0){
			setstring("ADD_PRICE_LINE"+Line+"_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", translate("IDC_WI_VERPACKUNGPREIS_LABEL"));
			setstring("ADD_PRICE_LINE"+Line+"_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", sprintf("%.2f", Verpackungspreis));
			setstring("ADD_PRICE_LINE"+Line+"_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", getstring("AG_CURRENCY_UNIT", "PROJECT.SETTINGS.AG_TEXTE"));
			Line	+= 1;
		}
		else{
			setstring("ADD_PRICE_LINE2_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE2_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE2_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
		}
		//var Frachtpreis			= getstring("IDC_WI_FRACHTPREIS_EDIT",		"IDD_PROJECTLISTE");
		var Frachtpreis			= getstring("WI_FRACHTPREIS",		"PROJECT.SETTINGS");
		if (Frachtpreis != "" && Frachtpreis*1 != 0){
			setstring("ADD_PRICE_LINE"+Line+"_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", translate("IDC_WI_FRACHTPREIS_LABEL"));
			setstring("ADD_PRICE_LINE"+Line+"_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", sprintf("%.2f", Frachtpreis));
			setstring("ADD_PRICE_LINE"+Line+"_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", getstring("AG_CURRENCY_UNIT", "PROJECT.SETTINGS.AG_TEXTE"));
			Line	+= 1;
		}
		else{
			setstring("ADD_PRICE_LINE3_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE3_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE3_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
		}
		//var Dokupreis			= getstring("IDC_WI_RUESTPREIS_EDIT",		"IDD_PROJECTLISTE");
		var Dokupreis			= getstring("WI_RUESTPREIS",		"PROJECT.SETTINGS");
		if (Dokupreis != "" && Dokupreis*1 != 0){
			setstring("ADD_PRICE_LINE"+Line+"_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", translate("IDC_WI_RUESTPREIS_LABEL"));
			setstring("ADD_PRICE_LINE"+Line+"_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", sprintf("%.2f", Dokupreis));
			setstring("ADD_PRICE_LINE"+Line+"_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", getstring("AG_CURRENCY_UNIT", "PROJECT.SETTINGS.AG_TEXTE"));
			Line	+= 1;
		}
		else{
			setstring("ADD_PRICE_LINE4_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE4_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE4_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
		}
		//var Kennzeichnungspreis	= getstring("IDC_WI_KENNZPOSPREIS_EDIT",	"IDD_PROJECTLISTE");
		var Kennzeichnungspreis	= getstring("WI_KENNZPOSPREIS",	"PROJECT.SETTINGS");
		if (Kennzeichnungspreis != "" && Kennzeichnungspreis*1 != 0){
			setstring("ADD_PRICE_LINE"+Line+"_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", translate("IDC_WI_KENNZPOSPREIS_LABEL"));
			setstring("ADD_PRICE_LINE"+Line+"_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", sprintf("%.2f", Kennzeichnungspreis));
			setstring("ADD_PRICE_LINE"+Line+"_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", getstring("AG_CURRENCY_UNIT", "PROJECT.SETTINGS.AG_TEXTE"));
			Line	+= 1;
		}
		else{
			setstring("ADD_PRICE_LINE5_LABEL",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE5_EDIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("ADD_PRICE_LINE5_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
		}
		// ggf. Vorgabe Projektpreis
		if (getstring("PROJENDPREIS_VORGABE", "PROJECT.SETTINGS")*1 > 0){
			setstring("PROJ_VPRICE_TXT",	"PROJECT.SETTINGS.AG_TEXTE", translate("IDC_WI_PROJENDPREIS_VORGABE_LABEL"));
			setstring("PROJ_VPRICE",		"PROJECT.SETTINGS.AG_TEXTE", sprintf("%.2f", getstring("PROJENDPREIS_VORGABE", "PROJECT.SETTINGS")));
			setstring("PROJ_VPRICE_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", getstring("AG_CURRENCY_UNIT", "PROJECT.SETTINGS.AG_TEXTE"));
		}
		else{
			setstring("PROJ_VPRICE_TXT",	"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("PROJ_VPRICE",		"PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("PROJ_VPRICE_UNIT",	"PROJECT.SETTINGS.AG_TEXTE", "");
		}
		
		// IATF-Texte
		var LocationNew	= getstring("VERTRIEBSADRESSEN_COMBO",	"PROJECT.SETTINGS");
		var strSQLStatement		= "select * from VERTRIEBSADRESSEN where INTERN='" + LocationNew + "' order by abs(SEQ_ID)";
		var numRet				= dbselect("CASCADE", strSQLStatement, "ADRESSEN");
		while (dbiseof("ADRESSEN") == 0)
		{
			setstring("ITAF_TEXT",	"PROJECT.SETTINGS.AG_TEXTE", translate(dbgetstring("ADRESSEN", "IATF_TEXT")));
			dbskip("ADRESSEN");
		}
		
		setlanguage(CurrentLanguage);
	}
	
	// für Projekte die gespeichert wurden als diese Funktionalität noch nicht gegeben war
	// Zeile 1 und 2 muss neu "berechnet" und die ursprünglichen Werte übernommen werden "Freie Eingabe"
	if (event == "IDC_LADEN_BUT_NEU" && getstring("FIRMENANSCHRIFT_ZEILE1", "PROJECT.SETTINGS.AG_TEXTE") == ""){
		setstring("VERTRIEBSADRESSEN_COMBO",	"PROJECT.SETTINGS", "EMPTY");
		event = "IDC_FIRMENNAME_AN";	// zur Neuberechnung der Texte
	}
	
	//if (getstring("DISABLE_CRM", "PROJECT.SETTINGS") == "true" || typeof( Object.fromStorage("PROJECT.SETTINGS.VIS") ) == "object"){	// CRM oder VIS
	//if (toupper(getstring("DISABLE_CRM", "PROJECT.SETTINGS")) == "TRUE" || toupper(getstring("VISBUTTON_COMMENT_START", "DLGDATA")) == "FALSE"){	// CRM oder VIS
	if (toupper(getstring("VISBUTTON_COMMENT_START", "DLGDATA")) == "FALSE" ||
		toupper(getstring("DISABLE_CRM", "PROJECT.SETTINGS")) == "TRUE"){	// CRM oder VIS
		setstring ("DISABLE_VERTRIEBSFELD",	"RIGHTS", "false");
		setstring ("PREVENT_FIRMA_SELECT",	"RIGHTS", "true");
		//if (event == "")
		// leider sind die Daten aus CRM nur schlecht befüllt - wir nehmen die Defaults wenn möglich
		if (event == "" && Selected == "EMPTY")
			event	= "IDC_FIRMENNAME_AN";
	}
	else if (getstring("VERTRIEBSADRESSEN_COMBO", "PROJECT.SETTINGS") != "EMPTY"){	// LocationNew
		setstring ("DISABLE_VERTRIEBSFELD",	"RIGHTS", "true");
		setstring ("PREVENT_FIRMA_SELECT",	"RIGHTS", "false");
		setstring ("DISABLE_CRM", "PROJECT.SETTINGS", "false");
	}
	else{	// nicht VIS, nicht CRM und keine passender Select zur Tel.-Nr.
		setstring ("DISABLE_VERTRIEBSFELD",		"RIGHTS", "false");
		//setstring ("PREVENT_FIRMA_SELECT",		"RIGHTS", "true");
		setstring ("PREVENT_FIRMA_SELECT",		"RIGHTS", "false");
		setstring ("FIRMENANSCHRIFT_ZEILE1",	"PROJECT.SETTINGS.AG_TEXTE",	"");
		setstring ("FIRMENANSCHRIFT_ZEILE2",	"PROJECT.SETTINGS.AG_TEXTE",	"");
		setstring ("DISABLE_CRM",				"PROJECT.SETTINGS",				"false");
		event	= "IDC_FIRMENNAME_AN";
	}
	
	if ((event == "IDC_FIRMENNAME_AN" || event == "IDC_STRASSE_AN" || event == "IDC_ORT_AN")){	// Fall freie Eingabe oder gezielte Neuberechnung für CRM/VIS
		setstring("FIRMENANSCHRIFT_ZEILE1",	"PROJECT.SETTINGS.AG_TEXTE",	getstring("FIRMENNAME_AN", "PROJECT.SETTINGS"));
		setstring("FIRMENANSCHRIFT_ZEILE2",	"PROJECT.SETTINGS.AG_TEXTE",	getstring("STRASSE_AN", "PROJECT.SETTINGS") + " - " + getstring("ORT_AN", "PROJECT.SETTINGS"));
	}
	
	
	//------------------------------------------------------------------------------------------------
	
	//------------------------------------------------------------------------------------------------
	// beim Kopieren müssen manche Werte ggf. automatisch rückgesetzt werden wenn die Pos. bearbeitet wird
	// wir setzen hier eine COPYED-Flag damit wir die Werte dann bei bedarf löchen können
	// das betrifft "Zusatzmarkierung", "Zusatzlast aus EG", ...
	if (event == "IDC_AUSWAHL_KOPIEREN_BUT"){
		var Anz = getsize("PROJECT.POSITIONS.PROJECTLIST_ITEMS", "");
		var LastPosNr	= toupper(getstring("POS", "IT"));
		var TempSplit	= LastPosNr.split("A");
		LastPosNr		= "";
		for (var Splt=0; Splt < TempSplit.length; Splt++){
			if (TempSplit[Splt] != "")	// wir haben eine Alternativposition
				LastPosNr	+= TempSplit[Splt];
		}
		for (var CopyedItems = 0; CopyedItems < Anz; CopyedItems++){
			var ActPosNr	= toupper(getstring("POS", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+CopyedItems+"]"));
			TempSplit		= ActPosNr.split("A");
			ActPosNr		= "";
			for (Splt=0; Splt < TempSplit.length; Splt++){
				if (TempSplit[Splt] != "")	// wir haben eine Alternativposition
				ActPosNr	+= TempSplit[Splt];
			}
			if (ActPosNr*1 > LastPosNr*1)
				setstring("COPYED_FLAG", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+CopyedItems+"]", "true");
		}
	}
	
	if (event == "IDC_TYP_TRAEGER_COMBO"){
		var TypTraeger			= getstring("IDC_TYP_TRAEGER_COMBO", "IDD_FIN_DEFAULTS");
		setstring("IDC_TYP_TRAEGER_COMBO",	"PROJECT.SETTINGS.FINDEFAULTS",	TypTraeger);
		TypTraeger				= TypTraeger.split("_");
		TypTraeger				= TypTraeger[0] + (TypTraeger.length == 1 ? "" : "_A");
		var strSQL				= "select * from TRAEGER_" + TypTraeger + " order by abs(KUERZEL) ";
		var SubtypComboSelect	= "";
		var SubtypComboValues	= "";
		var FirstValue			= 1;
		dbselect("CASCADE", strSQL, "TR_KUERZEL");
		while ( dbiseof("TR_KUERZEL") == 0){
			SubtypComboValues	+= dbgetstring("TR_KUERZEL", "KUERZEL") + "=" + dbgetstring("TR_KUERZEL", "KUERZEL") + "|";
			if (FirstValue){
				SubtypComboSelect	= dbgetstring("TR_KUERZEL", "KUERZEL");
				FirstValue			= 0;
			}
			dbskip( "TR_KUERZEL" );
		}
		SubtypComboValues	= trimright(SubtypComboValues, "|");
		setstring("IDC_SUBTYP_TRAEGER_COMBO",			"PROJECT.SETTINGS.FINDEFAULTS",	SubtypComboSelect);
		setstring("IDC_SUBTYP_TRAEGER_VALUES",			"PROJECT.SETTINGS.FINDEFAULTS",	SubtypComboValues);
	}
	
	if (event == "IDC_TYP_TRAEGER_LAGER_COMBO"){
		var TypTraeger			= getstring("IDC_TYP_TRAEGER_LAGER_COMBO", "IDD_FIN_DEFAULTS");
		setstring("IDC_TYP_TRAEGER_LAGER_COMBO",	"PROJECT.SETTINGS.FINDEFAULTS",	TypTraeger);
		//TypTraeger				= TypTraeger.split("_");
		//TypTraeger				= TypTraeger[1] + (TypTraeger.length == 2 ? "" : "_" + TypTraeger[2]);
		var strSQL				= "select * from " + TypTraeger + " order by abs(B) ";
		var SubtypComboSelect	= "";
		var SubtypComboValues	= "";
		var FirstValue			= 1;
		dbselect("LAGER2", strSQL, "TR_KUERZEL");
		while ( dbiseof("TR_KUERZEL") == 0){
			SubtypComboValues	+= dbgetstring("TR_KUERZEL", "TRAE_GR") + "=" + dbgetstring("TR_KUERZEL", "TRAE_GR") + "|";
			if (FirstValue){
				SubtypComboSelect	= dbgetstring("TR_KUERZEL", "TRAE_GR");
				FirstValue			= 0;
			}
			dbskip( "TR_KUERZEL" );
		}
		SubtypComboValues	= trimright(SubtypComboValues, "|");
		setstring("IDC_SUBTYP_TRAEGER_LAGER_COMBO",		"PROJECT.SETTINGS.FINDEFAULTS",	SubtypComboSelect);
		setstring("IDC_SUBTYP_TRAEGER_LAGER_VALUES",	"PROJECT.SETTINGS.FINDEFAULTS",	SubtypComboValues);
	}
	
	/*
	if (event == "IDC_DRUCKEN_BUT"){
		//specialexec("ProjectRecalcPrices");
		//doAktualisierung();
		if (trimright(trimleft(getstring("IDC_WI_PROJENDPREIS_VORGABE_EDIT", "IDD_PROJECTLISTE"), " "), " ") == ""){
			setstring("AG_HINWEIS_VORGABE", "PROJECT.SETTINGS.AG_TEXTE", "");
			setstring("AG_PREIS", "PROJECT.SETTINGS.AG_TEXTE", getstring("IDC_WI_PROJENDPREIS_EDIT", "IDD_PROJECTLISTE"));
		}
		else{
			setstring("AG_HINWEIS_VORGABE", "PROJECT.SETTINGS.AG_TEXTE", "(" + getstring("QUOT_LINE3LABEL", "PROJECT.SETTINGS") + ")");
			setstring("AG_PREIS", "PROJECT.SETTINGS.AG_TEXTE", getstring("IDC_WI_PROJENDPREIS_VORGABE_EDIT", "IDD_PROJECTLISTE"));
		}
	}
	*/
	
	if (event == "IDC_PREIS_IMPORT"){
		var oRet =	{
					success : false,
					message : ""
					};
		LoadPriceCSV(oRet);
		specialexec("ProjectRecalcPrices");
		setstring("TEMP.ERRORMESSAGE", "", oRet.message);
		//setstring("TEMP.ERRORMESSAGE", "", "Zeile 1\r\nZeile 2");
	}
	
	return new_dlg;

}

function LoadPriceCSV(oRet){
	var TempPosPrice	= [];
	var strCSVFile 		= filedialog( 1, 'csv', '', 'CSV File|*.csv||', '' );
	if (strCSVFile != ""){
		var Projectlist = Object.fromStorage( "PROJECT.POSITIONS.PROJECTLIST_ITEMS" );
		var PrjListLen	= Projectlist.length;
		var File		= readfile(strCSVFile).split("\r\n");
		var RelPos		= 0;
		// erste Zeile ist Ueberschrift -> daher a=1
		for (var a=1; a<File.length ;a++){
			if (trimleft(trimright(File[a], " "), " ") != ""){
				if (rfind(File[a], ";") < 0)
					File[a]	+= ";";
				TempPosPrice	= File[a].split(";");
				var GoOn		= true;
				var PosCheck	= false;
				var i			= 0;
				RelPos			+= 1;
				while (GoOn){
					for (i; i<PrjListLen; i++){
						if (Projectlist[i].POS + "" == TempPosPrice[0] + ""){
							if (TempPosPrice[1]*1 > 0){
								//var UnitpriceOld	= getstring("UNITPRICE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + i + "]")*1;
								var UnitpriceOld	= Projectlist[i].UNITPRICE*1;
								var UnitpriceNew	= TempPosPrice[1]*1;
								if (UnitpriceNew < UnitpriceOld){
								//if (getstring("UNITPRICE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + i + "]")*1 < TempPosPrice[1]*1){
									oRet.message	+= translate("POSITION") + " " + TempPosPrice[0]
									+ " " + translate("IDC_LISTENPREIS_LABEL") + " " + UnitpriceOld + " " + getstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR")
									+ " | " + translate("Vorgabepreis") + " " + UnitpriceNew + " " + getstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR") + "!\r\n";
								}
								// zuerst loeschen
								setstring ("FORCEDUNITPRICE_EURO", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + i + "]", "");
								setstring ("FORCEDUNITPRICE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + i + "]", "");
								// dann neu setzen
								setstring ("FORCEDUNITPRICE_EURO", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + i + "]", TempPosPrice[1]);
								setstring ("FORCEDUNITPRICE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + i + "]", (getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR")*1) * (TempPosPrice[1]*1));
							}
							else{
								oRet.message	+= translate("POSITION") + " " + TempPosPrice[0] + " " + translate("Vorgabepreis") + " " + TempPosPrice[1]*1 + " " + getstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR") + "!\r\n";
								setstring ("FORCEDUNITPRICE_EURO", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + i + "]", "");
								setstring ("FORCEDUNITPRICE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS[" + i + "]", "");
							}
							i	= PrjListLen;
							PosCheck	= true;
						}
					}
					GoOn	= false;
					if (!PosCheck){
						oRet.message	+= translate("Import") + " " + translate("POSITION") + " " + TempPosPrice[0] + " not in " + translate("IDC_PROJEKTLISTE_LABEL") + "!\r\n";
					}
				}
			}
		}
		oRet.success	= true;
		if (PrjListLen != RelPos){
			oRet.message	+= translate("IDC_PROJEKTLISTE_LABEL") + ": " + PrjListLen + " | "
			+ translate("Import") + ": " + RelPos + "!";
		}
	}
	else
		oRet.message = "Abort by user.";
	return oRet;
}

function check_Version(MAJOR,MINOR){
	var ERROR	= false;
	if (((MAJOR * 1) < 4) || (((MAJOR * 1) == 4) && ((MINOR * 1) < 4))){
		ERROR	= true;
	}
	return (ERROR)
}
