
//#############################################################################
//
// Author:		H.M. Bauer / M. Wille
// Copyright:	Plan Software GmbH, Saarbrcken
//
//#############################################################################

function importTCAfile(strTCAfile)
{

	var strPrgPath  = getstddirectory("PROGRAM");
	var dataDir = strPrgPath;  // "catalog/data/sap/";

    if (strTCAfile == "")
	{
		var strUserTcaPath = getstring("IMPORT_TCA_VERZEICHNIS", "");
        strTCAfile = filedialog(1, "TCA", "", "TCA-Files|*.TCA;*.tca||", strUserTcaPath); // 1 = Open-Dialog
	}

    if (strTCAfile != "")
    {
		var strDir = FileName.getDir(strTCAfile);
		setstring("IMPORT_TCA_VERZEICHNIS", "", strDir);
		var iniFilename = getinipath();
		writeinistring(iniFilename, "CA_SETTINGS", "IMPORT_TCA_VERZEICHNIS", strDir);
	
        var tca = new TCAimport();
        // Test: var i = tca.abbZuGrad("S 20 W");

        var nRet = tca.readImportFile(strTCAfile);
    
        if (nRet)
            nRet = tca.analyseImport();

        if (nRet)
        {
            var _storeBasePath = "DLGDATA.CA.FORMS";
            
            if (tca.orientation == 0)   // horizontal
                setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", _storeBasePath, "HORIZONTAL");
            else
            {
                setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", _storeBasePath, "VERTIKAL");
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", _storeBasePath, "HAENGEND_DOPPEL");
            }
            if (tca.m_attachmentName != "")
                setstring("UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", _storeBasePath, tca.m_attachmentName);
            else
                setstring("UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", _storeBasePath, tca.name);
            setstring("UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR", _storeBasePath, tca.m_drawingNumber);
                
            // var form = Object.fromStorage( _storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT");

            var oTable = {  bewegung:       ["", "", abs(tca.movementZ)],
                            einfuegepunkt:  ["", "", tca.SysLevel],
                            last:           ["", "", tca.forcesZ],
                            schraegzug:     ["", "", tca.alpha],
                            ueberlast:      ["", "", tca.Testload],
                            zusatzlast:     ["", "", ""] };
                            
            oTable.toStorage(_storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE", false);

            if (tca.movementZ > 0)
                setstring("SOLLWERTE_HALTERUNGSPUNKT.IDC_RICHTUNG_BEWEGUNG", _storeBasePath, "AUF");
            else
                setstring("SOLLWERTE_HALTERUNGSPUNKT.IDC_RICHTUNG_BEWEGUNG", _storeBasePath, "AB");

            // int atyp = A_LASTKETTE;
            var strHangerTyp = tca.hangerTyp;
            if (strHangerTyp == "FH")
            {
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, "BEWEGLICH");
            }
            else if (strHangerTyp == "FS")
            {
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, "BEWEGLICH");
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", _storeBasePath, "STUETZEND_EINFACH");
            }
            else if(strHangerTyp == "KH")
            {
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, "BEWEGLICH");
                // pLKneu->b_direktwahl    = DIREKT_KH;
            }
            else if (strHangerTyp == "KS")
            {
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, "BEWEGLICH");
                // pLKneu->b_direktwahl    = DIREKT_KH;
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", _storeBasePath, "STUETZEND_EINFACH");
            }
            else if (strHangerTyp == "SC")
            {
                // @@@@  atyp = A_STAUFFSCHELLE;
            }
            else if (strHangerTyp == "SH")
            {
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, "STARR");
            }
            else if (strHangerTyp == "GS")
            {
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, "GELENKSTREBE");
            }
            else if (strHangerTyp == "FG")
            {
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, "GELENKSTUETZE");
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", _storeBasePath, "STUETZEND_EINFACH");
            }
            else if (strHangerTyp == "AC")	// Schelle einzeln whlen
            {
                setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, "EINZEL_SCHELLE");
            }
            
            setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_NENNWEITE_DN", _storeBasePath, tca.nominalBore);
            setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER", _storeBasePath, tca.outsideDiameter);
            setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_MEDIUM", _storeBasePath, tca.designTemperature);
            setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_REFERENZ", _storeBasePath, tca.designTemperature);
            setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_UMGEBUNG", _storeBasePath, tca.projectTemperature);
            setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE", _storeBasePath, tca.insulation);
            
            // Fr Lager:
            setstring("LAGER_BETRIEBSBEDINGUNGEN.IDC_TEMPERATUR_TS", _storeBasePath, tca.designTemperature);
            setstring("LAGER_BETRIEBSBEDINGUNGEN.IDC_DAEMMDICKE", _storeBasePath, tca.insulation);
            setstring("LAGER_AUSWAHL.IDC_NENNWEITE", _storeBasePath, tca.nominalBore);
            setstring("LAGER_AUSWAHL.IDC_AUSSENDURCHMESSER", _storeBasePath, tca.outsideDiameter);

            // Lageplan-Daten aus TCA bernehmen:
            setstring("LAGEPLAN_C", "DLGDATA.CA.FORMS.LAGEPLAN", tca.ewAxis1);
            setstring("LAGEPLAN_D", "DLGDATA.CA.FORMS.LAGEPLAN", tca.ewAxis2);
            setstring("LAGEPLAN_A", "DLGDATA.CA.FORMS.LAGEPLAN", tca.nsAxis2);
            setstring("LAGEPLAN_B", "DLGDATA.CA.FORMS.LAGEPLAN", tca.nsAxis1);
            setstring("LAGEPLAN_X", "DLGDATA.CA.FORMS.LAGEPLAN", tca.xDistance);
            setstring("LAGEPLAN_Z", "DLGDATA.CA.FORMS.LAGEPLAN", tca.yDistance);
            setstring("LAGEPLAN_Y", "DLGDATA.CA.FORMS.LAGEPLAN", tca.flowDirection);

            // Pfad / Projektname :
            if (tca.m_pfad != "")
            {
                var projFile = tca.pipeName;
                if (projFile.length > 0)
                {
                    if (left(projFile, 1) == "/")
                        projFile = right(projFile, projFile.length -1);
                }
                if (right(tca.m_pfad, 1) != "\\")
                    tca.m_pfad = tca.m_pfad + "\\";
                
                setstring("PROJECT.PROJECTPATH", "", tca.m_pfad + projFile + ".wit");
                setstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS", tca.m_pfad);
                setstring("EXPORT_STK_VERZEICHNIS", "", tca.m_pfad);
            }
        }
        
        delete(tca);
        return nRet;
    }
    
    return false;
    
/* Auslegung
		if (! pApp->abbDaten.pipeName.IsEmpty())
		{
			SetTitle(pApp->abbDaten.pipeName.Mid(1));	// Dokumenttitel setzen
			// SetPathName(strModell+"_"+strLineID);
			DoSave(pApp->abbDaten.pipeName.Mid(1) +".cas", TRUE); // ohne Pfad, aber da wir in der App reingewechselt sind...
		}
	}
	pLKneu = new CLk();
	pLKneu->b_lastabtragung = EINFACH;
	CString strHangerTyp = pApp->abbDaten.hangerTyp;
	if ((pApp->abbDaten.orientation==HOR) ||
		(atyp == A_STAUFFSCHELLE))
	{
		pLKneu->b_rohrverlauf   = HORIZONTAL;
	}
	else
	{
		pLKneu->b_rohrverlauf   = VERTIKAL;
		pLKneu->b_lastabtragung = DOPPELT;
	}

	pLKneu->b_stahlbau      = FALSE;

	//Zuweisung der Anlagenpositionsnummer
	if(pApp->abbDaten.m_attachmentName.IsEmpty())
	{
		pLKneu->b_anlpos				= pApp->abbDaten.name;
	}
	else
	{
		pLKneu->b_anlpos				= pApp->abbDaten.m_attachmentName;
	}

	pLKneu->b_betriebslast	= pApp->abbDaten.forcesZ;
	pLKneu->b_sollweg		  	= abs(pApp->abbDaten.movementZ);
	if (pApp->abbDaten.movementZ >= 0)
		pLKneu->b_richtung = AUF;
	else
		pLKneu->b_richtung = AB;

	pLKneu->b_beweg_axial		= pApp->abbDaten.movementX;
	pLKneu->b_beweg_lateral		= pApp->abbDaten.movementY;
	pLKneu->m_orientation		= pApp->abbDaten.orientation;
	pLKneu->m_flowDirection		= pApp->abbDaten.flowDirection;

	pLKneu->b_nennweite			= pApp->abbDaten.nominalBore;
	pLKneu->b_aussendurch		= pApp->abbDaten.outsideDiameter;
	pLKneu->b_medientemp		= pApp->abbDaten.designTemperature;
	pLKneu->b_umgeb_temp		= pApp->abbDaten.projectTemperature;
	pLKneu->b_daemmdicke		= pApp->abbDaten.insulation;

	pLKneu->b_y2				= pApp->abbDaten.nsAxis1;
	pLKneu->b_y1				= pApp->abbDaten.nsAxis2;
	pLKneu->b_x1				= pApp->abbDaten.ewAxis1;
	pLKneu->b_x2				= pApp->abbDaten.ewAxis2;

	pLKneu->b_xx				= pApp->abbDaten.xDistance;
	pLKneu->b_yy				= pApp->abbDaten.yDistance;
	pLKneu->b_zeichnr			= pApp->abbDaten.m_drawingNumber;
	// double	zahl;
	// zahl = atof(pApp->abbDaten.m_level);
	// pLKneu->H1				= (long)atof(pApp->abbDaten.m_level);
	pLKneu->m_lVorgabeSyslevel	= pApp->abbDaten.SysLevel;
	pLKneu->m_RohrMitteZ		= pApp->abbDaten.SysLevel;

	pLKneu->m_dAlpha			= pApp->abbDaten.alpha;		
	pLKneu->m_dTestload			= pApp->abbDaten.Testload;	
	atyp = BestimmeAuslegungsTyp(strHangerTyp, pLKneu);
*/

}