
//#############################################################################
//
// Author:		H.M. Bauer / M. Wille
// Copyright:	Plan Software GmbH, Saarbrcken
//
//#############################################################################

function importSTKfromFolder(Ordner)
{
    if (right(Ordner, 1) != "\\")
        Ordner = Ordner + "\\";
    
    delete("TEMP.FILES", "");
    getdirectory(Ordner + "*.*", "TEMP.FILES");

    var nLastPos			= getsize("TEMP.FILES", "") - 1;
    var i, nTransferCount	= 0;
    var eksPathImport		= "";
    var SICdone				= false;
	var STKdone				= false;
	for (i = 0; i <= nLastPos; ++i)
    {
        var eksPathFile = "TEMP.FILES[" + i + "]";
        var nameFile = getstring("FILENAME", eksPathFile);
		//var typeFile = toupper(right(nameFile, 4));
		var typeFile = "." + toupper(FileName.getExt(Ordner + nameFile));
        //var TEST	= !getbool("CLIENTVERSION","RIGHTS");
		// Schilddaten "NEU"
		if (typeFile == ".SIC" && getstring("IS_DIRECTORY", eksPathFile) != "1"){
			eksPathImport = "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS["+ nTransferCount + "]";
			SICdone	= true;
			if (importSICfileToArray(Ordner + nameFile, eksPathImport, nameFile))
                nTransferCount++;
		}
		// FIN oder STK's
		else if (((typeFile == ".STK") || (typeFile == ".FIN") || (typeFile == ".EFIN"))
				&&(getstring("IS_DIRECTORY", eksPathFile) != "1"))
        {
            eksPathImport = "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS["+ nTransferCount + "]";
			if (importSTKfileToArray(Ordner + nameFile, eksPathImport, i+1, ""))
                nTransferCount++;
			STKdone	= true;
        }
		// LI-CAD-Daten nur fr Expert-Mode lesen
		else if (typeFile == ".L3D" && getbool("EXPERT_MODE","RIGHTS") && getstring("IS_DIRECTORY", eksPathFile) != "1"){
			eksPathImport	= "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS["+ nTransferCount + "]";
			var strNewFIN	= ConvertL3DFile(Ordner + nameFile);
			if (typeof(strNewFIN) == 'string' && importSTKfileToArray(Ordner + nameFile, eksPathImport, i+1, strNewFIN))
				nTransferCount++;
			STKdone	= true;
		}
    }
    if (SICdone){
		sortarray("TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS", "schildtyp");
		var AnzKH		= 0;
		var AnzFH50		= 0;
		var AnzFH100	= 0;
		var AnzFH200	= 0;
		var AnzSonst	= 0;
		for (i = 0; i < nTransferCount; i++)
		{
			var Schildpath	= "TEMP.SIC_IMPORT_AREA.SCHILDLIST_ITEMS[" + i + "]";
			var Schildtyp	= getstring ("schildtyp", Schildpath);
			
			if (getbool("SEND_CHECK", Schildpath)){
				switch (Schildtyp){
					case "KH"	:	AnzKH++;
									break;
					case "FH50"	: 	AnzFH50++;
									break;
					case "FH100": 	AnzFH100++;
									break;
					case "FH200": 	AnzFH200++;
									break;
					default		:	AnzSonst++;
									break;
				}
			}
			if (!getstring("SCHILDLIST_TABELLE_SELECTED", "TEMP.SIC_IMPORT_AREA") && getstring("SEND_CHECK", Schildpath) == "true")
				setstring("SCHILDLIST_TABELLE_SELECTED", "TEMP.SIC_IMPORT_AREA", i);
		}
		setstring("IDC_ANZ_KH",		"IDD_PROJECTLISTE",	AnzKH);
		setstring("IDC_ANZ_FH050",	"IDD_PROJECTLISTE",	AnzFH50);
		setstring("IDC_ANZ_FH100",	"IDD_PROJECTLISTE",	AnzFH100);
		setstring("IDC_ANZ_FH200",	"IDD_PROJECTLISTE",	AnzFH200);
		setstring("IDC_ANZ_SONST",	"IDD_PROJECTLISTE",	AnzSonst);
		
		setstring("AnzGesamt",	"TEMP.SIC_IMPORT_AREA",	nTransferCount);
	}
	else if (STKdone && !SICdone)
		sortarray("TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS", "info");
}

function ConvertL3DFile(L3DFile){
	var MacheWeiter	= true;
	var CheckLOF	= false;	// wir brauchen auch das LOF-File --> wenn das nicht da ist --> Meldung
	var LineNoL3D	= 0;
	var LineNoLOF	= 0;
	var LineNoFIN	= 0;
	var FIN;				// das FIN
	var L3D;				// das L3D
	var LOF			= "";	// das LOF
	var LOFFile		= left(L3DFile, L3DFile.length-3) + "LOF";
	var LI_VERS		= "";
	var SearchFIN	= "";	// FIN-Variable
	var ValueFIN	= "";	// Wert aus dem L3D fr FIN-Variable
	var ValueQTY	= 1;
	var strL3DtoFIN	= "";
	var isDynamic	= 0;
	var testDynamic	= 1;
	var HotLoad		= 1;	// Warmlastauslegung	1..."Kalt"	2..."Warm"
	
	if (FileName.fileExists(LOFFile))
		CheckLOF	= true;
	
	// unser leeres Standard-FIN-File
	//FIN	= readfile("C:\\DATA\\TEMP\\L3D\\empty");
	FIN	= readfile(getstddirectory("PROGRAM") + "empty.fin");
	FIN	= FIN.split("\r\n");
	// das LI-L3D-File
	L3D = readfile(L3DFile);
	L3D	= L3D.replace("$*", "");
	L3D	= L3D.split("\r\n");
	for (var i = 0; i < L3D.length; i++){
		L3D[i]	= trimleft(L3D[i], " ");
		if (testDynamic && left(L3D[i], 1)*1 == 2){
			isDynamic	= 1;
			testDynamic	= 0;
		}
		else if (testDynamic && left(L3D[i], 1)*1 > 2)
			testDynamic	= 0;
		if (left(L3D[i], 3)*1 == 90){	// 90	eingegebene Last LICAD 10
			HotLoad	= (rfind("F(H)", L3D[i]) > (-1) ? 2 : HotLoad);
		}
		if (left(L3D[i], 3)*1 == 104){	// 104	eingegebene Last LICAD 9
			var ValLine104	= L3D[i].split(":");
			ValLine104		= trimright(trimleft(ValLine104[1], " "), " ")*1;
		}
		if (left(L3D[i], 3)*1 == 106){	// 106	Warmlast LICAD 9 (bei Warmlastauslegung ist "104" == "106")
			var ValLine106	= L3D[i].split(":");
			ValLine106		= trimright(trimleft(ValLine106[1], " "), " ")*1;
			HotLoad			= (ValLine104 == ValLine106 ? 2 : HotLoad);
		}
		if (left(L3D[i], 3)*1 == 997){	// LI-Version
			LI_VERS	= L3D[i].split(":");
			LI_VERS = trimright(trimleft(LI_VERS[1], " "), " ");
		}
	}
	// das LI-LOF-File - sofern vorhanden lesen
	if (CheckLOF){
		LOF = readfile(LOFFile);
		//LOF	= LOF.replace("--", "");
		LOF	= LOF.split("\r\n");
		for (i = 0; i < LOF.length; i++){
			LOF[i]	= trimleft(LOF[i], " ");
		}
		// noch die INFO bzgl. Warmlastauslegung anhngen
		LOF[i]	= ":USTHOTLOAD " + HotLoad;
	}
	else{	// wenn nicht vorhanden -> bauen
		var oLOFInfo	= {	DYN_H		: 0,
							DYN_HZ		: 0,
							DYN_HS		: 0,
							F_hori		: 0,
							F_lat		: 0,
							F_verti		: 0,
							F_Test		: 0,
							W_hori		: 0,
							W_lat		: 0,
							W_verti		: 0,
							W_DYN_Pl	: 0,
							W_DYN_Mi	: 0,
							Spw			: 0,
							FRate		: 0
						  };
		for (i = 0; i < L3D.length; i++){
			L3DLineSplit	= L3D[i].split(":");
			switch (left(L3D[i], 3)*1){
				case 90		:
				case 104	:
					oLOFInfo.F_verti	= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 94	:
					oLOFInfo.F_Test		= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 107	:
					oLOFInfo.FRate		= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 108	:
					oLOFInfo.W_hori		= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 109	:
					oLOFInfo.W_lat		= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 110	:
					oLOFInfo.W_verti	= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 205	:
					oLOFInfo.DYN_H		= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 206	:
					oLOFInfo.DYN_HZ		= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 207	:
					oLOFInfo.DYN_HS		= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 208	:
					oLOFInfo.W_DYN_Pl	= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 209	:
					oLOFInfo.W_DYN_Mi	= trimleft(trimright(L3DLineSplit[1], " "), " ");
					break;
				case 400	:
					i	= L3D.length;
					break;
				default		:
					break;
			}
			
		}
		LOF	+= ":USTDYNLOADS " + oLOFInfo.DYN_H + " " + oLOFInfo.DYN_HZ + " " + oLOFInfo.DYN_HS + "\r\n";	// Dynamische Lasten
		LOF	+= ":USTFORCES " + oLOFInfo.F_hori + " " + oLOFInfo.F_lat + " " + oLOFInfo.F_verti + "\r\n";	// Statische Lasten
		LOF	+= ":USTTESTLOAD " + oLOFInfo.F_Test + "\r\n";	// Testlast
		LOF	+= ":USTMOVEMENT " + oLOFInfo.W_hori + " " + oLOFInfo.W_lat + " " + oLOFInfo.W_verti + " " + oLOFInfo.W_DYN_Pl + " " + oLOFInfo.W_DYN_Mi + "\r\n";	// Bewegungen statisch und dynamisch
		LOF	+= ":USTDISTROD " + oLOFInfo.Spw + "\r\n";	// Spannweite
		LOF	+= ":USTRATE " + oLOFInfo.FRate + "\r\n";	// Federrate
		LOF	+= ":USTLOFVER LOF_from_Flexperte_based_on_L3D" + "\r\n";	// Info
		LOF	+= ":USTHOTLOAD " + HotLoad;	// Info zur Warmlastauslegung
		LOF	= LOF.split("\r\n");
	}
	// Werte aus LOF holen - sofern vorhanden
	while(LineNoLOF < LOF.length){
		// Zeile Nr. "998" verndern um die PDMS-Version zu lesen
		if (left(trimleft(trimleft(LOF[LineNoLOF], "--"), " "), 3)*1 == 998){
			var Split		= LOF[LineNoLOF].replace(" ", "");
			Split			= Split.split(":");
			LOF[LineNoLOF]	= ":USTLOFVER " + Split[1];
		}
		if (left(LOF[LineNoLOF], 1) == ":"){
			var Split	= LOF[LineNoLOF].split(" ");
			var TempUST	= [];
			var strUST	= "";
			var strSQL	= "select * from LOF_TO_FIN where UST_LOF='" + trimleft(Split[0],":") + "' and DYNAMIC='" +  isDynamic + "' ";
			var numRet	= dbselect("CASCADE", strSQL, "LOF");
			if (numRet){
				for  (i = 0; i < Split.length; i++){
					if (Split[i] != "")
						TempUST[TempUST.length]	= Split[i];
				}
				var SearchQTY	= dbgetstring("LOF", "SEARCH_QTY");
				SearchQTY		= SearchQTY.split("/");
				var WI_UST	= [];
				if (SearchQTY[0] != "CHECK"){
					for (i = 0; i < SearchQTY.length; i++){
						WI_UST[i]	= 0;
					}
					for (i = 0; i < SearchQTY.length; i++){
						if (SearchQTY[i]*1 != 0){
							WI_UST[i]	= (left(SearchQTY[i], 1) == "-" ? (-1) : 1) * TempUST[abs(SearchQTY[i])];
						}
						else
							i++;
					}
				}
				else{
					for (i = 0; i < SearchQTY[1]*1; i++){
						WI_UST[i]	= 0;
					}
					var RelValues	= dbgetstring("LOF", "VALUES_LOF");
					RelValues		= RelValues.split("/");
					if (TempUST.length > RelValues[RelValues.length]*1){	// just to be sure
						if (WI_UST.length == 6){							// fr 6-wertige Variablen
							for (i = 0; i < RelValues.length; i++){			// sollte fr keine anderen kommen
								if (TempUST[RelValues[i]]*1 > 0)
									WI_UST[i]	= TempUST[RelValues[i]]*1;
								else
									WI_UST[i+3]	= TempUST[RelValues[i]]*1;
							}
						}
					}
				}
				
				for (i = 0; i < WI_UST.length; i++){
					strUST	+= WI_UST[i] + " ";
				}
				
				if (trimleft(trimright(strUST, " "), " ") != ""){
					var SEARCH	= dbgetstring("LOF", "SEARCH");
					LineNoFIN	= 0;
					while(MacheWeiter && LineNoFIN < FIN.length){
						if (trimright(trimleft(FIN[LineNoFIN], " "), " ") == SEARCH){
							FIN[LineNoFIN]	+= trimleft(strUST, "/");
							MacheWeiter		= false;
						}
						else
							LineNoFIN++;
					}
					MacheWeiter = true;
				}
			}
		}
		LineNoLOF++;
	}
	// Werte aus L3D holen
	var L3DStueLi	= [];
	var AddInfoDone	= false;
	while(LineNoL3D < L3D.length){
		SearchFIN	= "";
		ValueFIN	= "";
		ValueTEST	= "";
		ValueQTY	= 0;
		if (!AddInfoDone){	// auf diese Art nur bis nach der Stckliste suchen
			var strSQL	= "select * from L3D_TO_FIN where NO_L3D='" + left(trimleft(L3D[LineNoL3D]," "),3)*1 + "' ";
			var numRet	= dbselect("CASCADE", strSQL, "L3D");
			if (numRet){	// es darf nur "0" oder "1" sein, ansonsten wre eine Doppelung drin
				SearchFIN	= dbgetstring("L3D", "SEARCH");
				ValueFIN	= dbgetstring("L3D", "VALUE");
				ValueTEST	= dbgetstring("L3D", "TEST");
				ValueQTY	+= 1;
			}
		}
		if (left(trimleft(L3D[LineNoL3D]," "),3)*1 == 410){
			var TempPart	= trimleft(trimleft(L3D[LineNoL3D]," "), "410");
			TempPart		= TempPart.split("|");
			for (i = 0; i < TempPart.length; i++){
				TempPart[i]	= trimleft(trimright(TempPart[i], " "), " ");
			}
			L3DStueLi.push(TempPart);
		}
		//if (left(trimleft(L3D[LineNoL3D]," "),3)*1 > 410 && !AddInfoDone){	// jetzt sind wir durch die StueLi durch
		if (left(trimleft(L3D[LineNoL3D]," "),3)*1 == 999 && !AddInfoDone){		// "End INFO-L3D-Data"
			var isShoe		= false;	// Lager vorhanden
			var isShoeW		= false;	// Mehrfachfhrung vorhanden
			var LIShoeW		= "";		// LI-Typ der Mehrfachfhrung
			var isGuide		= false;	// Fhrung fr Lager
			var isAssembly	= false;	// Lastkette oder einzelnes Lager
			var isSS_CS		= false;	// Sttzen
			var isASS		= false;	// Gelenkfedersttze
			var isSpring	= false;	// FH/FS
			var isConstant	= false;	// KH/KS
			var isSnubber	= false;	// Stossbremse
			var isStrut		= false;	// Gelenkstrebe
			var isVertical	= false;	// Rohrverlauf vertikal
			var LIType		= 0;
			var LIType_L2	= 0;
			for (i = 0; i < L3DStueLi.length; i++){
				LIType		= L3DStueLi[i][1];
				LIType_L2	= left(LIType, 2)*1;
				switch LIType_L2 {
					case 11	:
					case 12	:
					case 13	:
					case 14	:
					case 18	:
						isConstant	= true;
						isAssembly	= true;
						break;
					case 19	:	// Achtung - das kann auch eine Gelenkkonstantsttze sein!!!
					case 16	:
						isConstant	= true;
						isSS_CS		= true;
						isAssembly	= true;
						break;
					case 79	:	// Konstanthngertraverse oder Federhngertraverse und normale Traversen!!!
						isDouble	= true;
						isAssembly	= true;
						if (right(LIType, 2)*1 == 11 || right(LIType, 2)*1 == 19){
							isSpring	= true;
						}
						else if (right(LIType, 2)*1 > 30){
							// do nothing --> normale Traverse
						}
						else{
							isConstant	= true;
						}
						break;
					case 20	:
						isASS		= true;
						isAssembly	= true;
						break;
					case 21	:
					case 22	:
					case 25	:
					case 26	:
						isSpring	= true;
						isAssembly	= true;
						break;
					case 28	:
					case 29	:
						isSS_CS		= true;
						isSpring	= true;
						isAssembly	= true;
						break;
					case 30	:
					case 31	:
						isSnubber	= true;
						isAssembly	= true;
						break;
					case 39	:
						isStrut		= true;
						isAssembly	= true;
						break;
					case 34	:
					case 45	:
					case 46	:
					case 48	:
						isVertical	= true;
						isAssembly	= true;
						break;
					case 49	:
						if (!(right(left(LIType, 4), 2)*1))
							isGuide	= true;
						else{
							isShoe	= true;
							if (rfind(LIType, "G") > -1){
								isShoeW	= true;
								LIShoeW	= "LI_" + right(LIType, LIType.length - rfind(LIType, "G") + 1);
							}
						}
						break;
					case 66	:
					case 67 :
						isAssembly	= true;
						break;
					default:
						break;
				}
			}
			// jetzt die Flle unterscheiden und SearchFIN, ValueFIN und ValueQTY setzen
			if (isAssembly){	// wir haben eine Lastkette
				if (isConstant){
					if (isSS_CS){	// Konstantsttze
						SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
						ValueFIN	+= (!ValueQTY ? "" : "|@|") + "KF";
						ValueQTY	+= 1;
					}
					else{	// Konstanthnger
						SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
						ValueFIN	+= (!ValueQTY ? "" : "|@|") + "KH";
						ValueQTY	+= 1;
					}
				}
				else if (isSpring){
					if (isSS_CS){	// Federsttze
						SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
						ValueFIN	+= (!ValueQTY ? "" : "|@|") + "FF";
						ValueQTY	+= 1;
					}
					else{	// Federhnger
						SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
						ValueFIN	+= (!ValueQTY ? "" : "|@|") + "FH";
						ValueQTY	+= 1;
					}
				}
				else if (isASS){	// Gelenkfedersttze
					SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
					ValueFIN	+= (!ValueQTY ? "" : "|@|") + "FGS";
					ValueQTY	+= 1;
				}
				else if (isStrut){	// Gelenkstrebe
					SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
					ValueFIN	+= (!ValueQTY ? "" : "|@|") + "GS";
					ValueQTY	+= 1;
				}
				else if (isSnubber){	// Stossbremse
					SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
					ValueFIN	+= (!ValueQTY ? "" : "|@|") + "DP";
					ValueQTY	+= 1;
				}
				else{	// Starre LK
					SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
					ValueFIN	+= (!ValueQTY ? "" : "|@|") + "SH";
					ValueQTY	+= 1;
				}
			}
			else if (isShoe && !isAssembly){	// das ist ein Lager --> LICAD kennt keine Festpunkte!!!
				if (isGuide){	// mit Fhrung
					SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
					ValueFIN	+= (!ValueQTY ? "" : "|@|") + "FL";
					ValueQTY	+= 1;
				}
				else{	// keine Fhrung
					if (isShoeW){
						SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
						// ValueFIN	+= (!ValueQTY ? "" : "|@|") + "QS";
						
						// neue RH-Typen fr die LI-Mehrfachfhrung
						switch (LIShoeW){
							case "LI_G2A"	:
								ValueFIN += (!ValueQTY ? "" : "|@|") + "2W_90";
								break;
							case "LI_G3"	:
								ValueFIN += (!ValueQTY ? "" : "|@|") + "3W";
								break;
							case "LI_G4"	:
								ValueFIN += (!ValueQTY ? "" : "|@|") + "4W";
								break;
							default		:
								ValueFIN += (!ValueQTY ? "" : "|@|") + "2W";
								break;
						}
						
						ValueQTY	+= 1;
					}
					else{
						SearchFIN	+= (!ValueQTY ? "" : "|@|") + "RH_TYP";
						ValueFIN	+= (!ValueQTY ? "" : "|@|") + "LL";
						ValueQTY	+= 1;
					}
				}
			}
			// wenn nicht zuordenbar muss der Anwender das spter selbst entscheiden
			// jetzt noch die Rohrrichtung bestimmen
			if (isVertical){
				SearchFIN	+= (!ValueQTY ? "" : "|@|") + "FLOWDIRECTION";
				ValueFIN	+= (!ValueQTY ? "" : "|@|") + "D";
				ValueQTY	+= 1;
			}
			else{
				SearchFIN	+= (!ValueQTY ? "" : "|@|") + "FLOWDIRECTION";
				ValueFIN	+= (!ValueQTY ? "" : "|@|") + "E";
				ValueQTY	+= 1;
			}
			
			AddInfoDone	= true;
		}
		if (toupper(left(trimleft(L3D[LineNoL3D]," "),6)) == "HEIGHT"){
			var CoordInfo	= [];
			var CoordValues	= [];
			var TempSplit	= L3D[LineNoL3D].split(" ");
			for (i = 0; i < TempSplit.length; i++){
				if (trimleft(trimright(TempSplit[i], " "), " ") != "")
					CoordInfo.push(trimleft(trimright(TempSplit[i], " "), " "));
			}
			var TempSplit	= L3D[LineNoL3D+1].split(" ");
			for (i = 0; i < TempSplit.length; i++){
				if (trimleft(trimright(TempSplit[i], " "), " ") != "")
					CoordValues.push(trimleft(trimright(TempSplit[i], " "), " "));
			}
			SearchFIN	+= (!ValueQTY ? "" : "|@|") + "PIPECENTERX" + "|@|" + "PIPECENTERY" + "|@|" + "PIPECENTERZ" + 
							"|@|" + "PIPEANGLE-X" + "|@|" + "PIPEANGLE-Y" + "|@|" + "Ba1Z";
			ValueFIN	+= (!ValueQTY ? "" : "|@|") + CoordValues[3] + "|@|" + CoordValues[5] + "|@|" + CoordValues[7] +
							"|@|" + (max(abs(CoordValues[4]), abs(CoordValues[6]))) + "|@|" + CoordValues[8] +
							"|@|" + (CoordValues[7]*1 + CoordValues[0]*1);
			ValueQTY	+= 6;
		}
		if (SearchFIN != ""){
			for (i = 0; i < ValueQTY; i++){
				ValueFIN	= (ValueFIN != "" ? ValueFIN : right(L3D[LineNoL3D],L3D[LineNoL3D].length - rfind(L3D[LineNoL3D],":")));
				LineNoFIN	= 0;
				if (ValueQTY > 1){
					if (!i){
						var SplitValue	= ValueFIN.split("|@|");
						var SplitSearch	= SearchFIN.split("|@|");
					}
					SearchFIN	= SplitSearch[i];
					ValueFIN	= SplitValue[i];
				}
				while(MacheWeiter && LineNoFIN < FIN.length){
					//if (rfind(FIN[LineNoFIN],SearchFIN) > (-1)){	// geht nicht wg. Dopplungen "NAME", "PIPENAME", ...
					if (trimright(trimleft(FIN[LineNoFIN], " "), " ") == SearchFIN){
						FIN[LineNoFIN]	+= trimleft(trimleft(ValueFIN, " "), "/");
						MacheWeiter		= false;
					}
					else
						LineNoFIN++;
				}
				MacheWeiter = true;
			}
		}
		LineNoL3D++;
	}
	for (var i = 0; i < FIN.length; i++){
		strL3DtoFIN	+= FIN[i] + "\r\n";
	}
	// ggf. den "bearbeitet" Status noch anhngen
	var LastLineL3D	= L3D[L3D.length-1].replace("\n", "");
	Split			= LastLineL3D.split(" ");
	if (Split[0] == translate("IDC_BEARBEITET")){
		strL3DtoFIN	+= LastLineL3D + " ";
	}
	return (strL3DtoFIN);
}

function importSTKfileToArray(strSTKfile, eksPathImport, defaultPos, strFileContent)
{
    if (!strFileContent)
		strFileContent == "";
	
	if (strSTKfile == "")
	{
		var strUserTcaPath = getstring("IMPORT_TCA_VERZEICHNIS", "");
        strSTKfile = filedialog(1, "FIN", "", "FIN-Files|*.FIN;*.fin||", strUserTcaPath); // 1 = Open-Dialog
		
	}	
    if (strSTKfile != "")
    {
		var strDir = FileName.getDir(strSTKfile);
		setstring("IMPORT_TCA_VERZEICHNIS", "", strDir);
		var iniFilename = getinipath();
		writeinistring(iniFilename, "CA_SETTINGS", "IMPORT_TCA_VERZEICHNIS", strDir);
		
        var stk = new STKimport();
		
        var nRet = stk.readImportFile(strSTKfile, strFileContent);
		
        if (nRet)
            nRet = stk.analyseImport();
		
        if (nRet)
        {
            //setstring("info", eksPathImport, stk.info); // Infofeld fuer File-Type nutzen
            
			// Bearbeitet setzen, wenn in FIN vermerkt
			var Index		= stk.keyBuffer.length - 1; 
			var strIndex	= stk.keyBuffer[Index].k;
			if (strIndex == translate("IDC_BEARBEITET"))
				setstring("status", eksPathImport, strIndex + " " + stk.keyBuffer[Index].v);
			else
				setstring("status", eksPathImport, "");
        
			var strPos = trimWhite(getFinDataValue(stk.STKDATA, 'assembly','pos'));
            setstring("pos", eksPathImport, (strPos == '') ? defaultPos : strPos);
            setstring("qty", eksPathImport, getFinDataValue(stk.STKDATA, 'assembly','qty'));
            
			if (getFinDataValue(stk.STKDATA, 'assembly','name') != "")
				setstring("m_attachmentName", eksPathImport, getFinDataValue(stk.STKDATA, 'assembly','name'));
			else
				setstring("m_attachmentName", eksPathImport, getFinDataValue(stk.STKDATA, 'assembly','nodenumb'));
			
			var typeFile = toupper(right(strSTKfile, 3));
            setstring("typeFile", eksPathImport, typeFile);
			
			var strFileNameArray	= strSTKfile.split("\\");
			var strFileName			= strFileNameArray[(strFileNameArray.length)-1];
			
			//setstring("info", eksPathImport, typeFile + "-FILE");
			setstring("info", eksPathImport, strFileName);
			
			//setstring("typ", eksPathImport, getstring("IDC_LASTKETTE", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"));
			if (typeFile == "FIN"){
				var strTyp = 'FIN';
				if (stk.STKDATA.partslist.aPartslist && (stk.STKDATA.partslist.aPartslist.length > 0))
					strTyp = '	eFIN';
			}
			else
				var strTyp	= typeFile;
			setstring("typ", eksPathImport, strTyp);

			stk.STKDATA.toStorage(eksPathImport+".FINOBJECT", false );
		}
        
        return nRet;
    }
    
    return false;
}

function importSICfileToArray(strSICfile, eksPathImport, strFileName)
{
	var strDir = FileName.getDir(strSICfile);
	setstring("IMPORT_TCA_VERZEICHNIS", "", strDir);
	var iniFilename = getinipath();
	writeinistring(iniFilename, "CA_SETTINGS", "IMPORT_TCA_VERZEICHNIS", strDir);
	
	var sic				= new STKimport();
	var nRet			= sic.readImportFile(strSICfile, "");
	var Index			= sic.keyBuffer.length - 1; 
	var strIndex		= sic.keyBuffer[Index].k;
	var FileNamePart	= left(strFileName, rfind(strFileName, ".") - 1).split("_");
	//if (strIndex == translate("IDC_BEARBEITET"))
	var AnzBearb		= 1;
	if (strIndex == translate("STATUS")){
		setstring("status", eksPathImport, sic.keyBuffer[Index].v);
		while (Index >= 0 && sic.keyBuffer[Index-1].k == translate("STATUS")){
			AnzBearb++;
			Index--;
		}
		setstring("AnzBearb", eksPathImport, AnzBearb);
		setstring("SEND_CHECK", eksPathImport, "false");
	}
	else{
		setstring("status", eksPathImport, "");
		setstring("AnzBearb", eksPathImport, 0);
		setstring("SEND_CHECK", eksPathImport, "true");
	}
	setstring("schildtyp", eksPathImport, FileNamePart[1]);
	setstring("index", eksPathImport, FileNamePart[3]);
	setstring("position", eksPathImport, FileNamePart[2]);
	setstring("filename", eksPathImport, strFileName);
	var AnzLines	= 0;
	for (var i = 0; i < sic.keyBuffer.length; i++){
		if (sic.keyBuffer.k != "STATUS"){
			sic.keyBuffer[i].toStorage(eksPathImport + "Line["+i+"]", true);   // merge
			AnzLines++;
		}
	}
	setstring("AnzLines", eksPathImport, AnzLines);
	return (true);
}

function setSTKdataToDlg(strPos)
{
    var eksPathImport = "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS["+ strPos + "]";
	var typeFile = getstring("typeFile", eksPathImport);
	return setSTKdataToDlgAbsPath(eksPathImport, typeFile);
}

function getFinDataValue(finData, strSection, strProperty)
{
	strProperty = replace(strProperty, '-', '_');
	strProperty = tolower(strProperty);
	if (! strSection in finData)
		return '';
	if (finData[strSection][strProperty] == undefined)
		return '';
		
	return finData[strSection][strProperty];
}

function setSTKdataToDlgAbsPath(eksPathImport, fileType)
{
    var _storeBasePath			= "DLGDATA.CA.FORMS";
	var _storeBasePath_Lager	= "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN";
    var ret = 1;

	// -Schu- Test auf "eFIN" und ggf. 
	// wenn "eFIN" mssen Werte vom Restrain aus PDMS verwendet werden
	// mit diesen Werten wurde ursprnglich im Flexperte ausgelegt
	var finData		= Object.fromStorage( eksPathImport+".FINOBJECT");
	//var beFIN		= (getstring("typ", eksPathImport) == "eFIN" ? true : false);
	var beFIN		= (rfind(getstring("typ", eksPathImport), "eFIN") > (-1) ? true : false);	// eFIN mit WITZENMANN Bauteilen
	// Achtung auch andere Auslegungen z.B. LICAD liefern eFIN
	// falls andere Auslegung knnen wir zumindest die CAD-OBJECTS-LIST verwenden und auswerten
	if(trimleft(trimright(getFinDataValue(finData, 'restrain', 'hangtype'), " "), " ") == "" && beFIN){
		beFIN				= false;
		var bOTHEReFIN		= true;
	}
	else
		var bOTHEReFIN		= false;
	
	var bSTK		= (rfind(getstring("typ", eksPathImport), "STK")> (-1) ? true : false);	// auch STK's knnen wie eFIN's eingelesen werden (zumindest die StLi)
	
	// hier nicht ntig, wird im navigate komplett gemacht:
	// delete("DLGDATA.CA.FINDATA",""); // -mw- 20.9.2010
	
	// FIN's aus Excelimport knnen auch eine Stckzahl haben
	var QTY	= getFinDataValue(finData, 'assembly', 'qty');
	if (QTY == "" || QTY*1 == 0)
		QTY	= 1;
		
	setstring("QTY",	"DLGDATA",	QTY);
	
	finData.toStorage("DLGDATA.CA.FINDATA.FINOBJECT", false );
	// FINDATA for Lagerteil
	var FIN_oDlgLagerSession = {};
	FIN_oDlgLagerSession.toStorage("DLGDATA.CA.FINDATA.oDlgLagerSession_FIN", false );
	
	// Message for eFIN-Import
	var eFIN_Message = {Temperaturvergleich			:	"",
						TemperaturREST				:	"",
						TemperaturPIPE				:	"",
						Werkstoffvergleich			:	"",
						WerkstoffSelected			:	"",
						WerkstoffRuT				:	"",
						Aussendurchmesservergleich	:	"",
						AussendurchmesserPIPE		:	"",
						isAussenDmrSonderPIPE		:	"",
						NennweitePIPE				:	"",
						AussendurchmesserRuT		:	"",
						BaseType					:	""};
	
	if ((fileType == 'FIN') && finData.sec_steel && finData.sec_steel.aSteeldata &&
		(finData.sec_steel.aSteeldata.length > 0))  {
		//setstring("STEELPARTS", "DLGDATA.CA.FINDATA", finData.sec_steel.aSteeldata.length);
		setstring("STEELPARTS", "DLGDATA.CA.FINDATA", 'todo');
	}
	else {
		setstring("STEELPARTS", "DLGDATA.CA.FINDATA", "");
	}
	
	var quelle	= atoi(getFinDataValue(finData, 'project', 'quelle'));	// woher stammt das FIN-FILE
	// 1-PDMS; 2-SuCAD(PDS); 3-Rohr2; 4-CaesarII; 5-Smart3D; 6-LiCAD(L3D/LOF); 7-EXCEL-Import; 8-ACAD Plant3D; 9-eFIN4FreePos
	
	// Betimmen des Koordinatensystems - global fr gesamtes Projekt
	var vertikaldir_up	= get_verti_dir_def(atoi(getFinDataValue(finData, 'pipe', 'vertikaldir_up')));	// vertikale Achse und Richtung
	
	setstring("IDC_VERTIKALDIR_DEF", "PROJECT.SETTINGS.CASCADE", "IDC_VERTIKALDIR_DEF_" + vertikaldir_up[1]);
	setstring("IDC_VERTIKALDIR_ACHS_DEF", "PROJECT.SETTINGS.CASCADE", "IDC_VERTIKALDIR_ACHS_DEF_" + vertikaldir_up[2]);
	setstring("IDC_KOORD_IMAGE", "PROJECT.SETTINGS.CASCADE", "RH_KOORD_V" + vertikaldir_up[2] + "_Var1");	// derzeit keine Infos "Default ist Var1"
	setstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", vertikaldir_up[1]);
	
	// Bestimmung der Rohrrichtung (Achse) und Rohverlauf
	var pipeorient	= getFinDataValue(finData, 'pipe', 'pipeorient');	// Richtungsvektor der Rohrleitung
	if (!pipeorient){	// Fall PDMS (kein Richtungsvektor)
		var flowdirection	= left(trimleft(trimright(getFinDataValue(finData, 'pipe', 'flowdirection'), " "), " "),1);
		var Rohrverlauf		= "VERTIKAL";
		var Rohrachse		= "SCHRAEG_ACHSE";
		var alpha			= fround(atod(getFinDataValue(finData, 'pipe', 'pipeangle_x')), 2);
		var beta			= fround(atod(getFinDataValue(finData, 'pipe', 'pipeangle_y')), 2);
		if (abs(alpha) <= 4 && abs(beta) <= 4){
			if (flowdirection == "E" || flowdirection == "W"){
				Rohrverlauf	= "HORIZONTAL";
				Rohrachse	= vertikaldir_up[4] + "_ACHSE";
			}
			else if (flowdirection == "N" || flowdirection == "S"){
				Rohrverlauf	= "HORIZONTAL";
				Rohrachse	= vertikaldir_up[3] + "_ACHSE";
			}
			else if (flowdirection == "U" || flowdirection == "D"){
				Rohrachse	= vertikaldir_up[2] + "_ACHSE";
			}
		}
		else if (flowdirection != "U" && flowdirection != "D"){
			Rohrverlauf		= "HORIZONTAL"
			setstring("SYSTEMCHARAKTERISTIK.SCHRAEG_ALPHA", _storeBasePath, alpha);
			setstring("SYSTEMCHARAKTERISTIK.SCHRAEG_BETA", _storeBasePath, beta);
			setstring("Systemcharakteristik.dAlpha", _storeBasePath_Lager, alpha);
			setstring("Systemcharakteristik.dBeta", _storeBasePath_Lager, beta);
		}
		setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRRICHTUNG", _storeBasePath, Rohrachse);
		setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", _storeBasePath, Rohrverlauf);
		setstring("Systemcharakteristik.strSelRadioRohrichtung", _storeBasePath_Lager, "LAGER_" + Rohrachse);
		setstring("Systemcharakteristik.strSelRadioRohrverlauf", _storeBasePath_Lager, "LAGER_" + Rohrverlauf);
	}
	else{	// Richtungsvektor vorhanden
		var strVektor		= pipeorient.split(" ");	// Aufbau
		var strVektor_neu	= "";
		var temp			= 0;
		var Vmulti			= 1;
		for (var i = 0; i < strVektor.length; i++)	// Normieren
		{
			if ((fround((strVektor[i])-0, 0) != 0) && (temp == 0))
			{
				Vmulti			= 1 / abs(strVektor[i]);
				temp			= 1;
				i				= -1;
				strVektor_neu	= "";
			}
			else
			{
				var NKomma		= (fround(Vmulti, 1) == 1 ? 0 : 2);
				//strVektor[i]	= fround(Vmulti * strVektor[i], 2);
				strVektor[i]	= fround(Vmulti * strVektor[i], NKomma);
				strVektor_neu	+= strVektor[i] + " ";
			}
		}
		var Vektor_HHV	= get_Vektor_HHV(strVektor, vertikaldir_up[2]);
		var Rohrverlauf	= ((abs(Vektor_HHV[2]) == 1) ? "VERTIKAL" : "HORIZONTAL");
		var Rohrachse	= "SCHRAEG_ACHSE";
		if ((((Vektor_HHV[0] != 0) || (Vektor_HHV[1] != 0)) && (Vektor_HHV[2] != 0))
				|| (Vektor_HHV[0] != 0 && Vektor_HHV[1] != 0)){	// schraeger Rohrleitungsverlauf
			/*
			var alpha	= fround(atandeg(Vektor_HHV[1] / Vektor_HHV[0]), 1);
			var beta	= fround(atandeg(Vektor_HHV[2] / sqrt(pow(Vektor_HHV[0], 2) + pow(Vektor_HHV[1], 2))), 1);
			*/
			strVektor_neu	= trimright(trimleft(strVektor_neu, " "), " ");
			var VektorN	= strVektor_neu.split(" ");
			var alpha	= fround(atandeg(VektorN[1] / VektorN[0]), 1);
			var beta	= fround(atandeg(VektorN[2] / sqrt(pow(VektorN[0], 2) + pow(VektorN[1], 2))), 1);
			setstring("SYSTEMCHARAKTERISTIK.SCHRAEG_ALPHA", _storeBasePath, alpha);
			setstring("SYSTEMCHARAKTERISTIK.SCHRAEG_BETA", _storeBasePath, beta);
			setstring("Systemcharakteristik.dAlpha", _storeBasePath_Lager, alpha);
			setstring("Systemcharakteristik.dBeta", _storeBasePath_Lager, beta);
		}
		else{
			if (abs(strVektor[0]))
				Rohrachse	= "X_ACHSE"
			else if (abs(strVektor[1]))
				Rohrachse	= "Y_ACHSE"
			else if (abs(strVektor[2]))
				Rohrachse	= "Z_ACHSE"
		}
		setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRRICHTUNG", _storeBasePath, Rohrachse);
		setstring("SYSTEMCHARAKTERISTIK.IDC_ROHRVERLAUF", _storeBasePath, Rohrverlauf);
		setstring("Systemcharakteristik.strSelRadioRohrichtung", _storeBasePath_Lager, "LAGER_" + Rohrachse);
		setstring("Systemcharakteristik.strSelRadioRohrverlauf", _storeBasePath_Lager, "LAGER_" + Rohrverlauf);
	}
	
	// Sollwerte RUT
	var medTemp_PIPE	= atoi(trimleft(trimright(getFinDataValue(finData, 'pipe', 'medtemp'), " "), " "));
	if (beFIN || bOTHEReFIN)
		var medTemp_REST	= atoi(trimleft(trimright(getFinDataValue(finData, 'restrain', 'dtemp'), " "), " "));
	else
		var medTemp_REST	= medTemp_PIPE;
	
	eFIN_Message.TemperaturPIPE			= medTemp_PIPE;
	eFIN_Message.TemperaturREST			= medTemp_REST;
	eFIN_Message.Temperaturvergleich	= (medTemp_PIPE == medTemp_REST ? "true" : "false");
	
	var medTemp			= max(medTemp_PIPE, medTemp_REST);
	if (medTemp == "")
		medTemp	= 20;
	
	var dRohr = fround(atod(getFinDataValue(finData, 'pipe', 'pod')),1);
	var DN	= atoi(trimleft(trimright(getFinDataValue(finData, 'pipe', 'dia'), " "), " "));
	// S3D bringt fuer DN dem umgerechneten Wert Zoll*25,4
	// das stimmt nicht exakt mit dA fr DN berein -> suchen in Tabelle
	if (quelle == 5 || quelle == 8){
		var UOM	= trimleft(trimright(getFinDataValue(finData, 'pipe', 'uom'), " "), " ");	// Unit of Measure -> "IN" oder "MM"
		if (UOM == "IN"){
			var strSQLStatement	= "select * from ROHRD where abs(INCH)="+ (DN*1)+" ";
			var numRet			= dbselect("CASCADE", strSQLStatement, "ROHRD");
			if (numRet){
				dRohr	= dbgetdouble("ROHRD", "D");
				DN		= dbgetdouble("ROHRD", "nennweite");
			}
			else{
				dRohr	= DN * 25.4;
				DN		= "";
			}
		}
	}
	var isSonderDA	= false;
	if ((DN == "" || DN == 0) && dRohr != 0){
		var strSQLStatement	= "select * from ROHRD where abs(D)="+ (dRohr-0)+" ";
		var numRet			= dbselect("CASCADE", strSQLStatement, "ROHRD");
		DN					= dbgetdouble("ROHRD", "nennweite");
		if (!numRet){
			var strSQLStatement	= "select * from DELDA_D where abs(D_BIS) > "+(dRohr)+" ";
			var numRet			= dbselect("CASCADE", strSQLStatement, "DELDA_D");
			var DEL_D			= dbgetdouble("DELDA_D", "DEL_D");
			for (var a=(dRohr-DEL_D); a<=(dRohr+DEL_D);){
				strSQLStatement	= "select * from ROHRD where abs(D)="+ fround(a, 1) +" ";
				numRet			= dbselect("CASCADE", strSQLStatement, "ROHRD");
				DN				= dbgetdouble("ROHRD", "nennweite");
				if (numRet || numRet == "1"){
					strSQLStatement	= "select * from ROHRD where abs(NENNWEITE) = "+(DN)+" ";
					numRet			= dbselect("CASCADE", strSQLStatement, "ROHRD");
					//var dRohr_Sel	= dbgetdouble("ROHRD", "D");
					dRohr			= dbgetdouble("ROHRD", "D");
					a = (dRohr+DEL_D);	// wenn Treffer -> Abbruch der Schleife
				}
				a	+= 0.1;
			}
			//dRohr	= dRohr_Sel;
			if (!numRet){
				isSonderDA		= true;
				strSQLStatement	= "select * from ROHRD where abs(D)>"+ (dRohr-0)+" order by abs(D)";
				dbselect("CASCADE", strSQLStatement, "ROHRD");
				DN				= dbgetdouble("ROHRD", "nennweite");
			}
		}
	}
	else if ((DN == "" || DN == 0) && (dRohr == "" || dRohr == 0)){	// kein RuT
		DN			= 0;
		dRohr		= 0;
		isSonderDA	= false;
		setstring("SYSTEMCHARAKTERISTIK.IDC_KEIN_ROHRUMSCHLIESSENDES_TEIL", _storeBasePath, "KEIN_ROHRUMSCHLIESSENDES_TEIL");
	}
	else{
		var strSQLStatement	= "select * from ROHRD where abs(NENNWEITE) = "+(DN)+" ";
		var numRet			= dbselect("CASCADE", strSQLStatement, "ROHRD");
		var dRohrNorm		= dbgetdouble("ROHRD", "D");
		if (dRohr != 0){
			var strSQLStatement	= "select * from DELDA_D where abs(D_BIS) > "+(dRohr)+" ";
			var numRet			= dbselect("CASCADE", strSQLStatement, "DELDA_D");
			var DEL_D			= dbgetdouble("DELDA_D", "DEL_D");
			if (abs(dRohrNorm - dRohr) > DEL_D)
				isSonderDA		= true;
			else
				dRohr		= dRohrNorm;
		}
		else
			dRohr			= dRohrNorm;
		
	}
	eFIN_Message.AussendurchmesserPIPE	= dRohr;
	eFIN_Message.isAussenDmrSonderPIPE	= (isSonderDA ? "true" : "false");
	eFIN_Message.NennweitePIPE			= DN;
	
	var daemm	= fround(atod(getFinDataValue(finData, 'pipe', 'insulat')),0);
	
	if (isSonderDA){
        setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER_SONDER_CHECK", _storeBasePath, "true");
        setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER_SONDER", _storeBasePath, dRohr);
		setstring("SollwerteRohrUmTeil.bAussenDuMesserSonder", _storeBasePath_Lager, "true");
		setstring("SollwerteRohrUmTeil.dAussenDuMesserSonder", _storeBasePath_Lager, dRohr);
	}
    
	setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_NENNWEITE_DN", _storeBasePath, DN);
	setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_AUSSENDURCHMESSER", _storeBasePath, dRohr);
    setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_MEDIUM", _storeBasePath, medTemp);
	setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_UMGEBUNG", _storeBasePath, "20");
	var refTemp = ((atoi(medTemp) <= 350 && atoi(medTemp) >= 40) ?  atoi(medTemp) - 20 : atoi(medTemp));
	setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_TEMPERATUR_REFERENZ", _storeBasePath, refTemp);
    setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_DAEMMDICKE", _storeBasePath, daemm);
	setstring("SollwerteRohrUmTeil.strSelNennweiteCombo", _storeBasePath_Lager, DN);
	setstring("SollwerteRohrUmTeil.strSelAussenDuMesserCombo", _storeBasePath_Lager, dRohr);
	setstring("SollwerteRohrUmTeil.strSelMantelDuMesserCombo", _storeBasePath_Lager, "STD");
	setstring("SollwerteRohrUmTeil.dTemperaturMedium", _storeBasePath_Lager, medTemp);
	setstring("SollwerteRohrUmTeil.dDaemmDicke", _storeBasePath_Lager, daemm);
	
	// Bestimmung des Lastabtragung
	// -Schu- fr den Fall eFIN aber keine Daten befllt StLi auswerten und rh_typ bestimmen
	var rh_typ		= (beFIN ? toupper(trimleft(trimright(getFinDataValue(finData, 'restrain', 'hangtype'), " "), " ")) : toupper(trimleft(trimright(getFinDataValue(finData, 'assembly', 'rh_typ'), " "), " ")));
	if ((left(rh_typ, 2) == "FG" || left(rh_typ, 2) == "KG") && quelle != 7)
		rh_typ	= left(rh_typ, 3);
	else if ((left(rh_typ, 2) == "FG" || left(rh_typ, 2) == "KG") && quelle == 7)
		rh_typ	= rh_typ;
	else if (left(rh_typ, 4) == "FLAX")
		rh_typ	= "AX";
	else
		rh_typ	= left(rh_typ, 2);
	var rh_b_typ	= trimleft(trimright(getFinDataValue(finData, 'assembly', 'rh_b_typ'), " "), " ");
	// Achtung
	// manchmal ist der TYP nicht befllt - aber es ist trotzdem ein WI-eFIN
	// manchmal ist der TYP auch falsch
	// wir bestimmen den rh_typ anhand der StLi
	// das gilt auch fr STK's
	// if (beFIN || bSTK){	// bOTHEReFIN nicht -> die Bauteile knnen nicht ausgewertet werden
	// Problem hier ist, dass auch ein eFIN ohne rh_typ als OTHEReFIN kommt aber WI-Teile hat
	if (beFIN || bSTK || bOTHEReFIN){
	//if ((beFIN || bSTK || bOTHEReFIN) && quelle != 9){
	// alles was irgendwie Bauteile haben kann -> OTHEReFIN ohne WI-Teile fllt dann in LK nur mit Sonderteilen
		var rh_typ_isLager				= false;
		var rh_typ_isFestlager			= false;
		var rh_typ_isFuehrungW			= false;
		var rh_typ_isKlemmsystem		= false;
		var rh_typ_isStarrerHaenger		= false;
		var rh_typ_isKonstantstuetze	= false;
		var rh_typ_isKonstanthaenger	= false;
		var rh_typ_isFederstuetze		= false;
		var rh_typ_isFederhaenger		= false;
		var rh_typ_isGelenkferder		= false;
		var rh_typ_isGelenkstrebe		= false;
		var rh_typ_isStossbremse		= false;
		var rh_typ_isStauffschelle		= false;
		var rh_typ_isTraverse			= false;	// nur zu Auswertungszwecken
		var AnzahlTeile					= finData.partslist.aPartslist.length;
		for (var a = 0; a < AnzahlTeile; a++){
			//var Basetype		= left(finData.partslist.aPartslist[a].typ, 3);
			var Basetype		= (quelle == 9 ? '@' : '') + left(finData.partslist.aPartslist[a].typ, 3);
			var Basetype_ext	= (quelle == 9 ? '@' : '') + left(finData.partslist.aPartslist[a].typ, 5);
			if	( Basetype == "LKL" || Basetype == "LSL" || Basetype == "LXL" || Basetype == "IKL" ||
				  Basetype == "LVL" || Basetype == "LVS" ||
				  // Auch die FLEXPERTE 4 Lager die es nicht mehr gibt mssen bercksichtigt werden
				  // die Zuordnug zu den neuen Typen erfolgt beim eFIN-Import
				  // auch in den o.g. Typen knnen FL4 Lager stecken -> Baureihe 40!!!
				  Basetype == "LSW" || Basetype == "LKG" || Basetype == "LVG" || Basetype == "LSG" ||
				  Basetype == "LXA" || Basetype == "LXV" || Basetype == "IKG" )
					rh_typ_isLager	= true;
			else if	( Basetype == "FLN" || Basetype == "FLV" ||
					  Basetype == "FVN" || Basetype == "FSN" || Basetype == "FSD" )
					rh_typ_isFestlager	= true;
			else if ( Basetype == "LSF" || Basetype == "LXF" || Basetype == "LKF" )
					rh_typ_isFuehrungW	= true;
			else if ( left(Basetype, 2) == "KZ" || left(Basetype, 2) == "KA" || left(Basetype, 2) == "KO" ||
					  left(Basetype, 2) == "KL" || left(Basetype, 2) == "LA" || Basetype_ext == "LKG10" )
					rh_typ_isKlemmsystem	= true;
			else if ( Basetype == "KSR" || Basetype == "KSP" )
					rh_typ_isKonstantstuetze	= true;
			else if ( Basetype == "KHD" || Basetype == "KHS" || Basetype == "KVD" || Basetype == "KVS" )
					rh_typ_isKonstanthaenger	= true;
			else if ( Basetype == "FSS" || Basetype == "FSP" )
					rh_typ_isFederstuetze	= true;
			else if ( Basetype == "FHD" || Basetype == "FHG" || Basetype == "FHS" || Basetype == "FDT" )
					rh_typ_isFederhaenger	= true;
			else if ( Basetype == "FSG" )
					rh_typ_isGelenkfeder	= true;
			else if ( Basetype == "SSG" )
					rh_typ_isGelenkstrebe	= true;
			else if ( Basetype == "SSB" )
					rh_typ_isStossbremse	= true;
			else if ( Basetype == "SP_" || left(Basetype_ext, 4) == "SPAL" )
					rh_typ_isStauffschelle	= true;
			else if ( Basetype == "ZSM" || Basetype == "ZRM" )
					rh_typ_isStarrerHaenger	= true;
			else if ( Basetype == "ZTN" )
					rh_typ_isTraverse	= true;
		}
		if ( rh_typ_isKonstantstuetze )
			rh_typ	= "KS";
		else if ( rh_typ_isKonstanthaenger )
			rh_typ	= "KH";
		else if ( rh_typ_isFederstuetze )
			rh_typ	= "FS";
		else if ( rh_typ_isFederhaenger )
			rh_typ	= "FH";
		else if ( rh_typ_isGelenkfeder )
			rh_typ	= "FG";
		else if ( rh_typ_isGelenkstrebe )
			rh_typ	= "GS";
		else if ( rh_typ_isStossbremse )
			rh_typ	= "DP";		// Prfen ob das stimmt
		else if ( rh_typ_isStarrerHaenger )
			rh_typ	= "SH";
		else if ( rh_typ_isFuehrungW )
			rh_typ	= "QS";
		else if ( rh_typ_isLager && !rh_typ_isKlemmsystem )
			rh_typ	= "GL";
		else if ( rh_typ_isKlemmsystem )
			rh_typ	= "FL";
		else if ( rh_typ_isFestlager )
			rh_typ	= "FP";
		else if ( rh_typ_isStauffschelle && finData.sec_steel.aSteeldata.length > 0 )
			rh_typ	= "SC_LK";
		else if ( rh_typ_isStauffschelle )
			rh_typ	= "SC";
		else if ( finData.sec_steel.aSteeldata.length > 0 || AnzahlTeile > 1 )	// nur Stahlbau oder unbekannte LK ohne/mit Stahlbau
			rh_typ	= "FREE_LK";
		else if (AnzahlTeile == 1)	// einzelnes unbekanntes Teil
			rh_typ	= "FREE";
		else						// hier ist was komisch
			rh_typ	= "";
		// jetzt kann geprft werden ob ein "echtes" eFIN vorliegt
		//if ( bOTHEReFIN && rh_typ != "" && left(rh_typ, 4) != "FREE" ){
		if ( rh_typ != "" && left(rh_typ, 4) != "FREE" ){
			bOTHEReFIN	= false;
			beFIN		= true;
		}
		// die neu ermittelten Werte ggf. setzen
		if ( getstring("STKIMPORTLIST_TABELLE_SELECTED", "TEMP.STK_IMPORT_AREA") =! "" ){
			var ImportTablePos	= atoi(getstring("STKIMPORTLIST_TABELLE_SELECTED", "TEMP.STK_IMPORT_AREA"));
			setstring( "rh_typ", "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS[" + ImportTablePos + "].FINOBJECT.assembly", rh_typ );
			finData.assembly.rh_typ	= rh_typ;
			if ( atoi(getstring("springrate_g", "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS[" + ImportTablePos + "].FINOBJECT.assembly")) > 0
				&& getstring("fh_typ", "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS[" + ImportTablePos + "].FINOBJECT.assembly") == "" ){
				setstring( "fh_typ", "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS[" + ImportTablePos + "].FINOBJECT.assembly", "FH_SRate_" + getFinDataValue(finData, 'assembly', 'springrate_g') );
				finData.assembly.fh_typ	= "FH_SRate_" + getFinDataValue(finData, 'assembly', 'springrate_g');
			}
		}
		// just to be sure
		Basetype		= trimleft(Basetype, '@');
		Basetype_ext	= trimleft(Basetype_ext, '@');
	}
	// fr Gelenkstreben / Stossbremsen aus WI-eFIN noch HAENGEND oder STUETZEND bestimmen
	if ((rh_typ == "GS" || rh_typ == "DP" || rh_typ == "DB") && (beFIN || bSTK)){
		switch (vertikaldir_up[2]){
				case "X" :
					var HRohrmitte	= fround(finData.pipe.pipecenterx, 0);
					break;
				case "Y" :
					var HRohrmitte	= fround(finData.pipe.pipecentery, 0);
					break;
				default :
					var HRohrmitte	= fround(finData.pipe.pipecenterz, 0);
					break;
		}
		if (fround(finData.caddata.aCaddata[0].hlevel, 0) > HRohrmitte)
			rh_typ	+= "_H";	// HAENGEND
		else
			rh_typ	+= "_S";	// STUETZEND
	}
	var Typ_Hae_Lg	= getTypHL(rh_typ);
	
	if (Typ_Hae_Lg[0] == "FREIEPOSITION" && (beFIN || bOTHEReFIN || bSTK)){
		setstring("hangtype","DLGDATA.CA.FINDATA.FINOBJECT.restrain", Typ_Hae_Lg[1]);
		setstring("FINOBJECT.restrain.hangtype",eksPathImport, Typ_Hae_Lg[1]);
	}
	
	// bei Sttzen "FS" oder "KS" ohne Lager bzw.
	// Traverse ohne Lager
	// in der Systemcharakteristik kein RUT setzen
	if ((beFIN || bOTHEReFIN || bSTK) &&
		((rh_typ == "FS" || rh_typ == "KS" || rh_typ_isTraverse) && !rh_typ_isLager && !rh_typ_isFuehrungW))
		setstring("SYSTEMCHARAKTERISTIK.IDC_KEIN_ROHRUMSCHLIESSENDES_TEIL", _storeBasePath, "KEIN_ROHRUMSCHLIESSENDES_TEIL");
	
	var lk_typ		= left(trimleft(trimright(getFinDataValue(finData, 'assembly', 'lk_typ'), " "), " "), 2);
	var distance	= atoi(getFinDataValue(finData, 'assembly', 'distance'));
	//if (beFIN){	// Auswertung der Teile, da die Spannweite ggf. gendert wurde
	if (finData.partslist.aPartslist.length > 0){	// Auswertung der Teile, da die Spannweite ggf. gendert wurde
		for (var a = 0; a < finData.partslist.aPartslist.length; a++){
			var BauteilSPW	= isBauteilSpannweite (finData.partslist.aPartslist[a].typ);
			if (BauteilSPW.isBTmSPW){
				distance	= BauteilSPW.SPW;
				break;
			}
		}
	}
	var lk_num		= left(trimleft(trimright(getFinDataValue(finData, 'assembly', 'lk_num'), " "), " "), 1); // R2 Anz. d. Federn
	// Flexperte-Pos. wurde aus einem FIN erzeugt, welches eine Spannweite hatte aber nur "hngend einfach" ausgelegt wurde
	if (bSTK && distance > 0 && (lk_typ == "N1" || lk_num == "1"))
		distance	= 0;
	if (Typ_Hae_Lg[0] != "LAGER2011"){ // Lastabtragung nur bei LK relevant
		var Lastabtragung	= "_EINFACH";
		if (lk_typ == "N2" || distance != 0 || lk_num == "2"){
			Lastabtragung	= "_DOPPEL";
			var CheckSpw	= isSonderSpannweite(distance);
			if (CheckSpw.SonderSpw){
				setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE_SONDER_CHECK", _storeBasePath, "true");
				setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE_SONDER", _storeBasePath, distance);
				setstring("SOLLWERTE_SPANNWEITE.IDC_SPANNWEITE_EINZEL_SONDER_CHECK", _storeBasePath, "true");
				setstring("SOLLWERTE_SPANNWEITE.IDC_SPANNWEITE_EINZEL_SONDER", _storeBasePath, distance);
				// auch die "StandardSpw" setzen
				setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE", _storeBasePath, CheckSpw.NextSpw);
				setstring("SOLLWERTE_SPANNWEITE.SPANNWEITE", _storeBasePath, CheckSpw.NextSpw);
			}
			else{
				setstring("SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL.IDC_SPANNWEITE", _storeBasePath, distance);
				setstring("SOLLWERTE_SPANNWEITE.SPANNWEITE", _storeBasePath, distance);
			}
		}
		Lastabtragung	= Typ_Hae_Lg[1] + Lastabtragung;
		setstring("SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG", _storeBasePath, Lastabtragung);
		setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, Typ_Hae_Lg[0]);
	}
	else{	// Lagerteil
		var Lastabtragung	= "LAGER2011";
		setstring("SYSTEMCHARAKTERISTIK.IDC_LASTKETTE", _storeBasePath, "EINZEL_LAGER");

		if (Typ_Hae_Lg[1] == "FESTLAGER")	// Select auf Festlager setzen
			setstring("Systemcharakteristik.strSelRadioLager", _storeBasePath_Lager, "LAGER_FS");
		else if (atoi(medTemp) > 320)	// hier geht Stahl/PA-Gleitpaarung nicht mehr -> Stahl/Stahl whlen
			setstring("Systemcharakteristik.strSelRadioLager", _storeBasePath_Lager, "LAGER_SSG");
		// "GEFUEHRT" ist default -> abern nur bei Gleitlagern
		if (Typ_Hae_Lg[1] == "FUEHRUNGSLAGER")
			setstring("AuswahlRollenlager.strSelRadioRollerBearing", _storeBasePath_Lager, "GEFUEHRT");
		if (Typ_Hae_Lg[1] == "LOSLAGER")
			setstring("AuswahlStandard.strSelRadioFunction", _storeBasePath_Lager, "LOSE");
		else if (left(Typ_Hae_Lg[1], 9) == "FUEHRUNG_"){
			setstring("AuswahlStandard.strSelRadioFunction", _storeBasePath_Lager, "GEFUEHRT_MEHRFACH");
			setstring("AuswahlStandard.strSelComboFunction", _storeBasePath_Lager, Typ_Hae_Lg[1]);
		}
	}
	
	// Setzen der Krfte
	var force_normal	= (beFIN ? trimleft(trimright(getFinDataValue(finData, 'restrain', 'opforces'), " "), " ").split(' ') : trimleft(trimright(getFinDataValue(finData, 'required', 'force_normal'), " "), " ").split(' '));
	var f_normal_vorh	= true;
	var force_all		= (beFIN ? trimleft(trimright(getFinDataValue(finData, 'restrain', 'maxforces'), " "), " ").split(' ') : trimleft(trimright(getFinDataValue(finData, 'required', 'force_all'), " "), " ").split(' '));
	var f_all_vorh		= true;
	var dynforce		= (beFIN ? trimleft(trimright(getFinDataValue(finData, 'restrain', 'dynloads'), " "), " ").split(' ') : trimleft(trimright(getFinDataValue(finData, 'required', 'dynforce'), " "), " ").split(' '));
	var dynforce_vorh	= true;
	if (force_normal[0] == ""){
		f_normal_vorh	= false;
		for (var i = 0; i < 6; i++)
			force_normal[i] = 0;
	}
	// manchmal sind hier Werte PDMS-seitig falsch zugeordnet
	else{
		for (var i = 0; i < 3; i++){
			if (force_normal[i] < 0 && force_normal[i+3] <= 0){
				force_normal[i+3]	= (-1) * max(abs(force_normal[i]), abs(force_normal[i+3]));
				force_normal[i]		= 0;
			}
			else if (force_normal[i] < 0){
				var TempForce		= force_normal[i];
				force_normal[i]		= force_normal[i+3];
				force_normal[i+3]	= TempForce;
			}
		}
		for (i; i < 6; i++){
			if (force_normal[i] > 0 && force_normal[i-3] >= 0){
				force_normal[i-3]	= max(abs(force_normal[i]), abs(force_normal[i-3]));
				force_normal[i]		= 0;
			}
			else if (force_normal[i] > 0){
				var TempForce		= force_normal[i];
				force_normal[i]		= force_normal[i-3];
				force_normal[i-3]	= TempForce;
			}
		}
	}
	if (force_all[0] == ""){
		f_all_vorh	= false;
		for (var i = 0; i < 6; i++)
			force_all[i] = 0;
	}
	// manchmal sind hier Werte PDMS-seitig falsch zugeordnet
	else{
		for (var i = 0; i < 3; i++){
			if (force_all[i] < 0 && force_all[i+3] <= 0){
				force_all[i+3]	= (-1) * max(abs(force_all[i]), abs(force_all[i+3]));
				force_all[i]	= 0;
			}
			else if (force_all[i] < 0){
				var TempForce	= force_all[i];
				force_all[i]	= force_all[i+3];
				force_all[i+3]	= TempForce;
			}
		}
		for (i; i < 6; i++){
			if (force_all[i] > 0 && force_all[i-3] >= 0){
				force_all[i-3]	= max(abs(force_all[i]), abs(force_all[i-3]));
				force_all[i]	= 0;
			}
			else if (force_all[i] > 0){
				var TempForce	= force_all[i];
				force_all[i]	= force_all[i-3];
				force_all[i-3]	= TempForce;
			}
		}
	}
	if (dynforce[0] == ""){
		dynforce_vorh	= false;
		for (var i = 0; i < 3; i++)
			dynforce[i] = 0;
	}
	var Kraftmatrix	 = [];
	for (var i = 0; i < 6; i++)
		Kraftmatrix[i] =(abs(force_normal[i]) > abs(force_all[i]) ? force_normal[i] : force_all[i]);
	if (!f_normal_vorh && !f_all_vorh && !beFIN){
		// die "_force"-Werte kommen als absolute Maximalwerte mit Vorzeichen 
		var x_force		 = (vertikaldir_up[2] == "X" ? (-1)*abs(fround(atod(getFinDataValue(finData, 'required', 'x_force')), 2))
														: fround(atod(getFinDataValue(finData, 'required', 'x_force')), 2));
		if (x_force > 0)
			Kraftmatrix[0]	= x_force;
		else
			Kraftmatrix[3]	= x_force;
		var y_force		 = (vertikaldir_up[2] == "Y" ? (-1)*abs(fround(atod(getFinDataValue(finData, 'required', 'y_force')), 2))
														: fround(atod(getFinDataValue(finData, 'required', 'y_force')), 2));
		if (y_force > 0)
			Kraftmatrix[1]	= y_force;
		else
			Kraftmatrix[4]	= y_force;
		var z_force		 = (vertikaldir_up[2] == "Z" ? (-1)*abs(fround(atod(getFinDataValue(finData, 'required', 'z_force')), 2))
														: fround(atod(getFinDataValue(finData, 'required', 'z_force')), 2));
		if (z_force > 0)
			Kraftmatrix[2]	= z_force;
		else
			Kraftmatrix[5]	= z_force;
	}
	// Hnger haben separate vertikale Lastangaben
	if (Typ_Hae_Lg[2] == "FS" || Typ_Hae_Lg[2] == "KS" ||
		Typ_Hae_Lg[2] == "FH" || Typ_Hae_Lg[2] == "KH" ||
		Typ_Hae_Lg[2] == "GS" || Typ_Hae_Lg[3] == "SH" ||
		Typ_Hae_Lg[3] == "FSG"){
		var ZLast_EG	= 0;
		var F_HP		= abs(fround(atod(getFinDataValue(finData, 'required', 'instload')), 2));
		var F_Haenger	= (F_HP != 0 ? F_HP : abs(fround(atod(getFinDataValue(finData, 'required', 'z_statload')), 2)));
		F_HP			= F_Haenger;	// jetzt sind beide gleich
		
		// -Schu- "instload" und "z_statload" sind pro Halterungspunkt aber "statload" aus "restrain" ist pro Hnger
		// weiteres Problem -> "statload" ist inkl. Zusatzlast aus Eigengewicht
		// wenn beide Werte vorhanden sind, kann die wahrscheinliche Zusatzlast ermittelt werden
		if (beFIN){
			F_Haenger	= (right(Lastabtragung, 6) == "DOPPEL" ? 2 : 1) * abs(fround(atod(getFinDataValue(finData, 'restrain', 'statload')), 2));
			ZLast_EG	= (F_HP != 0 ? fround(abs(F_Haenger - F_HP), 2) : 0);
			if (ZLast_EG != 0){
				//setstring("AUSWAHL_HAENGERGROESSE.IDC_ZUS_LAST_EG_KH", _storeBasePath, ZLast_EG);
				//setstring("AUSWAHL_HAENGERGROESSE.IDC_ZUS_LAST_EG_FH", _storeBasePath, ZLast_EG);
				setstring("SOLLWERTE_HALTERUNGSPUNKT.Z_LAST_EG", _storeBasePath, ZLast_EG);
				F_Haenger	= F_HP;		// wenn hier die Zusatzlast nicht stimmt, muss die Last spter korrigiert werden
			}
		}
		if (bSTK){
			// OPERAT ist die in FL eingegebene Last ohne Zusatzlast
			F_Haenger	= abs(fround(atod(getFinDataValue(finData, 'required', 'operat')), 2));
		}
		
		if (F_Haenger != 0)
			switch (vertikaldir_up[2]){
				case "X":
					Kraftmatrix[3]	= (-1)*F_Haenger;
					break;
				case "Y":
					Kraftmatrix[4]	= (-1)*F_Haenger;
					break;
				default:	// "Z"
					Kraftmatrix[5]	= (-1)*F_Haenger;
					break;
			}
	}
	// Werte werden alle positiv in Tabelle eingesetzt
	for (var i = 0; i < 6; i++)
		//Kraftmatrix[i] = fround(abs(Kraftmatrix[i]),1);
		Kraftmatrix[i] = fround(abs(Kraftmatrix[i]), abs(Kraftmatrix[i]) < 10 ? 2 : 1);
	
	// Setzen der Bewegungen
	var Bewegungsmatrix	= [0,0,0,0,0,0];
	// Fall "normales" "FIN"
	if (!beFIN){
		var mov_normal		= trimleft(trimright(getFinDataValue(finData, 'required', 'mov_normal'), " "), " ").split(' ');
		var mov_normal_vorh	= (mov_normal[0] == "" ? false : true);
		if (!mov_normal_vorh)
			mov_normal		= Bewegungsmatrix;
		var mov_hdw_op		= trimleft(trimright(getFinDataValue(finData, 'required', 'mov_hdw_op'), " "), " ").split(' ');
		var mov_hdw_op_vorh	= (mov_hdw_op[0] == "" ? false : true);
		if (!mov_hdw_op_vorh)
			mov_hdw_op		= Bewegungsmatrix;
		var mov_w_op		= trimleft(trimright(getFinDataValue(finData, 'required', 'mov_w_op'), " "), " ").split(' ');
		var mov_w_op_vorh	= (mov_w_op[0] == "" ? false : true);
		if (!mov_w_op_vorh)
			mov_w_op		= Bewegungsmatrix;
		var mov_all			= trimleft(trimright(getFinDataValue(finData, 'required', 'mov_all'), " "), " ").split(' ');
		var mov_all_vorh	= (mov_all[0] == "" ? false : true);
		if (!mov_all_vorh)
			mov_all			= Bewegungsmatrix;
		var mov_hdw			= trimleft(trimright(getFinDataValue(finData, 'required', 'mov_hdw'), " "), " ").split(' ');
		var mov_hdw_vorh	= (mov_hdw[0] == "" ? false : true);
		if (!mov_hdw_vorh)
			mov_hdw			= Bewegungsmatrix;
		var mov_w			= trimleft(trimright(getFinDataValue(finData, 'required', 'mov_w'), " "), " ").split(' ');
		var mov_w_vorh		= (mov_w[0] == "" ? false : true);;
		if (!mov_w_vorh)
			mov_w			= Bewegungsmatrix;
	}
	else{	// Fall "eFIN"
		var mov_normal		= trimleft(trimright(getFinDataValue(finData, 'restrain', 'opmoves'), " "), " ").split(' ');
		var mov_normal_vorh	= (mov_normal[0] == "" ? false : true);
		if (!mov_normal_vorh)
			mov_normal_vorh	= Bewegungsmatrix;
		var mov_all			= trimleft(trimright(getFinDataValue(finData, 'restrain', 'maxmoves'), " "), " ").split(' ');
		var mov_all_vorh	= (mov_all[0] == "" ? false : true);
		if (!mov_all_vorh)
			mov_all_vorh	= Bewegungsmatrix;
		var mov_hdw_op		= Bewegungsmatrix;
		var mov_hdw_op_vorh	= false;
		var mov_w_op		= Bewegungsmatrix;
		var mov_w_op_vorh	= false;
		var mov_hdw			= Bewegungsmatrix;
		var mov_hdw_vorh	= false;
		var mov_w			= Bewegungsmatrix;
		var mov_w_vorh		= false;
	}
	// Auswerten der Bewegungen
	if (Typ_Hae_Lg[2] == "FS" || Typ_Hae_Lg[2] == "KS" || Typ_Hae_Lg[2] == "FH" || Typ_Hae_Lg[2] == "KH"){	// Lastkette
		if (!mov_normal_vorh && !mov_hdw_op_vorh && !mov_all_vorh && !mov_hdw_vorh && !beFIN){
			if (trimleft(trimright(getFinDataValue(finData, 'required', 'x_mov'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'x_mov')) > 0)
					Bewegungsmatrix[0]	= fround(atod(getFinDataValue(finData, 'required', 'x_mov')), 1);
				else
					Bewegungsmatrix[3]	= fround(atod(getFinDataValue(finData, 'required', 'x_mov')), 1);
			else if (trimleft(trimright(getFinDataValue(finData, 'required', 'x_mov_hdw'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'x_mov_hdw')) > 0)
					Bewegungsmatrix[0]	= fround(atod(getFinDataValue(finData, 'required', 'x_mov_hdw')), 1);
				else
					Bewegungsmatrix[3]	= fround(atod(getFinDataValue(finData, 'required', 'x_mov_hdw')), 1);
			if (trimleft(trimright(getFinDataValue(finData, 'required', 'y_mov'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'y_mov')) > 0)
					Bewegungsmatrix[1]	= fround(atod(getFinDataValue(finData, 'required', 'y_mov')), 1);
				else
					Bewegungsmatrix[4]	= fround(atod(getFinDataValue(finData, 'required', 'y_mov')), 1);
			else if (trimleft(trimright(getFinDataValue(finData, 'required', 'y_mov_hdw'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'y_mov_hdw')) > 0)
					Bewegungsmatrix[1]	= fround(atod(getFinDataValue(finData, 'required', 'y_mov_hdw')), 1);
				else
					Bewegungsmatrix[4]	= fround(atod(getFinDataValue(finData, 'required', 'y_mov_hdw')), 1);
			if (trimleft(trimright(getFinDataValue(finData, 'required', 'z_mov'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'z_mov')) > 0)
					Bewegungsmatrix[2]	= fround(atod(getFinDataValue(finData, 'required', 'z_mov')), 1);
				else
					Bewegungsmatrix[5]	= fround(atod(getFinDataValue(finData, 'required', 'z_mov')), 1);
			else if (trimleft(trimright(getFinDataValue(finData, 'required', 'z_mov_hdw'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'z_mov_hdw')) > 0)
					Bewegungsmatrix[2]	= fround(atod(getFinDataValue(finData, 'required', 'z_mov_hdw')), 1);
				else
					Bewegungsmatrix[5]	= fround(atod(getFinDataValue(finData, 'required', 'z_mov_hdw')), 1);
		}
		else{
			for (var i = 0; i < 6; i++)	// alle Werte werden ohne Vorzeichen an FL bergeben
				Bewegungsmatrix[i]	= fround(max(abs(mov_normal[i]),abs(mov_hdw_op[i]),abs(mov_all[i]),abs(mov_hdw[i])),1);
		}
		// die Hngerbewegung wird separat bergeben
		// Bestimmen der Position gem. der vertikalen Achse
		switch (vertikaldir_up[2]){
			case 'X'	:	// Senkrechte
				var PosKorr	= 0;
				break;
			case 'Y'	:
				var PosKorr	= 1;
				break;
			default		:	// "Z"
				var PosKorr	= 2;
				break;
		}
		// Fall "normales" "FIN"
		if (!beFIN){
			if (atod(getFinDataValue(finData, 'required', 'mov_hanger')) > 0)
				Bewegungsmatrix[PosKorr]	= fround(atod(getFinDataValue(finData, 'required', 'mov_hanger')),1);
			//else	// Achtung: "LEER" ist auch nicht ">0"
			else if (atod(getFinDataValue(finData, 'required', 'mov_hanger')) < 0)
				Bewegungsmatrix[PosKorr+3]	= fround(abs(atod(getFinDataValue(finData, 'required', 'mov_hanger'))),1);
		}
		else	// "eFIN"
			if (atod(getFinDataValue(finData, 'restrain', 'maxtravel')) > 0)
				Bewegungsmatrix[PosKorr]	= fround(atod(getFinDataValue(finData, 'restrain', 'maxtravel')),1);
			else
				Bewegungsmatrix[PosKorr+3]	= fround(abs(atod(getFinDataValue(finData, 'restrain', 'maxtravel'))),1);
	}
	else{	// Lagerteil
		if (!mov_normal_vorh && !mov_w_op_vorh && !mov_all_vorh && !mov_w_vorh && !beFIN){
			if (trimleft(trimright(getFinDataValue(finData, 'required', 'x_mov'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'x_mov')) > 0)
					Bewegungsmatrix[0]	= fround(atod(getFinDataValue(finData, 'required', 'x_mov')), 1);
				else
					Bewegungsmatrix[3]	= fround(atod(getFinDataValue(finData, 'required', 'x_mov')), 1);
			else if (trimleft(trimright(getFinDataValue(finData, 'required', 'x_mov_w'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'x_mov_w')) > 0)
					Bewegungsmatrix[0]	= fround(atod(getFinDataValue(finData, 'required', 'x_mov_w')), 1);
				else
					Bewegungsmatrix[3]	= fround(atod(getFinDataValue(finData, 'required', 'x_mov_w')), 1);
			if (trimleft(trimright(getFinDataValue(finData, 'required', 'y_mov'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'y_mov')) > 0)
					Bewegungsmatrix[1]	= fround(atod(getFinDataValue(finData, 'required', 'y_mov')), 1);
				else
					Bewegungsmatrix[4]	= fround(atod(getFinDataValue(finData, 'required', 'y_mov')), 1);
			else if (trimleft(trimright(getFinDataValue(finData, 'required', 'y_mov_w'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'y_mov_w')) > 0)
					Bewegungsmatrix[1]	= fround(atod(getFinDataValue(finData, 'required', 'y_mov_w')), 1);
				else
					Bewegungsmatrix[4]	= fround(atod(getFinDataValue(finData, 'required', 'y_mov_w')), 1);
			if (trimleft(trimright(getFinDataValue(finData, 'required', 'z_mov'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'z_mov')) > 0)
					Bewegungsmatrix[2]	= fround(atod(getFinDataValue(finData, 'required', 'z_mov')), 1);
				else
					Bewegungsmatrix[5]	= fround(atod(getFinDataValue(finData, 'required', 'z_mov')), 1);
			else if (trimleft(trimright(getFinDataValue(finData, 'required', 'z_mov_w'), " "), " ") != "")
				if (atod(getFinDataValue(finData, 'required', 'z_mov_w')) > 0)
					Bewegungsmatrix[2]	= fround(atod(getFinDataValue(finData, 'required', 'z_mov_w')), 1);
				else
					Bewegungsmatrix[5]	= fround(atod(getFinDataValue(finData, 'required', 'z_mov_w')), 1);
		}
		else{
			for (var i = 0; i < 6; i++)	// alle Werte werden ohne Vorzeichen an FL bergeben
				Bewegungsmatrix[i]	= fround(max(abs(mov_normal[i]),abs(mov_w_op[i]),abs(mov_all[i]),abs(mov_w[i])),1);
		}
	}
	
	// Bestimmung der Prflast
	var x_testload = (beFIN ? 0 : fround(getFinDataValue(finData, 'required', 'x_test_load'), 1));
    var y_testload = (beFIN ? 0 : fround(getFinDataValue(finData, 'required', 'y_test_load'), 1));
    var z_testload = (beFIN ? fround(getFinDataValue(finData, 'restrain', 'testload'), 1) : fround(getFinDataValue(finData, 'required', 'z_test_load'), 1));
	
	// Bestimmung des Rohrmittelpunktes
    var pipecenterx = fround(getFinDataValue(finData, 'pipe', 'pipecenterx'), 0);
    var pipecentery = fround(getFinDataValue(finData, 'pipe', 'pipecentery'), 0);
    var pipecenterz = fround(getFinDataValue(finData, 'pipe', 'pipecenterz'), 0);
	
	// Bestimmung Warm-/Kaltlast
	var load_type	= (beFIN ? getFinDataValue(finData, 'restrain', 'loadtype') : getFinDataValue(finData, 'assembly', 'load_type')) + "";
	if (load_type == "2" || load_type == "0" || load_type == 2 || load_type == 0 || load_type == "H")
		load_type	= "WARM";
	else
		load_type	= "KALT"
	setstring("SOLLWERTE_HALTERUNGSPUNKT.IDC_SOLLAST_IST", _storeBasePath, load_type);
	
	// bergabe der "Sollwerte Halterungspunkt" fr Lastkette
	var oTable_LK = {	last_plus		:	[Kraftmatrix[0],Kraftmatrix[1],Kraftmatrix[2]],
						last_minus		:	[Kraftmatrix[3],Kraftmatrix[4],Kraftmatrix[5]],
						zusatzlast		:	[0,0,0],	// immer NULL
						ueberlast		:	[x_testload,y_testload,z_testload],
						bewegung_plus	:	[Bewegungsmatrix[0],Bewegungsmatrix[1],Bewegungsmatrix[2]],
						bewegung_minus	:	[Bewegungsmatrix[3],Bewegungsmatrix[4],Bewegungsmatrix[5]],
						einfuegepunkt	:	[pipecenterx,pipecentery,pipecenterz]};
	
	var oTable_DYN = {	last_plus		:	[Kraftmatrix[0],Kraftmatrix[1],(dynforce_vorh ? dynforce[0] : Kraftmatrix[2])],
						last_minus		:	[Kraftmatrix[3],Kraftmatrix[4],(dynforce_vorh ? dynforce[0] : Kraftmatrix[5])],
						last_plus_HZ	:	[0,0,(dynforce_vorh ? dynforce[1] : 0)],
						last_minus_HZ	:	[0,0,(dynforce_vorh ? dynforce[1] : 0)],
						last_plus_HS	:	[0,0,(dynforce_vorh ? dynforce[2] : 0)],
						last_minus_HS	:	[0,0,(dynforce_vorh ? dynforce[2] : 0)],
						zusatzlast		:	[0,0,0],	// immer NULL
						ueberlast		:	[x_testload,y_testload,z_testload],
						bewegung_plus	:	[Bewegungsmatrix[0],Bewegungsmatrix[1],Bewegungsmatrix[2]],
						bewegung_minus	:	[Bewegungsmatrix[3],Bewegungsmatrix[4],Bewegungsmatrix[5]],
						einfuegepunkt	:	[pipecenterx,pipecentery,pipecenterz]};
	
	
    if (Typ_Hae_Lg[0] != "LAGER2011"){	// fhrt sonst zu falschen Werten in der Tabelle bei LAGER2011
		if (Typ_Hae_Lg[2] != "GS" && Typ_Hae_Lg[2] != "SB"){
			oTable_LK.toStorage(_storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE", false);
			// noch Werte in "AUSWAHL_HAENGERGROESSE" setzen die fehlen sonst dort nach Auto-Import
			setstring("IDC_SOLLWEG_KH_AUF",			_storeBasePath + ".AUSWAHL_HAENGERGROESSE", Bewegungsmatrix[PosKorr]);
			setstring("IDC_SOLLWEG_VERTIKAL_AUF",	_storeBasePath + ".AUSWAHL_HAENGERGROESSE", Bewegungsmatrix[PosKorr]);
			setstring("IDC_SOLLWEG_KH_AB",			_storeBasePath + ".AUSWAHL_HAENGERGROESSE", Bewegungsmatrix[PosKorr+3]);
			setstring("IDC_SOLLWEG_VERTIKAL_AB",	_storeBasePath + ".AUSWAHL_HAENGERGROESSE", Bewegungsmatrix[PosKorr+3]);
		}
		else
			oTable_DYN.toStorage(_storeBasePath + ".SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE", false);
	}
	// fr den Lagerteil ist der Aufbau der Tabelle anders (Unterscheidung in Axial - Lateral - Auflage/Abhebe(Schief) nicht X/Y/Z)
	var Kraftmatrix_LG		= [0,0,0,0,0,0];
	var Bewegungsmatrix_LG	= [0,0,0,0,0,0];
	// Umsortieren
	if (Rohrverlauf == 'HORIZONTAL'){
		switch (vertikaldir_up[2]){
			case 'X'	:	// Senkrechte
				Kraftmatrix_LG[2]		= Kraftmatrix[0];		//+abhebe 'X'
				Bewegungsmatrix_LG[2]	= Bewegungsmatrix[0];	//+abhebe 'X'
				Kraftmatrix_LG[5]		= Kraftmatrix[3];		//-auflage 'X'
				Bewegungsmatrix_LG[5]	= Bewegungsmatrix[3];	//-auflage 'X'
				if (left(Rohrachse, 1) == 'Y'){
					Kraftmatrix_LG[0]		= Kraftmatrix[1];		//+axial 'Y'
					Bewegungsmatrix_LG[0]	= Bewegungsmatrix[1];	//+axial 'Y'
					Kraftmatrix_LG[3]		= Kraftmatrix[4];		//-axial 'Y'
					Bewegungsmatrix_LG[3]	= Bewegungsmatrix[4];	//-axial 'Y'
					Kraftmatrix_LG[1]		= Kraftmatrix[2];		//+lateral 'Z'
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[2];	//+lateral 'Z'
					Kraftmatrix_LG[4]		= Kraftmatrix[5];		//-lateral 'Z'
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[5];	//-lateral 'Z'
				}
				else{
					Kraftmatrix_LG[0]		= Kraftmatrix[2];		//+axial 'Z'
					Bewegungsmatrix_LG[0]	= Bewegungsmatrix[2];	//+axial 'Z'
					Kraftmatrix_LG[3]		= Kraftmatrix[5];		//-axial 'Z'
					Bewegungsmatrix_LG[3]	= Bewegungsmatrix[5];	//-axial 'Z'
					Kraftmatrix_LG[1]		= Kraftmatrix[1];		//+lateral 'Y'
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[1];	//+lateral 'Y'
					Kraftmatrix_LG[4]		= Kraftmatrix[4];		//-lateral 'Y'
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[4];	//-lateral 'Y'
				}
			break;
			case 'Y'	:
				Kraftmatrix_LG[2]		= Kraftmatrix[1];		//+abhebe 'Y'
				Bewegungsmatrix_LG[2]	= Bewegungsmatrix[1];	//+abhebe 'Y'
				Kraftmatrix_LG[5]		= Kraftmatrix[4];		//-auflage 'Y'
				Bewegungsmatrix_LG[5]	= Bewegungsmatrix[4];	//-auflage 'Y'
				if (left(Rohrachse, 1) == 'Z'){
					Kraftmatrix_LG[0]		= Kraftmatrix[2];		//+axial 'Z'
					Bewegungsmatrix_LG[0]	= Bewegungsmatrix[2];	//+axial 'Z'
					Kraftmatrix_LG[3]		= Kraftmatrix[5];		//-axial 'Z'
					Bewegungsmatrix_LG[3]	= Bewegungsmatrix[5];	//-axial 'Z'
					Kraftmatrix_LG[1]		= Kraftmatrix[0];		//+lateral 'X'
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[0];	//+lateral 'X'
					Kraftmatrix_LG[4]		= Kraftmatrix[3];		//-lateral 'X'
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[3];	//-lateral 'X'
				}
				else{
					Kraftmatrix_LG[0]		= Kraftmatrix[0];		//+axial 'X'
					Bewegungsmatrix_LG[0]	= Bewegungsmatrix[0];	//+axial 'X'
					Kraftmatrix_LG[3]		= Kraftmatrix[3];		//-axial 'X'
					Bewegungsmatrix_LG[3]	= Bewegungsmatrix[3];	//-axial 'X'
					Kraftmatrix_LG[1]		= Kraftmatrix[2];		//+lateral 'Z'
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[2];	//+lateral 'Z'
					Kraftmatrix_LG[4]		= Kraftmatrix[5];		//-lateral 'Z'
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[5];	//-lateral 'Z'
				}
			break;
			default		: // auch case 'Z'
				Kraftmatrix_LG[2]		= Kraftmatrix[2];		//+abhebe 'Z'
				Bewegungsmatrix_LG[2]	= Bewegungsmatrix[2];	//+abhebe 'Z'
				Kraftmatrix_LG[5]		= Kraftmatrix[5];		//-auflage 'Z'
				Bewegungsmatrix_LG[5]	= Bewegungsmatrix[5];	//-auflage 'Z'
				if (left(Rohrachse, 1) == 'X'){		// X-Achse
					Kraftmatrix_LG[0]		= Kraftmatrix[0];		//+axial 'X'
					Bewegungsmatrix_LG[0]	= Bewegungsmatrix[0];	//+axial 'X'
					Kraftmatrix_LG[3]		= Kraftmatrix[3];		//-axial 'X'
					Bewegungsmatrix_LG[3]	= Bewegungsmatrix[3];	//-axial 'X'
					Kraftmatrix_LG[1]		= Kraftmatrix[1];		//+lateral 'Y'
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[1];	//+lateral 'Y'
					Kraftmatrix_LG[4]		= Kraftmatrix[4];		//-lateral 'Y'
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[4];	//-lateral 'Y'
				}
				else if (left(Rohrachse, 1) == 'Y'){	// Y-Achse
					Kraftmatrix_LG[0]		= Kraftmatrix[1];		//+axial 'Y'
					Bewegungsmatrix_LG[0]	= Bewegungsmatrix[1];	//+axial 'Y'
					Kraftmatrix_LG[3]		= Kraftmatrix[4];		//-axial 'Y'
					Bewegungsmatrix_LG[3]	= Bewegungsmatrix[4];	//-axial 'Y'
					Kraftmatrix_LG[1]		= Kraftmatrix[0];		//+lateral 'X'
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[0];	//+lateral 'X'
					Kraftmatrix_LG[4]		= Kraftmatrix[3];		//-lateral 'X'
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[3];	//-lateral 'X'
				}
				else {		// Schrger RL-Verlauf
					
				}
			break;
		}
	}
	else{
		switch (vertikaldir_up[2]){
			case 'X'	:	// Senkrechte
				// axial 'X'
				Kraftmatrix_LG[0]		= Kraftmatrix[0];
				Bewegungsmatrix_LG[0]	= Bewegungsmatrix[0];
				Kraftmatrix_LG[3]		= Kraftmatrix[3];
				Bewegungsmatrix_LG[3]	= Bewegungsmatrix[3];
				// auflage
				Kraftmatrix_LG[5]		= max(abs(Kraftmatrix[1]),abs(Kraftmatrix[4]),abs(Kraftmatrix[2]),abs(Kraftmatrix[5]));
				if (abs(Kraftmatrix[1]) == Kraftmatrix_LG[5]){	//max-Wert ist +Y
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[4];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[4];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[1];
					//lateral 'Z'
					Kraftmatrix_LG[1]		= Kraftmatrix[2];
					Kraftmatrix_LG[4]		= Kraftmatrix[5];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[2];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[5];
				}
				else if (abs(Kraftmatrix[4]) == Kraftmatrix_LG[5]){	//max-Wert ist -Y
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[1];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[1];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[4];
					//lateral 'Z'
					Kraftmatrix_LG[1]		= Kraftmatrix[2];
					Kraftmatrix_LG[4]		= Kraftmatrix[5];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[2];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[5];
				}
				else if (abs(Kraftmatrix[2]) == Kraftmatrix_LG[5]){	//max-Wert ist +Z
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[5];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[2];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[5];
					//lateral 'Y'
					Kraftmatrix_LG[1]		= Kraftmatrix[1];
					Kraftmatrix_LG[4]		= Kraftmatrix[4];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[1];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[4];
				}
				else if (abs(Kraftmatrix[5]) == Kraftmatrix_LG[5]){	//max-Wert ist -Z
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[2];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[5];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[2];
					//lateral 'Y'
					Kraftmatrix_LG[1]		= Kraftmatrix[1];
					Kraftmatrix_LG[4]		= Kraftmatrix[4];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[1];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[4];
				}
			break;
			case 'Y'	:	// Senkrechte
				// axial 'Y'
				Kraftmatrix_LG[0]		= Kraftmatrix[1];
				Bewegungsmatrix_LG[0]	= Bewegungsmatrix[1];
				Kraftmatrix_LG[3]		= Kraftmatrix[4];
				Bewegungsmatrix_LG[3]	= Bewegungsmatrix[4];
				// auflage
				Kraftmatrix_LG[5]		= max(abs(Kraftmatrix[0]),abs(Kraftmatrix[3]),abs(Kraftmatrix[2]),abs(Kraftmatrix[5]));
				if (abs(Kraftmatrix[0]) == Kraftmatrix_LG[5]){	//max-Wert ist +X
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[3];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[0];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[3];
					//lateral 'Z'
					Kraftmatrix_LG[1]		= Kraftmatrix[2];
					Kraftmatrix_LG[4]		= Kraftmatrix[5];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[2];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[5];
				}
				else if (abs(Kraftmatrix[3]) == Kraftmatrix_LG[5]){	//max-Wert ist -X
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[0];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[3];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[0];
					//lateral 'Z'
					Kraftmatrix_LG[1]		= Kraftmatrix[2];
					Kraftmatrix_LG[4]		= Kraftmatrix[5];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[2];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[5];
				}
				else if (abs(Kraftmatrix[2]) == Kraftmatrix_LG[5]){	//max-Wert ist +Z
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[5];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[2];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[5];
					//lateral 'X'
					Kraftmatrix_LG[1]		= Kraftmatrix[0];
					Kraftmatrix_LG[4]		= Kraftmatrix[3];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[0];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[3];
				}
				else if (abs(Kraftmatrix[5]) == Kraftmatrix_LG[5]){	//max-Wert ist -Z
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[2];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[5];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[2];
					//lateral 'X'
					Kraftmatrix_LG[1]		= Kraftmatrix[0];
					Kraftmatrix_LG[4]		= Kraftmatrix[3];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[0];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[3];
				}
			break;
			default	:	//auch case 'Z'
				// axial 'Z'
				Kraftmatrix_LG[0]		= Kraftmatrix[2];
				Bewegungsmatrix_LG[0]	= Bewegungsmatrix[2];
				Kraftmatrix_LG[3]		= Kraftmatrix[5];
				Bewegungsmatrix_LG[3]	= Bewegungsmatrix[5];
				// auflage
				Kraftmatrix_LG[5]		= max(abs(Kraftmatrix[0]),abs(Kraftmatrix[3]),abs(Kraftmatrix[1]),abs(Kraftmatrix[4]));
				if (abs(Kraftmatrix[0]) == Kraftmatrix_LG[5]){	//max-Wert ist +X
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[3];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[0];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[3];
					//lateral 'Y'
					Kraftmatrix_LG[1]		= Kraftmatrix[1];
					Kraftmatrix_LG[4]		= Kraftmatrix[4];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[1];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[4];
				}
				else if (abs(Kraftmatrix[3]) == Kraftmatrix_LG[5]){	//max-Wert ist -X
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[0];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[3];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[0];
					//lateral 'Y'
					Kraftmatrix_LG[1]		= Kraftmatrix[1];
					Kraftmatrix_LG[4]		= Kraftmatrix[4];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[1];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[4];
				}
				else if (abs(Kraftmatrix[1]) == Kraftmatrix_LG[5]){	//max-Wert ist +Y
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[4];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[4];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[1];
					//lateral 'X'
					Kraftmatrix_LG[1]		= Kraftmatrix[0];
					Kraftmatrix_LG[4]		= Kraftmatrix[3];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[0];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[3];
				}
				else if (abs(Kraftmatrix[4]) == Kraftmatrix_LG[5]){	//max-Wert ist -Y
					// abhebe
					Kraftmatrix_LG[2]		= Kraftmatrix[1];
					// auflage
					Bewegungsmatrix_LG[2]	= Bewegungsmatrix[1];
					// abhebe
					Bewegungsmatrix_LG[5]	= Bewegungsmatrix[4];
					//lateral 'X'
					Kraftmatrix_LG[1]		= Kraftmatrix[0];
					Kraftmatrix_LG[4]		= Kraftmatrix[3];
					Bewegungsmatrix_LG[1]	= Bewegungsmatrix[0];
					Bewegungsmatrix_LG[4]	= Bewegungsmatrix[3];
				}
			break;
		}
	}
	// Zuordnung der Hydrotestlasten
	switch (vertikaldir_up[2]){
		case "X" :
			if (Rohrverlauf	== "HORIZONTAL"){
				var aufl_testload	= x_testload;
				if (left(Rohrachse, 1) == "Z"){
					var axial_testload	= z_testload;
					var quer_testload	= y_testload;
				}
				else{
					var axial_testload	= y_testload;
					var quer_testload	= z_testload;
				}
			}
			else{
				var axial_testload	= x_testload;
				var aufl_testload	= max(abs(z_testload), abs(y_testload));
				var quer_testload	= min(abs(z_testload), abs(y_testload));
			}
			break;
		case "Y" :
			if (Rohrverlauf	== "HORIZONTAL"){
				var aufl_testload	= y_testload;
				if (left(Rohrachse, 1) == "Z"){
					var axial_testload	= z_testload;
					var quer_testload	= x_testload;
				}
				else{
					var axial_testload	= x_testload;
					var quer_testload	= z_testload;
				}
			}
			else{
				var axial_testload	= y_testload;
				var aufl_testload	= max(abs(z_testload), abs(x_testload));
				var quer_testload	= min(abs(z_testload), abs(x_testload));
			}
			break;
		default :	// "Z"
			if (Rohrverlauf	== "HORIZONTAL"){
				var aufl_testload	= z_testload;
				if (left(Rohrachse, 1) == "Y"){
					var axial_testload	= y_testload;
					var quer_testload	= x_testload;
				}
				else{
					var axial_testload	= x_testload;
					var quer_testload	= y_testload;
				}
			}
			else{
				var axial_testload	= z_testload;
				var aufl_testload	= max(abs(y_testload), abs(x_testload));
				var quer_testload	= min(abs(x_testload), abs(x_testload));
			}
			break;
	}
	var oTable_LG	= {	last_plus		:	{'axial' : Kraftmatrix_LG[0],'quer' : Kraftmatrix_LG[1],'schief' : Kraftmatrix_LG[2]},
						last_minus		:	{'axial' : Kraftmatrix_LG[3],'quer' : Kraftmatrix_LG[4],'schief' : Kraftmatrix_LG[5]},
						zusatzlast		:	{'axial' : 0,'quer' : 0,'schief' : 0},	// immer NULL
						//ueberlast		:	{'axial' : x_testload,'quer' : y_testload,'schief' : z_testload},
						ueberlast		:	{'axial' : axial_testload,'quer' : quer_testload,'schief' : aufl_testload},
						bewegung_plus	:	{'axial' : Bewegungsmatrix_LG[0],'quer' : Bewegungsmatrix_LG[1],'schief' : Bewegungsmatrix_LG[2]},
						bewegung_minus	:	{'axial' : Bewegungsmatrix_LG[3],'quer' : Bewegungsmatrix_LG[4],'schief' : Bewegungsmatrix_LG[5]},
						einfuegepunkt	:	{'axial' : pipecenterx,'quer' : pipecentery,'schief' : pipecenterz}};
	oTable_LG.toStorage(_storeBasePath_Lager + ".SollwerteHalterungspunkt.oTable", false);
	
	// Auswahl Hngergre
	if (Typ_Hae_Lg[2] == "KH" || Typ_Hae_Lg[2] == "KS")
		setstring("SELECT_KH", "DLGDATA.CA.FINDATA.DIALOGS", "true");
	
	// bersicht LK
	if (getFinDataValue(finData, 'assembly', 'name') != "")
		setstring("UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", _storeBasePath, getFinDataValue(finData, 'assembly', 'name'));
	else
		setstring("UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", _storeBasePath, getFinDataValue(finData, 'assembly', 'nodenumb'));
	setstring("UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR",  _storeBasePath, getFinDataValue(finData, 'assembly', 'drawing'));
    setstring("UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN",  _storeBasePath, getFinDataValue(finData, 'addinfo', 'remark'));
    setstring("UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS",  _storeBasePath, getFinDataValue(finData, 'addinfo', 'rfq_pos'));
	
	// Systemmasse bernehmen
	if (fileType == "FIN" || fileType == "L3D"){
		setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
		setstring("VORGABE_H2", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
		setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", "");
		// Fall "normales" "FIN"
		if (!beFIN && !bOTHEReFIN){
			switch (vertikaldir_up[2]){
				case "X" :
					var BA	= (!getFinDataValue(finData, 'steel', 'ba1x') ? "" : fround(getFinDataValue(finData, 'steel', 'ba1x'), 0));
					var HP	= pipecenterx;
					break;
				case "Y" :
					var BA	= (!getFinDataValue(finData, 'steel', 'ba1y') ? "" : fround(getFinDataValue(finData, 'steel', 'ba1y'), 0));
					var HP	= pipecentery;
					break;
				default :
					var BA	= (!getFinDataValue(finData, 'steel', 'ba1z') ? "" : fround(getFinDataValue(finData, 'steel', 'ba1z'), 0));
					var HP	= pipecenterz;
					break;
			}
			if (left(Lastabtragung, 6) == "STUETZ" || (quelle == 5 && (BA*1 < HP*1) )){		// setzen UBA
				if (BA == '')	// im FIN ist nichts gesetzt
					BA = HP*1 - getstring("IDC_MIN_SYSTEMMASS_STUETZEND_EDIT", "PROJECT.SETTINGS.FINDEFAULTS")*1;
				setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", BA);
				setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", HP);
			}
			else{	// setzen OBA
				if (BA == '')	// im FIN ist nichts gesetzt
					BA = HP*1 + getstring("IDC_MIN_SYSTEMMASS_HAENGEND_EDIT", "PROJECT.SETTINGS.FINDEFAULTS")*1;
				setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", BA);
				setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", HP);
			}
		}
		else{	// "eFIN"
			// Ausweten "caddata" "hlevel"
			// nutzen von Max- bzw. Minwert
			if (left(Lastabtragung, 6) == "STUETZ"){	// setzen UBA
				// H1 ... Rohrmitte -> fr automatischen Import mit setzen
				switch (vertikaldir_up[2]){
				case "X" :
					setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", pipecenterx);
					break;
				case "Y" :
					setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", pipecentery);
					break;
				default :
					setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", pipecenterz);
					break;
				}
				// H2 ... gibt es nicht
				if (beFIN) // letztes Objekt der Lastkette bei WI-eFIN
					setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", fround(finData.caddata.aCaddata[finData.caddata.aCaddata.length - 1].hlevel - finData.caddata.aCaddata[finData.caddata.aCaddata.length - 1].emass, 0));
				else // beOTHEReFIN -> LISEGA macht das andersrum
					setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", fround(finData.caddata.aCaddata[0].hlevel, 0));
			}
			else{
				if (beFIN || bSTK)	// 1. Objekt der Lastkette bei WI-eFIN
					setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", fround(finData.caddata.aCaddata[0].hlevel, 0));
				else // beOTHEReFIN -> LISEGA macht das andersrum
					setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", fround(finData.caddata.aCaddata[finData.caddata.aCaddata.length-1].hlevel - finData.caddata.aCaddata[finData.caddata.aCaddata.length - 1].emass, 0));
				var PosFHG		= -1;
				// H3 ... Rohrmitte -> fr automatischen Import mit setzen
				switch (vertikaldir_up[2]){
				case "X" :
					setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", pipecenterx);
					break;
				case "Y" :
					setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", pipecentery);
					break;
				default :
					setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", pipecenterz);
					break;
				}
				for (i = 0; i < finData.partslist.aPartslist.length; i++){
					if (left(finData.partslist.aPartslist[i].typ, 3) == "FHG" && PosFHG == -1){	// wir haben den ersten FHG
						PosFHG	= finData.partslist.aPartslist[i].posnr * 1;
						break;
					}
				}
				if (PosFHG > -1){
					var VORGABE_H2	= 0;	// FHG
					for (i = 0; i < finData.caddata.aCaddata.length; i++){
						if (finData.caddata.aCaddata[i].objnr * 1 < PosFHG)
							VORGABE_H2	+= (finData.caddata.aCaddata[i].emass * 1);
							// -Schu- ZPK / 2xMutter hat "negatives" E-Mass -> TODO
						if (finData.caddata.aCaddata[i].objnr * 1 == PosFHG)
							break;
					}
					setstring("VORGABE_H2", "DLGDATA.CA.FORMS.HOEHENLEVEL", fround(finData.caddata.aCaddata[0].hlevel, 0) - fround(VORGABE_H2, 0));
				}
			}
		}
	}
	else
	{
		setstring("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL", getFinDataValue(finData, 'assembly', 'h1'));
		setstring("VORGABE_H2", "DLGDATA.CA.FORMS.HOEHENLEVEL", getFinDataValue(finData, 'assembly', 'h2'));
		setstring("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL", getFinDataValue(finData, 'assembly', 'h3'));
	}
	
    // Lageplan-Daten aus STK bernehmen:
    setstring("LAGEPLAN_A", "DLGDATA.CA.FORMS.LAGEPLAN", getFinDataValue(finData, 'loc_plan', 'y1'));
    setstring("LAGEPLAN_B", "DLGDATA.CA.FORMS.LAGEPLAN", getFinDataValue(finData, 'loc_plan', 'y2'));
    setstring("LAGEPLAN_C", "DLGDATA.CA.FORMS.LAGEPLAN", getFinDataValue(finData, 'loc_plan', 'x1'));
    setstring("LAGEPLAN_D", "DLGDATA.CA.FORMS.LAGEPLAN", getFinDataValue(finData, 'loc_plan', 'x2'));
    if (getFinDataValue(finData, 'loc_plan', 'x_dist') != "")
		setstring("LAGEPLAN_X", "DLGDATA.CA.FORMS.LAGEPLAN", fround(getFinDataValue(finData, 'loc_plan', 'x_dist'), 0));
	else
		setstring("LAGEPLAN_X", "DLGDATA.CA.FORMS.LAGEPLAN", getFinDataValue(finData, 'loc_plan', 'x_dist'));
    setstring("LAGEPLAN_Y", "DLGDATA.CA.FORMS.LAGEPLAN", getFinDataValue(finData, 'loc_plan', 'angle_x'));
    if (getFinDataValue(finData, 'loc_plan', 'y_dist') != "")
		setstring("LAGEPLAN_Z", "DLGDATA.CA.FORMS.LAGEPLAN", fround(getFinDataValue(finData, 'loc_plan', 'y_dist'), 0));
	else
		setstring("LAGEPLAN_Z", "DLGDATA.CA.FORMS.LAGEPLAN", getFinDataValue(finData, 'loc_plan', 'y_dist'));
	
	// Steel und Required-Data kopieren ...
	setstring("Ba1X", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'ba1x'));
	setstring("Ba1Y", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'ba1y'));
	setstring("Ba1Z", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'ba1z'));
	setstring("BW1X", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bw1x'));
	setstring("BW1Y", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bw1y'));
	setstring("BS1", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bs1'));
	setstring("BK1", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bk1'));
	setstring("BA1", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'ba1'));
	setstring("BSP1", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bsp1'));
	setstring("Ba2X", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'ba2x'));
	setstring("Ba2Y", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'ba2y'));
	setstring("Ba2Z", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'ba2z'));
	setstring("BW2X", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bw2x'));
	setstring("BW2Y", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bw2y'));
	setstring("BS2", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bs2'));
	setstring("BK2", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bk2'));
	setstring("BA2", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'ba2'));
	setstring("BSP2", "DLGDATA.CA.FINDATA.STEEL", getFinDataValue(finData, 'steel', 'bsp2'));

	setstring("L_AXES", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'l_axes'));
	setstring("X_FORCE", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'x_force'));
	setstring("Y_FORCE", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'y_force'));
	setstring("Z_FORCE", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_force'));
	setstring("FORCE_NORMAL", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'force_normal'));	//neu
	setstring("FORCE_ALL", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'force_all'));		//neu
	setstring("Z_STATLOAD", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_statload'));
	setstring("INSTLOAD", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'instload'));			//neu
	setstring("X_FORCE_L", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'x_force_l'));
	setstring("Y_FORCE_L", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'y_force_l'));
	setstring("Z_FORCE_L", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_force_l'));
	//setstring("X_DYNFORCE", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'x_dynforce'));
	//setstring("Y_DYNFORCE", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'y_dynforce'));
	//setstring("Z_DYNFORCE", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_dynforce'));
	setstring("DYNFORCE", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'dynforce'));			//neu
	//setstring("X_DYNFORCE_L", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'x_dynforce_l'));
	//setstring("Y_DYNFORCE_L", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'y_dynforce_l'));
	//setstring("Z_DYNFORCE_L", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_dynforce_l'));
	setstring("X_MOV", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'x_mov'));
	setstring("X_MOV_HDW", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'x_mov_hdw'));		//neu
	setstring("X_MOV_W", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'x_mov_w'));			//neu
	setstring("Y_MOV", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'y_mov'));
	setstring("Y_MOV_HDW", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'y_mov_hdw'));		//neu
	setstring("Y_MOV_W", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'y_mov_w'));			//neu
	setstring("Z_MOV", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_mov'));
	setstring("Z_MOV_HDW", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_mov_hdw'));		//neu
	setstring("Z_MOV_W", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_mov_w'));			//neu
	setstring("MOV_NORMAL", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'mov_normal'));		//neu
	setstring("MOV_HDW_OP", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'mov_hdw_op'));		//neu
	setstring("MOV_W_OP", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'mov_w_op'));			//neu
	setstring("MOV_ALL", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'mov_all'));			//neu
	setstring("MOV_HDW", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'mov_hdw'));			//neu
	setstring("MOV_W", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'mov_w'));				//neu
	setstring("X_MOV_L", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'x_mov_l'));
	setstring("Y_MOV_L", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'y_mov_l'));
	setstring("Z_MOV_L", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_mov_l'));
	setstring("MOV_HANGER", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'mov_hanger'));
	//setstring("X_TEST_LOAD", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'x_test_load'));
	//setstring("Y_TEST_LOAD", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'y_test_load'));
	setstring("Z_TEST_LOAD", "DLGDATA.CA.FINDATA.REQUIRED", getFinDataValue(finData, 'required', 'z_test_load'));
	setstring("RH_TYP", "DLGDATA.CA.FINDATA.ASSEMBLY", trimleft(trimright(getFinDataValue(finData, 'assembly', 'rh_typ'), " "), " "));
	setstring("SPRINGRATE_G", "DLGDATA.CA.FINDATA.ASSEMBLY", trimleft(trimright(getFinDataValue(finData, 'assembly', 'springrate_g'), " "), " "));
	setstring("FH_TYP", "DLGDATA.CA.FINDATA.ASSEMBLY", trimleft(trimright(getFinDataValue(finData, 'assembly', 'fh_typ'), " "), " "));

	// SECONDARY-STEEL DATEN
	var steel_count = finData.sec_steel.aSteeldata.length;
	setstring ("STEEL_COUNT", "DLGDATA.CA.FINDATA.SECONDARY_STEEL", steel_count);
	for (var i = 0; i < steel_count; i++)
	{
		var j = i + 1;
		setstring("STEEL_ART" + j, "DLGDATA.CA.FINDATA.SECONDARY_STEEL",	getstring("steel_art", "TEMP.STK_SINGLE_IMPORT_AREA.FINOBJECT.sec_steel.aSteeldata[" + i + "]"));
		setstring("STEEL_KLASS" + j, "DLGDATA.CA.FINDATA.SECONDARY_STEEL",	getstring("steel_klass", "TEMP.STK_SINGLE_IMPORT_AREA.FINOBJECT.sec_steel.aSteeldata[" + i + "]"));
		setstring("STEEL_TYP" + j, "DLGDATA.CA.FINDATA.SECONDARY_STEEL",	getstring("steel_typ", "TEMP.STK_SINGLE_IMPORT_AREA.FINOBJECT.sec_steel.aSteeldata[" + i + "]"));
		setstring("STEEL_WERK" + j, "DLGDATA.CA.FINDATA.SECONDARY_STEEL",	getstring("steel_werk", "TEMP.STK_SINGLE_IMPORT_AREA.FINOBJECT.sec_steel.aSteeldata[" + i + "]"));
		
		var count_steel_mass = finData.sec_steel.aSteeldata[i].steel_mass.length;
		var tmpstr = finData.sec_steel.aSteeldata[i].steel_mass[0];
		if (count_steel_mass > 1)
		{
			for (var k = 1; k < count_steel_mass; k++)
			{
				tmpstr = tmpstr + " " + finData.sec_steel.aSteeldata[i].steel_mass[k];
			}
		}
		setstring("STEEL_MASS" + j, "DLGDATA.CA.FINDATA.SECONDARY_STEEL",	tmpstr);
	}
	
	// Pfad / Projektname :
	var projname			= getFinDataValue(finData, 'project', 'projname');
	if (FileName.dirExists(getFinDataValue(finData, 'project', 'projdirectory')))
		var projdirectory	= getFinDataValue(finData, 'project', 'projdirectory');
	else
		var projdirectory	= '';
	
	if (projdirectory != "")
	{
		var projFile = projname; // pipename;
		if (projFile.length > 0)
		{
			if (left(projFile, 1) == "/")
				projFile = right(projFile, projFile.length -1);
		}
		if (right(projdirectory, 1) != "\\")
			projdirectory = projdirectory + "\\";

        var newProjfilePath = "";
        if (projFile != "")
            newProjfilePath = projdirectory + projFile + ".wit";

		setstring("PROJECT.PROJECTPATH", "", newProjfilePath);
		setstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS", projdirectory);
		setstring("EXPORT_STK_VERZEICHNIS", "", projdirectory);
        /*
        if ((fileType == "FIN") && (!beFIN) && (!bOTHEReFIN) && (newProjfilePath != ""))
        {
            // Prfen ob noch ungesicherte nderungen da sind ...
            var strMod = getstring("PROJ_MODIFIED_FLAG", "PROJECT.SETTINGS");
            if (strMod == "MODIFIED")
            {
                result = messagebox(translate("WARNING_CURRENT_PROJECT_DELETE"), 4) != 6;
                specialexec("SaveProject");
            }
            
            // Prfen, ob neue Projektdatei schon da ist; wenn ja ffnen
            if (FileName.fileExists(newProjfilePath))
                specialexec("LoadProject");
            else {
                // Aktuelles Projekt leer machen ...
                delete("PROJECT.POSITIONS", "");
            }
        }
		*/
	}
	
	eFIN_Message.BaseType	= fileType;
	eFIN_Message.toStorage("DLGDATA.CA.FINDATA.eFIN_Message", false );
	
    return ret;
}

function getHanger (RHTyp_Info, tmpCaMainController, FinDefaults, isDoppelt, isHorizontal, PreMessage, Message, sNkleiner)
{
	var PassenderHaenger = {ret: 0, msg : '', selected: 0, fherg : [], ret_kh: 0, msg_kh : '', selected_kh: 0, kherg : []};
	if (left(RHTyp_Info[3], 1) == "F"){	// prfen, ob das vorgegebene "F" geht
		PassenderHaenger	= tmpCaMainController.legeFederhaengerAus(PassenderHaenger);
		if (!PassenderHaenger.ret && PassenderHaenger.fherg.length > 0){	// gibt FH aber mit zu groer Lastabweichung
			PassenderHaenger.ret	= 1;
			PreMessage				+= (Message != "" ? "\n" : "") + "Load deviation more than preset!";
		}
		else if (!PassenderHaenger.ret || !PassenderHaenger.fherg.length){	// kein FH gefunden wir versuchen KH
			RHTyp_Info[2]	= RHTyp_Info[2].replace("F","K");
			RHTyp_Info[3]	= RHTyp_Info[3].replace("F","K");
			PreMessage		+= (Message != "" ? "\n" : "") + "No FH/FS possible! KH/KS selected!";
		}
	}
	if (left(RHTyp_Info[3], 1) == "F"){	// ggf. ist jetzt aus "F" ein "K" geworden
		// bei zu kleiner Wegreserve ggf. einen lngeren Hnger whlen
		// "Streuung" der Zusatzlast als Annahme - im schlechtesten Fall wrde auch ein kleiner Hnger gehen
		var ChangeFH	= false;
		var DivDoppel	= (isDoppelt ? 2 : 1);
		var DifZuLa		= getstring("Z_LAST_EG", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT")*1000 / DivDoppel / PassenderHaenger.fherg[PassenderHaenger.selected].IDC_FEDERRATE;
		if (PassenderHaenger.fherg[PassenderHaenger.selected].IDC_WEGRESERVE_UNTEN - DifZuLa < PassenderHaenger.fherg[PassenderHaenger.selected].wegreserve_minimal)
			ChangeFH	= true;
		else if (PassenderHaenger.fherg[PassenderHaenger.selected].IDC_WEGRESERVE_OBEN - DifZuLa < PassenderHaenger.fherg[PassenderHaenger.selected].wegreserve_minimal)
			ChangeFH	= true;
		if (ChangeFH && ((PassenderHaenger.fherg.length - 1) > PassenderHaenger.selected))
			PassenderHaenger.selected	+= 1;
		if (sNkleiner){
			for (var i=0; i<PassenderHaenger.fherg.length; i++){
				if (PassenderHaenger.fherg[i].IDC_NENNWEG*1 < PassenderHaenger.fherg[PassenderHaenger.selected].IDC_NENNWEG*1 &&
					PassenderHaenger.fherg[i].IDC_LASTAENDERUNG*1 <= getstring("FH_PROZ_LASTAENDERUNG", "PROJECT.SETTINGS.CASCADE")*1){
						PassenderHaenger.selected	= i;
						if (PassenderHaenger.fherg[i].IDC_LASTGROESSE*1 > PassenderHaenger.fherg[PassenderHaenger.selected].IDC_LASTGROESSE*1)
							PreMessage		+= (Message != "" ? "\n" : "") + "Check system elevations!";
						i	= PassenderHaenger.fherg.length;
					}
			}
		}
		var HangerPath		= (PassenderHaenger.ret ? "TMP.CASELECTIONS.FHAENGER.VARIANTEN["+ PassenderHaenger.selected +"].HAENGER" : false);
		PassenderHaenger	= (PassenderHaenger.ret ? PassenderHaenger.fherg[PassenderHaenger.selected] : false);
		if (RHTyp_Info[1] == "STUETZEND"){
			var SollHaenger	= FinDefaults.IDC_STUETZE_TYP_FS_IST.split("_");
		}
		else{
			var SollHaenger	= FinDefaults.IDC_HANGER_TYP_FH_IST.split("_");
			if (isDoppelt && isHorizontal && atoi(FinDefaults.IDC_FDT_CHECK))
				SollHaenger[1]	= "FDT";
		}
		if (RHTyp_Info[0] == "GELENKSTUETZE")
			SollHaenger[1]	= "FSG_" + left(RHTyp_Info[1], 1);
	}
	else if (left(RHTyp_Info[3], 1) == "K"){
		if (typeof(PassenderHaenger) != 'object')
			PassenderHaenger = {ret: 0, msg : '', selected: 0, fherg : [], ret_kh: 0, msg_kh : '', selected_kh: 0, kherg : []};
		PassenderHaenger	= tmpCaMainController.legeKonstanthaengerAus(PassenderHaenger);
		var ChangeKH		= (PassenderHaenger.selected_kh > 0 ? 1 : 0);	// wenn mglich einen sN krzer um Probleme ZusLast zu vermeiden
		var HangerPath		= (PassenderHaenger.ret_kh ? "TMP.CASELECTIONS.KHAENGER.VARIANTEN["+ (PassenderHaenger.selected_kh-ChangeKH) +"].HAENGER" : false);
		PassenderHaenger	= (PassenderHaenger.ret_kh ? PassenderHaenger.kherg[PassenderHaenger.selected_kh-ChangeKH] : false);
		if (RHTyp_Info[1] == "STUETZEND")
			var SollHaenger	= FinDefaults.IDC_STUETZE_TYP_KS_IST.split("_");
		else
			var SollHaenger	= FinDefaults.IDC_HANGER_TYP_KH_IST.split("_");
	}
	var WIHanger = getstring("wihangtype", "DLGDATA.CA.FINDATA.FINOBJECT.addinfo");
	if (WIHanger == "")
		var strSQLaddInfo	= "and TYP_HANGER_DEFAULT_='" + SollHaenger[1] + "' ";
	else
		var strSQLaddInfo	= "and TYP_HANGER_DEFAULT_='" + WIHanger + "' ";
	return {Hanger : PassenderHaenger, SQL : strSQLaddInfo, Path : HangerPath, PreMessage : PreMessage};
}

function getSQLCombination(RHTyp_Info, isDoppelt, isHorizontal, isSchelle, isVAGP, strSQLaddInfo)
{
	return( "select * from DEFAULT_BT_IMPORT where RH_TYP='" + RHTyp_Info[3] + "' and IS_DOPPELT='" + isDoppelt + 
			"' and IS_HORIZONTAL='" + isHorizontal + "' and IS_SCHELLE='" + isSchelle + "' and IS_VAGP='" + isVAGP + "' " +
			strSQLaddInfo + "order by abs(SEQ_ID) ");
}

function enhanceFinFile(posPath)
{
	var oImport		= Object.fromStorage( posPath );
	var rh_typ		= oImport.FINOBJECT.assembly.rh_typ;
	var RHTyp_Info	= getTypHL(rh_typ);
	
	if (RHTyp_Info[3] == ""){	// wenn der Typ LEER ist, kann keine Systemcharakteristik bestimmt werden
			return {bOK : false};
	}
	
	// Damit nie Reste von vorher stehen bleiben:
	delete("", "DLGDATA");
	// Nach Abarbeitung dieses Requests muss der Standard-Main-Controller nicht raus-serialisiert werden:
	setstring("KILL_CAMAINCONTROLLER", "", "true");
	setSTKdataToDlgAbsPath(posPath, "FIN");
	
	var tmpCaMainController = new CaController();
	var FinDefaults			= Object.fromStorage( "PROJECT.SETTINGS.FINDEFAULTS" );
	var strSQLaddInfo		= "";
	var AchsKSInfo			= tmpCaMainController.dataAccess.getAchsKSInfo();
	var VertiDir			= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
	var isDoppelt			= (right(getstring("IDC_LASTABTRAGUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 6) == "DOPPEL" ? 1 : 0);
	var isHorizontal		= (getstring("IDC_ROHRVERLAUF", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") == "VERTIKAL" ? 0 : 1);
	var isSchelle			= (getstring("IDC_KEIN_ROHRUMSCHLIESSENDES_TEIL", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") == "KEIN_ROHRUMSCHLIESSENDES_TEIL" ? 0 : 1);
	var isHaengend			= (left(getstring("IDC_LASTABTRAGUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 8) == "HAENGEND" ? 1 : 0);
	
	// Pauschal Zusatzlast bercksichtigen
	var ZLast	= 0;
	if(isSchelle){
		//var EGDivisor	= (isDoppelt ? 400 : 1100);
		var SchelleDN	= getstring("IDC_NENNWEITE_DN", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")*1;
		var EGDivisor	= 320;	// fr DOPPELT
		if (!isDoppelt){
			EGDivisor	= (SchelleDN > 400 ? 700 : 1100);
		}
		ZLast	= fround(SchelleDN/EGDivisor, 2);
		setstring("Z_LAST_EG", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT", ZLast);
	}
	
	var Message			= "";	// generelle Hinweise
	var PreMessage		= "";	// zustzliche Hinweise
	
	var PassenderHaenger	= 0;
	
	// wenn wir einen "echten" Hnger brauchen, suchen wir einen
	// separate Funktion, weil wir ggf. dann nochmal neu suchen mssen
	//if (RHTyp_Info[0] == "BEWEGLICH"){
	if (RHTyp_Info[0] == "BEWEGLICH" || RHTyp_Info[0] == "GELENKSTUETZE"){
		var newHanger		= getHanger(RHTyp_Info, tmpCaMainController, FinDefaults, isDoppelt, isHorizontal, PreMessage, Message, false);
		PassenderHaenger	= newHanger.Hanger;
		strSQLaddInfo		+= newHanger.SQL;
		var HangerPath		= newHanger.Path;
		PreMessage			= newHanger.PreMessage;
	}
	
	// wenn wir einen "starren" Hnger haben - prfen mit/ohne ZSM
	if (RHTyp_Info[0] == "STARR"){
		var HangerSH	= FinDefaults.IDC_HANGER_TYP_SH_IST.split("_");
		strSQLaddInfo	+= "and TYP_HANGER_DEFAULT_='" + HangerSH[1] + "' ";
	}
	
	// wenn wir eine Strebe brauchen, suchen wir eine
	var LGG	= "";
	if (RHTyp_Info[0] == "GELENKSTREBE"){
		tmpCaMainController.legeSSGAus();
		LGG	= tmpCaMainController.topologieKlasse.Haenger.m_strLGG;
	}
	// wenn wir eine Bremse brauchen, suchen wir eine
	if (RHTyp_Info[0] == "STOSSBREMSE"){
		tmpCaMainController.legeSSBAus();
		LGG	= tmpCaMainController.topologieKlasse.Haenger.m_strLGG;
	}
	// LGG der FSG
	if (RHTyp_Info[0] == "GELENKSTUETZE"){
		dbselect("CASCADE", "select * from FSG where abs(LASTGR)=" + newHanger.Hanger.IDC_LASTGROESSE + " ", "FSG_LGG");
		LGG	= dbgetdouble("FSG_LGG", "LGG");
		if (LGG < 10)
			LGG	= "00" + LGG;
		else if (LGG < 100)
			LGG	= "0" + LGG;
	}
	
	// Nennweite
	var Nennweite		= "";
	var SchelBetrLast	= "";
	var SchelKaltLast	= "";
	var Testlast		= tmpCaMainController.dataAccess.getSollwerteUeberLast(1, AchsKSInfo[6]);
	var TempMedium		= "";
	var TempReferenz	= "";
	var WstPossible		= "";
	var WstSelect		= "";
	var TempKorrFakt	= "";
	var Daemmdicke		= "";
	if (isSchelle){
		Nennweite		= getstring("IDC_NENNWEITE_DN", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")*1;
		RohraussenDmr	= getstring("IDC_AUSSENDURCHMESSER", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")*1;
		TempMedium		= getstring("IDC_TEMPERATUR_MEDIUM", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")*1;
		TempReferenz	= getstring("IDC_TEMPERATUR_REFERENZ", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")*1;
		Daemmdicke		= getstring("IDC_DAEMMDICKE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")*1;
		WstPossible		= tmpCaMainController.getPassendeWerkstoffe(TempMedium, TempReferenz, "S235 JRG2");
		WstSelect		= WstPossible.strRecommended;
		TempKorrFakt	= tmpCaMainController.CompTempKorr(TempReferenz, tmpCaMainController.dataAccess.getZahlFromWerkstoff(WstSelect));
		if (!PassenderHaenger){		// einzelnes Lager (nicht in Hngerlastkette) oder Starrer Hnger
			if (tmpCaMainController.dataAccess.getLastketteTyp() == "EINZEL_LAGER"){	// Einzelnes Lager
				if (VertiDir == "AUF")
					SchelBetrLast	= Math.abs(getstring("last_minus.schief", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteHalterungspunkt.oTable"));
				else	
					SchelBetrLast	= Math.abs(getstring("last_plus.schief", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteHalterungspunkt.oTable"));
			}
			else{	// Starre Lastkette
				if (VertiDir == "AUF")
					SchelBetrLast	= Math.abs(tmpCaMainController.dataAccess.getSollwerteLast("-", 1, AchsKSInfo[6]));
				else	
					SchelBetrLast	= Math.abs(tmpCaMainController.dataAccess.getSollwerteLast("+", 1, AchsKSInfo[6]));
			}
			SchelKaltLast	= SchelBetrLast;
		}
		else{
			if (left(PassenderHaenger.IDC_GRUNDTYP, 1) == "F"){	// Federhnger
				SchelBetrLast	= PassenderHaenger.IDC_WARMLAST * (isDoppelt ? 2 : 1);
				SchelKaltLast	= PassenderHaenger.IDC_KALTLAST * (isDoppelt ? 2 : 1);
			}
			else{	// Konstanthnger
				SchelBetrLast	= PassenderHaenger.IDC_SOLLLAST_KH * (isDoppelt ? 2 : 1);
				SchelKaltLast	= SchelBetrLast;
			}
		}
	}
	// Spannweite
	var Spannweite	= "";
	if (isDoppelt){
		if (getstring("IDC_SPANNWEITE_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL") == "true")
			Spannweite	=	getstring("IDC_SPANNWEITE_SONDER", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")*1;
		else
			Spannweite	= getstring("IDC_SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL")*1;
		Spannweite	=	(Spannweite != 0 ? Spannweite : FinDefaults.IDC_MIN_SPANNWEITE_EDIT);
		setstring("distance", posPath + "FINOBJECT.assembly", Spannweite);	// damit es beim nchsten durchlauf stimmt
		// jetzt noch die Vorbelegung korrigieren - just to be sure
		var CheckSpw	= isSonderSpannweite(Spannweite);
		if (!CheckSpw.SonderSpw){
			setstring("IDC_SPANNWEITE_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", "false");	// sonst bekommen wir eine Sonderschelle mit Standardspannweite
			setstring("IDC_SPANNWEITE_SONDER", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", "");	// sonst bekommen wir eine Sonderschelle mit Standardspannweite
			setstring("IDC_SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", Spannweite);
			setstring("SPANNWEITE_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE", "false");
			setstring("SPANNWEITE_SONDER", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE", "");
			setstring("SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE", Spannweite);
		}
		else{
			setstring("IDC_SPANNWEITE_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", "true");	// sonst bekommen wir eine Sonderschelle mit Standardspannweite
			setstring("IDC_SPANNWEITE_SONDER", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", Spannweite);	// sonst bekommen wir eine Sonderschelle mit Standardspannweite
			setstring("IDC_SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", CheckSpw.NextSpw);
			setstring("SPANNWEITE_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE", "true");
			setstring("SPANNWEITE_SONDER", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE", Spannweite);
			setstring("SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE", CheckSpw.NextSpw);
		}
	}
	// wir bestimmen, ob wir ein LXL brauchen
	var isVAGP	= "0";
	if ((RHTyp_Info[0] == "LAGER2011" && FinDefaults.IDC_LAGER_BASETYP_IST == "IDC_EPG_CHECK") ||
		(RHTyp_Info[3] == "FS" && FinDefaults.IDC_STUETZE_TYP_FS_IST == "IDC_FSP_CHECK") ||
		(RHTyp_Info[3] == "KS" && FinDefaults.IDC_STUETZE_TYP_KS_IST == "IDC_KSP_CHECK"))
			isVAGP	= "1";
	// wir bestimmen auf Basis des Typs die notwendigen Bauteile aus einer Tabelle
	var strSQL	= getSQLCombination(RHTyp_Info, isDoppelt, isHorizontal, isSchelle, isVAGP, strSQLaddInfo);
	
	var NumLKCombination	= dbselect( "CASCADE", strSQL, "IMPORT" );
	
	// wir bestimmen die LGV der Lastkette
	if (PassenderHaenger != 0)	// der Hnger bestimmt die LGV
		var LGV		= PassenderHaenger.lgv;
	else	// die Betriebslast bestimmt die LGV
		var LGV	= tmpCaMainController.GetLGVfromLast();
	
	var MacheWeiter	= 1;	// manchmal sind mehrere Kombinationen denkbar -> Abbruch nach erster die erfolgreich war
	var LoopsHanger	= 3;	// max. Anz. der Versuche der Hngerauslegung
	
	while ( dbiseof( "IMPORT" ) == 0 && MacheWeiter ){
		var AnzBT		= dbgetdouble("IMPORT", "ANZ_BT");
		var ZLastBT		= 0;		// tatschliche Zusatzlast
		var bHaenger	= (PassenderHaenger != 0 ? false : true);	// sind wir schon am Haenger vorbei bzw. gibt es einen?
		var StueLi		= [];
		var caddata		= {};
		var partslist	= {};
		var aCaddata	= [];
		var aPartslist	= [];
		var lGwstGesch	= abs(getdouble("VORGABE_H1", "DLGDATA.CA.FORMS.HOEHENLEVEL") - getdouble("VORGABE_H3", "DLGDATA.CA.FORMS.HOEHENLEVEL"));
		Message			= "";
		for (var BT=1; BT<=AnzBT; BT++){
			var Bauteil	= dbgetstring("IMPORT", "BAUTEIL"+BT);
			switch (Bauteil){
				case "ZLN/ZKB/ZKN"	:
				case "ZLK/ZKK"	:
				case "ZLN"	:
					var Success	= (LGV != "" ? true : false);	// LGV prfen!!!
					if (Success){
						if (FinDefaults.IDC_TYP_TRAEGERANSCHLUSS_IST == "IDC_SCHWEISS_CHECK")
							Bauteil	= left(Bauteil, 3) + " " + LGV + "-3";		// die Schweilaschen stehen als erstes - jew. nur eine Variante "ZLN" bzw. "ZKN"
						else{	// die Klemmvarianten "ZKB/ZKN" bzw. "ZKK"
							// Bestimmen der Trgerinformationen
							var SQLTraeger	= "select * from TRAEGER_" + FinDefaults.IDC_TYP_TRAEGER_COMBO + " where abs(KUERZEL)=" + FinDefaults.IDC_SUBTYP_TRAEGER_COMBO + " ";
							var NumRet		= dbselect( "CASCADE", SQLTraeger, "TRAEGER" );
							if (NumRet < 1)
								Success	= false;
							else{
								// Schweilaschen aus "Bauteil" entfernen
								Bauteil	= right(Bauteil, Bauteil.length - 4);
								var Btr	= dbgetdouble("TRAEGER", "BTR");
								var tG	= dbgetdouble("TRAEGER", "TG");
								if (left(Bauteil, 3) == "ZKB" && LGV*1 == 12 && Btr <= 300 && tG <= 21)
									Bauteil	= left(Bauteil, 3) + LGV + "." + (Btr <= 200 ? "200" : "300") + "-2";		// ZKB
								else{
									Bauteil	= right(Bauteil, 3);	// ZKN oder ZKK
									if (Bauteil == "ZKN")
										Bauteil += "2." + LGV + "." + Btr + "." + tG + "-2";	// wir legen immer ZKN Typ 2 aus
									else
										Bauteil	+= LGV + "." + Btr + "." + tG + "-2";
								}
							}
						}
						if (Success){
							aCaddata.push({
											objnr		: BT,
											posstrang	: BT,
											hlevel		: '88',
											emass		: ''
											});
							aPartslist.push({
											 posnr	: BT,
											 anz	: (isDoppelt ? '2' : '1'),
											 typ	: Bauteil,
											 matnr	: ''
											});
						}
					}
					else	// Versuch abbrechen
						BT	= AnzBT + 1;
					break;
				case "ZGM"	:
				case "ZOM"	:
				case "ZSM"	:
				case "ZHM"	:
				case "ZLM"	:
					var Success	= (LGV != "" ? true : false);	// LGV prfen!!!
					if (Success){
						var TempZUB	= new Zubehoer();
						// Init : function(/*string*/ nTypID, /* string */ plgv , /*string*/ cpartid)
						Success		= TempZUB.Init(Bauteil, LGV*1, "");
					}
					if (Success){
						if (Bauteil == "ZSM" && rh_typ == "SH"){	// das Spannschloss ist der "Haenger"
							tmpCaMainController.topologieKlasse.SegmentStrang.Haenger = TempZUB;
							tmpCaMainController.topologieKlasse.a_lgv	= LGV;
						}
						ZLastBT		= (bHaenger ? ZLastBT + fround(getdouble("GEWICHT", "TMP.ZB_ADDITIONAL_DATA"), 2) : ZLastBT);
						lGwstGesch	-= getdouble("E", "TMP.ZB_ADDITIONAL_DATA");
						Bauteil	+= LGV + "-1";
						aCaddata.push({
										objnr		: BT,
										posstrang	: BT,
										hlevel		: '88',
										emass		: ''
										});
						aPartslist.push({
										 posnr	: BT,
										 anz	: (isDoppelt ? '2' : '1'),
										 typ	: Bauteil,
										 matnr	: ''
										});
					}
					else	// Versuch abbrechen
						BT	= AnzBT + 1;
					break;
				case "ZRM"	:
					var Success	= (LGV != "" ? true : false);	// LGV prfen!!!
					if (Success){
						//ZLastBT	= (bHaenger ? ZLastBT + fround(LGV / 1000, 2) : ZLastBT);	// am Ende anhand lGwstGesch addieren
						Bauteil	+= LGV + ".0000-1";
						aCaddata.push({
										objnr		: BT,
										posstrang	: BT,
										hlevel		: '88',
										emass		: ''
										});
						aPartslist.push({
										 posnr	: BT,
										 anz	: (isDoppelt ? '2' : '1'),
										 typ	: Bauteil,
										 matnr	: ''
										});
					}
					else	// Versuch abbrechen
						BT	= AnzBT + 1;
					break;
				case "ZTN"	:
					var Success	= (LGV != "" ? true : false);	// LGV prfen!!!
					if (Success){
						var TempZTN	= new Zubehoer();
						Success		= TempZTN.InitZTN(LGV, Spannweite);
					}
					if (Success){
						var Obfl	= Oberflaechenschutz[getstring("OBFL_TRAVERSEN", "PROJECT.SETTINGS.CASCADE")];
						ZLastBT		+= getstring("GEWICHT", "TMP.ZB_ADDITIONAL_DATA")*1;
						var SSpw	= isSonderSpannweite(Spannweite);
						SSpw		= (SSpw.SonderSpw ? "-S" : "");
						Bauteil	+= + SSpw + LGV + "." + (Spannweite < 1000 ? "0" : "") + Spannweite + "-37." + Obfl;
						aCaddata.push({
										objnr		: BT,
										posstrang	: BT,
										hlevel		: '88',
										emass		: ''
										});
						aPartslist.push({
										 posnr	: BT,
										 anz	: '1',
										 typ	: Bauteil,
										 matnr	: ''
										});
					}
					else	// Versuch abbrechen
						BT	= AnzBT + 1;
					break;
				case "VSR"						:
				case "VPR"						:
				case "VGR"						:
				case "VBK"						:
				case "VKK/VKR"					:
				case "VKR/VKK"					:
				case "VBK/VKR/VKK/VSR/VPR/VGR"	:
					var VSchellen	= Bauteil.split("/");
					for (var VVarianten = 0; VVarianten < VSchellen.length; VVarianten++){
						var SchelleIst	= tmpCaMainController.SeekVSchelle(VSchellen[VVarianten], Nennweite, Spannweite, (SchelBetrLast / TempKorrFakt), SchelKaltLast, Testlast, TempKorrFakt, SchelBetrLast, LGG, WstSelect);
						if (SchelleIst.success){
							SucheWeiter	= false;
							VVarianten	= VSchellen.length;
						}
					}
					if (!SchelleIst.success){	// wir knnen diesen Versuch abbrechen
						BT		= AnzBT + 1;
						Message	+= "No selection of clamp possible!";
					}
					else{
						StueLi.push(SchelleIst.schelle);
						ZLastBT	+= SchelleIst.schelle.m_Pgewicht;
						lGwstGesch	-= SchelleIst.schelle.m_Pemass;
						Bauteil	= SchelleIst.schelle.m_Ptyp;
						if (isHaengend)
							Bauteil	= Bauteil.replace(".-", "."+LGV+"-");	// nur fr "HAENGEND"
						else
							Bauteil	= Bauteil.replace(".-", ".00-");	// nur fr "STUETZEND"
						aCaddata.push({
										objnr		: BT,
										posstrang	: BT,
										hlevel		: '88',
										emass		: SchelleIst.schelle.m_Pemass
										});
						aPartslist.push({
										 posnr	: BT,
										 anz	: '1',
										 typ	: Bauteil.replace(" ", ""),
										 matnr	: ''
										});
					}
					break;
				case "HDx/HBx"			:
				case "HGx"				:
				case "HZx/HDx/HBx/HGx"	:
				case "MSN"				:	// noch testen
				case "MSL"				:	// noch testen
					var HSchellen		= Bauteil.replace("x", "N");
					HSchellen			= HSchellen.split("/");
					var WstZahl			= tmpCaMainController.dataAccess.getZahlFromWerkstoff(WstSelect);
					var DaemmdickeIst	= Daemmdicke;
					for (var HVarianten = 0; HVarianten < HSchellen.length; HVarianten++){
						var SucheWeiter		= true;
						var LoopDaemmdicke	= false;
						while (SucheWeiter){
							var SchelleIst	= tmpCaMainController.SeekHschel(Nennweite, (SchelBetrLast / TempKorrFakt), HSchellen[HVarianten], TempKorrFakt, 0, SchelKaltLast, SchelBetrLast, Testlast, Daemmdicke, WstZahl);
							if (SchelleIst.success){
								SucheWeiter	= false;
								HVarianten	= HSchellen.length + 1;
								if (LoopDaemmdicke){
									PreMessage	+= (PreMessage != "" ? "\n" : "") + "Insulation reduced from " + DaemmdickeIst + " mm to " + Daemmdicke + " mm!";
									setstring("FINOBJECT.pipe.insulat", posPath, Daemmdicke);
									setstring("FINOBJECT.project.addinfo", posPath, "Insulation " + DaemmdickeIst + " mm!");
									/*
									// Das wird dann gleich wieder gelscht
									setstring("IDC_DAEMMDICKE", "DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL", Daemmdicke);
									setstring("insulat", "DLGDATA.CA.FINDATA.FINOBJECT.pipe", Daemmdicke);
									setstring("IDC_BEMERKUNGEN", "DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE", "Insulation " + DaemmdickeIst + " mm!");
									*/
								}
							}
							else if (!SchelleIst.success && SchelleIst.f_exists && SchelleIst.nw_exists && !LoopDaemmdicke){
								Daemmdicke		= fround(2 * Daemmdicke / 3, 0);
								LoopDaemmdicke	= true;
							}
							else if (right(HSchellen[HVarianten], 1) == "S"){
								SucheWeiter	= false;
								Daemmdicke	= DaemmdickeIst;
							}
							else{
								HSchellen[HVarianten]	= left(HSchellen[HVarianten], 2) + (right(HSchellen[HVarianten], 1) == "N" ? "V" : "S");
								Daemmdicke				= DaemmdickeIst;
								LoopDaemmdicke			= false;
							}
						}
					}
					if (!SchelleIst.success || LGV == ""){	// wir knnen diesen Versuch abbrechen
						BT	= AnzBT + 1;
						Message	+= "No selection of clamp possible!";
					}
					else{
						ZLastBT	+= SchelleIst.schelle.m_Pgewicht;
						lGwstGesch	-= SchelleIst.schelle.m_Pemass;
						Bauteil	= SchelleIst.schelle.m_Ptyp;
						if (left(Bauteil, 1) != "M")
							Bauteil	= Bauteil.replace(".-", "."+LGV+"-");
						else{
							if (RHTyp_Info[0] = "GELENKSTUETZE"){
								if (LGG*1 <10)
									LGG	= "00" + LGG*1;
								else if (LGG*1 < 100)
									LGG	= "0" + LGG*1;
								else
									LGG	= LGG*1;
							}
							else{
								if (LGG*1 <10)
									LGG	= "000" + LGG*1;
								else if (LGG*1 < 100)
									LGG	= "00" + LGG*1;
								else if (LGG*1 < 1000)
									LGG	= "0" + LGG*1;
								else
									LGG	= LGG*1;
							}
							Bauteil	= Bauteil.replace(".-", "."+LGG+"-");
						}
						StueLi.push(SchelleIst.schelle);
						aCaddata.push({
										objnr		: BT,
										posstrang	: BT,
										hlevel		: '88',
										emass		: SchelleIst.schelle.m_Pemass
										});
						aPartslist.push({
										 posnr	: BT,
										 anz	: '1',
										 typ	: Bauteil.replace(" ", ""),
										 matnr	: ''
										});
					}
					break;
				case "FSS"	:
				case "FSP"	:
				case "FHD"	:
				case "FHG"	:
				case "FHS"	:
				case "FDT"	:
				case "FSG"	:
				case "KHD"	:
				case "KVD"	:
				case "KHS"	:
				case "KVS"	:
				case "KSR"	:
				case "KSP"	:
					if (!PassenderHaenger)	// wir knnen diesen Versuch abbrechen
						BT	= AnzBT + 1;
					else{
						bHaenger	= true;
						if (isHaengend && RHTyp_Info[0] != "GELENKSTUETZE"){
							tmpCaMainController.topologieKlasse.SegmentStrang.Haenger = (left(Bauteil, 1) == "F" ? new Federhaenger() : new Konstanthaenger());
							tmpCaMainController.topologieKlasse.SegmentStrang.Haenger.serializeIn(HangerPath);
							tmpCaMainController.topologieKlasse.SegmentStrang.Haenger.Selected(Bauteil, Spannweite, 1);
							StueLi.push(tmpCaMainController.topologieKlasse.SegmentStrang.Haenger);
							if (Bauteil == "FDT"){
								ZLastBT	+= tmpCaMainController.topologieKlasse.SegmentStrang.Haenger.aktgew*1 + tmpCaMainController.topologieKlasse.SegmentStrang.Haenger.m_FDT_TGewicht*1;
							}
							Bauteil		= tmpCaMainController.topologieKlasse.SegmentStrang.Haenger.m_Ptyp;
							var Emass	= tmpCaMainController.topologieKlasse.SegmentStrang.Haenger.m_Pemass;
						}
						else{
							tmpCaMainController.topologieKlasse.Haenger = (left(Bauteil, 1) == "F" ? new Federhaenger() : new Konstanthaenger());
							tmpCaMainController.topologieKlasse.Haenger.serializeIn(HangerPath);
							tmpCaMainController.topologieKlasse.Haenger.Selected(Bauteil, Spannweite, 1);
							StueLi.push(tmpCaMainController.topologieKlasse.Haenger);
							Bauteil		= tmpCaMainController.topologieKlasse.Haenger.m_Ptyp;
							var Emass	= tmpCaMainController.topologieKlasse.Haenger.m_Pemass;
						}
						lGwstGesch	-= Emass;
						aCaddata.push({
										objnr		: BT,
										posstrang	: BT,
										hlevel		: "88",
										emass		: Emass
									});
						var TempAnz	= (isDoppelt ? '2' : '1');
						TempAnz		= (left(Bauteil, 3) == "FDT" ? '1' : TempAnz);
						aPartslist.push({
										 posnr	: BT,
										 anz	: TempAnz,
										 typ	: Bauteil.replace(" ", ""),
										 matnr	: ''
										});
					}
					break;
				
				case "LKL/LSL/LVL/LVS/LXL"	:	// Einzelnes Lager
				case "LKL/LSL/LVL/LVS"		:
				case "LXL"					:
				case "LKF/LSF"				:
				case "LXF"					:
				case "FLN/FVN/FSN/FSD"		:	// Festlager
				case "LG"					:	// Lager in Lastkette
					var WstNr		= Werkstoffe[WerknamenDB[(WstSelect.replace(" ", ""))]];
					var NHmin		= Daemmdicke*1 + 10;
					// zuerst die relevante Baureihe bestimmen
					if (Bauteil != "LG"){
						var LGBasetype	= FinDefaults.IDC_LAGER_BASETYP_IST.split("_");
						// prfen ob das gewnschte Lager geht
						var strSQL		= "select * from WERKSTOFF_KOMBI where LAGER_KOMBI='LAGER_" + LGBasetype[1] + "' and abs(WERKSTOFF)=" + WstNr + " ";
						var NumRet		= dbselect( "LAGER2", strSQL, "WSTKombi" );
						if (NumRet < 1)			// Wechsel auf Stahl-Stahl
							LGBasetype[1]	= "SSG";
						// wir brauchen noch die gewnschte Mindestnennhhe
						switch (LGBasetype[1]){
							case "SPG"	:
								if (WstNr == 37)
									var NH	= right(FinDefaults.IDC_NENNHOEHE_RST_SPG_COMBO, 3)*1;
								else
									var NH	= right(FinDefaults.IDC_NENNHOEHE_SON_SPG_COMBO, 3)*1;
								break;
							case "SSG"	:
								if (WstNr == 37)
									var NH	= right(FinDefaults.IDC_NENNHOEHE_RST_SSG_COMBO, 3)*1;
								else
									var NH	= right(FinDefaults.IDC_NENNHOEHE_SON_SSG_COMBO, 3)*1;
								break;
							case "EPG"	:
								if (WstNr == 37)
									var NH	= right(FinDefaults.IDC_NENNHOEHE_RST_EPG_COMBO, 3)*1;
								else
									var NH	= right(FinDefaults.IDC_NENNHOEHE_SON_EPG_COMBO, 3)*1;
								break;
							default		:	// just to be sure
								var NH	= 150;
								break;
						}
						// prfen ob die Vorgabe ausreichend ist
						if (RHTyp_Info[3] == "FL" || RHTyp_Info[3] == "FP")
							NHmin	+= 20;	// "10" wurden oben bereits addiert
						if (NHmin > NH){
							NH	= NHmin;
							Message	+= "Preselected nominal height not possible!"
						}
						// wir brauchen noch einen Kenner fr Hhenverstellbar und ggf. weitere
						var strIsHV		= "false";
						if (TempMedium*1 > 320 && strIsHV == "true")	// da gibt es keine
							strIsHV	= "false";
						// die Festlager sind Typ "FS" und die Abfrage ist anders
						var FPTypVarianten	= false;
						var LoopsToDo		= 0;
						if (RHTyp_Info[3] == "FP"){
							LGBasetype[1]	= "FS";
							var strSQL		= "select * from AUSLEGUNG_GLEIT_FEST_LAGER where LAGER_TYP='LAGER_" + LGBasetype[1] + "'and VORISOLIERT='false' and HOEHENVERSTELLBAR='" + strIsHV + "' ";
							// Achtung -> hier sind mehrere Baureihen mglich
							var FPTypVarianten	= [];
							dbselect( "LAGER2", strSQL, "LGTyp" );
							while ( dbiseof( "LGTyp") == 0 ){
								FPTypVarianten.push(dbgetstring("LGTyp", "LAGERREIHE"));
								dbskip( "LGTyp" );
							}
							var Lagerreihe	= FPTypVarianten[0];
							LoopsToDo		= FPTypVarianten.length - 1;
						}
						else{
							var strSQL		= "select * from AUSLEGUNG_GLEIT_FEST_LAGER where LAGER_TYP='LAGER_" + LGBasetype[1] + "'and LAGERART='" + RHTyp_Info[1] + "' and GLEITUNTERLAGE='false' and VORISOLIERT='false' and HOEHENVERSTELLBAR='" + strIsHV + "' ";
							dbselect( "LAGER2", strSQL, "LGTyp" );
							var Lagerreihe	= dbgetstring("LGTyp", "LAGERREIHE");
							Lagerreihe		= Lagerreihe.split("/");
							Lagerreihe		= left(Lagerreihe[0], 3);
						}
					}
					else{
						var NH	= max(NHmin, 85);	// niedrige Bauform nicht zulassen
						var Lagerreihe	= "LSL";
						if (RHTyp_Info[1] != "HAENGEND"){
							if (PassenderHaenger*1 != 0 && left(PassenderHaenger.IDC_GRUNDTYP, 1) == "F"){
								var TypStuetze	= FinDefaults.IDC_STUETZE_TYP_FS_IST.split("_");
								if (TypStuetze[1] == "FSP")
									Lagerreihe	= "LXL";
							}
							else if (PassenderHaenger*1 != 0){
								var TypStuetze	= FinDefaults.IDC_STUETZE_TYP_KS_IST.split("_");
								if (TypStuetze[1] == "KSP")
									Lagerreihe	= "LXL";
							}
						}
					}
					// min. NH prfen
					if (Lagerreihe == "LXL" && WstNr == 37 && TempMedium > 210)
						NH	= max(NH, 143);
					else if (Lagerreihe == "LXL" && WstNr == 16 && TempMedium > 370)
						NH	= max(NH, 203);
					else if (TempMedium > 320)
						NH	= max(NH, TempMedium / 3);
					// bestimme die Defaultoberflche
					if (WstNr == 37)	// alle RST
						var strObfl	= Oberflaechenschutz[getstring("OBFL_SCHEL1", "PROJECT.SETTINGS.CASCADE")];
					else if (WstNr <= 16 || WstNr >= 91)	// alle Warmfesten
						var strObfl	= Oberflaechenschutz[getstring("OBFL_SCHEL3", "PROJECT.SETTINGS.CASCADE")];
					else	// alle VA
						var strObfl	= Oberflaechenschutz[getstring("OBFL_SCHEL4", "PROJECT.SETTINGS.CASCADE")];
					// der WST muss vorbelegt sein
					setstring("strSelRadioWerkstoff", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteRohrUmTeil", "LAGER_" + WerknamenDB[(WstSelect.replace(" ", ""))]);
					// die Oberflche muss vorbelegt sein
					setstring("strSelComboGroundLevel", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.AuswahlStandard", strObfl);
					var Success	= false;
					for (var BAU_F = 21; BAU_F <= 24; BAU_F++){
						// bei Mehrfachfhrungen ist der Typ ggf. anders
						var BAU_F_Count	= BAU_F;
						if (RHTyp_Info[3] == "QS"){
							BAU_F	= "" + left(right(RHTyp_Info[1], 2), 1) + right(BAU_F, 1) + "";
							BAU_F	= (BAU_F*1 > 90 ? BAU_F*1 - 30 : BAU_F*1);
						}
						// aData bestimmen
						var strSQL	= "select * from " + Lagerreihe + " where BAU_F='" + (BAU_F < 10 ? '0' : '') + BAU_F + "' and abs(DN)=" + Nennweite + " and abs(NH)>=" + NH + " and Werkstoff=" + WstNr + " ";
						var DBData 	= Lager.Search.getSearchResultData('LAGER2',strSQL);
						// rcksetzen
						BAU_F		= BAU_F_Count;
						for (var LGVarianten = 0; LGVarianten < DBData.length; LGVarianten++){
							var oLGRet	= {};
							if (LGBasetype[1] != "FS")	// Lager auf Sttze - etwas breiter whlen
								if (Bauteil == "LG" && !isDoppelt){
									if ((DBData[LGVarianten].D*1 <= 88.9 && DBData[LGVarianten].A*1 < 100 && DBData[LGVarianten].WERKSTOFF*1 == 37) ||
										(DBData[LGVarianten].D*1 >= 219.1 && DBData[LGVarianten].A*1 <= 100))
											//DBData[LGVarianten].strError = "Pipe shoe at support - more width needed";
											oLGRet.bOk =	0;
									else
										oLGRet =	Lager.Search.TestAndModify_Gleitlager(Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN" ), DBData[LGVarianten], "eFIN");
								}
								else
									oLGRet =	Lager.Search.TestAndModify_Gleitlager(Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN" ), DBData[LGVarianten], "eFIN");
							else{
								// Bewegungen!?
								var oBewegungMinus	= Object.fromStorage('DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteHalterungspunkt.oTable.bewegung_minus');
								var oBewegungPlus	= Object.fromStorage('DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.SollwerteHalterungspunkt.oTable.bewegung_plus');
								var BewGrenzwert	= DBData[LGVarianten].W_AXIAL;	// fr die FP Axial/Quer identisch
								if (max(abs(oBewegungMinus.axial) + abs(oBewegungPlus.axial),
										abs(oBewegungMinus.quer) + abs(oBewegungPlus.quer),
										abs(oBewegungMinus.schief) + abs(oBewegungPlus.schief)) > BewGrenzwert){
									setstring("rh_typ", posPath + ".FINOBJECT.assembly", "FL");
									PreMessage = "Position defined as fix point - but min. one total movement (axial/lateral/lift-off) is more than " + BewGrenzwert + "mm\n"
													+ "Type changed to guided support!";
									return {bAgain : true, isWarning : true, Warning : PreMessage };
								}
								// Problem Temperatur > 450C fhrt hier noch nicht zum Abbruch - klemmbar ist hier noch nicht gesetzt
								if (TempMedium > 450 && BAU_F >= 20)
									//DBData[LGVarianten].strError = "Clamping System not possible!"
									oLGRet.bOk =	0;
								else
									oLGRet =	Lager.Search.TestAndModify_Festlager(Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN" ), DBData[LGVarianten], "eFIN");
							}
							//var TEST	= typeof(DBData[LGVarianten].strError);
							//if (DBData[LGVarianten].strError == "" || typeof(DBData[LGVarianten].strError) == 'undefined'){	// alles ist gut -> nicht weitersuchen
							if (oLGRet.bOk){
								ZLastBT		+= DBData[LGVarianten].GEW;
								lGwstGesch	+= (DBData[LGVarianten].E*1);
								aCaddata.push({
									objnr		: BT,
									posstrang	: BT,
									hlevel		: "88",
									emass		: DBData[LGVarianten].E;
								});
								var TypLG	= DBData[LGVarianten].TYP.replace(" ", "");
								if (LGBasetype[1] == "FS" && left(DBData[LGVarianten].TYP, 2) != "FS")	// Festlager klemmbar
									TypLG	= TypLG.replace("XXX", FinDefaults.IDC_SUBTYP_TRAEGER_LAGER_COMBO);
								aPartslist.push({
									posnr	: BT,
									anz		: '1',
									//typ		: (DBData[LGVarianten].TYP.replace(" ", "")).replace("XXX", FinDefaults.IDC_SUBTYP_TRAEGER_LAGER_COMBO),
									typ		: TypLG,
									matnr	: ''
								});
								BAU_F		= 25;
								LGVarianten	= DBData.length;
								
								setstring("strSelComboBeamArt", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.AuswahlStandard", FinDefaults.IDC_TYP_TRAEGER_LAGER_COMBO);
								setstring("strSelComboBeamSize", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.AuswahlStandard", FinDefaults.IDC_SUBTYP_TRAEGER_LAGER_COMBO);
								setstring("strSelRadioFixed", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.AuswahlStandard", left(DBData[LGVarianten].TYP, 2) == "FS" ? "SCHRAUBBAR" : "KLEMMBAR");
								
								Success		= true;
							}
						}
						// ggf. noch die schraubbaren Festlager prfen
						if (BAU_F == 24 && LoopsToDo > 0){	// wir haben keinen klemmbaren Festpunkt gefunden, haben aber noch weitere Optionen
							BAU_F			= 0;	// wird oben hochgezhlt
							Lagerreihe		= FPTypVarianten[FPTypVarianten.length - LoopsToDo];
							LoopsToDo		-= 1;
						}
						if (BAU_F == 2){	// das ist die grtmgliche Variante (FSx 02) -> aber kein Treffer
							if (LoopsToDo > 0){
								BAU_F			= 1;
								Lagerreihe		= FPTypVarianten[FPTypVarianten.length - LoopsToDo];
								LoopsToDo		-= 1;
							}
							else
								BAU_F	= 25;	// nichts geht mehr
						}
					}
					if (!Success){	// Abbruch Versuch
						BT		= AnzBT + 1;
						Message	+= (Message != "" ? "\n" : "") + "No selection of clamp possible!";
					}
					break;
				case "KZT/KZU/KZL"	:
					// bestimme den Basistyp -> T/U/L
					var BaseTypeKlemm	= left(FinDefaults.IDC_TYP_TRAEGER_LAGER_COMBO, 1);
					var SubTypeKlemm	= FinDefaults.IDC_SUBTYP_TRAEGER_LAGER_COMBO;
					var KSY_BAU_F		= (LGBasetype[1] == "SPG" ? "20" : "15");
					if ((BaseTypeKlemm == "U") || (BaseTypeKlemm == "L"))
						Bauteil	= "KZ" + BaseTypeKlemm;
					else{
						Bauteil			= "KZT"
						BaseTypeKlemm	= "T";
					}
					// wir brauchen noch die Trgerbreite bzw. die Abmessungen vom L- bzw. U-Profil
					var Success		= true;
					var SQLTraeger	= "select * from " + FinDefaults.IDC_TYP_TRAEGER_LAGER_COMBO + " where abs(TRAE_GR)=" + FinDefaults.IDC_SUBTYP_TRAEGER_LAGER_COMBO + " ";
					var NumRet		= dbselect( "LAGER2", SQLTraeger, "TRAEGER" );
					if (NumRet < 1)
						Success	= false;
					else{
						var Traegerbreite	= "-";
						if (BaseTypeKlemm == "T" && dbgetdouble("TRAEGER", "B") <= 140)
							Traegerbreite	= "140";
						BaseTypeKlemm	= dbgetstring("TRAEGER", "VAR_KLEMM");
					}
					setstring("strSelComboBeamArt", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.AuswahlStandard", FinDefaults.IDC_TYP_TRAEGER_LAGER_COMBO);
					setstring("strSelComboBeamSize", "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN.AuswahlStandard", FinDefaults.IDC_SUBTYP_TRAEGER_LAGER_COMBO);
					// Test der mglichen KSY
					var strSQL	= "SELECT * FROM 'KXX' WHERE  TYP like '" + Bauteil + " " + KSY_BAU_F + "%' AND TRAEGERBREITE = '" + Traegerbreite + "' ";
					var DBData	= Klemmsystem.Search.getSearchResultData('LAGER2',strSQL);
					for (KSYVarianten = 0; KSYVarianten < DBData.length; KSYVarianten++){
							var oReturn	= Base.TestAndModify(Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN" ), DBData[0], 1);
							if (oReturn.bOk)	// alles gut
								KSYVarianten	= DBData.length;
					}
					if (!oReturn.bOk){
						Success	= false;
						Message	+= (Message != "" ? "\n" : "") + oReturn.strError;
					}
					
					if (!Success)	// Abbruch Versuch
						BT	= AnzBT + 1;
					else{
						Bauteil	+= " " + KSY_BAU_F + "-" + BaseTypeKlemm;
						aCaddata.push({
							objnr		: BT,
							posstrang	: BT,
							hlevel		: "88",
							emass		: "0";
						});
						aPartslist.push({
							posnr	: BT,
							anz		: '1',
							typ		: Bauteil,
							matnr	: ''
						});
					}
					break;
				case "STAUFF"	:
					var SQLTraeger	= "select * from SPAL where D=" + RohraussenDmr + " ";
					var NumRet		= dbselect( "CASCADE", SQLTraeger, "SPAL" );
					if (!NumRet)
						BT	= AnzBT + 1;
					else{
						Bauteil	= "SPAL " + dbgetstring("SPAL", "TypNr");
						aCaddata.push({
							objnr		: BT,
							posstrang	: BT,
							hlevel		: "88",
							emass		: "0";
						});
						aPartslist.push({
							posnr	: BT,
							anz		: '1',
							typ		: Bauteil,
							matnr	: ''
						});
					}
					break;
				case "MBW"		:
				case "MBW_3"	:
				case "MBW_0"	:
					var Success	= (LGG != "" ? true : false);	// LGG prfen!!!
					if (Success){
						var MasseSplit	= tmpCaMainController.topologieKlasse.Haenger.m_strMasse.split(" ");
						var FN_Bock		= 0;
						for (var Mass = 0; Mass < MasseSplit.length; Mass++){
							if (MasseSplit[Mass] == "FN_BOCK"){
								FN_Bock	= MasseSplit[Mass+1];
								Mass	= MasseSplit.length;
							}
						}
						if (FN_Bock*1 < 10)
							FN_Bock	= "000" + FN_Bock;
						else if (FN_Bock*1 < 100)
							FN_Bock	= "00" + FN_Bock;
						else if (FN_Bock*1 < 1000)
							FN_Bock	= "0" + FN_Bock;
						else
							FN_Bock	= "" + FN_Bock;
						var BockObfl	= (rfind(Bauteil, "_") > -1 ? right(Bauteil, 1)*1 : 3);
						Bauteil	= left(Bauteil, 3) + " " + FN_Bock + "-" + BockObfl;
						aCaddata.push({
							objnr		: BT,
							posstrang	: BT,
							hlevel		: "88",
							emass		: "0";
						});
						aPartslist.push({
							posnr	: BT,
							anz		: '1',
							typ		: Bauteil,
							matnr	: ''
						});
					}
					break;
				case "MBS"	:
					var Success	= (LGG != "" ? true : false);	// LGG prfen!!!
					if (Success){
						if (LGG*1 < 10)
							LGG = "00" + LGG*1;
						else if (LGG*1 < 100)
							LGG	= "0" + LGG*1;
						Bauteil	= Bauteil + " " + LGG + "-3";
						aCaddata.push({
							objnr		: BT,
							posstrang	: BT,
							hlevel		: "88",
							emass		: "0";
						});
						aPartslist.push({
							posnr	: BT,
							anz		: '1',
							typ		: Bauteil,
							matnr	: ''
						});
					}
					break;
				case "SSG"	:
				case "SSB"	:
					if (typeof(tmpCaMainController.topologieKlasse.Haenger) != 'object')	// wir knnen diesen Versuch abbrechen
						BT	= AnzBT + 1;
					else{
						StueLi.push(tmpCaMainController.topologieKlasse.Haenger);
						Bauteil	= tmpCaMainController.topologieKlasse.Haenger.m_Ptyp;
						aCaddata.push({
									objnr		: BT,
									posstrang	: BT,
									hlevel		: "88",
									emass		: tmpCaMainController.topologieKlasse.Haenger.m_Pemass
									});
						aPartslist.push({
										posnr	: BT,
										anz		: isDoppelt ? '2' : '1',
										typ		: Bauteil.replace(" ", ""),
										matnr	: ''
										});
					}
					break;
				default		:
					BT	= AnzBT + 1;
					break;
			}
			if (BT > AnzBT)
				MacheWeiter	= 1;	// das passiert sobald ein Teil nicht ausgelegt werden konnte
			else
				MacheWeiter	= 0;
		}
		dbskip( "IMPORT" );
		
		if (!MacheWeiter && PassenderHaenger != 0 && ZLastBT != 0 && LoopsHanger > 0){	// FH/KH und FS/KS
			if (isHaengend)
				ZLastBT	+= (isDoppelt ? 2 : 1) * lGwstGesch * LGV / 5000;
			var KleinerMgl	= false;
			var SRateSoll	= getFinDataValue(Object.fromStorage( "DLGDATA.CA.FINDATA.FINOBJECT" ), "assembly", "springrate_g")*1 / (isDoppelt ? 2 : 1);
			SRateSoll		= (SRateSoll == 0 ? PassenderHaenger.IDC_FEDERRATE*1 : SRateSoll);
			if (ZLastBT < ZLast*100 &&
				left(PassenderHaenger.IDC_GRUNDTYP, 1) == "F" &&
				PassenderHaenger.IDC_FEDERRATE*1 != SRateSoll &&
				LoopsHanger > 2)
					KleinerMgl	= true;
			setstring("Z_LAST_EG", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT", fround(ZLastBT / 100, 2));
			if (!tmpCaMainController.recalcHaenger(getstring("SollastHpkt", newHanger.Path)*1, fround(ZLastBT / 100, 2), "eFIN") || KleinerMgl){
				newHanger			= getHanger(RHTyp_Info, tmpCaMainController, FinDefaults, isDoppelt, isHorizontal, PreMessage, Message, false);
				PassenderHaenger	= newHanger.Hanger;
				LGV					= PassenderHaenger.lgv;
				HangerPath			= newHanger.Path;
				PreMessage			= newHanger.PreMessage;
				LoopsHanger			-= 1;
				MacheWeiter			= true;
				strSQL	= getSQLCombination(RHTyp_Info, isDoppelt, isHorizontal, isSchelle, isVAGP, newHanger.SQL);
				NumLKCombination	= dbselect( "CASCADE", strSQL, "IMPORT" );
				dbgotop( "IMPORT" );
			}
			if (lGwstGesch < 8.5*LGV && PassenderHaenger != 0){
				newHanger			= getHanger(RHTyp_Info, tmpCaMainController, FinDefaults, isDoppelt, isHorizontal, PreMessage, Message, true);
				if (newHanger.Hanger.IDC_NENNWEG*1 < PassenderHaenger.IDC_NENNWEG*1){
					PassenderHaenger	= newHanger.Hanger;
					LGV					= PassenderHaenger.lgv;
					HangerPath			= newHanger.Path;
					PreMessage			= newHanger.PreMessage;
					LoopsHanger			-= 1;
					MacheWeiter			= true;
					strSQL	= getSQLCombination(RHTyp_Info, isDoppelt, isHorizontal, isSchelle, isVAGP, newHanger.SQL);
					NumLKCombination	= dbselect( "CASCADE", strSQL, "IMPORT" );
					dbgotop( "IMPORT" );
				}
				else{
					PreMessage	+= (PreMessage != "" ? "\n" : "") + "Check system elevations!";
				}
			}
		}
		else if (!MacheWeiter && ZLastBT != 0 && LoopsHanger > 0 && rh_typ == "SH"){	// starre Haenger
			setstring("Z_LAST_EG", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT", fround(ZLastBT / 100, 2));
			var F_HP	= getdouble("PLAIN_ARRAY_ITEM_VALUE", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_minus["+ AchsKSInfo[6] +"]");
			if (!tmpCaMainController.recalcHaenger(F_HP, fround(ZLastBT / 100, 2), "eFIN")){
				LoopsHanger			-= 1;
				MacheWeiter			= true;
				LGV					= tmpCaMainController.GetLGVfromLast();
				strSQL	= getSQLCombination(RHTyp_Info, isDoppelt, isHorizontal, isSchelle, isVAGP, "");
				NumLKCombination	= dbselect( "CASCADE", strSQL, "IMPORT" );
				dbgotop( "IMPORT" );
			}
		}
		else if (dbiseof( "IMPORT" ) < 0 && MacheWeiter && WstPossible.aEnabled.length > 1 && WstPossible.aEnabled[WstPossible.aEnabled.length - 1] != WstSelect){
			// findInArray(value, myArray)
			WstSelect	= WstPossible.aEnabled[findInArray(WstSelect, WstPossible.aEnabled) + 1];
			dbgotop( "IMPORT" );
		}
	}
	
	if (!MacheWeiter){
		caddata['aCaddata']		= aCaddata;
		partslist['aPartslist']	= aPartslist;
		caddata.toStorage(posPath + "FINOBJECT.caddata", false);	// kein merge
		partslist.toStorage(posPath + "FINOBJECT.partslist", false);	// kein merge
	}
	
	var Warning	= PreMessage;
	Warning		+= (Warning != "" ? "\n" : "") + Message;
	Warning		+= (Message != "" ? "\n" : "");
	/*
	Message		= (!MacheWeiter ? "Import with default values!" : "No selection with default values possible!")
					+ (Warning != "" ? "\n" + Warning : "\n");
	*/
	//return {bOK : !MacheWeiter, Message : Message, isWarning : (Warning != "" ? true : false), Warning : Warning};
	return {bOK : !MacheWeiter, isWarning : (Warning != "" ? true : false), Warning : Warning, bAgain : false};
}

function get_verti_dir_def(int_vertikaldir_up)
{
	// (1)-"X AUF"; (-1)-"X AB"; (2)-"Y AUF"; (-2)-"Y AB"; (3)-"Z AUF"; (-3)-"Z AB"
	var verti_info	= [];
	if (int_vertikaldir_up >= 0)
		verti_info[1]	= 'AUF';
	else
		verti_info[1]	= 'AB';
	switch (int_vertikaldir_up){
		case 1  :
		case -1 :
			verti_info[2]	= 'X';	// vertikale
			verti_info[3]	= 'Z';	// N-S-Richtung
			verti_info[4]	= 'Y';	// E-W-Richtung
			break;
		case 2  :
		case -2 :
			verti_info[2]	= 'Y';
			verti_info[3]	= 'X';
			verti_info[4]	= 'Z';
			break;
		case 3  :
		case -3 :
		default :
			verti_info[2]	= 'Z';
			verti_info[3]	= 'Y';
			verti_info[4]	= 'X';
			break;
	}
	return verti_info;
}

function get_Vektor_HHV(strVektor, vertikaldir) // horizontal - horizontal - vertikal
{
	var Vektor_HHV	= [];
	switch (vertikaldir){
		case 'X' :
			Vektor_HHV[2]	= strVektor[0];
			Vektor_HHV[1]	= strVektor[1];
			Vektor_HHV[0]	= strVektor[2];
			break;
		case 'Y' :
			Vektor_HHV[2]	= strVektor[1];
			Vektor_HHV[1]	= strVektor[2];
			Vektor_HHV[0]	= strVektor[0];
			break;
		case 'Z' :
		default  :
			Vektor_HHV[2]	= strVektor[2];
			Vektor_HHV[1]	= strVektor[0];
			Vektor_HHV[0]	= strVektor[1];
			break;
	}
	return Vektor_HHV;
}

function getTypHL(rh_typ)
{
	var ret	= [];
	switch (rh_typ){
		case "SH":
			ret[0]	= "STARR";
			ret[1]	= "HAENGEND";
			ret[2]	= "";
			ret[3]	= "SH";
			break;
		case "ST":
		case "GL":
		case "LL":
			ret[0]	= "LAGER2011";
			ret[1]	= "LOSLAGER";
			ret[2]	= "";
			ret[3]	= "GL";
			break;
		case "AX":
		case "FP":
			ret[0]	= "LAGER2011";
			ret[1]	= "FESTLAGER";
			ret[2]	= "";
			ret[3]	= "FP";
			break;
		case "FL":
			ret[0]	= "LAGER2011";
			ret[1]	= "FUEHRUNGSLAGER";
			ret[2]	= "";
			ret[3]	= "FL";
			break;
		case "QS":
		case "QSV":
		case "QSVX":
		case "QSVY":
		case "QSVZ":
			ret[0]	= "LAGER2011";
			ret[1]	= "FUEHRUNG_2W";
			ret[2]	= "";
			ret[3]	= "QS";
			break;
		case "2W":
		case "2W_90":
		case "3W":
		case "4W":
			ret[0]	= "LAGER2011";
			ret[1]	= "FUEHRUNG_" + rh_typ;
			ret[2]	= "";
			ret[3]	= "QS";
			break;
		case "FH":
		case "KH":
			ret[0]	= "BEWEGLICH";
			ret[1]	= "HAENGEND";
			ret[2]	= rh_typ;
			ret[3]	= rh_typ;
			break;
		case "FGL":
		case "FS":
		case "FF":
		case "FFL":
			ret[0]	= "BEWEGLICH";
			ret[1]	= "STUETZEND";
			ret[2]	= "FS";
			ret[3]	= "FS";
			break;
		case "KGL":
		case "KS":
		case "KF":
		case "KFL":
		case "KFLAX":
		case "KFLVX":
		case "KFLVY":
		case "KFLVZ":
		case "KFLVXY":
		case "KFLVXZ":
		case "KFLVYZ":
			ret[0]	= "BEWEGLICH";
			ret[1]	= "STUETZEND";
			ret[2]	= "KS";
			ret[3]	= "KS";
			break;
		case "GS":	// default fr normales FIN und bOTHEReFIN
		case "GS_H":	// WI-eFIN HAENGEND
			ret[0]	= "GELENKSTREBE";
			ret[1]	= "HAENGEND";
			ret[2]	= "GS";
			ret[3]	= "GS";
			break;
		case "GS_S":	// WI-eFIN STUETZEND
			ret[0]	= "GELENKSTREBE";
			ret[1]	= "STUETZEND";
			ret[2]	= "GS";
			ret[3]	= "GS";
			break;
		case "FGS":	// default fr normales FIN und bOTHEReFIN
		case "KGS":
			ret[0]	= "GELENKSTUETZE";
			ret[1]	= "STUETZEND";
			ret[2]	= "";
			ret[3]	= "FGS";
			break;
		case "FGS_H":
		case "KGS_H":
			ret[0]	= "GELENKSTUETZE";
			ret[1]	= "HAENGEND";
			ret[2]	= "";
			ret[3]	= "FGS";
			break;
		case "FGS_S":
		case "KGS_S":
			ret[0]	= "GELENKSTUETZE";
			ret[1]	= "STUETZEND";
			ret[2]	= "";
			ret[3]	= "FGS";
			break;
		case "DP":
		case "DB":
		case "DP_H":
		case "DB_H":
			ret[0]	= "STOSSBREMSE";
			ret[1]	= "HAENGEND";
			ret[2]	= "SB";
			ret[3]	= "DP";
			break;
		case "DP_S":
		case "DB_S":
			ret[0]	= "STOSSBREMSE";
			ret[1]	= "STUETZEND";
			ret[2]	= "SB";
			ret[3]	= "DP";
			break;
		case "SC":
			ret[0]	= "FREIEPOSITION";
			ret[1]	= "STAUFF";
			ret[2]	= "";
			ret[3]	= "SC";
			break;
		case "AC":
			ret[0]	= "EINZEL_SCHELLE";
			ret[1]	= "HAENGEND";
			ret[2]	= "";
			ret[3]	= "AC";
			break;
		case "FREE":
			ret[0]	= "FREIEPOSITION";
			ret[1]	= "FREITEXT";
			ret[2]	= "";
			ret[3]	= "";
			break;
		case "SC_LK":
			ret[0]	= "EINZEL_ZUBEHOER";
			ret[1]	= "STAUFF_LK";
			ret[2]	= "";
			ret[3]	= "";
			break;
		case "FREE_LK":
			ret[0]	= "EINZEL_ZUBEHOER";
			ret[1]	= "FREITEXT_LK";
			ret[2]	= "";
			ret[3]	= "";
			break;
		default :
			ret[0]	= "BEWEGLICH";
			ret[1]	= "HAENGEND";
			ret[2]	= "";
			ret[3]	= "";
			break;
	}
	return ret;
}

function isBauteilSpannweite (Typ)
{
	var oRet	= {	isBTmSPW	: false,
					SPW			: -1 };
	var isSpecial	= (rfind("-S", Typ) > -1 ? true : false);
	if (isSpecial){
		var TypSonderSplit	= splitVarDelimiter(strTyp, "-S.");	// -> Array mit Lnge 3
		if (TypSonderSplit[1].length > 4)
			TypSonderSplit[1]	= right(TypSonderSplit[1], TypSonderSplit[1].length - 1);
		Typ	= TypSonderSplit[0] + TypSonderSplit[1] + "." + TypSonderSplit[3];
		
	}
	var TypSplit	= Typ.split(".");
	var TypID		= left(Typ, 3);
	if ((TypID == "FDT" || TypID == "VBK" || TypID == "VKR" || TypID == "VKK" || TypID == "VSR" ||
		 TypID == "VPR" || TypID == "VGR") && (TypSplit[2] * 1 > 0)){
		
		oRet.isBTmSPW	= true;
		oRet.SPW		= TypSplit[2] * 1;
	}
	else if (TypID == "ZTN"){
		TypSplit		= splitVarDelimiter(Typ, ".-");
		if (TypSplit[1] * 1 > 0){
			oRet.isBTmSPW	= true;
			oRet.SPW		= TypSplit[1] * 1;
		}
	}
	
	return oRet;
}

function isSonderSpannweite(spannweite)
{
	var RetObj		=	{SonderSpw	: false,
						 NextSpw	: spannweite};
	var spannweiten = [
                        300, 
                        400, 
                        500, 
                        600, 
                        800, 
                        1000,
                        1200,
                        1400,
                        1600,
                        1800,
                        2000,
                        2200,
                        2400
                    ]
	/*
	if (findInArray(spannweite, spannweiten) < 0)
		return true;
	else
		return false;
	*/
	if (findInArray(spannweite, spannweiten) < 0){
		RetObj.SonderSpw	= true;
		for (var spw = 0; spw < spannweiten.length; spw++){
			if (spannweiten[spw] > spannweite){
				RetObj.NextSpw	= spannweiten[spw];
				spw				= spannweiten.length;
			}
		}
	}
	
	return RetObj;
}

function isSonderDA(DA)
{
	var DA_NORM =  [
						21.3,
						26.9,
						33.7,
						42.4,
						48.3,
						60.3,
						76.1,
						88.9,
						114.3,
						139.7,
						168.3,
						219.1,
						273,
						323.9,
						355.6,
						406.4,
						457,
						508,
						559,
						610,
						711,
						813,
						863,
						914,
						1016,
						1120,
						1220
					]
	if (findInArray(DA, DA_NORM) < 0)
		return true;
	else
		return false;
}