/**
 * Session Object, alle gesetzten Werte, werden in diesen Object hinterlegt.
 * - bei Dialogen mit Such-Tabellen, wird der Selectierte Datensatz immer in oSearchResult hinterlegt
 * - kommt in einen Unterobject die Variable "strDialogId" vor, wird der Dialog fr mehrere Auslegungen verwendet, in dem Fall muss die Variable zuvor bestimmt werden,
 *   dieses geschieht in der Regel im Initial Zustand des Dialoges (an erster Stelle)
 * @constructor
 */
LagerObject = function()
{
	this.DialogHistoryIDs			= new Array(); 									//welche Dialoge wurden durchlaufen, Hier stehen die ID's mit denen auch die Texte im History Panel gefllt werden
	this.bLastKetteDialog			= false; 										//dient als Marker, der Wert ist solange false, bis der Dialog bersicht LastKette erreicht ist. Von da an wird er nur gendert
	this.bLastKettePathSelection 	= false;																		//wenn sich in den Dialogen zuvor etwas ndert
	
	//Daten fr den Dialog Systemcharakteristik
	this.Systemcharakteristik 	= {};
	this.Systemcharakteristik.oLastKettenPath 			= {};
	this.Systemcharakteristik.strSelRadioLager 			= 'LAGER_SPG';
	this.Systemcharakteristik.strSelRadioRohrverlauf 	= 'LAGER_HORIZONTAL';
	this.Systemcharakteristik.strSelRadioRohrichtung 	= 'LAGER_X_ACHSE';
	this.Systemcharakteristik.strSelZubehoerComboLager 	= 'AzA';
	this.Systemcharakteristik.bSel_krT					= false;
	this.Systemcharakteristik.dAlpha					= 0;
	this.Systemcharakteristik.dBeta						= 0;
	
	//Daten fr den Dialog Sollwerte Haltepunkte
	this.SollwerteHalterungspunkt	= {};
	this.SollwerteHalterungspunkt.oTable	= {};
	this.SollwerteHalterungspunkt.strSelRadioSollast    = 'KALT';
	
	this.SollwerteRohrUmTeil		= {};
	this.SollwerteRohrUmTeil.dTemperaturMedium			= 25;
	this.SollwerteRohrUmTeil.dAussenDuMesserSonder		= 0;
	this.SollwerteRohrUmTeil.dMantelDuMesserSonder		= 0;
	this.SollwerteRohrUmTeil.dDaemmDicke				= 0;
	this.SollwerteRohrUmTeil.dSchelleneinlage			= 0;
	this.SollwerteRohrUmTeil.bUmgebungsTemperatur		= true;
	this.SollwerteRohrUmTeil.bAussenDuMesserSonder	    = false;	
	this.SollwerteRohrUmTeil.bMantelDuMesserSonder	    = false;
	this.SollwerteRohrUmTeil.strSelNennweiteCombo		= '150';
	this.SollwerteRohrUmTeil.strSelAussenDuMesserCombo	= '168.3';
	//this.SollwerteRohrUmTeil.strSelMantelDuMesserCombo	= '90';
	this.SollwerteRohrUmTeil.strSelMantelDuMesserCombo	= 'STD';
	this.SollwerteRohrUmTeil.strSelRadioWerkstoff		= 'LAGER_W_RST';
	
	this.AuswahlStandard								= {};	
	this.AuswahlStandard.oSearchResult					= {};
	this.AuswahlStandard.strResultId					= '';
	this.AuswahlStandard.strDialogId 					= '';
	this.AuswahlStandard.strSelRadioFunction			= "GEFUEHRT"; 			//GEFUEHRT_MEHRFACH / LOSE / GEFUEHRT
	// @@@ LGE TEST
	//this.AuswahlStandard.strSelRadioFunction			= "LOSE"; 			//GEFUEHRT_MEHRFACH / LOSE / GEFUEHRT
	this.AuswahlStandard.strSelRadioFixed				= "KLEMMBAR";			//KLEMMBAR / SCHRAUBBAR
	this.AuswahlStandard.strSelRadioFixedScrewOn		= "EINFACH";			//EINFACH  / DOPPELT  	
	this.AuswahlStandard.strSelComboFunction			= "FUEHRUNG_2W"; 		//FUEHRUNG_2W+ / FUEHRUNG_2W_90	/ FUEHRUNG_2W / FUEHRUNG_3W / FUEHRUNG_4W
	this.AuswahlStandard.strSelComboBeamArt				= "HEB";
	this.AuswahlStandard.strSelComboBeamSize			= "100 - 140";
	this.AuswahlStandard.strActualHeightRange			= '120-170';
	this.AuswahlStandard.strActualMassRange				= '374-424';
	//this.AuswahlStandard.strSelComboSlidingPart			= '-';					//OHNE / LGA / LGV / LGE
	// @@@ LGE TEST
	this.AuswahlStandard.strSelComboSlidingPart			= 'OHNE';					//OHNE / LGA / LGV / LGE
	//this.AuswahlStandard.strSelComboAccessory			= 'KLEMMBAR'; 			//KLEMMBAR / ABHEBESICHERUNG / GLEITELEMENT / -
	// @@@ LGE TEST
	this.AuswahlStandard.strSelComboAccessory			= 'OHNE';					//KLEMMBAR / ABHEBESICHERUNG / GLEITELEMENT / -
	this.AuswahlStandard.strSelComboGroundLevel			= '';					//Oberflaeche
	this.AuswahlStandard.bSonderAbMessung				= false;
	//this.AuswahlStandard.bSonderAbMessung_Laenge		= false;
	
	this.AuswahlStandard.bSonderAbMessung_Hoehe1		= true;
	this.AuswahlStandard.bSonderAbMessung_Hoehe2		= true;
	this.AuswahlStandard.bSonderAbMessung_Hoehe3		= true;
	this.AuswahlStandard.bSonderAbMessung_Hoehe4		= true;
	
	this.AuswahlStandard.bHoehenverstellbar				= false;
	this.AuswahlStandard.bGaT							= false; 		//Gleitunterlage am Trger
	this.AuswahlStandard.bBuegel						= false;		//Buegelausfuehrung
	
	// ----------------------------------------------------------------------------------------------------
	// Masze Lager mit Sonderabmessungen
	// Laenge
	this.AuswahlStandard.dLaenge						= 400;
	this.AuswahlStandard.dLaengeSonder					= 385;		// nicht in Combo
	this.AuswahlStandard.dLaengeSonderMin				= 0;
	this.AuswahlStandard.dLaengeSonderMax				= 0;
	// Breite
	this.AuswahlStandard.dBreite						= 120;
	this.AuswahlStandard.dBreiteSonder					= 125;		// nicht in Combo
	this.AuswahlStandard.dBreiteSonderMin				= 0;
	this.AuswahlStandard.dBreiteSonderMax				= 0;
	// Hoehe
	this.AuswahlStandard.dHoehe1						= 100;
	this.AuswahlStandard.dHoehe2						= 100;
	this.AuswahlStandard.dHoehe3						= 100;
	this.AuswahlStandard.dHoehe4						= 100;
	this.AuswahlStandard.dHoeheMin						= 0;
	this.AuswahlStandard.dHoeheMax						= 0;
	// E-Mass - wird anhand gewaehlten dA bestimmt
	this.AuswahlStandard.dMass1							= 0;
	this.AuswahlStandard.dMass2							= 0;
	this.AuswahlStandard.dMass3							= 0;
	this.AuswahlStandard.dMass4							= 0;
	this.AuswahlStandard.dMassMin						= 0;
	this.AuswahlStandard.dMassMax						= 0;
	// ----------------------------------------------------------------------------------------------------
	
	this.AuswahlStandard.dBeamHeight					= 140;
	this.AuswahlStandard.dBeamWidth						= 140;
	this.AuswahlStandard.dBeamThickness					= 12;
	this.AuswahlStandard.dActualHeight					= 150;
	this.AuswahlStandard.dActualMass					= 404;
	
	this.AuswahlSattel									= {};
	this.AuswahlSattel.oSearchResult					= {};
	this.AuswahlSattel.strResultId						= '';
	this.AuswahlSattel.strDialogId						= ''; //muss bestimmt werden - entweder SATTEL oder Rollenlager- Sattel = "ROLLENLAGER_SATTEL"
	this.AuswahlSattel.strRadioSurroundingPart			= 'SCHELLE_SCHELLE';
	this.AuswahlSattel.strRadioWeldEnd					= 'BIEGETEIL';
	this.AuswahlSattel.strSelComboLength				= '';
	this.AuswahlSattel.strSelComboGroundLevel			= '';
	this.AuswahlSattel.bRadioSurroundingPart			= true;
	this.AuswahlSattel.bRadioWeldEnd					= false;
	this.AuswahlSattel.bActuator						= false;
	this.AuswahlSattel.bUpliftRestraint					= false;
	this.AuswahlSattel.bSonderLayer						= false;
	this.AuswahlSattel.bSonderLength					= false;	
	this.AuswahlSattel.dSonderLayer						= 0;
	this.AuswahlSattel.dSonderLength					= 0;
	this.AuswahlSattel.dLayer							= 0;
	
	this.AuswahlRollenlagerDirekt = {};
	this.AuswahlRollenlagerDirekt.oSearchResult			= {};
	this.AuswahlRollenlagerDirekt.strResultId			= '';
	this.AuswahlRollenlagerDirekt.strRadio				= 'DZ_RL'; 		// DZ_RL / Z_RL / DK_RL / DZ_RL_SV / Z_RL_SV / DK_RL_SV
	this.AuswahlRollenlagerDirekt.strSelComboDZ_RL		= '';
	this.AuswahlRollenlagerDirekt.strSelComboZ_RL		= '';
	this.AuswahlRollenlagerDirekt.strSelComboDK_RL		= '';
	this.AuswahlRollenlagerDirekt.strSelComboDZ_RL_SV	= '';
	this.AuswahlRollenlagerDirekt.strSelComboZ_RL_SV	= '';
	this.AuswahlRollenlagerDirekt.strSelComboDK_RL_SV	= '';
	this.AuswahlRollenlagerDirekt.bCheck				= false;
	
	this.AuswahlRollenlager								= {};	
	this.AuswahlRollenlager.oSearchResult				= {};
	this.AuswahlRollenlager.strResultId					= '';
	this.AuswahlRollenlager.strDialogId					= ''; 			//ROLLENLAGER_P 	/ ROLLENLAGER_S / ROLLENLAGER_K / ROLLENLAGER_U_SATTEL
	this.AuswahlRollenlager.strSelRadioFunction			= 'KLEMMBAR'; 	//KLEMMBAR 		/ SCHRAUBBAR
	this.AuswahlRollenlager.strSelRadioWeldEnd			= 'ZWEIFACH'; 	//ZWEIFACH 		/ VIERFACH
	this.AuswahlRollenlager.strSelRadioRollerBearing	= 'LOSE';		//LOSE 			/ GEFUEHRT 
	this.AuswahlRollenlager.strSelRadioFixed			= 'OHNE';		//OHNE 			/ MIT				<-- ABHEBESICHERUNG fr LagerSystem
	this.AuswahlRollenlager.strSelComboTyp				= 'DOPPELZYLINDER';			//DOPPELZYLINDER / DOPPELKEGEL	/ ZYLINDER
	this.AuswahlRollenlager.strSelComboType				= '';						//DB TYP
	this.AuswahlRollenlager.strSelComboGroundLevel		= '';						//Oberflaeche
	this.AuswahlRollenlager.strSelComboMaterial			= '';						//Werkstoff
	this.AuswahlRollenlager.strSelRadioWerk				= 'St';						// Radio fr Werkstoff
	this.AuswahlRollenlager.dSattelOuterDiameter		= 0;
	this.AuswahlRollenlager.dSattelBearingDiameter		= 0;
	this.AuswahlRollenlager.dSattelLength				= 0;
	this.AuswahlRollenlager.dSupportDiameter			= 0;
	this.AuswahlRollenlager.dFeetWide					= 0;
	this.AuswahlRollenlager.bUpliftRestraint			= false;
	
	this.ZubehoerPTFE									= {};
	this.ZubehoerPTFE.oSearchResult						= {};
	this.ZubehoerPTFE.strSelComboTyp					= "LAW 10.24-37.3";
	this.ZubehoerPTFE.strSelComboSlidingPart			= "LGV";
	this.ZubehoerPTFE.strSelComboTempSlidingPart		= "90";
	this.ZubehoerPTFE.strSelComboDimensions				= "050.050";
	this.ZubehoerPTFE.bFieldSetCheckBox					= false;
	
	this.Klemmsystem									= {}; 
	this.Klemmsystem.oSearchResult						= {};
	this.Klemmsystem.strResultId						= '';
	this.Klemmsystem.strDialogId						= ''; 			//LAGERSYSTEM	/ ZUBEHOER
	this.Klemmsystem.strSelRadioFixed					= 'OHNE';		//OHNE 			/ MIT				<-- ABHEBESICHERUNG fr LagerSystem
	this.Klemmsystem.strSelComboFunction				= 'FUEHRUNGSLAGER';
	this.Klemmsystem.strSelComboWidthBaseOfTheSupport	= '80';
	this.Klemmsystem.bUpliftRestraint					= false;
	this.Klemmsystem.bUpliftRestraint4					= false;
	this.Klemmsystem.bGaT								= false;	
	this.Klemmsystem.dOtherWidthBaseOfTheSupport		= 0;
}

LagerObject.prototype = {
}