/**
 * gets the dialog object for a dialog. If none is present, a new one is created.
 * A dialog objet is used to transfer dialog variables in the controller for a specific configuration dialog 
 * to the product logic. It contains those variables that must be transfered from the user input to the product or product configuration object, if the
 * user accepts his new selection (and that must be discarded if the user rejects the selection). Properties of dialog objects must be named exactly the
 * same as the corresponding property of the product or product configuration object.
 *
 * @param strDialog - dialog id
 *
 * @return object - dialog object for the dialog
 *
 * @throws EasyKat.Exception in case no dialog object was present and none could be created
 */

function getDialogObjectSession(strDialog){
	var base = _session();
	if(!base.oDialogObjects )	// lazy initialisation for startup
		base.oDialogObjects = {};
	
	if (strDialog == 'LAGER') {
		//var test = caMainController.getLagerTopologieklasse();
		if (caMainController.getLagerTopologieklasse()){
			return caMainController.getLagerTopologieklasse().getDlgLagerSession();	
		}
		return caMainController.topologieKlasse.getDlgLagerSession();
	}

	if ( !base.oDialogObjects[strDialog] )
		base.oDialogObjects[strDialog] = createDialogObject( strDialog );

	if ( !base.oDialogObjects[strDialog] )	// property may exist but value may be null
	{
		alert( 'no dialog object for dialog ' + strDialog );
		// no dialog object present, not possible to create one? bad luck dude
		throw new EasyKat.Exception( 'getDialogObject - no dialog object for dialog ' + strDialog );
	}
	return( base.oDialogObjects[strDialog] );
}

/**
 * setze Session Object zurck
 * VORSICHT !! oDlgLagerSession.SollwerteRohrUmTeil bleibt erhalten -- siehe Protokoll 12.12.2011 / 13.12.2011
 */
function setDeleteDialogObjectSession(strDialog){
	var base = _session();
	
	if (strDialog == 'LAGER') {
		// zur Unterscheidung ob ein FIN-File und damit Vorgabewerte vorhanden sind
		var FIN_FILE	= (typeof(Object.fromStorage( "DLGDATA.CA.FINDATA" )) == 'object' ? true : false);
		if (!FIN_FILE){
			var oClone = Base.deepClone(caMainController.topologieKlasse.oDlgLagerSession.SollwerteRohrUmTeil);
			caMainController.topologieKlasse.oDlgLagerSession = null;
			
			getDialogObjectSession('LAGER');
			Base.applyValues(caMainController.topologieKlasse.oDlgLagerSession.SollwerteRohrUmTeil,oClone);
			
			return true;
		}
		else{	// FIN_FILE
			var oDlgLagerSession_FIN = Object.fromStorage( "DLGDATA.CA.FINDATA.oDlgLagerSession_FIN" );
			caMainController.topologieKlasse.oDlgLagerSession = null;
			
			getDialogObjectSession('LAGER');
			
			caMainController.topologieKlasse.oDlgLagerSession.SollwerteHalterungspunkt = oDlgLagerSession_FIN.SollwerteHalterungspunkt;
			Base.applyValues(caMainController.topologieKlasse.oDlgLagerSession,oDlgLagerSession_FIN);
			
			return true;
		}
	}
	else{
		var oSess = getDialogObjectSession(strDialog);
		oSess = null;
	}
	
	if(base.oDialogObjects )	// lazy initialisation for startup
		base.oDialogObjects = {};
	
	return true;
}

function createDialogObject( strDialog )
{
	switch(strDialog){
		case "LAGER" :
			return( new LagerObject() );
		case "TOLERANZ" :
			return( new ToleranceObject() );	
		case "LAGERCACHE" :
			return( new LagerCacheObject() );	
	}
	
	return( null );
}

/**
 * gibt LagerCacheobject
 * @return {Object}
 */
function setDataIntoLagerCacheObject(strId,strTyp,oData,dIndex){
	var oLagerCache = getDialogObjectSession('LAGERCACHE');
	switch(strTyp){
		case 'TABLE' : 
				if(!oData)
					oLagerCache[strId].aResultTable = [];
				else	
					oLagerCache[strId].aResultTable.push(oData);
			break;
		case 'TEMP_TABLE' : 
				if(!oData)
					oLagerCache[strId].aTempTable = [];
				else	
					oLagerCache[strId].aTempTable.push(oData);
			break;	
		case 'UPDATE_COMPLITE_TABLE' :
				oLagerCache[strId].aResultTable = oData; //wobei hier das oData ein Array in Array ist;
			break;	
		case 'UPDATE_TEMP_TABLE' : 
				oLagerCache[strId].aTempTable[dIndex] = oData;				
			break;
		case 'TEMP_GUI' :
				if(!oData)
					oLagerCache[strId].aGuiTempObject = [];
				else	
					oLagerCache[strId].aGuiTempObject.push(oData);
			break;	
		case 'TEMP_OBJECT' : //Temp setDataIntoLagerCacheObject('Temp','TEMP_OBJECT',oData)
				if(!oData)
					oLagerCache[strId].Temp = {};
				else
					oLagerCache[strId].Temp = oData;
			break;
	}
	
}

function getDataFromLagerCacheObject(strId,strTyp,strZusatz){
	var oLagerCache = getDialogObjectSession('LAGERCACHE');
	var Result;
	switch(strTyp){
		case 'TABLE' : 
				if(strZusatz){
					if(oLagerCache[strId].aResultTable)
						Result = oLagerCache[strId].aResultTable[strZusatz];
					else
						Result = null;
				}
				else
					Result = oLagerCache[strId].aResultTable
			break;
		case 'TEMP_TABLE' : 
				if(strZusatz)
					Result = oLagerCache[strId].aTempTable[strZusatz];
				else
					Result = oLagerCache[strId].aTempTable
			break;
		case 'TEMP_GUI' :
				if(strZusatz)
					Result = oLagerCache[strId].aGuiTempObject[strZusatz];
				else
					Result = oLagerCache[strId].aGuiTempObject
			break;
		case 'TEMP_OBJECT':
				Result = oLagerCache[strId];
			break;
	}
	
	return Result;
}

/**
 * gibt Toleranzobject
 * @return {Object}
 */
function getLagerToleranzObject(){
	return(getDialogObjectSession('TOLERANZ'));
}
