/**
 * @category   Sattel function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Sattel ) === 'undefined' )
	Sattel = {};
if ( typeof( Sattel.Search ) === 'undefined' )
	Sattel.Search = {};
if ( typeof( Sattel.Search.SattelTyp ) === 'undefined' )
	Sattel.Search.SattelTyp = {};	

/**
 * fr Schale/Schale 
 * @param [oDlgLagerSession] {Object}
 * @param [strTable] {String} Tabelle
 * @return {Array} fr Client Tabelle
 */
Sattel.Search.SattelTyp.SchaleSchale =function(oDlgLagerSession,strTable){
	var oZusatz;
	var aResult 			= new Array();
	
	/**
	 * @private 
	 */
	var _buildDirection = function(oDlgLagerSession,strTable){
		var sqlPart = '';
		if(strTable == 'SMR'){
			if(oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo!='STD' )
				sqlPart = " AND abs(DM) = "+oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo;
			else if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder){
				sqlPart = " AND abs(DM) >= "+oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder*1;
				sqlPart +=" ORDER BY abs(DM) LIMIT 2";
			}
			//es existiert kein DN in SMR
			oZusatz = {};
			oZusatz.DN = oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo;
			oZusatz.D  = oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo;
		}
		
		return sqlPart;
	}
	
	var aTable = strTable.split(",");
	var dResult 	= 0;
	var strError 	= '';
	var _setError = function(strValue){
		if(!strError)
			strError = strValue;
	}
		
	for(var a=0;a<aTable.length;a++){
		var strSql 	= Sattel.Search.getDefaultSQL(oDlgLagerSession,aTable[a]);
			strSql	+= _buildDirection(oDlgLagerSession,aTable[a])
			
		var dbName	= 'LAGER2';		
		var oDBData = Sattel.Search.getSearchResultData(dbName,strSql);
		
		for(var j=0;j<oDBData.length;j++){
			oDBData[j]  = Sattel.Search.UpdateData(oDBData[j],oZusatz);
			
			var oRet 	= Sattel.Search.TestAndModify_LagerSystem(oDlgLagerSession, oDBData[j],aTable[a]);
			
			if(oRet.bOk){ //build client Tabelle
				dResult +=1;
				for(var i = 0;i<oRet.dCopy;i++){
					setDataIntoLagerCacheObject('AuswahlSattel','TABLE',(oRet.oData));
				}					
			}
			else
				_setError(oRet.oData.strError);	
		}	
	}
	
	return (dResult > 0 ? (Sattel.getClientTable(oDlgLagerSession)) : ['ERROR',strError]); 
}

/**
 * fr Schelle/Schelle , Schelle/Schale , Bgel/Schale, Biegeteil, Stege ...
 * @param [oDlgLagerSession] {Object}
 * @param [strTable] {String} Tabelle
 * @return {Array} fr Client Tabelle
 */
Sattel.Search.SattelTyp.searchMantel =function(oDlgLagerSession,strTable){
	var oZusatz;
	var aResult = new Array();
	
	/**
	 * @private 
	 */
	var _buildDirection = function(oDlgLagerSession){
		var oToleranz 		= getLagerToleranzObject();
		var oToleranzData	= Base.buildToleranceValue((oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder ? (oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder*1) : (oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo*1)),oToleranz.dMantelDuMesserSonder)
		var sqlPart;
		
		if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder && !oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
			sqlPart = " AND abs(D) >= "+oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder;
		}
		else if(oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder)
			strPartSQL = " AND abs(D) >= "+oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder+" ";
		else if(oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo!='STD'){	
			sqlPart = " AND abs(D) <= "+oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo;
			sqlPart += " AND abs(DN) = "+oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo;
		}	
		else
			sqlPart = " AND abs(D) = "+oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo;
			
		return sqlPart;
	}
	
	var aTable = strTable.split(",");
	
	for(var a=0;a<aTable.length;a++){
		var strSql 	= Sattel.Search.getDefaultSQL(oDlgLagerSession,aTable[a]);
			strSql	+= _buildDirection(oDlgLagerSession,aTable[a])
		
		if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder || oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
			strSql		+= " order by abs(D) ";			
		}
		
		var dbName	= 'LAGER2';
		var oDBData = Sattel.Search.getSearchResultData(dbName,strSql);
		var dD_Default;
		var bOK = true;
		
		var dResult 	= 0;
		var strError 	= '';
		var _setError = function(strValue){
			if(!strError)
				strError = strValue;
		}
		
		for(var i=0;i<oDBData.length;i++){
			if( (i==0) && (oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder || oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)){
				dD_Default 	= oDBData[i].D;
			}
			else if( (i>0) && (oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder || oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)){
				if(dD_Default){
					if(dD_Default != oDBData[i].D){
							bOK = false;
							_setError(translate("ERROR_AUSSENDURCHMESSER"));
						break;
					}
				}				
			}
			
			if(bOK){
				oDBData[i]  = Sattel.Search.UpdateData(oDBData[i],oZusatz);
				
				var oRet 	= Sattel.Search.TestAndModify_LagerSystem(oDlgLagerSession, oDBData[i],aTable[a]);
				
				if(oRet.bOk){ //build client Tabelle
					dResult +=1;
					for(var j = 0;j<oRet.dCopy;j++){
						setDataIntoLagerCacheObject('AuswahlSattel','TABLE',(oRet.oData));
						setDataIntoLagerCacheObject('AuswahlSattel','TEMP_TABLE',({'RollenlagerTable' : aTable[a]}));
					}					
				}
				else
					_setError(oRet.oData.strError);	
			}
		}
	}
	
	return (dResult > 0 ? (Sattel.getClientTable(oDlgLagerSession)) : ['ERROR',strError]); 
}



/**
 * fr nur Schale 
 * @param [oDlgLagerSession] {Object}
 * @param [strTable] {String} Tabelle
 * @return {Array} fr Client Tabelle
 */
Sattel.Search.SattelTyp.NurSchale =function(oDlgLagerSession,strTable){
	var oZusatz;
	var aResult 			= new Array();
	
	/**
	 * @private 
	 */
	var _buildDirection = function(oDlgLagerSession,strTable){
		var sqlPart = '';
		if(strTable == 'SSR'){			
			//es existiert kein DN in SMR
			oZusatz = {};
			oZusatz.DN = oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo;
			oZusatz.D  = oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo;
			
			var dAUFL,dAB;
			var dL	= (!oDlgLagerSession.AuswahlSattel.bSonderLength ? (oDlgLagerSession.AuswahlSattel.strSelComboLength * 1) : oDlgLagerSession.AuswahlSattel.dSonderLength);
			if(oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo !="STD" || oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder){ //Manteldurchmesser
				//Berechnung ber Mantel
				dAB = 0;
				var dMantel = oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo;
				if(dMantel !="STD")
					dMantel = dMantel *1;
				else
					dMantel = oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder;
					
				dAUFL = (0.7*dMantel*dL*0.3) / 1000;
				
				oZusatz.DM = dMantel;			
			}
			else { 
				//Berechnung ber Dmmung
				var dJ = (oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke*1);
				dAUFL = (0.7*dJ*dL*10) / 1000;
				
				oZusatz.J_MAX = dJ;
			}
			
			oZusatz.F_AUFL 	= dAUFL;
			oZusatz.F_AB	= dAB;
			oZusatz.F_QUER  = (0.35 * dAUFL);
			
			sqlPart = " AND abs(DA_DM_MIN) <= "+(oZusatz.DM ? oZusatz.DM : oZusatz.J_MAX);
			sqlPart +=" AND abs(DA_DM_MAX) >= "+(oZusatz.DM ? oZusatz.DM : oZusatz.J_MAX);
		}
		
		return sqlPart;
	}
	
	var aTable = strTable.split(",");
	
	var dResult 	= 0;
	var strError 	= '';
	var _setError = function(strValue){
		if(!strError)
			strError = strValue;
	}
	
	for(var a=0;a<aTable.length;a++){
		var strSql 		= Sattel.Search.getDefaultSQL(oDlgLagerSession,aTable[a]);
			strSql		+= _buildDirection(oDlgLagerSession,aTable[a])
			
		var dbName	= 'LAGER2';
		var oDBData = Sattel.Search.getSearchResultData(dbName,strSql);
		
		for(var i=0;i<oDBData.length;i++){
			oDBData[i]  = Sattel.Search.UpdateData(oDBData[i],oZusatz);
			
			var oRet 	= Sattel.Search.TestAndModify_LagerSystem(oDlgLagerSession, oDBData[i],aTable[a]);
			
			if(oRet.bOk){ //build client Tabelle
				dResult +=1;
				for(var j = 0;j<oRet.dCopy;j++){
					setDataIntoLagerCacheObject('AuswahlSattel','TABLE',(oRet.oData));
				}					
			}
			else
				_setError(oRet.oData.strError);	
		}
	}
	
	return (dResult > 0 ? (Sattel.getClientTable(oDlgLagerSession)) : ['ERROR',strError]); 
}