/**
 * @category   Sattel function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Sattel ) === 'undefined' )
	Sattel = {};
if ( typeof( Sattel.Search ) === 'undefined' )
	Sattel.Search = {};
if ( typeof( Sattel.Search.SattelTyp ) === 'undefined' )
	Sattel.Search.SattelTyp = {};	

/**
 * fr Schelle/Schelle , Schelle/Schale , Bgel/Schale, Biegeteil, Stege ...
 * @param [oDlgLagerSession] {Object}
 * @param [strTable] {String} Tabelle
 * @return {Array} fr Client Tabelle
 */
Sattel.Search.SattelTyp.searchDaemmdicke =function(oDlgLagerSession,strTable){
	var oZusatz;
	var aResult = new Array();
	
	/**
	 * @private 
	 */
	var _buildDirection = function(oDlgLagerSession){
		var oToleranz 		= getLagerToleranzObject();
		var oToleranzData	= Base.buildToleranceValue((oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke*1),oToleranz.dMantelDuMesserSonder)
		var sqlPart = "";
		
		if(oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
			sqlPart = " AND abs(D) >= "+oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder+" ";
			
			if(oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke)
				sqlPart += " AND abs(J_MAX) >= "+oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke;
		}	
		else{
			sqlPart =" AND abs(DN) = "+oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo;
			sqlPart += " AND abs(J_MAX) >= "+oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke;
		}
		
		return sqlPart;
	}
	
	var aTable = strTable.split(",");
	
	for(var a=0;a<aTable.length;a++){
		var strSql	= Sattel.Search.getDefaultSQL(oDlgLagerSession,aTable[a]);
			strSql	+= _buildDirection(oDlgLagerSession,aTable[a])
		
		if(oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke || oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
			strSql += " order by abs(D) ";
		}
		
		var dbName	= 'LAGER2';
		var oDBData = Sattel.Search.getSearchResultData(dbName,strSql);
		
		var dD_Default;
		var bOK = true;
		
		// -Schu- fhrt sonst zu leerer Liste, wenn z.B. IDR gefunden werden aber keine IKB
		if (a == 0)
			var dResult 	= 0;
		var strError 	= '';
		var _setError = function(strValue){
			if(!strError)
				strError = strValue;
		}
		
		for(var i=0;i<oDBData.length;i++){
			if( (i==0) && (oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder || oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)){
				dD_Default 	= oDBData[i].D;
			}
			else if( (i>0) && (oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder || oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)){
				if(dD_Default){
					if(dD_Default != oDBData[i].D){
							bOK = false;
							_setError(translate("ERROR_AUSSENDURCHMESSER"));
						break;
					}
				}				
			}
			
			if(bOK){
				oDBData[i]  = Sattel.Search.UpdateData(oDBData[i],oZusatz);
				
				var oRet 	= Sattel.Search.TestAndModify_LagerSystem(oDlgLagerSession, oDBData[i],aTable[a]);
				
				if(oRet.bOk){ //build client Tabelle
					dResult +=1;
					for(var j = 0;j<oRet.dCopy;j++){
						setDataIntoLagerCacheObject('AuswahlSattel','TABLE',(oRet.oData));
						setDataIntoLagerCacheObject('AuswahlSattel','TEMP_TABLE',({'RollenlagerTable' : aTable[a]}));
					}					
				}
				else
					//_setError(oRet.oData.strError);
					_setError(oRet.strError);
			}
		}
	}
	
	return (dResult > 0 ? (Sattel.getClientTable(oDlgLagerSession)) : ['ERROR',strError]); 
}