/**
 * @category   Sattel function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Sattel ) === 'undefined' )
	Sattel = {};
if ( typeof( Sattel.Search ) === 'undefined' )
	Sattel.Search = {};
	
/**
 * Test des gefunden Sattel
 */
Sattel.Search.TestAndModify_LagerSystem = function(oDlg, oData, strTable){
	var oRet = {};
	var strOberflaeche,strIdent,strWerkstoff,strOberflaeche;
	oRet.oData 		= oData;
	oRet.bOk		= true;
	oRet.strError	= '';
	
	// Prfung der sich ergebenden Buchsentemperatur am RL
	if (oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_SYROLLSA"){
		var oTempSatRL	= Lager.isRollenlager_Werkstoff_PA(oDlg.SollwerteRohrUmTeil,oData);
		if (oTempSatRL.RLTemp*1 > 280){
			oRet.bOk	= false;
			oRet.oData.strError	= translate("ERROR_TEMP_RL");
			oRet.strError	= translate("ERROR_TEMP_RL");
			return oRet;
		}
	}
	
	
	var oTableData 		= oDlg.SollwerteHalterungspunkt.oTable;	
	
	//Test 1 auf Bewegung
	var strPlusBewegung 	= "bewegung_plus";
	var strMinusBewegeung 	= "bewegung_minus";
	var aBewegungMatrix	= 	[
		oTableData.bewegung_plus.axial, oTableData.bewegung_plus.quer,oTableData.bewegung_plus.schief, 
		oTableData.bewegung_minus.axial, oTableData.bewegung_minus.quer, oTableData.bewegung_minus.schief
	];
	
	var _testBewegung = function(oPlusBewegung, oMinusBewegung, dPruefwertAxial, bUpliftRestraint, ZylRL, isMANTEL, AuflDMR){
		var bTestOk = true;
		var dAxial = abs(oPlusBewegung.axial*1) + abs(oMinusBewegung.axial*1);
		var deltaL	= fround(0.1 * dAxial, 0);
		if (bUpliftRestraint && !ZylRL){
			// Bestimmung der warscheinlichen RL-Gre
			var RL_Typ	= "";
			var strSQLStatement = "select * from RDF where abs(DA_MIN)<="+abs(AuflDMR)+" and abs(DA_MAX)>="+abs(AuflDMR)+" and WERKSTOFF_ROLLE = 'St' ";
			var numRet	= dbselect("LAGER2", strSQLStatement, "RDF");
			var RL_Gr	= dbgetdouble("RDF", "BAU_F");
			var TypAHS	= (isMANTEL ? "ADM" : "ADJ");
			strSQLStatement = "select * from "+TypAHS+" where abs(WERKSTOFF) = "+37+" and abs(BAU_F) = "+RL_Gr " ";
			numRet	= dbselect("LAGER2", strSQLStatement, TypAHS);
			var deltaL_DZ	= dbgetdouble(TypAHS, "DEL_AXBEW_ZUL");
			var strSQLStatement = "select * from RKF where abs(DA_MIN)<="+abs(AuflDMR)+" and abs(DA_MAX)>="+abs(AuflDMR)+" and WERKSTOFF_ROLLE = 'St' ";
			var numRet	= dbselect("LAGER2", strSQLStatement, "RKF");
			if (numRet > 0){
				var RL_Gr	= dbgetdouble("RKF", "BAU_F");
				var TypAHS	= (isMANTEL ? "AKM" : "AKJ");
				strSQLStatement = "select * from "+TypAHS+" where abs(WERKSTOFF) = "+37+" and abs(BAU_F) = "+RL_Gr " ";
				numRet	= dbselect("LAGER2", strSQLStatement, TypAHS);
				var deltaL_DK	= dbgetdouble(TypAHS, "DEL_AXBEW_ZUL");
			}
			else
				var deltaL_DK	= deltaL_DZ;
		}
		deltaL	+= max(deltaL_DZ, deltaL_DK);
		var dSattellaenge = dPruefwertAxial - deltaL;
		if(dAxial > dSattellaenge)
			bTestOk = false;
			
		return bTestOk;
	}
	
	for(var a=0;a<aBewegungMatrix.length;a++){
		if((aBewegungMatrix[a]*1)!=0){
				var strPruefAxial = (oDlg.AuswahlSattel.strSelComboLength*1);
				
				oRet.bOk = _testBewegung(oTableData[strPlusBewegung], oTableData[strMinusBewegeung], strPruefAxial, oDlg.AuswahlSattel.bUpliftRestraint, oDlg.AuswahlSattel.bActuator, (oData.DM ? true : false), oData.DA);
				
				if(!oRet.bOk){
					oRet.oData.strError	= translate("ERROR_SATTELLAENGE");
					return oRet;
				}
				
			break;
		}
	}
	
	//Test 2 Lasten
	var strPlusLast 	= "last_plus";
	var strMinusLast 	= "last_minus";
	var strUeberLast 	= "ueberlast";
	var strZusatzLast   = "zusatzlast";
	var aKraftMatrix		= 	[
		oTableData.last_plus.axial, oTableData.last_plus.quer,oTableData.last_plus.schief,
		oTableData.last_minus.axial,oTableData.last_minus.quer,oTableData.last_minus.schief
	];
	
	var _testKraft = function(oPlusLast,oMinusLast,oUeberLast,oZusatzLast,oDataRes,dAbminderungsfaktor){
		var bTestOk 	= true;
		var dAxial 		= max(abs(oPlusLast.axial*1),abs(oMinusLast.axial*1)) + abs(oZusatzLast.axial);
		var dQuer  		= max(abs(oPlusLast.quer*1),abs(oMinusLast.quer*1)) + abs(oZusatzLast.quer);
		var dAuflage	= abs(oMinusLast.schief*1) + abs(oZusatzLast.schief);
		var dAbhebe		= abs(oPlusLast.schief*1);
		
		//var dF_AXIAL = oDataRes.F_AXIAL;
		var dF_QUER  = oDataRes.F_QUER;
		var dF_AB	 = oDataRes.F_AB;
		var dF_AUFL  = oDataRes.F_AUFL;
		/*
		if(dF_AXIAL != "-"){
			var dZulaessig_Axial =  dF_AXIAL * dAbminderungsfaktor;
				
			if(dZulaessig_Axial<dAxial)
				return false;
				
			oDataRes.F_AXIAL_CALCULATION	= dZulaessig_Axial;	
		}
		else
			oDataRes.F_AXIAL_CALCULATION = dF_AXIAL;
		*/
		
		if(dF_QUER != "-"){
			var dZulaessig_Quer =  dF_QUER * dAbminderungsfaktor;
			
			if(dZulaessig_Quer<dQuer)
				//return false;
				bTestOk	= false;
			
			oDataRes.F_QUER_CALCULATION 	= fround(dZulaessig_Quer, 1);
		}
		else
			oDataRes.F_QUER_CALCULATION = dF_QUER;
		
		if(dF_AB != "-"){
			var dZulaessig_Ab =  dF_AB * dAbminderungsfaktor;
			
			if(dZulaessig_Ab<dAbhebe)
				//return false;
				bTestOk	= false;
			 
			oDataRes.F_AB_CALCULATION = fround(dZulaessig_Ab, 1);
		}
		else
			oDataRes.F_AB_CALCULATION = dF_AB;
		
		//var dZulaessig_Auflage =  oDataRes.F_AUFL;
		if(dF_AUFL != "-"){
			var dZulaessig_Auflage	= dF_AUFL * dAbminderungsfaktor;
			
			if(dZulaessig_Auflage<dAuflage)
				//return false;
				bTestOk	= false;
			
			oDataRes.F_AUFL_CALCULATION = fround(dZulaessig_Auflage, 1);
		}
		else
			oDataRes.F_AUFL_CALCULATION = dF_AUFL;
		
		if(((oUeberLast.axial*1) != 0) || ((oUeberLast.quer*1) !=0) || ((oUeberLast.schief*1) !=0) ){
			if(((oUeberLast.axial*1) != 0) && (dF_AXIAL != "-")){
				var dZulaessig  = (dF_AXIAL) * 2.5;
				if(dZulaessig<(oUeberLast.axial*1))
					//return false;					
					bTestOk	= false;
			}
			
			if(((oUeberLast.quer*1) != 0) && (dF_QUER != "-")){
				var dZulaessig  = (dF_QUER) * 2.5;
				if(dZulaessig<(oUeberLast.quer*1))
					//return false;					
					bTestOk	= false;
			}
			
			if(((oUeberLast.schief*1) != 0) && dZulaessig_Auflage){
				var dZulaessig  = (dZulaessig_Auflage/dAbminderungsfaktor) * 2.5;
				if(dZulaessig < dZulaessig_Auflage)
					//return false;					
					bTestOk	= false;
			}
		}
		
		return {'bOk' : bTestOk, 'oData' : oDataRes, 'strError' : translate("ERROR_KRAFT") };
	};
	
	// bei "SMR" ist der WerkstoffFaktor "1"
	var dWerk_Faktor = (strTable == "SMR" ? 1 : Lager.Search.TestAndModify_WerkstoffFaktor(oDlg));
	
	for(var a=0;a<aKraftMatrix.length;a++){
		if((aKraftMatrix[a]*1)!=0){
				oRet = _testKraft(oTableData[strPlusLast], oTableData[strMinusLast], oTableData[strUeberLast],oTableData[strZusatzLast],oData,dWerk_Faktor);
				
				if(!oRet.bOk)
					return oRet;
			
			break;
		}
	}
	
	//var strTypOf = typeof(oRet.bOk);
	var strTypOf = typeof(oRet);
	if(strTypOf == "object"){
		//oRet.oData  = oRet.bOk.oData;
		//oRet.bOk	= oRet.bOk.bOk;
	}
	if(!oRet.oData.F_AB_CALCULATION)
		oRet.oData.F_AB_CALCULATION = fround(oData.F_AB * dWerk_Faktor, 1);
	
	if(!oRet.oData.F_QUER_CALCULATION)
		oRet.oData.F_QUER_CALCULATION = fround(oData.F_QUER * dWerk_Faktor, 1);
		
	if(!oRet.oData.F_AXIAL_CALCULATION)
		oRet.oData.F_AXIAL_CALCULATION = fround(oData.F_AXIAL * dWerk_Faktor, 1);	
	
	if(!oRet.oData.F_AUFL_CALCULATION)
		oRet.oData.F_AUFL_CALCULATION = fround(oData.F_AUFL * dWerk_Faktor, 1);
	
	 /**
	 * @private bestimmen der Default Spalten aus der DB
	 */
	var _buildDefaultPreiseGewicht = function(){
		var strPreis 		= "PREIS_0_STL"; 		//WK0 == WERKSTOFF_ID & STL == Sattellnge
		var strGewicht 		= "GEW_STL";
		var strDelPreis 	= "DELPREIS_0_100";
		
		var strWerkstoff 	= oDlg.SollwerteRohrUmTeil.strSelRadioWerkstoff;
		
		//bestimme Seitenlnge
		//mgliche Grenze 700 - gilt auch bei Sonderlnge > 600
		var bGrenze700 = false;
		//if(((oDlg.AuswahlSattel.strSelComboLength*1) >=700 || (oDlg.AuswahlSattel.dSonderLength*1)>700) && oRet.oData.GEW_700)
		if(((oDlg.AuswahlSattel.strSelComboLength*1) >= 700 || (oDlg.AuswahlSattel.dSonderLength*1) > 600) && oRet.oData.GEW_700)
			bGrenze700 = true;
		
		if(bGrenze700){
			strPreis 	= strPreis.replace("STL","700");
			strGewicht 	= strGewicht.replace("STL","700");
		}
		else{
			strPreis 	= strPreis.replace("STL","300");
			strGewicht 	= strGewicht.replace("STL","300");
		}
		
		return ({
			'dDefaultGew'		: (oRet.oData[strGewicht]*1),
			'dDefaultPreis' 	: ((oRet.oData[strPreis]*1) 	== '-' ? -99999999 : (oRet.oData[strPreis]*1)),
			'dDefaultPreis100' 	: ((oRet.oData[strDelPreis]*1)	== '-' ? -99999999 : (oRet.oData[strDelPreis]*1))
		});
	}
	
	var _buildCompliteMaterial = function(){
		var strWerkstoff 	= oDlg.SollwerteRohrUmTeil.strSelRadioWerkstoff;
		var strOberflaeche	= oDlg.AuswahlSattel.strSelComboGroundLevel; 
		
		strWerkstoff		= Produkt.getWerkstoffeNumber(strWerkstoff.replace("LAGER_",""));
		strWerkstoff 		= strWerkstoff+'.'+strOberflaeche;
		
		return strWerkstoff;
	}
	
	//Korrigierre TYP
	var strTyp = oRet.oData.TYP;
	var bTypCorrction = false;
	if(strTyp.indexOf('.XXX.')>0){
		bTypCorrction = true;
		if (oDlg.AuswahlSattel.bSonderLength)
			strTyp = strTyp.replace("XXX",oDlg.AuswahlSattel.dSonderLength);
		else
			strTyp = strTyp.replace("XXX",oDlg.AuswahlSattel.strSelComboLength);
	}
	else if(strTyp.indexOf('.XXXX')>0){
		bTypCorrction = true;	
		var strWerkstoff 	= _buildCompliteMaterial();		
		
		var strSize 		= ''+oDlg.AuswahlSattel.strSelComboLength;
		if(oDlg.AuswahlSattel.bSonderLength){
			strSize = ''+oDlg.AuswahlSattel.dSonderLength;
			if(strSize.length > 4)
				oRet.bOk = false;				
		}
		
		switch(strSize.length){
			case 1 : strSize = '000'+strSize; break;
			case 2 : strSize = '00'+strSize; break;
			case 3 : strSize = '0'+strSize; break;
			default : strSize = ''+strSize; break;
		}
		
		strTyp = strTyp.replace('.XXXX','.'+strSize);
	}
	else if(strTyp.indexOf('XXX-')>0){
		bTypCorrction = true;
		var strSize 		= ''+oDlg.AuswahlSattel.strSelComboLength;
		if(oDlg.AuswahlSattel.bSonderLength){
			strSize = ''+oDlg.AuswahlSattel.dSonderLength;
			if(strSize.length > 4)
				oRet.bOk = false;				
		}
		//strTyp = strTyp.replace("XXX",oDlg.AuswahlSattel.strSelComboLength);
		strTyp = strTyp.replace("XXX",strSize);
	}
	else if(strTyp.indexOf('XXXX.XXX')>0){
		bTypCorrction = true;
		var dDN_DM,strDN_DM;
		var strSize = Sattel.getFormatLength(oDlg);
		
		if(oRet.oData.J_MAX)
			dDN_DM = oRet.oData.J_MAX*1;
		else if(oRet.oData.DM)
			dDN_DM = oRet.oData.DM*1;
		
		//Daten Auffllen
		if(dDN_DM > 10000)
			oRet.bOk = false;
		else if(dDN_DM >= 1000 && dDN_DM<10000)
			strDN_DM = ''+ dDN_DM;
		else if(dDN_DM >=100 && dDN_DM<1000)
			strDN_DM = '0'+dDN_DM; 
		else if(dDN_DM >=10 && dDN_DM<100)
			strDN_DM = '00'+dDN_DM; 
		else if(dDN_DM >=1 && dDN_DM<10)
			strDN_DM = '000'+dDN_DM; 
		
		var strWerkstoff 	= _buildCompliteMaterial();
		
		strTyp = strTyp.replace('XXXX.XXX',''+strDN_DM+'.'+strSize );
	}
	
	if(strTyp.indexOf('.X')>0)
		strTyp = strTyp.replace(".X","."+oDlg.AuswahlSattel.strSelComboGroundLevel);
	
	
	//Korrigierre Preis und Gewicht entsprechend der Seitenlnge
	var oDefaultPreisGewicht = _buildDefaultPreiseGewicht();
	var oZusatzData = {
		'DELGEW_100'		: (oRet.oData.DELGEW_100*1),
		'dDefaultGew'		: oDefaultPreisGewicht.dDefaultGew,
		'dDefaultPreis' 	: oDefaultPreisGewicht.dDefaultPreis,
		'dDefaultPreis100' 	: oDefaultPreisGewicht.dDefaultPreis100,
		'dFaktObfl'			: '',	
		'dSonderLength' 	: oDlg.AuswahlSattel.dSonderLength,
		'strSelComboLength' : oDlg.AuswahlSattel.strSelComboLength,
		'dOberflaeche'		: (oDlg.AuswahlSattel.strSelComboGroundLevel*1),
		'L_MIN'				: oRet.oData.L_MIN
	};	
	var oCalculationdata	= Base.buildPreisGewicht(oZusatzData,oData);
	oRet.oData.GEWICHT 		= oCalculationdata.dNewGew;
	oRet.oData.PREIS		= oCalculationdata.dNewPrice < 0 ? 0 : oCalculationdata.dNewPrice;	
	oRet.oData.PREIS_Tab    = Base.getPrice(oCalculationdata.dNewPrice);
	
	//Teste Hhe
	if(oRet.oData.L_MAX && !oDlg.AuswahlSattel.bSonderLength){
		if((oRet.oData.L_MAX*1) <  (oDlg.AuswahlSattel.strSelComboLength *1)) //der Fall kann vorkommen wenn mehrere Tabellen (Bsp. Schelle/Schelle) in frage kommen
			oRet.bOk = false;
	}
	
	//Test - Neuberechnung Haltepunkte	
	if(bTypCorrction)
		oRet.oData.TYP = strTyp;
	
	oRet.dCopy = 1;	
	return oRet;	
}	
	