/**
 * @category   Sattel function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Sattel ) === 'undefined' )
	Sattel = {};
if ( typeof( Sattel.Search ) === 'undefined' )
	Sattel.Search = {};

/**
 * Zentraler Einstieg zu suche von Sattel
 * Wird direkt aufgerufen aus dem Kontroller 
 * @return {Object}
 */
Sattel.Search.getSearchResult = function(oDlgLagerSession){
	var myData;
	var oResult = {};
	
	if(oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart){
		switch(oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart){
			case "SCHELLE_SCHELLE" 	:
			case "SCHELLE_SCHALE"	:
			case "BUEGEL_SCHALE"	:
					if(oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != 'STD' || oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
						myData = Sattel.Search.SattelTyp.searchMantel(oDlgLagerSession,Sattel.getTypReihen(oDlgLagerSession));
					else
						myData = Sattel.Search.SattelTyp.searchDaemmdicke(oDlgLagerSession,Sattel.getTypReihen(oDlgLagerSession));
				break;	
			case "SCHALE_SCHALE"	:
					myData = Sattel.Search.SattelTyp.SchaleSchale(oDlgLagerSession,Sattel.getTypReihen(oDlgLagerSession));
				break;		
		}
	}
	else if(oDlgLagerSession.AuswahlSattel.bRadioWeldEnd){
		switch(oDlgLagerSession.AuswahlSattel.strRadioWeldEnd){
			case "STEGE_M_SCHALE"	:
			case "STEGE"			:
			case "BIEGETEIL" 		:
					myData =  Sattel.Search.SattelTyp.searchDaemmdicke(oDlgLagerSession,Sattel.getTypReihen(oDlgLagerSession));
				break;
			case "N_SCHALE"	:
					myData = Sattel.Search.SattelTyp.NurSchale(oDlgLagerSession,Sattel.getTypReihen(oDlgLagerSession));
				break;
		}
	} 
	
	
	if(myData.length == 2){
		try{
			if(myData[0] == 'ERROR' && myData[1] != '')
				oResult.Error = myData[1];
			else if(myData[0] == 'ERROR')
				oResult.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
			else
				oResult.aTableData = myData;
		}
		catch(err){}
	}
	else if(myData.length == 0)
		oResult.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
	else
		oResult.aTableData = myData;
	
	return oResult;
}

/**
 * erstelle Default SQL String fr Sattel
 * @param [oDlgLagerSession] {Object}
 * @param [strTable] {String}
 */
Sattel.Search.getDefaultSQL = function(oDlgLagerSession,strTable){
	var sqlString = "SELECT * FROM "+strTable+" ";
	
	if(!oDlgLagerSession.AuswahlSattel.bSonderLength)
		sqlString += "WHERE abs(L_MIN) <= "+oDlgLagerSession.AuswahlSattel.strSelComboLength;
	else{
		sqlString += "WHERE abs(L_MIN) <= "+oDlgLagerSession.AuswahlSattel.dSonderLength;
		sqlString += " AND abs(L_MAX) >= "+oDlgLagerSession.AuswahlSattel.dSonderLength;
	}
	
	sqlString += " AND WERKSTOFF = '"+Lager.getWerkstoffeNumber(oDlgLagerSession)+"'";
	
	return sqlString;
}


/**
 * lies Db Zeile aus
 * @param [dbNameTable] {String}
 * @param [oZusatz] {Object}
 * @return {Object}
 */
Sattel.Search.getSearchResultData = function(dbNameTable,sqlString){
	return(Object.fromDatabase(dbNameTable,sqlString));	
};

Sattel.Search.UpdateData = function(oData,oZusatz){
	if(!oData.DM)
		oData.DM = oZusatz.DM ? oZusatz.DM : null;
	
	if(!oData.F_AUFL)
		oData.F_AUFL = oZusatz.F_AUFL;
	
	if(!oData.F_AB)
		oData.F_AB = oZusatz.F_AB;
		
	if(!oData.F_QUER)
		oData.F_QUER = oZusatz.F_QUER;
	
	if(!oData.J_MAX)
		oData.J_MAX = oZusatz.J_MAX ? oZusatz.J_MAX : null;
	
	if(!oData.DN)
		oData.DN = oZusatz.DN;
	
	if(!oData.D)
		oData.D = oZusatz.D;
	
	return oData;
}