/**
 * @category   Sattel function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Sattel ) === 'undefined' )
	Sattel = {};

Sattel.getZuOrdnungsObject = function(){
	var aRadios = [
		['SCHELLE_SCHELLE' 	, 'ITB,IDR,IKB'],
		['SCHELLE_SCHALE'	, 'INS'],
		['SCHALE_SCHALE'	, 'SMR'],
		['BUEGEL_SCHALE'	, 'INB'],
		['BIEGETEIL'		, 'IKO'],
		['STEGE'			, 'IDO'],
		['STEGE_M_SCHALE'	, 'INO'],
		['N_SCHALE'			, 'SSR']
	];
	
	return aRadios;
};

/**
 * Bestimmte DB Tabellen (somit den TYP des Sattels)
 * @param [oDlgLagerSession] {Object}
 * @param [strTypen] {String}
 * @retrun
 */
Sattel.getTypReihen = function(oDlgLagerSession,strTypen){
	var strTypReihen;
	if(!strTypen){ 
		//bRadioSurroundingPart = true dann ist bRadioWeldEnd = false
		//oder
		//bRadioSurroundingPart = false dann ist bRadioWeldEnd = true
		
		if(oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart){
			switch(oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart){
				case "SCHELLE_SCHELLE" 	:
						if(oDlgLagerSession.AuswahlSattel.bActuator)
							strTypReihen = 'ITB';
						else	
							strTypReihen = 'IDR,IKB';
					break;
				case "SCHELLE_SCHALE"	:
						strTypReihen = 'INS';
					break;
				case "SCHALE_SCHALE"	:
						strTypReihen = 'SMR';
					break;
				case "BUEGEL_SCHALE"	:
						strTypReihen = 'INB';
					break;
			}
		}
		else if(oDlgLagerSession.AuswahlSattel.bRadioWeldEnd){
			switch(oDlgLagerSession.AuswahlSattel.strRadioWeldEnd){
				case "BIEGETEIL" 	:
						strTypReihen = 'IKO';
					break;
				case "STEGE"	:
						strTypReihen = 'IDO';
					break;
				case "STEGE_M_SCHALE"	:
						strTypReihen = 'INO';
					break;
				case "N_SCHALE"	:
						strTypReihen = 'SSR';
					break;
			}
		}
	}
	
	return strTypReihen;
};

/**
 * is Zylinder
 */
Sattel.ZuordnungRollenlager = function(strTableId){
	var strZuordnung = false;
	
	switch(strTableId){
		case "SMR" :
		case "INS" :
		case "INB" :
		case "IDR" :
		case "IKB" :
				strZuordnung = "ZYLINDER";
			break;
		case "ITB" :
				strZuordnung = "DOPPELZYLINDER,DOPPELKEGEL";
			break;
	}
	
	return strZuordnung;
}


/**
 * Formatiere Sattellnge
 */
Sattel.getFormatLength = function(oDlg,bZubehoer){
	var strSize	= oDlg.AuswahlSattel.strSelComboLength;
	
	if(oDlg.AuswahlSattel.bSonderLength || bZubehoer){
		var dSize = bZubehoer ? oDlg.AuswahlRollenlager.dSattelLength : oDlg.AuswahlSattel.dSonderLength;
		if(dSize >= 1000)
			strSize = '-';
		else if(dSize >=100 && dSize<1000)
			strSize = ''+dSize; 
		else if(dSize >=10 && dSize<100)
			strSize = '0'+dSize; 
		else if(dSize >=1 && dSize<10)
			strSize = '00'+dSize;				
	}
	
	return strSize;
}

/**
 * Bestimme mgliche Sattellngen und Teste auf selectierten Wert (ndere diesen gegebenfals)
 * @param [oDlgLagerSession] {Object}
 * @return {Object}
 */
 Sattel.getLaenge = function(oDlgLagerSession){
	var strTable 			= Sattel.getTypReihen(oDlgLagerSession);
	var aTables   			= strTable.split(",");
	var aMoeglicheLaengen 	= new Array();
	
	var _addWert = function(newData_min,newData_max){
		if(!newData_max) //solange L_MAX in DB nicht vorhanden ist
			newData_max = 1000;
		var a = 0;	
		
		var oTableData = oDlgLagerSession.SollwerteHalterungspunkt.oTable;
		
		while(newData_min <= newData_max){
			var bEmpty = true;
			for(var i=0;i<aMoeglicheLaengen.length;i++){
				if(aMoeglicheLaengen[i][0] == newData_min)
					bEmpty = false;
			}	
			
			//Test ob Axialverschiebung passt
			var dAxial1 		= max(abs(oTableData.last_plus.axial*1),abs(oTableData.last_minus.axial*1)) + abs(oTableData.zusatzlast.axial);
			var dAxial 			= abs(oTableData.bewegung_plus.axial*1) + abs(oTableData.bewegung_minus.axial*1);
			var dSattellaenge 	= newData_min - 50;
			
			if(dAxial > dSattellaenge)
				bEmpty = false;
		
			if(bEmpty)
				aMoeglicheLaengen.push([newData_min,newData_min]);
			
			
			newData_min += 100;
		}
	}
	
	for(var a=0; a<aTables.length;a++){
		var D_DM		= (aTables[a] == "SMR" ? "DM" : "D");
		var Gr_Gl		= "=";	// "Gleich" oder "GrerGleich"
		if (D_DM == "D" && !oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder)
			var dA		= oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo;
		else if (D_DM == "D" && oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
			var dA		= oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder;
			Gr_Gl		= ">=";
		}
		else if (D_DM == "DM" && !oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
			var dA		= oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo;
		else if (D_DM == "DM" && oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder){
			var dA		= oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder;
			Gr_Gl		= ">=";
		}
		else{	// sollte nicht vorkommen
			var dA		= 0;
			Gr_Gl		= ">=";
		}
		//var sqlString 	= "SELECT * FROM "+aTables[a]+" WHERE abs("+D_DM+") >= "+dA+" GROUP BY L_MIN ORDER BY L_MIN";
		var sqlString 	= "SELECT * FROM "+aTables[a]+" WHERE abs("+D_DM+") "+Gr_Gl+" "+dA+" GROUP BY L_MIN ORDER BY L_MIN";
		var dbName 		= 'LAGER2';
		var dbNameTable = "SATTEL_LAENGE";
		var strTable	= '';		
		if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){
			var MacheWeiter	= true;
			//while ( dbiseof( dbNameTable) == 0 ){
			while ( dbiseof( dbNameTable) == 0 && MacheWeiter ){
				_addWert(dbgetdouble(dbNameTable,"L_MIN"),dbgetdouble(dbNameTable,"L_MAX"));
				if (Gr_Gl == ">=")
					MacheWeiter	= false;
				dbskip( dbNameTable );
			}
		}
	}
	
	//Test Selection Wert
	if(!Base.hasValueIntoArrayPositionNull( aMoeglicheLaengen, oDlgLagerSession.AuswahlSattel.strSelComboLength ))
		oDlgLagerSession.AuswahlSattel.strSelComboLength = (aMoeglicheLaengen.length > 0 ? aMoeglicheLaengen[0][0] : null);
	
	//Rckgabe
	return ({
		'Store' 	: aMoeglicheLaengen,
		'select' 	: oDlgLagerSession.AuswahlSattel.strSelComboLength
	});
 }

/**
 * Bestimme default Daten fr den Sattel
 * - bestimme strRadioSurroundingPart
 * - bestimme default Zylinderrollenlage
 * - bestimme default Abhebesicherung
 * - bestimme default Rohrumschluss / anscheissen
 * - bestimme Auflagedurchmesser
 * - bestimme default Saatelnge
 * @param [oDlgLagerSession] {Object}
 */
Sattel.setDefaultData = function(oDlgLagerSession){
	var bMantel = false;
	if((oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo !== 'STD') || (oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)){
		oDlgLagerSession.AuswahlSattel.bActuator 				= false;
		oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart 	= 'SCHALE_SCHALE';
		oDlgLagerSession.AuswahlSattel.strRadioWeldEnd			= 'N_SCHALE';
		oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart 	= true;
		oDlgLagerSession.AuswahlSattel.bRadioWeldEnd 			= false;
		oDlgLagerSession.AuswahlSattel.dLayer					= (oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo * 1);
		bMantel = true;
	}
	else{
		oDlgLagerSession.AuswahlSattel.dLayer					= ((oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder * 1) + (oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke * 1));
		oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart 	= 'SCHELLE_SCHELLE';
		oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart 	= true;
		oDlgLagerSession.AuswahlSattel.bRadioWeldEnd 			= false;
	}
	
	//bestimme mgliche Radio-Button	
	var aRadios = Sattel.getZuOrdnungsObject();
	for(var a=0;a<aRadios.length;a++){
		var aPart 		= aRadios[a];
		var strTable 	= aPart[1];
		var aTable 		= strTable.split(",");
		var bExistiert  = false;
		for(var i=0;i<aTable.length;i++){
			if (strTable != "SMR")
				var sqlString = "SELECT count(*) AS Zaehler FROM "+aTable[i]+" WHERE DN = "+oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo;
			else
				var sqlString = "SELECT count(*) AS Zaehler FROM "+aTable[i]+" WHERE DM = "+oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo;
			var oData = Object.fromDatabase("LAGER2",sqlString);
			
			if(bMantel && (a > 3)){
				if(aPart[0] == 'N_SCHALE')
					oDlgLagerSession.AuswahlSattel.strRadioWeldEnd	= 'N_SCHALE';
			}			
			else if(oData[0].ZAEHLER > 0){
				bExistiert = true;
				if(a > 3)
					oDlgLagerSession.AuswahlSattel.strRadioWeldEnd = aPart[0];
			}
		}
		
		if(oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart == aPart[0]){
			if(!bExistiert)
				oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart = '';
		}
		else if(oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart == '' && bExistiert && a<=3)
			oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart = aPart[0];		
		else if(oDlgLagerSession.AuswahlSattel.strRadioWeldEnd == aPart[0]){
			if(!bExistiert)
				oDlgLagerSession.AuswahlSattel.strRadioWeldEnd = '';
		}
		else if(!oDlgLagerSession.AuswahlSattel.strRadioWeldEnd && bExistiert && i>3)
			oDlgLagerSession.AuswahlSattel.strRadioWeldEnd = aPart[0];
		
		setDataIntoLagerCacheObject('AuswahlSattel','TEMP_GUI',([aPart[0] , bExistiert]));		
	}
	
	if(oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart == '')
		oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart = 'SCHELLE_SCHELLE';
	
	if(oDlgLagerSession.AuswahlSattel.strRadioWeldEnd == '')
		oDlgLagerSession.AuswahlSattel.strRadioWeldEnd = 'N_SCHALE';
	
	oDlgLagerSession.AuswahlSattel.bSonderLayer					= false;
	oDlgLagerSession.AuswahlSattel.bSonderLength				= false;	
	oDlgLagerSession.AuswahlSattel.dSonderLayer					= 0;
	oDlgLagerSession.AuswahlSattel.dSonderLength				= 0;
	oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel		= '2'; //laut Katalog
	
	if(!oDlgLagerSession.AuswahlSattel.bActuator)
		oDlgLagerSession.AuswahlSattel.bUpliftRestraint = false;
		
	
	
	Sattel.getLaenge(oDlgLagerSession);
}


Sattel.getClientTable = function(oDlgLagerSession){
	var aAbhebesicherung;
	var aResult 	= new Array();
	var aSattelData = getDataFromLagerCacheObject('AuswahlSattel','TABLE');
	
	if(oDlgLagerSession.AuswahlSattel.bUpliftRestraint)
		aAbhebesicherung = getDataFromLagerCacheObject('AuswahlAbhebesicherung','TABLE');
	
	for(var a=0;a<aSattelData.length;a++){
		var aDBData = new Array();
		var oDataAbhebesicherung;
		var oDataSattel = aSattelData[a];
		
		if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder || oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
			// Original-Datensatz merken
			var oOriginalRow = Base.deepClone(oDataSattel);  
			// Original-Daten abndern auf Sondermae
			var oUpdateData  = Base.updateTableSearchData(oDlgLagerSession,oDataSattel,'AuswahlSattel');
			// Wenn abndern erfolgreich ist und die Originaldaten noch nicht gespeichert sind
			// letzeres ntig, da sonst bei jedem zurck der Preis erhht wird!!!
			if(oUpdateData.bOk && typeof(aSattelData[a].oOriginalData) != 'object'){
				// Original-Datensatz als Unterobjekt sichern
				aSattelData[a].oOriginalData = {};
				EasyKat.apply(aSattelData[a].oOriginalData,oOriginalRow);
				// Neue, abgenderte Daten zur Anzeige benutzen
				oDataSattel = oUpdateData;
				//Um auf nummer sicher zu gehen
				Base.applyValues(aSattelData[a],oUpdateData);
			}
		}
		
		if(oDlgLagerSession.AuswahlSattel.bUpliftRestraint)
			oDataAbhebesicherung = aAbhebesicherung[a];
	
		aDBData.push(oDataSattel.TYP+"_"+a+																		(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDataAbhebesicherung.TYP ? '<br>'+oDataAbhebesicherung.TYP+"_"+a : '')); //ID
		aDBData.push(oDataSattel.TYP+																			(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDataAbhebesicherung.TYP ? '<br>'+oDataAbhebesicherung.TYP : '')); //TYP
		aDBData.push(oDataSattel.DN	+																			(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDataAbhebesicherung.TYP ? '<br>' : ''));
		aDBData.push((oDataSattel.DM ? oDataSattel.DM : oDataSattel.J_MAX)+										(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDataAbhebesicherung.TYP ? '<br>' : ''));					
		aDBData.push((oDataSattel.F_AUFL_CALCULATION ? oDataSattel.F_AUFL_CALCULATION : oDataSattel.F_AUFL)+	(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDataAbhebesicherung.TYP ? '<br>' : ''));
		aDBData.push((oDataSattel.F_QUER_CALCULATION ? oDataSattel.F_QUER_CALCULATION : oDataSattel.F_QUER)+	(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDataAbhebesicherung.TYP ? '<br>' : ''));
		aDBData.push((oDataSattel.F_AB_CALCULATION ? oDataSattel.F_AB_CALCULATION : oDataSattel.F_AB)+			(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDataAbhebesicherung.TYP ? '<br>' : ''));				
		aDBData.push(oDataSattel.GEWICHT+ 																		(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDataAbhebesicherung.TYP ? '<br>'+oDataAbhebesicherung.GEWICHT : ''));
		aDBData.push(oDataSattel.PREIS_Tab+ 																	(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDataAbhebesicherung.TYP ? '<br>'+oDataAbhebesicherung.PREIS_Tab : ''));
		
		aResult.push(aDBData);
	}
	
	if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder || oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
		setDataIntoLagerCacheObject('AuswahlSattel','UPDATE_COMPLITE_TABLE',aSattelData);
	}
	
	return aResult;
}