/**
 * @category   Lager function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * Lager Typ: Lose Lager
 */
if ( typeof( Lager ) === 'undefined' )
	Lager = {};
if ( typeof( Lager.Search ) === 'undefined' )
	Lager.Search = {};
if ( typeof( Lager.Search.LagerTyp ) === 'undefined' )
	Lager.Search.LagerTyp = {};	

/**
 * suche nache Zubehr in Tabelle LGA_LGV, LAW
 * @param [oDlg]{Object}
 * @return {Array} Combo Array
 */ 
Lager.Search.LagerTyp.ZubehoerPTFE = function(oDlg){
	var aDBData 	= new Array();
	if(!oDlg.ZubehoerPTFE.bFieldSetCheckBox	){ //Lager Gleitelemente PTFE 
		var sqlString = "SELECT * FROM 'LGA_LGV' ";
		var strTyp = oDlg.ZubehoerPTFE.strSelComboSlidingPart;
		
		if(oDlg.ZubehoerPTFE.strSelComboTempSlidingPart == '90') //Temperatur
			strTyp += '%-0.3';
		else if(oDlg.ZubehoerPTFE.strSelComboTempSlidingPart == '180')
			strTyp += '%-1.3';
			
			sqlString += "WHERE TYP like '"+strTyp+"' ";
			
		var dbName		= 'LAGER2';
		var dbNameTable = "ZUBEHOER_PTFE";
		var aResult		= new Array();
		var dRow 		= 0;
		
		var dSelect 	= dbselect( dbName, sqlString, dbNameTable );
		
		if ( dSelect > 0 ){
			while ( dbiseof( dbNameTable) == 0 ){
				var strTyp		= dbgetstring(dbNameTable,"TYP");
				var strTypSplit	= strTyp.substring(4,strTyp.lastIndexOf("-"));
				aDBData.push([strTyp,strTypSplit,strPic]);				
				dbskip( dbNameTable );
			}
		}
	}	
	else{ //Abhebesicherung anschweissbar
	
	}
	
	if(!Base.hasValueIntoArrayPositionNull(aDBData,oDlg.ZubehoerPTFE.strSelComboDimensions))
		oDlg.ZubehoerPTFE.strSelComboDimensions = aDBData[0][0];
	
	var oResult = {
		'strSelection' 	: oDlg.ZubehoerPTFE.strSelComboDimensions,
		'ComboStore'	: aDBData
	};
	
	return oResult;
}

/**
 * gib alle Daten fr den Selectierten Wert
 */
Lager.Search.LagerTyp.ZubehoerPTFE_AllData = function(strTable,strSelTyp){
	var sqlString = "SELECT * FROM "+strTable;
		sqlString += " WHERE TYP = '"+strSelTyp+"' ";
	
	var dbName		= 'LAGER2';
	var oResult		= Lager.Search.getSearchResultData(dbName,sqlString);	
	return oResult;
};