/**
 * @category   Lager function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * Lager Typ: Lose Lager
 */
if ( typeof( Lager ) === 'undefined' )
	Lager = {};
if ( typeof( Lager.Search ) === 'undefined' )
	Lager.Search = {};
if ( typeof( Lager.Search.LagerTyp ) === 'undefined' )
	Lager.Search.LagerTyp = {};	

/**
 * bestimme alle daten aus der DB die es zu den begegebene Typ gibt, sollte nur einer sein, da Typ eindeutig ist
 * funtktion wird direkt aus dem Controller angesprungen
 * @return {Object} es gibt hier nur einen DB Eintrge Direktwahl
 */
Lager.Search.LagerTyp.Rollenlager_Direkt = function(oDlg,strSelection){
	var strTable	= strSelection.substring(0,3);	
	var sqlSting	= "SELECT * FROM "+strTable+" WHERE TYP = '"+strSelection+"'";
	var dbName		= 'LAGER2';
	var oResult 	= Lager.Search.getSearchResultData(dbName,sqlSting)	
	
	for(var a=0;a<oResult.length;a++){
		oResult[a].PRICE_CALCULATION = Base.getPrice(oResult[a].PRICE);
	}
	
	return oResult[0]; //Es kann nur ein Wert hier sien, da eindeutig bestimmt also kann man auch gleich dieses Ergebnis als Object zurckgeben
}	

/**
 * Bestimmung des Rollenlagers
 * @param [oDlg] {Object}
 * @param [strDialog] {String}
 * @return Array
 */
Lager.Search.LagerTyp.Rollenlager = function(oDlg,strDialog){
	/**
	 * @private build direction for sql
	 */
	var _buildDirection = function(oDlg,strSql){
		var strPartSQL = '';
		var bIsKlemmbar = (oDlg.AuswahlRollenlager.strSelRadioFunction == 'KLEMMBAR');
		if (bIsKlemmbar)
			//strPartSQL = ' AND abs(KLEMMBAR) = abs('+(bIsKlemmbar ? 1 : 0)+')';
			strPartSQL = ' AND abs(KLEMMBAR) = abs(1)';
		
		return strPartSQL;
	}
	
	var strSql 		= Lager.Search.getDefaultSQLRollenlager(oDlg,strDialog);
	
	if(strDialog == "ROLLENLAGER_S" || (strDialog == "ROLLENLAGER_P" && oDlg.AuswahlRollenlager.strSelComboTyp == "ZYLINDER"))
		strSql		+= " WHERE WERKSTOFF_ROLLE = '"+oDlg.AuswahlRollenlager.strSelRadioWerk+"'";
	else if(strDialog == "ROLLENLAGER_P")
		strSql		+= " AND WERKSTOFF_ROLLE = '"+oDlg.AuswahlRollenlager.strSelRadioWerk+"'";
	//strSql		+= _buildDirection(oDlg,strSql);
	strSql		+= _buildDirection(oDlg,strSql) + " order by abs(SEQ_ID) ";
	var aResult		= new Array();	
	var aAllDBData  = Lager.Search.getSearchResultData('LAGER2',strSql);
	var dResult 	= 0;
	var strError 	= '';
	
	var _setError = function(strValue){
		if(!strError)
			strError = strValue;
	}
	
	for(var a=0;a<aAllDBData.length;a++){
		var oRet = Lager.Search.TestAndModify_Rollenlager(oDlg, aAllDBData[a]);
		if(oRet.bOk){ //build client Tabelle				
			dResult +=1;
			for(var i = 0;i<oRet.dCopy;i++){
				setDataIntoLagerCacheObject('AuswahlRollenlager','TABLE',(oRet.oData));
			}
		}
		else
			_setError(oRet.oData.strError);
	}
	
	return (dResult > 0 ? Lager.getClientTable(oDlg,strDialog) : ['ERROR',strError]);
}

Lager.Search.LagerTyp.isRollenlagerKlemmbar = function(strId){
	var strTable = strId.substring(0,3);
	var sqlSting = "SELECT KLEMMBAR FROM "+strTable+" WHERE TYP like '"+strId+"'";
	
	var aAllDBData  = Lager.Search.getSearchResultData('LAGER2',sqlSting);
	
	return(aAllDBData[0].KLEMMBAR == '1' ? true : false);
}	