/**
 * @category   Lager function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * Lager Typ: Fuehrungslager
 */
if ( typeof( Lager ) === 'undefined' )
	Lager = {};
if ( typeof( Lager.Search ) === 'undefined' )
	Lager.Search = {};
if ( typeof( Lager.Search.LagerTyp ) === 'undefined' )
	Lager.Search.LagerTyp = {};	
	
Lager.Search.LagerTyp.Fuehrungslager = function(oDlg){
	/**
	 * @private build column for load pressure
	 */
	var _buildColumnLast = function(oDlg){
		if(oDlg.Systemcharakteristik.strSelRadioLager == 'LAGER_EPG')
			return 'F_AUFL_PTFE';
		else if(oDlg.Systemcharakteristik.strSelRadioLager == 'LAGER_SSG')	
			return 'F_AUFL_TRAV';
		else
			return 'F_AUFL_ST';
	}
		
	/**
	 * @private build direction for sql
	 */
	var _buildDirection = function(oDlg,strSql){
		var strPartSQL = ' ';
		if(rfind(strSql,"IKL")>0){		// @@@@@@@@ Besserer Check, in Zukunft gibt es mehr vorisolierte Typen !
			//hier wird der Mantelduchmesser gebraucht - es existiert keine Spalte D sonder nur DM
			
			if(oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo!='STD')
				strPartSQL += "AND abs(DM) = "+oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo+"";
			else{
				var oToleranz = getLagerToleranzObject();
				var dDM = ((oDlg.SollwerteRohrUmTeil.dDaemmDicke * 1) + (oDlg.SollwerteRohrUmTeil.strSelAussenDuMesserCombo * 1));
				//var oTolenzbereich = Base.buildToleranceValue((dDM*1),(oToleranz.dAussenDuMesserSonder*1));
				strPartSQL += "AND abs(DM) >= "+(dDM)+" ";
				//strPartSQL += "AND abs(DM) < "+(oTolenzbereich.dMaxValue)+" ";
			}
		}
		else{
			if(!oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder )
				strPartSQL += "AND abs(D) = "+oDlg.SollwerteRohrUmTeil.strSelAussenDuMesserCombo+"";
			else if(oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder ){
				//var oToleranz = Base.buildToleranceValue((oDlg.SollwerteRohrUmTeil.dAussenDuMesserSonder*1),getLagerToleranzObject().dAussenDuMesserSonder);
				strPartSQL += " AND abs(D) >= "+oDlg.SollwerteRohrUmTeil.dAussenDuMesserSonder+" ";
				//strPartSQL += " AND abs(D) <= "+oToleranz.dMaxValue+" ";
			}
		}
		
		if(oDlg.AuswahlStandard.bHoehenverstellbar){
			if ((oDlg.AuswahlStandard.dActualHeight - 0) > 0) {
				strPartSQL += " AND abs(H_MIN)<="+oDlg.AuswahlStandard.dActualHeight+" ";
				strPartSQL += " AND abs(H_MAX)>="+oDlg.AuswahlStandard.dActualHeight+" ";
			}
			/*	das muss hier nicht zustzlich geprft werden
			if ((oDlg.AuswahlStandard.dActualMass - 0) > 0) {
				strPartSQL += " AND abs(E_MIN)<="+oDlg.AuswahlStandard.dActualMass+" ";
				strPartSQL += " AND abs(E_MAX)>="+oDlg.AuswahlStandard.dActualMass+" ";
			}
			*/
		}
		
		if(!oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder && oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo == 'STD'
			&& oDlg.SollwerteRohrUmTeil.dDaemmDicke*1 > 0 && !oDlg.AuswahlStandard.bSonderAbMessung){
				// Sonder erstmal nicht betrachten -> die muessen ggf. bei "Test and Modify" raus
			// -Schu- Fehlinformation:
			// Aussendurchmesser / 2 + Dmmdicke ergibt minimale Hhe
			// var dBuildHeight = (oDlg.SollwerteRohrUmTeil.strSelAussenDuMesserCombo / 2) + (oDlg.SollwerteRohrUmTeil.dDaemmDicke * 1);
			// Korrekt:
			// minimale Hhe = Dmmdicke+30
			var dBuildHeight = (oDlg.SollwerteRohrUmTeil.dDaemmDicke * 1) + 30;
			strPartSQL += " AND (abs(NH) >= "+dBuildHeight+")";
		}
		
		return strPartSQL;
	}
	
	
	var aResult 		= new Array();	
	var strColumnLast	= "F_AUFL_ST";	
	var dRow			= 0;
	if (oDlg.AuswahlStandard.bSonderAbMessung){
		var strSql	= "SELECT * FROM " + (oDlg.AuswahlStandard.bHoehenverstellbar ? "S_GL_VH" : "S_GL_FH") +
						" WHERE abs(H_MIN) <= " + oDlg.AuswahlStandard.dHoehe1 + " AND abs(H_MAX) >= " + oDlg.AuswahlStandard.dHoehe1 +
						" AND abs(L_MIN) <= " + (oDlg.AuswahlStandard.dLaenge == "-" ? oDlg.AuswahlStandard.dLaengeSonder : oDlg.AuswahlStandard.dLaenge) +
						" AND abs(L_MAX) >= " + (oDlg.AuswahlStandard.dLaenge == "-" ? oDlg.AuswahlStandard.dLaengeSonder : oDlg.AuswahlStandard.dLaenge) +
						" AND abs(B_MIN) <= " + (oDlg.AuswahlStandard.dBreite == "-" ? oDlg.AuswahlStandard.dBreiteSonder : oDlg.AuswahlStandard.dBreite) +
						" AND abs(B_MAX) >= " + (oDlg.AuswahlStandard.dBreite == "-" ? oDlg.AuswahlStandard.dBreiteSonder : oDlg.AuswahlStandard.dBreite);
	}
	else
		var strSql 			= Lager.Search.getDefaultSQLGleitlager(oDlg,Lager.Search.getDBTableGleitlager(oDlg));
	if(strSql){	
		strSql		+= _buildDirection(oDlg,strSql);
		
		if(oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder || oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder){
			if(oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder || (rfind(strSql,"IKL")>0))
				strSql		+= " order by abs(D) ";
			else
				strSql		+= " order by abs(DM) ";
		}
		else
			strSql		+= " order by abs(SEQ_ID) ";
		
		logtraceln("Lagersuche Fuehrungslager: SQL - "+strSql);
		
		var aAllDBData  = Lager.Search.getSearchResultData('LAGER2',strSql);
		
		var dD_Default,dDM_Default;
		var bOK = true;
		var dResult = 0;
		var strError = '';
		
		var _setError = function(strValue){
			if(!strError)
				strError = strValue;
		}
	
		for(var a=0;a<aAllDBData.length;a++){
			if (oDlg.AuswahlStandard.bSonderAbMessung)
				aAllDBData[a]	= Base.updateTableSearchData(oDlg,aAllDBData[a],"SONDERLAGER");
			if( (a==0) && (oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder || oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder)){
				if(oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder || (rfind(strSql,"IKL")>0))
					dD_Default 	= aAllDBData[a].D;
				else
					dDM_Default = aAllDBData[a].DM;
			}
			else if( (a>0) && (oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder || oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder)){
				if(dD_Default){
					if(dD_Default != aAllDBData[a].D){
							bOK = false;
							_setError(translate("ERROR_AUSSENDURCHMESSER"));
						break;
					}
				}
				else if(dDM_Default){
					if(dDM_Default != aAllDBData[a].DM){
							bOK = false;
							_setError(translate("ERROR_MANTELDURCHMESSER"));
						break;
					}
				}
			}
			
			if(bOK){				
				var dD = (aAllDBData[a].D *1) / 2;
				var dH = (aAllDBData[a].NH *1);
				if (dH <= 40)	// nur unisoliert zulssig
					aAllDBData[a].dHdD = 0;
				else
					aAllDBData[a].dHdD = (dH-30);
				
				var oRet = Lager.Search.TestAndModify_Gleitlager(oDlg, aAllDBData[a]);
				if(oRet.bOk){ //build client Tabelle
					dResult +=1;
					for(var i = 0;i<oRet.dCopy;i++){
						setDataIntoLagerCacheObject('AuswahlStandard','TABLE',(oRet.oData));
					}
				}
				else
					_setError(oRet.oData.strError);
			}
		}	
	}
	return (strSql ? (dResult > 0 ? Lager.getClientTable(oDlg) : ['ERROR',strError]) : 'ERROR siehe Log');
}