/**
 * @category   Lager function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * Lager Typ: Fuehrungslager
 */
if ( typeof( Lager ) === 'undefined' )
	Lager = {};
if ( typeof( Lager.Search ) === 'undefined' )
	Lager.Search = {};
if ( typeof( Lager.Search.LagerTyp ) === 'undefined' )
	Lager.Search.LagerTyp = {};	

/**
 * Suchfunktion festlager
 * @param [oDlg]{Object}
 * @return {Array}
 */
Lager.Search.LagerTyp.Festlager = function(oDlg){	
	/**
	 * @private build direction for sql
	 */
	var _buildDirection = function(oDlg){
		var strPartSQL = '';
		
		if(oDlg.AuswahlStandard.bHoehenverstellbar){
			strPartSQL += " AND abs(H_MIN)<="+oDlg.AuswahlStandard.dActualHeight+" ";
			strPartSQL += " AND abs(H_MAX)>="+oDlg.AuswahlStandard.dActualHeight+" ";
			
			strPartSQL += " AND abs(E_MIN)<="+oDlg.AuswahlStandard.dActualMass+" ";
			strPartSQL += " AND abs(E_MAX)>="+oDlg.AuswahlStandard.dActualMass+" ";
		}
		
		//if(caMainController.getLagerTopologieklasse().getIsolierung() === 'ID_WAERMEGEDAEMMT'){
		if(caMainController.getLagerTopologieklasse().getIsolierung() !== 'ID_VORISOLIERT'){
			// 1/2 * RAD +Dmmdicke muss kleiner sein als Lagerhhe
			//var dBuildHeight = (oDlg.SollwerteRohrUmTeil.strSelNennweiteCombo / 2) + (oDlg.SollwerteRohrUmTeil.dDaemmDicke * 1);
			if(oDlg.AuswahlStandard.strSelRadioFixed == "KLEMMBAR")
				strPartSQL += " AND abs(NH)>="+(oDlg.SollwerteRohrUmTeil.dDaemmDicke*1 + 30)+"";
			else
				strPartSQL += " AND abs(NH)>="+(oDlg.SollwerteRohrUmTeil.dDaemmDicke*1 + 10)+"";
			if (oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder)
				// eigentlich sollte die Basis immer die nchst grere NW sein
				// strPartSQL += " AND abs(D) >= "+oDlg.SollwerteRohrUmTeil.dAussenDuMesserSonder+"";
				// in SAP ist das aber nicht -> so hier gilt D >= DN
				strPartSQL += " AND abs(DN) <= "+oDlg.SollwerteRohrUmTeil.dAussenDuMesserSonder+"";
			else
				strPartSQL += " AND abs(DN) = "+oDlg.SollwerteRohrUmTeil.strSelNennweiteCombo+"";
		}
		//else if((caMainController.getLagerTopologieklasse().getIsolierung() !== 'ID_WAERMEGEDAEMMT')){
		else if(caMainController.getLagerTopologieklasse().getIsolierung() === 'ID_VORISOLIERT'){
			//strPartSQL += " AND ((abs(H)+1) = 1)";		
			strPartSQL += " AND (D = '"+oDlg.SollwerteRohrUmTeil.strSelAussenDuMesserCombo+"')";
		}
		
		//Bestimme TrgerTyp
		if(oDlg.AuswahlStandard.strSelRadioFixed == "KLEMMBAR"){
			var strTrageArt = oDlg.AuswahlStandard.strSelComboBeamArt;
			var strKlemmTyp;
			if(	rfind(strTrageArt,"PROFIL")>0 ){
			
			}
			else{
				var dbName 		= 'LAGER';
				var dbNameTable = 'LAGER_TRAEGER';
				var sqlLager 	= "SELECT * FROM "+strTrageArt+" WHERE TRAE_GR like '"+oDlg.AuswahlStandard.strSelComboBeamSize+"'";
				var dTableDatenLength 	= dbselect( dbName, sqlLager, dbNameTable );	
				if ( dTableDatenLength > 0 ){
					while ( dbiseof( dbNameTable) == 0 ){
						strKlemmTyp = dbgetstring(dbNameTable,'VAR_KLEMM');
						dbskip( dbNameTable );
					}
				}			
			}
			
			if(strKlemmTyp){
				strPartSQL += " AND (TYP like '%"+strKlemmTyp+"%'";
				var strPartKlemmTyp = strKlemmTyp.substring(0,1);
				strPartSQL += " OR TYP like '%"+strPartKlemmTyp+"XXX%')";
			}
		}
		
		return strPartSQL;
	}
	
	var strSql 	= Lager.Search.getDefaultSQLGleitlager(oDlg,Lager.Search.getDBTableGleitlager(oDlg));
	if(strSql){
		if (oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder)
			strSql += _buildDirection(oDlg) + " order by abs(DN) ";
		else
			strSql += _buildDirection(oDlg) + " order by abs(SEQ_ID) ";
		
		var dbName		= 'LAGER2';
		var allDBData	= Lager.Search.getSearchResultData(dbName,strSql);
		var strError	= '';
		var dResult     = 0;
		for(var a = 0; a < allDBData.length; a++){
			var oRet 	= Lager.Search.TestAndModify_Festlager(oDlg, allDBData[a],strTable);
			// fr Sonderdurchmesser mssen die "zu kleinen" noch eliminiert werden
			if (oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder && oRet.bOk && (allDBData[a].DN*1 != allDBData[allDBData.length-1].DN*1 )){
				oRet.bOk	= false;
				strError	= translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
			}
			if(oRet.bOk){ //build client Tabelle
				dResult +=1;
				if (oDlg.AuswahlStandard.strSelRadioFixed == "SCHRAUBBAR")
					allDBData[a].dHdD = allDBData[a].NH *1 - 10;
				else
					allDBData[a].dHdD = allDBData[a].NH *1 - 30;
				for(var i = 0;i<oRet.dCopy;i++){
					setDataIntoLagerCacheObject('AuswahlStandard','TABLE',(oRet.oData));
				}
			}
			else{
				if(!strError)
					strError = oRet.oData.strError;
			}
		}
	}
	
	return  (strSql ? (dResult > 0 ? Lager.getClientTable(oDlg) : ['ERROR',strError]) : 'ERROR siehe Log');
}