/**
 * @category   Lager function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Lager ) === 'undefined' )
	Lager = {};
if ( typeof( Lager.Search ) === 'undefined' )
	Lager.Search = {};

/**
 * Einstiegspunkt fr Gleitlager.
 * Klemmsysteme werden nachtrglich bestimmt
 * @param [oDlg] {Object}
 * @param [oData] {Object}
 * @param [strTable] {String} bentigt falls unterschiedlich gefiltert werden muss
 */
Lager.Search.TestAndModify_Gleitlager = function(oDlg,oData, strWoher){
	if (!strWoher)
		strWoher	= "STANDARD";
	var dWerk_Faktor = Lager.Search.TestAndModify_WerkstoffFaktor(oDlg);
	var oRet = {};
	oRet.bOk = true;
	
	/*
	//bestimme Gleitelement
	oRet.dCopy	= 1;
	if((oDlg.AuswahlStandard.strSelComboSlidingPart != 'OHNE' && oDlg.AuswahlStandard.strSelComboSlidingPart != '-') 
		&& oDlg.AuswahlStandard.strSelComboAccessory == 'GLEITELEMENT' && oRet.bOk){
		
		if(oData.TYP_LGX){
			var oGleitelement = Gleitelement.Search.getSearchResult(oDlg, oData,'TYP_LGX');
		
			if(oGleitelement.strError)
				oRet.bOk = false;
			else
				oRet.dCopy = oGleitelement.aTableData.length;
		}
	}
	*/
	
	//bestimme Klemmsystem
	if(oDlg.AuswahlStandard.strSelComboAccessory == 'KLEMMBAR' && oRet.bOk){		
		// hole mgliche Tabellen oRet.oData.TYP_KS
		// nicht bei eFIN-Import -> KSY ist ggf. schon da und wird einzeln geprft
		if (strWoher != "eFIN"){
			var oTypKS	= Klemmsystem.Search.KlemmsystemTyp.holeKlemmsystemTyp(oDlg,oData);
			//if(oTypKS && (oData.BAU_F*1 < 24 || rfind(oData.TYP,"IKL") > 0) || oData.BAU_F*1 == 43)
			if(oTypKS && (oData.BAU_F*1 < 24 || oDlg.AuswahlStandard.strSelComboSlidingPart == "LGE" || rfind(oData.TYP,"IKL") > 0) || oData.BAU_F*1 == 43)
				setDataIntoLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE',(oTypKS));
			else{
				oRet.bOk = false;
				oRet.oData	= [];
				oRet.oData.strError	= translate("ERROR_KSY_N_MOEGLICH");
			}
		}
	}
	
	// fr LXL's auf PTFE nicht alle Hhen zulassen!
	if (((oDlg.AuswahlStandard.strSelComboSlidingPart != "OHNE" && oDlg.AuswahlStandard.strSelComboSlidingPart != '-') ||
		(oDlg.bLastKettePathSelection && left(oData.TYP,2) == "LX")) && (left(oData.TYP,2) == "LX")){	// LXL und LXF
		var MedTemp	= oDlg.SollwerteRohrUmTeil.dTemperaturMedium*1;
		if ((oData.WERKSTOFF*1 == 37 && oData.NH*1 < 143 && MedTemp > 210) ||
			(oData.WERKSTOFF*1 == 16 && oData.NH*1 < 203 && MedTemp > 370)){
			oRet.bOk	= false;
		}
	}
	
	// fr LKL nicht alle Hhen zulassen
	if (!oDlg.bLastKettePathSelection && oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_SPG"){
		if (((oDlg.SollwerteRohrUmTeil.dTemperaturMedium*1 > 100 || oDlg.SollwerteRohrUmTeil.dDaemmDicke*1 > 0) && oData.NH*1 <= 40)
			|| (oDlg.SollwerteRohrUmTeil.dTemperaturMedium*1 > 190 && oData.NH*1 <= 60))
			oRet.bOk	= false;
	}
	
	// Lager Typ 10 entweder LKL oder LKG anzeigen
	if ((oData.NH*1 <= 40 && left(oData.TYP, 3) == "LKL" && oDlg.AuswahlStandard.strSelRadioFunction == "GEFUEHRT")
		|| (oData.NH*1 <= 40 && left(oData.TYP, 3) == "LKG" && oDlg.AuswahlStandard.strSelRadioFunction != "GEFUEHRT"))
		oRet.bOk	= false;
	
	// in Abhngigkeit der Medietemperatur (ber 320C) nicht alle Hhen zulassen
	// prinipiell knnte man die auch aus der LagerDB lschen
	var isExpertMode		= getstring("EXPERT_MODE", "RIGHTS");	// fr ExpertMode zulassen
	//if ((oDlg.SollwerteRohrUmTeil.dTemperaturMedium*1 > 320) && (oData.NH*1 < oDlg.SollwerteRohrUmTeil.dTemperaturMedium*1/3)
	if ((oDlg.SollwerteRohrUmTeil.dTemperaturMedium*1 >= 270) && (oData.NH*1 < oDlg.SollwerteRohrUmTeil.dTemperaturMedium*1/2.5)
		&& (oData.WERKSTOFF*1 != 37) && !(isExpertMode*1))
		oRet.bOk	= false;
	
	// LSL NH 52 auf Traverse/Sttze nicht zulassen
	if (oDlg.bLastKettePathSelection && oData.NH*1 < 85 &&
		(oDlg.SollwerteRohrUmTeil.dTemperaturMedium*1 > 170 || oData.BAU_F*1 >= 23))
		oRet.bOk	= false;
	
	// Temperatur ber 650C nur im ExpertMode zulassen
	var strSQLStatement		= "select * from AUSLTEMPMAX where EXPERT = " + isExpertMode + " ";
	var numret				= dbselect("CASCADE", strSQLStatement, "TEMPMAX");
	if (numret){
		var ClampMaxTemp	= dbgetdouble("TEMPMAX", "MAXTEMPSCHELL");
		if (ClampMaxTemp < oDlg.SollwerteRohrUmTeil.dTemperaturMedium*1){
			oRet.bOk	= false;
			oRet.oData	= [];
			oRet.oData.strError	= translate("ERROR_RH_MEDIUMTEMP_GEDAEMMT");
		}
	}
	
	// Mehrfachfhrung kleiner DN40 nur 2-fach (2W / 2W+) zulassen
	if (((oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder && oDlg.SollwerteRohrUmTeil.dAussenDuMesserSonder*1 < 48.3)
					|| (!oDlg.SollwerteRohrUmTeil.bAussenDuMesserSonder && oDlg.SollwerteRohrUmTeil.strSelNennweiteCombo*1 < 40))
					&& oData.BAU_F*1 > 24){
						oRet.bOk	= false;
						oRet.oData	= [];
						oRet.oData.strError	= translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
	}
	
	// fr Sonder noch die Hhe prfen - bei Standard schon in Suche bercksichtigt
	if (oDlg.AuswahlStandard.bSonderAbMessung){
		var nHeight	= oDlg.SollwerteRohrUmTeil.dDaemmDicke*1 + 10;
		nHeight		+= (oDlg.AuswahlStandard.strSelRadioFunction == "GEFUEHRT" ? 20 : 0);
		var eHeight	= oDlg.AuswahlStandard.dHoehe1;
		if (oDlg.AuswahlStandard.strSelRadioFunction == "GEFUEHRT_MEHRFACH"){
			nHeight		+= (rfind(oDlg.AuswahlStandard.strSelComboFunction, "+") > 0 ? 20 : 0);
			var AnzSchlitten	= left(oDlg.AuswahlStandard.strSelComboFunction.replace("FUEHRUNG_",""), 1)*1;
			AnzSchlitten		= (AnzSchlitten > 4 ? 2 : AnzSchlitten);
			eHeight				= min(eHeight, oDlg.AuswahlStandard.dHoehe2);
			if (AnzSchlitten > 2)
				eHeight				= min(eHeight, oDlg.AuswahlStandard.dHoehe3);
			if (AnzSchlitten > 3)
				eHeight				= min(eHeight, oDlg.AuswahlStandard.dHoehe4);
		}
		if (nHeight > eHeight){
			oRet.bOk	= false;
			oRet.oData	= [];
			oRet.oData.strError	= translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
		}
	}
	
	if(!oRet.bOk)
		return oRet;
	
	//Allgemeiner Test 
	var oReturn 	= Lager.Search.TestAndModify(oDlg,oData,dWerk_Faktor,oDlg.AuswahlStandard.strSelComboGroundLevel, strWoher);
	
	if (oReturn.bOk){	// das Lager ist i.O. --> ggf. weitere Teile suchen und prfen
		oRet.dCopy	= 1;
		//bestimme Gleitelement (LGA und LGV fest zu Lager zugeordnet LGE suchen)
		if((oDlg.AuswahlStandard.strSelComboSlidingPart != 'OHNE' && oDlg.AuswahlStandard.strSelComboSlidingPart != '-')){ 
			// @@@ LGE TEST
			//&& oDlg.AuswahlStandard.strSelComboAccessory == 'GLEITELEMENT'){
			//if(oData.TYP_LGX){
				var oGleitelement = Gleitelement.Search.getSearchResult(oDlg, oData,'TYP_LGX');
				
				if(oGleitelement.strError)
					oRet.bOk = false;
				else
					oRet.dCopy = oGleitelement.aTableData.length;
			//}
		}
		//bestimme Abhebesicherung
		if((oDlg.AuswahlStandard.strSelComboAccessory == 'ABHEBESICHERUNG')
			|| (oDlg.AuswahlStandard.strSelComboAccessory == 'ABHEBESICHERUNG_4')){
			
			var oAbhebesicherung = Abhebesicherung.Search.getSearchResult(oDlg,oData,'LAGER');
			if(oAbhebesicherung.strError)
				oRet.bOk = false;
			else
				oRet.dCopy = oAbhebesicherung.aTableData.length;
		}
		//wenn die Zubehrteile scheitern nicht weitermachen
		if(!oRet.bOk)
			return oRet;
	}
	
	oReturn.dCopy 	= oRet.dCopy;
	
	return (oReturn);
}

/**
 * Einstiegspunkt Festlager
 * Klemmsystem wird automatisch mit erzeugt und die Ergebnistabelle damit aufgefllt
 * @param [oDlg] {Object}
 * @param [oData] {Object}
 * @param [strTable] {String} bentigt falls unterschiedlich gefiltert werden muss
 */
Lager.Search.TestAndModify_Festlager = function(oDlg,oData,strDBTable, strWoher){
	if (!strWoher)
		strWoher	= "STANDARD";
	
	var oRet = {
		'bOk' 	: true,
		'dCopy' : 1,
		'oData' : oData
	}
	
	var dWerk_Faktor 	= Lager.Search.TestAndModify_WerkstoffFaktor(oDlg);
	
	//bestimme Klemmsystem
	if(oDlg.AuswahlStandard.strSelRadioFixed == 'KLEMMBAR' && oRet.bOk){ //aktuell sind die Klemmsysteme mit im Festlager integriert	
		//hole mgliche Tabellen oRet.oData.TYP_KS
		if (strWoher != "eFIN"){
			var oTypKS = Klemmsystem.Search.KlemmsystemTyp.holeKlemmsystemTyp(oDlg,oData);
			if (oTypKS)
				setDataIntoLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE',(oTypKS));
		}
		
		//es gibt nur T Trger also braucht man hier nur die Gre rest ist egal
		//var strSize = oDlg.AuswahlStandard.strSelComboBeamSize;
		var strSize = oDlg.AuswahlStandard.dBeamWidth;
		// Typ 23 erst ab BTr >= 100mm zulassen
		if (strSize*1 < 100 && oData.BAU_F*1 > 22){
			oRet.bOk	= false;
			oRet.oData	= [];
			return (oRet);
		}
		if(strSize == "100 - 140" || (strSize*1)<=140)
			strSize = "T140";
		else
			strSize = "T"+strSize;
			
		var strNewTyp = oRet.oData.TYP;
		strNewTyp = strNewTyp.replace("TXXX",strSize);
		
		oRet.oData.TYP_CALCULATION = strNewTyp; 	
		
		// wenn in der Tabelle keine realen Lasten vorgegeben wurden, mssen ggf. noch die zul. Lasten korrigiert werden
		if ((!oDlg.SollwerteHalterungspunkt.oTable.last_minus.axial && !oDlg.SollwerteHalterungspunkt.oTable.last_minus.axial) &&
				(oRet.oData.F_AXIAL_KSY * 1 < oRet.oData.F_AXIAL * dWerk_Faktor) )
				oRet.oData.F_AXIAL = oRet.oData.F_AXIAL_KSY * 1 / dWerk_Faktor;
		if ((!oDlg.SollwerteHalterungspunkt.oTable.last_minus.quer && !oDlg.SollwerteHalterungspunkt.oTable.last_minus.quer) &&
				(oRet.oData.F_QUER_KSY * 1 < oRet.oData.F_QUER * dWerk_Faktor) )
				oRet.oData.F_QUER = oRet.oData.F_QUER_KSY * 1 / dWerk_Faktor;
		if ((!oDlg.SollwerteHalterungspunkt.oTable.last_plus.schief) &&
				(oRet.oData.F_AB_KSY * 1 < oRet.oData.F_AB * dWerk_Faktor) )
				oRet.oData.F_AB = oRet.oData.F_AB_KSY * 1 / dWerk_Faktor;
	}
		
	var oResult	= Lager.Search.TestAndModify(oDlg,oRet.oData,dWerk_Faktor,oDlg.AuswahlStandard.strSelComboGroundLevel);
	
	if(!oResult.dCopy)
		oResult.dCopy 	= 1;
	
	return (oResult);
}

/**
 * Einstiegspunkt Rollenlager
 * Test and Modify
 * @param [oDlg] {Object}
 * @param [oData] {Object}
 */
Lager.Search.TestAndModify_Rollenlager = function(oDlg,oData){
	var oRet = {
		'bOk' 	: true,
		'dCopy' : 1,
		'oData' : oData
	}
	
	// Prfung und Korrektur der zulssigen Auflagelast bezglich der Buchsentemperatur am RL
	if (oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_SYROLLSA"){
		var KorrTemp	= 1;
		var oTempSatRL	= Lager.isRollenlager_Werkstoff_PA(oDlg.SollwerteRohrUmTeil,oDlg.AuswahlSattel.oSearchResult.oResultSattel);
		
		if (oTempSatRL.RLTemp*1 > 150 && oTempSatRL.RLTemp*1 <= 250)
			// y = -0,0033x + 1,4982
			KorrTemp	= -0.0033*oTempSatRL.RLTemp + 1.4982;
		else if (oTempSatRL.RLTemp > 250)
			// y = -0,0056x + 2,074
			KorrTemp	= -0.0056*oTempSatRL.RLTemp + 2.074;
		
		oData.F_AUFL	= fround(oData.F_AUFL * KorrTemp, 1);
	}
	
	// zulssige Querkraft bei RDF/RKF
	if (oData.F_QUER_MAX){
		var dFquer			= max(abs(oDlg.SollwerteHalterungspunkt.oTable.last_minus.quer),abs(oDlg.SollwerteHalterungspunkt.oTable.last_plus.quer));
		var dFquerZUL		= abs(oDlg.SollwerteHalterungspunkt.oTable.last_minus.schief) * 0.35;
		var dFquerZUL_MAX	= (dFquerZUL > 0 ? dFquerZUL : oData.F_QUER_MAX * 0.35); // ausschluss "0" -> nichts eingegeben
		if (dFquer > dFquerZUL_MAX){
			oRet.bOk	= false;
			oRet.oData.strError	= translate("ERROR_QUERKRAFT_RL");
		}
	}
	// Prfung des Auflagedurchmessers und Korrektur der zulssigen Auflagelast
	if (oData.DA_MIN){
		var DA_MIN	= (oData.DA_MIN)*1;
		var DA_MAX	= (oData.DA_MAX)*1;
		var DA_MITTEL	= (DA_MIN + DA_MAX)/2;
		if (oDlg.AuswahlSattel.oSearchResult.oResultSattel)
			var DA		= (oDlg.AuswahlSattel.oSearchResult.oResultSattel.DA)*1;
		else
			var DA		= (oDlg.AuswahlRollenlager.dSupportDiameter)*1;
		if ((DA < DA_MIN) || (DA > DA_MAX)){
			oRet.bOk	= false;
			oRet.oData.strError	= translate("ERROR_AUFLAGEDURCHMESSER");
		}
		if (oRet.bOk && left(oData.TYP, 2) != "RK"){
			var ProzFaufl	= 100 - (30 * abs(DA - DA_MITTEL) / (DA_MAX - DA_MITTEL));
			oData.F_AUFL	= fround(ProzFaufl / 100 * oData.F_AUFL, 1);
			if (oData.F_AUFL < abs(oDlg.SollwerteHalterungspunkt.oTable.last_minus.schief)){
				oRet.bOk	= false;
				oRet.oData.strError	= translate("ERROR_KRAFT");
			}
		}
	}
	
	// Prfung der Fussbreite bei Zylinder-RL
	var isZylinderRL	= ((oDlg.AuswahlSattel.bActuator || oDlg.AuswahlRollenlager.strSelComboTyp == "ZYLINDER") ? true : false);
	if (isZylinderRL){
		var FussBreit	= (oDlg.AuswahlSattel.bActuator ? oDlg.AuswahlSattel.oSearchResult.oResultSattel.A*1 : oDlg.AuswahlRollenlager.dFeetWide*1);
		var RolleBreit	= oData.L*1;
		var isGefuehrt	= (oDlg.AuswahlRollenlager.strSelRadioRollerBearing == "GEFUEHRT" ? true : false);
		//if (FussBreit > RolleBreit || (isGefuehrt && min((RolleBreit-FussBreit)/2,(oData.W-oData.S_STEG)/2)-((FussBreit-oData.S_STEG)/2) >= 0)){
		if (FussBreit > RolleBreit || (isGefuehrt && (oData.W - FussBreit >= 0))){
			oRet.bOk	= false;
			oRet.oData.strError	= translate("ERROR_FUSSBREITE");
		}
	}
	// fr Klemmsysteme fr Rollenlager noch Fab korrikgieren
	if ((oDlg.Systemcharakteristik.strSelZubehoerComboLager == "KR" || 
		(oDlg.AuswahlSattel.bUpliftRestraint && oDlg.AuswahlRollenlager.strSelRadioFunction != "SCHRAUBBAR")) &&
			oDlg.AuswahlStandard.dBeamWidth*1 > 140)
	{
		var F_AB_KS = fround((6/1.5)*pow(10,7)*pow((oDlg.AuswahlStandard.dBeamWidth*1),(-3.0135)), 1);
		if (oData.F_AB == "-" || F_AB_KS < oData.F_AB)
			oData.F_AB = F_AB_KS;
		if (oData.F_AB < abs(oDlg.SollwerteHalterungspunkt.oTable.last_plus.schief)){
			oRet.bOk	= false;
			oRet.oData.strError	= translate("ERROR_KRAFT_KLEMMSYSTEM");
		}
	}
	// fr AHS noch Fab korrikgieren
	if (oDlg.AuswahlSattel.bUpliftRestraint && oData.F_AB_AHS != "-"){
		var F_AB_AHS = fround(oData.F_AB_AHS * 300 / oDlg.AuswahlSattel.strSelComboLength, 1);
		if (oData.F_AB == "-" || F_AB_AHS < oData.F_AB)
			oData.F_AB = F_AB_AHS;
		if (oData.F_AB < abs(oDlg.SollwerteHalterungspunkt.oTable.last_plus.schief)){
			oRet.bOk	= false;
			oRet.oData.strError	= translate("ERROR_KRAFT_ABHEBESICHERUNG");
		}
	}
	
	if(!oRet.bOk)
		return oRet;
	
	oData.PREIS_Tab = Base.getPrice(oData.PREIS);
	var dWerk_Faktor 	= 1;
	var oTestResult	= Base.TestAndModify(oDlg,oData,dWerk_Faktor);
	oRet.bOk 		= oTestResult.bOk;
	oRet.oData		= oTestResult.oData;
	
	return oRet;
}


Lager.Search.TestAndModify_WerkstoffFaktor = function(oDlg){
	// Bestimmung der Referenztemperatur
	// dTemp <= 350C und dTemp >= 40C : dRefTemp = dTemp - 20
	// dTemp >= 40C da es ab 20C die ersten Abminderungsfaktoren gibt (1.4541)
	var dRefTemp = oDlg.SollwerteRohrUmTeil.dTemperaturMedium;
	if (oDlg.SollwerteRohrUmTeil.dTemperaturMedium <= 350 && oDlg.SollwerteRohrUmTeil.dTemperaturMedium >= 40)
		dRefTemp	= oDlg.SollwerteRohrUmTeil.dTemperaturMedium - 20;
	
	var dWerk_Faktor		= 1; 	//Vorgabewert fr dWerkstoffNumber = 37
	
	//aktuelle Auslegungsmethode analog zu Schellen Faktor auch fr RSt bestimmen
	
	var dWerkstoffNumber 	= Lager.getWerkstoffeNumber(oDlg);
	
	//teste Werkstoffwerte gegen Werte der Datenbank und berechne Werkstoffaktor
	
	if (( dWerkstoffNumber == 37 ) && ( dRefTemp > 80 )){
		dWerk_Faktor = (-4)*pow(10,-6)*pow(dRefTemp,2)+
						8*pow(10,-5)*dRefTemp+
						0.9081;
	}
	else if ( dWerkstoffNumber == 16 ){
		if ( dRefTemp < 480 )
			dWerk_Faktor = 11.122609 * pow ( dRefTemp, -0.468394 );
		else 
			dWerk_Faktor = 2.0149 * pow( 10, 29 ) * pow ( dRefTemp, -11.0101 );
	}
	else if ( dWerkstoffNumber == 13 ){
		if ( dRefTemp < 480 )
			dWerk_Faktor = -0.0003333 * dRefTemp + 0.91;
		else 
			dWerk_Faktor = 1.57895 * pow( 10, -6 ) * pow( dRefTemp, 3 ) - 2.404887 * pow( 10, -3 ) * 
		
		pow( dRefTemp, 2 ) + 1.2111353 * dRefTemp - 201.125;
	}
	else if ( dWerkstoffNumber == 10 ){
		dWerk_Faktor = 1.9145297 * pow( 10, 21 ) * pow( dRefTemp, -7.9688 );
	}
	else if (( dWerkstoffNumber == 41 ) || ( dWerkstoffNumber == 43 )){
		dWerk_Faktor = 0.000001 * pow( dRefTemp, 2 ) - 0.0013 * dRefTemp + 0.9992;
	}
	else if ( dWerkstoffNumber == 71 ){
		dWerk_Faktor = 0.000001 * pow( dRefTemp, 2 ) - 0.0015 * dRefTemp + 1.0644;
	}
	else if ( dWerkstoffNumber == 80 ){
		if ( dRefTemp <= 600 )
			dWerk_Faktor = 0.4;
		else
			dWerk_Faktor = 0.00000390036 * pow( dRefTemp, 2 ) - 0.007 * dRefTemp + 3.1577;
	}
	else if ( dWerkstoffNumber == 91 ){
		dWerk_Faktor = 0.00002075 * pow( dRefTemp, 2 ) - 0.029887 * dRefTemp + 10.847;
	}
	else if ( dWerkstoffNumber == 78 ){
		dWerk_Faktor = 3.4 * pow( 10, 17 ) * pow( dRefTemp;, -6.5205 );
	}
		
	// Logik ab Baukasten 2023 zul Lasten bezogen auf 300C S235 JR ("37")
	var LG_2023_exists	= false;
	if(getstring("IDC_RADIO_LG_ALT_NEU","PROJECT.SETTINGS.CASCADE") != "") // Feld existiert - Suche in neuer Tabelle
		LG_2023_exists	= true;
	
	if(LG_2023_exists){
		// in FN bercksichtigt K(T)=0,58
		// 1.0038	-	300C
		// 1.5415	-	480C
		// 1.7335	-	500C
		// 1.7380	-	500C
		// 1.4903	-	565C
		// 1.4541	-	550C
		// 1.4878	-	550C
		// 1.4958	-	200C
		// max. Erhhung Faktor 1,25 (S235 JR bei 300C / SN bzw. Steg auerhalb Dmmung)
		if (dWerk_Faktor <= 0.83)
			dWerk_Faktor = dWerk_Faktor + 0.42;
		else
			dWerk_Faktor = 0.83 + 0.42;	// 1,25
	}
	
	return dWerk_Faktor;
}

/**
 * Test und abndern der Werte fr 1 Suchergebnis - Haupttest -
 * @param [oDlg] {Object}
 * @param [oData]{Object} Daten aus der Tabelle zur berprfung
 * @return {Object} oData
 */
Lager.Search.TestAndModify = function(oDlg,oData,dWerk_Faktor,dObfl,strWoher){
	if (!strWoher)
		strWoher	= "STANDARD";
	var bOk		= true;
	//Temperatur
	if(oDlg.SollwerteRohrUmTeil.dTemperaturMedium > 450 && strWoher != "eFIN"){
		//if(caMainController.getLagerTopologieklasse().isGleitlager() && oDlg.AuswahlStandard.strSelComboAccessory	== 'KLEMMBAR')
		if(oDlg.Systemcharakteristik.strSelRadioLager != "LAGER_FS" && oDlg.AuswahlStandard.strSelComboAccessory	== 'KLEMMBAR')
			bOk = false;
		//else if(caMainController.getLagerTopologieklasse().isFestlager() && oDlg.AuswahlStandard.strSelRadioFixed	== 'KLEMMBAR')
		else if(oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && oDlg.AuswahlStandard.strSelRadioFixed	== 'KLEMMBAR')
			bOk = false;
		else if((oDlg.Systemcharakteristik.strSelRadioLager == 'LAGER_ROLL') || (oDlg.Systemcharakteristik.strSelRadioLager == 'LAGER_SAROLL'))	{
			if(oDlg.AuswahlRollenlager.strSelRadioFunction	== 'KLEMMBAR')
				bOk = false;
		}
	}
	else if(oDlg.SollwerteRohrUmTeil.dTemperaturMedium > 450 && strWoher == "eFIN" && !oDlg.bLastKettePathSelection){
		if(oDlg.Systemcharakteristik.strSelRadioLager != "LAGER_FS" && oDlg.AuswahlStandard.strSelComboAccessory	== 'KLEMMBAR')
			bOk = false;
		else if(oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && oDlg.AuswahlStandard.strSelRadioFixed	== 'KLEMMBAR')
			bOk = false;
	}
	
	if(!bOk){
		oData.strError	= "ERROR_KSY_TEMP";
		return {'bOk' : bOk, 'oData' : oData};
	}
	
	var oTestResult	= Base.TestAndModify(oDlg,oData,dWerk_Faktor);
	bOk		 		= oTestResult.bOk;
	oData			= oTestResult.oData;
	oData.strError	= oTestResult.strError;
	
	if(!bOk)
		return {'bOk' : bOk, 'oData' : oData};
	
	//- 05.12.2011 Tel.: GEW auf zwei Stellen nach den Komma Runden
	if(oData.GEW)
		oData.GEW = Math.round(oData.GEW*100) / 100;	
	
	//- 10.01.2012 nderung am Typ und Preis Berechnung in Abhngigkeit zur Oberfl.
	var strTyp = 'TYP';
	if(oData.TYP_CALCULATION)
		strTyp = 'TYP_CALCULATION';
		
	if(abs(oData[strTyp].indexOf('.X'))>0){
		oData[strTyp] = oData[strTyp].replace('.X','.'+dObfl);
		oData[strTyp] = oData[strTyp].replace('.x','.'+dObfl);
		if(dObfl>0 && dObfl != 4){ //Preis korrektur
			oData.PREIS = ((Base.buildPreisOberflaeche({'dOberflaeche' : dObfl}, oData).dNewPrice < 0) ? 0 : Base.buildPreisOberflaeche({'dOberflaeche' : dObfl}, oData).dNewPrice);	// ohne Rabatt
			oData.PREIS_Tab = Base.getPrice(Base.buildPreisOberflaeche({'dOberflaeche' : dObfl}, oData).dNewPrice);		// Preis mit Rabatt
		}
		else{	// -Schu- ist das wirklich richtig?
			oData.PREIS		= (((oData.PREIS_0 < 0) || (oData.PREIS_0 == '-') ) ? 0 : oData.PREIS_0);
			oData.PREIS_Tab = Base.getPrice(((dObfl == 4) ? -1 : oData.PREIS_0));
		}		
	}
	
	return {'bOk' : bOk, 'oData' : oData};
};