/**
 * @category   Lager function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Lager ) === 'undefined' )
	Lager = {};
if ( typeof( Lager.Search ) === 'undefined' )
	Lager.Search = {};

/**
 * Einstiegsfunktion zur Suche von Lagern
 * @param [oDlg]{Object}
 * @param [strDialog] {String} 
 */
Lager.Search.getSearchResult = function(oDlg,strDialog){
	var myData;
	var oResult = {};
	
	if(strDialog == 'lager.auswahl-standard'){ 
		switch(oDlg.Systemcharakteristik.strSelRadioLager){
			case 'LAGER_SPG' :
			case 'LAGER_EPG' :
			case 'LAGER_SSG' :		
					if(oDlg.AuswahlStandard.strSelRadioFunction == 'LOSE'
						|| oDlg.bLastKettePathSelection*1)
						myData = Lager.Search.LagerTyp.Loslager(oDlg);
					else if(oDlg.AuswahlStandard.strSelRadioFunction == 'GEFUEHRT')
						myData = Lager.Search.LagerTyp.Fuehrungslager(oDlg);
					else 
						myData = Lager.Search.LagerTyp.FuehrungslagerMehrfach(oDlg);
				//breakpoint();
				break;
			case 'LAGER_FS' :
					myData = Lager.Search.LagerTyp.Festlager(oDlg);
				break;
		}		
	}
	else if(strDialog == "ROLLENLAGER_P" || strDialog=="ROLLENLAGER_S"){
		myData = Lager.Search.LagerTyp.Rollenlager(oDlg,strDialog);
	}
	
	if(myData.length == 2){
		try{
			if(myData[0] == 'ERROR' && myData[1] != '')
				oResult.Error = myData[1];
			else if(myData[0] == 'ERROR')
				oResult.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
			else
				oResult.aTableData = myData;
		}
		catch(err){}
	}
	else if(myData.length == 0)
		oResult.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
	else{	
		oResult.aTableData = myData;
	}
	
	return oResult;
}

/**
 * bestimme Tabellen Namen in der Datenbank fr Gleitlager
 * @param [oDlg]{Object}
 * @return {String}
 */
Lager.Search.getDBTableGleitlager = function(oDlgLagerSession){
	var sqlString; 
	if(caMainController.getLagerTopologieklasse().isGleitlager())
		sqlString	= Lager.Search._getSQL_AUSLEGUNG_GLEIT_FEST_LAGER(oDlgLagerSession);
	else if(caMainController.getLagerTopologieklasse().isFestlager()){
		sqlString	= "SELECT * FROM AUSLEGUNG_GLEIT_FEST_LAGER WHERE LAGER_TYP ='"+oDlgLagerSession.Systemcharakteristik.strSelRadioLager+"'";
		sqlString  += (caMainController.getLagerTopologieklasse().getIsolierung() == 'ID_VORISOLIERT') ? " AND VORISOLIERT = 'true' " : " AND VORISOLIERT = 'false'" ;
		sqlString  += " AND HOEHENVERSTELLBAR = '"+(oDlgLagerSession.AuswahlStandard.bHoehenverstellbar ? 'true' : 'false')+"'";
		
		if(oDlgLagerSession.AuswahlStandard.strSelRadioFixed == 'KLEMMBAR'){
			sqlString  += " AND SCHRAUBBAR_EINFACH = 'false'";
			sqlString  += " AND SCHRAUBBAR_DOPPELT = 'false'";
		}
		else if(oDlgLagerSession.AuswahlStandard.strSelRadioFixed == 'SCHRAUBBAR'){
			if(oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn	== "EINFACH"){
				sqlString  += " AND SCHRAUBBAR_EINFACH = 'true'";
				sqlString  += " AND SCHRAUBBAR_DOPPELT = 'false'";
			}
			else if(oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn == "DOPPELT"){
				sqlString  += " AND SCHRAUBBAR_EINFACH = 'false'";
				sqlString  += " AND SCHRAUBBAR_DOPPELT = 'true'";
			}
		}
		
		sqlString  += " AND LAGERART like '-'";
		sqlString  += " AND GLEITUNTERLAGE like '-'";
		sqlString  += " AND KLEMMSYSTEM like '-'";
	}
	
	var dbName 		= 'LAGER2';
	var dbNameTable = "AUSLEGUNG_GLEIT_FEST_LAGER_TABLE";
	var strTable	= '';
	
	var dSearchResult = dbselect( dbName, sqlString, dbNameTable );
	if ( dSearchResult > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			var strLagerReihe = dbgetstring(dbNameTable,"LAGERREIHE");
			if(strLagerReihe != '???' && strLagerReihe.length == 3){
				strTable = strTable ? strTable+','+dbgetstring(dbNameTable,"LAGERREIHE") : dbgetstring(dbNameTable,"LAGERREIHE");
			}
			else if(strLagerReihe != '???'){
				strTable +=dbgetstring(dbNameTable,"LAGERREIHE").replace("/",",");				
			}
			dbskip( dbNameTable );
		}
	}
	
	/*
	if(oDlgLagerSession.bLastKettePathSelection){
		var oForms			= Base.Store.getForms();
		var strHaengertyp 	= oForms.AUSWAHL_HAENGERTYP.IDC_IMAGE_ID;
		
		if((rfind(strTable,'LSL')>0) &&  (strHaengertyp == 'KSP') )
			strTable = strTable.replace('LSL','LXL');
	}
	*/
	return strTable;
};


/**
 * erstelle default sql anweisung fr Gleitlager
 * @param [oDlgLagerSession] {Object}
 * @param [strTable] {String}
 * @return {String}
 */
Lager.Search.getDefaultSQLGleitlager = function(oDlgLagerSession,strTable){
	var aSplitTable = strTable.split(',');
	var strTable;
	var strTyp;
	
	for(var a=0;a<aSplitTable.length;a++){
		if(aSplitTable[a].length == 3 && (rfind(strTable,aSplitTable[a])<0))
			strTable = strTable ? strTable+","+aSplitTable[a] : aSplitTable[a];
		else if(aSplitTable[a].length > 3){
			var strLeftSide 	= aSplitTable[a].substring(0,3);
			var strRigthSide 	= aSplitTable[a].substring(3,aSplitTable[a].length);
			
			if(rfind(strTable,strLeftSide)<0)
				strTable = strTable ? strTable+","+strLeftSide : strLeftSide;
			strRigthSide = strRigthSide.replace("x","%");
			
			strTyp = strTyp ? strTyp+(" OR TYP like '"+strLeftSide+" "+strRigthSide+".%'")	: (" TYP like '"+strLeftSide+" "+strRigthSide+".%'");
		}	
	}
	
	var LG_2023_exists	= false;
	
	if(getstring("IDC_RADIO_LG_ALT_NEU","PROJECT.SETTINGS.CASCADE") != ""){ // Feld existiert - Suche in neuer Tabelle
		strTable		+= "_2023";
		LG_2023_exists	= true;
	}
	
	if(rfind(strTable,",")<0){
		var sqlString = "SELECT * FROM "+strTable+" WHERE ";
		var sqlPartString;
		
		if(strTyp)
			sqlPartString = sqlPartString ? sqlPartString+' AND ('+strTyp+')' : '('+strTyp+')';
		
		sqlPartString = sqlPartString ? sqlPartString+" AND WERKSTOFF = "+ Lager.getWerkstoffeNumber(oDlgLagerSession) +" " : " WERKSTOFF = "+ Lager.getWerkstoffeNumber(oDlgLagerSession) +" ";
		
		//if(strTable == 'LSL'){
		if (rfind(strTable, "LSL") > 0){
			var strStandard = " ST_ST = 'x' ";
			if(oDlgLagerSession.AuswahlStandard.bGaT)
				strStandard = " GP_TR = 'x' ";
			
			sqlPartString += sqlPartString ? " AND "+strStandard : strStandard;
		}
		
		if (false){	// TODO Checkbox fr alle Varianten zeigen
		
		}
		// es sollen alle gezeigt werden "alte" und "neue" Bauhoehen
		/*
		else if(!LG_2023_exists || rfind(getstring("IDC_RADIO_LG_ALT_NEU","PROJECT.SETTINGS.CASCADE"), "NEU")<0)
			sqlPartString	+= sqlPartString ? " AND IS_STD = '1' " : " IS_STD = '1' ";
		else
			sqlPartString	+= sqlPartString ? " AND IS_STD_2023 = '1' " : " IS_STD_2023 = '1' ";
		*/
		else{
			sqlPartString	+= sqlPartString ? " AND ( IS_STD = '1' " : " ( IS_STD = '1' ";
			sqlPartString	+= " OR IS_STD_2023 = '1' ) ";
		}
		
		sqlString += sqlPartString ? sqlPartString : '';
		
		return sqlString;
	}
	else{
		logtraceln("FEHLER: lager.search.common - mehrere Tabellen sollen hier verarbeitet werden - "+strTable)
		return false;
	}
}

/**
 * erstelle default sql anweisung fr Rollenlager
 * @param [oDlgLagerSession] {Object}
 * @param [strTable] {String}
 * @return {String}
 */
Lager.Search.getDefaultSQLRollenlager = function(oDlg,strDialog){
	var strTable;
	var _getTable = function(oDlg){
		var __getLoseOrGefuehrt = function(){
			if(oDlg.AuswahlRollenlager.strSelRadioRollerBearing	== 'LOSE')
				return ("AND LOSE ='true' ");
			else
				return ("AND GEFUEHRT = 'true' ");
		}
	
		var __getKlemmbarOrSchraubbar = function(){
			if(oDlg.AuswahlRollenlager.strSelRadioFunction	== 'KLEMMBAR')
				return ("AND KLEMMBAR = 'true' ");
			else
				return ("AND SCHRAUBBAR = 'true' ");
		}
		
		var __getAbhebesicherung = function(oDlg){
			var bUpliftRestraint = oDlg.AuswahlSattel.bUpliftRestraint;
			var bSattel			= (oDlg.Systemcharakteristik.strSelRadioLager == 'LAGER_SYROLLSA');
			if(!bSattel && oDlg.AuswahlRollenlager.bUpliftRestraint)
				return ("AND ABHEBSICHERUNG = 'true' ");
			else if(bSattel && bUpliftRestraint)
				return ("AND ABHEBSICHERUNG = 'true' ");
			else	
				return ("AND ABHEBSICHERUNG = 'false' ");
		}
		
		var sqlString = "SELECT * FROM AUSLEGUNG_ROLLEN_LAGER WHERE ";
			sqlString += "VORISOLIERT ='false' "; //wir whlen hier nur ein Rollenlager, von daher kann dieses angesetzt werden
			sqlString += "AND LAGERART = '"+oDlg.AuswahlRollenlager.strSelComboTyp+"' ";
			sqlString += __getLoseOrGefuehrt();
			sqlString += __getKlemmbarOrSchraubbar();
			sqlString += __getAbhebesicherung(oDlg);
			
		var aRowData = 	Object.fromDatabase('LAGER2',sqlString);
		
		return aRowData[0].TYPENREIHE;
	}
	
	strTable = _getTable(oDlg); //Hier kommt genau eine Tabelle raus (jetziger Aufbau 2011)
	
	var sqlString = "SELECT * FROM "+strTable;
	/*
	if(oDlg.AuswahlRollenlager.strSelComboTyp	== 'ZYLINDER' && (oDlg.AuswahlRollenlager.dFeetWide*1 > 0) && strTable == "RZG"){
		var oToleranz = getLagerToleranzObject();
		var oToleranzData = Base.buildToleranceValue((oDlg.AuswahlRollenlager.dFeetWide*1),oToleranz.dFeetWide);
		
		sqlString += " WHERE L >= "+oToleranzData.dMinValue+" AND L <= "+oToleranzData.dMaxValue;
	}
	else if(oDlg.AuswahlRollenlager.strSelComboTyp	== 'ZYLINDER' && (oDlg.AuswahlRollenlager.dFeetWide*1 > 0) && strTable == "RZL"){
		var oToleranz = getLagerToleranzObject();
		var oToleranzData = Base.buildToleranceValue((oDlg.AuswahlRollenlager.dFeetWide*1),oToleranz.dFeetWide);
		
		sqlString += " WHERE L >= "+oToleranzData.dMinValue+" AND L <= "+oToleranzData.dMaxValue;
	}
	else*/ if(oDlg.AuswahlRollenlager.dSupportDiameter*1 > 0){
		var oToleranz 		= getLagerToleranzObject();
		var oToleranzData 	= Base.buildToleranceValue((oDlg.AuswahlRollenlager.dSupportDiameter*1),oToleranz.dSupportDiameter);
		
		//sqlString += " WHERE abs(DA_MIN) <= "+oToleranzData.dMinValue+" AND abs(DA_MAX)>= "+oToleranzData.dMaxValue;
		sqlString += " WHERE abs(DA_MIN) <= "+(oDlg.AuswahlRollenlager.dSupportDiameter*1)+" AND abs(DA_MAX)>= "+(oDlg.AuswahlRollenlager.dSupportDiameter*1)+" ";
	}
	
	return sqlString;
}

/**
 * lies Werte aus der Datenbank
 * @param [dbName] {Datenbank}
 * @param [sqlString] {String} 
 * @retun {Object}
 */
Lager.Search.getSearchResultData = function(dbName,sqlString){
	return (Object.fromDatabase(dbName,sqlString));
}

/**
 * @private Diese Funktion soll nur hier (in diesem File) angsprochen werden (wird also als private function behandelt)
 */
Lager.Search._getSQL_AUSLEGUNG_GLEIT_FEST_LAGER = function(oDlgLagerSession){
	var sqlString	= "SELECT * FROM AUSLEGUNG_GLEIT_FEST_LAGER WHERE LAGER_TYP ='"+oDlgLagerSession.Systemcharakteristik.strSelRadioLager+"'";
		sqlString  += (caMainController.getLagerTopologieklasse().getIsolierung() == 'ID_VORISOLIERT') ? " AND VORISOLIERT = 'true' " : " AND VORISOLIERT = 'false'" ;
	
	if(!caMainController.getLagerTopologieklasse().isFestlager()){
		switch(oDlgLagerSession.AuswahlStandard.strSelRadioFunction){
			case "LOSE" :
					sqlString += " AND LAGERART like 'LOSLAGER' ";
				break;	
			case "GEFUEHRT"	:
					sqlString += " AND LAGERART like 'FUEHRUNGSLAGER' ";
				break;
			case "GEFUEHRT_MEHRFACH" :
					sqlString += " AND LAGERART like '"+oDlgLagerSession.AuswahlStandard.strSelComboFunction+"' ";
				break;	
		}
	}
	
	if(!caMainController.getLagerTopologieklasse().isFestlager())
		sqlString += " AND GLEITUNTERLAGE 	='"+(oDlgLagerSession.AuswahlStandard.bGaT ? 'true' : 'false')+"' ";
	
	sqlString += " AND HOEHENVERSTELLBAR ='"+(oDlgLagerSession.AuswahlStandard.bHoehenverstellbar ? 'true' : 'false')+"' ";
	
	if(caMainController.getLagerTopologieklasse().isFestlager() && oDlgLagerSession.AuswahlStandard.strSelRadioFixed	== "KLEMMBAR"){
		sqlString += " AND SCHRAUBBAR_EINFACH = 'false' ";
		sqlString += " AND SCHRAUBBAR_DOPPELT = 'false' ";
	}
	else if(caMainController.getLagerTopologieklasse().isFestlager() && oDlgLagerSession.AuswahlStandard.strSelRadioFixed	== "SCHRAUBBAR"){
		if(oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn	== "EINFACH"){
			sqlString += " AND SCHRAUBBAR_EINFACH = 'true' ";
			sqlString += " AND SCHRAUBBAR_DOPPELT = 'false' ";
		}
		else{
			sqlString += " AND SCHRAUBBAR_EINFACH = 'false' ";
			sqlString += " AND SCHRAUBBAR_DOPPELT = 'true' ";
		}
	}
	
	switch(oDlgLagerSession.AuswahlStandard.strSelComboAccessory){
		case "KLEMMBAR" :
				sqlString += "AND KLEMMSYSTEM <> 'false' AND KLEMMSYSTEM <> '-'  AND KLEMMSYSTEM <> ''";
			break;	
		case "ABHEBESICHERUNG_4"	:	
		case "ABHEBESICHERUNG"	:
				sqlString += "AND ABHEBESICHERUNG <> '-' AND ABHEBESICHERUNG <> ''";
			break;
		case "GLEITELEMENT" :
				sqlString += "AND GLEITELEMENT = '"+oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart+"' ";
			break;	
	}
	
	return  sqlString;
}