/**
 * @category   Store 
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Lager ) === 'undefined' )
	Lager = {};
else if ( typeof( Lager.RohrumschliessendesTeil ) === 'undefined' )
	Lager.RohrumschliessendesTeil = {};

	
Lager.RohrumschliessendesTeil.getSelectionAussendurchmesser = function(strNenndurchmesser){
	var sqlstring 	= "SELECT * FROM NENNWEITEN WHERE DN = '"+strNenndurchmesser+"'";
	var dbName		= 'LAGER2';
	var dbNameTable = "SelectionAussendurchmesser";
	
	var strD;
	if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			var aDBData = new Array();
			strD  = dbgetstring(dbNameTable,"D");
			dbskip( dbNameTable );
		}
	}
	
	return strD;
}

Lager.RohrumschliessendesTeil.getSelectionNenndurchmesser = function(strAussendurchmesser){
	var sqlstring 	= "SELECT * FROM NENNWEITEN WHERE D = '"+strAussendurchmesser+"'";
	var dbName		= 'LAGER2';
	var dbNameTable = "SelectionNenndurchmesser";
	
	var strDN;
	if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			var aDBData = new Array();
			strDN  = dbgetstring(dbNameTable,"DN");
			dbskip( dbNameTable );
		}
	}
	
	return strDN;
}

/**
 * build and get Material Object
 * @param [dTemp] {Double}
 * @return {Object}
 */
Lager.RohrumschliessendesTeil.getBasicMaterial = function(dTemp){
	// Bestimmung der Auslegungsregel fr die Grenztemperaturen
	var TempSuffix	= "VGB";
	if (right(getstring("GRENZ_TEMP", "PROJECT.SETTINGS.CASCADE"), 5) == "WERKE")
		TempSuffix	= "WIT";
	// Bestimmung der Referenztemperatur
	// dTemp <= 350C und dTemp >= 40C : dRefTemp = dTemp - 20
	// dTemp >= 40C da es ab 20C die ersten Abminderungsfaktoren gibt (1.4541)
	var dRefTemp = dTemp*1;
	if (dTemp <= 350 && dTemp >= 40)
		dRefTemp	= dTemp - 20;
	//var sqlstring 	= "SELECT * FROM GRENZTEMP WHERE abs(U"+TempSuffix+") <= abs("+dRefTemp+") AND abs("+dRefTemp+") <= abs(O"+TempSuffix+")";
	var sqlstring 	= "SELECT * FROM GRENZTEMP WHERE (U"+TempSuffix+")*1 <= ("+dRefTemp+") AND ("+dRefTemp+") <= (O"+TempSuffix+")*1";
	var dbName		= 'CASCADE';
	var dbNameTable = 'BuildBaseMaterial';
	
	var aBaseMaterial = new Array();
	if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			var oData = {};
			oData.MAT 	= dbgetstring(dbNameTable,"MAT");
			oData.DINEN = dbgetstring(dbNameTable,"DINEN");
			oData.UVGB 	= dbgetstring(dbNameTable,"UVGB");
			oData.OVGB 	= dbgetstring(dbNameTable,"OVGB");
			oData.UWIT 	= dbgetstring(dbNameTable,"UWIT");
			oData.OWIT 	= dbgetstring(dbNameTable,"OWIT");
			oData.MATID = Produkt.getWerstoffeDBNumber(oData.MAT).strSelWerkstoff;
			
			aBaseMaterial.push(oData);
			
			dbskip( dbNameTable );
		}
	}
	/*
	if(dTemp <300) //Werte bei Betriebstemperatur < 300 C
		oSelection = Produkt.getWerstoffeDBNumber("S235JRG2");
	else if(dTemp <= 450) // Werte bei Betriebstemperatur zwischen 300 C und 450 C
		oSelection = Produkt.getWerstoffeDBNumber("16Mo3");
	else*/ 
		oSelection = Produkt.getWerstoffeDBNumber((aBaseMaterial.length > 0 ? aBaseMaterial[0].MAT : ''));
	
	return ({'aBaseMaterial' : aBaseMaterial, 'strSelId' : oSelection.strSelId, 'strSelWerkstoff' : oSelection.strSelWerkstoff});
}