/**
 * @category   Lager function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * Lager Typ: Fuehrungslager
 */
if ( typeof( Lager ) === 'undefined' )
	Lager = {};

/**
 * hat aktuelles Lager ein Klemmsystem
 * @param [oDlg]{Object}
 * @return {Boolean}
 */
Lager.isKlemmbar = function(oDlg){
	var bKlemmbar = false;
	//sollte sich aus der Matrix ergeben TUDO
	if(oDlg.AuswahlStandard.strSelRadioFixed == 'KLEMMBAR' || oDlg.Systemcharakteristik.strSelRadioLager == 'LAGER_FS')
		bKlemmbar = true;
	
	return bKlemmbar;
};

/**
 * existieren PA_Rollen fr Rollenlagern
 * @param [RohrUmTeil]{Object}
 * @param [SattelObj]{Object}
 * @return {Boolean}
 */
Lager.isRollenlager_Werkstoff_PA = function(RohrUmTeil,SattelObj){
	
	var retObj	= { bPA	: true,
					SatTemp	: "",
					RLTemp	: "" };
	//var bPA = true;
	// fr Manteldurchmesser ist keine Prfung ntig
	//if (!RohrUmTeil.bMantelDuMesserSonder || RohrUmTeil.strSelMantelDuMesserCombo == "STD"){
	// Berechnung der Temperatur am Sattel
	var dA		= (RohrUmTeil.bAussenDuMesserSonder ? RohrUmTeil.dAussenDuMesserSonder : RohrUmTeil.strSelAussenDuMesserCombo)*1;
	var J		= RohrUmTeil.dDaemmDicke*1;
	var H		= (left(SattelObj.TYP,3) == "ITB" ? min(SattelObj.J_MAX*1,SattelObj.A) + 6 :
					SattelObj.J_MAX*1 + SattelObj.S_LAUFSCHALE*1);
	var sS		= SattelObj.S_STEG*1;
	var Ti		= RohrUmTeil.dTemperaturMedium*1;
	var Ta		= 25;	// Umgebungstemperatur
	var E		= dA/2 + H;
	var a		= E * J / (2000 * sS);
	var CTemp	= (a > 6 ? 0.17 :
					-0.0009*pow(a,5) + 0.0165*pow(a,4) - 0.117*pow(a,3) + 0.4155*pow(a,2) - 0.8153*a + 0.9994);
	var C1		= 1;	// Stege nicht unterbrochen
	var C2		= 1 - pow((H-J)/H,3);
	var SatTemp	= fround(C1 * (CTemp * Ti + (1 - CTemp) * Ta), 0);
	retObj.SatTemp	= SatTemp;
	retObj.RLTemp	= (2*SatTemp+Ta)/3;
	if (SatTemp > 100)	// zulssige Temperatur fr PA liegt bei 100C
		retObj.bPA = false;
	//}
	return retObj; 
}


/**
 * search Picture for Topology FielsSet
 * @return {String} Filename
 */
Lager.getTopologyPicture = function(oDlg){
	var strBild = 'blank.gif';
	
	var strFile = 'catalog/client/custom/img/WITgifs/RH/' + strBild;
	
	return strFile;
};	

/**
 * get Werkstoffnumer
 * @param [oDlg]{Object} Data Object
 * @return {Double}
 */
Lager.getWerkstoffeNumber = function(oDlg){
	var strSelection 	= oDlg.SollwerteRohrUmTeil.strSelRadioWerkstoff;
	strSelection 		= strSelection.replace("LAGER_","");
	strSelection		= Produkt.getWerkstoffeNumber(strSelection);
	
	return strSelection;
};


Lager.isGleitlager = function(oDlg){
	if(!oDlg)
		alert('ERROR: Lager Dialog Object is null');
	switch(oDlg.Systemcharakteristik.strSelRadioLager){
		case "LAGER_SPG" :
		case "LAGER_SSG" :
		case "LAGER_EPG" :
			return true;
		default :
			return false;
	}	
};

Lager.isFestlager = function(oDlg){
	if(!oDlg)
		alert('ERROR: Lager Dialog Object is null');
	if(oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_FS")
		return true;
	else 
		return false;
};

Lager.getIsolierung = function(oDlg){
	if(!oDlg)
		alert('ERROR: Lager Dialog Object is null');
	if(oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo == 'STD' && oDlg.SollwerteRohrUmTeil.dDaemmDicke == 0 && !oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder)
		return 'ID_UNGEDAEMMT';
	else if(oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo == 'STD' && oDlg.SollwerteRohrUmTeil.dDaemmDicke > 0)
		return 'ID_WAERMEGEDAEMMT';
	else if(oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo !== 'STD' || oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder)
		return 'ID_VORISOLIERT';
};


/**
 * Test 
 */
Lager.setDefaultData = function(oDlg,strDialogId){
	if(Lager.isGleitlager(oDlg) || Lager.isFestlager(oDlg)){
		var dbName		= 'LAGER2';
		var sqlString 	= "SELECT * FROM AUSLEGUNG_GLEIT_FEST_LAGER WHERE LAGER_TYP ='"+oDlg.Systemcharakteristik.strSelRadioLager+"'";
		
		if(strDialogId == "lager.systemcharakteristik")
			sqlString += " GROUP BY (LAGER_TYP)";
		else if("lager.sollwerte_rohrumschliessendesteil")	
			sqlString += (Lager.getIsolierung(oDlg) == 'ID_VORISOLIERT') ? " AND VORISOLIERT = 'true' " : " AND VORISOLIERT = 'false'" ;
			
		
		if(strDialogId != 'lager.sollwerte_halterungspunkt'){			
			var dbNameTable 		= "AUSLEGUNG_GLEIT_FEST_LAGER_LAGER_TYP";
			var aResult 			= new Array();
			var dTableDatenLength 	= dbselect( dbName, sqlString, dbNameTable );
			if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){					
				var bOk	= false;
				
				while ( dbiseof( dbNameTable) == 0 ){
					var bCorrectLagerart 			= Lager.isFestlager(oDlg) ? true : false;
					var bCorrectGleitunterlage 		= false;
					var bCorrectAbhebesicherung 	= false;
					var bCorrectHoehenverstellbar 	= false;
					var bCorrectGleitelement		= false;
					var bCorrectKlemmsystem			= false;
					var bCorrectSchraubEinfach		= Lager.isGleitlager(oDlg) ? true : false;
					var bCorrectSchraubZweifach		= Lager.isGleitlager(oDlg) ? true : false;
					var bCorrectFixed				= Lager.isGleitlager(oDlg) ? true : false;
					
					if(!Base.convertStringToBoolean(dbgetstring(dbNameTable,"VORISOLIERT")) && strDialogId == "lager.systemcharakteristik"){
						oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder 		= false;
						oDlg.SollwerteRohrUmTeil.dMantelDuMesserSonder		= 0;
						oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo 	= 'STD';	
						
						
						bCorrectLagerart 			= true;
						bCorrectGleitunterlage 		= true;
						bCorrectAbhebesicherung 	= true;
						bCorrectHoehenverstellbar 	= true;
						bCorrectGleitelement		= true;
						bCorrectKlemmsystem			= true;
						bCorrectSchraubEinfach		= true;
						bCorrectSchraubZweifach		= true;
						bCorrectFixed				= true;
					}
					
					if(strDialogId == "lager.sollwerte_rohrumschliessendesteil"){						
						//Lagerart
						if(Lager.isGleitlager(oDlg)){
							var strLagerArt = dbgetstring(dbNameTable,"LAGERART");
							switch(oDlg.AuswahlStandard.strSelRadioFunction){
								case "LOSE" :
										bCorrectLagerart = (strLagerArt == "LOSLAGER") ? true : false;
									break;	
								case "GEFUEHRT"	:
										bCorrectLagerart = (strLagerArt == "FUEHRUNGSLAGER") ? true : false;
									break;
								case "GEFUEHRT_MEHRFACH" :
										bCorrectLagerart = (rfind(strLagerArt,"FUEHRUNG_")> 0) ? true : false;
									break;	
							}
						}
						
						//Gleitelement
						if(oDlg.AuswahlStandard.bGaT){
							if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"GLEITUNTERLAGE")))
								bCorrectGleitunterlage = true;
						}
						else if(!oDlg.AuswahlStandard.bGaT){
							if(!Base.convertStringToBoolean(dbgetstring(dbNameTable,"GLEITUNTERLAGE")))
								bCorrectGleitunterlage = true;
						}
						
						//Hoehenverstellbar
						if(oDlg.AuswahlStandard.bHoehenverstellbar){
							if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"HOEHENVERSTELLBAR")))
								bCorrectHoehenverstellbar = true;
						}
						else if(!oDlg.AuswahlStandard.bHoehenverstellbar){
							if(!Base.convertStringToBoolean(dbgetstring(dbNameTable,"HOEHENVERSTELLBAR")))
								bCorrectHoehenverstellbar = true;
						}
						
						//Abhebesicherung,Gleitelement,Klemmsystem
						if(oDlg.AuswahlStandard.strSelComboAccessory == '-'){
							//Abhebesicherung
							if(dbgetstring(dbNameTable,"ABHEBSICHERUNG") == '-' || dbgetstring(dbNameTable,"ABHEBSICHERUNG") == '')
								bCorrectAbhebesicherung = true;
							//Gleitelement
							if(dbgetstring(dbNameTable,"GLEITELEMENT") == '-' || dbgetstring(dbNameTable,"GLEITELEMENT") == '')
								bCorrectGleitelement = true;
							//Klemmsystem
							if(dbgetstring(dbNameTable,"KLEMMSYSTEM") == '-' || dbgetstring(dbNameTable,"KLEMMSYSTEM") == '')
								bCorrectKlemmsystem = true;		
						}
						else if((oDlg.AuswahlStandard.strSelComboAccessory === 'ABHEBESICHERUNG') || (oDlg.AuswahlStandard.strSelComboAccessory === 'ABHEBESICHERUNG_4')){
							if(dbgetstring(dbNameTable,"ABHEBSICHERUNG") !== '-' ){
								bCorrectKlemmsystem = true;
								bCorrectAbhebesicherung = true;
								bCorrectGleitelement = true;
							}
						}
						else if(oDlg.AuswahlStandard.strSelComboAccessory === 'GLEITELEMENT'){
							if(dbgetstring(dbNameTable,"GLEITELEMENT") !== '-' ){
								//Test auf TYP
								if(oDlg.AuswahlStandard.strSelComboSlidingPart === dbgetstring(dbNameTable,"GLEITELEMENT")){
									bCorrectKlemmsystem = true;
									bCorrectAbhebesicherung = true;
									bCorrectGleitelement = true;
								}
							}	
						}
						else if(oDlg.AuswahlStandard.strSelComboAccessory === 'KLEMMBAR'){
							if(dbgetstring(dbNameTable,"KLEMMSYSTEM") !== '-' ){
								bCorrectKlemmsystem = true;
								bCorrectAbhebesicherung = true;
								bCorrectGleitelement = true;
							}	
						}
						
						if(Lager.isFestlager(oDlg)){
							if(oDlg.AuswahlStandard.strSelRadioFixed == 'KLEMMBAR'){
								if(!Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_EINFACH")) && !Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_DOPPELT")))
									bCorrectFixed = true;
							}
							else if(oDlg.AuswahlStandard.strSelRadioFixed == 'SCHRAUBBAR'){
								if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_EINFACH")) || Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_DOPPELT")))
									bCorrectFixed = true;
									
								if(oDlg.AuswahlStandard.strSelRadioFixedScrewOn == 'EINFACH'){
									if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_EINFACH")) && !Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_DOPPELT")))
										bCorrectSchraubEinfach = true;
								}
								else if(oDlg.AuswahlStandard.strSelRadioFixedScrewOn == 'DOPPELT'){
									if(!Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_EINFACH")) && Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_DOPPELT")))
										bCorrectSchraubZweifach = true;
								}
							}
						}
						
						//tatschliches Einbaumass
						oDlg.AuswahlStandard.dActualMass = Base.buildMountingDimension(oDlg.AuswahlStandard.dActualHeight*1,oDlg.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					}
					
					if(strDialogId == "lager.auswahl_standard"){
						bCorrectLagerart 			= true;
						bCorrectGleitunterlage 		= true;
						bCorrectAbhebesicherung 	= true;
						bCorrectHoehenverstellbar 	= true;
						bCorrectGleitelement		= true;
						bCorrectSchraubEinfach		= true;
						bCorrectSchraubZweifach		= true;
						bCorrectFixed				= true;
						bCorrectKlemmsystem 		= true;
						
						//Klemmsystem berprfen					
						if(oDlg.AuswahlStandard.strSelComboAccessory == 'KLEMMBAR'){
							//1. Abhebesicherung	
							var oAbhebsicherungData 	= Klemmsystem.getDataAbhebesicherung(oDlg);
							if(oDlg.AuswahlRollenlager.strSelRadioFixed == 'MIT' && !oAbhebsicherungData.bMit)
								bCorrectKlemmsystem = false;
							
							//2. Trger
							var oTraeger				= Klemmsystem.getDataTraeger(oDlg);
							if(!Base.hasValueIntoArrayPositionNull(oTraeger.Store,oDlg.AuswahlStandard.strSelComboBeamArt))
								bCorrectKlemmsystem = false;
						}
						
					}
					
					if(bCorrectLagerart && bCorrectGleitunterlage && bCorrectAbhebesicherung 
						&& bCorrectHoehenverstellbar && bCorrectGleitelement && bCorrectKlemmsystem 
						&& bCorrectSchraubEinfach && bCorrectSchraubZweifach && bCorrectFixed)						
						bOk = true;
					
					
					dbskip( dbNameTable );					
				}
				
				//setze default Wert fr die Oberflche
				if(strDialogId == "lager.sollwerte_rohrumschliessendesteil"){
					//if(!oDlg.AuswahlStandard.strSelComboGroundLevel){		// sonst kommt 16Mo3 ohne Oberflche
						var oOberflaeche = Base.Store.getOberflaeche();
						if(rfind(oDlg.SollwerteRohrUmTeil.strSelRadioWerkstoff,"W_RST")>0)
							oDlg.AuswahlStandard.strSelComboGroundLevel = oOberflaeche.strSchel1Setting;
						else if((rfind(oDlg.SollwerteRohrUmTeil.strSelRadioWerkstoff,"W_10CRMO")>0) ||
								(rfind(oDlg.SollwerteRohrUmTeil.strSelRadioWerkstoff,"W_15MO3")>0) ||
								(rfind(oDlg.SollwerteRohrUmTeil.strSelRadioWerkstoff,"W_P91")>0) ||
								(rfind(oDlg.SollwerteRohrUmTeil.strSelRadioWerkstoff,"W_13CRMO")>0)){						
							oDlg.AuswahlStandard.strSelComboGroundLevel	= oOberflaeche.strSchel3Setting;
						}	
						else
							oDlg.AuswahlStandard.strSelComboGroundLevel = oOberflaeche.strSchel4Setting;
					}
				//}
				
				if(!bOk){
					//Werte korrigieren
					if(strDialogId == "lager.sollwerte_rohrumschliessendesteil"){
						sqlString += " GROUP BY (LAGER_TYP)";
						var dbNameTable 		= "AUSLEGUNG_GLEIT_FEST_LAGER_LAGER_TYP_NEW";
						var aResult 			= new Array();
						var dTableDatenLength 	= dbselect( dbName, sqlString, dbNameTable );
						if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){
							while ( dbiseof( dbNameTable) == 0 ){
								var strLagerArt = dbgetstring(dbNameTable,"LAGERART");
								var strAbhebeSi = dbgetstring(dbNameTable,"ABHEBSICHERUNG");
								var strGleitele = dbgetstring(dbNameTable,"GLEITELEMENT");
								var strKlemmsys = dbgetstring(dbNameTable,"KLEMMSYSTEM");
								var bGleitunter = Base.convertStringToBoolean(dbgetstring(dbNameTable,"GLEITUNTERLAGE"));
								var bHoehenvers = Base.convertStringToBoolean(dbgetstring(dbNameTable,"HOEHENVERSTELLBAR"));
								/*
								if(Lager.isGleitlager(oDlg)){
									if(strLagerArt == "LOSLAGER")
										oDlg.AuswahlStandard.strSelRadioFunction = "LOSE";
									else if(strLagerArt == "FUEHRUNGSLAGER")
										oDlg.AuswahlStandard.strSelRadioFunction = "GEFUEHRT";
									else if(rfind(strLagerArt,"FUEHRUNG_")> 0){	
										oDlg.AuswahlStandard.strSelRadioFunction = "GEFUEHRT_MEHRFACH";
										oDlg.AuswahlStandard.strSelComboFunction = strLagerArt;
									}
								}
								*/
								if(strAbhebeSi !== '-' && strAbhebeSi !== '')
									oDlg.AuswahlStandard.strSelComboAccessory = 'ABHEBESICHERUNG';
								else if(strGleitele !== '-' && strGleitele !=='')
									oDlg.AuswahlStandard.strSelComboAccessory = 'GLEITELEMENT';
								else if(strKlemmsys !== '-' && strKlemmsys !=='' && strKlemmsys !=='false')
									oDlg.AuswahlStandard.strSelComboAccessory = 'KLEMMBAR';
								else
									oDlg.AuswahlStandard.strSelComboAccessory = '-';
									
								if(oDlg.AuswahlStandard.strSelComboAccessory == 'GLEITELEMENT')
									oDlg.AuswahlStandard.strSelComboSlidingPart	= dbgetstring(dbNameTable,"GLEITELEMENT");
								
								if(oDlg.AuswahlStandard.strSelComboAccessory == '-')
									oDlg.AuswahlStandard.strSelComboSlidingPart = '-';
								
								oDlg.AuswahlStandard.bHoehenverstellbar	= bHoehenvers;
								oDlg.AuswahlStandard.bGaT 				= bGleitunter;
								
								if(Lager.isFestlager(oDlg)){
									if(!Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_EINFACH")) && !Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_DOPPELT")))
										oDlg.AuswahlStandard.strSelRadioFixed = 'KLEMMBAR';
									else if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_EINFACH")) || Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_DOPPELT"))){
										oDlg.AuswahlStandard.strSelRadioFixed = 'SCHRAUBBAR';
										
										if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_EINFACH")))
											oDlg.AuswahlStandard.strSelRadioFixedScrewOn = 'EINFACH';
										else if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_DOPPELT")))
											oDlg.AuswahlStandard.strSelRadioFixedScrewOn = 'DOPPELT';
									}
								}
								
								dbskip( dbNameTable );
							}
						}					
					}
					
					if(strDialogId == "lager.auswahl_standard"){
						if(oDlg.AuswahlStandard.strSelComboAccessory == 'KLEMMBAR'){
							//Korrigiere Selection 
							//1. Abhebesicherung	
							var oAbhebsicherungData 	= Klemmsystem.getDataAbhebesicherung(oDlg);
							if(oDlg.AuswahlRollenlager.strSelRadioFixed == 'MIT' && !oAbhebsicherungData.bMit)
								oDlg.AuswahlRollenlager.strSelRadioFixed = 'OHNE';
							
							//2. Trger
							var oTraeger				= Klemmsystem.getDataTraeger(oDlg);
							if(!Base.hasValueIntoArrayPositionNull(oTraeger.oData.Store,oDlg.AuswahlStandard.strSelComboBeamArt))
								oDlg.AuswahlStandard.strSelComboBeamArt = oTraeger.Store[0][0]; 	
						}
					}
				}
			}
		}
	}
}

/** 
 * erstelle Lager Client Tabelle
 * @param {oDlgLagerSession}{Object}
 * @return Array
 */
Lager.getClientTable = function(oDlgLagerSession,strDialog){
	var aResult 	= new Array();
	var aLagerData,aAbhebData,aGleitData;
	var bAbheb		= false;
	var bGleit		= false;
	var bHoehenverstellbar = false;
	
	if(!strDialog){
		aLagerData 	= getDataFromLagerCacheObject('AuswahlStandard','TABLE');
		aAbhebData 	= getDataFromLagerCacheObject('AuswahlAbhebesicherung','TABLE');
		aGleitData 	= getDataFromLagerCacheObject('AuswahlGleitelement','TABLE');
		bAbheb		= aAbhebData.length > 0 ? true : false;
		bGleit		= aGleitData.length > 0 ? true : false;
		bHoehenverstellbar = oDlgLagerSession.AuswahlStandard.bHoehenverstellbar;
	}
	else if(strDialog == "ROLLENLAGER_P" || strDialog == "ROLLENLAGER_S") {
		aLagerData 	= getDataFromLagerCacheObject('AuswahlRollenlager','TABLE');
		// bHoehenverstellbar = oDlgLagerSession.AuswahlStandard.bHoehenverstellbar;
	}
	
	for(var a=0;a<aLagerData.length;a++){
		var aDBData = new Array();
		var oDataLager = aLagerData[a];
		var oAbhebData = {};
		var oGleitData = {};
		
		if(strDialog !== "ROLLENLAGER_P" && strDialog !== "ROLLENLAGER_S"){
			if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder || oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
				// Original-Datensatz merken
				var oOriginalRow = Base.deepClone(oDataLager);  
				// Original-Daten abndern auf Sondermae
				var oUpdateData  = Base.updateTableSearchData(oDlgLagerSession,oDataLager,strDialog);
				// Wenn abndern erfolgreich ist und die Originaldaten noch nicht gespeichert sind
				// letzeres ntig, da sonst bei jedem zurck der Preis erhht wird!!!
				if(oUpdateData.bOk && typeof(aLagerData[a].oOriginalData) != 'object'){
					// Original-Datensatz als Unterobjekt sichern
					aLagerData[a].oOriginalData = {};
					EasyKat.apply(aLagerData[a].oOriginalData,oOriginalRow);
					// Neue, abgenderte Daten zur Anzeige benutzen
					oDataLager = oUpdateData;
					//Um auf nummer sicher zu gehen
					Base.applyValues(aLagerData[a],oUpdateData);
				}
			}
		}
		
		if(bAbheb)
			oAbhebData = aAbhebData[a];
		
		if(bGleit)
			oGleitData = aGleitData[a];
		
		var strH = oDataLager.NH;
		if (bHoehenverstellbar)
			strH = oDataLager.H_MIN_MAX;
		var strE = oDataLager.E;
		if (bHoehenverstellbar)
			strE = oDataLager.E_MIN_MAX;
		
		aDBData.push(oDataLager.TYP+"_"+a+ 														(bAbheb ? '<br>'+oAbhebData.TYP 					: (bGleit ? '<br>'+oGleitData.TYP : '')));
		//aDBData.push((oDataLager.TYP_CALCULATION ? oDataLager.TYP_CALCULATION : oDataLager.TYP)+(bAbheb ? '<br>'+oAbhebData.TYP 					: (bGleit ? '<br>'+oGleitData.TYP : '')));
		//@@@ LGE Test
		aDBData.push((oDataLager.TYP_CALCULATION ? oDataLager.TYP_CALCULATION : oDataLager.TYP)+(bAbheb ? '<br>'+oAbhebData.TYP 					: (bGleit ? '<br>'+(oGleitData.TYP_CALCULATION ? oGleitData.TYP_CALCULATION : oGleitData.TYP) : '')));
		//if(strDialog !== "ROLLENLAGER_P" && strDialog !== "ROLLENLAGER_S"){	
			if(oDataLager.DN)
				aDBData.push(oDataLager.DN+																(bAbheb ? '<br>	-' 									: (bGleit ? '<br> -' : '')));		
			else
				aDBData.push('-');
			
			if(oDataLager.NH)
				aDBData.push(strH+																		(bAbheb ? '<br>	-' 									: (bGleit ? '<br> -' : '')));
			else
				aDBData.push('-');
				
			if(strE) 
				aDBData.push(strE+																		(bAbheb ? '<br>	-' 									: (bGleit ? '<br> -' : '')));
			else
				aDBData.push('-');
				
			if(oDataLager.dHdD)
				aDBData.push(formatstring(oDataLager.dHdD,"%.0f")+															(bAbheb ? '<br>	-' 									: (bGleit ? '<br> -' : '')));					
			else if(!strDialog && oDataLager.DM)
				aDBData.push(formatstring(oDataLager.DM,"%.0f")+																(bAbheb ? '<br>	-' 									: (bGleit ? '<br> -' : '')));					
			else
				aDBData.push('-');
		//}
		if(oDataLager.F_AUFL_CALCULATION)
			aDBData.push(oDataLager.F_AUFL_CALCULATION+												(bAbheb ? '<br>	-' 									: (bGleit ? '<br> -' : '')));
		else
			aDBData.push('-');
			
		if(oDataLager.F_AXIAL_CALCULATION)
			aDBData.push(oDataLager.F_AXIAL_CALCULATION+											(bAbheb ? '<br>	-' 									: (bGleit ? '<br> -' : '')));
		else
			aDBData.push('-');
		
		if(oDataLager.F_QUER_CALCULATION)
			aDBData.push(oDataLager.F_QUER_CALCULATION+												(bAbheb ? '<br>'+oAbhebData.F_QUER 					: (bGleit ? '<br> -' : '')));
		else
			aDBData.push('-');
		
		if(/*!strDialog &&*/ oDataLager.F_AB_CALCULATION)
			aDBData.push(oDataLager.F_AB_CALCULATION+												(bAbheb ? '<br>'+oAbhebData.F_AB 					: (bGleit ? '<br> -' : '')));			
		else
			aDBData.push('-');
			
		aDBData.push(oDataLager.GEW+															(bAbheb ? '<br>'+oAbhebData.GEW 					: (bGleit ? '<br>'+oGleitData.GEW 	: '')));
		aDBData.push(oDataLager.PREIS_Tab+											(bAbheb ? '<br>'+oAbhebData.PREIS_Tab	: (bGleit ? '<br>'+ Base.getPrice(oGleitData.PREIS) 	: '')));				
		
		aResult.push(aDBData);
	}
	
	if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder || oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
		setDataIntoLagerCacheObject('AuswahlStandard','UPDATE_COMPLITE_TABLE',aLagerData);
	}
	
	return aResult;
};