/**
 * @category   Klemmsystem function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Klemmsystem ) === 'undefined' )
	Klemmsystem = {};
if ( typeof( Klemmsystem.Search ) === 'undefined' )
	Klemmsystem.Search = {};
if( typeof( Klemmsystem.Search.KlemmsystemTyp ) === 'undefined' )	
	Klemmsystem.Search.KlemmsystemTyp = {};
	
Klemmsystem.Search.KlemmsystemTyp.Zubehoer_Gleitlager = function(oDlg){
	var oZusatz;
	
	/**
	 * @private build direction for sql
	 */
	var _buildDirection = function(oDlg){
		var oDirection 	= Klemmsystem.Search.buildDefaultDirection(oDlg);
		
		oZusatz = {
			'strLagerart' 				: oDlg.Klemmsystem.strSelComboFunction, 
			'strTraegerart' 			: oDlg.AuswahlStandard.strSelComboBeamArt,
			'bAbhebesicherung' 			: oDlg.Klemmsystem.bUpliftRestraint,
			'bAbhebesicherung4fach' 	: oDlg.Klemmsystem.bUpliftRestraint4,
			'bGleitunterlage'			: oDlg.Klemmsystem.bGaT,
			'strBreite'					: (oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport != 'SONST' ? oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport : oDlg.Klemmsystem.dOtherWidthBaseOfTheSupport),
			'strVorgabeTraegerbreite' 	: oDirection.oZusatz.strVorgabeTraegerbreite,
			'strVorgabeProfilform'		: oDirection.oZusatz.strVorgabeProfilform,
			'strTypenschluesselSuffix'  : oDirection.oZusatz.strTypenschluesselSuffix,
			'strVorgabeFussBreite'		: ((oDirection.oZusatz.strVorgabeFussBreite && oDirection.oZusatz.strVorgabeFussBreite!= 'SONST')? oDirection.oZusatz.strVorgabeFussBreite :(oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport != 'SONST' ? oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport : oDlg.Klemmsystem.dOtherWidthBaseOfTheSupport))
		};		
		
		var strType 		= Klemmsystem.berechneRelevanteBaureihe(oZusatz);
		var oTraegerdaten 	= Klemmsystem.holeTraegerdaten( oZusatz.strTraegerart, oDlg.AuswahlStandard.strSelComboBeamSize );
		
		//Build SQL
		var strPartSQL = " TYP like '"+strType+"%' ";
		
		if(strVorgabeProfilform)
			strPartSQL += " AND PROFILFORM like '"+strVorgabeProfilform+"%'";	
		/*	
		if(oZusatz.bGleitunterlage && (oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport !== 'SONST'))
			strPartSQL += " AND abs(BREITE) = "+oZusatz.strBreite+"";
		else if(oZusatz.bGleitunterlage && (oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport == 'SONST')){
			strPartSQL += " AND abs(BREITE) >= "+oZusatz.strBreite+"";
		}
		*/
		if (oZusatz.bGleitunterlage && (oDlg.Klemmsystem.strSelComboFunction == "LOSE"))
			strPartSQL += " AND abs(BREITE) >= "+oZusatz.strBreite+"";
		else if (oZusatz.bGleitunterlage)
			strPartSQL += " AND abs(BREITE) = "+oZusatz.strBreite+"";
		
		if(((oZusatz.strVorgabeTraegerbreite*1) <= 140) && oZusatz.strVorgabeProfilform == "T")
			strPartSQL += " AND TRAEGERBREITE = '140'";		
		else
			strPartSQL += " AND TRAEGERBREITE = '-'";
		
		return strPartSQL;
	}	
	
	var strSql 		= "SELECT * FROM 'KXX' WHERE "
		strSql		+= _buildDirection(oDlg);
	
	var dbName		= 'LAGER2';
	var oAllDBDaten = Klemmsystem.Search.getSearchResultData(dbName,strSql);
	var dResult 	= 0;
	var strError 	= '';
	var _setError = function(strValue){
		if(!strError)
			strError = strValue;
	}
	
	for(var i=0;i<oAllDBDaten.length;i++){
		var oRet 	= Klemmsystem.Search.TestAndModify_LagerSystem(oDlg,oAllDBDaten[i],'KXX',oZusatz);
		if(oRet.bOk){
			dResult +=1;
			setDataIntoLagerCacheObject('AuswahlKlemmsystem','TABLE',(oRet.oData));
		}
		else
			_setError(oRet.oData.strError);	
	}
	
	return  (dResult > 0 ? Klemmsystem.getClientTable(oDlg,false) : ['ERROR',strError]);
};