/**
 * @category   Klemmsystem function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Klemmsystem ) === 'undefined' )
	Klemmsystem = {};
if ( typeof( Klemmsystem.Search ) === 'undefined' )
	Klemmsystem.Search = {};
if( typeof( Klemmsystem.Search.KlemmsystemTyp ) === 'undefined' )	
	Klemmsystem.Search.KlemmsystemTyp = {};
	
Klemmsystem.Search.KlemmsystemTyp.Zubehoer = function(oDlg){
	var oZusatz;
	
	/**
	 * @private build direction for sql
	 */
	var _buildDirection = function(oDlg){
		var strType = "KOT";
		var strPartSQL = '';
		if(oDlg.AuswahlStandard.dBeamWidth*1 < 120)
			strType += " 09";
		else
			strType += " 20";
		
		strPartSQL = " AND TYP like '"+strType+"%RL%' ";
		
		var oDirection 	= Klemmsystem.Search.buildDefaultDirection(oDlg);
		oZusatz 		= oDirection.oZusatz;
		if(oDlg.AuswahlStandard.dBeamWidth*1 >= 120)
			strPartSQL +=" AND TRAEGERBREITE like '-%'";
		else //if(oDlg.AuswahlStandard.dBeamWidth*1 < 120)
			strPartSQL +=" AND TRAEGERBREITE like '120'";
				
		return strPartSQL;
	}	
	
	var strSql 		= Klemmsystem.Search.getDefaultSQL(oDlg,'KXX');
		strSql		+= _buildDirection(oDlg);
		
	var dbName				= 'LAGER2';
	var oAllDBDaten 		= Klemmsystem.Search.getSearchResultData(dbName,strSql);
	
	var dResult 	= 0;
	var strError 	= '';
	var _setError = function(strValue){
		if(!strError)
			strError = strValue;
	}
	
	for(var i=0;i<oAllDBDaten.length;i++){
		var oRet 	= Klemmsystem.Search.TestAndModify_LagerSystem(oDlg,oAllDBDaten[i],'KXX',oZusatz);
		if(oRet.bOk){
			dResult +=1;
			setDataIntoLagerCacheObject('AuswahlRollenlager','TABLE',(oRet.oData));
		}
		else
			_setError(oRet.oData.strError);	
	}
	
	return (dResult > 0 ? Klemmsystem.getClientTable(oDlg) : ['ERROR',strError]);
};