/**
 * @category   Klemmsystem function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Klemmsystem ) === 'undefined' )
	Klemmsystem = {};
if ( typeof( Klemmsystem.Search ) === 'undefined' )
	Klemmsystem.Search = {};
if( typeof( Klemmsystem.Search.KlemmsystemTyp ) === 'undefined' )	
	Klemmsystem.Search.KlemmsystemTyp = {};

Klemmsystem.Search.KlemmsystemTyp.Lagersystem	= function(oDlg){
	var oZusatz;
	/**
	 * @private build direction for sql
	 */
	var _buildDirection = function(oDlg){
		var oDirection 	= Klemmsystem.Search.buildDefaultDirection(oDlg);
		var BeamArt		= "T_POFIL"
		if (left(oDlg.AuswahlStandard.strSelComboBeamArt, 1) == "U" || left(oDlg.AuswahlStandard.strSelComboBeamArt, 1) == "L")
			BeamArt		= left(oDlg.AuswahlStandard.strSelComboBeamArt, 1) + "_PROFIL";
		var UpliftRestraint	= (oDlg.Klemmsystem.strSelRadioFixed == "OHNE" ? 0 : 1);
		// @@@ LGE Test
		oZusatz = {
			'strLagerart' 				: oDlg.Klemmsystem.strSelComboFunction, 
			'strTraegerart' 			: BeamArt,
			'bAbhebesicherung' 			: UpliftRestraint,
			'bAbhebesicherung4fach'		: 0,
			'bGleitunterlage'			: oDlg.Klemmsystem.bGaT,
			'strBreite'					: (oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport != 'SONST' ? oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport : oDlg.Klemmsystem.dOtherWidthBaseOfTheSupport),
			'strVorgabeTraegerbreite' 	: oDirection.oZusatz.strVorgabeTraegerbreite,
			'strVorgabeProfilform'		: oDirection.oZusatz.strVorgabeProfilform,
			'strTypenschluesselSuffix'  : oDirection.oZusatz.strTypenschluesselSuffix,
			'strVorgabeFussBreite'		: ((oDirection.oZusatz.strVorgabeFussBreite && oDirection.oZusatz.strVorgabeFussBreite!= 'SONST')? oDirection.oZusatz.strVorgabeFussBreite :(oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport != 'SONST' ? oDlg.Klemmsystem.strSelComboWidthBaseOfTheSupport : oDlg.Klemmsystem.dOtherWidthBaseOfTheSupport)),
			'strBauformLG10'			: (oDlg.AuswahlStandard.oSearchResult.oResultLager.BAU_F*1 == 10 ? 1 : 0),
			'strBauformLGE'				: (oDlg.AuswahlStandard.strSelComboSlidingPart == 'LGE' ? 1 : 0)
		}
		var strType 		= Klemmsystem.berechneRelevanteBaureihe(oZusatz);
		
		if (UpliftRestraint)
		{
			var strPartSQL = " (TYP like '"+strType+"%' ";
			oZusatz.bAbhebesicherung4fach = UpliftRestraint;
			strType	= Klemmsystem.berechneRelevanteBaureihe(oZusatz);
			strPartSQL	+= " OR TYP like '"+strType+"%') ";
		}
		else
			var strPartSQL = " TYP like '"+strType+"%' ";
		
		strPartSQL += oDirection.sqlString;
		if(oDlg.AuswahlStandard.oSearchResult.oResultLager && (oDlg.Klemmsystem.strSelRadioFixed != "OHNE")){
			if(oDlg.AuswahlStandard.oSearchResult.oResultLager.TF && oDlg.AuswahlStandard.oSearchResult.oResultLager.TF != "-"){
				//strPartSQL = strPartSQL ? strPartSQL+" AND abs(TF) > "+oDlg.AuswahlStandard.oSearchResult.oResultLager.TF+""
				//				: "abs(TF) > "+oDlg.AuswahlStandard.oSearchResult.oResultLager.TF+"";
				//if (oDlg.AuswahlStandard.oSearchResult.oResultLager.TF*1 < 15)
				//	strPartSQL	+= " AND abs(TF) <= "+(oDlg.AuswahlStandard.oSearchResult.oResultLager.TF*1 + 5)+"";
				
				// @@@ LGE Test
				var TF	= oDlg.AuswahlStandard.oSearchResult.oResultLager.TF*1;
				TF		+= (oZusatz.strBauformLGE ? oDlg.AuswahlStandard.oSearchResult.oResultGleitelement.E*1 : 0);
				strPartSQL	= strPartSQL ? strPartSQL+" AND abs(TF) >= " + (TF+2) + "" : "abs(TF) >= " + (TF+2) + "";
				strPartSQL	+= " AND abs(TF) <= " + (TF+7) + "";
			}
		}
		if (oZusatz.strBauformLG10)
			strPartSQL	+= "";	// wir brauchen nichts weiter
		else if ((oDlg.Klemmsystem.bGaT) && oDlg.AuswahlStandard.strSelRadioFunction == "GEFUEHRT")
			strPartSQL	+= " AND abs(BREITE) = "+(oDlg.AuswahlStandard.oSearchResult.oResultLager.A)*1+"";
		else if ((oDlg.Klemmsystem.bGaT) && oDlg.AuswahlStandard.strSelRadioFunction == "LOSE")
			strPartSQL	+= " AND abs(BREITE) > "+(oDlg.AuswahlStandard.oSearchResult.oResultLager.A)*1+"";
		
		return strPartSQL;
	}
	var strSql 		= "SELECT * FROM 'KXX' WHERE "
		strSql		+= _buildDirection(oDlg)
		
	var dbName				= 'LAGER2';
	var aResult 			= new Array();
	var oAllDBDaten 		= Klemmsystem.Search.getSearchResultData(dbName,strSql);
	
	var dResult 	= 0;
	var strError 	= '';
	var _setError = function(strValue){
		if(!strError)
			strError = strValue;
	}
	
	for(var i=0;i<oAllDBDaten.length;i++){
		var oRet 	= Klemmsystem.Search.TestAndModify_LagerSystem(oDlg,oAllDBDaten[i],'KXX',oZusatz);
		if(oRet.bOk){
			dResult +=1;
			setDataIntoLagerCacheObject('AuswahlKlemmsystem','TABLE',(oRet.oData));		
		}
		else
			_setError(oRet.oData.strError);	
	}
	
	return (dResult > 0 ? Klemmsystem.getClientTable(oDlg) : ['ERROR',strError]);
}