/**
 * @category   Klemmsystem function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Klemmsystem ) === 'undefined' )
	Klemmsystem = {};
if ( typeof( Klemmsystem.Search ) === 'undefined' )
	Klemmsystem.Search = {};


/**
 * Test des gefunden Klemmsystems
 */
Klemmsystem.Search.TestAndModify_LagerSystem = function(oDlg, oData,strTable,oZusatz){
	var oRet				= {};
	oRet.oData 				= oData;
	oRet.bOk 				= false;
	var strTyp				= oData.TYP;
	// indirekt gleitend Typ 10
	if (oZusatz.strBauformLG10)
		oRet.bOk	= true;
	// indirekt gleitend alle anderen
	else if(oDlg.Klemmsystem.bGaT && ((oData.BAU_F)*1 >= 40) && (rfind(strTyp,"RL") <= 0) ){
		// Prfung, ob gengend Platz fr Querbewegung ist
		if (oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_ZUBEHOER" ||
				((oDlg.AuswahlStandard.oSearchResult.oResultLager.A*1 + abs(oDlg.SollwerteHalterungspunkt.oTable.bewegung_minus.quer)*1
				+ abs(oDlg.SollwerteHalterungspunkt.oTable.bewegung_plus.quer)*1) <= oData.BREITE*1))
					oRet.bOk = true;
	}
	// direkt gleitend
	else if(!oDlg.Klemmsystem.bGaT && ((oData.BAU_F)*1 < 40) && (rfind(strTyp,"RL") <= 0) )
		oRet.bOk = true;
	// KSY Rollenlager
	else if (oDlg.Systemcharakteristik.strSelZubehoerComboLager == "KR" && (rfind(strTyp,"RL") > 0))
		oRet.bOk = true;
	
	// Prfung, ob 4-fach AHS zulssig/sinnig - nur wenn auch ein Lager da ist!!!
	if (oDlg.AuswahlStandard.oSearchResult.oResultLager){
		if (left(strTyp, 3) == "KAT" &&
			(oDlg.AuswahlStandard.dBeamWidth*1 >= (oDlg.AuswahlStandard.oSearchResult.oResultLager.L*1 + abs(oDlg.SollwerteHalterungspunkt.oTable.bewegung_minus.axial)*1 + abs(oDlg.SollwerteHalterungspunkt.oTable.bewegung_plus.axial)*1)
			|| oDlg.AuswahlStandard.oSearchResult.oResultLager.L*1-abs(oDlg.SollwerteHalterungspunkt.oTable.bewegung_minus.axial)*1 - abs(oDlg.SollwerteHalterungspunkt.oTable.bewegung_plus.axial)*1 - oDlg.AuswahlStandard.dBeamWidth*1 <= 10))
			oRet.bOk = false;
	}
	
	if(oRet.bOk){
		oRet				= Base.TestAndModify(oDlg,oData,1);
		oRet.oData.strError	= oRet.strError;
		//oRet.bOk	= Base.TestAndModify(oDlg,oData,1).bOk;
	}
		
	//- 05.12.2011 Tel.: GEW auf zwei Stellen nach den Komma Runden
	if(oRet.oData.GEW)
		oRet.oData.GEW = Math.round(oRet.oData.GEW*100) / 100;
	
	if(oRet.bOk){
		var strKorrigierterTyp = strTyp;
		var nIndex = strTyp.indexOf( '-TXXX' );	// spezielle T-Profile
		if ( nIndex == -1 )
			nIndex = strTyp.indexOf( '-LXXX' );	// spezielle L-Profile
		if ( nIndex == -1 )
			nIndex = strTyp.indexOf( '-UXXX' );	// spezielle U-Profile
		// else Profil mit Standardtraegerbreite
		
		if ( nIndex > -1 ){
			//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< hier muss noch was gendert werden !!!!!!!!!!!!!
			var strSchluesselSuffix;
			if(oZusatz.strVorgabeTraegerbreite){
				strSchluesselSuffix = oZusatz.strTypenschluesselSuffix;
				
				if(!strSchluesselSuffix)
					//strSchluesselSuffix = "-"+oZusatz.strVorgabeProfilform+""+oZusatz.strVorgabeTraegerbreite;
					strSchluesselSuffix = "-" + oZusatz.strVorgabeProfilform + "" + (oDlg.AuswahlStandard.dBeamWidth*1 < 100 ? "0" + oDlg.AuswahlStandard.dBeamWidth : oDlg.AuswahlStandard.dBeamWidth);
			}
			
			if(strSchluesselSuffix)
				strKorrigierterTyp = left( strTyp, nIndex ) +strSchluesselSuffix;
			else{	
				strKorrigierterTyp = strKorrigierterTyp.replace('-TXXX','-T'+oData.TRAEGERBREITE);
			}
			
		}
		
		if((oRet.oData.TRAEGERBREITE == '-') && oZusatz.strVorgabeTraegerbreite)
			oRet.oData.TRAEGERBREITE = oZusatz.strVorgabeTraegerbreite;
		
		oRet.oData.TYP_CALCULATION 	= strKorrigierterTyp;
		//DAS HIER IST NICHT SCHN ABER DA H,B UND TG NICHT IN DER KXX TABELLE SIND MUSS DAS AN DER STELLE SEIN
		oRet.oData.H				= oDlg.AuswahlStandard.dBeamHeight;
		oRet.oData.B				= oDlg.AuswahlStandard.dBeamWidth;	
		oRet.oData.TG				= oDlg.AuswahlStandard.dBeamThickness;
	}
	
	return oRet;
}