/**
 * @category   Klemmsystem function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Klemmsystem ) === 'undefined' )
	Klemmsystem = {};
if ( typeof( Klemmsystem.Search ) === 'undefined' )
	Klemmsystem.Search = {};

/**
 * Zentraler Einstieg zu suche von Klemmsystemen
 * Wird direkt aufgerufen aus dem Kontroller 
 * @return {Object}
 */
Klemmsystem.Search.getSearchResult = function(oDlgLagerSession){
	var myData;
	var oResult = {};
	
	switch(oDlgLagerSession.AuswahlRollenlager.strDialogId){			
		case "ROLLENLAGER_K" :
				setDataIntoLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE');
				myData = Klemmsystem.Search.KlemmsystemTyp.Zubehoer(oDlgLagerSession);
			break;		
		default :
				switch(oDlgLagerSession.Klemmsystem.strDialogId){
					case "LAGERSYSTEM" :
							myData = Klemmsystem.Search.KlemmsystemTyp.Lagersystem(oDlgLagerSession);
						break;
					case "ZUBEHOER"	:
							myData = Klemmsystem.Search.KlemmsystemTyp.Zubehoer_Gleitlager(oDlgLagerSession);
						break;
					default :
						alert("ERROR: Klemmsystem.Search.getSearchResult - "+oDlgLagerSession.Klemmsystem.strDialogId);
				}
			break;
	}
	
	
	if(myData.length == 2){
		try{
			if(myData[0] == 'ERROR' && myData[1] != '')
				oResult.Error = myData[1];
			else if(myData[0] == 'ERROR')
				oResult.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
			else
				oResult.aTableData = myData;
		}
		catch(err){}
	}
	else if(myData.length == 0)
		oResult.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
	else
		oResult.aTableData = myData;
	
	return oResult;
}

Klemmsystem.Search.getDefaultSQL = function(oDlgLagerSession,strTable){
	var _TypLimit = function(){
		if(oDlgLagerSession.AuswahlStandard.strResultId){
			var oSelectionData 	 = oDlgLagerSession.AuswahlStandard.oSearchResult;
			var oKlemmsystemData = getDataFromLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE',oDlgLagerSession.AuswahlStandard.strResultId);
			var strPart1SQLTable = '';
			
			if(oSelectionData.TF){
				var dTF = 2;
				if(oSelectionData.TF != '-' && (rfind(oKlemmsystemData.TYP_KS,"KL")<1)){				
					dTF += (oSelectionData.TF*1);
					strPart1SQLTable = " AND TF <= "+dTF+"";
				}	
				else
					strPart1SQLTable = " AND TF = '-'";				 
			}
			
			if(oSelectionData.TYP_KS && rfind(oKlemmsystemData.TYP_KS,",")<1){
				if(rfind(oSelectionData.TYP_KS,"KO")>0)
					strPart1SQLTable = " AND TF = '-'";	
					
				return (strPart1SQLTable+" AND TYP like '"+oKlemmsystemData.TYP_KS+"'");
			}
			else{
				var aSplit;
				if(oSelectionData.TYP_KS)
					aSplit = oSelectionData.TYP_KS.split(",");
				else if(oKlemmsystemData.TYP_KS)
					aSplit = oKlemmsystemData.TYP_KS.split(",");
				
				var strPartSQLTable = '';
				var strLastID 			= oDlgLagerSession.DialogHistoryIDs[(oDlgLagerSession.DialogHistoryIDs.length-1)];
				if(strLastID == "lager.auswahl_klemmsystem")
					strLastID 			= oDlgLagerSession.DialogHistoryIDs[(oDlgLagerSession.DialogHistoryIDs.length-2)];
				
				for(var a=0;a<aSplit.length;a++){
					if(strLastID !="lager.auswahl_standard" && !(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "ZUBEHOER" && oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager =='KG')){
						if(oDlgLagerSession.AuswahlRollenlager.strSelRadioFixed == 'OHNE' && aSplit[a] == 'KO%' ){
							strPartSQLTable = strPartSQLTable == '' ? " AND TYP like '"+aSplit[a]+"'" : " OR TYP like '"+aSplit[a]+"'";
							strPart1SQLTable = " AND TF = '-'"; //hier gibt es laut DB keine Wert fr die Fudicke
						}
						else if(oDlgLagerSession.AuswahlRollenlager.strSelRadioFixed == 'MIT' && aSplit[a] !== 'KO%')
							strPartSQLTable = strPartSQLTable == '' ? " AND TYP like '"+aSplit[a]+"'" : strPartSQLTable+" OR TYP like '"+aSplit[a]+"'";
					}
					else 
						strPartSQLTable = strPartSQLTable == '' ? " AND TYP like '"+aSplit[a]+"'" : strPartSQLTable+" OR TYP like '"+aSplit[a]+"'";
				}
				
				if(rfind(strPartSQLTable,"OR")>0){
					strPartSQLTable +=")";
					strPartSQLTable = strPartSQLTable.replace("AND ", "AND (");
					strPartSQLTable = strPartSQLTable.replace("KAT","KAT%");
				}	
				
				return (strPart1SQLTable+" "+strPartSQLTable);
			}
		}
		else 
			return '';
	}
		
	var strSql = "SELECT * FROM "+strTable;
		strSql += " WHERE OBFL <> '' ";
		strSql += _TypLimit();
	
	return strSql;
}

/**
 * erstelle zustgzliche SQL - WHERE Anweisung (Default)
 * @return {Object}
 */
Klemmsystem.Search.buildDefaultDirection = function(oDlg){
	var strPartSQL = '';
	var strTraegerart = oDlg.AuswahlStandard.strSelComboBeamArt;
	
	var strTypenschluesselSuffix = "";
	var oTraegerdaten = Klemmsystem.holeTraegerdaten( strTraegerart, oDlg.AuswahlStandard.strSelComboBeamSize );
	
	if ((( strTraegerart == "HEB") || (strTraegerart == "HEA") || (strTraegerart == "IPE") 
		|| (strTraegerart == "INP") || (strTraegerart == "T_PROFIL") ) && (oTraegerdaten.strVarKlemm == "T140") )
		strTypenschluesselSuffix = "" ; 
	else 
		strTypenschluesselSuffix = "-" + oTraegerdaten.strVarKlemm;	// Spezial
	
	// Breite Lagerfuss bei Gleitunterlage am Klemmsystem
	var strVorgabeWertGleitunterlage 	= "0";
	var strVorgabeFussBreite 			= "";
	
	var strLastID 	= oDlg.DialogHistoryIDs[(oDlg.DialogHistoryIDs.length-1)];
	if(strLastID == 'lager.auswahl_standard'){
		if (oDlg.Klemmsystem.bGaT && (oDlg.Klemmsystem.strDialogId == "LAGERSYSTEM")){
			strVorgabeFussBreite 			= oDlg.AuswahlStandard.oSearchResult.oResultLager.A ? oDlg.AuswahlStandard.oSearchResult.oResultLager.A : mid( 'ID_B080', 5, 7 ); //<-- muss noch korrigiert werden
			strVorgabeWertGleitunterlage 	= "2";
			
			logtraceln("Z150 - WAHL KLEMMSYSTEM Fussbreite: "+strVorgabeFussBreite);
		}
	}
	
	var strVorgabeTraegerbreite	= oDlg.AuswahlStandard.dBeamWidth;
	var strVorgabeProfilform 	= "T";
	if ((strTraegerart == "HEB") || (strTraegerart == "HEA") || (strTraegerart == "IPE") 
		|| (strTraegerart == "INP") || (strTraegerart == "T_PROFIL")){
		if ( oTraegerdaten.strVarKlemm == "T140" )
			strVorgabeTraegerbreite = "140";
	}
	else if ( strTraegerart == "U_PROFIL" )
		strVorgabeProfilform = "U";
	else if ( ( strTraegerart == "L_PROFIL_G" ) || ( strTraegerart == "L_PROFIL_U" ) )
		strVorgabeProfilform = "L";
	
	//strPartSQL += " AND GL_U = '"+strVorgabeWertGleitunterlage +"'";
	strPartSQL += " AND PROFILFORM like '"+strVorgabeProfilform+"%'";
	
	if (strVorgabeProfilform == 'T' && oTraegerdaten.strVarKlemm == "T140")
		strPartSQL += " AND TRAEGERBREITE = '"+strVorgabeTraegerbreite+"'";		
	else
		strPartSQL += " AND TRAEGERBREITE = '-'";
	
	/*
	var oKlemmData = getDataFromLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE'); 
	if(oKlemmData.length>0){
		var oKlemmDataSel 	= getDataFromLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE',oDlg.AuswahlStandard.strResultId);
		var strTypReihen 	= oKlemmDataSel.TYP_KS;
		if(oDlg.AuswahlRollenlager.strSelRadioFixed == 'MIT'){
			strTypReihen = strTypReihen.replace("KO%,","");
			strTypReihen = strTypReihen.replace("KAT","KAT%");
		}	
		else
			strTypReihen = 'KO%';
			
		strTypReihen = strTypReihen.replace(","," OR TYP like '");
		strTypReihen = strTypReihen.replace("%","%'");
		strPartSQL += " AND (TYP like '"+strTypReihen+")";
	}*/
	
	
	oZusatz = {
		'strTypenschluesselSuffix' 	: strTypenschluesselSuffix,
		'strVorgabeFussBreite'		: strVorgabeFussBreite,
		'strVorgabeTraegerbreite'	: strVorgabeTraegerbreite,
		'strVorgabeProfilform'		: strVorgabeProfilform
	}
	
	return ({
		'oZusatz' 	: oZusatz,
		'sqlString' : strPartSQL
	});
};
	
Klemmsystem.Search.getTypData = function(oDlg,strTyp,strTable){
	var aSplitTyp = Klemmsystem.getKlemmsystemTypReihen(oDlg,strTyp);
	if(aSplitTyp)
		aSplitTyp = aSplitTyp.split(",");
	else{
		aSplitTyp = new Array();
		aSplitTyp.push(strTyp.TYP_KS);
	}	
	var strSqlTyp;
	for(var a=0;a<aSplitTyp.length;a++){
		if(a==0)
			strSqlTyp = " TYP like '"+aSplitTyp[0]+"'";
		else
			strSqlTyp = " OR TYP like '"+aSplitTyp[a]+"'";
	}	

	var strSql = "select * from "+strTable+" WHERE"+strSqlTyp;
	var dbName		= 'LAGER2';
	var dbNameTable = "KLEMMSYSTEMTYP";
	
	var oRet;
	if ( dbselect( dbName, strSql, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			oRet = Klemmsystem.Search.getSearchResultData(dbNameTable);
			dbskip( dbNameTable );
		}
	}
	
	return oRet;
};

Klemmsystem.Search.getSearchResultData = function(dbName,sqlString){	
	return (Object.fromDatabase(dbName,sqlString));
};