/**
 * @category   Klemmsystem function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Klemmsystem ) === 'undefined' )
	Klemmsystem = {};

/**
 * Nach welchen Klemmsystemtypen muss gesucht werden
 * @param [oDlg]{Object}
 * @param [strTypen] {String}
 * @return {String}
 */
Klemmsystem.getKlemmsystemTypReihen = function(oDlg,strTypen){
	var strTypReihen;
	if(!strTypen){
		if(oDlg.AuswahlRollenlager.bUpliftRestraint && ((caMainController.getLagerTopologieklasse().isGleitlager() && oDlg.AuswahlStandard.strSelRadioFunction !== "LOSE") || caMainController.getLagerTopologieklasse().isFestlager()))
			strTypReihen = 'KZT,KAT,KZU,KZL';
		else if((caMainController.getLagerTopologieklasse().isGleitlager() && oDlg.AuswahlStandard.strSelRadioFunction === "LOSE"))
			strTypReihen = 'KLT,KLU,KLL';
		else
			strTypReihen = 'KOT,KOU,KOL';
	}
	else{
		if((caMainController.getLagerTopologieklasse().isGleitlager() && oDlg.AuswahlStandard.strSelRadioFunction === "LOSE")){
			var _add = function(strTyp){
				if(strTypReihen)
					strTypReihen += ','+strTyp;
				else
					strTypReihen = strTyp;
			}
			
			var aSplit = strTypen.split(",");		
			for(var a=0;a<aSplit.length;a++){
				if(oDlg.AuswahlRollenlager.bUpliftRestraint){
					if(rfind('KZ',aSplit[a])>0)
						_add(aSplit[a]);
					
					if(rfind('KA',aSplit[a])>0)
						_add(aSplit[a]);
				}
				else{
					if(rfind('KO',aSplit[a])>0)
						_add(aSplit[a]);
				}
			}
		}
		else
			strTypReihen = strTypen;
	}
	
	return strTypReihen;
}

/**
 * berechnet die fr die Suche relevante Baureihe des Klemmsystems
 *
 * @param [oZusatzData] {Object} oZusatzfunktionen - Zusatzfunktionen fr das Lager
 *				  - boolean bAbhebesicherung - Abhebesicherung gewhlt?
 *				  - boolean bAbhebesicherung4fach - Abhebesicherung 4-fach gewhlt?
 *				  - boolean bGleitunterlage - Gleitunterlage gewhlt?
 *                - string strBreite - Lagerfubreite
 *			  	  - string strLagerart
 *				  - string strTraegerart
 * @returns	string Kennung der relevanten Baureihe
 */
Klemmsystem.berechneRelevanteBaureihe = function(oZusatzData){
	var strFirstChar = "K";
	var strSecondChar = "";
	var strThirdChar = "";
	
	// zweites Zeichen
	if ( oZusatzData.strBauformLG10 )
		strSecondChar	= "S";
	// @@@ LGE Test
	//else if ( oZusatzData.strLagerart == "FUEHRUNGSLAGER" || oZusatzData.strLagerart == "GEFUEHRT" 
	//			|| oZusatzData.strLagerart == "GEFUEHRT_MEHRFACH")
	else if ( oZusatzData.strLagerart == "FUEHRUNGSLAGER" || oZusatzData.strLagerart == "GEFUEHRT" 
				|| oZusatzData.strLagerart == "GEFUEHRT_MEHRFACH" || oZusatzData.strBauformLGE
				|| (oZusatzData.strLagerart == "LOSE" && !oZusatzData.bGleitunterlage))
	{
		if ( oZusatzData.bAbhebesicherung )
		{
			if ( oZusatzData.bAbhebesicherung4fach )
				strSecondChar = "A"
			else strSecondChar = "Z"
		}
		else strSecondChar = "O"
	}
	else strSecondChar = "L"

	// drittes Zeichen
	if ( oZusatzData.strBauformLG10 )
		strThirdChar	= "Y";
	else if ( oZusatzData.strTraegerart == "U_PROFIL" )
		strThirdChar = "U"
	else if ( ( oZusatzData.strTraegerart == "L_PROFIL_G" ) || ( oZusatzData.strTraegerart == "L_PROFIL_U" ) || ( oZusatzData.strTraegerart == "L_PROFIL" ))
		strThirdChar = "L"
	else strThirdChar = "T"

	return( strFirstChar + strSecondChar + strThirdChar );
}

/**
 * @public function - Existitiert eine Abhebesicherung
 * @param [oDlgLagerSession] {Object} DialogObject
 * @return {Object}
 */
Klemmsystem.getDataAbhebesicherung = function(oDlgLagerSession){
	var oData = {};
	if(oDlgLagerSession.AuswahlStandard.strResultId){ //Klemmsystem Typ (oDlgLagerSession.AuswahlStandard.strResultId)
		var oKlemmsystemData = getDataFromLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE',oDlgLagerSession.AuswahlStandard.strResultId);
		
		var dbName			= 'LAGER2';
		var sqlString 		= "SELECT * FROM AUSLEGUNG_KLEMMSYSTEM_TRAEGER WHERE KLEMMSYSTEM like '"+oKlemmsystemData.TYP_KS_DEFAULT+"'";
		var dbNameTable 	= "AUSLEGUNG_KLEMMSYSTEM_TRAEGER_FUNCT_LAGERSYSTEM";
		
		if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){
			var bAbhebesicherung 	= false;
			var bSchraubbarZweifach = false;
			var bSchraubbarViewfach = false;
			
			while ( dbiseof( dbNameTable) == 0 ){
				if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"ABHEBESICHERUNG")))
					bAbhebesicherung = true;
					
				if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_ZWEIFACH")))
					bSchraubbarZweifach = true;	
					
				if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_VIERFACH")))
					bSchraubbarViewfach = true;
				
				dbskip( dbNameTable );
			}
			
			//if(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial || oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer || oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief ||
			//	oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial || oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer || oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief 
			//)
			// ohne sollte auch bei vorgegebener Abhebelast whlbar sein
			/*if(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief)
			{
				oData.bOhne 				= false; 	//existier immer also nie disabled
				oData.bMit  				= bAbhebesicherung;	//default disabled 
			}
			else{*/
				if (left(oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager.TYP, 3) == "LKG")
					oData.bOhne 				= false;
				else
					oData.bOhne 				= true; 	//existier immer also nie disabled -> Ausnahme LKG 10
				oData.bMit  				= bAbhebesicherung;	//default disabled 
			//}
			oData.bSchraubbarZweifach 	= bSchraubbarZweifach;
			oData.bSchraubbarViewfach 	= bSchraubbarViewfach;					
		}
	}
	
	return (oData);
}

/**
 * @public function - gib alle passenden Trgerart als Array zurck
 * @param [oDlgLagerSession] {Object}
 * @param [strTraegertyp] {String} kann / muss aber nicht bergeben werden
 * - wenn bergabe dann folgt Spezial
 * @return {Object}
 */
Klemmsystem.getDataTraeger = function(oDlgLagerSession,strTraegertyp){
	var oData = {};
	var oKlemmsystemData = getDataFromLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE',oDlgLagerSession.AuswahlStandard.strResultId);
		
	var dbName			= 'LAGER2';
	var dbNameTable 	= "AUSLEGUNG_KLEMMSYSTEM_TRAEGER";
	var aStore			= new Array();
	
	var sqlString 		= "select KLEMMSYSTEM,AUSLEGUNG_KLEMMSYSTEM_TRAEGER.TRAEGER_TABELLE AS ATT, PROFILART.ID AS PTT, PROFILART";
			sqlString  += " from AUSLEGUNG_KLEMMSYSTEM_TRAEGER,PROFILART";
			
	if(oKlemmsystemData.TYP_KS_DEFAULT)
		sqlString  += " WHERE KLEMMSYSTEM = '"+oKlemmsystemData.TYP_KS_DEFAULT+"'";
	else if(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_ZUBEHOER" && oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager == 'KR')
		sqlString  += " WHERE KLEMMSYSTEM_TYP = 'KOT'";	
	
	if(rfind(sqlString,"WHERE")>0)	
		sqlString  += " AND TRAEGER_TABELLE = PROFILART.ID";
	else
		sqlString  += " WHERE TRAEGER_TABELLE = PROFILART.ID";
		
	sqlString  += " GROUP BY PTT";
	
	// Spezial 
	// - fr Zubehr Klemmsystem Gleitelement
	// - fr Rollenlager
	if((oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_ZUBEHOER" && oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager == 'KG') ||
		(strTraegertyp)){
		sqlString = "SELECT * FROM PROFILART";
		
		if(strTraegertyp)
			sqlString += " WHERE TRAEGERTYP ='"+strTraegertyp+"'";
	}	
	
	if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			if((oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_ZUBEHOER" && oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager == 'KG') || strTraegertyp)
				aStore.push([dbgetstring(dbNameTable,"ID"),dbgetstring(dbNameTable,"PROFILART")]);
			else
				aStore.push([dbgetstring(dbNameTable,"PTT"),dbgetstring(dbNameTable,"PROFILART")]);
				
			dbskip( dbNameTable );
		}
	}
	
	oData.Store 		= aStore;
	oData.strProfilart  = oDlgLagerSession.AuswahlStandard.strSelComboBeamArt;	
	
	return oData;
};

/** 
 * Trgergre
 * @param [strProfilart] {String}  - aktuelle Profilart
 * @param [strTraegergroesse] {String}  - aktuelle Traegergroesse
 * @returns	{Object} - strTraegerhoehe - Trgerhhe
 *                   strTraegerbreite - Trgerbreite
 *                   strFlanschdicke - Flanschdicke
 */
Klemmsystem.holeTraegerdaten = function( strProfilart, strTraegergroesse ){
	// bestimme zuerst Trgerhhe, -breite und Flaschdicke aus den Daten der Trgergre
	var strHoehe = "";
	var strBreite = "";
	var strDicke = "";
	var strVarKlemm = "T140";
	
	if (strTraegergroesse != "-") {
		// baue select-statement
		var strSelect = "SELECT * FROM " + strProfilart + " WHERE TRAE_GR = '" + strTraegergroesse + "' ";
		// hole Werte aus Tabelle
		var strDBCache = "RH_TRAEGER";
		if ( dbselect( "LAGER2", strSelect, strDBCache ) ){
			// es sollte nur einen resultierenden Record geben; ist die Tabelle fehlerhaft und es gibt mehr, nehmen wir hier einfach den ersten
			strHoehe 	= dbgetstring( strDBCache, "H" );
			strBreite 	= dbgetstring( strDBCache, "B" );
			strDicke 	= dbgetstring( strDBCache, "tg" );
			strVarKlemm = dbgetstring( strDBCache, "VAR_KLEMM" );	// wird fr Korrektur des Typenschlssels und Berechnung des Bildnamens gebraucht
		}
	}
	else {
		strHoehe 	= getstring( "dBeamHeight", "DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard" );
		strBreite 	= getstring( "dBeamWidth", "DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard" );
		strDicke 	= getstring( "dBeamThickness", "DLGDATA.CA.FORMS.LAGER2DATA.AuswahlStandard" );
		if (left(strProfilart, 1) != "U" && left(strProfilart, 1) != "L")
			strVarKlemm = "T" + strBreite ;
		else
			strVarKlemm = left(strProfilart, 1) + (strBreite*1 < 100 ? ("0" + strBreite) : strBreite) + "x" + (strHoehe*1 < 100 ? ("0" + strHoehe) : strHoehe);
	}
	
	// Rckgabe der gefundenen Werte
	return({
		strTraegerhoehe	: strHoehe,
		strTraegerbreite: strBreite,
		strFlanschdicke	: strDicke,
		strVarKlemm		: strVarKlemm
	} );
}

/**
 * bestimme Client Tabelle
 * @param [oDlgLagerSession] {Object}
 * @param [bStandard] {Boolean} true/false or undefined
 * @return {Array}
 */
Klemmsystem.getClientTable = function(oDlgLagerSession,bStandard){
	if(bStandard == undefined)
		bStandard = true;	
	var oDataRes;
	var aResult = new Array();
	
	
	switch(oDlgLagerSession.AuswahlRollenlager.strDialogId){		
		case "ROLLENLAGER_P" :
		case "ROLLENLAGER_S" :
		case "ROLLENLAGER_K" :
				oDataRes = getDataFromLagerCacheObject('AuswahlRollenlager','TABLE');
			break;
		case "ROLLENLAGER_U_SATTEL":
			break;
		default :
			bStandard = false;
			oDataRes = getDataFromLagerCacheObject('AuswahlKlemmsystem','TABLE');
	}
 
	
	for(var i=0;i<oDataRes.length;i++){
		var aDBData = new Array();
		
		aDBData.push(oDataRes[i].TYP_CALCULATION ? oDataRes[i].TYP_CALCULATION+"_"+i : oDataRes[i].TYP+"_"+i); //ID
		aDBData.push(oDataRes[i].TYP_CALCULATION ? oDataRes[i].TYP_CALCULATION : oDataRes[i].TYP); //TYP
		if(bStandard){
			aDBData.push(oDataRes[i].DN);				
			aDBData.push(oDataRes[i].H);
			aDBData.push(oDataRes[i].E);
			aDBData.push(oDataRes[i].dHdD);					
			if (oDataRes[i].F_AUFL_CALCULATION)
				aDBData.push(oDataRes[i].F_AUFL_CALCULATION);
			else
				aDBData.push(oDataRes[i].F_AUFL);
			if (oDataRes[i].F_AXIAL_CALCULATION)
				aDBData.push(oDataRes[i].F_AXIAL_CALCULATION);
			else
				aDBData.push(oDataRes[i].F_AXIAL);
			if (oDataRes[i].F_QUER_CALCULATION)
				aDBData.push(oDataRes[i].F_QUER_CALCULATION);
			else
				aDBData.push(oDataRes[i].F_QUER);
			if (oDataRes[i].F_AB_CALCULATION)
				aDBData.push(oDataRes[i].F_AB_CALCULATION);
			else
				aDBData.push(oDataRes[i].F_AB);	
		}
		else{
			aDBData.push(oDataRes[i].F_AB);				
			aDBData.push(oDataRes[i].F_QUER);
			aDBData.push(oDataRes[i].TF);
		}
		aDBData.push(oDataRes[i].GEW);
		aDBData.push(Base.getPrice(oDataRes[i].PREIS));	
		
		aResult.push(aDBData);
	}
	
	return aResult;	
}