/**
 * @category   Gleitelement function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Gleitelement ) === 'undefined' )
	Gleitelement = {};
if ( typeof( Gleitelement.Search ) === 'undefined' )
	Gleitelement.Search = {};
if ( typeof( Gleitelement.Search.Gleitelementtyp ) === 'undefined' )
	Gleitelement.Search.Gleitelementtyp = {};	

Gleitelement.Search.Gleitelementtyp.Lager	= function(oDlg,oData){
	var aResult 	= new Array();
	
	// @@@ LGE Test
	// Unterscheidung in LGA/LGV bzw. LGE
	
	if (oDlg.AuswahlStandard.strSelComboSlidingPart == "LGE"){
		// Need for information clamped or not - fiel needed in FL
		switch (oDlg.AuswahlStandard.strSelRadioFunction)
		{ case "LOSE":
			switch (oDlg.AuswahlStandard.strSelComboAccessory)
			{	case "KLEMMBAR" :	// clamped
					var sqlString = "SELECT * FROM LGE_2023 WHERE Mov_Guid = " + 1 + " AND  abs(B_LG) = " + oData.A*1 +
									" AND abs(BTR) = " + 140 + "";
					var dbName		= 'LAGER2';
					var oAllData 	= Gleitelement.Search.getSearchResultData_AllColumns(dbName,sqlString);
					break;
					
				case "OHNE" :	// bolted or welded
					var sqlString = "SELECT * FROM LGE_2023 WHERE Mov_Guid = " + 2 + " AND abs(B_LG) = " + oData.A*1 +
									//" AND abs(BTR) = " + 140 + " AND abs(FMAX_LGX) >= " + oData.F_AUFL_CALCULATION*1 + "";
									// Zuordnung erfolgt unten nach dem "switch"
									" AND abs(BTR) = " + 140 + "";
					var dbName		= 'LAGER2';
					var oAllData 	= Gleitelement.Search.getSearchResultData_AllColumns(dbName,sqlString);
					break;
					
				default :
					break;
			}
		  break;
		case "GEFUEHRT" :
			switch (oDlg.AuswahlStandard.strSelComboAccessory)
			{	case "KLEMMBAR" :	// clamped
					var sqlString = "SELECT * FROM LGE_2023 WHERE Mov_Guid = " + 2 + " AND  B_LG = " + oData.A +
									" AND BTR = " + 140 + "";
					var dbName		= 'LAGER2';
					var oAllData 	= Gleitelement.Search.getSearchResultData_AllColumns(dbName,sqlString);
					break;
					
				default :
					break;
			}
		  break;
		case "MEHRFACH_GEFUEHRT" :
			switch (oDlg.AuswahlStandard.strSelComboAccessory)
			{	case "KLEMMBAR" :	// clamped
					
					break;
				case "..." :	// bolted or welded
					break;
					
				default :
					
					break;
			}
		  break;
		}
		//@@@ LGE Test - wir ordnen immer nur eine Size LGE dem Lager zu
		if (oAllData.length > 1){
			var TempOAllData	= oAllData;
			oAllData			= [];
			if (oData.BAU_F*1 <= 22)
				oAllData.push(TempOAllData[0]);
			else
				oAllData.push(TempOAllData[TempOAllData.length - 1]);
		}
	}
	else{
		var strTypLGX 	= oData.TYP_LGX.replace("LGx",oDlg.AuswahlStandard.strSelComboSlidingPart);
			strTypLGX 	= strTypLGX.replace("LGx",oDlg.AuswahlStandard.strSelComboSlidingPart);
			strTypLGX 	= strTypLGX.replace("xx","%%");
			
		var sqlString = "SELECT * FROM LGA_LGV WHERE TYP like '"+strTypLGX+"'";
		
		var dbName		= 'LAGER2';
		var oAllData 	= Gleitelement.Search.getSearchResultData_AllColumns(dbName,sqlString);
		
		var dResult 	= 0;
		var strError 	= '';
		var _setError = function(strValue){
			if(!strError)
				strError = strValue;
		}
	}
	
	for(var i=0;i<oAllData.length;i++){
		var oRet 	= Gleitelement.Search.TestAndModify_LagerSystem(oDlg,oAllData[i],oData,"LGA_LGV");
		
		if(oRet.bOk){ //build client Tabelle
			dResult +=1;
			var Typ	= (oRet.oData.TYP_CALCULATION ? oRet.oData.TYP_CALCULATION : oRet.oData.TYP);
			aResult.push(Typ);					
			setDataIntoLagerCacheObject('AuswahlGleitelement','TABLE',(oRet.oData));
		}
		else
			_setError(oRet.oData.strError);	
	}
	return (dResult > 0 ? (aResult) : ['ERROR',strError]);
};