/**
 * @category   Gleitelement function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Gleitelement ) === 'undefined' )
	Gleitelement = {};
if ( typeof( Gleitelement.Search ) === 'undefined' )
	Gleitelement.Search = {};

/**
 * Zentraler Einstieg zu suche von Gleitelement
 * Wird direkt aufgerufen aus dem Kontroller 
 * @return {Object}
 */
Gleitelement.Search.getSearchResult = function(oDlgLagerSession,oData,strDialog){
	var myData;
	//Bestimmung
	
	if(strDialog == 'TYP_LGX')
		myData = Gleitelement.Search.Gleitelementtyp.Lager(oDlgLagerSession,oData);
	
	
	var oRet = {
		'strError' : '',
		'aTableData' : []
	};
		
	if(myData.length == 2){
		try{
			if(myData[0] == 'ERROR' && myData[1] != '')
				oRet.strError = myData[1];
			else if(myData[0] == 'ERROR')
				oResult.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
			else
				oResult.aTableData = myData;
		}
		catch(err){}
	}
	else if(myData.length == 0)
		oRet.strError = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
	else
		oRet.aTableData = myData;
	
	return oRet;
}

/**
 * bestimme alle Daten aus der Datenbank
 * @param {String} Datenbank
 * @param {String} Sql Anweisung
 * @return {Object}
 */
Gleitelement.Search.getSearchResultData_AllColumns = function(dbName,sqlString){
	return (Object.fromDatabase(dbName,sqlString));
}