/**
 * @category   Store 
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Base ) === 'undefined' )
	Base = {};
if ( typeof( Base.Store ) === 'undefined' )
	Base.Store = {};

/**
 * get Currency data
 * @return {Object}
 */
Base.Store.getWaehrungsData = function(){
	var strWaehrungskuerzel = getstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR"); 	// "CZK";
	var strWaehrungsfaktor 	= getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR");  // 27.584;	// 1 EUR = xx Fremdwhrung
	
	return ({
		'CURRENCY_UNIT' 	: strWaehrungskuerzel,
		'CURRENCY_FACTOR' 	: strWaehrungsfaktor
	});
}

/**
 * get Setting Data
 * @return {Object};
 */
Base.Store.getSettings = function(){
	var oSettings = Object.fromStorage("PROJECT.SETTINGS.CASCADE");
	
	return oSettings;
} 

/**
 * get Oberflache Settings
 */
Base.Store.getOberflaeche = function(){
	var strSchel1Setting 	= getstring("OBFL_SCHEL1","PROJECT.SETTINGS.CASCADE");
	var strSchel2Setting 	= getstring("OBFL_SCHEL2","PROJECT.SETTINGS.CASCADE");
	var strSchel3Setting 	= getstring("OBFL_SCHEL3","PROJECT.SETTINGS.CASCADE");
	var strSchel4Setting 	= getstring("OBFL_SCHEL4","PROJECT.SETTINGS.CASCADE");
	
	
	return ({
		'strSchel1Setting' : Produkt.getOberflaechenSchutzId(strSchel1Setting),
		'strSchel2Setting' : Produkt.getOberflaechenSchutzId(strSchel2Setting),
		'strSchel3Setting' : Produkt.getOberflaechenSchutzId(strSchel3Setting),
		'strSchel4Setting' : Produkt.getOberflaechenSchutzId(strSchel4Setting)
	});
}

Base.Store.getCDMode = function(){
	return (tolower( getstring( "CATALOG.INTERNETSERVERINCDMODE", "ROOT" ) ));
}

/**
 * is Sales Version
 * @return {Boolean}
 */
Base.Store.isSalesVersion = function(){
	return (Base.convertStringToBoolean(getstring("SALESVERSION","RIGHTS")));
}

/**
 * is Expert Mode
 * @return {Boolean}
 */
Base.Store.isExpertMode = function(){
	return (getbool("EXPERT_MODE","RIGHTS"));
}

/**
 * gib die SessionId
 */
Base.Store.getSessionId = function(){
	var strSessionId 	= getstring("sessionid","");
	
	return strSessionId;
}

/**
 * gib Store Object der Systemcharakteristik
 * @return {Object}
 */
Base.Store.getForms= function(){
	var oRet = Object.fromStorage("DLGDATA.CA.FORMS");
	return oRet;
}

/**
 * gib Store Variable IDC_VERTIKALDIR_ACHS_DEF zurck
 * @return {String } X/Y/Z
 */
Base.Store.getSettingsVerticalAchse = function(){
	var strVerticalAchse = getstring("IDC_VERTIKALDIR_ACHS_DEF","PROJECT.SETTINGS.CASCADE");
	
	return right(strVerticalAchse,1);
}	