/**
 * @category   Product Logic
 * @package    Core
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */

// building the namespace
if ( typeof( Base ) === 'undefined' )
	Base = {};

/**
 * Ist eine Wert im Array enthalten
 */
Base.isCovered = function( array, value , dArrayPosition)
{
	for(var a=0;a<array.length;a++){
		var aPart = array[a];
		if(aPart[dArrayPosition] == value)
			return true;			
	}
	
	return false;
}

/**
 * Erstelle Preis und Formatiere den Preis
 * NUR Fuer Lager / Sttel usw. innerhalb der Suche / Anzeige Ergebnislisten
 * In der Stckliste wird die entsprechende Funktion aus dem Produkt herangezogen.
 * @param [dPrice] {Double} in EUR
 * @return {Double}
 */
Base.getPrice = function(dPrice){

	// Wenn der Anwender keine Rechte hat (sys.db3) keinen Preis zeigen
	if ( getstring( "PCODE", "CATALOG.SETTINGS" ) != "630927" )
		return( 0 );
	
	// Rabatte bercksichtigen
	// Aufruf an der Klasse geht, weil in der Funktion keine Objektvariablen benutzt werden ....
    dPrice = Produkt.getNettoPreis(dPrice, "RABATT_TYP_LAGER");

	// Whrungsumrechnung:
	var oCurrency 			= Base.Store.getWaehrungsData();
	var strWaehrungskuerzel = oCurrency.CURRENCY_UNIT;
	var dCurrencyFactor 	= oCurrency.CURRENCY_FACTOR*1;
	
	//var dWaehrungsfaktor = replace(strWaehrungsfaktor, ",", ".") - 0;				// 1 EUR = xx Fremdwhrung
	if (strWaehrungskuerzel == "")
		strWaehrungskuerzel = "EUR";
	if ((dCurrencyFactor < 0.01) || (strWaehrungskuerzel == "EUR"))
		dCurrencyFactor = 1.0;
	
	var dPrice = fround(dCurrencyFactor * dPrice, 2);
	
	if(dPrice <= 0)
		dPrice = translate("AUF_ANFRAGE");
	
	return dPrice;
}

/**
 * Konvertiere String zu Bool
 */
Base.convertStringToBoolean = function(strBoolean){
	if(strBoolean === 'true')
		return true;
	else
		return false;
}

/**
 * Konvertiere Json String zu einen Objekt 
 * @return {object}
 */
Base.getObjectFromJson = function (strJson) {
	var oObject = eval('(' + strJson + ')');
	return oObject;
}

/**
 * Ist ein Wert im Array entahlten
 * - Test auf Array Position 0
 * @param array 	
 * @param strTestId - array auf diesen Wert testen
 *
 * @return boolean: true / false
 */
Base.hasValueIntoArrayPositionNull = function( array, strTestId )
{
	if (! array)
		return( false );
		
	for( var i = 0; i < array.length; ++i )
	{
		if ( array[i][0] == strTestId )
			return( true )
	}
	
	return( false );
}

/**
 * Bestimmung Oberflche:
 * Anmerkung
 * - wird in verschieden Punkten gebraucht (darum hier zu finden)
 * @param [strSelection] {String} aktuell selektierter Wert
 * @return {Object} 
 *			- 'Store' fr Combobox
 *			- 'Selection' selektierter Wert
 */
Base.buildOberflaeche = function(strSelection){
	var aOberflaeche 		= [];
	var sqlstring 			= "select * from Oberflaeche WHERE OBERFL_ID < 8";
	
	var dbName				= 'CASCADE';
	var dbNameTable 		= "OBERFLAECHE";
	var dTableDatenLength 	= dbselect( dbName, sqlstring, dbNameTable );
	if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
		var strLanguage = getlanguage();
		while ( dbiseof( dbNameTable) == 0 ){
			var aDBData = new Array();
			aOberflaeche.push([dbgetstring(dbNameTable,"OBERFL_ID"),(strLanguage == 'DE' ? dbgetstring(dbNameTable,"OBERFL_TXT_DE") : dbgetstring(dbNameTable,"OBERFL_TXT_EN"))]);
			dbskip( dbNameTable );
		}
	}
	
	//Test ob Selectierung passt, wenn nicht selectiere neu
	if(!Base.hasValueIntoArrayPositionNull(aOberflaeche,strSelection))
		strSelection = aOberflaeche[1][0];
	
	return ({
		'Store' 	: aOberflaeche,
		'Selection' : strSelection
	})
};

/**
 * Bestimme Oberflchenfaktor
 */
Base.getOberflaechenFaktor = function(dOberflaeche){
	var dFaktor = 1;
	var sqlString 	= "SELECT * FROM FaktOBFL WHERE OBFL = '"+dOberflaeche+"'";
	var dbName 		= 'LAGER2';
	var dbNameTable = "OBERFLAECHE_DATA";
	if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			dFaktor = dbgetdouble(dbNameTable,"FAKTOBFL");
				
			dbskip( dbNameTable );
		}
	}
	
	return dFaktor;
};

/**
 * Bestimme Zuschlag fr Sonderaussendurchmesser
 */
Base.getSonderAussenDuMesserFaktor = function(){
	var dFaktor = 1;
	var sqlString 	= "SELECT * FROM FaktSONDER WHERE ART = 'DMR_S'";
	var dbName 		= 'LAGER2';
	var dbNameTable = "SONDER_DMR";
	if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			dFaktor = dbgetdouble(dbNameTable,"FAKTOR");
				
			dbskip( dbNameTable );
		}
	}
	return dFaktor;
};

/**
 * Bestimme Oberflchenfaktor Special Funktion
 */
Base.setSpecialOberflaechenFaktor = function(strLaqerTyp,strSelection,strWerkstoff){
	var strBuildNewSql;
	var sqlString = "select * from AUSLEGUNG_GLEIT_FEST_LAGER WHERE LAGER_TYP = '"+strLaqerTyp+"' GROUP BY LAGERREIHE";
	var dbName 		= 'LAGER2';
	var dbNameTable = "OBERFLAECHE_DATA";
	
	var strWerkstoff	= Werkstoffe[right(strWerkstoff,strWerkstoff.length - 6)];
	
	if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			var strText = dbgetstring(dbNameTable,"LAGERREIHE");
			var strSubstring = 	strText.substring(0,3);
			
			if(!strBuildNewSql)
				strBuildNewSql = "(TYP = '"+strSubstring+"'"
			else
				strBuildNewSql += " OR TYP = '"+strSubstring+"'"
			
			dbskip( dbNameTable );
		}
		
		if(strBuildNewSql)
			strBuildNewSql +=" )";
		else
			logtraceln("FEHLER - SQL Special Oberflaechenfunktion");		
	}
	
	var strBuildOberflaechenCombo  = "select * from Werkst_Obfl_Zuordnung WHERE ";
		strBuildOberflaechenCombo += strBuildNewSql;
		strBuildOberflaechenCombo += "AND abs(WERKSTOFF) = abs("+strWerkstoff+")"; 
		strBuildOberflaechenCombo += " GROUP BY OBFL";
	var dbNameTable = "OBERFLAECHE_DATA_1";
	var aOberflaechenArray = new Array();
	
	if ( dbselect( dbName, strBuildOberflaechenCombo, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			var strOberfl = dbgetdouble(dbNameTable,"OBFL");
			var dCount = 0;
			switch(strWerkstoff)
				case '37' 			:
				case 'LAGER_W_RST'	:
						if(strOberfl == 2){
							aOberflaechenArray.push([strOberfl,Base.getLanguageTextOberflaeche(strOberfl).strText]);
							dCount +=1;
						}
				default :
					if(dCount == 0)
						aOberflaechenArray.push([strOberfl,Base.getLanguageTextOberflaeche(strOberfl).strText]);
					
				
			dbskip( dbNameTable );
		}
	}
	
	if(aOberflaechenArray.length<=0)
		logtraceln("FEHLER - SQL- keine Oberflaechenwert gefunden");
	else{		
		if(!Base.hasValueIntoArrayPositionNull(aOberflaechenArray,strSelection))
			strSelection = aOberflaeche[1][0];
	}
	
	aOberflaechenArray.push(["4",translate("IDS_OBERFL_SONST")]);
	
	return ({
		'Store' 	: aOberflaechenArray,
		'Selection' : strSelection
	});
}

/**
 * Oberflchenfunktion
 */
Base.getLanguageTextOberflaeche = function(strOberflaeche){
	strOberflaeche = strOberflaeche*1;
	var m_Poberfl;
	if ( strOberflaeche == 0 )
		m_Poberfl = 'OB_ROH';
	else if ( strOberflaeche == 1)
		m_Poberfl = 'OB_GALV';
	else if ( strOberflaeche == 2 )
		m_Poberfl = 'OB_FEUER';
	else if ( strOberflaeche == 3 )
		m_Poberfl = 'OB_GRUND';
	else if ( strOberflaeche == 4 )
		m_Poberfl = 'OB_SONST';
	
	return ({
		strText : translate("IDS_OBERFL_"+m_Poberfl.substring(m_Poberfl.lastIndexOf('_')+1,m_Poberfl.length)), 
		strTextID : m_Poberfl
	});
}

/**
 * berechne die Oberflchenschutzgruppe fr das Lager (mgliche Gruppen: siehe CascadeProdukt.es, globales Objekt 'Oberflaechenschutz')
 *
 * @params -
 * @returns	string Oberflchenschutz
 */
Base.getOberFlaechenSchutzDefault = function(oDlg){
	var strSchutz = 'OB_SONST'; // default: 'sonstiger'

	if ( left( this.strTyp, 3 ) == 'LUR' )		// alter Loslagertyp 'LUR' hat den Oberflchentyp schon in der Typbezeichnung
	{
		var strID = right( oDlg.strTyp, 1 );
		if ( strID == '0' )
			strSchutz = 'OB_ROH';
		else if ( strID == '1' )
			strSchutz = 'OB_GALV';
		else if ( strID == '2' )
			strSchutz = 'OB_FEUER';
		else if ( strID == '3' )
			strSchutz = 'OB_GRUND';
		else if ( strID == '4' )
			strSchutz = 'OB_SONST';
		//else strSchutz = 'OB_SONST'; ist default
	}
	else
	{
		// mgliche Gruppen sind temperaturabhngig (vgl. Script RH_BESTIMME_OBFLSCHUTZ_VARIANTEN)
		if ( oDlg.dTemperaturMedium <= 300 )
			strSchutz = 'OB_FEUER';			// nur feuerverzinkt mglich
		else if ( oDlg.dTemperaturMedium <= 450 )
		{
			strSchutz = 'OB_ROH';		// roh
			// vorisolierte Los-und Fhrungslager sind bis 450C aus Werkstoff 37
			if ( substr( oDlg.strTyp, 1, 1 ) == "I" )
				strSchutz = 'OB_FEUER';		// nur feuerverzinkt mglich
		}
		else if ( oDlg.dTemperaturMedium > 450 )
			strSchutz = 'OB_ROH';		// roh
	}

	return( strSchutz );
}

/**
 * Werkstoff Funktion
 */ 
Base.getLanguageTextWerkstoff = function(strWerk){
	var dWerk = strWerk * 1;
	var strText;
	var strWerkstoff = 'W_SONST';
        
	if (dWerk == 37)
		strWerkstoff = "W_RST";
	else if (dWerk == 16)
		strWerkstoff = "W_15MO3";
	else if (dWerk == 13)
		strWerkstoff = "W_13CRMO";
	else if (dWerk == 10)
		strWerkstoff = "W_10CRMO";
	else if (dWerk == 41)
		strWerkstoff = "W_4541";
	else if (dWerk == 43)
		strWerkstoff = "W_4301";
	else if (dWerk == 71)
		strWerkstoff = "W_4571";
	else if (dWerk == 78)
		strWerkstoff = "W_4878";
	else if (strWerk == 80)
		strWerkstoff = "W_INCOLOY";
	else if (dWerk == 91)
		strWerkstoff = "W_P91";
	
	return ({
		strText 	: Produkt.getWerstoffeDBNumber(strWerkstoff).strSelWerkstoff, 
		strTextID 	: strWerkstoff
	});
}

/**
 * Verleichen Zweicher Objekte auf Gleichheit
 */
Base.isSameObject = function( base, dialogObject )
{
	logtraceln("*******************************************************************");
	logtraceln("Base.isSameObject**************************************************");
	var bSameObject = true;
	if( base && dialogObject && ( typeof( dialogObject ) === 'object' ) ){
		var t;
		for( var property in dialogObject )
		{
			t = typeof( dialogObject[property] );
			if ( property in base ){
				if ( ( t !== 'function' ) && ( t !== 'object' ) ){
					if(base[property] != dialogObject[property]){
						bSameObject = false;
						logtraceln("base[property] :"+base[property]+" dialogObject[property] :"+dialogObject[property]);
					}
					else
						logtraceln("base[property] :"+base[property]+" dialogObject[property] :"+dialogObject[property]);
				}	
				else if ( t === 'object' ){
					var bSameObject1 = Base.isSameObject( base[property], dialogObject[property] );
					logtraceln("Base.isSameObject return : "+bSameObject1);
					
					if(bSameObject)
						bSameObject = bSameObject1;
				}	
			}
			else
				bSameObject = false;
		}
	}
	else
		bSameObject = false;
	
	return bSameObject;
}


Base.applyValues = function( base, dialogObject )
{
	if( base && dialogObject && ( typeof( dialogObject ) === 'object' ) )
	{
		var t;
		for( var property in dialogObject )
		{
			t = typeof( dialogObject[property] );
			if ( property in base )
			{
				if ( ( t !== 'function' ) && ( t !== 'object' ) )
					base[property] = dialogObject[property];
				else if ( t === 'object' )
				{
					// recursive deep value copy (don't change references to preserve OK/Cancel semantics for dialog objects)
					Base.applyValues( base[property], dialogObject[property] );
				}
			}
		}
	}
}

/**
 * Funktion zum Clonen eines Objektes
 */
Base.deepCloneOld = function( obj ) {
	var c = obj instanceof Array ? [] : {};
	for (var i in obj) {
		var prop = obj[i];
		if (typeof prop == 'object') {
			if (prop instanceof Array) {
				c[i] = [];
				for (var j = 0; j < prop.length; j++) {
					if (typeof prop[j] != 'object') {
						c[i].push(prop[j]);
					} else {
						c[i].push(Object.deepClone(prop[j]));
					}
				}
			} else {
				c[i] = Object.deepClone(prop);
			}
		} else {
			c[i] = prop;
		}
	}
	return c;
}

/**
 * @constructor
 * deep clone of an object (nessessary because the deepClone-version in the framework is buggy for arrays - an array gets cloned as an object with attributes 0, 1, ...)
 * ultimatively, this is due to a bug in EasyScript - the instanceof operator is buggy for array literals
 *
 * ATTENTION: do not use with objects that contain self-references
 * 
 * @param obj - object to clone
 * @return object - cloned object
 */
Base.deepClone = function( obj ) 
{
	// catch trying to clone non-objects or null objects
	if ( !obj || ( typeof( obj ) !== 'object' ) )
        return( obj );

	var clone;
	if ( Base.isArray( obj ) )
		clone = [];
	else
	{
		try{
			if (obj && obj.prototype && obj.prototype.constructor && ( typeof( obj.prototype.constructor ) === 'function' ) )
				clone = new obj.constructor();	// if this line throws an exception in EasyScript, you've just been prey to another wonderful bug^B^B^Bfeature in EasyScript
												// concerning prototype chaining and object construction that is known for years but has not been removed since.
			else clone = {};
		}
		catch(err){
			clone = {};
		}
	}

	for ( var attr in obj ) 
	{
		var prop = obj[attr];
		if ( typeof( prop ) === 'object' ) 
		{
			try{
				if ( Base.isArray( prop ) ) 
				{
					clone[attr] = [];
					for ( var i = 0; i < prop.length; ++i ) 
					{
						if ( ( typeof prop[i] !== 'object' ) || !prop[i] )
							clone[attr].push( prop[i] );
						else clone[attr].push( Base.deepClone( prop[i] ) );
					}
				} 
				else if ( !prop )	// null has type 'object' in ECMAScript!
					clone[attr] = prop;
				else{
					clone[attr] = Base.deepClone( prop );
					
				}
			}
			catch(err){
				alert(err.message);
			}
		} 
		else{
			try{
				clone[attr] = prop;
			}
			catch(err){
				alert(err);
			}
		}
	}
	
	return( clone );
}


/**
 * @constructor
 * test if an object is an array
 *
 * @param obj - object to test
 * @return boolean: true - object is an array
 *                  false - object is not an array
 */
Base.isArray = function( obj )
{
	if ( !obj )
		return( false );
	
	// weird that this works in EasyScript, but instanceof doesn't work
	try{		
		return( obj.prototype.toString() === '[object Array]' );
	}
	catch(err){
		logtraceln('Error in fucntion isArray: '+ typeof obj.prototype.toString == 'function');
		//alert(err.message+' -- Array');
	}
}


