/**
 * @category   Product Logic
 * @package    Core
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */

// building the namespace
if ( typeof( Base ) === 'undefined' )
	Base = {};

/**
 * berechne sonder aussendurchmesser
 * @param [dSchellDeposit] {Double}
 * @return {Double}
 */
Base.buildSpecialExternalDiameter  = function(dSchellDeposit, AussenDuMesserRohr){
	return (1*AussenDuMesserRohr + 2*dSchellDeposit);
}	

/**
 * brechne Toleranzwert
 * @return {Object}
 */
Base.buildToleranceValue = function(dOrgValue,dTolerance){
	var dResult = (dOrgValue * dTolerance) / 100;
	
	return ({
		dMinValue : (dOrgValue-dResult),
		dMaxValue : (dOrgValue+dResult)
	})
}

/**
 * bestimmte Sonderabmessungen Hhe
 * @param [dE] {Double} Einbaumass
 * @param [dA] {Double} Aussendurchmesser
 */
Base.buildHeight = function(dE,dA){
	//return( Math.round((dE- (1/2*dA))*100)/100);
	return (Math.round(dE * 1 - (1/2*dA)));
}

/**
 * bestimme Sonderabmessungen Einbaumass
 * @param [dH] {Double} Hhe
 * @param [dA] {Double} Aussendurchmesser
 */
Base.buildMountingDimension = function(dH,dA){
	//return (Math.round((dH * 1 + (1/2 * dA))*100)/100);
	return (Math.round(dH * 1 + (1/2 * dA)));
}

/**
 * bestimme Gewicht der Sonderschelle
 * @param [dGEW_S_NORM] {Double} Gewicht der Standardschelle
 * @param [dGEW_NORM] {Double} Gewicht des Standardlagers
 * @param [dA] {Double} Aussendurchmesser
 * @param [dA_Norm] {Double} Standardaussendurchmesser
 */
Base.buildWeightClamp = function(dGew_S_NORM,dGew_NORM,dA,dA_NORM){
	var Gew_S_neu	= dA/dA_NORM*dGew_S_NORM;
	var Diff_S		= dGew_S_NORM - Gew_S_neu;
	var Gew_neu		= dGew_NORM - Diff_S;
	return (Math.round((Gew_neu)*10)/10);
}

/**
 * bestimme Preise und Gewichte fr Produktgruppen die abhngig sind vom Gewicht, Lnge, ...
 * aufgerufen wird diese Funktion aus "xxxx.search.test_and_modify" heraus 
 * @param [oZusatz] {Object} Ausgewhlte Daten
 * @param [oDBData] {Object} ein Datensatz der Abfrage (alle Spalten)
 */
Base.buildPreisGewicht = function(oZusatz,oDBData){
	var dNewGew,dNewPrice,dDiff;
	//if(oZusatz.bSonderLength)
	if(oZusatz.dSonderLength)
		dDiff = (oZusatz.dSonderLength*1);
	else
		dDiff = (oZusatz.strSelComboLength*1);
	
	//var a = (dDiff >= 700 ? 700 : oZusatz.L_MIN*1); 
	var a = (dDiff > 600 ? 700 : oZusatz.L_MIN*1); 
	var b = 0;
	
	b	= (dDiff - a) / 100;
	
	//bestimme das Gewicht
	var dNewGew 	= (b * oZusatz.DELGEW_100) + oZusatz.dDefaultGew ;
	
	//bestimme Grund Preis fr das ermittelte Gewicht
	var dNewPrice	= (b * oZusatz.dDefaultPreis100) + oZusatz.dDefaultPreis;	
	
	if(!oZusatz.dFaktObfl)
		oZusatz.dFaktObfl = Base.getOberflaechenFaktor(oZusatz.dOberflaeche);
	
	//addiere jetz (Gwicht * Oberflchenfaktor) -> nur wenn dNewPrice > 0
	dNewPrice  += (dNewPrice > 0 ? dNewGew*oZusatz.dFaktObfl : -1);
	
	// -Schu- Ist mir nicht klar, was hier noch passieren muss oder soll!?
	/*
	//nun fehlt noch der Werkstoffpreis (in abhngigkeit zum Gewicht ???)
	var strPreisColumn 	 = 'PREIS_'+oZusatz.strWerkstoff;
	var dDBPreis		 = oDBData[strPreisColumn];
	dNewPrice  			+= (dNewGew*dDBPreis);
	*/
	
	return ({
		'dNewGew' 	: Math.round(dNewGew*100)/100,
		'dNewPrice' : dNewPrice
	});
}

/**
 * bestimme Preise und Gewichte fr Produktgruppen die abhngig sind vom Gewicht, Lnge, ...
 * aufgerufen wird diese Funktion aus "xxxx.search.test_and_modify" heraus 
 * @param [oZusatz] {Object} Ausgewhlte Daten
 * @param [oDBData] {Object} ein Datensatz der Abfrage (alle Spalten)
 */
Base.buildPreisOberflaeche = function(oZusatz,oDBData){
	var dNewPrice = (oDBData.PREIS_0*1);
	
	/*
	if(!dNewPrice)
		dNewPrice = -9999;
	*/
	if(!oZusatz.dFaktObfl)
		oZusatz.dFaktObfl = Base.getOberflaechenFaktor(oZusatz.dOberflaeche);
	
	//addiere jetz (GEW * Oberflchenfaktor) -> nur wenn dNewPrice > 0
	dNewPrice  += (dNewPrice > 0 ? (oDBData.GEW*1)*oZusatz.dFaktObfl : -1);
		
	return ({
		'dNewPrice' : dNewPrice
	});
}

/**
 * Update Funktion: 
 * aktuallisiere die Suchergebnisdaten fr Sondereingaben im Dialog SollwerteRohrUmTeil
 * @param [oDlgLagerSession]		{Object} Session Object
 * @param [oData] 					{Object} Ergebniszeile
 * @param [strDialog]				{String} Dialog Id 
 * @return {Array}
 */
Base.updateTableSearchData = function(oDlgLagerSession,oData,strDialog){
	var oUpdateRow = Base.deepClone(oData)
	
	/**
	 * hier mssen dann die entsprechenden Anpassungen hin
	 * damit das ganze Funktioniert muss noch das bOk im Object auf true
	 * Zugriff auf Dialogmasken-Eingaben z.B. durch oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder 
	 * oder oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder
	 */
	 
	 
	/*if(strDialog != 'AuswahlSattel') 
		oUpdateRow.DN = 12; //Beispiel
	*/
	
	if (strDialog != "SONDERLAGER"){
		// nderungen fr Sonderaussendmr/Sondermanteldmr (kein weiteres Sondermass!!!)
		// der Preis ist der des nchst greren Standardlagers/-sattels
		if(oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
			oUpdateRow.DN	= "-";	// dA entspricht keiner Nennweite mehr
			oUpdateRow.D	= oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder;	// Sonderaussendmr
			var Gew_S_Fakt	= 1;	// Erhhung des Schellengewichts bei greren Sattellngen
			if (oDlgLagerSession.AuswahlSattel.strDialogId != ""){
				if ((oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart*1 == 1 && right(oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart,6) == "SCHALE")
					|| (oDlgLagerSession.AuswahlSattel.bRadioWeldEnd*1 == 1 && right(oDlgLagerSession.AuswahlSattel.strRadioWeldEnd,6) == "SCHALE")){
						Gew_S_Fakt	= oDlgLagerSession.AuswahlSattel.strSelComboLength / oData.L_MIN;
						if (oUpdateRow.GEW_S == "-")
							oUpdateRow.GEW_S = fround(oUpdateRow.S_STUETZSCHALE * oUpdateRow.L_STUETZSCHALE
												* oDlgLagerSession.AuswahlSattel.strSelComboLength
												* 7.85 / 1000000, 2);
				}
			}
			// bei Lagern mit Sonderaussendurchmesser wird nie eine BASF-Schelle verwendet
			// <= DN 500 -> HZN
			// > DN 500 -> HZL
			if (rfind(oDlgLagerSession.Systemcharakteristik.strSelRadioLager, "ROLL") < 0){
				if (oData.DN*1 < 25)
					Gew_S_Fakt	= 1.8;
				else if (oData.DN*1 >=100 && oData.DN*1 < 600 && oData.DN*1 != 200 && oData.DN*1 != 500)
					Gew_S_Fakt	= 1.4;
			}
			
			if (!oUpdateRow.DM){	// Fallunterscheidung Sonderaussendmr bei Manteldmr
				if (typeof(oUpdateRow.GEW) != "undefined")
					oUpdateRow.GEW	= Base.buildWeightClamp(oData.GEW_S * Gew_S_Fakt, oData.GEW, oUpdateRow.D, oData.D);
					// neues Gewicht Lager
				if (typeof(oUpdateRow.GEW_300) != "undefined")
					//oUpdateRow.GEW_300	= Base.buildWeightClamp(oData.GEW_S * Gew_S_Fakt, oData.GEW_300, oUpdateRow.D, oData.D);
					oUpdateRow.GEW_300	= Base.buildWeightClamp(oUpdateRow.GEW_S * Gew_S_Fakt, oData.GEW_300, oUpdateRow.D, oData.D);
					// neues Gewicht Sattel_300
				if (typeof(oUpdateRow.GEW_700) != "undefined")
					oUpdateRow.GEW_700	= Base.buildWeightClamp(oData.GEW_S * Gew_S_Fakt, oData.GEW_700, oUpdateRow.D, oData.D);
					// neues Gewicht Sattel_700
			}
		}
		if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder){
			oUpdateRow.DM	= oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder;	// Sondermanteldmr
			oUpdateRow.GEW	= Base.buildWeightClamp(oData.GEW_S * Gew_S_Fakt,oData.GEW,oData.DM,oUpdateRow.DM);	// neues Gewicht
		}
		// Preise updaten (Sondermanteldmr wird wie Sonderaussendmr behandelt)
		// nicht bei Sonderaussendmr und standard Manteldmr -> Standardlager
		if (oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder ||
			(oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder && !oUpdateRow.DM)){
			if (typeof(oUpdateRow.PREIS_0) != "undefined")
				oUpdateRow.PREIS_0		= fround(Base.getSonderAussenDuMesserFaktor() * oUpdateRow.PREIS_0, 2);
			if (typeof(oUpdateRow.PREIS_0_300) != "undefined")
				oUpdateRow.PREIS_0_300	= fround(Base.getSonderAussenDuMesserFaktor() * oUpdateRow.PREIS_0_300, 2);
			if (typeof(oUpdateRow.PREIS_0_700) != "undefined")
				oUpdateRow.PREIS_0_700	= fround(Base.getSonderAussenDuMesserFaktor() * oUpdateRow.PREIS_0_700, 2);
			
			oUpdateRow.PREIS_Tab	= fround(Base.getSonderAussenDuMesserFaktor() * oUpdateRow.PREIS_Tab, 2);
			oUpdateRow.PREIS		= fround(Base.getSonderAussenDuMesserFaktor() * oUpdateRow.PREIS, 2);
		}
		// neues E-Mass
		oUpdateRow.E	= Base.buildMountingDimension((oUpdateRow.H ? oUpdateRow.H : oDlgLagerSession.AuswahlStandard.dActualHeight),oUpdateRow.D);	// neues E-Mass
		if (oDlgLagerSession.AuswahlStandard.bHoehenverstellbar){
			var newEMass			= Base.SonderMinMaxEinbaumass(oData, oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder);
			oUpdateRow.E_MAX		= newEMass.Max;
			oUpdateRow.E_MIN		= newEMass.Min;
			oUpdateRow.E_MIN_MAX	= newEMass.Min + "-" + newEMass.Max;
		}
		// fr schraubbare Festpunkte noch die Lnge des Standrohres korrigieren -> sonst ist StLi falsch
		// Achtung in FL ist die Basis immer das Lager der nchst greren NW
		// in SAP-Definition ist das leider nicht immer so :-(
		if (oDlgLagerSession.AuswahlStandard.strSelRadioFixed == "SCHRAUBBAR"){
			oUpdateRow.L2	= fround(oUpdateRow.E
								- oUpdateRow.TF
								- sqrt(pow(oUpdateRow.D/2+oUpdateRow.SS*1,2)-pow((oUpdateRow.D2*1-2*oUpdateRow.S2)/2,2))
								,0);
		}
		// korrigieren weiterer Werte - soweit vorhanden
		// Schellengewicht
		if (typeof(oUpdateRow.GEW_S) != "undefined" && oUpdateRow.GEW_S != "" && oUpdateRow.GEW_S != "-"
			&& oUpdateRow.GEW_S != "0" && oUpdateRow.GEW_S != 0)
				oUpdateRow.GEW_S	= fround(oUpdateRow.D / oData.D * oUpdateRow.GEW_S, 2);
		// Auflagedurchmesser
		if (typeof(oUpdateRow.DA) != "undefined"){
			if (typeof(oUpdateRow.DM) != "undefined" && oUpdateRow.DM != null)
				oUpdateRow.DA	= fround(oUpdateRow.DM*1 + 2*oUpdateRow.J_MAX + 2*oUpdateRow.S_LAUFSCHALE, 0);
			else
				oUpdateRow.DA	= fround(oUpdateRow.D*1 + 2*(oUpdateRow.S_STUETZSCHALE*1 + oUpdateRow.S_LAUFSCHALE*1 + oUpdateRow.H_STEG*1) + 1, 0);
		}
		// Laufschale
		if (typeof(oUpdateRow.L_LAUFSCHALE) != "undefined" && left(oUpdateRow.TYP, 3) != "SMR"){
			oUpdateRow.L_LAUFSCHALE	= fround((oUpdateRow.DA - oUpdateRow.S_LAUFSCHALE) * Math.PI/6, 0);
			oUpdateRow.L_LAUFSCHALE	= (oUpdateRow.L_LAUFSCHALE < 360 ? 2*oUpdateRow.L_LAUFSCHALE : oUpdateRow.L_LAUFSCHALE);
			oUpdateRow.L_LAUFSCHALE	= (oUpdateRow.L_LAUFSCHALE < 360 ? 360 : oUpdateRow.L_LAUFSCHALE);
		}
		else if (typeof(oUpdateRow.L_LAUFSCHALE) != "undefined"){ // SMR
			var r1SMR	= fround(floor(oUpdateRow.DM /(oUpdateRow.DM < 100 ? 1 : 10))/2, 0) * (oUpdateRow.DM < 100 ? 1 : 10);
			var r1SMR	= fround(floor(oUpdateRow.DM * (oUpdateRow.DM < 100 ? 10 : 1)) / 2, 0) * (oUpdateRow.DM < 100 ? 0.1 : 1);
			var aSMR	= fround(1.8*oUpdateRow.DS + 2*sqrt(pow(r1SMR + 2.5*oUpdateRow.S_LAUFSCHALE, 2) - pow(2.5*oUpdateRow.S_LAUFSCHALE + oUpdateRow.F/2, 2)) + oUpdateRow.S_LAUFSCHALE*1, 0);
			aSMR		= floor(aSMR/2) * 2;
			var alpha	= acosdeg((1*oUpdateRow.F + 5*oUpdateRow.S_LAUFSCHALE) / (2*r1SMR + 5*oUpdateRow.S_LAUFSCHALE));
			oUpdateRow.L_LAUFSCHALE	= fround(aSMR + 2*oUpdateRow.C + (2*r1SMR + 5*oUpdateRow.S_LAUFSCHALE) * (alpha*Math.PI/180 - sindeg(alpha)), 0);
		}
		// Sttzschale
		if (typeof(oUpdateRow.L_STUETZSCHALE) != "undefined" && left(oUpdateRow.TYP, 3) != "INS"){
			oUpdateRow.L_STUETZSCHALE	= fround((oUpdateRow.D*1 + oUpdateRow.S_STUETZSCHALE*1 + 4) * Math.PI/3, 0);
			oUpdateRow.L_STUETZSCHALE	= (oUpdateRow.L_STUETZSCHALE < 360 ? 2*oUpdateRow.L_STUETZSCHALE : oUpdateRow.L_STUETZSCHALE);
			oUpdateRow.L_STUETZSCHALE	= (oUpdateRow.L_STUETZSCHALE < 360 ? 360 : oUpdateRow.L_STUETZSCHALE);
		}
		else if (typeof(oUpdateRow.L_STUETZSCHALE) != "undefined"){		// INS hat in StLi HVN/HVL mit HZN/HZL fr DN < 1300
			if (oData.DN*1 >= 1300){
				oUpdateRow.L_STUETZSCHALE	= fround((oUpdateRow.D*1 + oUpdateRow.S_STUETZSCHALE*1) * Math.PI/2 - 13, 0);
			}
		}
		// Namen fr Sondergleitlager / Sonderfestpunkte
		if (rfind(oDlgLagerSession.Systemcharakteristik.strSelRadioLager,"ROLL") < 0){
			switch (left(oUpdateRow.TYP,3)){
			case "FLN":
			case "FVN":
				oUpdateRow.TYP	= oUpdateRow.TYP_CALCULATION = sprintf("%s-S %s.%.4d.%.3d-T%s-%s.%d",left(oUpdateRow.TYP,3),oUpdateRow.BAU_F,oUpdateRow.D,oUpdateRow.NH,oDlgLagerSession.AuswahlStandard.strSelComboBeamSize,oUpdateRow.WERKSTOFF,oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel);
				break;
			case "FLV":
				oUpdateRow.TYP	= oUpdateRow.TYP_CALCULATION = sprintf("%s-S %s.%.4d.%.4d-T%s-%s.%d",left(oUpdateRow.TYP,3),oUpdateRow.BAU_F,oUpdateRow.D,oUpdateRow.DM,oDlgLagerSession.AuswahlStandard.strSelComboBeamSize,oUpdateRow.WERKSTOFF,oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel);
				break;
			default:
				oUpdateRow.TYP	= oUpdateRow.TYP_CALCULATION = sprintf("%s-S %s.%.4d.%.3d-%s.%d",left(oUpdateRow.TYP,3),oUpdateRow.BAU_F,oUpdateRow.D,oUpdateRow.NH,oUpdateRow.WERKSTOFF,oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel);
				break;
			}
		}
		else {	// Sondersattel
			switch (left(oUpdateRow.TYP,3)){
			case "ITB":
				oUpdateRow.TYP	= oUpdateRow.TYP_CALCULATION = sprintf("%s-S %03d.%.3d.%s-%s.%d A=%3d",left(oUpdateRow.TYP,3),oUpdateRow.D,oUpdateRow.J_MAX,(oDlgLagerSession.AuswahlSattel.bSonderLength ? oDlgLagerSession.AuswahlSattel.dSonderLength : oDlgLagerSession.AuswahlSattel.strSelComboLength),oUpdateRow.WERKSTOFF,oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel,oUpdateRow.A*1);
				break;
			case "SMR":
				oUpdateRow.TYP	= oUpdateRow.TYP_CALCULATION = sprintf("%s-S %04d.%.3d.%s-%s.%d",left(oUpdateRow.TYP,3),oUpdateRow.DM,(oDlgLagerSession.AuswahlSattel.bSonderLength ? oDlgLagerSession.AuswahlSattel.dSonderLength : oDlgLagerSession.AuswahlSattel.strSelComboLength),oUpdateRow.FORM,oUpdateRow.WERKSTOFF,oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel);
				break;
			case "SSR":	// todo
				break;
			default:
				oUpdateRow.TYP	= oUpdateRow.TYP_CALCULATION = sprintf("%s-S %04d.%.3d.%.4d-%s.%d",left(oUpdateRow.TYP,3),oUpdateRow.D,oUpdateRow.J_MAX,(oDlgLagerSession.AuswahlSattel.bSonderLength ? oDlgLagerSession.AuswahlSattel.dSonderLength : oDlgLagerSession.AuswahlSattel.strSelComboLength),oUpdateRow.WERKSTOFF,oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel);
				break;
			}
		}
		oUpdateRow.bOk = true;
	}
	else{
		var _GetAddData = function(oRow, K_T1, K_T2){
			var sPlatte			= 0;	// Gleitplatte (VA / PA)
			var AnzSchlitten	= 1;
			oRow.GEW			= 0;
			var strTyp			= left(oRow.TYP, 3);
			var strSubTyp		= oRow.BAU_F;
			var isGleitlager	= false;
			var isFuehrung		= false;
			var isFestlager		= false;
			switch (strTyp){
				case "LKL"	:
				case "LVL"	:
				case "IKL"	:
					oRow.GEW		= fround((oRow.B * oRow.L * oRow.SPA) / 1000 * 1.35 / 1000, 1);
					sPlatte			= oRow.SPA;
					isGleitlager	= true;
				break;
				case "LXL"	:
				case "LVX"	:	// gibt es noch nicht
					oRow.GEW		= fround((oRow.B * oRow.L * oRow.SVA) / 1000 * 7.85 / 1000, 1);
					sPlatte			= oRow.SVA;
					isGleitlager	= true;
				break;
				case "LSL"	:
				case "LVS"	:
					isGleitlager	= true;
				break;
				case "LKF"	:
					AnzSchlitten	= (left(strSubTyp, 1)*1 < 5 ? left(strSubTyp, 1)*1 : 2);
					oRow.GEW		= AnzSchlitten * fround((oRow.B * oRow.L * oRow.SPA) / 1000 * 1.35 / 1000, 1);
					sPlatte			= oRow.SPA;
					isFuehrung		= true;
				break;
				case "LXF"	:
					AnzSchlitten	= (left(strSubTyp, 1)*1 < 5 ? left(strSubTyp, 1)*1 : 2);
					oRow.GEW		= AnzSchlitten * fround((oRow.B * oRow.L * oRow.SVA) / 1000 * 7.85 / 1000, 1);
					sPlatte			= oRow.SVA;
					isFuehrung		= true;
				break;
				case "LSF"	:
					AnzSchlitten	= (left(strSubTyp, 1)*1 < 5 ? left(strSubTyp, 1)*1 : 2);
					isFuehrung		= true;
				break;
				case "FLN"	:
				case "FVN"	:
				case "FLV"	:
				case "FSN"	:
				case "FSD"	:
					isFestlager		= true;
					oRow.GEW		= 0;
				break;
				default		:	// sollte nicht vorkommen
				break;
			}
			oRow.TF	= oRow.SFUP*1 + sPlatte*1;
			switch (strSubTyp*1){
				case 20 : case 21 : case 22 :
				case 30 : case 31 : case 32 :
				case 40 : case 41 : case 42 :
				case 60 : case 61 : case 62 :
					var AnzSchell	= 2;
					//Gewicht
					if (!(right(strSubTyp,1)*1)){	// 20/30/40/60
						oRow.GEW	+= fround((((oRow.B * oRow.L * oRow.SFUP))
									+ ((oRow.L*1 - 20) * (oRow.H*1 - oRow.SFUP*1 - oRow.SS*1 - sPlatte*1) * oRow.SSTEG)
									- (((oRow.L*1 - 20 - (oRow.BS*1 + 10)) / 2) * (oRow.H*1 - oRow.SFUP*1 - sPlatte*1 - oRow.SS*1 - 20) * oRow.SSTEG))
									* 7.85 / 1000000 * AnzSchlitten
									+ oRow.GEW_S, 1);
						AnzSchell	= 1;
					}
					else
						oRow.GEW	+= fround((((oRow.B * oRow.L * oRow.SFUP))
									+ ((oRow.L*1 - 20) * (oRow.H*1 - oRow.SFUP*1 - sPlatte*1 - oRow.SS*1) * oRow.SSTEG))
									* 7.85 / 1000000 * AnzSchlitten
									+ 2 * oRow.GEW_S, 1);
					//Querkraft
						//Schweissnaht Schelle/Steg
					var WbI_I			= 2*AnzSchell/(oRow.SSTEG*1+oRow.SN1*1)*oRow.BS/12
											*(pow(oRow.SSTEG*1+oRow.SN1*1,3)-pow(oRow.SSTEG*1-oRow.SN1*1,3));
					var eI_I			= oRow.H_FQ*1-oRow.H*1+oRow.SS*1;
					var FxI_I			= 0.7*(150*K_T1)*WbI_I/abs(eI_I-oRow.H_FQ/4)/1000;
						//Schweissnaht Steg/FUP
					var WbIII_III_SN	= 2/(oRow.SSTEG*1+oRow.SN2*1)*(oRow.L*1-20)/12
											*(pow(oRow.SSTEG*1+oRow.SN2*1,3)-pow(oRow.SSTEG*1-oRow.SN2*1,3));
					var eIII_III_SN		= oRow.H_FQ*1-oRow.SFUP*1-sPlatte*1;
					var FxIII_III_SN	= 0.7*(150*K_T2)*WbIII_III_SN/abs(eIII_III_SN-oRow.H_FQ/4)/1000;
						//Steg oberhalb SN
					//var WbIII_III_ST	= (oRow.L-20)*pow(oRow.SSTEG,2)/6;
					var WbIII_III_ST	= (oRow.L-20)*pow((right(strSubTyp,1)*1 == 0 ? 2*oRow.SSTEG/3 : oRow.SSTEG),2)/6;
					//var WbIII_III_ST	= (oRow.L*1 - 20) * pow(oRow.SSTEG,2) / (12 / AnzSchell);
					var eIII_III_ST		= oRow.H_FQ*1-oRow.SFUP*1-sPlatte*1-2*oRow.SN2/sqrt(2);
					var FxIII_III_ST	= (150*K_T2)*WbIII_III_ST/abs(eIII_III_ST-oRow.H_FQ/4)/1000;
					oRow.F_QUER			= oRow.F_QUER_CALCULATION = fround(min(FxI_I,FxIII_III_SN,FxIII_III_ST),1);
					//Auflagelast
						//Schweissnaht Schelle/Steg
					var ASNI_I			= 2*AnzSchell*oRow.SN1*oRow.BS;
					var Fz_SN1			= 0.7*(150*K_T1)*ASNI_I/1000;
						//Schweissnaht Steg/FUP
					var ASNIII_III		= 2*oRow.SN2*(oRow.L*1-20);
					var Fz_SN2			= 0.7*(150*K_T2)*ASNIII_III/1000;
						//Biegung und Schub im Steg -> v.a. bei langen Lagern relevant
					var hR				= oRow.H*1 - oRow.SFUP*1 - sPlatte*1 - oRow.SS*1;
					var e_BiSchub		= (oRow.L*1 - 50) / 2;
					var ASteg			= (hR) * (oRow.SSTEG);
					var Zs				= (hR*oRow.SSTEG*hR/2 - oRow.B*oRow.SFUP*oRow.SFUP/2)/(hR*oRow.SSTEG + oRow.B*oRow.SFUP);
					var Ixx_BiSchub		= 1/3*(oRow.SSTEG*pow(hR,3) + oRow.B*pow(oRow.SFUP,3)) - pow(Zs,2)*(hR*oRow.SSTEG + oRow.B*oRow.SFUP);
					var Wb_BiSchub		= Ixx_BiSchub / (hR - Zs);
					var Fz_BiSchub		= 2*150 / sqrt(pow(e_BiSchub / Wb_BiSchub, 2) + 4 * pow(1 / ASteg, 2)) / 1000;
					oRow.F_AUFL_ST		= oRow.F_AUFL_CALCULATION = fround(min(oRow.F_QUER_CALCULATION/0.35,Fz_SN1,Fz_SN2,Fz_BiSchub),1);
					//Abhebelast
					var es				= (oRow.AS - (oRow.D + oRow.SS) - 1.2 * oRow.DS) / 2;
					var Fz_Schelle		= (2*AnzSchell*(150*K_T1)*oRow.BS*oRow.SS)/(1+((6*es)/(oRow.SS*1.4)))/1000;
					oRow.F_AB			= oRow.F_AB_CALCULATION = fround(min(Fz_SN1,Fz_SN2,Fz_Schelle,oRow.F_AUFL_CALCULATION*0.9),1);
					//Axiallast - bei Bedarf
					if (isFestlager){
						//Schweissnaht Schelle/Steg
						var Fax_SN1		= 0.5 * (150 * K_T1) * ASNI_I / 1000;
						//Rutschen Rohr in Schelle
						var Fax_RR		= 2 * 0.45 * (1.5 * 150 * K_T1) * AnzSchell * oRow.BS * oRow.SS / (1 + 6 * es / (oRow.SS * 1.4)) / 1000;
						oRow.F_AXIAL	= oRow.F_AXIAL_CALCULATION = fround(min(Fax_SN1, Fax_RR, oRow.F_AUFL_CALCULATION) ,1);
						oRow.W_AXIAL	= "-";
					}
					else
						oRow.W_AXIAL	= oRow.L*1 - 50;
					// Anpassung Lasten bei Fuehrungen
					if (isFuehrung && strSubTyp*1 >= 30 && strSubTyp*1 < 50)
						oRow.F_QUER		= oRow.F_QUER_CALCULATION	= oRow.F_AUFL_CALCULATION;
					if (isFuehrung && ((strSubTyp*1 >= 40 && strSubTyp*1 < 50) || strSubTyp*1 < 30))
						oRow.F_AB		= oRow.F_AB_CALCULATION		= oRow.F_AUFL_CALCULATION;
				break;
				case 23 : case 33 : case 43 : case 63 :
					if (!isFestlager){
						var H1_T23		= oRow.E*1 - sqrt(pow(oRow.D/2 + oRow.SS*1, 2) - pow((2*oRow.B/3)/2, 2)) - 1;
						var Lgestr_T23	= 2 * H1_T23 + (oRow.L*1 + 4*oRow.SFUP) - 2 * 1.93 * oRow.SFUP;
						var mBG_T23		= Lgestr_T23 * oRow.B * oRow.SFUP * 7.85 / 1000000 * AnzSchlitten;
						var mRI_T23		= (oRow.L*1 + 2*oRow.SFUP) * (oRow.H*1 - oRow.SFUP*1 - oRow.SS*1) * oRow.SSTEG * 7.85 / 1000000 * AnzSchlitten;
						oRow.GEW		+= fround(mBG_T23 + mRI_T23 + 2*oRow.GEW_S, 1);
						// Druckspannung in SN1 / SN2
						var ASNI_I		= 2 * ((2*oRow.B/3) - 15 - (2*oRow.B/3)/10) * oRow.SN1;
						ASNI_I			+= 2 * (oRow.BS*1 - 10) * oRow.SN1;
						var Fz_SN1		= 0.7 * (150*K_T1) * 2*ASNI_I/1000;
						var ASNIII_III	= 2 * (oRow.L*1 + 2*oRow.SFUP - 80) * oRow.SN2;
						var Fz_SN2		= 0.7 * (150*K_T2) * ASNIII_III/1000;
						// Biegung und Schub im Steg
						var hR			= oRow.H*1 - oRow.SFUP*1 - sPlatte*1 - oRow.SS*1;
						var e_BiSchub	= (oRow.L*1 + 4*oRow.SFUP - 50) / 2;
						var ASteg		= (hR) * (oRow.SSTEG);
						var Zs			= (hR*oRow.SSTEG*hR/2 - oRow.B*oRow.SFUP*oRow.SFUP/2)/(hR*oRow.SSTEG + oRow.B*oRow.SFUP);
						var Ixx_BiSchub	= 1/3*(oRow.SSTEG*pow(hR,3) + oRow.B*pow(oRow.SFUP,3)) - pow(Zs,2)*(hR*oRow.SSTEG + oRow.B*oRow.SFUP);
						var Wb_BiSchub	= Ixx_BiSchub / (hR - Zs);
						var Fz_BiSchub	= 2*150 / sqrt(pow(e_BiSchub / Wb_BiSchub, 2) + 4 * pow(1 / ASteg, 2)) / 1000;
						// Auflagelast gesamt
						oRow.F_AUFL_ST	= oRow.F_AUFL_CALCULATION = fround(min(Fz_SN1, Fz_SN2, Fz_BiSchub), 1);
						// Querkraft - Schubspannung in SN1 (beide Schellen)
						var FxI_I		= 0.5 * (150 * K_T1) * ASNI_I * 2 / 1000;
						oRow.F_QUER		= oRow.F_QUER_CALCULATION = fround(min(FxI_I, 0.95*oRow.F_AUFL_CALCULATION), 1);
						// Abhebelast
						var es			= (oRow.AS - (oRow.D + oRow.SS) - 1.2 * oRow.DS) / 2;
						var Fz_Schelle	= (2*2*(150*K_T1)*oRow.BS*oRow.SS)/(1+((6*es)/(oRow.SS*1.4)))/1000;
						oRow.F_AB		= oRow.F_AB_CALCULATION = fround(min(Fz_SN1,Fz_SN2,Fz_Schelle,oRow.F_AUFL_CALCULATION*0.9),1);
						oRow.W_AXIAL	= oRow.L*1 - 50;
					}
					else{
					
					}
				break;
				case 24 : case 34 : case 44 : case 64 :
					
				break;
				default		:
				break;
			}
			return;
		}
		var strBaseType	= left(oUpdateRow.TYP, 3);
		var strReplace	= "";
		var K_T1				= Lager.Search.TestAndModify_WerkstoffFaktor(oDlgLagerSession);
		oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium = oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium / 2;
		var K_T2				= Lager.Search.TestAndModify_WerkstoffFaktor(oDlgLagerSession);
		oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium = oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium * 2;
		switch (strBaseType){
		case "LxL"	:
		case "LxF"	:
			var AnzSchlitten	= 1;
			if (strBaseType == "LxF"){
				var RepSchlitten	= oDlgLagerSession.AuswahlStandard.strSelComboFunction.replace("FUEHRUNG_", "");
				if (RepSchlitten == "2W_90")
					RepSchlitten	= "6";
				else
					RepSchlitten	= left(RepSchlitten, 1);
				AnzSchlitten		= left(oDlgLagerSession.AuswahlStandard.strSelComboFunction.replace("FUEHRUNG_", ""), 1)*1;
				AnzSchlitten		= (AnzSchlitten > 4 ? 2 : AnzSchlitten);
				// ggf. BAU_F korrigieren -> kommt immer 20, 21, ...
				oUpdateRow.BAUFO	= oUpdateRow.BAUFO.replace(oUpdateRow.BAU_F, RepSchlitten + right(oUpdateRow.BAU_F, 1));
				oUpdateRow.BAU_F	= RepSchlitten + right(oUpdateRow.BAU_F, 1);
			}
			oUpdateRow.E		= oDlgLagerSession.AuswahlStandard.dMass1*1;
			oUpdateRow.H		= oDlgLagerSession.AuswahlStandard.dHoehe1*1;
			if (AnzSchlitten >= 2){
				oUpdateRow.E	= max(oUpdateRow.E, oDlgLagerSession.AuswahlStandard.dMass2*1)
				oUpdateRow.H	= max(oUpdateRow.H, oDlgLagerSession.AuswahlStandard.dHoehe2*1);
			}
			if (AnzSchlitten >= 3){
				oUpdateRow.E	= max(oUpdateRow.E, oDlgLagerSession.AuswahlStandard.dMass3*1)
				oUpdateRow.H	= max(oUpdateRow.H, oDlgLagerSession.AuswahlStandard.dHoehe3*1);
			}
			if (AnzSchlitten >= 4){
				oUpdateRow.E	= max(oUpdateRow.E, oDlgLagerSession.AuswahlStandard.dMass4*1)
				oUpdateRow.H	= max(oUpdateRow.H, oDlgLagerSession.AuswahlStandard.dHoehe4*1);
			}
			oUpdateRow.W_AXIAL		= oUpdateRow.L - 50;
			switch (oDlgLagerSession.Systemcharakteristik.strSelRadioLager.replace("LAGER_", "")){
				case "SPG"	:
					if(oDlgLagerSession.AuswahlStandard.bGaT)
						strReplace	= (AnzSchlitten == 1 ? "LSL-S" : "LSF-S");
					else
						strReplace	= (AnzSchlitten == 1 ? "LKL-S" : "LKF-S");
					break;
				case "SSG"	:
					strReplace	= (AnzSchlitten == 1 ? "LSL-S" : "LSF-S");
					break;
				case "EPG"	:
					strReplace	= (AnzSchlitten == 1 ? "LXL-S" : "LXF-S");
					break;
			}
			oUpdateRow.TYP			= oUpdateRow.TYP.replace(strBaseType, strReplace);
			oUpdateRow.TYP			= oUpdateRow.TYP.replace("hhh", (oUpdateRow.H*1 < 100 ? "0" : "") + oUpdateRow.H);
			oUpdateRow.TYP			= oUpdateRow.TYP.replace("ww", Lager.getWerkstoffeNumber(oDlgLagerSession));
			oUpdateRow.TYP			= oUpdateRow.TYP.replace("o", oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel);
			oUpdateRow.TYP			= oUpdateRow.TYP.replace("a", RepSchlitten);
			oUpdateRow.BAUFO		= oUpdateRow.BAUFO.replace(strBaseType, left(strReplace, 3));
			oUpdateRow.BAUFO		= (AnzSchlitten == 1 ? oUpdateRow.BAUFO : oUpdateRow.BAUFO.replace("_WD", ""));	
			oUpdateRow.BAUFO		= (Lager.getWerkstoffeNumber(oDlgLagerSession)*1 == 37 ? oUpdateRow.BAUFO : oUpdateRow.BAUFO.replace("_WD", "_WW"));	
		break;
		default:
			break;
		}
		oUpdateRow.NH			= oUpdateRow.H;
		oUpdateRow.B			= (oDlgLagerSession.AuswahlStandard.dBreite == "-" ? oDlgLagerSession.AuswahlStandard.dBreiteSonder : oDlgLagerSession.AuswahlStandard.dBreite);
		oUpdateRow.L			= (oDlgLagerSession.AuswahlStandard.dLaenge == "-" ? oDlgLagerSession.AuswahlStandard.dLaengeSonder : oDlgLagerSession.AuswahlStandard.dLaenge);
		oUpdateRow.WERKSTOFF	= Lager.getWerkstoffeNumber(oDlgLagerSession);
		oUpdateRow.H_FQ			= ceil(oUpdateRow.E - ceil(oUpdateRow.D) / 3);
		_GetAddData(oUpdateRow, K_T1, K_T2);
	}
	return oUpdateRow;
}


Base.SonderMinMaxHoehe = function(oDlgLagerSession){
	var dMin = 0;
	var dMax = 0;
	
	return {
		'Min' 	: dMin,
		'Max'	: dMax
	};
}

Base.SonderMinMaxEinbaumass	= function(oData, dA){
	var dMin = fround(oData.H_MIN*1 + dA/2, 0);
	var dMax = fround(oData.H_MAX*1 + dA/2, 0);
	
	return {
		'Min' 	: dMin,
		'Max'	: dMax
	};
}

Base.Sondernachberechnung	= function(oDlgLagerSession){
	
}

/*
	Prft, ob Sonderaussendurchmesser tatschlich einer ist
*/
Base.CheckDiameter	= 	function (dA){
	var strSQLStatement	= "select * from NENNWEITEN where abs(D) >= abs("+ dA +") ";
	var numRet			= dbselect("LAGER2", strSQLStatement, "DELTA_DA");
	var Del_dA			= dbgetdouble("DELTA_DA", "DEL_D");
	var strSQLStatement	= "select * from NENNWEITEN where abs(D) >= abs("+ (dA - Del_dA) +") ";
	var numRet			= dbselect("LAGER2", strSQLStatement, "DELTA_DA");
	var DN_norm			= dbgetdouble("DELTA_DA", "DN");
	var dA_norm			= dbgetdouble("DELTA_DA", "D");
	var isDN			= false;
	if (dA >= (dA_norm - Del_dA) && dA <= (dA_norm + Del_dA))
		var isDN			= true;
	return {
		'isDN'		:	isDN,
		'DN_norm'	:	DN_norm,
		'dA_norm'	:	dA_norm
	};
}

/*
	Prft, ob Sondermanteldurchmesser tatschlich einer ist
*/
Base.CheckDiameterMantel	= 	function (dM){
	var strSQLStatement	= "select * from MANTELDMR where abs(DM) >= abs("+ dM +") ";
	var numRet			= dbselect("LAGER2", strSQLStatement, "DELTA_DM");
	var Del_dM			= dbgetdouble("DELTA_DM", "DEL_DM");
	var strSQLStatement	= "select * from MANTELDMR where abs(DM) >= abs("+ (dM - Del_dM) +") ";
	var numRet			= dbselect("LAGER2", strSQLStatement, "DELTA_DM");
	var DM_norm			= dbgetdouble("DELTA_DM", "DM");
	var isDM_norm		= false;
	if (dM >= (DM_norm - Del_dM) && dM <= (DM_norm + Del_dM))
		isDM_norm	= true;
	return {
		'isDM_norm'	:	isDM_norm,
		'DM_norm'	:	DM_norm
	};
}