/**
 * @category   Product Logic
 * @package    Core
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */

// building the namespace
if ( typeof( Base ) === 'undefined' )
	Base = {};
/**
 * Test fr fast alle Produkte. Lager (Gleit-/Fest-/Rollenlager), Klemmsystem, Abhebesicherung
 * @param [oDlg]{Object} session objectat
 * @param [oData]{Object} DB - gefundene Zeile
 * @param [dWerk_Faktor] {Double}
 */
Base.TestAndModify = function(oDlg,oData,dWerk_Faktor){	
	var bOk = {'bOk' : true, 'oData' : oData};
	// Belastungen und Verschiebungen prfen	
	var oTableData 		= oDlg.SollwerteHalterungspunkt.oTable;	
	
	//Test 1 auf Bewegung
	var strPlusBewegung 	= "bewegung_plus";
	var strMinusBewegeung 	= "bewegung_minus";
	var aBewegungMatrix	= 	[
		oTableData.bewegung_plus.axial, oTableData.bewegung_plus.quer,oTableData.bewegung_plus.schief, 
		oTableData.bewegung_minus.axial, oTableData.bewegung_minus.quer, oTableData.bewegung_minus.schief
	];
	
	var _testBewegung = function(oPlusBewegung, oMinusBewegung, strPruefwertAxial, strPruefwertQuer, strPruefwertAufAb){
		var bTestOk = true;
		var dSum	= abs(oPlusBewegung.axial*1) + abs(oMinusBewegung.axial*1);
		if(strPruefwertAxial != "-" && (dSum>(strPruefwertAxial*1)) && (atoi(dSum) > 0))
			bTestOk = false;
		
		if(strPruefwertQuer != "-"){
			var dQuerSum	= abs(oPlusBewegung.quer*1) + abs(oMinusBewegung.quer*1);
			if(dQuerSum>(strPruefwertQuer*1) && (atoi(dQuerSum)>0))
				bTestOk = false;
		}
		
		if(strPruefwertAufAb != "-"){
			var dSumAufAb	= abs(oPlusBewegung.schief*1) + abs(oMinusBewegung.schief*1);
			if(dSumAufAb > (strPruefwertAufAb*1) && (atoi(dSumAufAb) > 0))
				bTestOk = false;
		}
		
		return bTestOk;
	}
	
	for(var a=0;a<aBewegungMatrix.length;a++){
		if((aBewegungMatrix[a]*1)!=0){
				var strPruefAxial = oData.W_AXIAL;
				var strPruefQuer  = oData.W_QUER;
				var strPruefAufAb = "-";
				if((oDlg.AuswahlStandard.strSelComboAccessory == "GLEITELEMENT") && (oDlg.AuswahlStandard.AuswahlStandard.strSelComboSlidingPart != "OHNE")){
					strPruefAxial = oData.W_LGX_AXIAL;
					strPruefQuer  = oData.W_LGX_QUER;
				}
				if (oData.BAU_F*1 == 40 && left(oData.TYP, 2) == "KL"){
					strPruefQuer  = oData.BREITE*1 + 50 - oDlg.AuswahlStandard.oSearchResult.oResultLager.A*1;
					oData.W_QUER  = strPruefQuer;
				}
				// Lager auf Sttze
				if (oDlg.bLastKettePathSelection && getstring("IDC_LASTABTRAGUNG","DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") == "STUETZEND_EINFACH"){
					// FSS
					if (getstring("IDC_IMAGE_ID","DLGDATA.CA.FORMS.AUSWAHL_HAENGERTYP") == "FSS" || left(oData.TYP, 3) == "LSL"){
						strPruefQuer	= 0.38 * oData.A;
						oData.W_QUER	= strPruefQuer;
					}
					// "FSP"
					else{
						strPruefQuer	= (oData.A * 1 - 10) - atoi(getstring("P","TMP.FH_ADDITIONAL_DATA"));
						if (strPruefQuer < 0){
							bOk.bOk		= false;
							break;
						}
						oData.W_QUER	= strPruefQuer;
						strPruefAxial	= (oData.L * 1 -10) - atoi(getstring("P","TMP.FH_ADDITIONAL_DATA"));
						if (strPruefAxial < 0){
							bOk.bOk		= false;
							break;
						}
						oData.W_AXIAL	= strPruefAxial;
					}
				}
				// Lager auf Traverse
				else if (oDlg.bLastKettePathSelection){
					strPruefAxial	= "-";
					strPruefAxial	= oData.W_AXIAL;
				}
				// Festpunkt
				else if (oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_FS")
					strPruefAufAb	= strPruefAxial;
				//bOk = _testBewegung(oTableData[strPlusBewegung], oTableData[strMinusBewegeung],strPruefAxial,strPruefQuer);
				bOk.bOk = _testBewegung(oTableData[strPlusBewegung], oTableData[strMinusBewegeung], strPruefAxial, strPruefQuer, strPruefAufAb);
			break;
		}
	}
	
	if(!bOk.bOk)
		return {'bOk' : bOk.bOk, 'oData' : bOk.oData, 'strError' : translate("ERROR_BEWEGUNG")};
	
	//Test 2 Lasten
	var strPlusLast 	= "last_plus";
	var strMinusLast 	= "last_minus";
	var strUeberLast 	= "ueberlast";
	var strZusatzLast   = "zusatzlast";
	var aKraftMatrix		= 	[
		oTableData.last_plus.axial, oTableData.last_plus.quer,oTableData.last_plus.schief,
		oTableData.last_minus.axial,oTableData.last_minus.quer,oTableData.last_minus.schief
	];
	
	var _testKraft = function(oPlusLast,oMinusLast,oUeberLast,oZusatzLast,oDataRes,dAbminderungsfaktor,oDlg){
		var bTestOk 	= true;
		if (!oDlg.bLastKettePathSelection){
			var dAxial 		= max(abs(oPlusLast.axial*1),abs(oMinusLast.axial*1)) + abs(oZusatzLast.axial);
			var dQuer  		= max(abs(oPlusLast.quer*1),abs(oMinusLast.quer*1)) + abs(oZusatzLast.quer);
			var dAuflage	= abs(oMinusLast.schief*1) + abs(oZusatzLast.schief);
			var dAbhebe		= abs(oPlusLast.schief*1);
		}
		else{
			var dAxial 		= 0;	// wird nicht aufgenommen
			var dQuer  		= 0;	// wird nicht aufgenommen
			if (oDlg.AuswahlStandard.strSelRadioFunction == "GEFUEHRT_MEHRFACH")
				dQuer		= max(abs(oPlusLast.quer*1),abs(oMinusLast.quer*1)) + abs(oZusatzLast.quer);
			var dAuflage	= abs(oMinusLast.schief*1) + abs(oZusatzLast.schief);
			var dAbhebe		= 0;	// wird nicht aufgenommen
		}
		
		var dF_AXIAL = oDataRes.F_AXIAL;
		var dF_QUER  = oDataRes.F_QUER;
		var dF_AB	 = oDataRes.F_AB;
		
		var strError = "";
		
		if((oDlg.AuswahlStandard.strSelComboAccessory == "GLEITELEMENT")
			&& (oDlg.AuswahlStandard.AuswahlStandard.strSelComboSlidingPart != "OHNE")
			&& (oDlg.AuswahlStandard.AuswahlStandard.strSelRadioFunction == "GEFUEHRT_MEHRFACH")){
			//dF_AXIAL = oDataRes.F_AXIAL_PTFE;
			//dF_QUER  = oDataRes.F_QUER_PTFE;
			dF_AB	 = oDataRes.F_AB_PTFE;	// das gibt es nur bei "LXF"
		}
		else if(left(oDataRes.TYP, 3) == "RDF" || left(oDataRes.TYP, 3) == "RKF")
			dF_QUER  = oDataRes.F_QUER_MAX;
		
		if(dF_AXIAL != "-"){
			var dZulaessig_Axial =  dF_AXIAL * dAbminderungsfaktor;
			if (oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && left(oDataRes.TYP, 2) != "FS" && oDataRes.F_AXIAL_KSY < dZulaessig_Axial)
				dZulaessig_Axial = oDataRes.F_AXIAL_KSY;
			
			if(dZulaessig_Axial<dAxial){
				bTestOk		 = false;
				strError	+= translate("ERROR_KRAFT_AXIAL") + "\n";
			}
				
			oDataRes.F_AXIAL_CALCULATION	= fround(dZulaessig_Axial,1);
		}
		else
			oDataRes.F_AXIAL_CALCULATION = fround(dF_AXIAL,1);
		
		
		if(dF_QUER != "-"){
			var dZulaessig_Quer =  dF_QUER * dAbminderungsfaktor;
			if (oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && left(oDataRes.TYP, 2) != "FS" && oDataRes.F_QUER_KSY < dZulaessig_Quer)
				dZulaessig_Quer = oDataRes.F_QUER_KSY;
			
			if(left(oDataRes.TYP, 2) == "RD" || left(oDataRes.TYP, 2) == "RK")
				dZulaessig_Quer = fround(0.35 * dAuflage, 1);
			
			if(dZulaessig_Quer<dQuer){
				bTestOk		 = false;
				strError	+= translate("ERROR_KRAFT_QUER") + "\n";
			}
			
			oDataRes.F_QUER_CALCULATION 	= fround(dZulaessig_Quer,1);
		}
		else
			oDataRes.F_QUER_CALCULATION = fround(dF_QUER,1);
		
		if(dF_AB != "-"){
			var dZulaessig_Ab =  dF_AB * dAbminderungsfaktor;
			if (oDlg.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && left(oDataRes.TYP, 2) != "FS" && oDataRes.F_AB_KSY < dZulaessig_Ab)
				dZulaessig_Ab = oDataRes.F_AB_KSY;
				
			if(dZulaessig_Ab<dAbhebe){
				bTestOk		 = false;
				strError	+= translate("ERROR_KRAFT_AB") + "\n";
			}
			 
			oDataRes.F_AB_CALCULATION = fround(dZulaessig_Ab,1);
		}
		else
			oDataRes.F_AB_CALCULATION = fround(dF_AB,1);
		
		var dZulaessig_Auflage = '';
		if(((oDlg.AuswahlStandard.strSelComboAccessory == "GLEITELEMENT")
			&& (oDlg.AuswahlStandard.AuswahlStandard.strSelComboSlidingPart != "OHNE"))
			||
			(oDlg.bLastKettePathSelection && (getstring("IDC_IMAGE_ID","DLGDATA.CA.FORMS.AUSWAHL_HAENGERTYP") == "FSP"
			|| getstring("IDC_IMAGE_ID","DLGDATA.CA.FORMS.AUSWAHL_HAENGERTYP") == "KSP"))
			||
			(oDlg.bLastKettePathSelection && left(oDataRes.TYP, 3) == "LXL"))
		{
				if (oDataRes.F_AUFL_ST*1 > oDataRes.F_AUFL_PTFE*1)	// PTFE ist begrenzendes Element
					dZulaessig_Auflage = min(fround(oDataRes.F_AUFL_ST * dAbminderungsfaktor,1), oDataRes.F_AUFL_PTFE*1);
				else
					dZulaessig_Auflage =  fround(oDataRes.F_AUFL_PTFE * dAbminderungsfaktor,1);
		}
		else if (oDataRes.F_AUFL_ST == "-")	// Klemmsysteme
			//dZulaessig_Auflage =  round(oDataRes.F_AUFL_ST);
			dZulaessig_Auflage =  "-";
		else if (oDlg.bLastKettePathSelection && getstring("IDC_IMAGE_ID","DLGDATA.CA.FORMS.AUSWAHL_HAENGERTYP") != "FSS"
					&& left(getstring("IDC_LASTABTRAGUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK"), 9) != "STUETZEND")
			dZulaessig_Auflage = oDataRes.F_AUFL_TRAV * dAbminderungsfaktor;
		else //F_AUFL_ST
			dZulaessig_Auflage =  oDataRes.F_AUFL_ST ? (fround(oDataRes.F_AUFL_ST * dAbminderungsfaktor,1)) : (fround(oDataRes.F_AUFL * dAbminderungsfaktor,1));
		
		if(dZulaessig_Auflage != "-"){
			if(dZulaessig_Auflage<dAuflage){
				bTestOk = false;
				strError	+= translate("ERROR_KRAFT_AUFL") + "\n";
			}
		
			oDataRes.F_AUFL_CALCULATION = fround(dZulaessig_Auflage,1);
		}
		
		if(((oUeberLast.axial*1) != 0) || ((oUeberLast.quer*1) !=0) || ((oUeberLast.schief*1) !=0) ){
			if(((oUeberLast.axial*1) != 0) && (dF_AXIAL != "-")){
				var dZulaessig  = (dF_AXIAL) * 2.5;
				if(dZulaessig<(oUeberLast.axial*1)){
					bTestOk		 = false;
					strError	+= translate("ERROR_UEBLAST_AXIAL") + "\n";
				}
			}
			
			if(((oUeberLast.quer*1) != 0) && (dF_QUER != "-")){
				var dZulaessig  = (dF_QUER) * 2.5;
				if(dZulaessig<(oUeberLast.quer*1)){
					bTestOk		 = false;
					strError	+= translate("ERROR_UEBLAST_QUER") + "\n";
				}
			}
			
			if(((oUeberLast.schief*1) != 0) && dZulaessig_Auflage){
				var dZulaessig  = (dZulaessig_Auflage/dAbminderungsfaktor) * 2.5;
				if(dZulaessig < dZulaessig_Auflage){
					bTestOk		 = false;
					strError	+= translate("ERROR_UEBLAST_AUFL") + "\n";
				}
			}
		}
		
		return {'bOk' : bTestOk, 'oData' : oDataRes, 'strError' : strError};
	};
	
	for(var a=0;a<aKraftMatrix.length;a++){
		if((aKraftMatrix[a]*1)!=0){
				bOk = _testKraft(oTableData[strPlusLast], oTableData[strMinusLast], oTableData[strUeberLast],oTableData[strZusatzLast],oData,dWerk_Faktor,oDlg);
			break;
		}
	}
	if(!bOk.bOk)
		//return {'bOk' : bOk.bOk, 'oData' : bOk.oData, 'strError' : translate("ERROR_KRAFT")};
		return {'bOk' : bOk.bOk, 'oData' : bOk.oData, 'strError' : bOk.strError};
	
	var strTypOf = typeof(bOk);
	if(strTypOf == "object"){
		oData 	= bOk.oData;
		bOk		= bOk.bOk;
		
		if(!oData.F_AB_CALCULATION)
			oData.F_AB_CALCULATION = fround(oData.F_AB * dWerk_Faktor, 1);
		
		if(!oData.F_QUER_CALCULATION)
			oData.F_QUER_CALCULATION = fround(oData.F_QUER * dWerk_Faktor, 1);
			
		if(!oData.F_AXIAL_CALCULATION)
			oData.F_AXIAL_CALCULATION = fround(oData.F_AXIAL * dWerk_Faktor, 1);	
		
		if(!oData.F_AUFL_CALCULATION)
			oData.F_AUFL_CALCULATION = (oData.F_AUFL_ST ? fround(oData.F_AUFL_ST * dWerk_Faktor, 1) : fround(oData.F_AUFL * dWerk_Faktor, 1));
			
		/*
		if((oDlg.AuswahlStandard.strSelComboAccessory == "GLEITELEMENT") && (oDlg.AuswahlStandard.AuswahlStandard.strSelComboSlidingPart != "OHNE")){
			oData.F_AXIAL_CALCULATION 	= oData.F_AXIAL_PTFE;
			oData.F_QUER_CALCULATION  	= oData.F_QUER_PTFE;
			oData.F_AB_CALCULATION	 	= oData.F_AB_PTFE;
			oData.F_AUFL_CALCULATION	= oData.F_AUFL_PTFE;
		}	
		*/
		
	}
	
	return {'bOk' : bOk , 'oData' : oData, 'strError' : ''};
}	
	