/**
 * @category   Abhebesicherung function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Abhebesicherung ) === 'undefined' )
	Abhebesicherung = {};
if ( typeof( Abhebesicherung.Search ) === 'undefined' )
	Abhebesicherung.Search = {};
if ( typeof( Abhebesicherung.Search.Abhebesicherungtyp) === 'undefined' )
	Abhebesicherung.Search.Abhebesicherungtyp = {};

/**
 * Zubehr - Auswahl Abhebesicherung fr Rollenlager und Sattel
 */	
Abhebesicherung.Search.Abhebesicherungtyp.Zubehoer_Rollenlager_Sattel = function(oDlgLagerSession,strTable){
	var aResult = [];
	var strRollenlagerTable = oDlgLagerSession.AuswahlRollenlager.strSelComboType;
		strRollenlagerTable = strRollenlagerTable.substring(0,3);
		
	if((oDlgLagerSession.AuswahlRollenlager.dSattelBearingDiameter - oDlgLagerSession.AuswahlRollenlager.dSattelOuterDiameter)<=12)
		strTable += "M";
	else
		strTable += "J";
	
	var sqlString = "SELECT * FROM "+strRollenlagerTable+" WHERE TYP = '"+oDlgLagerSession.AuswahlRollenlager.strSelComboType+"'";
	var allDBData = Abhebesicherung.Search.getSearchResultData_AllColumns('LAGER2',sqlString);
	
	var dResult 	= 0;
	var strError 	= '';
	var _setError = function(strValue){
		if(!strError)
			strError = strValue;
	}
	
	for(var a=0;a<allDBData.length;a++){ //sollte eigentlich immer nur einen Wert liefern
		var sqlString 	= "SELECT * FROM "+strTable+" WHERE BAU_F like '%"+allDBData[a].BAU_F.substring(1,3)+"' AND abs(WERKSTOFF) = abs("+oDlgLagerSession.AuswahlRollenlager.strSelComboMaterial+")" ;
		if (oDlgLagerSession.AuswahlRollenlager.dSattelBearingDiameter != ""){
			var RL_TYP_Sel	= oDlgLagerSession.AuswahlRollenlager.strSelComboType;
			var TYP_Sel_DB	= false;
			var sqlStringRL = "SELECT * FROM "+strRollenlagerTable+" WHERE abs(DA_MIN) <= "+abs(oDlgLagerSession.AuswahlRollenlager.dSattelBearingDiameter)+" AND abs(DA_MAX) >= "+abs(oDlgLagerSession.AuswahlRollenlager.dSattelBearingDiameter)+" ";
			var numRet = dbselect("LAGER2", sqlStringRL, "RL_TYP");
			while (dbiseof("RL_TYP") == 0)
			{
				var RL_TYP_DB	= dbgetstring("RL_TYP", "TYP");
				if (RL_TYP_DB == RL_TYP_Sel)
					TYP_Sel_DB	= true;
				
				dbskip("RL_TYP");
			}
		}
		var abAllDBData = Abhebesicherung.Search.getSearchResultData_AllColumns('LAGER2',sqlString);
		if (!abAllDBData.length)
			_setError(translate("ERROR_WERKSTOFF"));
		
		if (!TYP_Sel_DB)
			_setError(translate("ERROR_TYP_RL"));
		else{
			for(var i=0;i<abAllDBData.length;i++){
				//var oRet 	= Abhebesicherung.Search.TestAndModify_LagerSystem(oDlgLagerSession,abAllDBData[i],aTable[a],true);
				var oRet 	= Abhebesicherung.Search.TestAndModify_LagerSystem(oDlgLagerSession,abAllDBData[i],strTable,true);
						
				if(oRet.bOk){ //build client Tabelle
					dResult +=1;
					aResult.push(oRet.oData.TYP);					
					setDataIntoLagerCacheObject('AuswahlAbhebesicherung','TABLE',(oRet.oData));
				}
				else
					_setError(oRet.oData.strError);	
			}
		}
	}
	
	return (dResult > 0 ? (Abhebesicherung.getClientTable(oDlgLagerSession)) : ['ERROR',strError]); 
};