/**
 * @category   Abhebesicherung function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Abhebesicherung ) === 'undefined' )
	Abhebesicherung = {};
if ( typeof( Abhebesicherung.Search ) === 'undefined' )
	Abhebesicherung.Search = {};
if ( typeof( Abhebesicherung.Search.Abhebesicherungtyp) === 'undefined' )
	Abhebesicherung.Search.Abhebesicherungtyp = {};

/**
 * Abhebeischerung Lager - Lagerschlitten - gefhrt und gewhlt Abhebesicherung 
 * @param [oDlgLagerSession] {Object}
 * @param [oData] {Object}
 * @return {Object}
 */
Abhebesicherung.Search.Abhebesicherungtyp.Lager = function(oDlgLagerSession,oData){
	var oRet		= {};
	var sqlString	= "SELECT * FROM AUSLEGUNG_GLEIT_FEST_LAGER WHERE LAGER_TYP ='"+oDlgLagerSession.Systemcharakteristik.strSelRadioLager+"'";
		sqlString  += (caMainController.getLagerTopologieklasse().getIsolierung() == 'ID_VORISOLIERT') ? " AND VORISOLIERT = 'true' " : " AND VORISOLIERT = 'false'" ;
		
	switch(oDlgLagerSession.AuswahlStandard.strSelRadioFunction){
		case "LOSE" :
				sqlString += " AND LAGERART like 'LOSLAGER' ";
			break;	
		case "GEFUEHRT"	:
				sqlString += " AND LAGERART like 'FUEHRUNGSLAGER' ";
			break;
		case "GEFUEHRT_MEHRFACH" :
				sqlString += " AND LAGERART like '"+oDlgLagerSession.AuswahlStandard.strSelComboFunction+"' ";
			break;	
	}
	
	sqlString += "AND GLEITUNTERLAGE 	='"+(oDlgLagerSession.AuswahlStandard.bGaT ? 'true' : 'false')+"' ";
	sqlString += "AND HOEHENVERSTELLBAR ='"+(oDlgLagerSession.AuswahlStandard.bHoehenverstellbar ? 'true' : 'false')+"' ";
	
	switch(oDlgLagerSession.AuswahlStandard.strSelComboAccessory){
		case "KLEMMBAR" :
				sqlString += "AND KLEMMSYSTEM <> 'false' AND KLEMMSYSTEM <> '-'  AND KLEMMSYSTEM <> ''";
			break;	
		case "ABHEBESICHERUNG_4":	
		case "ABHEBESICHERUNG"	:
				sqlString += "AND ABHEBESICHERUNG <> '-' AND ABHEBESICHERUNG <> ''";
			break;
		case "GLEITELEMENT" :
				sqlString += "AND GLEITELEMENT = '"+oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart+"' ";
			break;	
	}
	
	//var strSelection 	= oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff;
	//strSelection 		= strSelection.replace("LAGER_","");
	//strSelection		= Produkt.getWerkstoffeNumber(strSelection);	
	//sqlString += " AND WERKSTOFF = '"+strSelection+"'";
	
	var dbName 		= 'LAGER2';
	var dbNameTable = "AUSLEGUNG_GLEIT_FEST_LAGER_MINABHEBESICHERUNG";
	var strTable	= '';		
	if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			if(dbgetstring(dbNameTable,"ABHEBESICHERUNG")!='' && dbgetstring(dbNameTable,"ABHEBESICHERUNG")!='-')
			strTable = strTable ? strTable+","+dbgetstring(dbNameTable,"ABHEBESICHERUNG") : dbgetstring(dbNameTable,"ABHEBESICHERUNG");
			dbskip( dbNameTable );
		}
	}
	
	if(rfind(strTable,",")<0){
		var aResult = new Array();
		var strWerkstoff 	= oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff;
		strWerkstoff 		= strWerkstoff.replace("LAGER_","");
		strWerkstoff		= Produkt.getWerkstoffeNumber(strWerkstoff);
		var bAND = false;
		var sqlString  = "SELECT * FROM "+strTable+" WHERE ";
		if(oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel !="ALL"){
			sqlString += " OBFL like '3%' ";
			bAND = true;
		}
		
		if(bAND)
			sqlString += " AND WERKSTOFF = 37";
		else
			sqlString += " WERKSTOFF = 37";
		
		//sqlString += " AND abs(TF) >= "+(oData.TF*1)+"";
		sqlString += " AND abs(TF) > "+(oData.TF*1)+"";
		sqlString += " AND abs(TF) < "+(oData.TF*1 + 3)+"";
		//sqlString += " AND abs(F_AB) >= "+(oData.F_AB*1)+"";
		sqlString += " ORDER BY (TYP)";
			
		var oAllData = Abhebesicherung.Search.getSearchResultData_AllColumns(dbName,sqlString);
		var dResult 	= 0;
		var strError 	= '';
		var _setError = function(strValue){
			if(!strError)
				strError = strValue;
		}
		
		for(var i=0;i<oAllData.length;i++){
			//var oRet 	= Abhebesicherung.Search.TestAndModify_LagerSystem(oDlg,oAllData[i],strTable,false);
			var oRet 	= Abhebesicherung.Search.TestAndModify_LagerSystem(oDlgLagerSession,oAllData[i],strTable,false);
			
			//if(oRet.bOk){ //build client Tabelle
			if(oRet.bOk.bOk){ //build client Tabelle
				dResult +=1;
				aResult.push(oRet.oData.TYP);					
				setDataIntoLagerCacheObject('AuswahlAbhebesicherung','TABLE',(oRet.oData));
			}
			else
				_setError(oRet.oData.strError);	
		}		
	}
	
	return (dResult > 0 ? (aResult) : ['ERROR',strError]);
};