/**
 * @category   Sattel function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Abhebesicherung ) === 'undefined' )
	Abhebesicherung = {};
if ( typeof( Abhebesicherung.Search ) === 'undefined' )
	Abhebesicherung.Search = {};
	
/**
 * Test des gefunden Sattel
 */
Abhebesicherung.Search.TestAndModify_LagerSystem = function(oDlg, oData,strTable,bZubehoer){
	var oRet = {};
	var strOberflaeche,strIdent;
	oRet.oData 	= oData;
	// fr LAW 4-fach mssen die zulssigen Lasten verdoppelt werden
	if (strTable == "LAW" && oDlg.AuswahlStandard.strSelComboAccessory == "ABHEBESICHERUNG_4"){
		oData.F_AB		= oData.F_AB * 2;
		oData.F_QUER	= oData.F_QUER * 2;
	}
	oRet.bOk 	= Base.TestAndModify(oDlg,oData,1);
	
	//Korrigierre TYP
	var strTyp = oRet.oData.TYP;
	var bTypCorrction = false;	
		
	if(strTyp.indexOf('.XXX.')>0){
		bTypCorrction = true;
		// .XXX. 	--> Auendurchmesser Mantel oder Rohr
		var dAuss;
		if((oDlg.SollwerteRohrUmTeil.dDaemmDicke > 0) && !bZubehoer)
			dAuss = oDlg.SollwerteRohrUmTeil.dDaemmDicke;
		else if((oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != 'STD' || oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder) && !bZubehoer)
			dAuss = (oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder ? oDlg.SollwerteRohrUmTeil.dMantelDuMesserSonder : (oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo*1));
		else if(bZubehoer)
			dAuss = oDlg.AuswahlRollenlager.dSattelOuterDiameter;
			
		if(dAuss >= 1000)
			oRet.bOk = false;
		else if(dAuss >=100 && dAuss<1000)
			strSize = ''+dAuss; 
		else if(dAuss >=10 && dAuss<100)
			dAuss = '0'+dAuss; 
		else if(dSize >=1 && dAuss<10)
			dAuss = '00'+dAuss;
			
		strTyp = strTyp.replace(".XXX.","."+dAuss+".");
	}
	else if(strTyp.indexOf('.XXXX.')>0){
		bTypCorrction = true;
		// .XXXX. 	--> Auendurchmesser Mantel oder Rohr
		var dAuss;
		if(oDlg.SollwerteRohrUmTeil.dDaemmDicke > 0 && !bZubehoer)
			dAuss = oDlg.SollwerteRohrUmTeil.dDaemmDicke;
		else if((oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != 'STD' || oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder) && !bZubehoer)
			dAuss = (oDlg.SollwerteRohrUmTeil.bMantelDuMesserSonder ? oDlg.SollwerteRohrUmTeil.dMantelDuMesserSonder : (oDlg.SollwerteRohrUmTeil.strSelMantelDuMesserCombo*1));
		else if(bZubehoer)
			//dAuss = oDlg.AuswahlRollenlager.dSattelOuterDiameter;
			dAuss = round(oDlg.AuswahlRollenlager.dSattelBearingDiameter);
		
		if(dAuss >= 10000)
			oRet.bOk = false;
		else if(dAuss >=1000 && dAuss<10000)
			strSize = ''+dAuss; 
		else if(dAuss >=100 && dAuss<1000)
			dAuss = '0'+dAuss; 
		else if(dSize >=10 && dAuss<100)
			dAuss = '00'+dAuss;
		else if(dSize >=1 && dAuss<10)
			dAuss = '0'+dAuss;
		
		strTyp = strTyp.replace(".XXXX.","."+dAuss+".");
	}
	
	if(strTyp.indexOf('.XXX-')>0){
		bTypCorrction = true;
		// .XXX --> Sattellnge
		var strSize = Sattel.getFormatLength(oDlg,bZubehoer);
		strTyp = strTyp.replace(".XXX-","."+strSize+"-");
	}
	
	if(strTyp.indexOf('.X')>0 && !bZubehoer){
		bTypCorrction = true;
		//var strWerkstoff 	= oDlg.SollwerteRohrUmTeil.strSelRadioWerkstoff;
		//strWerkstoff		= Produkt.getWerkstoffeNumber(strWerkstoff.replace("LAGER_",""));
		
		//strIdent			= "IDENT_"+strWerkstoff;
		//strIdent			= oRet.oData[strIdent];
		
		strOberflaeche		= '.' + oDlg.AuswahlSattel.strSelComboGroundLevel; 
		//strWerkstoff 		= strWerkstoff+'.'+strOberflaeche; 
		//strTyp				= strTyp.replace('.X',strWerkstoff);
		strTyp				= strTyp.replace('.X',strOberflaeche);
	}
	else if(strTyp.indexOf('.X')>0 && bZubehoer){
		bTypCorrction = true;
		if(oDlg.AuswahlRollenlager.strDialogId == "ROLLENLAGER_U_SATTEL" && oDlg.AuswahlRollenlager.strSelComboMaterial!=''){
			//strIdent			= "IDENT_"+oDlg.AuswahlRollenlager.strSelComboMaterial;
			//strIdent			= oRet.oData[strIdent];
			//var strWerkstoff 	= oDlg.AuswahlRollenlager.strSelComboMaterial+'.'+oDlg.AuswahlRollenlager.strSelComboGroundLevel; 
			var strOberflaeche	= '.'+oDlg.AuswahlRollenlager.strSelComboGroundLevel;
			strTyp				= strTyp.replace('.X',strOberflaeche);
		}
	}
	
	if(!strOberflaeche)
		strOberflaeche = oDlg.AuswahlRollenlager.strSelComboGroundLevel;
	
	//Preise und Gewichte ermitteln
	if(strTable != 'LAW'){
		strOberflaeche	= right(strOberflaeche, 1);
		var oZusatzData = {
			'DELGEW_100'		: (oRet.oData.DELGEW_100*1),
			'dDefaultGew'		: (oRet.oData.GEW_300*1),
			'dDefaultPreis' 	: (oRet.oData.PREIS_0_300*1),
			'dDefaultPreis100' 	: (oRet.oData.DELPREIS_0_100*1),
			'dFaktObfl'			: '',
			'dOberflaeche'		: (strOberflaeche != '') ? strOberflaeche : '',
			'dSonderLength' 	: (!bZubehoer ? oDlg.AuswahlSattel.dSonderLength : false),
			'strSelComboLength' : (!bZubehoer ? oDlg.AuswahlSattel.strSelComboLength : oDlg.AuswahlRollenlager.dSattelLength),
			'L_MIN'				: oRet.oData.L_MIN			
		};
		
		var oCalculationdata 	= Base.buildPreisGewicht(oZusatzData,oData);
		oRet.oData.GEWICHT 		= Math.round(oCalculationdata.dNewGew*100)/100;		
		oRet.oData.PREIS		= (oCalculationdata.dNewPrice < 0) ? 0 : oCalculationdata.dNewPrice;	
		oRet.oData.PREIS_Tab    = Base.getPrice((strOberflaeche !=='4') ? oRet.oData.PREIS : -1);
	}
	else
		oRet.oData.PREIS_Tab    = Base.getPrice((strOberflaeche !=='4') ? oRet.oData.PREIS : -1);
	
	if(bTypCorrction)
		oRet.oData.TYP = strTyp;
	
	return oRet;
}