/**
 * @category   Abhebesicherung function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Abhebesicherung ) === 'undefined' )
	Abhebesicherung = {};
if ( typeof( Abhebesicherung.Search ) === 'undefined' )
	Abhebesicherung.Search = {};

/**
 * Zentraler Einstieg zu suche von Abhebesicherung
 * Wird direkt aufgerufen aus dem Kontroller 
 * @return {Object}
 */
Abhebesicherung.Search.getSearchResult = function(oDlgLagerSession,oData,strDialog,strTable){
	//Mgliche Tabellen
	if(strDialog != "LAGER" && !strTable){
		if(!oData.TYP_AHS_SATTEL && !oData.TYP_AHS_MANTEL){ 
			if(oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke == 0)
				strTable = 'ADM,AKM';
			else
				strTable = 'ADJ,AKJ';
		}
		else{
			if(oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke == 0)
				strTable = oData.TYP_AHS_SATTEL;
			else
				strTable = oData.TYP_AHS_MANTEL;
		}
	}
	
	var myData; //hier muss die Suchfunktion hin
	switch(strDialog){
		case 'SATTEL' :
				myData = Abhebesicherung.Search.Abhebesicherungtyp.Sattel(oDlgLagerSession,oData,strTable);
			break;
		case 'ROLLENLAGER':
				alert("A.S.C: Ze 39 - Sollte nicht vorkommen");
			break;	
		case 'LAGER': //fr Gleitlager mit Abhebesicherung
				myData = Abhebesicherung.Search.Abhebesicherungtyp.Lager(oDlgLagerSession,oData);
			break;
		case 'ROLLENLAGER_U_SATTEL' :
				myData = Abhebesicherung.Search.Abhebesicherungtyp.Zubehoer_Rollenlager_Sattel(oDlgLagerSession,strTable);
			break;
	}
	
	var oRet = {
		'strError' : '',
		'aTableData' : []
	};
		
	if(myData.length == 2){
		try{
			if(myData[0] == 'ERROR' && myData[1] != '')
				oRet.strError = myData[1];
			else if(myData[0] == 'ERROR')
				//oResult.strError = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
				oRet.strError = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
			else
				//oResult.aTableData = myData;
				oRet.aTableData = myData;
		}
		catch(err){}
	}
	else if(myData.length == 0)
		oRet.strError = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
	else
		oRet.aTableData = myData;
	
	return oRet;
}

/**
 * lies Db Zeile aus
 * @param [dbNameTable] {String}
 * @param [strSql] {String} sql Anweisung
 * @return {Object}
 */
Abhebesicherung.Search.getSearchResultData_AllColumns = function(dbNameTable,strSql){	
	return (Object.fromDatabase(dbNameTable,strSql));
};