/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};
if ( typeof( Controller.Lager.Common.AuswahlStandard ) === 'undefined' )
	Controller.Lager.Common.AuswahlStandard = {};
	
Controller.Lager.Common.AuswahlStandard.getFieldSetSpecial = function(oDlgLagerSession,strStatus,bRadio){
	var oSpecial 		= {};
	oSpecial.checkbox	= {};
	oSpecial.show 		= true;
			
	if(strStatus == "INITIAL_HAUPT"){
		oSpecial.Type = 'STANDARD';
		//hier brauchen wir nur die checkbox + Tabelle wenn checkbox whlbar
		if(oDlgLagerSession.AuswahlStandard.bHoehenverstellbar==false){
			oSpecial.disable = false; 
			if((oDlgLagerSession.AuswahlStandard.strSelRadioFunction !== "GEFUEHRT_MEHRFACH" && oDlgLagerSession.Systemcharakteristik.strSelRadioLager !== "LAGER_FS") || 
					(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && oDlgLagerSession.AuswahlStandard.strSelRadioFixed == "KLEMMBAR") ||
					(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && oDlgLagerSession.AuswahlStandard.strSelRadioFixed == "SCHRAUBBAR" && oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn == "EINFACH")
				){
				oSpecial.strHtmlTable = '<table border="1" bgcolor="#FFFF00" style="font-family:Verdana; font-size:8px;">'+
								'<tr>'+
									'<td width=100 valign=top>' + translate( 'IDC_LAGERLAENGE' ) + '</td>' +
									'<td width=100 valign=top>' + translate( 'IDC_LAGERBREITE' ) + '</td>' +
									'<td width=100 valign=top>' + translate( 'IDC_HOEHE' ) + '</td>' +
									'<td width=100 valign=top>' + translate( 'IDC_EINBAUMASS' ) + '</td>'+
								'</tr>' +
								'<tr>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dLaenge + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dBreite + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dHoehe1 + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dMass1  + '</td>' +
								'</tr>'+
							'</table>';
			}
			else{
				oSpecial.strHtmlTable = '<table border="1" bgcolor="#FFFF00" style="font-family:Verdana; font-size:8px;">'+
								'<tr>'+
									'<td width=100 valign=top>' + translate( 'IDC_POSITION' ) + '</td>' +
									'<td width=100 valign=top>' + translate( 'IDC_LAGERLAENGE' ) + '</td>' +
									'<td width=100 valign=top>' + translate( 'IDC_HOEHE' ) + '</td>' +
									'<td width=100 valign=top>' + translate( 'IDC_EINBAUMASS' ) + '</td>'+
								'</tr>' +
								'<tr>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe ? 'H1' : 'E1') + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dLaenge + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dBreite + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dHoehe1 + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dMass1  + '</td>' +
								'</tr>';
				if((rfind(oDlgLagerSession.AuswahlStandard.strSelComboFunction,"2W")>0) ||
						(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS" && oDlgLagerSession.AuswahlStandard.strSelRadioFixed == "SCHRAUBBAR" && oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn == "DOPPELT")
					){
					oSpecial.strHtmlTable += '<tr>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe ? 'H2' : 'E2') + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dLaenge + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dBreite + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dHoehe2 + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dMass2  + '</td>' +
								'</tr>';
				}
				else if((rfind(oDlgLagerSession.AuswahlStandard.strSelComboFunction,"3W")>0) &&
						(oDlgLagerSession.Systemcharakteristik.strSelRadioLager !== "LAGER_FS")
					){
					
					oSpecial.strHtmlTable += '<tr>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe ? 'H2' : 'E2') + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dLaenge + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dBreite + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dHoehe2 + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dMass2  + '</td>' +
								'</tr>'+
								'<tr>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe ? 'H3' : 'E3') + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dLaenge + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dBreite + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dHoehe3 + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dMass3  + '</td>' +
								'</tr>'
				}
				else if((rfind(oDlgLagerSession.AuswahlStandard.strSelComboFunction,"4W")>0)&&
						(oDlgLagerSession.Systemcharakteristik.strSelRadioLager !== "LAGER_FS")
					){
					
					oSpecial.strHtmlTable += '<tr>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe ? 'H2' : 'E2') + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dLaenge + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dBreite + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dHoehe2 + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dMass2  + '</td>' +
								'</tr>'+
								'<tr>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe ? 'H3' : 'E3') + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dLaenge + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dBreite + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dHoehe3 + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dMass3  + '</td>' +
								'</tr>'+
								'<tr>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe ? 'H4' : 'E4') + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dLaenge + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dBreite + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dHoehe4 + '</td>' +
									'<td width=100 valign=top text-align:right;line-height:normal>' + oDlgLagerSession.AuswahlStandard.dMass4  + '</td>' +
								'</tr>'
				}
				oSpecial.strHtmlTable +='</table>';
			}
			
			oSpecial.checkbox.bSonder	= oDlgLagerSession.AuswahlStandard.bSonderAbMessung;
		}
		else{
			oSpecial.disable = true; 
			oSpecial.checkbox.bSonder = false;
		}
	}
	else if(strStatus == "INITIAL_POPUP"){
		var dbName				= 'LAGER2';
		var sqlString			= "select * from SLagerGrenzen where abs(DN)=" + oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo + " ";
		var aResult				= Object.fromDatabase(dbName,sqlString);
		if (aResult.length > 0){
			oDlgLagerSession.AuswahlStandard.dHoeheMin 			= aResult[0].H_MIN;
			oDlgLagerSession.AuswahlStandard.dHoeheMax			= aResult[0].H_MAX;
			var dA	= oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo;
			if (oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder &&
				!oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder &&
				oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo == "STD")
					dA	= oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder;
			else if (oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != "STD" &&
					oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
					dA	= oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder;
			else if (oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != "STD")
					dA	= strSelMantelDuMesserCombo;
			oDlgLagerSession.AuswahlStandard.dMassMin			= Base.buildMountingDimension(aResult[0].H_MIN,dA)
			oDlgLagerSession.AuswahlStandard.dMassMax			= Base.buildMountingDimension(aResult[0].H_MAX,dA)
			oDlgLagerSession.AuswahlStandard.dBreiteSonderMin	= aResult[0].B_MIN;
			oDlgLagerSession.AuswahlStandard.dBreiteSonderMax	= aResult[0].B_MAX;
			oDlgLagerSession.AuswahlStandard.dLaengeSonderMin	= aResult[0].L_MIN;
			oDlgLagerSession.AuswahlStandard.dLaengeSonderMax	= aResult[0].L_MAX;
		}
		
		dbName					= 'LAGER2';
		//sqlString				= "select * from Lager_Laengen";
		sqlString				= "select * from Lager_Laengen where abs(LL_COMBO)<=" + oDlgLagerSession.AuswahlStandard.dLaengeSonderMax +
									" and abs(LL_COMBO)>=" + oDlgLagerSession.AuswahlStandard.dLaengeSonderMin + " ";
		aResult					= Object.fromDatabase(dbName,sqlString);
		var aComboStoreLaenge	= new Array();
		for(var a=0;a<aResult.length;a++){
			aComboStoreLaenge.push([aResult[a].LL_COMBO,aResult[a].LL_COMBO]);
		}
		aComboStoreLaenge.push(["-","-"]);
		if(!Base.isCovered ( aComboStoreLaenge, oDlgLagerSession.AuswahlStandard.dLaenge , 0))
			oDlgLagerSession.AuswahlStandard.dLaenge = aComboStoreLaenge[0][0];
		if (oDlgLagerSession.AuswahlStandard.dLaenge != "-")
			oDlgLagerSession.AuswahlStandard.dLaengeSonder	= oDlgLagerSession.AuswahlStandard.dLaenge;
		
		//sqlString				= "select * from Lager_Breiten";
		sqlString				= "select * from Lager_Breiten where abs(LB_COMBO)<=" + oDlgLagerSession.AuswahlStandard.dBreiteSonderMax +
									" and abs(LB_COMBO)>=" + oDlgLagerSession.AuswahlStandard.dBreiteSonderMin + " ";
		aResult					= Object.fromDatabase(dbName,sqlString);
		var aComboStoreBreite	= new Array();
		for(var a=0;a<aResult.length;a++){
			aComboStoreBreite.push([aResult[a].LB_COMBO,aResult[a].LB_COMBO]);
		}
		aComboStoreBreite.push(["-","-"]);
		if(!Base.isCovered ( aComboStoreBreite, oDlgLagerSession.AuswahlStandard.dBreite , 0))
			oDlgLagerSession.AuswahlStandard.dBreite = aComboStoreBreite[0][0];
		if (oDlgLagerSession.AuswahlStandard.dBreite != "-")
			oDlgLagerSession.AuswahlStandard.dBreiteSonder	= oDlgLagerSession.AuswahlStandard.dBreite;
		
		oSpecial.disable 	= {};
		oSpecial.value   	= {};
		oSpecial.value.Q1	= {};
		oSpecial.value.Q2	= {};
		oSpecial.value.Q3	= {};
		oSpecial.value.Q4	= {};
		oSpecial.value.LAENGE 			= oDlgLagerSession.AuswahlStandard.dLaenge;
		oSpecial.value.LAENGE_MIN		= oDlgLagerSession.AuswahlStandard.dLaengeSonderMin;
		oSpecial.value.LAENGE_MAX		= oDlgLagerSession.AuswahlStandard.dLaengeSonderMax;
		oSpecial.value.LAENGESTORE 		= aComboStoreLaenge;
		oSpecial.value.SONDER_LAENGE	= oDlgLagerSession.AuswahlStandard.dLaengeSonder;
		oSpecial.disable.SONDER_LAENGE	= (oDlgLagerSession.AuswahlStandard.dLaenge == "-" ? false : true);
		oSpecial.value.BREITE 			= oDlgLagerSession.AuswahlStandard.dBreite;
		oSpecial.value.BREITE_MIN		= oDlgLagerSession.AuswahlStandard.dBreiteSonderMin;
		oSpecial.value.BREITE_MAX		= oDlgLagerSession.AuswahlStandard.dBreiteSonderMax;
		oSpecial.value.BREITESTORE 		= aComboStoreBreite;
		oSpecial.value.SONDER_BREITE	= oDlgLagerSession.AuswahlStandard.dBreiteSonder;
		oSpecial.disable.SONDER_BREITE	= (oDlgLagerSession.AuswahlStandard.dBreite == "-" ? false : true);
		oSpecial.checkbox	= {};
		oSpecial.title		= {};
		oSpecial.title.Q1		= translate("IDC_SONDER_FIELDSET_Q1");
		oSpecial.title.Q2		= translate("IDC_SONDER_FIELDSET_Q2");
		oSpecial.title.Q3		= translate("IDC_SONDER_FIELDSET_Q3");
		oSpecial.title.Q4		= translate("IDC_SONDER_FIELDSET_Q4");
		
		var LGTypen		= Lager.Search.getDBTableGleitlager(oDlgLagerSession);
		var LGSubtyp	= left(LGTypen, 3);
		if (rfind(LGTypen, ",") > 0)
			var LGBauForm	= right(left(Lager.Search.getDBTableGleitlager(oDlgLagerSession), 4), 1) +
								(dA > 168.3 ? "3" : "x");
		else if (left(LGSubtyp, 2) == "FS")
			var LGBauForm	= (dA > 323.9 ? "02" : "01");
		else
			var LGBauForm	= (dA > 219.1 ? "23" : "2x");
		oSpecial.picture1	= '<img src="EasyKatImages/specpart/' + LGSubtyp + '_S_' + LGBauForm + '_V1.png" style="cursor:pointer" />';
		oSpecial.picture2	= '<img src="EasyKatImages/specpart/' + LGSubtyp + '_S_' + LGBauForm + '_V2.png" style="cursor:pointer" />';
		
		oSpecial.Type			= 'POPUP';
		if((oDlgLagerSession.AuswahlStandard.strSelRadioFunction !== "GEFUEHRT_MEHRFACH"
			&& oDlgLagerSession.Systemcharakteristik.strSelRadioLager !== "LAGER_FS")||	// Lager - kein Festpunkt
				(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS" &&
					oDlgLagerSession.AuswahlStandard.strSelRadioFixed == "KLEMMBAR") || // Festpunkt klemmbar
				(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS" &&
					oDlgLagerSession.AuswahlStandard.strSelRadioFixed == "SCHRAUBBAR" &&
					oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn == "EINFACH")	// Festpunkt schraubbar einfach
			){
			
			oSpecial.disable.Q1 = false;
			oSpecial.disable.Q2	= true;
			oSpecial.disable.Q3	= true;
			oSpecial.disable.Q4	= true;
			//oSpecial.disable.LAENGE 		= ((oDlgLagerSession.Systemcharakteristik.strSelRadioLager == 'LAGER_SPG') && (!oDlgLagerSession.AuswahlStandard.bGaT)) ? true : false;
			oSpecial.disable.LAENGE 		= false;
			oSpecial.value.Q1.HOEHE 		= oDlgLagerSession.AuswahlStandard.dHoehe1;
			oSpecial.value.Q1.EINBAUMASS 	= oDlgLagerSession.AuswahlStandard.dMass1;
			oSpecial.value.Q1.EMASS_MIN 	= oDlgLagerSession.AuswahlStandard.dMassMin;
			oSpecial.value.Q1.HOEHE_MIN 	= oDlgLagerSession.AuswahlStandard.dHoeheMin;
			oSpecial.value.Q1.EMASS_MAX 	= oDlgLagerSession.AuswahlStandard.dMassMax;
			oSpecial.value.Q1.HOEHE_MAX 	= oDlgLagerSession.AuswahlStandard.dHoeheMax;
			oSpecial.checkbox.Q1			= (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe1 ? "HOEHE" : "EINBAUMASS");
			
		}
		else{
			oSpecial.disable.Q1 			= false;
			oSpecial.disable.Q2				= false;
			oSpecial.value.Q1.HOEHE 		= oDlgLagerSession.AuswahlStandard.dHoehe1;
			oSpecial.value.Q1.EINBAUMASS 	= oDlgLagerSession.AuswahlStandard.dMass1;
			oSpecial.value.Q1.EMASS_MIN 	= oDlgLagerSession.AuswahlStandard.dMassMin;
			oSpecial.value.Q1.HOEHE_MIN 	= oDlgLagerSession.AuswahlStandard.dHoeheMin;
			oSpecial.value.Q1.EMASS_MAX 	= oDlgLagerSession.AuswahlStandard.dMassMax;
			oSpecial.value.Q1.HOEHE_MAX 	= oDlgLagerSession.AuswahlStandard.dHoeheMax;
			oSpecial.value.Q2.HOEHE 		= oDlgLagerSession.AuswahlStandard.dHoehe2;
			oSpecial.value.Q2.EINBAUMASS 	= oDlgLagerSession.AuswahlStandard.dMass2;
			oSpecial.value.Q2.EMASS_MIN 	= oDlgLagerSession.AuswahlStandard.dMassMin;
			oSpecial.value.Q2.HOEHE_MIN 	= oDlgLagerSession.AuswahlStandard.dHoeheMin;
			oSpecial.value.Q2.EMASS_MAX 	= oDlgLagerSession.AuswahlStandard.dMassMax;
			oSpecial.value.Q2.HOEHE_MAX 	= oDlgLagerSession.AuswahlStandard.dHoeheMax;
			oSpecial.checkbox.Q1			= (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe1 ? "HOEHE" : "EINBAUMASS");
			oSpecial.checkbox.Q2			= (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe2 ? "HOEHE" : "EINBAUMASS");
			
			if((rfind(oDlgLagerSession.AuswahlStandard.strSelComboFunction,"3W") > 0
				|| rfind(oDlgLagerSession.AuswahlStandard.strSelComboFunction,"4W")>0) &&
				(oDlgLagerSession.Systemcharakteristik.strSelRadioLager !== "LAGER_FS")
				){
				
				oSpecial.disable.Q3 			= false;
				oSpecial.value.Q3.HOEHE 		= oDlgLagerSession.AuswahlStandard.dHoehe3;
				oSpecial.value.Q3.EINBAUMASS 	= oDlgLagerSession.AuswahlStandard.dMass3;
				oSpecial.value.Q1.EMASS_MIN 	= oDlgLagerSession.AuswahlStandard.dMassMin;
				oSpecial.value.Q3.HOEHE_MIN 	= oDlgLagerSession.AuswahlStandard.dHoeheMin;
				oSpecial.value.Q3.EMASS_MAX 	= oDlgLagerSession.AuswahlStandard.dMassMax;
				oSpecial.value.Q3.HOEHE_MAX 	= oDlgLagerSession.AuswahlStandard.dHoeheMax;
				oSpecial.checkbox.Q3			= (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe3 ? "HOEHE" : "EINBAUMASS");
			}
			else
				oSpecial.disable.Q3 = true;
			
			if((rfind(oDlgLagerSession.AuswahlStandard.strSelComboFunction,"4W")>0)&&
				(oDlgLagerSession.Systemcharakteristik.strSelRadioLager !== "LAGER_FS")
				){
				
				oSpecial.disable.Q4 			= false;
				oSpecial.value.Q4.HOEHE 		= oDlgLagerSession.AuswahlStandard.dHoehe4;
				oSpecial.value.Q4.EINBAUMASS 	= oDlgLagerSession.AuswahlStandard.dMass4;
				oSpecial.value.Q1.EMASS_MIN 	= oDlgLagerSession.AuswahlStandard.dMassMin;
				oSpecial.value.Q4.HOEHE_MIN 	= oDlgLagerSession.AuswahlStandard.dHoeheMin;
				oSpecial.value.Q4.EMASS_MAX 	= oDlgLagerSession.AuswahlStandard.dMassMax;
				oSpecial.value.Q4.HOEHE_MAX 	= oDlgLagerSession.AuswahlStandard.dHoeheMax;
				oSpecial.checkbox.Q4			= (oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe4 ? "HOEHE" : "EINBAUMASS");
			}
			else
				oSpecial.disable.Q4 = true;
		}
	}
	
	return oSpecial;
}