/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};
if ( typeof( Controller.Lager.Common.AuswahlStandard ) === 'undefined' )
	Controller.Lager.Common.AuswahlStandard = {};
	
Controller.Lager.Common.AuswahlStandard.getFieldSetFunction = function(oDlgLagerSession,oDefaultDialogData){
	var strRadioSelection = oDlgLagerSession.AuswahlStandard.strSelRadioFunction;
	var strComboSelection = oDlgLagerSession.AuswahlStandard.strSelComboFunction;
	var storeCombo;
	var oFunction 		= {};
	oFunction.value 	= {};
	oFunction.hide		= {};
	oFunction.disable	= {}; 
	
	oFunction.show = true;
	var bSmallCombo = ((oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief*1) > 0) ? true : false; 
	/*
	if(!bSmallCombo)
		bSmallCombo = ((oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial*1) > 0) ? false : true; 
	if(!bSmallCombo)
		bSmallCombo = ((oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer*1) > 0) ? false : true; 
	*/
	var bKlemmSys	= ((oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium*1) > 450) ? false : true;
	
	//Combobox Store 
	if(!oDlgLagerSession.bLastKettePathSelection && !bSmallCombo && bKlemmSys){
		storeCombo = [
			[ 'FUEHRUNG_2W'		, translate('LAGER_FUEHRUNG_2W') ],
			[ 'FUEHRUNG_2W+'	, translate('LAGER_FUEHRUNG_2W_PLUS') ],
			[ 'FUEHRUNG_2W_90'	, translate('LAGER_FUEHRUNG_2W90') ],
			[ 'FUEHRUNG_3W'		, translate('LAGER_FUEHRUNG_3W') ],
			[ 'FUEHRUNG_4W'		, translate('LAGER_FUEHRUNG_4W') ]
		];
	}
	else if(!oDlgLagerSession.bLastKettePathSelection && !bSmallCombo && !bKlemmSys){
		storeCombo = [
			[ 'FUEHRUNG_2W'		, translate('LAGER_FUEHRUNG_2W') ],
			[ 'FUEHRUNG_2W_90'	, translate('LAGER_FUEHRUNG_2W90') ],
			[ 'FUEHRUNG_3W'		, translate('LAGER_FUEHRUNG_3W') ],
			[ 'FUEHRUNG_4W'		, translate('LAGER_FUEHRUNG_4W') ]
		];
	}
	else if(!oDlgLagerSession.bLastKettePathSelection && bSmallCombo && bKlemmSys){
		storeCombo = [
			[ 'FUEHRUNG_2W'		, translate('LAGER_FUEHRUNG_2W') ],
			[ 'FUEHRUNG_2W+'	, translate('LAGER_FUEHRUNG_2W_PLUS') ],
			[ 'FUEHRUNG_4W'		, translate('LAGER_FUEHRUNG_4W') ]
		];
	}
	else if(!oDlgLagerSession.bLastKettePathSelection && bSmallCombo && !bKlemmSys){
		storeCombo = [
			[ 'FUEHRUNG_2W'		, translate('LAGER_FUEHRUNG_2W') ],
			[ 'FUEHRUNG_4W'		, translate('LAGER_FUEHRUNG_4W') ]
		];
	}
	else{
		storeCombo = [
			[ 'FUEHRUNG_2W_90'	, translate('LAGER_FUEHRUNG_2W90') ],
			[ 'FUEHRUNG_3W'		, translate('LAGER_FUEHRUNG_3W') ]
		];
	}
	
	var bIsCovered = Base.isCovered( storeCombo, strComboSelection , 0);
	if(!bIsCovered){
		strComboSelection = storeCombo[0][0];
		oDlgLagerSession.AuswahlStandard.strSelComboFunction = strComboSelection;
	}
	
	if(strRadioSelection !== "GEFUEHRT_MEHRFACH"){
		oFunction.hide 			= {'combo' : {'value' : true}};
		oFunction.store 		= storeCombo;
		oFunction.value.combo 	= (strComboSelection ? strComboSelection : "FUEHRUNG_2W");
	}
	else{
		oFunction.hide = {'combo' : {'value' : false}};
		oFunction.store 		= storeCombo;
		oFunction.value.combo 	= (strComboSelection ? strComboSelection : "FUEHRUNG_2W");
	}
	
	//hide kann erweitert werden um die einzelnen Radios
	//Bsp. oFunction.hide.radio = {'vLOSE' : true, 'vGEFUEHRT' : false , 'vGEFUEHRT_MEHRFACH' : false}
	
	//radio selection
	oFunction.disable.radio	= {};
	oFunction.disable.radio.vLOSE		= oDefaultDialogData.bLoslager ? !oDefaultDialogData.bLoslager : true;
	//Kann aus Vorsystemen so kommen (Abhebelast aber Loslager)
	//if((oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief*1) > 0)
		//oFunction.disable.radio.vLOSE	= true;
		//strRadioSelection	 			= (oDefaultDialogData.bFuehrungslager ? 'GEFUEHRT' : 'GEFUEHRT_MEHRFACH');
	
	oFunction.disable.radio.vGEFUEHRT	= oDefaultDialogData.bFuehrungslager ? !oDefaultDialogData.bFuehrungslager : true;
	
	if(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == 'LAGER_EPG')
		oFunction.disable.radio.vGEFUEHRT = Controller.Lager.Common.AuswahlStandard.getGleitelement(oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart);
	
	oFunction.disable.radio.vGEFUEHRT_MEHRFACH	= oDefaultDialogData.bFuehrungMehrfach ? !oDefaultDialogData.bFuehrungMehrfach : true;
	oFunction.value.radio 						= (strRadioSelection ? strRadioSelection : 'GEFUEHRT');
	
	if(oDlgLagerSession.bLastKettePathSelection){
		var oForms	= Base.Store.getForms();
		var strHaengertyp 		= oForms.AUSWAHL_HAENGERTYP.IDC_IMAGE_ID;
		var strLastAbtragung 	= oForms.SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG;
		
		if((oDlgLagerSession.Systemcharakteristik.strSelRadioLager == 'LAGER_SSG') && (strLastAbtragung != "STUETZEND_EINFACH")){
			oFunction.disable.radio.vGEFUEHRT_MEHRFACH = true;
			oFunction.disable.radio.vGEFUEHRT = true;
			
			if(oDlgLagerSession.AuswahlStandard.strSelRadioFunction != 'LOSE'){
				oFunction.value.radio = 'LOSE';	
				oDlgLagerSession.AuswahlStandard.strSelRadioFunction = 'LOSE';
			}
		}
		
		if(strLastAbtragung == "STUETZEND_EINFACH"){
			switch(strHaengertyp){
				case "KSR"	:
				case "KSP"	:
				case "FSP"	:
				case "FSS"	:
						oFunction.disable.radio.vGEFUEHRT_MEHRFACH 	= false;
						oFunction.disable.radio.vGEFUEHRT 			= true;
						oFunction.disable.radio.vLOSE				= false;
						oFunction.value.radio = (oFunction.value.radio == 'GEFUEHRT_MEHRFACH') ? oFunction.value.radio : 'LOSE';	
						//oDlgLagerSession.AuswahlStandard.strSelRadioFunction = 'LOSE';
					break;
			}
		}
	}
	return oFunction;
}


Controller.Lager.Common.AuswahlStandard.getGleitelement = function(strComboId){
	//if(strComboId == 'OHNE')
	//if(strComboId == 'OHNE' || strComboId == '-')
	// @@@ LGE Test
	if(strComboId == 'OHNE' || strComboId == '-' || strComboId == 'LGE')
		return false;
	else
		return true;
}

// @@@ LGE Test
Controller.Lager.Common.AuswahlStandard.getFieldSetFunctionLGE = function(oDlgLagerSession,strComboId, strComboValue){
	var strRadioSelection = oDlgLagerSession.AuswahlStandard.strSelRadioFunction;
	var strComboSelection = oDlgLagerSession.AuswahlStandard.strSelComboFunction;
	var storeCombo;
	var oFunction 		= {};
	oFunction.value 	= {};
	oFunction.hide		= {};
	oFunction.disable	= {}; 
	
	oFunction.show = true;
	
	return oFunction;
}