/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};
if ( typeof( Controller.Lager.Common.AuswahlStandard ) === 'undefined' )
	Controller.Lager.Common.AuswahlStandard = {};
	
Controller.Lager.Common.AuswahlStandard.getFieldSetFixed = function(oDlgLagerSession,oData){
	var oFixed = {};
	oFixed.disabled = {};
	oFixed.show = true;
	
	var strSelBB 		= oDlgLagerSession.AuswahlStandard.strSelRadioFixed;
	var strSelScrewOn 	= oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn;
		
	switch(oData.strShow){
		case 'ALL' 	:
				oFixed.disabled.vSCHRAUBBAR = false;
				oFixed.disabled.vEINFACH 	= ((strSelBB !== 'SCHRAUBBAR') ? true : false);
				oFixed.disabled.vDOPPELT 	= ((strSelBB !== 'SCHRAUBBAR') ? true : false);
			break;
		case 'D_K' 	:
				oFixed.disabled.vEINFACH 	=  true;
				oFixed.disabled.vDOPPELT 	= ((strSelBB !== 'SCHRAUBBAR') ? true : false);
			break;
		case 'S_K' 	:
				oFixed.disabled.vEINFACH 	= ((strSelBB !== 'SCHRAUBBAR') ? true : false);
				oFixed.disabled.vDOPPELT 	= true;
			break;
		case 'K'	:
				oFixed.disabled.vSCHRAUBBAR = true;
				oFixed.disabled.vEINFACH 	= true;
				oFixed.disabled.vDOPPELT 	= true;
			break;
		case 'D'	:
				oFixed.disabled.vSCHRAUBBAR = false;
				oFixed.disabled.vKLEMMBAR	= true;
				oFixed.disabled.vEINFACH 	=  true;
				oFixed.disabled.vDOPPELT 	= false;
			break;
		case 'S'	:
				oFixed.disabled.vSCHRAUBBAR = false;
				oFixed.disabled.vKLEMMBAR	= true;
				oFixed.disabled.vEINFACH 	=  false;
				oFixed.disabled.vDOPPELT 	= true;
			break;
		case 'SD'	:
				oFixed.disabled.vSCHRAUBBAR = false;
				oFixed.disabled.vKLEMMBAR	= false;
				oFixed.disabled.vEINFACH 	= false;
				oFixed.disabled.vDOPPELT 	= false;
			break;
	}
	
	//radio selection
	oFixed.value = {
		'SelBB' 		: (strSelBB ? strSelBB : 'KLEMMBAR'),
		'SelSCHRAUBBAR' : (strSelScrewOn ? strSelScrewOn : 'EINFACH')	//Muss erweitert werden um entsprechende Variable
	};
	
	
		
	return oFixed;
}