/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};
if ( typeof( Controller.Lager.Common.AuswahlStandard ) === 'undefined' )
	Controller.Lager.Common.AuswahlStandard = {};
	
Controller.Lager.Common.AuswahlStandard.getFieldSetBeam = function(oDlgLagerSession,strComponent,strTraegertyp){
	strComponent  = (strComponent ? strComponent : 'ALL');
	strComponent  = strComponent.replace("ROLLEN_","");
	
	var oBeam = {};
	oBeam.store = {};
	oBeam.show = oDlgLagerSession.AuswahlStandard.strSelRadioFixed === 'KLEMMBAR' ? true : false;
	
	/**
	 * @private hole gltige Trgergren fr eine Profilart
	 * @params string strProfilart - aktuelle Profilart
	 * @returns	object - daten: Array von Arrays mit je zwei Werten (Value und Text) fr jede Trgergre
	 *                   strTraegergroesse: Defaultwert fr aktuelle Trgergre
	 */
	_holeTraegergroessen = function( strProfilart, strSize, isRLAuswahl ){
		var aDaten 		= new Array();
		var strTraeger 	= strSize;
		var bTraeger 	= false;
		// baue select-statement
		var strSelect = "SELECT TRAE_GR FROM " + strProfilart;
		if (isRLAuswahl)	// kleinere Trgerbreiten fr RL-Klemmungen nicht zulssig
			//strSelect	+= " WHERE ((abs(B) >= "+100+" AND abs(TG) >= "+10+") OR abs(B) >"+100+") ";
			strSelect	+= " WHERE (abs(B) >"+100+") ";
		
		var numRet	= dbselect( "LAGER2", strSelect, strDBCache );
		
		var strDBCache = "RH_TRAEGER";
		if ( dbselect( "LAGER2", strSelect, strDBCache ) )
		{
			var strDBTraeger = "";
			
			while ( !dbiseof( strDBCache ) )
			{
				// Profilart und ID einfgen
				strDBTraeger = dbgetstring( strDBCache, "TRAE_GR" );					
				if(strTraeger == strDBTraeger && !bTraeger)
					bTraeger = true;
					
				aDaten.push( [ strDBTraeger, strDBTraeger ] );

				// nchster Record
				dbskip( strDBCache );
			}
		}
		
		// hole Werte aus Tabelle
		// Werdau 12. Dezember 2011 - fr Sonder Gren erweitere Combo um "-"
		aDaten.push(["-","-"]);
		
		if(!Base.isCovered( aDaten, strTraeger , 0))
			strTraeger = (aDaten.length > 1) ? aDaten[1][0] : aDaten[0][0];
			//strTraeger = (aDaten.length > 2) ? aDaten[2][0] : aDaten[0][0];
		
		// Rckgabe der gefundenen Werte
		return({ 
			daten: aDaten, 
			strTraegergroesse: strTraeger
		} );
	}
	
	var oTraegerData,oTraegerGroessen;
	if(strComponent === 'ALL')
		oTraegerData 		= Klemmsystem.getDataTraeger(oDlgLagerSession,strTraegertyp);
	
	if(strComponent === 'ALL' || strComponent === 'LAGER_TRAEGER_ART')
		oTraegerGroessen 	= _holeTraegergroessen((oTraegerData ? oTraegerData.strProfilart : oDlgLagerSession.AuswahlStandard.strSelComboBeamArt), oDlgLagerSession.AuswahlStandard.strSelComboBeamSize, (rfind(oDlgLagerSession.Systemcharakteristik.strSelRadioLager,"ROLL") > 0 || oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager == "KR") ? 1 : 0);
	
	var oTraegerDaten		= Klemmsystem.holeTraegerdaten((oTraegerData ? oTraegerData.strProfilart : oDlgLagerSession.AuswahlStandard.strSelComboBeamArt),(oTraegerGroessen ? oTraegerGroessen.strTraegergroesse : oDlgLagerSession.AuswahlStandard.strSelComboBeamSize));
	
	if(strComponent === 'ALL' || strComponent === 'LAGER_TRAEGER_ART')
		oDlgLagerSession.AuswahlStandard.strSelComboBeamSize 	= oTraegerGroessen.strTraegergroesse;
	
	oDlgLagerSession.AuswahlStandard.dBeamHeight			= oTraegerDaten.strTraegerhoehe;
	oDlgLagerSession.AuswahlStandard.dBeamWidth				= oTraegerDaten.strTraegerbreite;
	oDlgLagerSession.AuswahlStandard.dBeamThickness			= oTraegerDaten.strFlanschdicke;
	
	if(strComponent === 'ALL'){
		var storeArt 			= oTraegerData.Store;	
		oBeam.store.storeTArt 	= storeArt;
	}
	
	if(strComponent === 'ALL' || strComponent === 'LAGER_TRAEGER_ART'){
		var storeGroesse 	= oTraegerGroessen.daten;
		oBeam.store.storeTGroesse =storeGroesse;
	}
	
	//disable 
	oBeam.disabled = {
		'disTArt'		: false,
		'disTGroesse' 	: false,
		'disHoehe'  	: (oDlgLagerSession.AuswahlStandard.strSelComboBeamSize  == '-' ? false : true),
		'disBreite' 	: (oDlgLagerSession.AuswahlStandard.strSelComboBeamSize  == '-' ? false : true),
		'disFDicke'		: (oDlgLagerSession.AuswahlStandard.strSelComboBeamSize  == '-' ? false : true)
	}; 
	
	//radio selection
	oBeam.value = {
		'vTArt'		: 	oDlgLagerSession.AuswahlStandard.strSelComboBeamArt,
		'vTGroesse' :	oDlgLagerSession.AuswahlStandard.strSelComboBeamSize,
		'vHoehe'  	:	oDlgLagerSession.AuswahlStandard.dBeamHeight,
		'vBreite' 	:	oDlgLagerSession.AuswahlStandard.dBeamWidth,
		'vFDicke'	:   oDlgLagerSession.AuswahlStandard.dBeamThickness
	};
	
	return oBeam;
}