/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};
if ( typeof( Controller.Lager.Common.AuswahlStandard ) === 'undefined' )
	Controller.Lager.Common.AuswahlStandard = {};
	
Controller.Lager.Common.AuswahlStandard.getFieldSetAttribute = function(oDlgLagerSession,strVersion,oDefaultDialogData){
	var oMerkmale = {};
	oMerkmale.show = true;
		
	//hide kann erweitert werden um die einzelnen Radios
	oMerkmale.hide = {
		//'vHoehenverstellbar'	: ((strVersion == 'LAGERSCHLITTEN' || strVersion == 'FESTPUNKT_STOP_W') ? false : true),
		//'vGAT'					: (strVersion == 'LAGERSCHLITTEN' ? false : true),
		'vBUEGEL'				: (strVersion == 'FESTPUNKT_STOP_U' ? false : true)
	};
	
	//disable 
	oMerkmale.disabled = {
		'vHoehenverstellbar'	: oDlgLagerSession.bLastKettePathSelection ? true : oDefaultDialogData.oCheckBox.oDisable.Hoehenverstellbar,
		'vGAT'					: oDefaultDialogData.oCheckBox.oDisable.Gleitunterlage
	}; //entsprechend hide

	
	var aStore 		= oDefaultDialogData.oCombo.oValue.aGleitelem ? oDefaultDialogData.oCombo.oValue.aGleitelem : [[]];
	var aAccessory 	= oDefaultDialogData.oCombo.oValue.aAccessory ? oDefaultDialogData.oCombo.oValue.aAccessory : [[]];
	
	if(oDlgLagerSession.bLastKettePathSelection){
		aAccessory = [['-','-']];
		var bIsCovered = Base.isCovered( aAccessory, oDlgLagerSession.AuswahlStandard.strSelComboAccessory , 0);
		if(!bIsCovered){
			strComboSelection = aAccessory[0][0];
			oDlgLagerSession.AuswahlStandard.strSelComboAccessory = strComboSelection;
		}
	}
	
	//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< UPDATE >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//die Funktion hier muss erstetzt werden !!!!!!!!!!!!!!!!!!!
	//var oOberflaeche  = Base.buildOberflaeche(oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel);
	var oOberflaeche = Base.setSpecialOberflaechenFaktor(oDlgLagerSession.Systemcharakteristik.strSelRadioLager,oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel,oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff);
	oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel = oOberflaeche.Selection;
	
	
	oMerkmale.store = {
		'combo' 	: [
			['storeGleitelement',aStore],
			['storeOberflaeche',oOberflaeche.Store],
			['storeACCESSORY',aAccessory]
		],
		'disable' 	: [
			['GLEITELEMENT',(aStore.length == 1 ? true : false)],
			['OBERFLAECHE',(oOberflaeche.Store.length == 1 ? true : false)],
			['ACCESSORY',(aAccessory.length == 1 ? true : false)]
		],
		'show'		: [
			['GLEITELEMENT',(aStore.length != 0 ? true : false)],
			['OBERFLAECHE',(oOberflaeche.Store.length != 0 ? true : false)],
			['ACCESSORY',(aAccessory.length != 0 ? true : false)]
		],
		'sel'		: [
			['GLEITELEMENT',oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart],
			['OBERFLAECHE',oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel],
// @@@ LGE TEST
			['ACCESSORY',oDlgLagerSession.AuswahlStandard.strSelComboAccessory]
//			['ACCESSORY',aAccessory[0][0]]
		]
	};
	
	//radio selection
	oMerkmale.value = {
		'vHoehenverstellbar'	: oDlgLagerSession.AuswahlStandard.bHoehenverstellbar,	
		'vGAT'					: oDlgLagerSession.AuswahlStandard.bGaT,	
		'vBUEGEL'				: oDlgLagerSession.AuswahlStandard.bBuegel
	};
	
	return oMerkmale;
}