/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */
if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};
if ( typeof( Controller.Lager.Common.AuswahlRollenlager ) === 'undefined' )
	Controller.Lager.Common.AuswahlRollenlager = {};
	
Controller.Lager.Common.AuswahlRollenlager.getFieldSetRollenlager = function(oDlgLagerSession,strId){
	var strTyp 			= oDlgLagerSession.AuswahlRollenlager.strDialogId;
	var oRollenlager 	= {};
		oRollenlager.value = {};
		oRollenlager.show  = true;
	
	var _StoreLagerArt = function(oDlgLagerSession, strTyp){
		var aStoreArt 			= [];
		var sqlString 			= "select * from AUSLEGUNG_ROLLEN_LAGER ";
		
		if(strTyp !== "ROLLENLAGER_P" && strTyp !== "ROLLENLAGER_S")
			sqlString += "WHERE LAGERART <> 'ZYLINDER' ";
		else if(strTyp === "ROLLENLAGER_S"){
			var oTempTable = getDataFromLagerCacheObject("AuswahlSattel","TEMP_TABLE",oDlgLagerSession.AuswahlSattel.strResultId)
			var strMoeglicheLagerArten = Sattel.ZuordnungRollenlager(oTempTable.RollenlagerTable)
			var aMoeglicheLagerArten = strMoeglicheLagerArten.split(",");
			for(var a=0;a<aMoeglicheLagerArten.length;a++){
				sqlString += (a==0) ? "WHERE LAGERART <> '"+aMoeglicheLagerArten[a]+"' " : "AND LAGERART <> '"+aMoeglicheLagerArten[a]+"'";
			}
		}
		
		sqlString += "GROUP BY LAGERART";
		
		var dbName				= 'LAGER2';
		var dbNameTable 		= "ROLLENLAGER_STORE_LAGERTYP";		
		var dTableDatenLength 	= dbselect( dbName, sqlString, dbNameTable );	
		if ( dTableDatenLength > 0 ){
			while ( dbiseof( dbNameTable) == 0 ){	//Hier sollte nur eun Wert rauskommen, wenn  nicht dann ist die Aufstellung in der DB falsch
				var strID = dbgetstring(dbNameTable,"LAGERART");	
				aStoreArt.push([strID,translate("LAGERART_"+strID)]);			
				dbskip(dbNameTable);
			}
		}
		
		if(!Base.hasValueIntoArrayPositionNull(aStoreArt,oDlgLagerSession.AuswahlRollenlager.strSelComboTyp)) //notwendige Korrektur
			oDlgLagerSession.AuswahlRollenlager.strSelComboTyp = aStoreArt[0][0];
		
		return aStoreArt;
	};
	
	
	var _StoreTypData = function(oDlgLagerSession){
		var aStoreType = [];
		var aSplitTable= [];
		var dbName				= 'LAGER2';
		var dbNameTable 		= "ROLLENLAGER_STORE_TYP";		
		
		if(oDlgLagerSession.AuswahlRollenlager.strSelComboTyp == "DOPPELZYLINDER")
			aSplitTable.push("RDF");
		else{
			aSplitTable.push("RKF");
			aSplitTable.push("RKL");
		}
		
		for(var a=0;a<aSplitTable.length;a++){
			var sqlString 			= "SELECT TYP FROM "+aSplitTable[a];
			var dTableDatenLength 	= dbselect( dbName, sqlString, dbNameTable );
			if ( dTableDatenLength > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){	//Hier sollte nur eun Wert rauskommen, wenn  nicht dann ist die Aufstellung in der DB falsch
					var strID = dbgetstring(dbNameTable,"TYP");	
					aStoreType.push([strID,strID]);			
					dbskip(dbNameTable);
				}
			}
		}		
		
		if(!Base.hasValueIntoArrayPositionNull(aStoreType,oDlgLagerSession.AuswahlRollenlager.strSelComboType)) //notwendige Korrektur
			oDlgLagerSession.AuswahlRollenlager.strSelComboType = aStoreType[0][0];
		
		return aStoreType;
	};
	
	var _buildTabPart = function(){
		var strTable = "A";
		if(oDlgLagerSession.AuswahlRollenlager.strSelComboTyp == 'DOPPELZYLINDER')
			strTable +="D";
		else
			strTable +="K";
		
		return strTable;
	}
	
	var _getAbhebesicherungsTable = function(){
		var strTable = "A";
		if(oDlgLagerSession.AuswahlRollenlager.strSelComboTyp == 'DOPPELZYLINDER')
			strTable +="D";
		else
			strTable +="K"; 
		
		return strTable;
	}
	
	var _StoreMaterialData = function(vTyp,oDlgLagerSession){
		var aStoreType 	= [];
		var dbName		= 'LAGER2';
		var dbNameTable = "ROLLENLAGER_STORE_MATERIAL";			
		var strTable 	= _getAbhebesicherungsTable();
		
		var sqlString  = "SELECT * FROM Werkst_Obfl_Zuordnung"; //noch zu definieren
			sqlString += " WHERE TYP like '"+strTable+"%'";
			sqlString += " GROUP BY WERKSTOFF ";
		
		var dTableDatenLength 	= dbselect( dbName, sqlString, dbNameTable );
		if ( dTableDatenLength > 0 ){
			while ( dbiseof( dbNameTable) == 0 ){	//Hier sollte nur eun Wert rauskommen, wenn  nicht dann ist die Aufstellung in der DB falsch
				var strID = dbgetstring(dbNameTable,"WERKSTOFF");	
				
				aStoreType.push([strID,Base.getLanguageTextWerkstoff(strID).strText]);			
				dbskip(dbNameTable);
			}
		}
		
		if(!Base.hasValueIntoArrayPositionNull(aStoreType,oDlgLagerSession.AuswahlRollenlager.strSelComboMaterial)) //notwendige Korrektur
			oDlgLagerSession.AuswahlRollenlager.strSelComboMaterial = aStoreType[0][0];
		
		return aStoreType;		
	};
	
	var _StoreOberflacheData = function(oDlgLagerSession){
		var aStoreType 	= [];
		var dbName		= 'LAGER2';
		var dbNameTable = "ROLLENLAGER_STORE_MATERIAL";	
		var strTable 	= _getAbhebesicherungsTable();
		var sqlString  = "SELECT DISTINCT OBFL FROM Werkst_Obfl_Zuordnung"; //noch zu definieren
			sqlString += " WHERE TYP like '"+strTable+"%'";
			sqlString += " AND WERKSTOFF = '"+oDlgLagerSession.AuswahlRollenlager.strSelComboMaterial+"' ";
			//sqlString += " GROUP BY WERKSTOFF ";
		
		var dTableDatenLength 	= dbselect( dbName, sqlString, dbNameTable );
		if ( dTableDatenLength > 0 ){
			while ( dbiseof( dbNameTable) == 0 ){	//Hier sollte nur eun Wert rauskommen, wenn  nicht dann ist die Aufstellung in der DB falsch
				var strID = dbgetstring(dbNameTable,"OBFL");	
				aStoreType.push([strID,Base.getLanguageTextOberflaeche(strID).strText]);			
				dbskip(dbNameTable);
			}
		}
		
		if(!Base.hasValueIntoArrayPositionNull(aStoreType,oDlgLagerSession.AuswahlRollenlager.strSelComboGroundLevel)) //notwendige Korrektur
			oDlgLagerSession.AuswahlRollenlager.strSelComboGroundLevel = aStoreType[0][0];
		
		return aStoreType;		
	};
	
	
	if(strTyp == "ROLLENLAGER_P" || strTyp == "ROLLENLAGER_S"){
		oRollenlager.store = {
			'Art' : _StoreLagerArt(oDlgLagerSession, strTyp)
		};
		
		oRollenlager.value = {
			'vArt' : oDlgLagerSession.AuswahlRollenlager.strSelComboTyp
		}
		
		oRollenlager.hide = {
			'hArt' 			: false,
			'hTyp'			: true,
			'hMaterial'		: true,
			'hOberflaeche'	: true
		}
	}
	else{
		oRollenlager.store = {};
		oRollenlager.value = {};
		oRollenlager.hide  = {};
		if(!strId){
			oRollenlager.store.Art 	= _StoreLagerArt(oDlgLagerSession, strTyp);
			oRollenlager.value.vArt = oDlgLagerSession.AuswahlRollenlager.strSelComboTyp;
		}	
		
		if(!strId || strId == 'LAGER_ROLLENLAGER_ART'){
			oRollenlager.store.Typ 	= _StoreTypData(oDlgLagerSession);
			oRollenlager.value.vTyp = oDlgLagerSession.AuswahlRollenlager.strSelComboType;
		}
		
		if(!strId || strId == 'LAGER_ROLLENLAGER_ART' || strId == 'LAGER_ROLLENLAGER_TYP'){
			oRollenlager.store.Material  = _StoreMaterialData(oRollenlager.value.vTyp,oDlgLagerSession);
			oRollenlager.value.vMaterial = oDlgLagerSession.AuswahlRollenlager.strSelComboMaterial;
		}
		
		if(!strId || strId == 'LAGER_ROLLENLAGER_ART' || strId == 'LAGER_ROLLENLAGER_TYP' || strId == 'LAGER_ROLLENLAGER_MATERIAL'){
			oRollenlager.store.Oberflaeche  = _StoreOberflacheData(oDlgLagerSession);
			oRollenlager.value.vOberflaeche = oDlgLagerSession.AuswahlRollenlager.strSelComboGroundLevel;
		}
			
		oRollenlager.hide = {
			'hArt' 			: false,
			'hTyp'			: false,
			'hMaterial'		: false,
			'hOberflaeche'	: (oRollenlager.store.Oberflaeche.length>0 ? false : true)
		}
		
		
		
	}
	
	return oRollenlager;
}