/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */
if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};
if ( typeof( Controller.Lager.Common.AuswahlRollenlager ) === 'undefined' )
	Controller.Lager.Common.AuswahlRollenlager = {};

/**
 * build GUI Data
 */
Controller.Lager.Common.AuswahlRollenlager.getFieldSetFunction = function(oDlgLagerSession,oData,strTypSys){
	var strTyp = oDlgLagerSession.AuswahlRollenlager.strDialogId;
	var oFunction = {};
		oFunction.value = {};
		oFunction.show 	= true;
		
	if(strTyp){
		var bDisableLose 		= false;
		var bDisableGefuehrt 	= false;
		
		if(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && (oDlgLagerSession.AuswahlRollenlager.strSelComboTyp === "DOPPELZYLINDER") && (strTyp == "ROLLENLAGER_S") ) {
			oData.bLose = false;
			oDlgLagerSession.AuswahlRollenlager.strSelRadioRollerBearing = 'GEFUEHRT';
		}
		
		if(strTyp == 'ROLLENLAGER_P' || strTyp == 'ROLLENLAGER_S'){
			var oTable = oDlgLagerSession.SollwerteHalterungspunkt.oTable;
			if(oTable.bewegung_minus.quer != 0)
				bDisableGefuehrt = true;
			
			if(oTable.bewegung_plus.quer != 0)
				bDisableGefuehrt = true;
			
			//if(oTable.einfuegepunkt.quer != 0)
			//	bDisableGefuehrt = true;
			/*	// Lasten sind hier nicht entscheidend - nur Bewegungen
			if(oTable.last_minus.quer != 0)
				bDisableGefuehrt = true;
			
			if(oTable.last_plus.quer != 0)
				bDisableGefuehrt = true;
			
			if(oTable.ueberlast.quer != 0)
				bDisableGefuehrt = true;
			
			if(oTable.zusatzlast.quer != 0)
				bDisableGefuehrt = true;
			*/
			if(bDisableGefuehrt){
				oData.bLose = true;
				oDlgLagerSession.AuswahlRollenlager.strSelRadioRollerBearing = 'LOSE';
			}
			
		}
		
		
		if(!oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDlgLagerSession.AuswahlSattel.bActuator){
			oData.bLose = true;
			oDlgLagerSession.AuswahlRollenlager.strSelRadioRollerBearing = 'LOSE';
			bDisableGefuehrt = true;
		}
		else if(oDlgLagerSession.AuswahlSattel.bUpliftRestraint && oDlgLagerSession.AuswahlSattel.bActuator){
			oData.bLose = false;
			oDlgLagerSession.AuswahlRollenlager.strSelRadioRollerBearing = 'GEFUEHRT';
			bDisableLose = true;
		}
	
		oFunction.value = {
			'vAbhebesicherung' 		: oDlgLagerSession.AuswahlRollenlager.bUpliftRestraint,
			'vRadioFk'				: oData.bLose ? 'LOSE' : 'GEFUEHRT',		//LOSE / GEFUEHRT
			'vRadioBf'				: oData.bKlemmbar ? 'KLEMMBAR' 	: 'SCHRAUBBAR', //KLEMMBAR / SCHRAUBBAR
			'Auflagendurchmesser' 	: oDlgLagerSession.AuswahlRollenlager.dSupportDiameter ? oDlgLagerSession.AuswahlRollenlager.dSupportDiameter : '',	
			'Fussbreite'			: oDlgLagerSession.AuswahlRollenlager.dFeetWide ? oDlgLagerSession.AuswahlRollenlager.dFeetWide : ''
		}
		
		if(oData.bLose && oDlgLagerSession.AuswahlRollenlager.strSelComboTyp === "ZYLINDER")
			oDlgLagerSession.AuswahlRollenlager.bUpliftRestraint = false;
		
		oFunction.disabled = {
			'Auflagendurchmesser'	: (oDlgLagerSession.AuswahlRollenlager.strSelComboTyp === "ZYLINDER" ? true : false),		
			'Fussbreite'		 	: (oDlgLagerSession.AuswahlRollenlager.strSelComboTyp === "ZYLINDER" ? false : true),
			'Lose'			 	 	: (((oDlgLagerSession.AuswahlSattel.bUpliftRestraint && (oDlgLagerSession.AuswahlRollenlager.strSelComboTyp === "DOPPELZYLINDER") && (strTyp == "ROLLENLAGER_S")) || bDisableLose ) ? true : false),
			'Gefuehrt'			 	: bDisableGefuehrt,
			'KLEMMBAR'				: oData.bDisableKlemmbar,
			'SCHRAUBBAR'			: false
		};
		
		oFunction.hide = {
			'Auflagendurchmesser' 	: false,		
			'Fussbreite'			: false
		};
		
		if(oDlgLagerSession.AuswahlRollenlager.strDialogId == "ROLLENLAGER_P"){
			//oFunction.hide.vAbhebesicherung		= (oDlgLagerSession.AuswahlRollenlager.strSelComboTyp === "ZYLINDER" ? (oData.bLose ? true : false) : true);
			oFunction.hide.vAbhebesicherung		= (oDlgLagerSession.AuswahlRollenlager.strSelComboTyp === "ZYLINDER" ? false : true);
			oFunction.value.vAbhebesicherung	= (oDlgLagerSession.AuswahlRollenlager.strSelComboTyp === "ZYLINDER" ? (oData.bLose ? false : true) : false);
			oFunction.disabled.vAbhebesicherung	= (oDlgLagerSession.AuswahlRollenlager.strSelComboTyp === "ZYLINDER" ? true : false);
		}
		else
			oFunction.hide.vAbhebesicherung = true;
	}
	else{
		oFunction.disabled 	= [['ABHEBESICHERUNG_OHNE',!oData.bOhne],['ABHEBESICHERUNG_MIT', !oData.bMit]];		
		var bIsKlemmsystem = (strTypSys == 'KLEMMSYSTEM');
		
		//if(bIsKlemmsystem && !oData.bOhne)
		if (bIsKlemmsystem && oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief
			&& oDlgLagerSession.AuswahlStandard.strSelRadioFunction != "GEFUEHRT_MEHRFACH")
			oDlgLagerSession.Klemmsystem.strSelRadioFixed = 'MIT';
		else if (!bIsKlemmsystem && !oData.bOhne)	
			oDlgLagerSession.AuswahlRollenlager.strSelRadioFixed = 'MIT';
		else if (left(oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager.TYP, 3) == "LKG")
			oDlgLagerSession.Klemmsystem.strSelRadioFixed = 'MIT';
		
		oFunction.value		= [(bIsKlemmsystem ? oDlgLagerSession.Klemmsystem.strSelRadioFixed : oDlgLagerSession.AuswahlRollenlager.strSelRadioFixed)];
		
		oFunction.hide = {
			'Auflagendurchmesser': true,		
			'Fussbreite'		 : true
		};
	}
	
	return oFunction;
}