/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */
if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};

/**
 * Aufruf aus IndexController.es
 * -------------------------------
 * -------- Schaltlogik ----------
 * -------------------------------
 * Wann kommt welcher Dialog ?
 * hierzu wird das Session Object bentigt, sowie den aktuellen Dialog
 * @version 1.4 - Update 21.11.2011 - Umbau Klemmsysteme (seperat)
 * <br> version 1.3 - Update 11.11.2011 - Rollenlager - neue Spezifikation vom 10.11.2011
 * <br> version 1.2 - new Zubehoer Auswahl Klemmsystem
 * <br> version 1.1 nderung an der Dialogfhrung
 * <br> version 1.0 Grundgerst
 * @param [strActivPanel] {String}
 */
Controller.Lager.Common.getNextClientPanel = function(oDlgLagerSession, strActivPanel, theMainController){
	//Hole Session Object
	var sollwerte_halterungspunkt = {
		'id': 'lager.sollwerte_halterungspunkt',
		'title': translate('SOLLWERTE_HALTERUNGSPUNKT')
	};
	
	var sollwerte_rohrumschliessendesteil = {
		'id': 'lager.sollwerte_rohrumschliessendesteil',
		'title': translate('SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL')
	};
	
	/**
	 * Abgedeckt werden die folgenden 4 Dialoge
	 * 1. 6.1 Lager gleitend 					(Lagerschlitten)
	 * 2. 6.2 Festpunkt / Stop, wrmegedmmt 	(Lager)
	 * 3. 6.3 Festpunkt / Stop, ungedmmt		(Lager)
	 * 4. 6.4 Festpunkt / Stop, vorisoliert		(Lager)
	 */
	var lager_auswahl_standard = {	
		'id': 'lager.auswahl_standard',
		'title': ''
	};
	
	/**
	 * Abgedeckt werden die folgenden 5 Dialoge
	 * 1. 6.6 Lagersystem
	 * 2. 7.1.2 Rollenlager - Wahl ber Parameter
	 * 3. 7.3.2 Rollenlager (allgemein)
	 * 4. 8.2 Klemmsystem Rollenlager
	 * 5. 8.4 Abhebesicherung fr Rollenlager und Sattel
	 */
	var lager_auswahl_rollen = {	
		'id': 'lager.auswahl_rollenlager',
		'title': ''
	};
	
	var lager_auswahl_sonder = {
		'id'	: 'lager.auswahl_standard_sonder',
		'title'	: translate("LAGER_SONDERABMESSUNGEN_LABEL")
	};
	
	/**
	 * Abgedeckt werden die folgenden 2 Dialoge
	 * 1. 7.2 Nur Sattel
	 * 2. 7.3 Rollelager Sattel
	 */
	var lager_auswahl_sattel = {
		'id': 'lager.auswahl_sattel',
		'title': translate("LAGER_AUSWAHL_SATTEL")
	};
	
	var lager_auswahl_rollen_direkt = {
		'id': 'lager.auswahl_rollenlager_direkt',
		'title': translate("LAGER_AUSWAHL_ROLLENLAGER_DIREKT")
	};
	
	var last_kette_uebersicht = {
		'id': 'uebersicht_lastkette',
		'title': translate('UEBERSICHT_LASTKETTE')
	};
		
	var last_kette_config = {
		id: 'systemcharakteristik',
		title: translate('SYSTEMCHARAKTERISTIK')
	}
		
	var lager_auswahl_klemmsystem = {
		'id': 'lager.auswahl_klemmsystem',
		'title': translate('IDC_AUSWAHL_KLEMMSYS_LABEL')
	};
	
	var lager_auswahl_zubehoer_ptfe = {
		'id': 'lager.auswahl_zubehoer_ptfe',
		'title': translate('LAGER_AUSWAHL_ZUBEHOER_PTFE')
	};
	
	var _findID = function(strId){
		var aPart 	= new Array();
		var bFound 	= false;
		for(var a=0;a<oDlgLagerSession.DialogHistoryIDs.length;a++){
			if(oDlgLagerSession.DialogHistoryIDs[a] == strId){
				bFound = true;
				break;
			}
			else
				aPart.push(oDlgLagerSession.DialogHistoryIDs[a]);
		}
		
		aPart.push(strId);
		oDlgLagerSession.DialogHistoryIDs = aPart;
	}
	
	var oNextPanel;
	if(strActivPanel != "lager.systemcharakteristik")
		_findID(strActivPanel);
	
	Lager.setDefaultData(oDlgLagerSession,strActivPanel);
	/**
	 * Update 11.11.2011 - Rollenlager - neue Spezifikation vom 10.11.2011
	 * systemcharakteristik -> sollwerte_halterungspunkt -> auswahl_rollenlager
	 */	
	switch(strActivPanel){
		case "lager.systemcharakteristik" : 				
				oDlgLagerSession.DialogHistoryIDs = new Array();
				oDlgLagerSession.DialogHistoryIDs[0] = "lager.systemcharakteristik";
				var strSelRadioLager = oDlgLagerSession.Systemcharakteristik.strSelRadioLager;
				switch(strSelRadioLager){
					case "LAGER_HS" :
							oNextPanel = last_kette_config;
						break;
					case "LAGER_ZUBEHOER"	:
							var strSelCombo = oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager;
							switch(strSelCombo){
								case "KG"		:
										oNextPanel = lager_auswahl_klemmsystem;
									break;
								case "KR"		:
										oNextPanel = lager_auswahl_rollen;
									break;								
								case "AfR"		:
										oNextPanel = lager_auswahl_rollen;
									break;	
								case "AzA" 		:
										oNextPanel = lager_auswahl_zubehoer_ptfe;
									break;
								case "G_PTFE"	:
										oNextPanel = lager_auswahl_zubehoer_ptfe;
									break;
							}
						break;
					case "LAGER_ROLL"	:
							if(oDlgLagerSession.Systemcharakteristik.bSel_krT)
								oNextPanel = lager_auswahl_rollen_direkt;
							else 
								oNextPanel = sollwerte_halterungspunkt;
						break;		
					default :
							oNextPanel = sollwerte_halterungspunkt;
						break;	
				}
				
			break;
		case "lager.sollwerte_halterungspunkt" :	// Update 11.11.2011	
				if(!oDlgLagerSession.Systemcharakteristik.bSel_krT && oDlgLagerSession.Systemcharakteristik.strSelRadioLager != "LAGER_ROLL")
					oNextPanel = sollwerte_rohrumschliessendesteil;
				else if(!oDlgLagerSession.Systemcharakteristik.bSel_krT && oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_ROLL")
					oNextPanel = lager_auswahl_rollen;	
				else{
					var strSelCombo = oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager;
					switch(strSelCombo){
						default :
								oNextPanel = lager_auswahl_standard;
							break;
					}
				}	
			break;

		case "lager.sollwerte_rohrumschliessendesteil" :  // Update 11.11.2011
				var strSelRadioLager = oDlgLagerSession.Systemcharakteristik.strSelRadioLager;
				if(strSelRadioLager == "LAGER_SAROLL" || strSelRadioLager == "LAGER_SYROLLSA")
					oNextPanel = lager_auswahl_sattel; 		//Kapitel 7.2	
				else {
					oNextPanel = lager_auswahl_standard;
					
					if (oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS")
						oNextPanel.title = translate("LAGER_AUSWAHL");
					else
						oNextPanel.title = translate("LAGER_AUSWAHL_LAGERSCHLITTEN");
				}
			break;	

		case "lager.auswahl_standard" :				
				if(oDlgLagerSession.AuswahlStandard.strSelComboAccessory == "KLEMMBAR")
					oNextPanel = lager_auswahl_klemmsystem;
				else
					oNextPanel = last_kette_uebersicht;
			break;
			
		case "lager.auswahl_rollenlager" :
				oNextPanel = last_kette_uebersicht; 						//Kapitel 6.6, 7.1.2, 7.3.2, 8.2, 8.4
			break;
			
		case "lager.auswahl_rollenlager_direkt"	:
				oNextPanel = last_kette_uebersicht; 						//Kapitel 7.1.1
			break;
		case "lager.auswahl_sattel"	:
				if(oDlgLagerSession.AuswahlSattel.strDialogId == "SATTEL") 	
					oNextPanel = last_kette_uebersicht;						//Kapitel 7.2
				else
					oNextPanel = lager_auswahl_rollen;						//Kapitel 7.3
			break;
		case "lager.auswahl_klemmsystem":	
		case "lager.auswahl_zubehoer_ptfe" :
				oNextPanel = last_kette_uebersicht;									//Kapitel 8.3
			break;
		default : 
				oNextPanel = '';
			break;
	}
	
	if(oNextPanel.id == 'uebersicht_lastkette'){
		//SessionObject --> STORE	
		oDlgLagerSession.bLastKetteDialog = true; 
		
		// Wenn Lastkette dann muss hier noch die Berechnung des Systemmasses durchgefhrt werden.
		// Die topologieKlasse hier ist entweder CaTopoHaengendEinfach (Doppelt wird auf Einfach gemappt) oder CaTopoStuetzend
		if(oDlgLagerSession.bLastKettePathSelection) {
			oNextPanel = theMainController.topologieKlasse.getNextPanel('neue_lagerauswahl_fertig');
		}
		theMainController.topologieKlasse.berechneSystemmassInitial();
	}
	
	return oNextPanel;
}	