﻿/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */

if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};
	
Controller.Lager.Common.getDataRohrumschliessendesTeil = function(oDlgLagerSession,strComponent){
	//Definition of Default Data
	var storeNennWeite 			= new Array();
	var storeAussendurchmesser 	= new Array();
	
	var _oMantelShow = function(oDlgLagerSession){
		if(caMainController.getLagerTopologieklasse().isGleitlager() || caMainController.getLagerTopologieklasse().isFestlager()){
			var sqlString = "SELECT * FROM AUSLEGUNG_GLEIT_FEST_LAGER WHERE LAGER_TYP ='"+oDlgLagerSession.Systemcharakteristik.strSelRadioLager+"'";
			var oResult 			= {};
			//interressiert nur der Manteldurchmesser
			sqlString += " AND VORISOLIERT = 'true' ";			
			sqlString = sqlString.replace("*","count(*) AS ANZAHL")
			
			var dbName				= 'LAGER2';
			var dbNameTable 		= "AUSLEGUNG_GLEIT_FEST_LAGER_MANTELDURCHMESSER";			
			var dTableDatenLength 	= dbselect( dbName, sqlString, dbNameTable );
			if ( dbselect( dbName, sqlString, dbNameTable ) > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){
					if((dbgetdouble(dbNameTable,"ANZAHL"))>0){
						oResult = {
							'bShow_Manteldurchmesser' : true
						};
					}				
					dbskip( dbNameTable );
				}
			}
			else{
				oResult = {
					'bShow_Manteldurchmesser' : true
				};
			}
		}
		else if(caMainController.getLagerTopologieklasse().isSattel()){
			oResult = {
				'bShow_Manteldurchmesser' : true
			};
		}
		
		return oResult;
	}
	
	// Achtung - Die Kombo ist unterschiedlich für die Gleitpaarungen bzw. Sattel
	// absoluten Maximalwert auslesen
	var sqlstring	= "SELECT * FROM NENNWEITEN_GRENZEN WHERE TYP = 'ALLGEMEIN'";
	var numret		= dbselect("LAGER2", sqlstring, "ALLGEMEIN");
	var DN_MAX		= dbgetstring("ALLGEMEIN", "DN_MAX")*1;
	// prüfen ob es eine ander Grenze gibt
	var ExpertMode	= getint("EXPERT_MODE", "RIGHTS");
	// für den Expert-Mode lassen wir alle zu
	if (!ExpertMode){
		sqlstring	= "SELECT * FROM NENNWEITEN_GRENZEN WHERE TYP = '"+oDlgLagerSession.Systemcharakteristik.strSelRadioLager+"' ";
		if (dbselect("LAGER2", sqlstring, "DN_MAX"))
			DN_MAX	= dbgetstring ("DN_MAX", "DN_MAX")*1;
	}
	
	var sqlstring 	= "SELECT * FROM NENNWEITEN WHERE abs(DN) <= abs('"+DN_MAX+"') ";
	
	if (oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != 'STD'
		&& !oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder){
		var strDM = oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo*1;
		sqlstring += " AND abs(D) < abs('"+strDM+"')";
	}
	else if (oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder){
		var strDM = oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder;
		//sqlstring += " WHERE D > abs('"+strDN+"')";
		sqlstring += " AND abs(D) < abs('"+strDM+"')";
	}
	
	var dbName		= 'LAGER2';
	var dbNameTable = "BuildComboS";
	
	numret	= dbselect( dbName, sqlstring, dbNameTable );
	
	if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			var aDBData = new Array();
			var strDN = dbgetstring(dbNameTable,"DN");
			var strD  = dbgetstring(dbNameTable,"D");
			storeNennWeite.push([strDN,strDN]);
			storeAussendurchmesser.push([strD,strD]);
			dbskip( dbNameTable );
		}
	}
	
	var strNennWeiteSelection			= oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo;
	var strAussendurchmesserSelection 	= (oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder ? oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder : oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo);
	
	var storeManteldurchmesser	= new Array();
	
	// Achtung - Die Kombo ist unterschiedlich für Gleitlager bzw. Sattel
	// standard Minimalwert auslesen
	var sqlstring	= "SELECT * FROM MANTELDMR_GRENZEN WHERE TYP = 'ALLGEMEIN'";
	var numret		= dbselect("LAGER2", sqlstring, "ALLGEMEIN");
	var DM_MIN		= dbgetstring("ALLGEMEIN", "DM_MIN")*1;
	// prüfen ob es einen anderen Min-Wert gibt
	sqlstring	= "SELECT * FROM MANTELDMR_GRENZEN WHERE TYP = '"+oDlgLagerSession.Systemcharakteristik.strSelRadioLager+"' ";
	if (dbselect("LAGER2", sqlstring, "DM_MIN"))
		DM_MIN	= dbgetstring ("DM_MIN", "DM_MIN")*1;
	
	sqlstring 	= "SELECT * FROM MANTELDMR WHERE abs(DM) > abs("+strAussendurchmesserSelection+") AND abs(DM) >= abs("+DM_MIN+") ";
	var dbName		= 'LAGER2';
	var dbNameTable = 'BuildMANTELDMR';
	
	if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
		while ( dbiseof( dbNameTable) == 0 ){
			var strDM = dbgetstring(dbNameTable,"DM");
			storeManteldurchmesser.push([strDM,strDM]);
				
			dbskip( dbNameTable );
		}
	}
	
	storeManteldurchmesser.push([ 'STD', " - "]);
	var bSel = Base.isCovered(storeManteldurchmesser,oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo,0);	
	if(!bSel)
		oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo = 'STD';
	
	var strManteldurchmesserSelection	= oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo;
	
	
	//Temperatur
	var dTemperaturMedium 				= oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium;
	var bTemperaturMediumDisabled 		= false;
	
	if(!strComponent || strComponent == 'LAGER_IDC_TEMPERATUR_MEDIUM'){
		var oMaterial = Lager.RohrumschliessendesTeil.getBasicMaterial(dTemperaturMedium);
		
		oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff = "LAGER_"+oMaterial.strSelWerkstoff;
		
		//Werkstoff Schelle/Lager
		var strRadioSelection					= oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff;
		var bRadioDisabled_S235_JRG2			= true;	
		var bRadioDisabled_10CrMo9_10			= true;
		var bRadioDisabled_X10CrMoVNb9_1		= true;
		var bRadioDisabled_16Mo3				= true;
		var bRadioDisabled_X6CrNiTi18_10		= true;
		var bRadioDisabled_X5CrAITi31_20		= true;
		var bRadioDisabled_13CrMo4_5			= true;
		var bRadioDisabled_X6CrNiMoTi17_12_2	= true;
		var bRadioDisabled_X8CrNiTi18_10		= true;
		var bRadioDisabled_X5CrNi18_10			= true;
		
		var _isAccept = function(dWerkstoffNumber){
			var strRadioSel = oDlgLagerSession.Systemcharakteristik.strSelRadioLager;
			if(strRadioSel == 'LAGER_SAROLL')
				strRadioSel = 'LAGER_SYROLLSA';
				
			var strSql = "SELECT count(*) AS ANZAHL FROM 'WERKSTOFF_KOMBI' WHERE LAGER_KOMBI = '"+strRadioSel+"' AND WERKSTOFF = '"+dWerkstoffNumber+"' ";
			var dbName 		= 'LAGER2';
			var dbNameTable = "ROHRUMSCHLIESSENDESTEIL_DATA";
			var bShow 		= true;
			if ( dbselect( dbName, strSql, dbNameTable ) > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){
					bShow = dbgetdouble(dbNameTable,"ANZAHL") > 0 ? true : false;
						
					dbskip( dbNameTable );
				}
			}
			return bShow;
		}
		
		for(var a=0;a<oMaterial.aBaseMaterial.length;a++){
			var aPart = oMaterial.aBaseMaterial[a];	
			switch(aPart.MATID){
				case "W_RST" :
						bRadioDisabled_S235_JRG2 			= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));							
					break;
				case "W_15MO3" :
						bRadioDisabled_16Mo3 				= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));
					break;
				case "W_13CRMO" :
						bRadioDisabled_13CrMo4_5 			= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));
					break;
				case "W_10CRMO" :
						bRadioDisabled_10CrMo9_10 			= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));
					break;
				case "W_4541" :
						bRadioDisabled_X6CrNiTi18_10 		= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));
					break;
				case "W_4571" :
						bRadioDisabled_X6CrNiMoTi17_12_2	= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));
					break;
				case "W_P91" :
						bRadioDisabled_X10CrMoVNb9_1		= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));
					break;	
				case "W_INCOLOY" :
						bRadioDisabled_X5CrAITi31_20		= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));
					break;
				case "W_4878" :
						bRadioDisabled_X8CrNiTi18_10 		= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));
					break;
				case "W_4301" :
						bRadioDisabled_X5CrNi18_10	 		= !_isAccept(Produkt.getWerkstoffeNumber(aPart.MATID));
					break;
			}
		}
	}
	
	//Mantel Sonder
	var strMantelSonderNumb				= oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder;	
	var bMantelSonderCheck				= oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder;
		
	//Aussen Sonder
	var strSonderNumb	= oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder;	
	var bSonderCheck	= oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder;
	var bSonderDisabled	= !oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder;
	var combodis		= [['LAGER_IDC_NENNWEITE',oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder],['LAGER_IDC_AUSSENDURCHMESSER',oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder]];
	//var bSonderDisabled					= false;
	
	if(storeAussendurchmesser.length==1){
		bSonderCheck					= true;
		strSonderNumb					= bMantelSonderCheck ? strMantelSonderNumb : strManteldurchmesserSelection;
		strAussendurchmesserSelection 	= 'STD';
		
		oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder 		= bSonderCheck;
		oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder 		= strSonderNumb;	
		oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo 	= strAussendurchmesserSelection;
	}
	
	
	//Umgebungstemperatur
	var bUmgebungstemperatur			= true;
	var bUmgebungstemperaturDisabled	= true;
	
	//Daemmdicke
	var strDaemmdicke					= (oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke == 0) ? '' : oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke;
	var bDaemmdickeDisabled				= ((strManteldurchmesserSelection !== 'STD') || bMantelSonderCheck) ? true : false;
		
	//Schelleneinlage
	var strSchelleneinlage				= (oDlgLagerSession.SollwerteRohrUmTeil.dSchelleneinlage == 0) ? '' : oDlgLagerSession.SollwerteRohrUmTeil.dSchelleneinlage;
	var bSchelleneinlageDisabled		= false;
		
		
	///Objecte zusammenstellen für Initialiserung
	/// Es ist nicht notwendig immer alle Daten an den Client zusenden, 
	/// es reicht aus wenn das Änderungsobject geschickt wird
	/// bsp. umgebungstemperatur = {'disable' : true}
	/// oder combo = {'Nennweite' : {'selected' 	: strNennWeiteSelection}}
	/// ....
	var oTemperatur = {
		'disable': {
			'Medium' 	: bTemperaturMediumDisabled
		},
		'value' : {
			'Medium' 	: dTemperaturMedium
		}
	};
	
	var oUmgebungstemperatur = {
		'disable' 	: { 'CheckBox' : bUmgebungstemperaturDisabled },
		'value'		: { 'CheckBox' : bUmgebungstemperatur }
	};
	
	var oWerkstoff	= {
		'disable'	: [
			['LAGER_W_RST'				, bRadioDisabled_S235_JRG2],
			['LAGER_W_10CRMO'			, bRadioDisabled_10CrMo9_10],
			['LAGER_W_P91'				, bRadioDisabled_X10CrMoVNb9_1],
			['LAGER_W_15MO3'			, bRadioDisabled_16Mo3],
			['LAGER_W_4541'				, bRadioDisabled_X6CrNiTi18_10],
			['LAGER_W_INCOLOY'			, bRadioDisabled_X5CrAITi31_20],
			['LAGER_W_13CRMO'			, bRadioDisabled_13CrMo4_5],
			['LAGER_W_4571'				, bRadioDisabled_X6CrNiMoTi17_12_2],
			['LAGER_W_4878'				, bRadioDisabled_X8CrNiTi18_10],
			['LAGER_W_4301'				, bRadioDisabled_X5CrNi18_10]
		],
		'selected'	: 	strRadioSelection	
	};
	
	var oCombo = {};
	
	if(!strComponent){
		oCombo.Nennweite = {
			'store' 	: storeNennWeite,
			'selected' 	: strNennWeiteSelection
		}; 
	}
	
	if(!strComponent || strComponent === 'LAGER_IDC_MANTELDURCHMESSER' || strComponent === 'LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD'){
		oCombo.Aussendurchmesser = {
			'store' 	: storeAussendurchmesser,
			'selected' 	: strAussendurchmesserSelection
		};
	}
		
	var oSchelleneinlage = {
		'disable' : {'schelleneinlage' : bSchelleneinlageDisabled},
		'value'	  : {'schelleneinlage' : strSchelleneinlage }
	};
	
	var oDaemmdicke = {
		'disable' : {'daemmdicke' : bDaemmdickeDisabled},
		'value'	  : {'daemmdicke' : strDaemmdicke }
	};
	
	var oSonder		= {
		'disable'  : {'sonder' : bSonderDisabled},
		//'value'	   : {'sonder' : strSonderNumb },
		//'disable'  : bSonderDisabled,
		'value'	   : strSonderNumb,
		'selected' : bSonderCheck,
		'combodis' : combodis 
	};
	
	var oSpecialStandardDIA	= {
			'specDiaSel'		:	false,
			'standDiaChosen'	:	false
		};
	if (strComponent){
		//var oCombo = {};
		oCombo.Aussendurchmesser = {
			'selected' 	: oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo
		};
		oCombo.Nennweite = {
			'selected' 	: oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo
		};
	}
	/*
	if (((strComponent == 'LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD' || strComponent == 'LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX') && oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder)
			|| (strComponent == 'LAGER_IDC_SCHELLENEINLAGE' && oDlgLagerSession.SollwerteRohrUmTeil.dSchelleneinlage*1 != 0)){
	*/
	if (oDlgLagerSession.SollwerteRohrUmTeil.bMessage){
		var isDN_Info	= Base.CheckDiameter(strAussendurchmesserSelection*1);
		if (isDN_Info.isDN){
			oSpecialStandardDIA	= {
				'specDiaSel'		:	true,
				'standDiaChosen'	:	true
			};
			/*
			oCombo.Nennweite = {
				'selected' 	: isDN_Info.DN_norm;
			};
			oCombo.Aussendurchmesser = {
				'selected' 	: isDN_Info.dA_norm;
			};
			*/
			oCombo.Nennweite.selected			= isDN_Info.DN_norm;
			oCombo.Aussendurchmesser.selected	= isDN_Info.dA_norm;
		}
	}
	
	var oMantel = {};
	if(!strComponent || strComponent === 'LAGER_IDC_NENNWEITE' || strComponent === 'LAGER_IDC_AUSSENDURCHMESSER' 
		|| strComponent === 'LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD' || strComponent === 'LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX')
	{
		oMantel.store 		= storeManteldurchmesser;
		if (bMantelSonderCheck){
			if ((bSonderCheck && strSonderNumb*1 >= strMantelSonderNumb*1) || (!bSonderCheck && strAussendurchmesserSelection*1 >= strMantelSonderNumb*1))
				bMantelSonderCheck	= false;
		}
	}
		
	if(!strComponent || strComponent === 'LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD' || strComponent === 'LAGER_IDC_AUSSENDURCHMESSER' || strComponent === 'LAGER_IDC_NENNWEITE')
		oMantel.selc  		= strManteldurchmesserSelection;
		
	//if(!strComponent || strComponent === 'LAGER_IDC_MANTELDURCHMESSER' || 
	//	strComponent === 'LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD' || 
	//	strComponent === 'LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX'){		
		oMantel.checkbox 	= bMantelSonderCheck;
		if(bMantelSonderCheck)
			oMantel.value = strMantelSonderNumb;
		else
			oMantel.value = "20";
	//}
	
	var oExistMantel 	= _oMantelShow(oDlgLagerSession);
	var bMantelShow 	= oExistMantel.bShow_Manteldurchmesser;
	
	oMantel.show 		= bMantelShow ? ((bDaemmdickeDisabled || !strDaemmdicke) ? true : false) : false;	

	// Sonder Checkboxen werden an Rechte gebunden
	// -Schu 130314- -> diese sind für alle zulässig!
	var oRechte = {};
	/*if(!Base.Store.isSalesVersion()){
		oRechte.disable = [
			['LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD',true],
			['LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX',true],
			['LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX',true],
			['LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD',true]
		]; 
	}
	else{*/
		oRechte.disable = [
			['LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD',(bMantelSonderCheck ? false : true)],
			//['LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX',(bMantelSonderCheck ? false : true)],
			['LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX',false],
			//['LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX',(bSonderCheck ? false : true)],
			['LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX',false],
			['LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD',(bSonderCheck ? false : true)],
			['LAGER_IDC_MANTELDURCHMESSER', (bMantelSonderCheck ? true : false)]
		];
	//}
	
	if(!strComponent){
		return ({
			'oSonder' 				: oSonder, 
			'oDaemmdicke' 			: oDaemmdicke, 
			'oSchelleneinlage'		: oSchelleneinlage,
			'oCombo' 				: oCombo, 
			'oWerkstoff'  			: oWerkstoff,
			'oUmgebungstemperatur' 	: oUmgebungstemperatur,
			'oTemperatur'			: oTemperatur,
			'oMantel'				: oMantel,
			'oSpecialStandardDIA'	: oSpecialStandardDIA,
			'oRechte'				: oRechte
		});	
	}
	else if(strComponent === 'LAGER_IDC_NENNWEITE' || strComponent === 'LAGER_IDC_AUSSENDURCHMESSER'){
		var oCombo = {};
		if(strComponent === 'LAGER_IDC_NENNWEITE'){
			oCombo.Aussendurchmesser = {
				'selected' 	: oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo
			};
		}
		
		if(strComponent === 'LAGER_IDC_AUSSENDURCHMESSER'){
			oCombo.Nennweite = {
				'selected' 	: oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo
			};
		}
		
		return ({
			'oCombo' 				: oCombo,
			'oMantel'				: oMantel,
			'oSpecialStandardDIA'	: oSpecialStandardDIA,
			'oRechte'   			: oRechte
		});
	}
	else{
		switch(strComponent){
			case 'LAGER_IDC_TEMPERATUR_MEDIUM' :
					return ({
						'oWerkstoff'  			: oWerkstoff,
						'oSpecialStandardDIA'	: oSpecialStandardDIA,
						'oRechte'   			: oRechte
					});
				break;
			case 'LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX'	:
			case 'LAGER_IDC_DAEMMDICKE' :
					return ({
						'oCombo' 				: oCombo,
						'oMantel'				: oMantel,
						'oDaemmdicke'			: oDaemmdicke,
						'oSpecialStandardDIA'	: oSpecialStandardDIA,
						'oRechte'   			: oRechte
					});
				break;	
			case 'LAGER_IDC_MANTELDURCHMESSER' :
					return ({
						'oCombo' 				: oCombo,
						'oDaemmdicke'			: oDaemmdicke,
						'oMantel'				: oMantel,
						'oSonder'				: oSonder,
						'oSpecialStandardDIA'	: oSpecialStandardDIA,
						'oRechte'   			: oRechte
					});
				break;
			case 'LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD' :
					return ({
						'oDaemmdicke'			: oDaemmdicke,
						'oCombo' 				: oCombo,
						'oMantel'				: oMantel,
						'oSonder'				: oSonder,
						'oSpecialStandardDIA'	: oSpecialStandardDIA,
						'oRechte'   			: oRechte
					});
				break;
			case 'LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX'	:
			case 'LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD' :
			case 'LAGER_IDC_SCHELLENEINLAGE' :
					return ({
						'oCombo' 				: oCombo,
						'oSonder' 				: oSonder,
						'oMantel'				: oMantel,
						'oSpecialStandardDIA'	: oSpecialStandardDIA,
						'oRechte'  				: oRechte
					});
				break;
		}
	}
}	