/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */

if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};

/**
 * 4 Dialog werden abgedeckt mit einer Maske
 * @param [oDlgLagerSession] {Object} Session Object
 * @param [strVersion] {String} "LAGERSCHLITTEN" / "FESTPUNKT_STOP_W" / "FESTPUNKT_STOP_U" / "FESTPUNKT_STOP_V"
 */	
Controller.Lager.Common.getDataAuswahlStandard = function(oDlgLagerSession,strVersion,strEvent){
	var oResult 						= {};
		oResult.fieldset 				= {};
		oResult.fieldset.lager_function = {};
		oResult.fieldset.lager_merkmale = {};
		oResult.fieldset.lager_bb 		= {};
		oResult.fieldset.lager_traeger 	= {};
		oResult.fieldset.lager_tatsaechlichemass = {};
		oResult.fieldset.lager_sonderabmessungen = {};
	
	var strCDVersion 	= Base.Store.getCDMode();	
	var dbName			= 'LAGER2';
	var sqlString 		= "SELECT * FROM AUSLEGUNG_GLEIT_FEST_LAGER WHERE LAGER_TYP ='"+oDlgLagerSession.Systemcharakteristik.strSelRadioLager+"'";
		sqlString 		+= (caMainController.getLagerTopologieklasse().getIsolierung() == 'ID_VORISOLIERT') ? " AND VORISOLIERT = 'true' " : " AND VORISOLIERT = 'false'" ;
	
	/**
	 * @private function fr Funktions Fieldset
	 */	 
	var _getDefaultDataFunction = function(oDlgLagerSession){
		var oResult ={};
		if(caMainController.getLagerTopologieklasse().isGleitlager() || caMainController.getLagerTopologieklasse().isFestlager()){
			var sqlPartString	= sqlString+" GROUP BY (LAGERART) ";
			var dbNameTable 	= "AUSLEGUNG_GLEIT_FEST_LAGER_FUNCT";
			
			if ( dbselect( dbName, sqlPartString, dbNameTable ) > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){
					if(dbgetstring(dbNameTable,"LAGERART") === 'LOSLAGER')
						oResult.bLoslager = true;
						
					if(dbgetstring(dbNameTable,"LAGERART") === 'FUEHRUNGSLAGER')
						oResult.bFuehrungslager = true;	
						
					if(rfind(dbgetstring(dbNameTable,"LAGERART"),'FUEHRUNG_')>0 && !oResult.bFuehrungMehrfach)
						oResult.bFuehrungMehrfach = true;
					
					dbskip( dbNameTable );
				}
			}
		}
		
		return oResult;
	}
	/**
	 * @private function fr Merkmale Fieldset
	 */	 
	var _getDefaultDataMerkmale = function(oDlgLagerSession,strEvent){
		var oResult ={};
		if(caMainController.getLagerTopologieklasse().isGleitlager() || caMainController.getLagerTopologieklasse().isFestlager()){
			var sqlPartString	= sqlString;
			
			if(caMainController.getLagerTopologieklasse().isGleitlager()){
				switch(oDlgLagerSession.AuswahlStandard.strSelRadioFunction){
					case "LOSE" :
							sqlPartString += " AND LAGERART like 'LOSLAGER' ";
						break;	
					case "GEFUEHRT"	:
							sqlPartString += " AND LAGERART like 'FUEHRUNGSLAGER' ";
						break;
					case "GEFUEHRT_MEHRFACH" :
							sqlPartString += " AND LAGERART like '"+oDlgLagerSession.AuswahlStandard.strSelComboFunction+"' ";
						break;	
				}
			}
			else if(caMainController.getLagerTopologieklasse().isFestlager()){
				sqlPartString += " AND LAGERART like '-'  ";
			}
			
			if(strEvent == 'MERKMALE'){
				sqlPartString +=" AND GLEITUNTERLAGE ='"+(oDlgLagerSession.AuswahlStandard.bGaT ? 'true' : 'false')+"' ";
				sqlPartString +=" AND HOEHENVERSTELLBAR ='"+(oDlgLagerSession.AuswahlStandard.bHoehenverstellbar ? 'true' : 'false')+"' ";
			}
			
			// @@@ LGE Test
			//if (oDlgLagerSession.AuswahlStandard.strSelComboAccessory == "KLEMMBAR")
			//	&& oDlgLagerSession.AuswahlStandard.strSelRadioFunction != "LOSE")
			//{
			//	sqlPartString += " AND KLEMMSYSTEM <> '-' ";
			//}
			
			var dbNameTable 		= "AUSLEGUNG_GLEIT_FEST_LAGER_AUSWAHL";
			var oResult 			= {};
			var aAccessory			= new Array();
			var aGleitelem			= new Array();
			var bAbhebeSich			= false;
			var bGleitelem			= false;
			var bKlemmsyst			= false;
			// @@@ LGE TEST
			var bLoslager			= false;
			var bLGE				= false;
			var bLGA				= false;
			var bLGV				= false;
			var strGleitunterlage	= '';
			var strHoehenverstell	= '';
			
			var dTableDatenLength 	= dbselect( dbName, sqlPartString, dbNameTable );
			if ( dTableDatenLength > 0 ){
				while ( dbiseof( dbNameTable) == 0 ){
					var strAbhebeSich   = dbgetstring(dbNameTable,"ABHEBESICHERUNG");
					var strGleitele		= dbgetstring(dbNameTable,"GLEITELEMENT");
					
					// @@@ LGE TEST
					var strLagerreihe	= dbgetstring(dbNameTable,"LAGERREIHE");
					
					if (oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium * 1 > 450) // KSY nur bis 450C zulssig
						var strKlemmsys	= '-';
					else
						var strKlemmsys	= dbgetstring(dbNameTable,"KLEMMSYSTEM");
					
					if(strAbhebeSich!='-' &&  strAbhebeSich!='' && !bAbhebeSich){
						aAccessory.push(["ABHEBESICHERUNG",translate("IDC_ABHEBESICHERUNG_LABEL")]);
						//ERWEITERUNG -- 02.02.2012
						aAccessory.push(["ABHEBESICHERUNG_4",translate("IDC_ABHEBESICHERUNG_4_LABEL")]);
						bAbhebeSich = true;
					}
					
					/*
					// @@@ LGE TEST
					if(strGleitele!='-' && strGleitele!='' && strGleitele != 'OHNE' && !bGleitelem){
						aAccessory.push(["GLEITELEMENT",translate("IDC_GLEITELEMENT_LABEL")]);
						bGleitelem = true;
					}
					*/
					
					// @@@ LGE TEST
					if (oDlgLagerSession.AuswahlStandard.strSelRadioFunction == "LOSE"
						&& left(strLagerreihe, 2) == "LX" && !bLoslager){
						aAccessory.push(["OHNE",translate("ID_OHNE")]);
						bLoslager = true;
					}
					
					if((strKlemmsys!='-' && strKlemmsys!='' && strKlemmsys!='false') && !bKlemmsyst){
						aAccessory.push(["KLEMMBAR",translate("LABEL_ANSCHLUSSART_klemmbar")]);
						bKlemmsyst = true;
						//if(strEvent == 'MERKMALE')
						//	oDlgLagerSession.AuswahlStandard.strSelComboAccessory = "KLEMMBAR";
					}
					
					// @@@ LGE TEST
					// hier gibt es mehr Zeilen - Abfangen sonst Mehrfachnennung im Dropdown
					if( ((strGleitele == 'OHNE') && oDlgLagerSession.bLastKettePathSelection) || !oDlgLagerSession.bLastKettePathSelection){
						if (oDlgLagerSession.AuswahlStandard.strSelRadioFunction == "GEFUEHRT"
							|| (oDlgLagerSession.AuswahlStandard.strSelRadioFunction == "LOSE" && oDlgLagerSession.AuswahlStandard.strSelComboAccessory == "KLEMMBAR")){
						// hier kein LGA und kein LGV zulassen
							bLGA	= true;
							bLGV	= true;
						}
						if (strGleitele!='-' && strGleitele!=''){
							if ((strGleitele == "LGE" && !bLGE) || (strGleitele == "LGA" && !bLGA)
								|| (strGleitele == "LGV" && !bLGV) || (strGleitele == 'OHNE'))
							{
								aGleitelem.push([strGleitele,translate("ID_"+strGleitele)]);
							}
							if (strGleitele == "LGE")
								bLGE	= true;
							else if (strGleitele == "LGA")
								bLGA	= true;
							else if (strGleitele == "LGV")
								bLGV	= true;
						}
					}
					
					var strTet = dbgetstring(dbNameTable,"GLEITUNTERLAGE");
					
					if(rfind(strGleitunterlage,dbgetstring(dbNameTable,"GLEITUNTERLAGE"))<0)
						strGleitunterlage += !strGleitunterlage ?  dbgetstring(dbNameTable,"GLEITUNTERLAGE") : ','+dbgetstring(dbNameTable,"GLEITUNTERLAGE");
					
					if(rfind(strHoehenverstell,dbgetstring(dbNameTable,"HOEHENVERSTELLBAR"))<0)
						strHoehenverstell += !strHoehenverstell ?  dbgetstring(dbNameTable,"HOEHENVERSTELLBAR") : ','+dbgetstring(dbNameTable,"HOEHENVERSTELLBAR");
					
					dbskip( dbNameTable );
				}
			}
			
			oResult.oCombo 			= {};
			oResult.oCombo.oShow 	= {};
			oResult.oCombo.oValue	= {};
			oResult.oCheckBox			= {};
			oResult.oCheckBox.oDisable 	= {};
			
			if(!Base.hasValueIntoArrayPositionNull(aAccessory,oDlgLagerSession.AuswahlStandard.strSelComboAccessory)){
				if(aAccessory.length == 0)
					oDlgLagerSession.AuswahlStandard.strSelComboAccessory = '-';
				else
					oDlgLagerSession.AuswahlStandard.strSelComboAccessory = aAccessory[0][0];
			}
			
			if(!Base.hasValueIntoArrayPositionNull(aGleitelem,oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart)){
				if(aGleitelem.length == 0)
					oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart = '-';
				else
					oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart = aGleitelem[0][0];
			}
			
			if(oDlgLagerSession.AuswahlStandard.strSelComboAccessory == '-')
				oResult.oCombo.oShow.bAccessory = false;
			else
				oResult.oCombo.oShow.bAccessory = true;
				
			if(!oResult.oCombo.oShow.bAccessory){
				oResult.oCombo.oShow.bKlemmsyst = false;
				oResult.oCombo.oShow.bGleitelem = false;
			}	
			
			if(aGleitelem.length>0)
				oResult.oCombo.oValue.aGleitelem = aGleitelem;
			
			
			if((rfind(strHoehenverstell,'true')>0) && (rfind(strHoehenverstell,'false')>0) || (strEvent === 'MERKMALE'))
				oResult.oCheckBox.oDisable.Hoehenverstellbar = false;
			else
				oResult.oCheckBox.oDisable.Hoehenverstellbar = true;
				
			if((rfind(strGleitunterlage,'true')>0) && (rfind(strGleitunterlage,'false')>0) || (strEvent === 'MERKMALE') )
				oResult.oCheckBox.oDisable.Gleitunterlage = (strGleitunterlage == 'false' ? true : false);
			else
				oResult.oCheckBox.oDisable.Gleitunterlage = true;
			
			if((strEvent !== 'MERKMALE')){
				if((rfind(strHoehenverstell,'true')>0) && !(rfind(strHoehenverstell,'false')>0))
					oDlgLagerSession.AuswahlStandard.bHoehenverstellbar	 = true;
				else
					oDlgLagerSession.AuswahlStandard.bHoehenverstellbar	 = false;
					
				if((rfind(strGleitunterlage,'true')>0) && !(rfind(strGleitunterlage,'false')>0))
					oDlgLagerSession.AuswahlStandard.bGaT = true;
				else
					oDlgLagerSession.AuswahlStandard.bGaT = false;
			}
			
			if(aAccessory.length>0){
				//Test Klemmsystem
				var sqlTestKlemmsystem =  sqlPartString;
				var dbNameTable1 = "AUSLEGUNG_GLEIT_FEST_LAGER_AUSWAHL_TEST";
				
				if(strEvent !== 'MERKMALE'){
					sqlTestKlemmsystem += " AND GLEITUNTERLAGE ='"+oDlgLagerSession.AuswahlStandard.bGaT+"' ";
					sqlTestKlemmsystem += " AND HOEHENVERSTELLBAR ='"+oDlgLagerSession.AuswahlStandard.bHoehenverstellbar+"' ";
					var dbNameTable1 	= "AUSLEGUNG_GLEIT_FEST_LAGER_AUSWAHL_TEST";
				}
				
				var dTableDatenLength = dbselect( dbName, sqlTestKlemmsystem, dbNameTable1 );
				if ( dTableDatenLength > 0 ){
					while ( dbiseof( dbNameTable1) == 0 ){
						if(dbgetstring(dbNameTable1,"KLEMMSYSTEM") == '' || dbgetstring(dbNameTable1,"KLEMMSYSTEM") == 'false' || dbgetstring(dbNameTable1,"KLEMMSYSTEM") == '-'){
							if(dbgetstring(dbNameTable1,"ABHEBESICHERUNG") == '' || dbgetstring(dbNameTable1,"ABHEBESICHERUNG") == 'false' || dbgetstring(dbNameTable1,"ABHEBESICHERUNG") == '-'){
								if(dbgetstring(dbNameTable1,"GLEITELEMENT") === '' || dbgetstring(dbNameTable1,"GLEITELEMENT") === '-'){
									//oDlgLagerSession.AuswahlStandard.strSelComboAccessory = '-';
									aAccessory = [['-','-']];
								}
							}
							//else if( dTableDatenLength > 1 )
							//	oDlgLagerSession.AuswahlStandard.strSelComboAccessory = aAccessory[0][0];
							//else
							//	oDlgLagerSession.AuswahlStandard.strSelComboAccessory = "ABHEBESICHERUNG";
								
						}
						//else{
							/*if(!Base.hasValueIntoArrayPositionNull(aAccessory,oDlgLagerSession.AuswahlStandard.strSelComboAccessory)){
								oDlgLagerSession.AuswahlStandard.strSelComboAccessory = "KLEMMBAR";
								oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart = "-";
							}*/
						//}
						dbskip( dbNameTable1 );
					}
					
					if(!Base.hasValueIntoArrayPositionNull(aAccessory,oDlgLagerSession.AuswahlStandard.strSelComboAccessory)){
						oDlgLagerSession.AuswahlStandard.strSelComboAccessory = aAccessory[0][0];
						oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart = "-";
					}
				}
				else
					oDlgLagerSession.AuswahlStandard.strSelComboAccessory = '-';
				
				if(oDlgLagerSession.AuswahlStandard.strSelComboAccessory == '-')
					oDlgLagerSession.AuswahlStandard.strSelComboAccessory = aAccessory[0][0];
					
				oResult.oCombo.oValue.aAccessory = aAccessory;
				
			}
			else
				oDlgLagerSession.AuswahlStandard.strSelComboAccessory = '-';	
		}
		
		return oResult;
	}
	
	/**
	 * @private function fr Fieldset Befestigung
	 */
	var _getDefaultDataFixed = function(oDlgLagerSession,strEvent){
		var oResult	= {};
		var strSqlFixed = sqlString;
			strSqlFixed += " AND HOEHENVERSTELLBAR = '"+oDlgLagerSession.AuswahlStandard.bHoehenverstellbar+"'";
		
		var dbNameTable = "AUSLEGUNG_GLEIT_FEST_LAGER_BEFESTIGUNG";
		var dTableDatenLength 	= dbselect( dbName, strSqlFixed, dbNameTable );
		if ( dTableDatenLength > 0 ){
			while ( dbiseof( dbNameTable) == 0 ){
				if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_EINFACH")))
					oResult.bSchraubbarEinfach = true;
				if(Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_DOPPELT")))
					oResult.bSchraubbarDoppelt = true;
				
				if(!Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_EINFACH")) && !Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR_DOPPELT")))
					oResult.bKlemmbar = true;
					
				dbskip(dbNameTable);
			}
		}
		
		if(!oDlgLagerSession.bLastKetteDialog){
			if(oResult.bKlemmbar && !strEvent)
				oDlgLagerSession.AuswahlStandard.strSelRadioFixed = "KLEMMBAR";
			else if(!strEvent)
				oDlgLagerSession.AuswahlStandard.strSelRadioFixed = "SCHRAUBBAR";
		}
		
		if(oResult.bSchraubbarEinfach && oResult.bSchraubbarDoppelt && oResult.bKlemmbar)
			oResult.strShow = 'ALL';
		else if(!oResult.bSchraubbarEinfach && oResult.bSchraubbarDoppelt && oResult.bKlemmbar){
			oResult.strShow = 'D_K';
			if(!strEvent)
				oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn = "DOPPELT";
		}
		else if(oResult.bSchraubbarEinfach && !oResult.bSchraubbarDoppelt && oResult.bKlemmbar){
			oResult.strShow = 'S_K';
			if(!strEvent)
				oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn = "EINFACH";
		}
		else if(!oResult.bSchraubbarEinfach && !oResult.bSchraubbarDoppelt && oResult.bKlemmbar)
			oResult.strShow = 'K';
		else if(!oResult.bSchraubbarEinfach && oResult.bSchraubbarDoppelt && !oResult.bKlemmbar){
			oResult.strShow = 'D';
			if(!strEvent)
				oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn = "DOPPELT";
		}
		else if(oResult.bSchraubbarEinfach && !oResult.bSchraubbarDoppelt && !oResult.bKlemmbar){
			oResult.strShow = 'S';
			if(!strEvent)
				oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn = "EINFACH";
		}
		else
			oResult.strShow = 'SD';
		
		return oResult;
	}
	
	//Data for Fieldset Function 
	switch(strVersion){
		case "LAGERSCHLITTEN"	:
				// @@@ LGE Test - Aufruf der Funktionen getauscht
				//var oDefaultDialogData 	= _getDefaultDataFunction(oDlgLagerSession);
				//var oFunction 	= Controller.Lager.Common.AuswahlStandard.getFieldSetFunction(oDlgLagerSession,oDefaultDialogData);
				//oResult.fieldset.lager_function = oFunction;
				
				var oDefaultDialogData 	= _getDefaultDataMerkmale(oDlgLagerSession);
				var oMerkmale	= Controller.Lager.Common.AuswahlStandard.getFieldSetAttribute(oDlgLagerSession,strVersion,oDefaultDialogData);
				oResult.fieldset.lager_merkmale = oMerkmale;
				
				var oDefaultDialogData 	= _getDefaultDataFunction(oDlgLagerSession);
				var oFunction 	= Controller.Lager.Common.AuswahlStandard.getFieldSetFunction(oDlgLagerSession,oDefaultDialogData);
				oResult.fieldset.lager_function = oFunction;
				
				oResult.fieldset.lager_bb.show 					= false;
				oResult.fieldset.lager_traeger.show				= false;
				
				var oActualInstallationDimension 				= Controller.Lager.Common.AuswahlStandard.getFieldSetActualInstallationDimension(oDlgLagerSession);
				oResult.fieldset.lager_tatsaechlichemass.show	= oActualInstallationDimension;
				
				oResult.title 	= translate("LAGER_AUSWAHL_LAGERSCHLITTEN");
			break;
		case "FESTPUNKT_STOP_W"	:
				oResult.fieldset.lager_function.show = false;
				var oDefaultDialogData 	= _getDefaultDataMerkmale(oDlgLagerSession);
				var oMerkmale			= Controller.Lager.Common.AuswahlStandard.getFieldSetAttribute(oDlgLagerSession,strVersion,oDefaultDialogData);
				oResult.fieldset.lager_merkmale = oMerkmale;
				
				var oDefaultDialogData 	= _getDefaultDataFixed(oDlgLagerSession);
				var oFixed				= Controller.Lager.Common.AuswahlStandard.getFieldSetFixed(oDlgLagerSession,oDefaultDialogData);
				oResult.fieldset.lager_bb = oFixed;
				
				var strTraegertyp = caMainController.getLagerTopologieklasse().isFestlager() ? 'T' : null;
				
				var oBeam	= Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,'ALL',strTraegertyp);
				oResult.fieldset.lager_traeger = oBeam;
				
				var oActualInstallationDimension = Controller.Lager.Common.AuswahlStandard.getFieldSetActualInstallationDimension(oDlgLagerSession);
				oResult.fieldset.lager_tatsaechlichemass	= oActualInstallationDimension;
				
				oResult.title 	= translate("LAGER_AUSWAHL");
			break;
		case "FIELDSET_MERKMALE" :				
				if(caMainController.getLagerTopologieklasse().isGleitlager()){
					var oDefaultDialogData 	= _getDefaultDataMerkmale(oDlgLagerSession,strEvent);
					var oMerkmale	= Controller.Lager.Common.AuswahlStandard.getFieldSetAttribute(oDlgLagerSession,strVersion,oDefaultDialogData);
										
					oResult.fieldset.lager_merkmale = oMerkmale;
					
					// @@@ LGE Test
					//if((strEvent == 'LAGER_GEFUEHRT_MEHRFACH' || strEvent == 'MERKMALE'))
					if((strEvent == 'LAGER_GEFUEHRT_MEHRFACH' || strEvent == 'MERKMALE' || strEvent == 'LAGER_MERKMALE_ACCESSORY'))
						oResult.fieldset.lager_function.show = true;
					
					var oActualInstallationDimension 			= Controller.Lager.Common.AuswahlStandard.getFieldSetActualInstallationDimension(oDlgLagerSession);
					oResult.fieldset.lager_tatsaechlichemass	= oActualInstallationDimension;
				}
				
				if(strEvent == 'MERKMALE' && caMainController.getLagerTopologieklasse().isFestlager()){
					oResult.fieldset.lager_merkmale.show	= true;
					oResult.fieldset.lager_traeger.show 	= true;
					var oActualInstallationDimension = Controller.Lager.Common.AuswahlStandard.getFieldSetActualInstallationDimension(oDlgLagerSession);
					oResult.fieldset.lager_tatsaechlichemass	= oActualInstallationDimension;
					
					var oDefaultDialogData 	= _getDefaultDataFixed(oDlgLagerSession);
					var oFixed				= Controller.Lager.Common.AuswahlStandard.getFieldSetFixed(oDlgLagerSession,oDefaultDialogData);
					oResult.fieldset.lager_bb = oFixed;
				}				
			break;
		case "FIELDSET_FUNCTION_MERKMALE" :
				var oDefaultDialogData 	= _getDefaultDataFunction(oDlgLagerSession);
				var oFunction 	= Controller.Lager.Common.AuswahlStandard.getFieldSetFunction(oDlgLagerSession,oDefaultDialogData);
				oResult.fieldset.lager_function = oFunction;
				
				var oDefaultDialogData 	= _getDefaultDataMerkmale(oDlgLagerSession);
				var oMerkmale	= Controller.Lager.Common.AuswahlStandard.getFieldSetAttribute(oDlgLagerSession,strVersion,oDefaultDialogData);
				oResult.fieldset.lager_merkmale = oMerkmale;				
			break;	
		case "FIELDSET_FIXED" :
				if(strEvent == 'FIXED' && caMainController.getLagerTopologieklasse().isFestlager()){
					oResult.fieldset.lager_merkmale.show	= true;
					
					var oActualInstallationDimension = Controller.Lager.Common.AuswahlStandard.getFieldSetActualInstallationDimension(oDlgLagerSession);
					oResult.fieldset.lager_tatsaechlichemass	= oActualInstallationDimension;
					
					var oDefaultDialogData 	= _getDefaultDataFixed(oDlgLagerSession,strEvent);
					var oFixed				= Controller.Lager.Common.AuswahlStandard.getFieldSetFixed(oDlgLagerSession,oDefaultDialogData);
					oResult.fieldset.lager_bb = oFixed;
					
					var oBeam	= Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,'ALL','T');
					oResult.fieldset.lager_traeger = oBeam;
				}
			break;
	}
	
	var oCurrency = Base.Store.getWaehrungsData();
	oResult.resulttable = {};
	oResult.resulttable.strPriceLabel 		= translate("TCH_PREIS")+"["+oCurrency.CURRENCY_UNIT+"]";
	oResult.resulttable.strLastEditionLabel = (oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf 	== 'LAGER_HORIZONTAL') ? translate("TCH_AUFLAGELAST") : translate("TCH_AUFLAGELAST_Y");
	
	var oSpecial 								= Controller.Lager.Common.AuswahlStandard.getFieldSetSpecial(oDlgLagerSession,"INITIAL_HAUPT");
	oResult.fieldset.lager_sonderabmessungen 	= (strCDVersion == "true") ? oSpecial : (oResult.fieldset.lager_sonderabmessungen.show = false);
	oResult.TopologyPicture						= Lager.getTopologyPicture(oDlgLagerSession);			
	
	//Sonder Checkboxen werden an Rechte gebunden
	var oRechte = {};
	var strIsolierung = caMainController.getLagerTopologieklasse().getIsolierung();
	//if(!Base.Store.isSalesVersion() || strIsolierung!=='ID_WAERMEGEDAEMMT'){
	if(!Base.Store.isExpertMode()){		// Sonder vorerst nur im Expert-Mode -> hier geht noch nichts
		oRechte.disable = [
			['LAGER_SONDERABMESSUNGEN' , true]
		];
		oResult.fieldset.lager_sonderabmessungen.show	= 0;
	}
	else{
		oRechte.disable = [
			['LAGER_SONDERABMESSUNGEN' , false]
		];
	}
	
	oResult.rechte = oRechte;
	
	return oResult;			
};

