/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 *
 */

if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};

/**
 * 4 Dialog werden abgedeckt mit einer Maske
 * @param [strVersion] {String} "SATTEL" / "ROLLENLAGER_SATTEL" 
 */	
Controller.Lager.Common.getDataAuswahlSattel = function(oDlgLagerSession){
	var oResult 					= {};
		oResult.lager_checkbox		= {};
		oResult.lager_radio			= {};
		oResult.lager_store	 		= {};
		oResult.lager_numberfield 	= {};
	
	if(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_SAROLL")
		oDlgLagerSession.AuswahlSattel.strDialogId = "SATTEL";
	else if(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_SYROLLSA")
		oDlgLagerSession.AuswahlSattel.strDialogId = "ROLLENLAGER_SATTEL";
	
	//Data for Fieldset Function 
	switch(oDlgLagerSession.AuswahlSattel.strDialogId){
		case "SATTEL"	:
		case "ROLLENLAGER_SATTEL"	:
				var oLaenge = Sattel.getLaenge(oDlgLagerSession);
				//Reihenfolge beachten !! erst Combobox, dann Radio und dann erst Checkbox Daten!!
				oResult.lager_store			= Controller.Lager.Common._getDataAuswahlSattel_Store(oDlgLagerSession,oLaenge);				
				oResult.lager_radio			= Controller.Lager.Common._getDataAuswahlSattel_Radio(oDlgLagerSession);
				oResult.lager_checkbox 		= Controller.Lager.Common._getDataAuswahlSattel_Checkbox(oDlgLagerSession);				
				oResult.lager_numberfield	= Controller.Lager.Common._getDataAuswahlSattel_Numberfield(oDlgLagerSession);
			break;		
	}
	
	oResult.resulttable;
	
	//Sonder Checkboxen werden an Rechte gebunden
	var oRechte = {};
	if(!Base.Store.isSalesVersion()){
		oRechte.disable = [
			['LAGER_SATTEL_LAENGE_SONDER' , true],
			['LAGER_SATTEL_LAENGE_SONDER_CHECK' , true],
			['LAGER_SATTEL_AUFLAGEDURCHMESSER_SONDER' , true],
			['LAGER_SATTEL_AUFLAGEDURCHMESSER_SONDER_CHECK' , true]
		]; 
	}
	else{
		oRechte.disable = [
			['LAGER_SATTEL_LAENGE_SONDER' , false],
			['LAGER_SATTEL_LAENGE_SONDER_CHECK' , false],
			['LAGER_SATTEL_AUFLAGEDURCHMESSER_SONDER' , false],
			['LAGER_SATTEL_AUFLAGEDURCHMESSER_SONDER_CHECK' , false]
		];
	}
	
	if((oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo !== 'STD') || (oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)){
		oRechte.disable.push(['LAGER_SATTEL_ANSCHWEISSEN',true]);
	}
	else
		oRechte.disable.push(['LAGER_SATTEL_ANSCHWEISSEN',false]);
	
	oResult.rechte = oRechte;
	
	return oResult;			
};

Controller.Lager.Common._getDataAuswahlSattel_Checkbox = function(oDlgLagerSession){
	var oCheckBox = {};
		oCheckBox.disabled = [			
			['ROHRUMSCHLUSS'			, false],
			['ANSCHWEISSEN'				, (oDlgLagerSession.AuswahlSattel.bActuator ? true : false)],
			['AUFLAGEDURCHMESSER_SONDER_CHECK'	, false],
			['LAENGE_SONDER_CHECK'				, (!oDlgLagerSession.AuswahlSattel.strSelComboLength ? true : false)]
		];
		
		
		oCheckBox.disabled.push(['ZYLIDER', (oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder ? true : false)]);
		
		//02.02.2012 Anpassung 
		// - Sattel fr Rollenlager keine Abhebesicherung mglich
		// - System Rollenlager / Sattel Abhebsicherung mglich, muss im Rollenlager mit bestimmt werden,
		//   aber nur dann wenn Zylinderrollenlager nicht gewhlt ist
		
		if(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_ROLL")
			oCheckBox.disabled.push(['ABHEBESICHERUNG', true]);
		else
			oCheckBox.disabled.push(['ABHEBESICHERUNG', false]);
		
		var oTable = oDlgLagerSession.SollwerteHalterungspunkt.oTable;
		//if(oTable.bewegung_minus.schief != 0)
		//	oDlgLagerSession.AuswahlSattel.bUpliftRestraint = true;
		
		if(oTable.bewegung_plus.schief != 0)
			oDlgLagerSession.AuswahlSattel.bUpliftRestraint = true;
		
		//if(oTable.einfuegepunkt.schief != 0)
		//	oDlgLagerSession.AuswahlSattel.bUpliftRestraint = true;
		
		//if(oTable.last_minus.schief != 0)
		//	oDlgLagerSession.AuswahlSattel.bUpliftRestraint = true;
		
		if(oTable.last_plus.schief != 0)
			oDlgLagerSession.AuswahlSattel.bUpliftRestraint = true;
		
		//if(oTable.ueberlast.schief != 0)
		//	oDlgLagerSession.AuswahlSattel.bUpliftRestraint = true;
		
		//if(oTable.zusatzlast.schief != 0)
		//	oDlgLagerSession.AuswahlSattel.bUpliftRestraint = true;
		
		
		oCheckBox.value = [
			['ZYLIDER'							, oDlgLagerSession.AuswahlSattel.bActuator],
			['ABHEBESICHERUNG' 					, oDlgLagerSession.AuswahlSattel.bUpliftRestraint],
			['ROHRUMSCHLUSS'					, oDlgLagerSession.AuswahlSattel.bRadioSurroundingPart],
			['ANSCHWEISSEN'						, oDlgLagerSession.AuswahlSattel.bRadioWeldEnd],
			['AUFLAGEDURCHMESSER_SONDER_CHECK'	, oDlgLagerSession.AuswahlSattel.bSonderLayer],
			['LAENGE_SONDER_CHECK'				, oDlgLagerSession.AuswahlSattel.bSonderLength]
		];	
		
	return oCheckBox;
}

Controller.Lager.Common._getDataAuswahlSattel_Radio = function(oDlgLagerSession){
	if(oDlgLagerSession.AuswahlSattel.bActuator && !oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder) //Korrektur selection radio
		oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart = "SCHELLE_SCHELLE";
	
	var oRadio = {};
	oRadio.disabled = [];
	
	var aTempGUIData = getDataFromLagerCacheObject('AuswahlSattel','TEMP_GUI');
	
	if(oDlgLagerSession.AuswahlSattel.bActuator){
		oRadio.disabled.push(['ROHRUMSCHLUSS_SCHELLE_SCHELLE', false]);
		oRadio.disabled.push(['ROHRUMSCHLUSS_SCHELLE_SCHALE', true] );			
		oRadio.disabled.push(['ROHRUMSCHLUSS_BUEGEL_SCHALE'	, true]);
		oRadio.disabled.push(['ROHRUMSCHLUSS_SCHALE_SCHALE'	, true]);
		oRadio.disabled.push(['ANSCHWEISSEN_BIEGETEIL'		, true]);
		oRadio.disabled.push(['ANSCHWEISSEN_STEGE'			, true]);
		oRadio.disabled.push(['ANSCHWEISSEN_STEGE_M_SCHALE'	, true]);
		oRadio.disabled.push(['ANSCHWEISSEN_N_SCHALE'		, true]);
	}
	else if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder){
		oRadio.disabled.push(['ROHRUMSCHLUSS_SCHELLE_SCHELLE', true]);
		oRadio.disabled.push(['ROHRUMSCHLUSS_SCHELLE_SCHALE', true] );			
		oRadio.disabled.push(['ROHRUMSCHLUSS_BUEGEL_SCHALE'	, true]);
		oRadio.disabled.push(['ROHRUMSCHLUSS_SCHALE_SCHALE'	, false]);
		oRadio.disabled.push(['ANSCHWEISSEN_BIEGETEIL'		, true]);
		oRadio.disabled.push(['ANSCHWEISSEN_STEGE'			, true]);
		oRadio.disabled.push(['ANSCHWEISSEN_STEGE_M_SCHALE'	, true]);
		oRadio.disabled.push(['ANSCHWEISSEN_N_SCHALE'		, true]);
		oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart = "SCHALE_SCHALE";
	}
	else{
		for(var a=0; a<aTempGUIData.length;a++){
			var aPart = aTempGUIData[a];
			switch(aPart[0]){
				case "SCHELLE_SCHELLE" :
						if(oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder || ((oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != '-') && (oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo != 'STD')))
							oRadio.disabled.push(['ROHRUMSCHLUSS_SCHELLE_SCHELLE', true]);
						else
							oRadio.disabled.push(['ROHRUMSCHLUSS_SCHELLE_SCHELLE', !aPart[1]]);
					break;
				case "SCHELLE_SCHALE" :
						oRadio.disabled.push(['ROHRUMSCHLUSS_SCHELLE_SCHALE', !aPart[1]]);
					break;	
				case "BUEGEL_SCHALE" :
						oRadio.disabled.push(['ROHRUMSCHLUSS_BUEGEL_SCHALE', !aPart[1]]);
					break;	
				case "SCHALE_SCHALE" :
						oRadio.disabled.push(['ROHRUMSCHLUSS_SCHALE_SCHALE', !aPart[1]]);
					break;	
				case "BIEGETEIL" :
						oRadio.disabled.push(['ANSCHWEISSEN_BIEGETEIL', !aPart[1]]);
					break;	
				case "STEGE" :
						oRadio.disabled.push(['ANSCHWEISSEN_STEGE', !aPart[1]]);
					break;
				case "STEGE_M_SCHALE" :
						oRadio.disabled.push(['ANSCHWEISSEN_STEGE_M_SCHALE', !aPart[1]]);
					break;	
				case "N_SCHALE" :
						oRadio.disabled.push(['ANSCHWEISSEN_N_SCHALE', !aPart[1]]);
					break;	
			}
		}
	}
	
	
	oRadio.value = {
		'ROHRUMSCHLUSS_RADIO' 	: oDlgLagerSession.AuswahlSattel.strRadioSurroundingPart,
		'ANSCHWEISSEN_RADIO'	: oDlgLagerSession.AuswahlSattel.strRadioWeldEnd
	};
	
	return oRadio;
}

Controller.Lager.Common._getDataAuswahlSattel_Store = function(oDlgLagerSession,oLaenge){	
	//Typ Reihe ?
	var strTypReihe 	= Sattel.getTypReihen(oDlgLagerSession);
	var strWerkstoff 	= Lager.getWerkstoffeNumber(oDlgLagerSession);
	var aSplitData		= strTypReihe.split(",");
	
	var strSql 			= "SELECT * FROM Werkst_Obfl_Zuordnung WHERE ("; 
	for(var i=0;i<aSplitData.length;i++){
		if(i == 0)
			strSql +=" TYP = '"+aSplitData[i]+"' ";
		else
			strSql +=" OR TYP = '"+aSplitData[i]+"' ";
	}
	
	strSql += ") AND WERKSTOFF = "+strWerkstoff;
	strSql += " GROUP BY OBFL";
	var aOBFL 			= Object.fromDatabase("LAGER2",strSql);
	
	var aOberflaeche = [];
	for(var a=0;a<aOBFL.length;a++){
		var sqlstring 			= "select * from Oberflaeche WHERE OBERFL_ID = "+aOBFL[a].OBFL;
		var dbName				= 'CASCADE';
		var dbNameTable 		= "OBERFLAECHE";
		var dTableDatenLength 	= dbselect( dbName, sqlstring, dbNameTable );
		if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
			var strLanguage = getlanguage();
			while ( dbiseof( dbNameTable) == 0 ){
				var aDBData = new Array();
				aOberflaeche.push([dbgetstring(dbNameTable,"OBERFL_ID"),(strLanguage == 'DE' ? dbgetstring(dbNameTable,"OBERFL_TXT_DE") : dbgetstring(dbNameTable,"OBERFL_TXT_EN"))]);
				dbskip( dbNameTable );
			}
		}
	}
	
	//und nun noch der Test ob ID im Array enthalten ist
	if(!Base.hasValueIntoArrayPositionNull(aOberflaeche,oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel))
		oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel = aOberflaeche[0][0];
	
	
	if(!oDlgLagerSession.AuswahlSattel.strSelComboLength){
		oDlgLagerSession.AuswahlSattel.bSonderLength = true;
		if(oDlgLagerSession.AuswahlSattel.dSonderLength == 0)
			oDlgLagerSession.AuswahlSattel.dSonderLength = 300;
	}
	
	var oStore 	= {};
		oStore.Combo 	= [['storeSattelLaenge',oLaenge.Store],['storeOberflaeche',aOberflaeche]];
		oStore.value 	= [['SATTEL_LAENGE',oDlgLagerSession.AuswahlSattel.strSelComboLength],['SATTEL_OBERFLAECHE',oDlgLagerSession.AuswahlSattel.strSelComboGroundLevel]];
		oStore.disabled = [['SATTEL_LAENGE',(oDlgLagerSession.AuswahlSattel.bSonderLength ? true : false)],['SATTEL_OBERFLAECHE',false]];
	return oStore;
}

Controller.Lager.Common._getDataAuswahlSattel_Numberfield = function(oDlgLagerSession){
	var oNumberfield = {};
	
	oNumberfield.value = [
		['AUFLAGEDURCHMESSER', oDlgLagerSession.AuswahlSattel.dLayer	],
		['AUFLAGEDURCHMESSER_SONDER', (oDlgLagerSession.AuswahlSattel.dSonderLayer != 0 ? oDlgLagerSession.AuswahlSattel.dSonderLayer : '')	],
		//['LAENGE_SONDER', (oDlgLagerSession.AuswahlSattel.dSonderLength != 0 ? oDlgLagerSession.AuswahlSattel.dSonderLength  : '')]
		['LAENGE_SONDER', ((oDlgLagerSession.AuswahlSattel.dSonderLength != 0 && oDlgLagerSession.AuswahlSattel.bSonderLength) ? oDlgLagerSession.AuswahlSattel.dSonderLength  : '')]
	];
	
	oNumberfield.disabled = [
		['AUFLAGEDURCHMESSER',true],
		['AUFLAGEDURCHMESSER_SONDER',false],
		['LAENGE_SONDER',false]
	];
	
	return oNumberfield;
}