/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */

if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};

Controller.Lager.Common.getDataAuswahlRollenlagerDirekt = function(oDlgLagerSession){
	var oResult 		= {};
		oResult.value 	= {};
		oResult.store  	= {};
	
	var _getTypen = function(oDlgLagerSession,strTable,strSelCombo){
		var aStore = [];
		var strSql 				= "SELECT * FROM "+strTable+" GROUP BY TYP ";
		var dbName				= 'LAGER2';
		var dbNameTable 		= "ROLLENLAGER_DIREKT";		
		var dTableDatenLength 	= dbselect( dbName, strSql, dbNameTable );	
		if ( dTableDatenLength > 0 ){
			while ( dbiseof( dbNameTable) == 0 ){	//Hier sollte nur eun Wert rauskommen, wenn  nicht dann ist die Aufstellung in der DB falsch
				var strTyp = dbgetstring(dbNameTable,"TYP");
				aStore.push([strTyp,strTyp]);
				
				dbskip(dbNameTable);
			}
		}
		
		if(!Base.hasValueIntoArrayPositionNull(aStore,oDlgLagerSession.AuswahlRollenlagerDirekt[strSelCombo]))
			oDlgLagerSession.AuswahlRollenlagerDirekt[strSelCombo] = aStore[0][0];
		
		return aStore;
	}
	
	var oBeam	= Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,'ALL','T');
	
	//Combo Inhalt
	var aComboStore = [
		['DZ_RL' 	, _getTypen(oDlgLagerSession,'RDF','strSelComboDZ_RL')],
		['Z_RL' 	, _getTypen(oDlgLagerSession,'RZL','strSelComboZ_RL')],
		['DK_RL' 	, _getTypen(oDlgLagerSession,'RKF','strSelComboDK_RL')],
		['DZ_RL_SV' , _getTypen(oDlgLagerSession,'RDL','strSelComboDZ_RL_SV')],
		['Z_RL_SV' 	, _getTypen(oDlgLagerSession,'RZG','strSelComboZ_RL_SV')],
		['DK_RL_SV' , _getTypen(oDlgLagerSession,'RKL','strSelComboDK_RL_SV')],
		['TRAEGERART',oBeam.store.storeTArt],
		['TRAEGERTYP',oBeam.store.storeTGroesse]
	];
	
	//build Array with all Combo Selections
	var aComboSel = [
		['DZ_RL' 	, oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboDZ_RL],
		['Z_RL' 	, oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboZ_RL],
		['DK_RL' 	, oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboDK_RL],
		['DZ_RL_SV' , oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboDZ_RL_SV],
		['Z_RL_SV' 	, oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboZ_RL_SV],
		['DK_RL_SV' , oDlgLagerSession.AuswahlRollenlagerDirekt.strSelComboDK_RL_SV],
		['TRAEGERART',oDlgLagerSession.AuswahlStandard.strSelComboBeamArt],
		['TRAEGERTYP',oDlgLagerSession.AuswahlStandard.strSelComboBeamSize]
	];
	
	oResult.value.strRadio 	= oDlgLagerSession.AuswahlRollenlagerDirekt.strRadio; 		//DZ_RL / Z_RL / DK_RL / DZ_RL_SV / Z_RL_SV / DK_RL_SV
	oResult.value.aComboSel = aComboSel; 	//Combo Selections
			
	var aValue = [
		['HOEHE', oDlgLagerSession.AuswahlStandard.dBeamHeight,true],
		['BREITE',oDlgLagerSession.AuswahlStandard.dBeamWidth,true],
		['FLANSCHDICKE',oDlgLagerSession.AuswahlStandard.dBeamThickness,true]
	];
	
	oResult.store = aComboStore;		
	oResult.value.numberfield = aValue;
	oResult.checkbox = {};
	oResult.checkbox.klemmbar = oDlgLagerSession.AuswahlRollenlagerDirekt.bCheck;
	
	return oResult;			
};

