/**
 * @category   controller function
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 */

if ( typeof( Controller ) === 'undefined' )
	Controller = {};
if ( typeof( Controller.Lager ) === 'undefined' )
	Controller.Lager = {};
if ( typeof( Controller.Lager.Common ) === 'undefined' )
	Controller.Lager.Common = {};

/**
 * 4 Dialog werden abgedeckt mit einer Maske
 * @param [oDlgLagerSession] {Object} Session Object
 */	
Controller.Lager.Common.getDataAuswahlRollenlager = function(oDlgLagerSession,strComponentId){
	var oResult 						= {};
		oResult.fieldset 				= {};
		oResult.fieldset.lager_traeger  = {};
		oResult.fieldset.lager_function = {};
		oResult.fieldset.lager_rollenlager = {};
		oResult.fieldset.lager_sattel	= {};
	
	/**
	 * @private hole datenbank daten ber das produkt
	 * Tabelle : AUSLEGUNG_ROLLEN_LAGER
	 */
	var _getDB_Rollenlager_Data = function(oDlgLagerSession){
		var oResult = {};
		var sqlstring = "SELECT * FROM AUSLEGUNG_ROLLEN_LAGER WHERE ";
		sqlstring += "LAGERART = '"+oDlgLagerSession.AuswahlRollenlager.strSelComboTyp+"' ";
		
		if(oDlgLagerSession.AuswahlRollenlager.strSelRadioRollerBearing == "LOSE")
			sqlstring += "AND LOSE = 'true' ";
		else
			sqlstring += "AND GEFUEHRT = 'true' ";
		
		var _subFilter = function(dAuflage,strSelComboTyp){
			if(strSelComboTyp == "DOPPELZYLINDER")
				//return (dAuflage <= 830);
				return (dAuflage <= 830 ? true : false);
			else if(strSelComboTyp == 'DOPPELKEGEL')
				//return (dAuflage <= 325);
				return (dAuflage <= 325 ? true : false);
			else	// Zylinderrollenlager
				return (dAuflage <= 120 ? true : false);	// dAuflage ist hier die Fussbreite des Lagers
		}
		
		var bKlemmbar = true;
		if((oDlgLagerSession.AuswahlRollenlager.strDialogId == 'ROLLENLAGER_P') || (oDlgLagerSession.AuswahlRollenlager.strDialogId == 'ROLLENLAGER_S')){			
			if (oDlgLagerSession.AuswahlRollenlager.strSelComboTyp != "ZYLINDER"){
				var dCalculationData = oDlgLagerSession.AuswahlRollenlager.dSupportDiameter;
				if(oDlgLagerSession.AuswahlRollenlager.strDialogId == 'ROLLENLAGER_S'){
					var dJ_Max 	= oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel.J_MAX;
					var ds_Lauf = oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel.S_LAUFSCHALE;
					
					dCalculationData  = 2 * dJ_Max; 
					dCalculationData += 2 * ds_Lauf;
					dCalculationData += (oDlgLagerSession.AuswahlSattel.bSonderLayer ? oDlgLagerSession.AuswahlSattel.dLayer : (oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel.DN*1)) ;
				}	
			}
			else{
				var dCalculationData = oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel.A;
			}
			if(dCalculationData > 0)
				bKlemmbar = _subFilter(dCalculationData,oDlgLagerSession.AuswahlRollenlager.strSelComboTyp);
		
			if(!bKlemmbar)
				oDlgLagerSession.AuswahlRollenlager.strSelRadioFunction = "SCHRAUBBAR";
		}
		
		if(oDlgLagerSession.AuswahlRollenlager.strSelRadioFunction == "KLEMMBAR")
			sqlstring += "AND KLEMMBAR = 'true' ";
		else if(oDlgLagerSession.AuswahlRollenlager.strSelRadioFunction == "SCHRAUBBAR")
			sqlstring += "AND SCHRAUBBAR = 'true' ";
			
		var dbName				= 'LAGER2';
		var dbNameTable 		= "ROLLENLAGER";		
		var dTableDatenLength 	= dbselect( dbName, sqlstring, dbNameTable );	
		if ( dTableDatenLength > 0 ){
			while ( dbiseof( dbNameTable) == 0 ){	//Hier sollte nur eun Wert rauskommen, wenn  nicht dann ist die Aufstellung in der DB falsch
				oResult.strTypenReihe		= dbgetstring(dbNameTable,"TYPENREIHE");
				oResult.bVorisoliert		= Base.convertStringToBoolean(dbgetstring(dbNameTable,"VORISOLIERT"));
				oResult.bLose				= Base.convertStringToBoolean(dbgetstring(dbNameTable,"LOSE"));
				oResult.bGefuehrt			= Base.convertStringToBoolean(dbgetstring(dbNameTable,"GEFUEHRT"));
				oResult.bKlemmbar			= (!bKlemmbar ? false : Base.convertStringToBoolean(dbgetstring(dbNameTable,"KLEMMBAR")));
				oResult.bSchraubbar			= Base.convertStringToBoolean(dbgetstring(dbNameTable,"SCHRAUBBAR"));
				oResult.bAbhebesicherung	= Base.convertStringToBoolean(dbgetstring(dbNameTable,"ABHEBESICHERUNG"));
				oResult.strTraegerTyp		= dbgetstring(dbNameTable,"TRAEGERTYP");				
				
				oResult.bDisableKlemmbar    = (!bKlemmbar ? true : false);
				
				dbskip(dbNameTable);
			}
			
			if(oResult.strTraegerTyp)
				oResult.bBeam = (oResult.strTraegerTyp == '-' ? false : true);
		}
		
		return oResult;
	}
	
	oResult.fieldset.lager_function.radioshow = false;
	//Data for Fieldset Function 
	switch(oDlgLagerSession.AuswahlRollenlager.strDialogId){
		case "ROLLENLAGER_S" 	:	
		case "ROLLENLAGER_P"	:
				if(!strComponentId)
					strComponentId = 'ALL';
				var oGuiData	= _getDB_Rollenlager_Data(oDlgLagerSession);
				if(oGuiData.bBeam){
					var oBeam		= Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,'ALL',oGuiData.strTraegerTyp);
					oResult.fieldset.lager_traeger = oBeam;
				}
				//else
				//	oResult.fieldset.lager_traeger.show = false;
			
				if(strComponentId == 'ALL' || strComponentId == 'LAGER_ROLLENLAGER_ART' || strComponentId =="RADIO" ){
					var oFunction 	= Controller.Lager.Common.AuswahlRollenlager.getFieldSetFunction(oDlgLagerSession,oGuiData);
					oResult.fieldset.lager_function = oFunction;
				}
				else
					oResult.fieldset.lager_function.show = true;
				
				//Bei ROLLENLAGER_S also Sattel und Rollenlager braucht man diese Anzeige nicht im
				//Rollenlager, da diese schon im Dialog zuvor Vorhanden waren.
				if(oDlgLagerSession.AuswahlRollenlager.strDialogId == 'ROLLENLAGER_S'){
					oResult.fieldset.lager_function.hide.Auflagendurchmesser = true;		
					oResult.fieldset.lager_function.hide.Fussbreite = true;
					
					oResult.fieldset.lager_function.radioshow = true;
					var oSattel = oDlgLagerSession.AuswahlSattel.oSearchResult.oResultSattel;
					var bPA = Lager.isRollenlager_Werkstoff_PA(oDlgLagerSession.SollwerteRohrUmTeil,oSattel).bPA;
					
					if(!bPA && (oDlgLagerSession.AuswahlRollenlager.strSelRadioWerk == 'PA') )
						oDlgLagerSession.AuswahlRollenlager.strSelRadioWerk = 'St';
					
					if(!bPA)
						oResult.fieldset.lager_function.radiodisabled = true;
					else
						oResult.fieldset.lager_function.radiodisabled = false;
					
					oResult.fieldset.lager_function.radiovalue = "LAGER_ROLLENLAGER_ART_WERKSTOFF_"+oDlgLagerSession.AuswahlRollenlager.strSelRadioWerk;
				}
				else{
					oResult.fieldset.lager_function.radioshow 	= true;
					oResult.fieldset.lager_function.radiovalue 	= "LAGER_ROLLENLAGER_ART_WERKSTOFF_"+oDlgLagerSession.AuswahlRollenlager.strSelRadioWerk;
				}
				
				if(strComponentId == 'ALL'){
					var oRollenlager = Controller.Lager.Common.AuswahlRollenlager.getFieldSetRollenlager(oDlgLagerSession);
					oResult.fieldset.lager_rollenlager = oRollenlager;
				}
				else
					oResult.fieldset.lager_rollenlager.show = true;
				
				oResult.fieldset.lager_sattel.show 		= false;
				
				oResult.title 	= (oDlgLagerSession.AuswahlRollenlager.strDialogId == "ROLLENLAGER_S" ? translate("LAGER_AUSWAHL_ROLLENLAGER") : translate("LAGER_AUSWAHL_ROLLENLAGER_UEBER_PARAMETER"));
			break;
		case "ROLLENLAGER_K" :
				var oBeam		= Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession);
				oResult.fieldset.lager_traeger = oBeam;
				
				oResult.fieldset.lager_function = {};
				oResult.fieldset.lager_function.show = false;
				oResult.fieldset.lager_function.hide = {
					'Auflagendurchmesser' 	: true,		
					'Fussbreite'			: true,
					'vAbhebesicherung'		: true
				};
				
				oResult.fieldset.lager_rollenlager = {};
				oResult.fieldset.lager_rollenlager.show = false;
				
				oResult.fieldset.lager_sattel = {};
				oResult.fieldset.lager_sattel.show 		= false;
				
				oResult.title 	= translate("LAGER_AUSWAHL_ROLLENLAGER_KLEMMSYSTEM");
				oResult.image   = '<img src="EasyKatImages/NO_PICTURE.jpg" style="cursor:pointer" />';
			break;
		case "ROLLENLAGER_U_SATTEL" :
				oResult.fieldset.lager_traeger = {};
				oResult.fieldset.lager_traeger.show = false;
				
				oResult.fieldset.lager_function = {};
				oResult.fieldset.lager_function.show = false;
				oResult.fieldset.lager_function.hide = {
					'Auflagendurchmesser' 	: true,		
					'Fussbreite'			: true,
					'vAbhebesicherung'		: true
				};
				
				var oRollenlager = Controller.Lager.Common.AuswahlRollenlager.getFieldSetRollenlager(oDlgLagerSession,strComponentId);
				oResult.fieldset.lager_rollenlager = oRollenlager;
				
				var oSattel = Controller.Lager.Common.AuswahlRollenlager.getFieldSetSattel(oDlgLagerSession);
				oResult.fieldset.lager_sattel	= oSattel;
				
				oResult.title 	= translate("LAGER_AUSWAHL_ROLLENLAGER_UND_SATTEL");
				oResult.image   = '<img src="EasyKatImages/NO_PICTURE.jpg" style="cursor:pointer" />';
			break;
	}
	
	var oCurrency = Base.Store.getWaehrungsData();
	oResult.fieldset.strfunction = oDlgLagerSession.AuswahlRollenlager.strDialogId;
	oResult.resulttable			 = {};
	oResult.resulttable.strPriceLabel	= translate("TCH_PREIS")+"["+oCurrency.CURRENCY_UNIT+"]";

	
	return oResult;			
};

