/**
 * SystemcharakteristikController
 */
LagerSystemcharakteristikController = function() {
	LagerSystemcharakteristikController.superclass.constructor.call(this);
};

EasyKat.extend(LagerSystemcharakteristikController, CustomController, {
	getInitalValuesAction: function(){
		var bDeleteDialogObject	= setDeleteDialogObjectSession("LAGER")
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		
		oDlgLagerSession.bLastKetteDialog = false;
		caMainController.getLagerTopologieklasse().setEmptyProduct();
		
		var oResult 			= this._getDataObject(oDlgLagerSession,"INITAL");
		oResult.sessionId 		= Base.Store.getSessionId();
		
		echo oResult.toJSON(); 
	},
	
	// wird aufgerufen beim Click auf Weiter aus dem Dialog
	setValuesAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");

		// LAGER_SPG, LAGER_SSG, LAGER_EPG, LAGER_ROHRST, LAGER_ROLL, LAGER_SAROLL, LAGER_SYROLLSA, LAGER_FS, LAGER_ZUBEHOER
		setstring( "IDC_LASTKETTE", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", oDlgLagerSession.Systemcharakteristik.strSelRadioLager );
		// LAGER_HORIZONTAL
		setstring( "IDC_ROHRVERLAUF", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf );
		// LAGER_X_ACHSE
		setstring( "IDC_ROHRRICHTUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung );

		// setstring( "KOORD_IMG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", oDlgLagerSession.KOORD_IMG );
		// setstring( "KOORD_IMG_VAR", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", oDlgLagerSession.KOORD_IMG_VAR );
		setstring( "SCHRAEG_ALPHA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", oDlgLagerSession.Systemcharakteristik.dAlpha );
		setstring( "SCHRAEG_BETA", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", oDlgLagerSession.Systemcharakteristik.dBeta );
		// setstring( "SENKR_ACHSE", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", oDlgLagerSession.SENKR_ACHSE );
		// setstring( "SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK", oDlgLagerSession.SENKR_RICHT );

	},
	
	setRadioAction: function(){
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		var strRadioGroup 		= HttpRequest.get("radiogroup"); 	//IDC_LAGER or IDC_ROHR or IDC_ROHRRICHTUNG or IDC_ROHRVERLAUF
		var strRadioValue 		= HttpRequest.get("radiovalue");	//'LAGER_SPG' / 'LAGER_SSG'	 / 'LAGER_EPG' / 'LAGER_ROHRST' / 'LAGER_ROLL' / 'LAGER_SAROLL' / 'LAGER_SYROLLSA' / 'LAGER_FS' / 'LAGER_ZUBEHOER' / 'LAGER_HS'	   
															//or 'HORIZONTAL' / 'VERTIKAL'
															//or 'X_ACHSE' / 'Y_ACHSE'  / 'Z_ACHSE' / 'SCHRAEG_ACHSE'
		
		switch(strRadioGroup){
			case "IDC_LAGER":
					oDlgLagerSession.Systemcharakteristik.strSelRadioLager = strRadioValue;
					Base.Store.setDefaultTableHaltepunkte();
				break;
			case "IDC_ROHRVERLAUF"	:
					oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf = "LAGER_"+strRadioValue;
				break;
			case "IDC_ROHRRICHTUNG"	:
					oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung = "LAGER_"+strRadioValue;
					/*if (strRadioValue != "SCHRAEG_ACHSE"){
						oDlgLagerSession.Systemcharakteristik.dAlpha	= 0;
						oDlgLagerSession.Systemcharakteristik.dBeta		= 0;
					}*/
				break;
		}
		
		var strSmallRadioGroup 	= strRadioGroup.replace("IDC_","");
		var oResult 			= this._getDataObject(oDlgLagerSession,strSmallRadioGroup);
		
		echo oResult.toJSON(); 
	},
	setNumberfieldAction: function() {
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		var strNumberfieldId 	= HttpRequest.get("numberfieldid"); 	
		var strNumberfieldValue = HttpRequest.get("numberfieldvalue");
		
		switch(strNumberfieldId){
			case "LAGER_SCHRAEG_ALPHA" 	:
					oDlgLagerSession.Systemcharakteristik.dAlpha = (strNumberfieldValue*1);
				break;
			case "LAGER_SCHRAEG_BETA"	:
					oDlgLagerSession.Systemcharakteristik.dBeta = (strNumberfieldValue*1);
				break;
		}
		
		var oResult = this._getDataObject(oDlgLagerSession);
		echo oResult.toJSON();
	},
	setCheckBoxAction: function(){
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		var strCheckBoxId 		= HttpRequest.get("checkboxid"); 	//krT
		var strCheckBoxValue 	= HttpRequest.get("checkboxvalue"); //true/false
		
		switch(strCheckBoxId){
			case "krT" :
					oDlgLagerSession.Systemcharakteristik.bSel_krT = (strCheckBoxValue == 'true' || strCheckBoxValue == true) ? true : false; 
					/*if(oDlgLagerSession.Systemcharakteristik.bSel_krT)
						oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf = 'LAGER_VERTIKAL';*/
				break;
			default: break;
		}
		
		var oResult = this._getDataObject(oDlgLagerSession);
		echo oResult.toJSON(); 
	},
	setComboBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strComboBoxId 	 = HttpRequest.get("comboboxid"); 	
		var strComboBoxValue = HttpRequest.get("comboboxvalue");	
		
		oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager = strComboBoxValue;
		
		var oResult = {};
		echo oResult.toJSON();
	},
	getImages2Action: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var oResult = {};
		oResult = this._getDataObject(oDlgLagerSession,'PICTURE');
		echo oResult.toJSON();
	},
	/**
	 * @private 
	 * build initial Object for this dialog
	 */
	_getDataObject: function(oDlgLagerSession,strBuildAjax){
		// zur Unterscheidung ob ein FIN-File und damit Vorgabewerte vorhanden sind
		var FIN_FILE	= (typeof(Object.fromStorage( "DLGDATA.CA.FINDATA" )) == 'object' ? true : false);
		var oRohrrichtung;
		if(strBuildAjax == "INITAL"){
			var oComboStore = [
				['KG'		,translate("LAGER_KLEMMSYSTEM_GLEITLAGER")],
				['KR'		,translate("LAGER_KLEMMSYSTEM_ROLLENLAGER")],
				['AzA'		,translate("LAGER_ABHEBESICHERUNG_ANSCHWEISSEN_UND_GLEITELEMENT_PTFE")],
				['AfR'		,translate("LAGER_ABHEBESICHERUNG_ROLLENLAGER")]
			];
			
			var oLager = {
				'radiogroup' : {'selection' : oDlgLagerSession.Systemcharakteristik.strSelRadioLager},
				'store'		 : oComboStore,
				'value'		 : oDlgLagerSession.Systemcharakteristik.strSelZubehoerComboLager
			};
		}
				
		if(strBuildAjax == "INITAL" || strBuildAjax == "LAGER"){
			var oRohr = {
				'krTDisable' 	: oDlgLagerSession.Systemcharakteristik.strSelRadioLager == 'LAGER_ROLL' ? false : true, 	//checkbox disabled "keine rohrumschliessendes Teil"
				'radiogroup' 	: oRadioRohrGroup
			};
			
			if(oDlgLagerSession.Systemcharakteristik.strSelRadioLager != 'LAGER_ROLL')
				oDlgLagerSession.Systemcharakteristik.bSel_krT = false;
			
			oRohr.krTValue = oDlgLagerSession.Systemcharakteristik.bSel_krT;
		}
		
		if(strBuildAjax !=="ROHRVERLAUF" || strBuildAjax !== "ROHRRICHTUNG"){
			var oRohrverlauf = {
				'selection' : oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf
			};
		}
		
		if(strBuildAjax !== "ROHRRICHTUNG" && strBuildAjax !== 'PICTURE'){
			var strVerticalAchse = Base.Store.getSettingsVerticalAchse();
			
			if((oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf == "LAGER_HORIZONTAL") && 
				(oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung == "LAGER_"+strVerticalAchse+"_ACHSE")){
				if (strVerticalAchse != 'X')
					oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung = "LAGER_X_ACHSE";
				else
					oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung = "LAGER_Y_ACHSE";
			}
			else if((oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf !== "LAGER_HORIZONTAL") && 
				(oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung !== "LAGER_"+strVerticalAchse+"_ACHSE")){
				oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung = "LAGER_"+strVerticalAchse+"_ACHSE";
			}
			
			var oDisable;
			if(oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf !== "LAGER_HORIZONTAL"){
				oDisable = {
					'LAGER_Z_ACHSE' : (strVerticalAchse == 'Z') ? false : true,
					'LAGER_X_ACHSE' : (strVerticalAchse == 'X') ? false : true,
					'LAGER_Y_ACHSE' : (strVerticalAchse == 'Y') ? false : true
				};
				if (!FIN_FILE && !oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung)
					oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung = 'LAGER_'+strVerticalAchse+'_ACHSE';
			}
			else{
				oDisable = {
					'LAGER_Z_ACHSE' : (strVerticalAchse == 'Z') ? true : false,
					'LAGER_X_ACHSE' : (strVerticalAchse == 'X') ? true : false,
					'LAGER_Y_ACHSE' : (strVerticalAchse == 'Y') ? true : false
				};
				
				if (!FIN_FILE && !oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung){
					if(strVerticalAchse !== 'X')
						oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung = 'LAGER_X_ACHSE';
					else
						oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung = 'LAGER_Y_ACHSE';
				}
			}
			
			var oRohrrichtung = {
				'selection' : oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung,
				'disable'	: oDisable			
			};	
		}	
		
		if(!oRohrrichtung)
			oRohrrichtung = {};
		
		if(oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung === "LAGER_SCHRAEG_ACHSE"){
			oRohrrichtung.hide 	= {'LAGER_SCHRAEG_ALPHA' : false, 'LAGER_SCHRAEG_BETA' : false};
			oRohrrichtung.value = {'LAGER_SCHRAEG_ALPHA' : oDlgLagerSession.Systemcharakteristik.dAlpha*1, 'LAGER_SCHRAEG_BETA' : oDlgLagerSession.Systemcharakteristik.dBeta*1};
		}
		else
			oRohrrichtung.hide 	= {'LAGER_SCHRAEG_ALPHA' : true, 'LAGER_SCHRAEG_BETA' : true};
		
		var oPicture = {
			'strImage' 	: this._buildKoorPic(oDlgLagerSession)
		};
		
		if(strBuildAjax == 'PICTURE'){
			return ({
				'picture' : oPicture
			});
		}
		
		return ({	
			'lager' 			: oLager, 
			'picture' 			: oPicture, 
			'rohr' 				: oRohr, 
			'rohrverlauf' 		: oRohrverlauf,
			'rohrrichtung'		: oRohrrichtung,
			'TopologyPicture' 	: Lager.getTopologyPicture(oDlgLagerSession)
		});
	},
	/**
	 * bestimme Bild mit Kootdinatensystem
	 * @return {String} strFile 
	 */
	_buildKoorPic: function(oDlgLagerSession){
		var strPipeImage,KoordImgS,SENKR_ACHSE;
		var strPipeDir 	= "";
		
		var RR_KS 			= caMainController.dataAccess.getInfoRRKSDefault("HORIZONTAL");
		var valRR 			= oDlgLagerSession.Systemcharakteristik.strSelRadioRohrichtung;
		var strKoordImgVar 	= RR_KS.KoordImgVar;
		var strSenkr_Achse 	= RR_KS.VertiDir;
		
		if (valRR == "LAGER_X_ACHSE")
			valRR = strPipeDir = "X";
		else if (valRR == "LAGER_Y_ACHSE")
			valRR = strPipeDir = "Y";
		else if (valRR == "LAGER_Z_ACHSE")
			valRR = strPipeDir = "Z";
		else if (valRR == "LAGER_SCHRAEG_ACHSE")
			valRR = strPipeDir = "S";
		
		var KoordImgS = "";
		if (valRR == "S")
			KoordImgS = "S_";
		
		if (oDlgLagerSession.Systemcharakteristik.strSelRadioRohrverlauf !== 'LAGER_HORIZONTAL')
			strPipeImage	= "RH_KOORD_V" + strSenkr_Achse + "_Rohr_V_" + KoordImgS + strKoordImgVar + ".jpg";
		else
			strPipeImage	= "RH_KOORD_V" + strSenkr_Achse + "_Rohr_H_" + strPipeDir + "_" + strKoordImgVar + ".jpg";
			
		var strFile			= 'EasyKatImages/WITgifs/RH/' + strPipeImage;
		
		return strFile;	
	}
});