LagerSollwerteRohrumschliessendesteilController = function() {
	LagerSollwerteRohrumschliessendesteilController.superclass.constructor.call(this);
};

EasyKat.extend(LagerSollwerteRohrumschliessendesteilController, CustomController, 
{
	getInitalValuesAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		// Noch die Warnmeldung wegbgeln
		if (oDlgLagerSession.SollwerteRohrUmTeil.bMessage &&
			!oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder &&
			!oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
			oDlgLagerSession.SollwerteRohrUmTeil.bMessage = 0;
		var oResult = this._getDataObject(oDlgLagerSession);
		echo oResult.toJSON(); 
	},
	setNumberfieldAction : function(){
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		var strNumberFieldId 	= HttpRequest.get("numberfieldid"); 	
		var strNumberFieldValue = HttpRequest.get("numberfieldvalue");	
		oDlgLagerSession.bLastKetteDialog = false;
		var oResult = this._buildNumField(oDlgLagerSession,strNumberFieldId,strNumberFieldValue);
		echo oResult.toJSON();
	},
	setComboBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strComboBoxId 	 = HttpRequest.get("comboboxid"); 	
		var strComboBoxValue = HttpRequest.get("comboboxvalue");	
		oDlgLagerSession.bLastKetteDialog = false;
		var oResult = this._buildCombo(oDlgLagerSession,strComboBoxId,strComboBoxValue);
		echo oResult.toJSON();
	},
	setCheckBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strCheckBoxId 	 = HttpRequest.get("checkboxid"); 	
		var strCheckBoxValue = HttpRequest.get("checkboxvalue");	
		oDlgLagerSession.bLastKetteDialog = false;
		var oResult = this._buildCheck(oDlgLagerSession,strCheckBoxId,strCheckBoxValue);
		echo oResult.toJSON();
	},
	setWerkstoffValuesAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var selectionRadio = HttpRequest.get('actWerkstoff');
		
		//if((oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff !== "LAGER_"+selectionRadio ) && oDlgLagerSession.bLastKetteDialog){
		if((oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff !== "LAGER_"+selectionRadio ) && !oDlgLagerSession.bLastKetteDialog){
			oDlgLagerSession.bLastKetteDialog = false;
			oDlgLagerSession.SollwerteRohrUmTeil.strSelRadioWerkstoff = "LAGER_"+selectionRadio;
		}
		
		var oResult = {'success' : true};
		echo oResult.toJSON();
	},
	setValuesAction : function(){
		
		// E-Mass fuer Sonderlager belegen
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var dA	= oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo;
		if (oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder)
			dA	= oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder;
		oDlgLagerSession.AuswahlStandard.dMass1 = fround(oDlgLagerSession.AuswahlStandard.dHoehe1 + dA/2);
		oDlgLagerSession.AuswahlStandard.dMass2 = fround(oDlgLagerSession.AuswahlStandard.dHoehe2 + dA/2);
		oDlgLagerSession.AuswahlStandard.dMass3 = fround(oDlgLagerSession.AuswahlStandard.dHoehe3 + dA/2);
		oDlgLagerSession.AuswahlStandard.dMass4 = fround(oDlgLagerSession.AuswahlStandard.dHoehe4 + dA/2);
		//var oResult = {'success' : true};
		//echo oResult.toJSON();
		
		setDataIntoLagerCacheObject('AuswahlSattel','TEMP_GUI'); //zwangssubern
	},
	_getDataObject: function(oDlgLagerSession,strComponent){
		var oResult 	= {};
		var oInitial 	= Controller.Lager.Common.getDataRohrumschliessendesTeil(oDlgLagerSession,strComponent);
		
		oResult.temperatur 			= oInitial.oTemperatur;
		oResult.umgebungstemperatur = oInitial.oUmgebungstemperatur;
		oResult.werkstoff			= oInitial.oWerkstoff;
		oResult.combo				= oInitial.oCombo;
		oResult.daemmdicke			= oInitial.oDaemmdicke;
		oResult.sonder				= oInitial.oSonder;
		oResult.manteldurchmesser	= oInitial.oMantel;
		oResult.schelleneinlage		= oInitial.oSchelleneinlage;
		oResult.TopologyPicture		= Lager.getTopologyPicture(oDlgLagerSession);
		oResult.rechte				= oInitial.oRechte;
		oResult.SpecialStandardDIA	= oInitial.oSpecialStandardDIA;
		
		return oResult;
	},
	_buildNumField: function(oDlgLagerSession,strNumberFieldId,strNumberFieldValue){
		var oResult = {}; //Bezeichnungen  siehe Controller.Lager.Common.getDataRohrumschliessendesTeil
		switch(strNumberFieldId){
			case "LAGER_IDC_TEMPERATUR_MEDIUM" :
					oDlgLagerSession.SollwerteRohrUmTeil.dTemperaturMedium = strNumberFieldValue;
				break;
			case "LAGER_IDC_DAEMMDICKE" :
					oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke = strNumberFieldValue;
				break;
			case "LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD" :
					var isDN_Info	= Base.CheckDiameter(strNumberFieldValue*1);
					if (isDN_Info.isDN){
						oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo		= isDN_Info.DN_norm;
						oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo	= isDN_Info.dA_norm;
						oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder = "";
						oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder = false;
						oDlgLagerSession.SollwerteRohrUmTeil.bMessage = true;
					}
					else if (strNumberFieldValue == ""){
						oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder = strNumberFieldValue;
						oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder = false;
						oDlgLagerSession.SollwerteRohrUmTeil.bMessage = false;
					}
					else{
						oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder = strNumberFieldValue;
						oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder = true;
						oDlgLagerSession.SollwerteRohrUmTeil.bMessage = false;
						oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo		= isDN_Info.DN_norm;
						oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo	= isDN_Info.dA_norm;
					}
				break;	
			case "LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD" :
					var isDM_Info	= Base.CheckDiameterMantel(strNumberFieldValue*1);
					if (isDM_Info.isDM_norm){
						oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo 	= isDM_Info.DM_norm;
						oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder		= false;
						oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder 		= "";
						oDlgLagerSession.SollwerteRohrUmTeil.bMessage = true;
					}
					else if (strNumberFieldValue == ""){
						oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder 		= strNumberFieldValue;
						oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder		= false;
						oDlgLagerSession.SollwerteRohrUmTeil.bMessage = false;
					}
					else{
						oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder 		= strNumberFieldValue;
						oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder		= true;
						//oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo 	= 'STD';
						oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo 	= isDM_Info.DM_norm;
						oDlgLagerSession.SollwerteRohrUmTeil.bMessage = false;
					}
				break;
			case "LAGER_IDC_SCHELLENEINLAGE" :	
					oDlgLagerSession.SollwerteRohrUmTeil.dSchelleneinlage = (strNumberFieldValue*1);
					if (!oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder)
						var istAussenDuMesser	= oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1;
					else
						var istAussenDuMesser	= oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder;
					
					var new_dA				= Base.buildSpecialExternalDiameter(oDlgLagerSession.SollwerteRohrUmTeil.dSchelleneinlage, istAussenDuMesser);
					var isDN_Info			= Base.CheckDiameter(new_dA*1);
					if (isDN_Info.isDN){
						oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo		= isDN_Info.DN_norm;
						oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo	= isDN_Info.dA_norm;
						oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder = "";
						oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder = false;
						oDlgLagerSession.SollwerteRohrUmTeil.bMessage = (strNumberFieldValue == "" ? false : true);
					}
					else{
						oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder = new_dA;
						oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder = true;
						oDlgLagerSession.SollwerteRohrUmTeil.bMessage = false;
					}
				break;
		}
		
		oResult = this._getDataObject(oDlgLagerSession,strNumberFieldId);
		
		return oResult;
	},
	
	_buildCombo: function(oDlgLagerSession,strComboBoxId,strComboBoxValue){
		var oResult = {}; //Bezeichnungen  siehe Controller.Lager.Common.getDataRohrumschliessendesTeil
		switch(strComboBoxId){
			case "LAGER_IDC_NENNWEITE" 			:
					oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo	= strComboBoxValue;
					var strD = Lager.RohrumschliessendesTeil.getSelectionAussendurchmesser(strComboBoxValue);
					oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo = strD;
				break;
			case "LAGER_IDC_AUSSENDURCHMESSER" 	:					
					oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo = strComboBoxValue;
					var strDN = Lager.RohrumschliessendesTeil.getSelectionNenndurchmesser(strComboBoxValue)
					oDlgLagerSession.SollwerteRohrUmTeil.strSelNennweiteCombo = strDN;
				break;
			case "LAGER_IDC_MANTELDURCHMESSER" 	:
					oDlgLagerSession.SollwerteRohrUmTeil.strSelMantelDuMesserCombo = strComboBoxValue;
					if((strComboBoxValue != 'STD') && oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder){
						oDlgLagerSession.SollwerteRohr8UmTeil.dMantelDuMesserSonder = 0;
						oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder = false;
					}
				break;
		}
		
		oResult = this._getDataObject(oDlgLagerSession,strComboBoxId);
		
		return oResult;
	},
	_buildCheck: function(oDlgLagerSession,strCheckBoxId,strCheckBoxValue){
		var oResult = {}; //Bezeichnungen  siehe Controller.Lager.Common.getDataRohrumschliessendesTeil
		switch(strCheckBoxId){
			case "LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX" 			:
					oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder = (strCheckBoxValue=='true' ? true  : false);
					if(!oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder){
						oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder 	= 0;
						oDlgLagerSession.SollwerteRohrUmTeil.dSchelleneinlage 		= 0;
					}
				break;
			case "LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX" 			:
					oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder = (strCheckBoxValue=='true' ? true  : false);
					if(!oDlgLagerSession.SollwerteRohrUmTeil.bMantelDuMesserSonder)
						oDlgLagerSession.SollwerteRohrUmTeil.dMantelDuMesserSonder = 0;						
				break;	
		}
		
		oResult = this._getDataObject(oDlgLagerSession,strCheckBoxId);		
		return oResult;
	}
});