LagerAuswahlStandardController = function() {
	LagerAuswahlStandardController.superclass.constructor.call(this);
};

EasyKat.extend(LagerAuswahlStandardController, CustomController, 
{
	getInitalValuesAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strSelection 	 = this._buildSelDialog(oDlgLagerSession);
		var oResult = Controller.Lager.Common.getDataAuswahlStandard(oDlgLagerSession,strSelection); 
		
		if(oDlgLagerSession.bLastKetteDialog){
			var oDataResult;
			var myData = Lager.getClientTable(oDlgLagerSession);
			
			if(myData.length == 0)
				oResult.resulttable.Error = translate("ERROR_KEIN_PRODUKT_GEFUNDEN");
			else
				oResult.resulttable.store = myData;
				
			oResult.resulttable.sel	= oDlgLagerSession.AuswahlStandard.strResultId;	
		}
		
		if(oDlgLagerSession.bLastKettePathSelection){
			if (getstring("IDC_LASTABTRAGUNG", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") != "STUETZEND_EINFACH"){
				// Prfen der gewhlten Spannweite zu DN / J, ggf. unter Bercksichtigung der Hnger
				var dA		= (oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder*1 == 1 ? oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder : oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo);
				var Daemm	= oDlgLagerSession.SollwerteRohrUmTeil.dDaemmDicke;
				var isSpecSpann	= toupper(getstring("IDC_SPANNWEITE_EINZEL_SONDER_CHECK", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE"));
				isSpecSpann		= isSpecSpann == "" ? false : true;
				var Spann		= isSpecSpann ? getstring("IDC_SPANNWEITE_EINZEL_SONDER", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE")*1 : getstring("SPANNWEITE", "DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE")*1;
				// TestSpannweite : function(b_aussendurchmesser, b_daemmdicke, b_spannweite, LGV, myHanger)
				var SPWTest = caMainController.TestSpannweite(dA, Daemm, Spann, caMainController.GetLGVfromLast(), caMainController.topologieKlasse.getCurrentHaenger());
				if (SPWTest.ErrorSpw){
					if (oResult.resulttable.Error)
						oResult.resulttable.Error	+= "<br>" + SPWTest.strMessage.replace("\n", "<br>");
					else
						oResult.resulttable.Error	= SPWTest.strMessage.replace("\n", "<br>");
					oResult.resulttable.Error	= trimright(oResult.resulttable.Error, "<br>");
				}
			}
		}
		
		echo oResult.toJSON(); 
	},
	getPopUpInitialAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var oResult = {};
		oResult.fieldset = {};
		oResult.fieldset.lager_sonderabmessungen = Controller.Lager.Common.AuswahlStandard.getFieldSetSpecial(oDlgLagerSession,"INITIAL_POPUP");
		echo oResult.toJSON(); 
	},
	setPOPUPApplyAction: function(){		
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.AuswahlStandard.bSonderAbMessung = true;
		var oResult = {};
		oDlgLagerSession.bLastKetteDialog = false;
		oResult.fieldset = {};
		oResult.fieldset.lager_sonderabmessungen = Controller.Lager.Common.AuswahlStandard.getFieldSetSpecial(oDlgLagerSession,"INITIAL_HAUPT");
		echo oResult.toJSON(); 
	},
	setPOPUPCloseAction: function(){
		//var oDlgCache		 = getDialogObjectSession("LAGERCACHE");
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		oDlgLagerSession.AuswahlStandard.bSonderAbMessung = false;
		oDlgLagerSession.bLastKetteDialog = false;
		var oResult = {};
		oResult.fieldset = {};
		oResult.fieldset.lager_sonderabmessungen = Controller.Lager.Common.AuswahlStandard.getFieldSetSpecial(oDlgLagerSession,"INITIAL_HAUPT");
		echo oResult.toJSON(); 
	},
	setNumberfieldSonderAction: function(){
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		var strNumberfieldId 	= HttpRequest.get("fieldid"); 	
		var dValue 		 		= HttpRequest.get("numberfieldvalue")*1;
		oDlgLagerSession.bLastKetteDialog = false;
		
		var oResult;
		strNumberfieldId = strNumberfieldId.replace("lager.auswahl_standard_sonder_","");
		strNumberfieldId = strNumberfieldId.replace("_Numberfield","");
		switch(strNumberfieldId){
			case "Q1_HOEHE" :
					oDlgLagerSession.AuswahlStandard.dHoehe1 = dValue;
					oDlgLagerSession.AuswahlStandard.dMass1 = Base.buildMountingDimension(dValue,oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					oResult = ['lager.auswahl_standard_sonder_Q1_EINBAUMASS_Numberfield',oDlgLagerSession.AuswahlStandard.dMass1];
				break;
			case "Q2_HOEHE" :
					oDlgLagerSession.AuswahlStandard.dHoehe2 = dValue;
					oDlgLagerSession.AuswahlStandard.dMass2 = Base.buildMountingDimension(dValue,oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					oResult = ['lager.auswahl_standard_sonder_Q2_EINBAUMASS_Numberfield',oDlgLagerSession.AuswahlStandard.dMass2];
				break;
			case "Q3_HOEHE" :
					oDlgLagerSession.AuswahlStandard.dHoehe3 = dValue;
					oDlgLagerSession.AuswahlStandard.dMass3 = Base.buildMountingDimension(dValue,oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					oResult = ['lager.auswahl_standard_sonder_Q3_EINBAUMASS_Numberfield',oDlgLagerSession.AuswahlStandard.dMass3];
				break;
			case "Q4_HOEHE" :
					oDlgLagerSession.AuswahlStandard.dHoehe4 = dValue;
					oDlgLagerSession.AuswahlStandard.dMass4 = Base.buildMountingDimension(dValue,oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					oResult = ['lager.auswahl_standard_sonder_Q4_EINBAUMASS_Numberfield',oDlgLagerSession.AuswahlStandard.dMass4];
				break;
			case "Q1_EINBAUMASS" :
					oDlgLagerSession.AuswahlStandard.dMass1 = dValue;
					oDlgLagerSession.AuswahlStandard.dHoehe1 = Base.buildHeight(dValue,oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					oResult = ['lager.auswahl_standard_sonder_Q1_HOEHE_Numberfield',oDlgLagerSession.AuswahlStandard.dHoehe1];
				break;
			case "Q2_EINBAUMASS" :
					oDlgLagerSession.AuswahlStandard.dMass2 = dValue;
					oDlgLagerSession.AuswahlStandard.dHoehe2 = Base.buildHeight(dValue,oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					oResult = ['lager.auswahl_standard_sonder_Q2_HOEHE_Numberfield',oDlgLagerSession.AuswahlStandard.dHoehe2];
				break;
			case "Q3_EINBAUMASS" :
					oDlgLagerSession.AuswahlStandard.dMass3 = dValue;
					oDlgLagerSession.AuswahlStandard.dHoehe3 = Base.buildHeight(dValue,oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					oResult = ['lager.auswahl_standard_sonder_Q3_HOEHE_Numberfield',oDlgLagerSession.AuswahlStandard.dHoehe3];
				break;
			case "Q4_EINBAUMASS" :
					oDlgLagerSession.AuswahlStandard.dMass4 = dValue;
					oDlgLagerSession.AuswahlStandard.dHoehe4 = Base.buildHeight(dValue,oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					oResult = ['lager.auswahl_standard_sonder_Q4_HOEHE_Numberfield',oDlgLagerSession.AuswahlStandard.dHoehe4];
				break;
			case "SONDER_LAGERLAENGE" :
					if ((dValue >= oDlgLagerSession.AuswahlStandard.dLaengeSonderMin) && (dValue <= oDlgLagerSession.AuswahlStandard.dLaengeSonderMax))
						oDlgLagerSession.AuswahlStandard.dLaengeSonder = dValue;
					oResult = ['lager.auswahl_standard_sonder_SONDER_LAGERLAENGE',oDlgLagerSession.AuswahlStandard.dLaengeSonder];
				break;
			case "SONDER_LAGERBREITE" :
					if ((dValue >= oDlgLagerSession.AuswahlStandard.dBreiteSonderMin) && (dValue <= oDlgLagerSession.AuswahlStandard.dBreiteSonderMax))
						oDlgLagerSession.AuswahlStandard.dBreiteSonder = dValue;
					oResult = ['lager.auswahl_standard_sonder_SONDER_LAGERBREITE',oDlgLagerSession.AuswahlStandard.dBreiteSonder];
				break;
		}	
		
		echo oResult.toJSON();
	},
	setNumberfieldAction : function(){
		var oDlgLagerSession		= getDialogObjectSession("LAGER");
		var strNumberFieldId		= HttpRequest.get("numberfieldid");
		var strNumberFieldValue		= HttpRequest.get("numberfieldvalue");
		var strNumberFieldValueOld	= HttpRequest.get("numberfieldvalueold");
		var oResult ={};
		oDlgLagerSession.bLastKetteDialog = false;
		switch(strNumberFieldId){
			case "LAGER_TRAEGER_HOEHE" :
					oDlgLagerSession.AuswahlStandard.dBeamHeight = strNumberFieldValue;
				break;
			case "LAGER_TRAEGER_BREITE" :
					//oDlgLagerSession.AuswahlStandard.dBeamWidth = strNumberFieldValue;
					
					// folgendes muss noch variabel "Expert" oder "NonExpert" gestaltet werden
					if (strNumberFieldValue*1 <= 310)
						oDlgLagerSession.AuswahlStandard.dBeamWidth = strNumberFieldValue;
					else{
						//oResult.responseText	= "ERROR";
						oResult	= [strNumberFieldId, strNumberFieldValueOld];
					}
				break;
			case "LAGER_TRAEGER_FLANSCHDICKE" :
					//oDlgLagerSession.AuswahlStandard.dBeamThickness = strNumberFieldValue;
					
					// folgendes muss noch variabel "Expert" oder "NonExpert" gestaltet werden
					if (strNumberFieldValue*1 <= 42 && strNumberFieldValue >= 7)
						oDlgLagerSession.AuswahlStandard.dBeamThickness = strNumberFieldValue;
					else{
						//oResult.responseText	= "ERROR";
						oResult	= [strNumberFieldId, strNumberFieldValueOld];
					}
				break;	
			case "LAGER_LAGERLAENGE_NUMBERFIELD" :
					oDlgLagerSession.AuswahlStandard.dLaenge = strNumberFieldValue;
				break;		
			case "LAGER_LAGERHOEHE_NUMBERFIELD" :
					oDlgLagerSession.AuswahlStandard.dHoehe1 = strNumberFieldValue;
				break;		
			case "LAGER_LAGERBAUMASS_NUMBERFIELD" :
					oDlgLagerSession.AuswahlStandard.dMass1 = strNumberFieldValue;
				break;
			case "LAGER_TATSAECHLICHE_HOEHE" :
					oDlgLagerSession.AuswahlStandard.dActualHeight 	= strNumberFieldValue;
					var dActualdA	= (oDlgLagerSession.SollwerteRohrUmTeil.bAussenDuMesserSonder ? oDlgLagerSession.SollwerteRohrUmTeil.dAussenDuMesserSonder*1 : oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1)
					oDlgLagerSession.AuswahlStandard.dActualMass 	= Base.buildMountingDimension(strNumberFieldValue*1,dActualdA);
					oResult = ['LAGER_TATSAECHLICHE_EINBAUMASS',formatstring(oDlgLagerSession.AuswahlStandard.dActualMass,"%.0f")];
				break;	
			case "LAGER_TATSAECHLICHE_HOEHE_BEREICH" :
					oDlgLagerSession.AuswahlStandard.strActualHeightRange	= strNumberFieldValue;
				break;
			case "LAGER_TATSAECHLICHE_EINBAUMASS":
					oDlgLagerSession.AuswahlStandard.dActualMass = strNumberFieldValue;
					oDlgLagerSession.AuswahlStandard.dActualHeight 	= Base.buildHeight(strNumberFieldValue*1,oDlgLagerSession.SollwerteRohrUmTeil.strSelAussenDuMesserCombo*1);
					oResult = ['LAGER_TATSAECHLICHE_HOEHE', formatstring(oDlgLagerSession.AuswahlStandard.dActualHeight,"%.0f")];
				break;
			case "LAGER_TATSAECHLICHE_EINBAUMASS_BEREICH":
					oDlgLagerSession.AuswahlStandard.strActualMassRange	= strNumberFieldValue;					
				break;
		}
		
		
		echo oResult.toJSON();
	},
	setComboBoxSonderAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strComboBoxId 	 = HttpRequest.get("comboboxid"); 	
		var strComboBoxValue = HttpRequest.get("comboboxvalue");	
		var oResult = {};
		
		oDlgLagerSession.bLastKetteDialog = false;
		strComboBoxId = strComboBoxId.replace("lager.auswahl_standard_sonder_","");
		switch(strComboBoxId){
			case "LAGERLAENGE"	 :
					oDlgLagerSession.AuswahlStandard.dLaenge = strComboBoxValue;
					if (strComboBoxValue == "-")
						oResult = false;
					else
						oResult = ['lager.auswahl_standard_sonder_SONDER_LAGERLAENGE',strComboBoxValue];
				break;
			case "LAGERBREITE"	 :
					oDlgLagerSession.AuswahlStandard.dBreite = strComboBoxValue;
					if (strComboBoxValue == "-")
						oResult = false;
					else
						oResult = ['lager.auswahl_standard_sonder_SONDER_LAGERBREITE',strComboBoxValue];
				break;
		}
		
		echo oResult.toJSON();
	},
	
	setComboBoxAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strComboBoxId 	 = HttpRequest.get("comboboxid"); 	
		var strComboBoxValue = HttpRequest.get("comboboxvalue");	
		var oResult = {};
		
		oDlgLagerSession.bLastKetteDialog = false;
		switch(strComboBoxId){
			case "LAGER_GEFUEHRT_MEHRFACH" :
					oDlgLagerSession.AuswahlStandard.strSelComboFunction = strComboBoxValue;
					oResult = Controller.Lager.Common.getDataAuswahlStandard(oDlgLagerSession,"FIELDSET_MERKMALE",strComboBoxId); 
				break;
			case "LAGER_TRAEGER_ART" :
					oDlgLagerSession.AuswahlStandard.strSelComboBeamArt = strComboBoxValue;
					var oBeam = Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,strComboBoxId);
					oResult.fieldset = {};
					oResult.fieldset.lager_sonderabmessungen 	= {};
					oResult.fieldset.lager_traeger 				= {};
					oResult.fieldset.lager_traeger = oBeam;
				break;
			case "LAGER_TRAEGER_GROESSE" :
					oDlgLagerSession.AuswahlStandard.strSelComboBeamSize = strComboBoxValue;
					var oBeam = Controller.Lager.Common.AuswahlStandard.getFieldSetBeam(oDlgLagerSession,strComboBoxId);
					oResult.fieldset = {};
					oResult.fieldset.lager_sonderabmessungen 	= {};
					oResult.fieldset.lager_traeger 				= {};
					oResult.fieldset.lager_traeger = oBeam;
				break;			
			case "LAGER_MERKMALE_GLEITELEMENT" :
					oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart = strComboBoxValue;					
					// @@@ LGE Test
					// Unterscheidung LGA/LGV und LGE --> OHNE???
					if (strComboBoxValue == "LGE"){
						oResult = {
							'fieldset' :{
								'lager_function' : {
									'show'		: true,
									'diable' 	: {								
										'radio' : {
											'vGEFUEHRT' : Controller.Lager.Common.AuswahlStandard.getGleitelement(oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart);
										}
									}
								}
							}
						}
					}
					else {
						oResult = {
							'fieldset' :{
								'lager_function' : {
									'show'		: true,
									'disable' 	: {								
										'radio' : {
											'vGEFUEHRT' : Controller.Lager.Common.AuswahlStandard.getGleitelement(oDlgLagerSession.AuswahlStandard.strSelComboSlidingPart);
										}
									}
								}
							}
						}
					}
				break;
			case "LAGER_MERKMALE_ACCESSORY" :
					oDlgLagerSession.AuswahlStandard.strSelComboAccessory = strComboBoxValue;
					oResult = Controller.Lager.Common.getDataAuswahlStandard(oDlgLagerSession,"FIELDSET_MERKMALE",strComboBoxId);
				break;
			case "LAGER_MERKMALE_OBERFLAECHE" :
					oDlgLagerSession.AuswahlStandard.strSelComboGroundLevel = strComboBoxValue;
					//oResult = Controller.Lager.Common.getDataAuswahlStandard(oDlgLagerSession,"FIELDSET_MERKMALE","MERKMALE"); 
				break;	
		}
		
		
		echo oResult.toJSON();
	},
	setCheckBoxAction: function(){
		var oDlgLagerSession 	= getDialogObjectSession("LAGER");
		var strCheckBoxId 	 	= HttpRequest.get("checkboxid"); 	
		var strCheckBoxValue 	= HttpRequest.get("checkboxvalue");	
		var oResult 			= {};
		
		if(	strCheckBoxId !== "LAGER_SONDERABMESSUNGEN")
			oDlgLagerSession.bLastKetteDialog = false;
		
		switch(strCheckBoxId){
			case "Q1" 	:
					if(strCheckBoxValue=="HOEHE")
						oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe1 = true;
					else
						oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe1 = false;
				break;
			case "Q2"	:
					if(strCheckBoxValue=="HOEHE")
						oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe2 = true;
					else
						oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe2 = false;
				break;
			case "Q3"	:
					if(strCheckBoxValue=="HOEHE")
						oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe3 = true;
					else
						oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe3 = false;
				break;
			case "Q4"	:
					if(strCheckBoxValue=="HOEHE")
						oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe4 = true;
					else
						oDlgLagerSession.AuswahlStandard.bSonderAbMessung_Hoehe4 = false;
				break;
			case "LAGER_SONDERABMESSUNGEN" :
						oDlgLagerSession.AuswahlStandard.bSonderAbMessung = (strCheckBoxValue == 'true' || strCheckBoxValue == true) ? true : false;
				break;
			case "LAGE_MERKMALE_GAT" :
					oDlgLagerSession.AuswahlStandard.bGaT = (strCheckBoxValue == 'true' || strCheckBoxValue == true) ? true : false;
					oResult = Controller.Lager.Common.getDataAuswahlStandard(oDlgLagerSession,"FIELDSET_MERKMALE","MERKMALE");
				break;
			case "LAGE_MERKMALE_HOEHENVERSTELLBAR" :
					oDlgLagerSession.AuswahlStandard.bHoehenverstellbar = (strCheckBoxValue == 'true' || strCheckBoxValue == true) ? true : false ;
					oResult = Controller.Lager.Common.getDataAuswahlStandard(oDlgLagerSession,"FIELDSET_MERKMALE","MERKMALE");
				break;			
		}		
		
		echo oResult.toJSON();
	},
	setRadioAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		var strRadioId 	 	= HttpRequest.get("radiogroup"); 	
		var strRadioValue 	= HttpRequest.get("radiovalue");	
		oDlgLagerSession.bLastKetteDialog = false;
		
		var oResult = {};
		oResult.fieldset = {};
		switch(strRadioId){
			case "LAGER_FUNCTION" :					
					oDlgLagerSession.AuswahlStandard.strSelRadioFunction = strRadioValue;
					var strRadioSelection = oDlgLagerSession.AuswahlStandard.strSelRadioFunction;
					var strComboSelection = oDlgLagerSession.AuswahlStandard.strSelComboFunction;
					var strSelection 	  = this._buildSelDialog(oDlgLagerSession);
					
					oResult = Controller.Lager.Common.getDataAuswahlStandard(oDlgLagerSession,"FIELDSET_FUNCTION_MERKMALE");
				break;	
			case "LAGER_BB"	:
					oDlgLagerSession.AuswahlStandard.strSelRadioFixed = strRadioValue;					
					//var oFixed = Controller.Lager.Common.AuswahlStandard.getFieldSetFixed(oDlgLagerSession);
					//oResult.fieldset.lager_bb = oFixed;	
					oResult = Controller.Lager.Common.getDataAuswahlStandard(oDlgLagerSession,"FIELDSET_FIXED","FIXED");
				break;
			case "LAGER_BB_SCHRAUBBAR" :
					oDlgLagerSession.AuswahlStandard.strSelRadioFixedScrewOn = strRadioValue;					
				break;
		}	
		
		//oResult.fieldset.lager_sonderabmessungen 	= Controller.Lager.Common.AuswahlStandard.getFieldSetSpecial(oDlgLagerSession,"INITIAL_HAUPT"); 
		
		echo oResult.toJSON();
	},
		
	/**
	 * set selection value - 
	 * strTableSelection = TABEL ROW ID <-- Wert ist eindeutig
	 */
	setTableSelAction: function(){
		var oDlgLagerSession	= getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		var strTableSelection 	= HttpRequest.get("selection");
		if(strTableSelection == '-')
			this._cleanUp();
		else{
			oDlgLagerSession.AuswahlStandard.strResultId = strTableSelection;
			oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager = {};
			oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager = getDataFromLagerCacheObject('AuswahlStandard','TABLE',strTableSelection);
			var AchsDirInfo	= caMainController.dataAccess.getAchsKSInfo();
			AchsDirInfo		= AchsDirInfo[9].split("_");
			
			//Abhebesicherung
			var oAbhebesicherung = getDataFromLagerCacheObject('AuswahlAbhebesicherung','TABLE',strTableSelection);
			if(oAbhebesicherung){
				oDlgLagerSession.AuswahlStandard.oSearchResult.oResultAbhebesicherung = {};
				oDlgLagerSession.AuswahlStandard.oSearchResult.oResultAbhebesicherung = oAbhebesicherung;
			}
			
			//Gleitelement
			var oGleitelement = getDataFromLagerCacheObject('AuswahlGleitelement','TABLE',strTableSelection);
			if(oGleitelement){
				oDlgLagerSession.AuswahlStandard.oSearchResult.oResultGleitelement = {};
				oDlgLagerSession.AuswahlStandard.oSearchResult.oResultGleitelement = oGleitelement;
			}
		}
		
		var oResult = {
			'success' : true,
			'image'		: AchsDirInfo[1] + "_" + oDlgLagerSession.AuswahlStandard.oSearchResult.oResultLager.BAUFO
		};
		echo oResult.toJSON();
		
	},
	getButtonAction: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.bLastKetteDialog = false;
		caMainController.getLagerTopologieklasse().setEmptyProduct();
		this._cleanUp();
		
		var storeData, strError;
		var oResult 				= {};
		oResult.resulttable 		= {};
		
		var oDataResult = Lager.Search.getSearchResult(oDlgLagerSession,'lager.auswahl-standard');
		
		if(oDataResult.Error)
			oResult.resulttable.Error = oDataResult.Error;
		
		if(oDataResult.aTableData)
			oResult.resulttable.store = oDataResult.aTableData;
		
		echo oResult.toJSON();
	},
	setValuesAction : function(){ 
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		/**
		 * ACHTUNG fr Sonderabmessung gibt es einen seperaten Dialog
		 * - die Initialisierung / Datenverarbeitung luft zwar noch hier ab, aber das eigentliche bernehmen der Daten in
		 * das Objekt oSearchResult geschieht jedoch im andern Contoller (Client bedingt)
		 */
		 
		 
		// Gleitlager, Festlager ... erzeugen und in der Topologie ablegen
		// -------------------   -mw- Test:
		//if(!oDlgLagerSession.AuswahlStandard.bSonderAbMessung){
			var x = caMainController;
			var oDlgLager = caMainController.getLagerTopologieklasse().getDlgLagerSession();
			caMainController.getLagerTopologieklasse().setGleitFestLager(oDlgLager);
		//}
		
		/*
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		
		var strTest = '';
		for (var prop in oDlgLagerSession.SollwerteRohrUmTeil) {
			strTest += prop + ' -> ' + typeof oDlgLagerSession.SollwerteRohrUmTeil[prop] + '\n\r';
		}
		oDlgLagerSession.toStorage("DLGDATA.CA.FORMS.LAGER2DATA", false);   // kein merge
		var storeTest = Object.fromStorage( "DLGDATA.CA.FORMS.LAGER2DATA" );
		var strTest2 = '';
		for (var prop in storeTest.SollwerteRohrUmTeil) {
			strTest2 += prop + ' -> ' + typeof oDlgLagerSession.SollwerteRohrUmTeil[prop] + '\n\r';
		}
		
		var y = oDlgLagerSession.AuswahlStandard.oSearchResult;
		*/
		
	},
	_cleanUp: function(){
		var oDlgLagerSession = getDialogObjectSession("LAGER");
		oDlgLagerSession.AuswahlStandard.strResultId 	= '';
		oDlgLagerSession.AuswahlStandard.oSearchResult 	= {};
		setDataIntoLagerCacheObject('AuswahlStandard','TABLE');
		setDataIntoLagerCacheObject('AuswahlAbhebesicherung','TABLE'); 		//Stahl/Stahl gleitend - gefuehrt
		setDataIntoLagerCacheObject('AuswahlKlemmsystem','TEMP_TABLE');
		setDataIntoLagerCacheObject('AuswahlGleitelement','TABLE');			//Edelstahl / PTFE gleitend - lose
	},
	_buildSelDialog: function(oDlgLagerSession){
		//"LAGERSCHLITTEN" / "FESTPUNKT_STOP_W" / "FESTPUNKT_STOP_U" / "FESTPUNKT_STOP_V"
		if(oDlgLagerSession.Systemcharakteristik.strSelRadioLager == "LAGER_FS"){
			oDlgLagerSession.AuswahlStandard.strDialogId = "FESTPUNKT_STOP_W";
		}
		else
			oDlgLagerSession.AuswahlStandard.strDialogId = "LAGERSCHLITTEN";
		
		return (oDlgLagerSession.AuswahlStandard.strDialogId);
	}
});